/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.export.sections;

import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.features.peptideshaker.PsSpectrumCountingFeature;
import com.compomics.util.parameters.quantification.spectrum_counting.SpectrumCountingParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;

public class PsSpectrumCountingSection {
    private final EnumSet<PsSpectrumCountingFeature> spectrumCountingFeatures;
    private final boolean indexes;
    private final boolean header;
    private final ExportWriter writer;

    public PsSpectrumCountingSection(ArrayList<ExportFeature> exportFeatures, boolean indexes, boolean header, ExportWriter writer) {
        this.indexes = indexes;
        this.header = header;
        this.writer = writer;
        this.spectrumCountingFeatures = EnumSet.noneOf(PsSpectrumCountingFeature.class);
        for (ExportFeature exportFeature : exportFeatures) {
            if (exportFeature instanceof PsSpectrumCountingFeature) {
                this.spectrumCountingFeatures.add((PsSpectrumCountingFeature)exportFeature);
                continue;
            }
            throw new IllegalArgumentException("Impossible to export " + exportFeature.getClass().getName() + " as spectrum counting feature.");
        }
    }

    public void writeSection(SpectrumCountingParameters spectrumCountingPreferences, WaitingHandler waitingHandler) throws IOException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        if (this.header) {
            if (this.indexes) {
                this.writer.writeHeaderText("");
                this.writer.addSeparator();
            }
            this.writer.writeHeaderText("Parameter");
            this.writer.addSeparator();
            this.writer.writeHeaderText("Value");
            this.writer.newLine();
        }
        int line = 1;
        for (PsSpectrumCountingFeature spectrumCountingFeature : this.spectrumCountingFeatures) {
            if (this.indexes) {
                this.writer.write(Integer.toString(line));
                this.writer.addSeparator();
            }
            this.writer.write(spectrumCountingFeature.getTitle());
            this.writer.addSeparator();
            block0 : switch (spectrumCountingFeature) {
                case method: {
                    switch (spectrumCountingPreferences.getSelectedMethod()) {
                        case EMPAI: {
                            this.writer.write("emPAI");
                            break block0;
                        }
                        case NSAF: {
                            this.writer.write("NSAF");
                            break block0;
                        }
                    }
                    this.writer.write("unknown");
                    break;
                }
                case validated: {
                    this.writer.write(MatchValidationLevel.getMatchValidationLevel((int)spectrumCountingPreferences.getMatchValidationLevel()).getName());
                    break;
                }
                default: {
                    this.writer.write("Not implemented");
                }
            }
            this.writer.newLine();
            ++line;
        }
    }
}

