/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.fileimport;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationProvider;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.filtering.PeptideAssumptionFilter;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.modification.search_engine_mapping.ModificationLocalizationMapper;
import com.compomics.util.experiment.identification.protein_inference.FastaMapper;
import com.compomics.util.experiment.identification.protein_inference.PeptideProteinMapping;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.identification.validation.percolator.PercolatorFeature;
import com.compomics.util.experiment.identification.validation.percolator.PercolatorFeaturesCache;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.tools.ProcessingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.fileimport.PsmImporter;
import eu.isas.peptideshaker.utils.PercolatorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.IntStream;

public class PsmImportRunnable
implements Runnable {
    public static final int BATCH_SIZE = 100000;
    private final ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private final ConcurrentLinkedQueue<SpectrumMatch> spectrumMatchQueue;
    private final HashMap<Long, Object> matchesToAdd = new HashMap(100000);
    private long nPSMs = 0L;
    private long nPeptideAssumptionsTotal = 0L;
    private int peptideIssue = 0;
    private int modificationIssue = 0;
    private final IdfileReader fileReader;
    private final HashMap<String, Integer> proteinCount = new HashMap(10000);
    private final Identification identification;
    private final IdentificationParameters identificationParameters;
    private final ProcessingParameters processingParameters;
    private final SequenceProvider sequenceProvider;
    private final FastaMapper fastaMapper;
    private final WaitingHandler waitingHandler;
    private final ExceptionHandler exceptionHandler;

    public PsmImportRunnable(ConcurrentLinkedQueue<SpectrumMatch> spectrumMatchQueue, IdentificationParameters identificationParameters, ProcessingParameters processingParameters, IdfileReader fileReader, Identification identification, SequenceProvider sequenceProvider, FastaMapper fastaMapper, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) {
        this.spectrumMatchQueue = spectrumMatchQueue;
        this.identificationParameters = identificationParameters;
        this.processingParameters = processingParameters;
        this.fileReader = fileReader;
        this.identification = identification;
        this.sequenceProvider = sequenceProvider;
        this.fastaMapper = fastaMapper;
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void run() {
        try {
            SpectrumMatch spectrumMatch;
            while ((spectrumMatch = this.spectrumMatchQueue.poll()) != null) {
                this.importPsm(spectrumMatch);
                if (this.waitingHandler.isRunCanceled()) {
                    return;
                }
                this.waitingHandler.increaseSecondaryProgressCounter();
            }
            if (!this.matchesToAdd.isEmpty()) {
                this.identification.addSpectrumMatches(this.matchesToAdd, this.waitingHandler, false);
            }
        }
        catch (Exception e) {
            this.waitingHandler.setRunCanceled();
            this.exceptionHandler.catchException(e);
        }
    }

    private void importPsm(SpectrumMatch spectrumMatch) {
        ++this.nPSMs;
        this.importAssumptions(spectrumMatch);
        if (spectrumMatch.hasPeptideAssumption() || spectrumMatch.hasTagAssumption()) {
            long spectrumMatchKey = spectrumMatch.getKey();
            SpectrumMatch dbMatch = this.identification.getSpectrumMatch(spectrumMatchKey);
            if (dbMatch != null) {
                this.mergePeptideAssumptions(spectrumMatch.getPeptideAssumptionsMap(), dbMatch.getPeptideAssumptionsMap());
                this.mergeTagAssumptions(spectrumMatch.getTagAssumptionsMap(), dbMatch.getTagAssumptionsMap());
            } else {
                this.matchesToAdd.put(spectrumMatch.getKey(), spectrumMatch);
                if (this.matchesToAdd.size() == 100000) {
                    this.identification.addSpectrumMatches(this.matchesToAdd, this.waitingHandler, false);
                    this.matchesToAdd.clear();
                }
            }
        }
    }

    private void mergeTagAssumptions(HashMap<Integer, TreeMap<Double, ArrayList<TagAssumption>>> matchAssumptions, HashMap<Integer, TreeMap<Double, ArrayList<TagAssumption>>> combinedAssumptions) {
        for (Map.Entry<Integer, TreeMap<Double, ArrayList<TagAssumption>>> entry : matchAssumptions.entrySet()) {
            int algorithm = entry.getKey();
            TreeMap<Double, ArrayList<TagAssumption>> algorithmMap = entry.getValue();
            TreeMap<Double, ArrayList<TagAssumption>> combinedAlgorithmMap = combinedAssumptions.get(algorithm);
            if (combinedAlgorithmMap == null) {
                combinedAssumptions.put(algorithm, algorithmMap);
                continue;
            }
            for (Map.Entry<Double, ArrayList<TagAssumption>> entry2 : algorithmMap.entrySet()) {
                double score = entry2.getKey();
                ArrayList<TagAssumption> scoreAssumptions = entry2.getValue();
                ArrayList<TagAssumption> combinedScoreAssumptions = combinedAlgorithmMap.get(score);
                if (combinedScoreAssumptions == null) {
                    combinedAlgorithmMap.put(score, scoreAssumptions);
                    continue;
                }
                combinedScoreAssumptions.addAll(scoreAssumptions);
            }
        }
    }

    private void mergePeptideAssumptions(HashMap<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> matchAssumptions, HashMap<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> combinedAssumptions) {
        for (Map.Entry<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> entry : matchAssumptions.entrySet()) {
            int algorithm = entry.getKey();
            TreeMap<Double, ArrayList<PeptideAssumption>> algorithmMap = entry.getValue();
            TreeMap<Double, ArrayList<PeptideAssumption>> combinedAlgorithmMap = combinedAssumptions.get(algorithm);
            if (combinedAlgorithmMap == null) {
                combinedAssumptions.put(algorithm, algorithmMap);
                continue;
            }
            for (Map.Entry<Double, ArrayList<PeptideAssumption>> entry2 : algorithmMap.entrySet()) {
                double score = entry2.getKey();
                ArrayList<PeptideAssumption> scoreAssumptions = entry2.getValue();
                ArrayList<PeptideAssumption> combinedScoreAssumptions = combinedAlgorithmMap.get(score);
                if (combinedScoreAssumptions == null) {
                    combinedAlgorithmMap.put(score, scoreAssumptions);
                    continue;
                }
                combinedScoreAssumptions.addAll(scoreAssumptions);
            }
        }
    }

    private void importAssumptions(SpectrumMatch spectrumMatch) {
        PeptideAssumptionFilter peptideAssumptionFilter = this.identificationParameters.getPeptideAssumptionFilter();
        SequenceMatchingParameters sequenceMatchingParameters = this.identificationParameters.getSequenceMatchingParameters();
        SequenceMatchingParameters modificationSequenceMatchingParameters = this.identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        HashMap peptideAssumptions = spectrumMatch.getPeptideAssumptionsMap();
        for (Map.Entry entry : peptideAssumptions.entrySet()) {
            int advocateId = (Integer)entry.getKey();
            if (advocateId == Advocate.xtandem.getIndex()) {
                PsmImporter.verifyXTandemModifications(this.identificationParameters);
            }
            TreeMap assumptionsForAdvocate = (TreeMap)entry.getValue();
            TreeSet scores = new TreeSet(assumptionsForAdvocate.keySet());
            Iterator iterator = scores.iterator();
            while (iterator.hasNext()) {
                double score = (Double)iterator.next();
                ArrayList oldAssumptions = (ArrayList)assumptionsForAdvocate.get(score);
                ArrayList<PeptideAssumption> newAssumptions = new ArrayList<PeptideAssumption>(oldAssumptions.size());
                this.nPeptideAssumptionsTotal += (long)oldAssumptions.size();
                for (PeptideAssumption peptideAssumption : oldAssumptions) {
                    Peptide peptide = peptideAssumption.getPeptide();
                    String peptideSequence = peptide.getSequence();
                    if (peptideSequence.length() >= peptideAssumptionFilter.getMinPepLength() && peptideSequence.length() <= peptideAssumptionFilter.getMaxPepLength()) {
                        this.proteinMapping(peptide);
                        if (peptide.getVariableModifications().length > 0) {
                            try {
                                ModificationLocalizationMapper.modificationLocalization((Peptide)peptide, (IdentificationParameters)this.identificationParameters, (IdfileReader)this.fileReader, (ModificationProvider)this.modificationFactory, (SequenceProvider)this.sequenceProvider);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (peptideAssumptionFilter.validateModifications(peptide, sequenceMatchingParameters, modificationSequenceMatchingParameters, searchParameters.getModificationParameters())) {
                            peptide.setKey(Peptide.getKey((String)peptide.getSequence(), (ModificationMatch[])peptide.getVariableModifications()));
                            ModificationParameters modificationParameters = searchParameters.getModificationParameters();
                            peptide.getMass(modificationParameters, this.sequenceProvider, modificationSequenceMatchingParameters);
                            newAssumptions.add(peptideAssumption);
                            for (String protein : peptide.getProteinMapping().navigableKeySet()) {
                                Integer count = this.proteinCount.get(protein);
                                if (count != null) {
                                    this.proteinCount.put(protein, count + 1);
                                    continue;
                                }
                                this.proteinCount.put(protein, 1);
                            }
                            if (!this.processingParameters.cachePercolatorFeatures()) continue;
                            PercolatorFeaturesCache percolatorFeaturesCache = (PercolatorFeaturesCache)peptideAssumption.getUrParam((UrParameter)PercolatorFeaturesCache.dummy);
                            if (percolatorFeaturesCache == null) {
                                percolatorFeaturesCache = new PercolatorFeaturesCache();
                                peptideAssumption.addUrParam((UrParameter)percolatorFeaturesCache);
                            }
                            boolean[] enzymaticity = PercolatorUtils.getEnzymaticityFeature(peptideAssumption, searchParameters, this.sequenceProvider);
                            percolatorFeaturesCache.cache.put(PercolatorFeature.enzymaticity, enzymaticity);
                            continue;
                        }
                        ++this.modificationIssue;
                        continue;
                    }
                    ++this.peptideIssue;
                }
                if (!newAssumptions.isEmpty()) {
                    assumptionsForAdvocate.put(score, newAssumptions);
                    continue;
                }
                assumptionsForAdvocate.remove(score);
            }
        }
    }

    private void proteinMapping(Peptide peptide) {
        TreeMap<String, int[]> proteinIndexes;
        SequenceMatchingParameters sequenceMatchingPreferences = this.identificationParameters.getSequenceMatchingParameters();
        ArrayList peptideProteinMappings = this.fastaMapper.getProteinMapping(peptide.getSequence(), sequenceMatchingPreferences);
        HashMap sequenceIndexes = PeptideProteinMapping.getPeptideProteinIndexesMap((ArrayList)peptideProteinMappings);
        if (sequenceIndexes.size() == 1) {
            proteinIndexes = new TreeMap((Map)sequenceIndexes.values().stream().findAny().get());
        } else {
            proteinIndexes = new TreeMap<String, int[]>();
            for (HashMap tempIndexes : sequenceIndexes.values()) {
                for (Map.Entry entry : tempIndexes.entrySet()) {
                    String accession = (String)entry.getKey();
                    int[] newIndexes = (int[])entry.getValue();
                    int[] currentIndexes = (int[])proteinIndexes.get(accession);
                    if (currentIndexes == null) {
                        proteinIndexes.put(accession, newIndexes);
                        continue;
                    }
                    int[] mergedIndexes = IntStream.concat(Arrays.stream(currentIndexes), Arrays.stream(newIndexes)).distinct().sorted().toArray();
                    proteinIndexes.put(accession, mergedIndexes);
                }
            }
        }
        peptide.setProteinMapping(proteinIndexes);
        HashMap variantMatches = PeptideProteinMapping.getVariantMatches((ArrayList)peptideProteinMappings);
        peptide.setVariantMatches(variantMatches);
    }

    public long getnPSMs() {
        return this.nPSMs;
    }

    public long getnPeptideAssumptionsTotal() {
        return this.nPeptideAssumptionsTotal;
    }

    public int getPeptideIssue() {
        return this.peptideIssue;
    }

    public int getModificationIssue() {
        return this.modificationIssue;
    }

    public HashMap<String, Integer> getProteinCount() {
        return this.proteinCount;
    }
}

