/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.fileimport;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.protein_inference.FastaMapper;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.XtandemParameters;
import com.compomics.util.parameters.tools.ProcessingParameters;
import com.compomics.util.threading.SimpleSemaphore;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.fileimport.PsmFirstHitRunnable;
import eu.isas.peptideshaker.fileimport.PsmImportRunnable;
import eu.isas.peptideshaker.scoring.maps.InputMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PsmImporter {
    private static boolean xTandemModsCheck = false;
    private static final SimpleSemaphore XTANDEM_MODS_CHECK_MUTEX = new SimpleSemaphore(1);
    private long nPSMs = 0L;
    private long nPeptideAssumptionsTotal = 0L;
    private int progress = 0;
    private int psmsRejected = 0;
    private int proteinIssue = 0;
    private int peptideIssue = 0;
    private int precursorIssue = 0;
    private int modificationIssue = 0;
    private int nRetained = 0;
    private int missingProteins = 0;
    private double maxPeptideErrorPpm = 0.0;
    private double maxPeptideErrorDa = 0.0;
    private double maxTagErrorPpm = 0.0;
    private double maxTagErrorDa = 0.0;
    private final HashSet<Integer> charges = new HashSet();
    private HashMap<String, Integer> proteinCount = new HashMap(10000);

    public void importPsms(ArrayList<SpectrumMatch> spectrumMatches, Identification identification, IdentificationParameters identificationParameters, InputMap inputMap, IdfileReader fileReader, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, FastaMapper fastaMapper, ProcessingParameters processingParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) throws InterruptedException, TimeoutException {
        int nThreads = processingParameters.getnThreads();
        ConcurrentLinkedQueue<SpectrumMatch> spectrumMatchQueue = new ConcurrentLinkedQueue<SpectrumMatch>(spectrumMatches);
        ExecutorService importPool = Executors.newFixedThreadPool(nThreads);
        ArrayList<PsmImportRunnable> importRunnables = new ArrayList<PsmImportRunnable>(nThreads);
        for (int i = 0; i < nThreads; ++i) {
            importRunnables.add(new PsmImportRunnable(spectrumMatchQueue, identificationParameters, processingParameters, fileReader, identification, sequenceProvider, fastaMapper, waitingHandler, exceptionHandler));
        }
        importRunnables.forEach(worker -> importPool.submit((Runnable)worker));
        importPool.shutdown();
        if (!importPool.awaitTermination(365L, TimeUnit.DAYS)) {
            throw new TimeoutException("Analysis timed out (time out: 365 days)");
        }
        for (PsmImportRunnable runnable : importRunnables) {
            this.nPSMs += runnable.getnPSMs();
            this.nPeptideAssumptionsTotal += runnable.getnPeptideAssumptionsTotal();
            this.peptideIssue += runnable.getPeptideIssue();
            this.modificationIssue += runnable.getModificationIssue();
            for (Map.Entry<String, Integer> entry : runnable.getProteinCount().entrySet()) {
                String accession = entry.getKey();
                int threadCount = entry.getValue();
                Integer count = this.proteinCount.get(accession);
                if (count != null) {
                    this.proteinCount.put(accession, count + threadCount);
                    continue;
                }
                this.proteinCount.put(accession, threadCount);
            }
        }
        spectrumMatchQueue = new ConcurrentLinkedQueue<SpectrumMatch>(spectrumMatches);
        ExecutorService firstHitPool = Executors.newFixedThreadPool(nThreads);
        ArrayList<PsmFirstHitRunnable> firstHitRunnables = new ArrayList<PsmFirstHitRunnable>(nThreads);
        for (int i = 0; i < nThreads; ++i) {
            firstHitRunnables.add(new PsmFirstHitRunnable(spectrumMatchQueue, identificationParameters, sequenceProvider, spectrumProvider, inputMap, this.proteinCount, waitingHandler, exceptionHandler));
        }
        firstHitRunnables.forEach(worker -> firstHitPool.submit((Runnable)worker));
        firstHitPool.shutdown();
        if (!firstHitPool.awaitTermination(365L, TimeUnit.DAYS)) {
            throw new TimeoutException("Analysis timed out (time out: 365 days)");
        }
        for (PsmFirstHitRunnable runnable : firstHitRunnables) {
            this.psmsRejected += runnable.getPsmsRejected();
            this.proteinIssue += runnable.getProteinIssue();
            this.peptideIssue += runnable.getPeptideIssue();
            this.precursorIssue += runnable.getPrecursorIssue();
            this.nRetained += runnable.getnRetained();
            this.missingProteins += runnable.getMissingProteins();
            this.maxPeptideErrorPpm = Math.max(this.maxPeptideErrorPpm, runnable.getMaxPeptideErrorPpm());
            this.maxPeptideErrorDa = Math.max(this.maxPeptideErrorDa, runnable.getMaxPeptideErrorDa());
            this.maxTagErrorPpm = Math.max(this.maxTagErrorPpm, runnable.getMaxPeptideErrorPpm());
            this.maxTagErrorDa = Math.max(this.maxTagErrorDa, runnable.getMaxPeptideErrorDa());
            this.charges.addAll(runnable.getCharges());
        }
    }

    public static void verifyXTandemModifications(IdentificationParameters identificationParameters) {
        if (!xTandemModsCheck) {
            XTANDEM_MODS_CHECK_MUTEX.acquire();
            if (!xTandemModsCheck) {
                SearchParameters searchParameters = identificationParameters.getSearchParameters();
                ModificationParameters modificationProfile = searchParameters.getModificationParameters();
                IdentificationAlgorithmParameter algorithmParameter = searchParameters.getIdentificationAlgorithmParameter(Advocate.xtandem.getIndex());
                if (algorithmParameter != null) {
                    XtandemParameters xtandemParameters = (XtandemParameters)algorithmParameter;
                    if (xtandemParameters.isProteinQuickAcetyl() && !modificationProfile.contains("Acetylation of protein N-term")) {
                        Modification modification = ModificationFactory.getInstance().getModification("Acetylation of protein N-term");
                        if (!modificationProfile.getRefinementVariableModifications().contains(modification.getName())) {
                            modificationProfile.addRefinementVariableModification(modification);
                        }
                    }
                    String[] pyroMods = new String[]{"Pyrolidone from E", "Pyrolidone from Q", "Pyrolidone from carbamidomethylated C"};
                    if (xtandemParameters.isQuickPyrolidone()) {
                        for (String modName : pyroMods) {
                            if (modificationProfile.getRefinementVariableModifications().contains(modName)) continue;
                            Modification modification = ModificationFactory.getInstance().getModification(modName);
                            modificationProfile.addRefinementVariableModification(modification);
                        }
                    }
                }
                xTandemModsCheck = true;
            }
            XTANDEM_MODS_CHECK_MUTEX.release();
        }
    }

    public long getnPSMs() {
        return this.nPSMs;
    }

    public long getnPeptideAssumptionsTotal() {
        return this.nPeptideAssumptionsTotal;
    }

    public int getPsmsRejected() {
        return this.psmsRejected;
    }

    public int getProteinIssue() {
        return this.proteinIssue;
    }

    public int getPeptideIssue() {
        return this.peptideIssue;
    }

    public int getPrecursorIssue() {
        return this.precursorIssue;
    }

    public int getModificationIssue() {
        return this.modificationIssue;
    }

    public int getMissingProteins() {
        return this.missingProteins;
    }

    public int getnRetained() {
        return this.nRetained;
    }

    public HashSet<Integer> getCharges() {
        return this.charges;
    }

    public double getMaxPeptideErrorPpm() {
        return this.maxPeptideErrorPpm;
    }

    public double getMaxPeptideErrorDa() {
        return this.maxPeptideErrorDa;
    }

    public double getMaxTagErrorPpm() {
        return this.maxTagErrorPpm;
    }

    public double getMaxTagErrorDa() {
        return this.maxTagErrorDa;
    }

    public HashMap<String, Integer> getProteinCount() {
        return this.proteinCount;
    }
}

