/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.followup;

import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.io.flat.SimpleFileWriter;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.threading.SimpleSemaphore;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.utils.DeepLcUtils;
import eu.isas.peptideshaker.utils.Ms2PipUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DeepLcExport {
    public static ArrayList<File> deepLcExport(String destinationStem, File percolatorBenchmarkResultsFile, Identification identification, ModificationParameters modificationParameters, SequenceMatchingParameters sequenceMatchingParameters, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, WaitingHandler waitingHandler) {
        HashMap<String, Double> confidenceScores = null;
        if (percolatorBenchmarkResultsFile != null) {
            confidenceScores = DeepLcExport.getPercolatorResults(percolatorBenchmarkResultsFile);
        }
        HashMap spectrumIdentificationMap = identification.getSpectrumIdentification();
        waitingHandler.resetSecondaryProgressCounter();
        waitingHandler.setMaxSecondaryProgressCounter(identification.getSpectrumIdentificationSize());
        HashMap<String, Double> confScores = confidenceScores;
        spectrumIdentificationMap.entrySet().parallelStream().forEach(entry -> DeepLcExport.deepLcExport(DeepLcExport.getDestinationFile(destinationStem, (String)entry.getKey(), spectrumIdentificationMap.size() > 1), DeepLcExport.getConfidentHitsDestinationFile(destinationStem, (String)entry.getKey(), spectrumIdentificationMap.size() > 1), confScores, (HashSet)entry.getValue(), identification, modificationParameters, sequenceMatchingParameters, sequenceProvider, spectrumProvider, waitingHandler));
        return DeepLcExport.getExportedFiles(destinationStem, identification);
    }

    private static HashMap<String, Double> getPercolatorResults(File percResultsFile) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        try (SimpleFileReader reader = SimpleFileReader.getFileReader((File)percResultsFile);){
            String line = reader.readLine();
            while ((line = reader.readLine()) != null) {
                String[] lineSplit = line.split("\t");
                String key = lineSplit[0];
                double q_value = Double.parseDouble(lineSplit[2]);
                if (result.get(key) != null) continue;
                result.put(key, q_value);
            }
        }
        return result;
    }

    public static ArrayList<File> getExportedFiles(String destinationStem, Identification identification) {
        HashMap spectrumIdentificationMap = identification.getSpectrumIdentification();
        ArrayList<File> result = new ArrayList<File>(0);
        result.addAll(spectrumIdentificationMap.keySet().stream().map(spectrumFile -> DeepLcExport.getDestinationFile(destinationStem, spectrumFile, spectrumIdentificationMap.size() > 1)).collect(Collectors.toCollection(ArrayList::new)));
        result.addAll(spectrumIdentificationMap.keySet().stream().map(spectrumFile -> DeepLcExport.getDestinationFile(destinationStem, spectrumFile, spectrumIdentificationMap.size() > 1)).collect(Collectors.toCollection(ArrayList::new)));
        return result;
    }

    public static File getDestinationFile(String destinationStem, String spectrumFile, boolean addSuffix) {
        if (!addSuffix) {
            if (!destinationStem.endsWith(".gz")) {
                destinationStem = destinationStem + ".gz";
            }
            return new File(destinationStem);
        }
        String path = String.join((CharSequence)"_", destinationStem, spectrumFile, "deeplc_export.gz");
        return new File(path);
    }

    public static File getConfidentHitsDestinationFile(String destinationStem, String spectrumFile, boolean addSuffix) {
        if (!addSuffix) {
            destinationStem = !destinationStem.endsWith(".gz") ? destinationStem + "_confident.gz" : destinationStem.substring(0, destinationStem.length() - 3) + "_confident.gz";
            return new File(destinationStem);
        }
        String path = String.join((CharSequence)"_", destinationStem, spectrumFile, "deeplc_export_confident.gz");
        return new File(path);
    }

    public static void deepLcExport(File destinationFile, File confidentHitsDestinationFile, HashMap<String, Double> confidenceScores, HashSet<Long> keys, Identification identification, ModificationParameters modificationParameters, SequenceMatchingParameters sequenceMatchingParameters, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, WaitingHandler waitingHandler) {
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        HashSet processedPeptideKeys = new HashSet();
        SimpleSemaphore writingSemaphore = new SimpleSemaphore(1);
        HashSet processedConfidentPeptideKeys = new HashSet();
        try (SimpleFileWriter writer = new SimpleFileWriter(destinationFile, true);){
            writer.writeLine("seq,modifications,tr");
            try (SimpleFileWriter writerConfident = new SimpleFileWriter(confidentHitsDestinationFile, true);){
                writerConfident.writeLine("seq,modifications,tr");
                long[] spectrumKeys = keys.stream().mapToLong(a -> a).toArray();
                SpectrumMatchesIterator spectrumMatchesIterator = identification.getSpectrumMatchesIterator(spectrumKeys, waitingHandler);
                while (true) {
                    SpectrumMatch spectrumMatch;
                    if ((spectrumMatch = spectrumMatchesIterator.next()) != null) {
                        if (waitingHandler != null) {
                            waitingHandler.increaseSecondaryProgressCounter();
                            if (waitingHandler.isRunCanceled()) {
                                return;
                            }
                        }
                        String spectrumFile = spectrumMatch.getSpectrumFile();
                        String spectrumTitle = spectrumMatch.getSpectrumTitle();
                        Precursor precursor = spectrumProvider.getPrecursor(spectrumFile, spectrumTitle);
                        double retentionTime = precursor.rt;
                        SpectrumMatch tempSpectrumMatch = spectrumMatch;
                        ((Stream)tempSpectrumMatch.getAllPeptideAssumptions().parallel()).forEach(peptideAssumption -> DeepLcExport.writePeptideCandidate(null, peptideAssumption, retentionTime, tempSpectrumMatch, modificationParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory, processedPeptideKeys, writingSemaphore, writer));
                        ((Stream)tempSpectrumMatch.getAllPeptideAssumptions().parallel()).forEach(peptideAssumption -> DeepLcExport.writePeptideCandidate(confidenceScores, peptideAssumption, retentionTime, tempSpectrumMatch, modificationParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory, processedConfidentPeptideKeys, writingSemaphore, writerConfident));
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private static void writePeptideCandidate(HashMap<String, Double> confidenceScores, PeptideAssumption peptideAssumption, double retentionTime, SpectrumMatch spectrumMatch, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters, ModificationFactory modificationFactory, HashSet<Long> processedPeptides, SimpleSemaphore writingSemaphore, SimpleFileWriter writer) {
        if (confidenceScores != null) {
            long spectrumKey = spectrumMatch.getKey();
            String peptideData = Ms2PipUtils.getPeptideData(peptideAssumption, modificationParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory);
            long peptideMs2PipKey = Ms2PipUtils.getPeptideKey(peptideData);
            String peptideID = Long.toString(peptideMs2PipKey);
            CharSequence[] charSequenceArray = new CharSequence[]{String.valueOf(spectrumKey), peptideID};
            String psmID = String.join((CharSequence)"_", charSequenceArray);
            double q_value = confidenceScores.get(psmID);
            if (q_value > 0.01) {
                return;
            }
        }
        String peptideData = DeepLcUtils.getPeptideData(peptideAssumption, retentionTime, modificationParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory);
        long peptideKey = DeepLcUtils.getPeptideKey(peptideData);
        writingSemaphore.acquire();
        if (!processedPeptides.contains(peptideKey)) {
            writer.writeLine(peptideData);
            processedPeptides.add(peptideKey);
        }
        writingSemaphore.release();
    }
}

