/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.followup;

import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.ProteinMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.gui.filtering.FilterParameters;
import com.compomics.util.io.flat.SimpleFileWriter;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class InclusionListExport {
    public static void exportInclusionList(File destinationFile, Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SpectrumProvider spectrumProvider, ArrayList<Integer> proteinFilters, ArrayList<PeptideFilterType> peptideFilters, ExportFormat exportFormat, SearchParameters searchParameters, double rtWindow, WaitingHandler waitingHandler, FilterParameters filterPreferences) throws IOException {
        if (waitingHandler != null) {
            if (waitingHandler.isRunCanceled()) {
                return;
            }
            waitingHandler.setWaitingText("Inclusion List - Writing File. Please Wait...");
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(identification.getProteinIdentification().size());
        }
        try (SimpleFileWriter writer = new SimpleFileWriter(destinationFile, false);){
            ProteinMatch proteinMatch;
            ProteinMatchesIterator proteinMatchesIterator = identification.getProteinMatchesIterator(waitingHandler);
            while ((proteinMatch = proteinMatchesIterator.next()) != null) {
                PSParameter proteinParameter = (PSParameter)proteinMatch.getUrParam((UrParameter)PSParameter.dummy);
                if (!proteinFilters.contains(proteinParameter.getProteinInferenceGroupClass())) {
                    ArrayList<Long> peptideMatches = new ArrayList<Long>();
                    for (long peptideKey : proteinMatch.getPeptideMatchesKeys()) {
                        PeptideMatch peptideMatch = identification.getPeptideMatch(peptideKey);
                        PSParameter peptideParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                        if (!peptideParameter.getMatchValidationLevel().isValidated()) continue;
                        boolean passesFilter = true;
                        for (PeptideFilterType filterType : peptideFilters) {
                            String sequence = peptideMatch.getPeptide().getSequence();
                            if (filterType == PeptideFilterType.degenerated) {
                                if (peptideParameter.getProteinInferenceGroupClass() == 0) continue;
                                passesFilter = false;
                                break;
                            }
                            if (filterType == PeptideFilterType.miscleaved) {
                                Integer peptideMinMissedCleavages = null;
                                DigestionParameters digestionPreferences = searchParameters.getDigestionParameters();
                                if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
                                    for (Enzyme enzyme : digestionPreferences.getEnzymes()) {
                                        int tempMissedCleavages = enzyme.getNmissedCleavages(sequence);
                                        if (peptideMinMissedCleavages != null && tempMissedCleavages >= peptideMinMissedCleavages) continue;
                                        peptideMinMissedCleavages = tempMissedCleavages;
                                    }
                                }
                                if (peptideMinMissedCleavages == null || peptideMinMissedCleavages <= 0) continue;
                                passesFilter = false;
                                break;
                            }
                            if (filterType != PeptideFilterType.reactive || !sequence.contains("M") && !sequence.contains("C") && !sequence.contains("W") && !sequence.contains("NG") && !sequence.contains("DG") && !sequence.contains("QG") && !sequence.startsWith("N") && !sequence.startsWith("Q")) continue;
                            passesFilter = false;
                            break;
                        }
                        if (!passesFilter) continue;
                        peptideMatches.add(peptideKey);
                    }
                    if (!peptideMatches.isEmpty()) {
                        Object object = peptideMatches.iterator();
                        while (object.hasNext()) {
                            long peptideKey = (Long)object.next();
                            PeptideMatch peptideMatch = identification.getPeptideMatch(peptideKey);
                            ArrayList<SpectrumMatch> validatedPsms = new ArrayList<SpectrumMatch>(peptideMatch.getSpectrumCount());
                            ArrayList<Double> retentionTimes = new ArrayList<Double>(peptideMatch.getSpectrumCount());
                            for (long spectrumKey : peptideMatch.getSpectrumMatchesKeys()) {
                                PSParameter spectrumParameter;
                                SpectrumMatch spectrumMatch = identification.getSpectrumMatch(spectrumKey);
                                if (spectrumMatch.getBestPeptideAssumption() == null || !(spectrumParameter = (PSParameter)spectrumMatch.getUrParam((UrParameter)PSParameter.dummy)).getMatchValidationLevel().isValidated()) continue;
                                validatedPsms.add(spectrumMatch);
                                retentionTimes.add(spectrumProvider.getPrecursorRt(spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle()));
                            }
                            if (validatedPsms.isEmpty()) continue;
                            Object object2 = validatedPsms.iterator();
                            while (object2.hasNext()) {
                                SpectrumMatch spectrumMatch = (SpectrumMatch)object2.next();
                                double precursorMz = spectrumProvider.getPrecursorMz(spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle());
                                String line = InclusionListExport.getInclusionListLine(spectrumMatch, retentionTimes, rtWindow, precursorMz, exportFormat, searchParameters);
                                writer.writeLine(line);
                            }
                        }
                    }
                }
                if (waitingHandler == null) continue;
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                waitingHandler.increaseSecondaryProgressCounter();
            }
        }
    }

    private static String getInclusionListLine(SpectrumMatch spectrumMatch, ArrayList<Double> retentionTimes, double rtWindow, double precursorMz, ExportFormat exportFormat, SearchParameters searchParameters) {
        switch (exportFormat.ordinal()) {
            case 0: {
                int index = (int)(0.25 * (double)retentionTimes.size());
                double rtMin = retentionTimes.get(index) / 60.0;
                index = (int)(0.75 * (double)retentionTimes.size());
                double rtMax = retentionTimes.get(index) / 60.0;
                if (rtMax - rtMin < rtWindow / 60.0) {
                    index = (int)(0.5 * (double)retentionTimes.size());
                    rtMin = (retentionTimes.get(index) - rtWindow / 2.0) / 60.0;
                    rtMax = (retentionTimes.get(index) + rtWindow / 2.0) / 60.0;
                }
                return String.join((CharSequence)"\t", Double.toString(precursorMz), Double.toString(rtMin), Double.toString(rtMax));
            }
            case 1: {
                int index = (int)(0.5 * (double)retentionTimes.size());
                double rtInMin = retentionTimes.get(index) / 60.0;
                return String.join((CharSequence)"\t", Double.toString(rtInMin), Double.toString(precursorMz));
            }
            case 2: {
                int index = 0 * retentionTimes.size();
                double rt = retentionTimes.get(index);
                int index25 = (int)(0.25 * (double)retentionTimes.size());
                int index75 = (int)(0.75 * (double)retentionTimes.size());
                double range = retentionTimes.get(index75) - retentionTimes.get(index25);
                if (range < rtWindow) {
                    range = rtWindow;
                }
                if (searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.PPM) {
                    double deltaMZ = searchParameters.getPrecursorAccuracy() / 1000000.0 * precursorMz;
                    double mzMin = precursorMz - deltaMZ;
                    double mzMax = precursorMz + deltaMZ;
                    return String.join((CharSequence)",", Double.toString(rt), Double.toString(range), Double.toString(mzMin), Double.toString(mzMax));
                }
                double deltaMZ = searchParameters.getPrecursorAccuracy() / (double)spectrumMatch.getBestPeptideAssumption().getIdentificationCharge();
                double mzMin = precursorMz - deltaMZ;
                double mzMax = precursorMz + deltaMZ;
                return String.join((CharSequence)",", Double.toString(rt), Double.toString(range), Double.toString(mzMin), Double.toString(mzMax));
            }
            case 3: {
                int index = (int)(0.5 * (double)retentionTimes.size());
                double rt = retentionTimes.get(index);
                return String.join((CharSequence)",", Double.toString(precursorMz), Double.toString(rt));
            }
        }
        return "";
    }

    public static String getProteinFiltersCommandLineOptions() {
        return "1: " + PSParameter.getProteinInferenceClassAsString((int)1) + ", " + 2 + ": " + PSParameter.getProteinInferenceClassAsString((int)2) + ", " + 3 + ": " + PSParameter.getProteinInferenceClassAsString((int)3) + ".";
    }

    public static enum PeptideFilterType {
        miscleaved(0, "Miscleaved Peptides"),
        reactive(1, "Reactive Peptides"),
        degenerated(2, "Degenerated Peptides");

        public int index;
        public String description;

        private PeptideFilterType(int index, String description) {
            this.index = index;
            this.description = description;
        }

        public static PeptideFilterType getTypeFromIndex(int index) {
            if (index == PeptideFilterType.miscleaved.index) {
                return miscleaved;
            }
            if (index == PeptideFilterType.reactive.index) {
                return reactive;
            }
            if (index == PeptideFilterType.degenerated.index) {
                return degenerated;
            }
            throw new IllegalArgumentException("Export format index " + index + "not implemented.");
        }

        public static String[] getPossibilities() {
            return (String[])Arrays.stream(PeptideFilterType.values()).map(value -> value.description).toArray(String[]::new);
        }

        public static String getCommandLineOptions() {
            return PeptideFilterType.miscleaved.index + ": " + PeptideFilterType.miscleaved.description + ", " + PeptideFilterType.reactive.index + ": " + PeptideFilterType.reactive.description + ", " + PeptideFilterType.degenerated.index + ": " + PeptideFilterType.degenerated.description + ".";
        }
    }

    public static enum ExportFormat {
        Thermo(0, "Thermo", "txt"),
        ABI(1, "ABI", "txt"),
        Bruker(2, "Bruker", "csv"),
        MassLynx(3, "MassLynx", "txt");

        public int index;
        public String description;
        public String extension;

        private ExportFormat(int index, String description, String extension) {
            this.index = index;
            this.description = description;
            this.extension = extension;
        }

        public static ExportFormat getTypeFromIndex(int index) {
            for (ExportFormat format : ExportFormat.values()) {
                if (index != format.index) continue;
                return format;
            }
            throw new IllegalArgumentException("Export format index " + index + "not implemented.");
        }

        public static String[] getPossibilities() {
            return (String[])Arrays.stream(ExportFormat.values()).map(value -> value.description).toArray(String[]::new);
        }

        public static String getCommandLineOptions() {
            return ExportFormat.Thermo.index + ": " + ExportFormat.Thermo.description + " (default), " + ExportFormat.ABI.index + ": " + ExportFormat.ABI.description + ", " + ExportFormat.Bruker.index + ": " + ExportFormat.Bruker.description + ", " + ExportFormat.MassLynx.index + ": " + ExportFormat.MassLynx.description + ".";
        }

        public static File verifyFileExtension(File destinationFile, ExportFormat exportFormat) {
            if (!destinationFile.getName().endsWith(exportFormat.extension)) {
                return new File(destinationFile.getParent(), destinationFile.getName() + exportFormat.extension);
            }
            return destinationFile;
        }
    }
}

