/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.followup;

import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Collectors;

public class ProgenesisExport {
    public static final char SEPARATOR = '\t';

    public static void writeProgenesisExport(File destinationFile, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, Identification identification, ExportType exportType, WaitingHandler waitingHandler, HashSet<String> targetedModifications, SequenceMatchingParameters sequenceMatchingPreferences) throws IOException {
        if (exportType == ExportType.confident_ptms && (targetedModifications == null || targetedModifications.isEmpty())) {
            throw new IllegalArgumentException("No modification provided for the Progenesis PTM export.");
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(destinationFile));){
            SpectrumMatch spectrumMatch;
            writer.write("sequence");
            writer.write(9);
            writer.write("modif");
            writer.write(9);
            writer.write("score");
            writer.write(9);
            writer.write("main AC");
            writer.write(9);
            writer.write("description");
            writer.write(9);
            writer.write("compound");
            writer.write(9);
            writer.write("jobid");
            writer.write(9);
            writer.write("pmkey");
            writer.newLine();
            if (waitingHandler != null) {
                waitingHandler.setWaitingText("Exporting Spectra - Writing File. Please Wait...");
                waitingHandler.resetSecondaryProgressCounter();
                waitingHandler.setMaxSecondaryProgressCounter(identification.getSpectrumIdentificationSize());
            }
            SpectrumMatchesIterator psmIterator = identification.getSpectrumMatchesIterator(waitingHandler);
            while ((spectrumMatch = psmIterator.next()) != null) {
                PSParameter spectrumMatchParameter;
                if (spectrumMatch.getBestPeptideAssumption() != null && (spectrumMatchParameter = (PSParameter)spectrumMatch.getUrParam((UrParameter)PSParameter.dummy)).getMatchValidationLevel().isValidated()) {
                    Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
                    if ((exportType != ExportType.confident_ptms || ProgenesisExport.isTargetedPeptide(peptide, targetedModifications)) && !PeptideUtils.isDecoy((Peptide)peptide, (SequenceProvider)sequenceProvider)) {
                        if (exportType == ExportType.validated_psms) {
                            ProgenesisExport.writeSpectrumMatch(writer, spectrumMatch, proteinDetailsProvider);
                        } else {
                            long peptideKey = peptide.getMatchingKey(sequenceMatchingPreferences);
                            PeptideMatch peptideMatch = identification.getPeptideMatch(peptideKey);
                            PSParameter peptideParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                            if (peptideParameter.getMatchValidationLevel().isValidated()) {
                                if (exportType == ExportType.validated_psms_peptides) {
                                    ProgenesisExport.writeSpectrumMatch(writer, spectrumMatch, proteinDetailsProvider);
                                } else {
                                    Iterator iterator = identification.getProteinMatches(peptideKey).iterator();
                                    while (iterator.hasNext()) {
                                        long proteinMatchKey = (Long)iterator.next();
                                        ProteinMatch proteinMatch = identification.getProteinMatch(proteinMatchKey);
                                        PSParameter proteinParameter = (PSParameter)proteinMatch.getUrParam((UrParameter)PSParameter.dummy);
                                        if (!proteinParameter.getMatchValidationLevel().isValidated()) continue;
                                        ProgenesisExport.writeSpectrumMatch(writer, spectrumMatch, proteinDetailsProvider);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
                if (waitingHandler == null) continue;
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                waitingHandler.increaseSecondaryProgressCounter();
            }
        }
    }

    private static boolean isTargetedPeptide(Peptide peptide, HashSet<String> targetedModifications) {
        return Arrays.stream(peptide.getVariableModifications()).anyMatch(modificationMatch -> targetedModifications.contains(modificationMatch.getModification()) && modificationMatch.getConfident());
    }

    private static void writeSpectrumMatch(BufferedWriter writer, SpectrumMatch spectrumMatch, ProteinDetailsProvider proteinDetailsProvider) throws IOException {
        PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam((UrParameter)PSParameter.dummy);
        PeptideAssumption bestAssumption = spectrumMatch.getBestPeptideAssumption();
        Peptide peptide = bestAssumption.getPeptide();
        for (String accession : peptide.getProteinMapping().navigableKeySet()) {
            String sequence = peptide.getSequence();
            writer.write(sequence + '\t');
            HashMap<Integer, HashSet<String>> modMap = new HashMap<Integer, HashSet<String>>();
            for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
                int site = modificationMatch.getSite();
                HashSet<String> modNames = (HashSet<String>)modMap.get(site);
                if (modNames == null) {
                    modNames = new HashSet<String>(1);
                    modMap.put(site, modNames);
                }
                modNames.add(modificationMatch.getModification());
            }
            for (int i = 0; i < sequence.length() + 1; ++i) {
                HashSet modsAtI = (HashSet)modMap.get(i + 1);
                if (modsAtI != null) {
                    writer.write(modsAtI.stream().sorted().collect(Collectors.joining(",")));
                }
                writer.write(58);
            }
            writer.write(9);
            writer.write(Double.toString(psParameter.getConfidence()));
            writer.write(9);
            writer.write(accession);
            writer.write(9);
            writer.write(proteinDetailsProvider.getSimpleDescription(accession));
            writer.write(9);
            String spectrumTitle = spectrumMatch.getSpectrumTitle();
            int intensityIndex = spectrumTitle.indexOf(" (intensity=");
            if (intensityIndex > -1) {
                spectrumTitle = spectrumTitle.substring(0, intensityIndex);
            }
            writer.write(spectrumTitle);
            writer.write(9);
            writer.write("N/A");
            writer.write(9);
            writer.write("N/A");
            writer.write(9);
            writer.newLine();
        }
    }

    public static enum ExportType {
        validated_psms_peptides_proteins(0, "Validated PSMs of Validated Peptides of Validated Proteins"),
        validated_psms_peptides(1, "Validated PSMs of Validated Peptides"),
        validated_psms(2, "Validated PSMs"),
        confident_ptms(3, "Confidently localized PTMs of Validated PSMs of Validated Peptides of Validated Proteins");

        public int index;
        public String description;

        private ExportType(int index, String description) {
            this.index = index;
            this.description = description;
        }

        public static ExportType getTypeFromIndex(int index) {
            for (ExportType exportType : ExportType.values()) {
                if (index != exportType.index) continue;
                return exportType;
            }
            throw new IllegalArgumentException("Export type index " + index + " not implemented.");
        }

        public static String[] getPossibilities() {
            return (String[])Arrays.stream(ExportType.values()).map(value -> value.description).toArray(String[]::new);
        }

        public static String getCommandLineOptions() {
            return ExportType.validated_psms_peptides_proteins.index + ": " + ExportType.validated_psms_peptides_proteins.description + ", " + ExportType.validated_psms_peptides.index + ": " + ExportType.validated_psms_peptides.description + ", " + ExportType.validated_psms.index + ": " + ExportType.validated_psms.description + "," + ExportType.confident_ptms.index + ":" + ExportType.confident_ptms.description + ".";
        }
    }
}

