/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.followup;

import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.io.mass_spectrometry.mgf.MgfFileWriter;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.io.IoUtil;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.recalibration.SpectrumRecalibrator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class RecalibrationExporter {
    private static final boolean DEBUG = false;
    public static final String SUFFIX = "_recalibrated";

    public static ArrayList<File> writeRecalibratedSpectra(boolean recalibratePrecursors, boolean recalibrateFragmentIons, File folder, Identification identification, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, IdentificationParameters identificationParameters, WaitingHandler waitingHandler) throws IOException {
        SpectrumRecalibrator spectrumRecalibrator = new SpectrumRecalibrator();
        ArrayList<File> recalibratedSpectrums = new ArrayList<File>();
        int progress = 1;
        for (String fileNameWithoutExtension : spectrumProvider.getOrderedFileNamesWithoutExtensions()) {
            if (waitingHandler != null) {
                if (waitingHandler.isRunCanceled()) break;
                waitingHandler.setWaitingText("Recalibrating Spectra. Inspecting Mass Deviations. Please Wait... (" + progress + "/" + spectrumProvider.getOrderedFileNamesWithoutExtensions().length + ")");
                waitingHandler.resetSecondaryProgressCounter();
                waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                waitingHandler.setMaxSecondaryProgressCounter(2 * spectrumProvider.getSpectrumTitles(fileNameWithoutExtension).length);
            }
            spectrumRecalibrator.estimateErrors(fileNameWithoutExtension, identification, sequenceProvider, spectrumProvider, identificationParameters, waitingHandler);
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                return null;
            }
            File file = new File(folder, RecalibrationExporter.getRecalibratedFileName(fileNameWithoutExtension + ".mgf"));
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                if (waitingHandler != null) {
                    waitingHandler.setWaitingText("Recalibrating Spectra. Writing Spectra. Please Wait... (" + progress + "/" + spectrumProvider.getOrderedFileNamesWithoutExtensions().length + ")");
                    waitingHandler.resetSecondaryProgressCounter();
                    waitingHandler.setMaxSecondaryProgressCounter(spectrumProvider.getSpectrumTitles(fileNameWithoutExtension).length);
                }
                for (String spectrumTitle : spectrumProvider.getSpectrumTitles(fileNameWithoutExtension)) {
                    Spectrum recalibratedSpectrum = spectrumRecalibrator.recalibrateSpectrum(fileNameWithoutExtension, spectrumTitle, spectrumProvider, recalibratePrecursors, recalibrateFragmentIons);
                    String recalibratedSpectrumAsMgf = MgfFileWriter.asMgf((String)spectrumTitle, (Spectrum)recalibratedSpectrum);
                    writer.write(recalibratedSpectrumAsMgf);
                    writer.flush();
                    if (waitingHandler == null) continue;
                    if (waitingHandler.isRunCanceled()) break;
                    waitingHandler.increasePrimaryProgressCounter();
                }
                spectrumRecalibrator.clearErrors(fileNameWithoutExtension);
            }
            recalibratedSpectrums.add(file);
        }
        return recalibratedSpectrums;
    }

    public static String getRecalibratedFileName(String fileName) {
        return IoUtil.appendSuffix((String)fileName, (String)SUFFIX);
    }
}

