/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.followup;

import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.io.mass_spectrometry.mgf.MgfFileWriter;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.io.IoUtil;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class SpectrumExporter {
    private final Identification identification;
    private final SpectrumProvider spectrumProvider;

    public SpectrumExporter(Identification identification, SpectrumProvider spectrumProvider) {
        this.identification = identification;
        this.spectrumProvider = spectrumProvider;
    }

    public ArrayList<File> exportSpectra(File destinationFolder, WaitingHandler waitingHandler, ExportType exportType, SequenceMatchingParameters sequenceMatchingPreferences) throws IOException {
        String[] spectrumFileNamesWithoutExtensions = this.spectrumProvider.getOrderedFileNamesWithoutExtensions();
        ArrayList<File> destinationFiles = new ArrayList<File>(spectrumFileNamesWithoutExtensions.length);
        for (int i = 0; i < spectrumFileNamesWithoutExtensions.length; ++i) {
            String fileNameWithoutExtension = spectrumFileNamesWithoutExtensions[i];
            String[] spectrumTitles = this.spectrumProvider.getSpectrumTitles(fileNameWithoutExtension);
            if (waitingHandler != null) {
                waitingHandler.setWaitingText("Exporting Spectra. Please Wait... (" + (i + 1) + "/" + spectrumFileNamesWithoutExtensions.length + ")");
                waitingHandler.resetSecondaryProgressCounter();
                waitingHandler.setMaxSecondaryProgressCounter(spectrumTitles.length);
            }
            File destinationFile = SpectrumExporter.getDestinationFile(destinationFolder, fileNameWithoutExtension + ".mgf", exportType);
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(destinationFile));){
                for (String spectrumTitle : spectrumTitles) {
                    boolean include;
                    Spectrum spectrum = this.spectrumProvider.getSpectrum(fileNameWithoutExtension, spectrumTitle);
                    if (spectrum.getSpectrumLevel() == 2 && (include = SpectrumExporter.include(fileNameWithoutExtension, spectrumTitle, this.identification, sequenceMatchingPreferences, exportType))) {
                        bw.write(MgfFileWriter.asMgf((String)spectrumTitle, (Spectrum)spectrum));
                    }
                    if (waitingHandler == null) continue;
                    if (waitingHandler.isRunCanceled()) {
                        ArrayList<File> arrayList = null;
                        return arrayList;
                    }
                    waitingHandler.increaseSecondaryProgressCounter();
                }
            }
            destinationFiles.add(destinationFile);
        }
        return destinationFiles;
    }

    public static File getDestinationFile(File destinationFolder, String originalFileName, ExportType exportType) {
        return new File(destinationFolder, IoUtil.appendSuffix((String)originalFileName, (String)SpectrumExporter.getSuffix(exportType)));
    }

    public static boolean include(String spectrumFile, String spectrumTitle, Identification identification, SequenceMatchingParameters sequenceMatchingParameters, ExportType exportType) {
        long spectrumMatchKey = SpectrumMatch.getKey((String)spectrumFile, (String)spectrumTitle);
        SpectrumMatch spectrumMatch = identification.getSpectrumMatch(spectrumMatchKey);
        switch (exportType.ordinal()) {
            case 0: {
                return spectrumMatch == null || !((PSParameter)spectrumMatch.getUrParam((UrParameter)PSParameter.dummy)).getMatchValidationLevel().isValidated();
            }
            case 1: {
                if (spectrumMatch == null || spectrumMatch.getBestPeptideAssumption() == null) {
                    return true;
                }
                long peptideMatchKey = spectrumMatch.getBestPeptideAssumption().getPeptide().getMatchingKey(sequenceMatchingParameters);
                PeptideMatch peptideMatch = identification.getPeptideMatch(peptideMatchKey);
                return !((PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy)).getMatchValidationLevel().isValidated();
            }
            case 2: {
                if (spectrumMatch == null || spectrumMatch.getBestPeptideAssumption() == null) {
                    return true;
                }
                long peptideMatchKey = spectrumMatch.getBestPeptideAssumption().getPeptide().getMatchingKey(sequenceMatchingParameters);
                PeptideMatch peptideMatch = identification.getPeptideMatch(peptideMatchKey);
                return !identification.getProteinMatches(peptideMatch.getKey()).stream().anyMatch(key -> ((PSParameter)identification.getProteinMatch(key.longValue()).getUrParam((UrParameter)PSParameter.dummy)).getMatchValidationLevel().isValidated());
            }
            case 3: {
                return spectrumMatch != null && ((PSParameter)spectrumMatch.getUrParam((UrParameter)PSParameter.dummy)).getMatchValidationLevel().isValidated();
            }
            case 4: {
                if (spectrumMatch == null || spectrumMatch.getBestPeptideAssumption() == null || !((PSParameter)spectrumMatch.getUrParam((UrParameter)PSParameter.dummy)).getMatchValidationLevel().isValidated()) {
                    return false;
                }
                long peptideMatchKey = spectrumMatch.getBestPeptideAssumption().getPeptide().getMatchingKey(sequenceMatchingParameters);
                PeptideMatch peptideMatch = identification.getPeptideMatch(peptideMatchKey);
                return ((PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy)).getMatchValidationLevel().isValidated();
            }
            case 5: {
                if (spectrumMatch == null || spectrumMatch.getBestPeptideAssumption() == null || !((PSParameter)spectrumMatch.getUrParam((UrParameter)PSParameter.dummy)).getMatchValidationLevel().isValidated()) {
                    return false;
                }
                long peptideMatchKey = spectrumMatch.getBestPeptideAssumption().getPeptide().getMatchingKey(sequenceMatchingParameters);
                PeptideMatch peptideMatch = identification.getPeptideMatch(peptideMatchKey);
                if (!((PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy)).getMatchValidationLevel().isValidated()) {
                    return false;
                }
                return !identification.getProteinMatches(peptideMatch.getKey()).stream().anyMatch(key -> ((PSParameter)identification.getProteinMatch(key.longValue()).getUrParam((UrParameter)PSParameter.dummy)).getMatchValidationLevel().isValidated());
            }
        }
        throw new UnsupportedOperationException("Export " + (Object)((Object)exportType) + " not implemented.");
    }

    public static String getSuffix(ExportType exportType) {
        switch (exportType.ordinal()) {
            case 0: {
                return "_non_validated_PSMs";
            }
            case 1: {
                return "_non_validated_peptides";
            }
            case 2: {
                return "_non_validated_proteins";
            }
            case 3: {
                return "_validated_PSMs";
            }
            case 4: {
                return "_validated_PSMs-peptides";
            }
            case 5: {
                return "_validated_PSMs-peptides-proteins";
            }
        }
        throw new IllegalArgumentException("Export type " + (Object)((Object)exportType) + " not supported.");
    }

    public static enum ExportType {
        non_validated_psms(0, "Spectra of Non-Validated PSMs"),
        non_validated_peptides(1, "Spectra of Non-Validated Peptides"),
        non_validated_proteins(2, "Spectra of Non-Validated Proteins"),
        validated_psms(3, "Spectra of Validated PSMs"),
        validated_psms_peptides(4, "Spectra of Validated PSMs of Validated Peptides"),
        validated_psms_peptides_proteins(5, "Spectra of validated PSMs of Validated Peptides of Validated Proteins");

        public int index;
        public String description;

        private ExportType(int index, String description) {
            this.index = index;
            this.description = description;
        }

        public static ExportType getTypeFromIndex(int index) {
            if (index == ExportType.non_validated_psms.index) {
                return non_validated_psms;
            }
            if (index == ExportType.non_validated_peptides.index) {
                return non_validated_peptides;
            }
            if (index == ExportType.non_validated_proteins.index) {
                return non_validated_proteins;
            }
            if (index == ExportType.non_validated_peptides.index) {
                return non_validated_peptides;
            }
            if (index == ExportType.validated_psms.index) {
                return validated_psms;
            }
            if (index == ExportType.validated_psms_peptides.index) {
                return validated_psms_peptides;
            }
            if (index == ExportType.validated_psms_peptides_proteins.index) {
                return validated_psms_peptides_proteins;
            }
            throw new IllegalArgumentException("Export type index " + index + " not implemented.");
        }

        public static String[] getPossibilities() {
            return new String[]{ExportType.non_validated_psms.description, ExportType.non_validated_peptides.description, ExportType.non_validated_proteins.description, ExportType.validated_psms.description, ExportType.validated_psms_peptides.description, ExportType.validated_psms_peptides_proteins.description};
        }

        public static String getCommandLineOptions() {
            return ExportType.non_validated_psms.index + ": " + ExportType.non_validated_psms.description + " (default), " + ExportType.non_validated_peptides.index + ": " + ExportType.non_validated_peptides.description + ", " + ExportType.non_validated_proteins.index + ": " + ExportType.non_validated_proteins.description + ", " + ExportType.validated_psms.index + ": " + ExportType.validated_psms.description + ", " + ExportType.validated_psms_peptides.index + ": " + ExportType.validated_psms_peptides.description + ", " + ExportType.validated_psms_peptides_proteins.index + ": " + ExportType.validated_psms_peptides_proteins.description + ".";
        }
    }
}

