/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui;

import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.exceptions.exception_handlers.WaitingDialogExceptionHandler;
import com.compomics.util.experiment.ProjectParameters;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationParametersFactory;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.experiment.io.biology.protein.ProteinDatabase;
import com.compomics.util.experiment.io.mass_spectrometry.MsFileHandler;
import com.compomics.util.experiment.io.mass_spectrometry.cms.CmsFolder;
import com.compomics.util.experiment.io.temp.TempFilesManager;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.JOptionEditorPane;
import com.compomics.util.gui.file_handling.FileDisplayDialog;
import com.compomics.util.gui.file_handling.FileSelectionDialog;
import com.compomics.util.gui.parameters.identification.IdentificationParametersEditionDialog;
import com.compomics.util.gui.parameters.tools.ProcessingParametersDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingDialog;
import com.compomics.util.io.compression.ZipUtils;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.ValidationQcParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.peptide_shaker.ProjectType;
import com.compomics.util.parameters.quantification.spectrum_counting.SpectrumCountingParameters;
import com.compomics.util.parameters.tools.ProcessingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.gui.WelcomeDialog;
import eu.isas.peptideshaker.gui.parameters.ProjectParametersDialog;
import eu.isas.peptideshaker.preferences.DisplayParameters;
import eu.isas.peptideshaker.preferences.ProjectDetails;
import eu.isas.peptideshaker.utils.Properties;
import eu.isas.peptideshaker.utils.PsZipUtils;
import eu.isas.peptideshaker.utils.Tips;
import eu.isas.peptideshaker.validation.MatchesValidator;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileFilter;

public class NewDialog
extends JDialog {
    private final ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private final PeptideShakerGUI peptideShakerGUI;
    private ArrayList<File> idFiles = new ArrayList();
    private final ArrayList<File> modificationFiles = new ArrayList();
    public static final String SEARCHGUI_INPUT = "searchGUI_input.txt";
    private ArrayList<File> spectrumFiles = new ArrayList();
    private File fastaFile;
    private PeptideShaker peptideShaker;
    private ProgressDialogX progressDialog;
    private IdentificationParameters identificationParameters = null;
    private ProcessingParameters processingParameters;
    private DisplayParameters displayPreferences = new DisplayParameters();
    private final WelcomeDialog welcomeDialog;
    private SpectrumCountingParameters spectrumCountingPreferences = new SpectrumCountingParameters();
    private ProjectDetails projectDetails = new ProjectDetails();
    private final IdentificationParametersFactory identificationParametersFactory = IdentificationParametersFactory.getInstance();
    private MsFileHandler msFileHandler = new MsFileHandler();
    private JButton aboutButton;
    private JButton addSettingsButton;
    private JButton browseDbButton;
    private JButton browseId;
    private JButton browseSpectra;
    private JButton clearDbButton;
    private JButton clearId;
    private JButton clearSpectra;
    private JLabel databaseLabel;
    private JButton editProcessingButton;
    private JButton editSettingsButton;
    private JTextField fastaFileTxt;
    private JLabel idFilesLabel;
    private JTextField idFilesTxt;
    private JLabel identificationParametersLabel;
    private JPanel inputFilesPanel;
    private JButton loadButton;
    private JLabel peptideShakerPublicationLabel;
    private JLabel processingLbl;
    private JPanel processingParametersPanel;
    private JTextField processingTxt;
    private JPanel projectDetailsPanel;
    private JTextField projectNameIdTxt;
    private JLabel projectReferenceLabel;
    private JButton projectSettingsButton;
    private JLabel projectSettingsLabel;
    private JTextField projectSettingsTxt;
    private JPanel sampleDetailsPanel;
    private JComboBox settingsComboBox;
    private JLabel spectrumFilesLabel;
    private JTextField spectrumFilesTxt;
    private JComboBox<String> typeCmb;

    public NewDialog(PeptideShakerGUI peptideShakerGui, boolean modal) {
        super((Frame)peptideShakerGui, modal);
        this.peptideShakerGUI = peptideShakerGui;
        this.welcomeDialog = null;
        this.processingParameters = new ProcessingParameters();
        this.setUpGui();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
        this.setLocationRelativeTo(peptideShakerGui);
        this.setVisible(true);
    }

    public NewDialog(WelcomeDialog welcomeDialog, PeptideShakerGUI peptideShakerGui, boolean modal) {
        super((Dialog)welcomeDialog, modal);
        this.peptideShakerGUI = peptideShakerGui;
        this.welcomeDialog = welcomeDialog;
        this.processingParameters = new ProcessingParameters();
        this.setUpGui();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
        this.setLocationRelativeTo(welcomeDialog);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.initComponents();
        this.settingsComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.typeCmb.setRenderer((ListCellRenderer<String>)new AlignedListCellRenderer(0));
        this.idFilesTxt.setText(this.idFiles.size() + " file(s) selected");
        this.spectrumFilesTxt.setText(this.spectrumFiles.size() + " file(s) selected");
        this.fastaFileTxt.setText("");
        this.processingTxt.setText(this.processingParameters.getnThreads() + " cores");
        Vector<String> parameterList = new Vector<String>();
        parameterList.add("-- Select --");
        for (String tempParameters : this.identificationParametersFactory.getParametersList()) {
            parameterList.add(tempParameters);
        }
        this.settingsComboBox.setModel(new DefaultComboBoxModel(parameterList));
        this.validateInput();
        GuiUtilities.installEscapeCloseOperation((JDialog)this);
    }

    private void initComponents() {
        this.sampleDetailsPanel = new JPanel();
        this.loadButton = new JButton();
        this.projectDetailsPanel = new JPanel();
        this.projectNameIdTxt = new JTextField();
        this.projectReferenceLabel = new JLabel();
        this.typeCmb = new JComboBox();
        this.processingParametersPanel = new JPanel();
        this.projectSettingsTxt = new JTextField();
        this.projectSettingsLabel = new JLabel();
        this.identificationParametersLabel = new JLabel();
        this.editSettingsButton = new JButton();
        this.projectSettingsButton = new JButton();
        this.processingLbl = new JLabel();
        this.processingTxt = new JTextField();
        this.editProcessingButton = new JButton();
        this.addSettingsButton = new JButton();
        this.settingsComboBox = new JComboBox();
        this.inputFilesPanel = new JPanel();
        this.idFilesLabel = new JLabel();
        this.idFilesTxt = new JTextField();
        this.browseId = new JButton();
        this.clearId = new JButton();
        this.spectrumFilesLabel = new JLabel();
        this.spectrumFilesTxt = new JTextField();
        this.browseSpectra = new JButton();
        this.clearSpectra = new JButton();
        this.databaseLabel = new JLabel();
        this.fastaFileTxt = new JTextField();
        this.browseDbButton = new JButton();
        this.clearDbButton = new JButton();
        this.aboutButton = new JButton();
        this.peptideShakerPublicationLabel = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle("PeptideShaker - New Project");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NewDialog.this.formWindowClosing(evt);
            }
        });
        this.sampleDetailsPanel.setBackground(new Color(230, 230, 230));
        this.loadButton.setBackground(new Color(0, 153, 0));
        this.loadButton.setFont(this.loadButton.getFont().deriveFont(this.loadButton.getFont().getStyle() | 1));
        this.loadButton.setForeground(new Color(255, 255, 255));
        this.loadButton.setText("Load Data!");
        this.loadButton.setEnabled(false);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.loadButtonActionPerformed(evt);
            }
        });
        this.projectDetailsPanel.setBorder(BorderFactory.createTitledBorder("Project Details"));
        this.projectDetailsPanel.setOpaque(false);
        this.projectNameIdTxt.setHorizontalAlignment(0);
        this.projectNameIdTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                NewDialog.this.projectNameIdTxtKeyReleased(evt);
            }
        });
        this.projectReferenceLabel.setForeground(new Color(255, 0, 0));
        this.projectReferenceLabel.setText("Project Reference*");
        this.projectReferenceLabel.setToolTipText("A project name for future reference");
        this.typeCmb.setModel(new DefaultComboBoxModel<String>(ProjectType.getGuiOptions()));
        this.typeCmb.setToolTipText("Project type");
        GroupLayout projectDetailsPanelLayout = new GroupLayout(this.projectDetailsPanel);
        this.projectDetailsPanel.setLayout(projectDetailsPanelLayout);
        projectDetailsPanelLayout.setHorizontalGroup(projectDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(projectDetailsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.projectReferenceLabel, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectNameIdTxt, -1, 521, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.typeCmb, -2, 144, -2).addContainerGap()));
        projectDetailsPanelLayout.setVerticalGroup(projectDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(projectDetailsPanelLayout.createSequentialGroup().addContainerGap().addGroup(projectDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectNameIdTxt, -2, -1, -2).addComponent(this.projectReferenceLabel).addComponent(this.typeCmb, -2, -1, -2)).addContainerGap()));
        this.processingParametersPanel.setBorder(BorderFactory.createTitledBorder("Project Settings"));
        this.processingParametersPanel.setOpaque(false);
        this.projectSettingsTxt.setEditable(false);
        this.projectSettingsTxt.setHorizontalAlignment(0);
        this.projectSettingsTxt.setText("Default");
        this.projectSettingsLabel.setText("Project");
        this.identificationParametersLabel.setText("Identification");
        this.editSettingsButton.setText("Edit");
        this.editSettingsButton.setEnabled(false);
        this.editSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.editSettingsButtonActionPerformed(evt);
            }
        });
        this.projectSettingsButton.setText("Edit");
        this.projectSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.projectSettingsButtonActionPerformed(evt);
            }
        });
        this.processingLbl.setText("Processing");
        this.processingTxt.setEditable(false);
        this.processingTxt.setHorizontalAlignment(0);
        this.processingTxt.setText("Default");
        this.editProcessingButton.setText("Edit");
        this.editProcessingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.editProcessingButtonActionPerformed(evt);
            }
        });
        this.addSettingsButton.setText("Add");
        this.addSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.addSettingsButtonActionPerformed(evt);
            }
        });
        this.settingsComboBox.setMaximumRowCount(16);
        this.settingsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"-- Select --"}));
        this.settingsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.settingsComboBoxActionPerformed(evt);
            }
        });
        GroupLayout processingParametersPanelLayout = new GroupLayout(this.processingParametersPanel);
        this.processingParametersPanel.setLayout(processingParametersPanelLayout);
        processingParametersPanelLayout.setHorizontalGroup(processingParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(processingParametersPanelLayout.createSequentialGroup().addContainerGap().addGroup(processingParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(processingParametersPanelLayout.createSequentialGroup().addComponent(this.processingLbl, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(processingParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.processingTxt, -1, 519, Short.MAX_VALUE).addComponent(this.projectSettingsTxt, GroupLayout.Alignment.TRAILING))).addGroup(processingParametersPanelLayout.createSequentialGroup().addGroup(processingParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.projectSettingsLabel, GroupLayout.Alignment.LEADING, -1, 130, Short.MAX_VALUE).addComponent(this.identificationParametersLabel, GroupLayout.Alignment.LEADING, -1, 130, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.settingsComboBox, 0, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(processingParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.editProcessingButton, -1, -1, Short.MAX_VALUE).addComponent(this.projectSettingsButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(processingParametersPanelLayout.createSequentialGroup().addComponent(this.addSettingsButton, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.editSettingsButton, -2, 70, -2))).addContainerGap()));
        processingParametersPanelLayout.setVerticalGroup(processingParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(processingParametersPanelLayout.createSequentialGroup().addContainerGap().addGroup(processingParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.identificationParametersLabel).addComponent(this.editSettingsButton).addComponent(this.addSettingsButton).addComponent(this.settingsComboBox, -2, -1, -2)).addGap(0, 0, 0).addGroup(processingParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectSettingsLabel).addComponent(this.projectSettingsTxt, -2, -1, -2).addComponent(this.projectSettingsButton)).addGap(0, 0, 0).addGroup(processingParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.processingLbl).addComponent(this.processingTxt, -2, -1, -2).addComponent(this.editProcessingButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.inputFilesPanel.setBorder(BorderFactory.createTitledBorder("Input Files"));
        this.inputFilesPanel.setOpaque(false);
        this.idFilesLabel.setForeground(new Color(255, 0, 0));
        this.idFilesLabel.setText("Identification File(s)*");
        this.idFilesTxt.setEditable(false);
        this.idFilesTxt.setHorizontalAlignment(0);
        this.idFilesTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewDialog.this.idFilesTxtMouseClicked(evt);
            }
        });
        this.browseId.setText("Browse");
        this.browseId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.browseIdActionPerformed(evt);
            }
        });
        this.clearId.setText("Clear");
        this.clearId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.clearIdActionPerformed(evt);
            }
        });
        this.spectrumFilesLabel.setForeground(new Color(255, 0, 0));
        this.spectrumFilesLabel.setText("Spectrum File(s)*");
        this.spectrumFilesTxt.setEditable(false);
        this.spectrumFilesTxt.setHorizontalAlignment(0);
        this.spectrumFilesTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewDialog.this.spectrumFilesTxtMouseClicked(evt);
            }
        });
        this.browseSpectra.setText("Browse");
        this.browseSpectra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.browseSpectraActionPerformed(evt);
            }
        });
        this.clearSpectra.setText("Clear");
        this.clearSpectra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.clearSpectraActionPerformed(evt);
            }
        });
        this.databaseLabel.setForeground(new Color(255, 0, 0));
        this.databaseLabel.setText("Database File*");
        this.fastaFileTxt.setEditable(false);
        this.fastaFileTxt.setHorizontalAlignment(0);
        this.browseDbButton.setText("Browse");
        this.browseDbButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.browseDbButtonActionPerformed(evt);
            }
        });
        this.clearDbButton.setText("Clear");
        this.clearDbButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.clearDbButtonActionPerformed(evt);
            }
        });
        GroupLayout inputFilesPanelLayout = new GroupLayout(this.inputFilesPanel);
        this.inputFilesPanel.setLayout(inputFilesPanelLayout);
        inputFilesPanelLayout.setHorizontalGroup(inputFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputFilesPanelLayout.createSequentialGroup().addContainerGap().addGroup(inputFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, inputFilesPanelLayout.createSequentialGroup().addComponent(this.idFilesLabel, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.idFilesTxt).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.browseId).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearId)).addGroup(inputFilesPanelLayout.createSequentialGroup().addComponent(this.spectrumFilesLabel, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spectrumFilesTxt).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.browseSpectra).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearSpectra)).addGroup(inputFilesPanelLayout.createSequentialGroup().addComponent(this.databaseLabel, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fastaFileTxt).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.browseDbButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearDbButton))).addContainerGap()));
        inputFilesPanelLayout.linkSize(0, this.browseId, this.clearId);
        inputFilesPanelLayout.linkSize(0, this.browseSpectra, this.clearSpectra);
        inputFilesPanelLayout.linkSize(0, this.browseDbButton, this.clearDbButton);
        inputFilesPanelLayout.setVerticalGroup(inputFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputFilesPanelLayout.createSequentialGroup().addContainerGap().addGroup(inputFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.idFilesTxt, -2, -1, -2).addComponent(this.idFilesLabel).addComponent(this.clearId).addComponent(this.browseId)).addGap(0, 0, 0).addGroup(inputFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spectrumFilesLabel).addComponent(this.clearSpectra).addComponent(this.browseSpectra).addComponent(this.spectrumFilesTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(inputFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearDbButton).addComponent(this.browseDbButton).addComponent(this.fastaFileTxt, -2, -1, -2).addComponent(this.databaseLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.aboutButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/peptide-shaker-medium-orange-shadow.png")));
        this.aboutButton.setToolTipText("Open the PeptideShaker web page");
        this.aboutButton.setBorder(null);
        this.aboutButton.setBorderPainted(false);
        this.aboutButton.setContentAreaFilled(false);
        this.aboutButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                NewDialog.this.aboutButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                NewDialog.this.aboutButtonMouseExited(evt);
            }
        });
        this.aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewDialog.this.aboutButtonActionPerformed(evt);
            }
        });
        this.peptideShakerPublicationLabel.setText("<html>Please cite PeptideShaker as <a style=\"text-decoration: none\" href=\"https://www.nature.com/nbt/journal/v33/n1/full/nbt.3109.html\">Vaudel <i>et al.</i>: Nature Biotechnol. 2015 Jan;33(1):22\u201324</a>.</html>\n\n");
        this.peptideShakerPublicationLabel.setToolTipText("Open the PeptideShaker publication");
        this.peptideShakerPublicationLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NewDialog.this.peptideShakerPublicationLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                NewDialog.this.peptideShakerPublicationLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                NewDialog.this.peptideShakerPublicationLabelMouseExited(evt);
            }
        });
        GroupLayout sampleDetailsPanelLayout = new GroupLayout(this.sampleDetailsPanel);
        this.sampleDetailsPanel.setLayout(sampleDetailsPanelLayout);
        sampleDetailsPanelLayout.setHorizontalGroup(sampleDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sampleDetailsPanelLayout.createSequentialGroup().addContainerGap().addGroup(sampleDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sampleDetailsPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.aboutButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.peptideShakerPublicationLabel, -2, 527, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadButton, -2, 141, -2).addGap(22, 22, 22)).addComponent(this.projectDetailsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.inputFilesPanel, -1, -1, Short.MAX_VALUE).addComponent(this.processingParametersPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        sampleDetailsPanelLayout.setVerticalGroup(sampleDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sampleDetailsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.projectDetailsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputFilesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.processingParametersPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(sampleDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.aboutButton).addComponent(this.peptideShakerPublicationLabel, -2, 45, -2).addComponent(this.loadButton, -2, 53, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sampleDetailsPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sampleDetailsPanel, -2, -1, -2));
        this.pack();
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        if (this.validateUserInput()) {
            ArrayList<String> tips;
            if (this.welcomeDialog != null) {
                this.welcomeDialog.setVisible(false);
            }
            this.setVisible(false);
            this.peptideShakerGUI.setVisible(true);
            final ProjectType projectType = ProjectType.getProjectType((String)this.typeCmb.getSelectedItem().toString());
            this.peptideShakerGUI.setIdentificationParameters(this.identificationParameters);
            this.peptideShakerGUI.setProcessingParameters(this.processingParameters);
            this.peptideShakerGUI.setDisplayParameters(this.displayPreferences);
            this.projectDetails = new ProjectDetails();
            this.projectDetails.setCreationDate(new Date());
            this.projectDetails.setPeptideShakerVersion(new Properties().getVersion());
            this.projectDetails.setFastaFile(this.fastaFile);
            this.peptideShakerGUI.setProjectDetails(this.projectDetails);
            this.peptideShakerGUI.setCurentNotes(new ArrayList<String>());
            this.peptideShakerGUI.updateNotesNotificationCounter();
            this.peptideShakerGUI.resetDisplayFeaturesGenerator();
            this.peptideShakerGUI.setSpectrumCountingParameters(this.spectrumCountingPreferences);
            this.peptideShakerGUI.setMsFileHandler(this.msFileHandler);
            ProjectParameters projectParameters = new ProjectParameters(this.projectNameIdTxt.getText().trim());
            if (this.peptideShakerGUI.getUtilitiesUserParameters().isAutoUpdate()) {
                Util.sendGAUpdate((String)"UA-36198780-1", (String)"startrun-gui", (String)("peptide-shaker-" + PeptideShaker.getVersion()));
            }
            this.peptideShaker = new PeptideShaker(projectParameters);
            try {
                tips = Tips.getTips();
            }
            catch (Exception e) {
                tips = new ArrayList();
            }
            final WaitingDialog waitingDialog = new WaitingDialog((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true, tips, "Importing Data", "PeptideShaker", PeptideShaker.getVersion(), true);
            waitingDialog.setCloseDialogWhenImportCompletes(true, true);
            int progressCounter = this.idFiles.size() + this.spectrumFiles.size();
            ++progressCounter;
            ++progressCounter;
            ++progressCounter;
            progressCounter += 6;
            if (this.identificationParameters.getProteinInferenceParameters().getSimplifyGroups()) {
                ++progressCounter;
            }
            ++progressCounter;
            progressCounter += 4;
            progressCounter += 2;
            if (this.identificationParameters.getModificationLocalizationParameters().getAlignNonConfidentModifications()) {
                ++progressCounter;
            }
            waitingDialog.setMaxPrimaryProgressCounter(++progressCounter);
            waitingDialog.increasePrimaryProgressCounter();
            boolean needDialog = false;
            if (!this.idFiles.isEmpty()) {
                needDialog = true;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        WaitingDialogExceptionHandler exceptionHandler = new WaitingDialogExceptionHandler(waitingDialog, "https://github.com/compomics/peptide-shaker/issues");
                        try {
                            int outcome = NewDialog.this.peptideShaker.importFiles((WaitingHandler)waitingDialog, NewDialog.this.idFiles, (SpectrumProvider)NewDialog.this.msFileHandler, NewDialog.this.identificationParameters, NewDialog.this.projectDetails, NewDialog.this.processingParameters, (ExceptionHandler)exceptionHandler);
                            if (outcome == 0) {
                                NewDialog.this.peptideShaker.createProject(NewDialog.this.identificationParameters, NewDialog.this.processingParameters, NewDialog.this.spectrumCountingPreferences, (SpectrumProvider)NewDialog.this.msFileHandler, NewDialog.this.projectDetails, projectType, (WaitingHandler)waitingDialog, true, (ExceptionHandler)exceptionHandler);
                            } else {
                                waitingDialog.setRunCanceled();
                            }
                        }
                        catch (Exception e) {
                            exceptionHandler.catchException(e);
                            waitingDialog.setRunCanceled();
                            waitingDialog.setWaitingText("Failed to import data or create the project!");
                        }
                    }
                }, "Import data and create project").start();
            }
            if (needDialog) {
                try {
                    waitingDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                this.dispose();
            }
            if (!needDialog || !waitingDialog.isRunCanceled()) {
                this.peptideShakerGUI.setProject(projectParameters);
                this.peptideShakerGUI.setIdentification(this.peptideShaker.getIdentification());
                this.peptideShakerGUI.setMetrics(this.peptideShaker.getMetrics());
                this.peptideShakerGUI.setGeneMaps(this.peptideShaker.getGeneMaps());
                this.peptideShakerGUI.setProjectType(projectType);
                this.peptideShakerGUI.setSequenceProvider(this.peptideShaker.getSequenceProvider());
                this.peptideShakerGUI.setProteinDetailsProvider(this.peptideShaker.getProteinDetailsProvider());
                this.peptideShakerGUI.resetDisplayFeaturesGenerator();
                this.peptideShakerGUI.setIdentificationFeaturesGenerator(this.peptideShaker.getIdentificationFeaturesGenerator());
                this.peptideShakerGUI.displayResults();
                this.peptideShakerGUI.initiateDisplay();
                this.peptideShakerGUI.getProjectDetails().setReport(waitingDialog.getReport(null));
                this.dispose();
            } else if (waitingDialog.isRunCanceled()) {
                try {
                    this.peptideShaker.getIdentification().close(false);
                }
                catch (Exception e) {
                    System.out.println("Failed to close the database!");
                    e.printStackTrace();
                }
            }
        }
    }

    private void clearDbButtonActionPerformed(ActionEvent evt) {
        this.fastaFileTxt.setText("");
        this.validateInput();
    }

    private void browseDbButtonActionPerformed(ActionEvent evt) {
        File startLocation = this.fastaFile;
        if (startLocation == null && this.peptideShakerGUI.getUtilitiesUserParameters().getDbFolder() != null && this.peptideShakerGUI.getUtilitiesUserParameters().getDbFolder().exists()) {
            startLocation = this.peptideShakerGUI.getUtilitiesUserParameters().getDbFolder();
        }
        if (startLocation == null) {
            startLocation = new File(this.peptideShakerGUI.getLastSelectedFolder().getLastSelectedFolder());
        }
        JFileChooser fc = new JFileChooser(startLocation);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith("fasta") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "FASTA (.fasta)";
            }
        };
        fc.setFileFilter(filter);
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            this.fastaFile = fc.getSelectedFile();
            File folder = this.fastaFile.getParentFile();
            this.peptideShakerGUI.getUtilitiesUserParameters().setDbFolder(folder);
            this.peptideShakerGUI.getLastSelectedFolder().setLastSelectedFolder("fastaFile", folder.getAbsolutePath());
            this.fastaFileTxt.setText(this.fastaFile.getName());
            if (this.fastaFile.getName().contains(" ")) {
                JOptionPane.showMessageDialog(this, "Your FASTA file name contains white space and ougth to be renamed.", "File Name Warning", 2);
            }
        }
        this.validateInput();
    }

    private void clearSpectraActionPerformed(ActionEvent evt) {
        this.spectrumFiles = new ArrayList();
        this.spectrumFilesTxt.setText(this.spectrumFiles.size() + " file(s) selected");
        this.msFileHandler = new MsFileHandler();
        this.validateInput();
    }

    private void browseSpectraActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser(this.peptideShakerGUI.getLastSelectedFolder().getLastSelectedFolder());
        fileChooser.setDialogTitle("Select Spectrum File(s)");
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(true);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith(".mgf") || myFile.getName().toLowerCase().endsWith(".mgf.gz") || myFile.getName().toLowerCase().endsWith(".mzml") || myFile.getName().toLowerCase().endsWith(".mzml.gz") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "mgf or mzML (.mgf, .mg.gz, .mzml, .mzml.gz)";
            }
        };
        fileChooser.setFileFilter(filter);
        int returnVal = fileChooser.showDialog(this, "Add");
        if (returnVal == 0) {
            final ArrayList<File> selectedFiles = new ArrayList<File>();
            for (File newFile : fileChooser.getSelectedFiles()) {
                if (newFile.isDirectory()) {
                    File[] tempFiles;
                    for (File file : tempFiles = newFile.listFiles()) {
                        if (!file.getName().toLowerCase().endsWith(".mgf") && !file.getName().toLowerCase().endsWith(".mgf.gz") && !file.getName().toLowerCase().endsWith(".mzml") && !file.getName().toLowerCase().endsWith(".mzml.gz")) continue;
                        selectedFiles.add(file);
                    }
                    continue;
                }
                selectedFiles.add(newFile);
            }
            this.progressDialog = new ProgressDialogX((JDialog)this, (Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.progressDialog.setTitle("Loading Files. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        NewDialog.this.progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("loadingThread"){

                @Override
                public void run() {
                    boolean allLoaded = true;
                    for (File file : selectedFiles) {
                        try {
                            File folder = CmsFolder.getParentFolder() == null ? file.getParentFile() : new File(CmsFolder.getParentFolder());
                            NewDialog.this.msFileHandler.register(file, folder, (WaitingHandler)NewDialog.this.progressDialog);
                        }
                        catch (Exception e) {
                            NewDialog.this.progressDialog.setRunCanceled();
                            allLoaded = false;
                            JOptionPane.showMessageDialog(null, "An error occurred while reading the following file.\n" + file.getAbsolutePath() + "\n\nError:\n" + e.getLocalizedMessage(), "File error", 0);
                            e.printStackTrace();
                        }
                    }
                    NewDialog.this.progressDialog.setRunFinished();
                    if (allLoaded) {
                        NewDialog.this.spectrumFiles.addAll(selectedFiles);
                        NewDialog.this.spectrumFilesTxt.setText(NewDialog.this.spectrumFiles.size() + " file(s) selected");
                        NewDialog.this.validateInput();
                    }
                }
            }.start();
        }
    }

    private void clearIdActionPerformed(ActionEvent evt) {
        this.idFiles = new ArrayList();
        this.idFilesTxt.setText(this.idFiles.size() + " file(s) selected");
        this.validateInput();
    }

    private void browseIdActionPerformed(ActionEvent evt) {
        final JFileChooser fileChooser = new JFileChooser(this.peptideShakerGUI.getLastSelectedFolder().getLastSelectedFolder());
        fileChooser.setDialogTitle("Select Identification File(s)");
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(true);
        FileFilter allFilter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                if (myFile.getName().equalsIgnoreCase("mods.xml") || myFile.getName().equalsIgnoreCase("usermods.xml")) {
                    return false;
                }
                String fileName = myFile.getName().toLowerCase();
                return fileName.endsWith(".omx") || fileName.endsWith(".t.xml") || fileName.endsWith(".pep.xml") || fileName.endsWith(".dat") || fileName.endsWith(".mzid") || fileName.endsWith(".ms-amanda.csv") || fileName.endsWith(".res") || fileName.endsWith(".tide-search.target.txt") || fileName.endsWith(".tags") || fileName.endsWith(".pnovo.txt") || fileName.endsWith(".novor.csv") || fileName.endsWith(".coss.tsv") || fileName.endsWith(".sage.tsv") || fileName.endsWith(".psm") || fileName.endsWith(".omx.gz") || fileName.endsWith(".t.xml.gz") || fileName.endsWith(".pep.xml.gz") || fileName.endsWith(".mzid.gz") || fileName.endsWith(".ms-amanda.csv.gz") || fileName.endsWith(".res.gz") || fileName.endsWith(".tide-search.target.txt.gz") || fileName.endsWith(".tags.gz") || fileName.endsWith(".pnovo.txt.gz") || fileName.endsWith(".novor.csv.gz") || fileName.endsWith(".coss.tsv.gz") || fileName.endsWith(".sage.tsv.gz") || fileName.endsWith(".psm.gz") || fileName.endsWith(".zip") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "All supported search result output formats";
            }
        };
        FileFilter zipFilter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                String fileName = myFile.getName().toLowerCase();
                return fileName.endsWith(".zip") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Compressed zip folder (.zip)";
            }
        };
        FileFilter omssaFilter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                String fileName = myFile.getName().toLowerCase();
                return fileName.endsWith(".omx") || fileName.endsWith(".omx.gz") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "OMSSA (.omx, .omx.gz)";
            }
        };
        FileFilter andromedaFilter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                String fileName = myFile.getName().toLowerCase();
                return fileName.endsWith(".res") || fileName.endsWith(".res.gz") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Andromeda (.res, .res.gz)";
            }
        };
        FileFilter tandemFilter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                String fileName = myFile.getName().toLowerCase();
                return fileName.endsWith(".t.xml") || fileName.endsWith(".t.xml.gz") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "X! Tandem (.t.xml, .t.xml.gz)";
            }
        };
        FileFilter pepXMLFilter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                String fileName = myFile.getName().toLowerCase();
                return fileName.endsWith(".pep.xml") || fileName.endsWith(".pep.xml.gz") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "PepXML (.pep.xml, .pep.xml.gz)";
            }
        };
        FileFilter mzidFilter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                String fileName = myFile.getName().toLowerCase();
                return fileName.endsWith(".mzid") || fileName.endsWith(".mzid.gz") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "mzIdentML (.mzid, .mzid.gz)";
            }
        };
        FileFilter msAmandaFilter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                String fileName = myFile.getName().toLowerCase();
                return fileName.endsWith(".csv") || fileName.endsWith(".csv.gz") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "MS Amanda (.ms-amanda.csv, .ms-amanda.csv.gz)";
            }
        };
        FileFilter tideFilter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                String fileName = myFile.getName().toLowerCase();
                return fileName.endsWith(".tide-search.target.txt") || fileName.endsWith(".tide-search.target.txt.gz") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Tide (.tide-search.target.txt, .tide-search.target.txt.gz)";
            }
        };
        FileFilter direcTagFilter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                String fileName = myFile.getName().toLowerCase();
                return fileName.endsWith(".tags") || fileName.endsWith(".tags.gz") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "DirecTag (.tags, .tags.gz)";
            }
        };
        FileFilter pNovoFilter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                String fileName = myFile.getName().toLowerCase();
                return fileName.endsWith(".pnovo.txt") || fileName.endsWith(".pnovo.txt.gz") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "pNovo+ (.pnovo.txt, .pnovo.txt.gz)";
            }
        };
        FileFilter novorFilter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                String fileName = myFile.getName().toLowerCase();
                return fileName.endsWith(".novor.csv") || fileName.endsWith(".novor.csv.gz") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Novor (.novor.csv, .novor.csv.gz)";
            }
        };
        FileFilter cossFilter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                String fileName = myFile.getName().toLowerCase();
                return fileName.endsWith(".coss.tsv") || fileName.endsWith(".coss.tsv.gz") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "COSS (.coss.tsv, .coss.tsv.gz)";
            }
        };
        FileFilter sageFilter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                String fileName = myFile.getName().toLowerCase();
                return fileName.endsWith(".sage.tsv") || fileName.endsWith(".sage.tsv.gz") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Sage (.sage.tsv, .sage.tsv.gz)";
            }
        };
        FileFilter onyaseFilter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                String fileName = myFile.getName().toLowerCase();
                return fileName.endsWith(".psm") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Onyase (.psm)";
            }
        };
        FileFilter mascotFilter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                String fileName = myFile.getName().toLowerCase();
                return fileName.endsWith(".dat") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Mascot (.dat)";
            }
        };
        fileChooser.setFileFilter(allFilter);
        fileChooser.addChoosableFileFilter(zipFilter);
        fileChooser.addChoosableFileFilter(pepXMLFilter);
        fileChooser.addChoosableFileFilter(mzidFilter);
        fileChooser.addChoosableFileFilter(omssaFilter);
        fileChooser.addChoosableFileFilter(andromedaFilter);
        fileChooser.addChoosableFileFilter(tandemFilter);
        fileChooser.addChoosableFileFilter(msAmandaFilter);
        fileChooser.addChoosableFileFilter(tideFilter);
        fileChooser.addChoosableFileFilter(mascotFilter);
        fileChooser.addChoosableFileFilter(onyaseFilter);
        fileChooser.addChoosableFileFilter(direcTagFilter);
        fileChooser.addChoosableFileFilter(novorFilter);
        fileChooser.addChoosableFileFilter(pNovoFilter);
        fileChooser.addChoosableFileFilter(cossFilter);
        fileChooser.addChoosableFileFilter(sageFilter);
        int returnVal = fileChooser.showDialog(this, "Add");
        if (returnVal == 0) {
            this.progressDialog = new ProgressDialogX((JDialog)this, (Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.progressDialog.setTitle("Loading Files. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        NewDialog.this.progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("importThread"){

                @Override
                public void run() {
                    NewDialog.this.loadIdInputFiles(fileChooser.getSelectedFiles());
                }
            }.start();
        }
    }

    private void editSettingsButtonActionPerformed(ActionEvent evt) {
        IdentificationParametersEditionDialog identificationParametersEditionDialog = new IdentificationParametersEditionDialog((Dialog)this, (Frame)this.peptideShakerGUI, this.identificationParameters, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), this.peptideShakerGUI.getLastSelectedFolder(), true);
        if (!identificationParametersEditionDialog.isCanceled()) {
            this.setIdentificationParameters(identificationParametersEditionDialog.getIdentificationParameters());
        }
    }

    private void projectSettingsButtonActionPerformed(ActionEvent evt) {
        ProjectParametersDialog preferencesDialog = new ProjectParametersDialog((Frame)this.peptideShakerGUI, this.spectrumCountingPreferences, this.displayPreferences);
        if (!preferencesDialog.isCanceled()) {
            this.spectrumCountingPreferences = preferencesDialog.getSpectrumCountingParameters();
            this.displayPreferences = preferencesDialog.getDisplayParameters();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.dispose();
    }

    private void projectNameIdTxtKeyReleased(KeyEvent evt) {
        this.validateInput();
    }

    private void editProcessingButtonActionPerformed(ActionEvent evt) {
        ProcessingParametersDialog processingPreferencesDialog = new ProcessingParametersDialog((Dialog)this, (Frame)this.peptideShakerGUI, this.processingParameters, true);
        if (!processingPreferencesDialog.isCanceled()) {
            this.processingParameters = processingPreferencesDialog.getProcessingParameters();
            this.processingTxt.setText(this.processingParameters.getnThreads() + " cores");
        }
    }

    private void aboutButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void aboutButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void aboutButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://compomics.github.io/projects/peptide-shaker.html");
        this.setCursor(new Cursor(0));
    }

    private void peptideShakerPublicationLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://www.nature.com/nbt/journal/v33/n1/full/nbt.3109.html");
        this.setCursor(new Cursor(0));
    }

    private void peptideShakerPublicationLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void peptideShakerPublicationLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void idFilesTxtMouseClicked(MouseEvent evt) {
        FileDisplayDialog fileDisplayDialog;
        if (!this.idFiles.isEmpty() && !(fileDisplayDialog = new FileDisplayDialog((JDialog)this, this.idFiles, true)).canceled()) {
            this.idFiles = fileDisplayDialog.getSelectedFiles();
            this.idFilesTxt.setText(this.idFiles.size() + " file(s) selected");
            this.validateInput();
        }
    }

    private void spectrumFilesTxtMouseClicked(MouseEvent evt) {
        FileDisplayDialog fileDisplayDialog;
        if (!this.spectrumFiles.isEmpty() && !(fileDisplayDialog = new FileDisplayDialog((JDialog)this, this.spectrumFiles, true)).canceled()) {
            final ArrayList selectedFiles = fileDisplayDialog.getSelectedFiles();
            this.progressDialog = new ProgressDialogX((JDialog)this, (Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.progressDialog.setTitle("Loading Files. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        NewDialog.this.progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("loadingThread"){

                @Override
                public void run() {
                    boolean allLoaded = true;
                    for (File file : selectedFiles) {
                        try {
                            File folder = CmsFolder.getParentFolder() == null ? file.getParentFile() : new File(CmsFolder.getParentFolder());
                            NewDialog.this.msFileHandler.register(file, folder, (WaitingHandler)NewDialog.this.progressDialog);
                        }
                        catch (Exception e) {
                            NewDialog.this.progressDialog.setRunCanceled();
                            allLoaded = false;
                            JOptionPane.showMessageDialog(null, "An error occurred while reading the following file.\n" + file.getAbsolutePath() + "\n\nError:\n" + e.getLocalizedMessage(), "File error", 0);
                            e.printStackTrace();
                        }
                    }
                    NewDialog.this.progressDialog.setRunFinished();
                    if (allLoaded) {
                        NewDialog.this.spectrumFilesTxt.setText(NewDialog.this.spectrumFiles.size() + " file(s) selected");
                        NewDialog.this.validateInput();
                    }
                }
            }.start();
        }
    }

    private void addSettingsButtonActionPerformed(ActionEvent evt) {
        IdentificationParametersEditionDialog identificationParametersEditionDialog = new IdentificationParametersEditionDialog((Dialog)this, (Frame)this.peptideShakerGUI, null, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), this.peptideShakerGUI.getLastSelectedFolder(), true);
        if (!identificationParametersEditionDialog.isCanceled()) {
            this.setIdentificationParameters(identificationParametersEditionDialog.getIdentificationParameters());
        }
    }

    private void settingsComboBoxActionPerformed(ActionEvent evt) {
        this.editSettingsButton.setEnabled(this.settingsComboBox.getSelectedIndex() != 0);
        if (this.settingsComboBox.getSelectedIndex() != 0) {
            File identificationParametersFile = IdentificationParametersFactory.getIdentificationParametersFile((String)((String)this.settingsComboBox.getSelectedItem()));
            try {
                if (!IdentificationParameters.supportedVersion((File)identificationParametersFile)) {
                    JOptionPane.showMessageDialog(null, "The identification parameters were generated using an older version, please update the parameters.", "File error", 0);
                } else {
                    this.identificationParameters = IdentificationParameters.getIdentificationParameters((File)identificationParametersFile);
                    String error = PeptideShaker.loadModifications(this.identificationParameters.getSearchParameters());
                    if (error != null) {
                        JOptionPane.showMessageDialog(this.peptideShakerGUI, error, "Modification Definition Changed", 2);
                    }
                    this.setIdentificationParameters(this.identificationParameters);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Failed to import search parameters from: " + identificationParametersFile.getAbsolutePath() + ".", "Search Parameters", 2);
                e.printStackTrace();
            }
        }
        this.validateInput();
    }

    private void validateInput() {
        boolean allValid = true;
        if (this.projectNameIdTxt.getText().length() > 0) {
            this.projectReferenceLabel.setForeground(Color.BLACK);
            this.projectReferenceLabel.setToolTipText(null);
            this.projectNameIdTxt.setToolTipText(null);
        } else {
            this.projectReferenceLabel.setForeground(Color.RED);
            this.projectReferenceLabel.setToolTipText("Please provide a project reference");
            this.projectNameIdTxt.setToolTipText("Please provide a project reference");
            allValid = false;
        }
        if (this.idFiles.size() > 0) {
            this.idFilesLabel.setForeground(Color.BLACK);
            this.idFilesLabel.setToolTipText(null);
            this.idFilesTxt.setToolTipText("Click to see the selected files");
            this.idFilesTxt.setCursor(new Cursor(12));
        } else {
            this.idFilesLabel.setForeground(Color.RED);
            this.idFilesLabel.setToolTipText("Please select at least one identification file");
            this.idFilesTxt.setToolTipText("Please select at least one identification file");
            this.idFilesTxt.setCursor(new Cursor(0));
            allValid = false;
        }
        if (this.spectrumFiles.size() > 0) {
            this.spectrumFilesLabel.setForeground(Color.BLACK);
            this.spectrumFilesLabel.setToolTipText(null);
            this.spectrumFilesTxt.setToolTipText("Click to see the selected files");
            this.spectrumFilesTxt.setCursor(new Cursor(12));
        } else {
            this.spectrumFilesLabel.setForeground(Color.RED);
            this.spectrumFilesLabel.setToolTipText("Please select the spectrum file(s) for the identfication files");
            this.spectrumFilesTxt.setToolTipText("Please select the spectrum file(s) for the identfication files");
            this.spectrumFilesTxt.setCursor(new Cursor(0));
            allValid = false;
        }
        if (this.fastaFileTxt.getText() != null && this.fastaFileTxt.getText().length() > 0 && this.fastaFile != null && this.fastaFile.exists()) {
            this.databaseLabel.setForeground(Color.BLACK);
            this.databaseLabel.setToolTipText(null);
            this.fastaFileTxt.setToolTipText(null);
        } else {
            this.databaseLabel.setForeground(Color.RED);
            if (this.fastaFileTxt.getText().length() > 0) {
                this.databaseLabel.setToolTipText("FASTA file not found!");
                this.fastaFileTxt.setToolTipText("FASTA file not found!");
            } else {
                this.databaseLabel.setToolTipText("Please select the database file used");
                this.fastaFileTxt.setToolTipText("Please select the database file used");
            }
            allValid = false;
        }
        if (this.identificationParameters != null && this.settingsComboBox.getSelectedIndex() != 0) {
            this.identificationParametersLabel.setForeground(Color.BLACK);
            this.identificationParametersLabel.setToolTipText(null);
            this.settingsComboBox.setToolTipText(null);
        } else {
            this.identificationParametersLabel.setForeground(Color.RED);
            this.identificationParametersLabel.setToolTipText("Please set the identification parameters");
            this.settingsComboBox.setToolTipText("Please set the identification parameters");
            allValid = false;
        }
        this.loadButton.setEnabled(allValid);
    }

    private boolean validateUserInput() {
        for (String forbiddenChar : Util.FORBIDDEN_CHARACTERS) {
            if (!this.projectNameIdTxt.getText().contains(forbiddenChar)) continue;
            JOptionPane.showMessageDialog(null, "The project name should not contain " + forbiddenChar + ".\nForbidden character in project name", "Input Error", 0);
            this.projectReferenceLabel.setForeground(Color.red);
            return false;
        }
        if (this.identificationParameters == null) {
            JOptionPane.showMessageDialog(null, "Please edit the search parameters.", "Input Error", 0);
            return false;
        }
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        if (searchParameters == null) {
            JOptionPane.showMessageDialog(null, "Please edit the search parameters.", "Input Error", 0);
            return false;
        }
        if (this.fastaFile == null) {
            JOptionPane.showMessageDialog(null, "Please verify the input for FASTA file.", "Input Error", 0);
            this.databaseLabel.setForeground(Color.RED);
            return false;
        }
        return true;
    }

    public void importSearchParameters(File file, ArrayList<File> dataFolders, ProgressDialogX progressDialog) throws IOException, FileNotFoundException, ClassNotFoundException {
        boolean matchesValidationAdded;
        ValidationQcParameters validationQcParameters;
        progressDialog.setTitle("Importing Search Parameters. Please Wait...");
        IdentificationParameters tempIdentificationParameters = IdentificationParameters.getIdentificationParameters((File)file);
        SearchParameters searchParameters = tempIdentificationParameters.getSearchParameters();
        String toCheck = PeptideShaker.loadModifications(searchParameters);
        if (toCheck != null) {
            JOptionPane.showMessageDialog(this, toCheck, "Modification Definition Changed", 2);
        }
        ModificationParameters modificationProfile = searchParameters.getModificationParameters();
        ArrayList<String> missing = new ArrayList<String>();
        for (String name : modificationProfile.getAllModifications()) {
            if (!this.modificationFactory.containsModification(name)) {
                missing.add(name);
                Modification mod = this.modificationFactory.getModification(name);
                mod.getMass();
                continue;
            }
            if (modificationProfile.contains(name)) continue;
            modificationProfile.setColor(name, Color.lightGray.getRGB());
        }
        if (!missing.isEmpty()) {
            if (missing.size() == 1) {
                JOptionPane.showMessageDialog(this, "The following modification is currently not recognized by PeptideShaker: " + (String)missing.get(0) + ".\nPlease import it by editing the search parameters.", "Modification Not Found", 2);
            } else {
                String output = "The following modifications are currently not recognized by PeptideShaker:\n" + String.join((CharSequence)", ", missing) + ".\nPlease import it by editing the search parameters.";
                JOptionPane.showMessageDialog(this, output, "Modification Not Found", 2);
            }
        }
        if ((validationQcParameters = tempIdentificationParameters.getIdValidationParameters().getValidationQCParameters()) == null || validationQcParameters.getPsmFilters() == null || validationQcParameters.getPeptideFilters() == null || validationQcParameters.getProteinFilters() == null || validationQcParameters.getPsmFilters().isEmpty() && validationQcParameters.getPeptideFilters().isEmpty() && validationQcParameters.getProteinFilters().isEmpty()) {
            MatchesValidator.setDefaultMatchesQCFilters(validationQcParameters);
            matchesValidationAdded = true;
        } else {
            matchesValidationAdded = false;
        }
        if (!this.identificationParametersFactory.getParametersList().contains(tempIdentificationParameters.getName())) {
            this.identificationParametersFactory.addIdentificationParameters(tempIdentificationParameters);
        } else {
            boolean parametersChanged;
            boolean bl = parametersChanged = !this.identificationParametersFactory.getIdentificationParameters(tempIdentificationParameters.getName()).equals(tempIdentificationParameters);
            if (parametersChanged && !matchesValidationAdded) {
                int value = JOptionPane.showOptionDialog(null, "A settings file with the name '" + tempIdentificationParameters.getName() + "' already exists.\nWhat do you want to do?", "Identification Settings", 1, 3, null, new String[]{"Replace File", "Use Existing File", "Keep Both Files"}, "default");
                switch (value) {
                    case 0: {
                        this.identificationParametersFactory.addIdentificationParameters(tempIdentificationParameters);
                        break;
                    }
                    case 1: {
                        tempIdentificationParameters = this.identificationParametersFactory.getIdentificationParameters(tempIdentificationParameters.getName());
                        break;
                    }
                    case 2: {
                        tempIdentificationParameters.setName(this.getIdentificationSettingsFileName(tempIdentificationParameters));
                        this.identificationParametersFactory.addIdentificationParameters(tempIdentificationParameters);
                        break;
                    }
                }
            } else if (matchesValidationAdded) {
                this.identificationParametersFactory.addIdentificationParameters(tempIdentificationParameters);
            }
        }
        this.setIdentificationParameters(tempIdentificationParameters);
    }

    private String getIdentificationSettingsFileName(IdentificationParameters tempIdentificationParameters) {
        String name = tempIdentificationParameters.getName();
        int counter = 2;
        String currentName = name;
        while (this.identificationParametersFactory.getParametersList().contains(currentName) && !this.identificationParametersFactory.getIdentificationParameters(currentName).equals(tempIdentificationParameters)) {
            currentName = name + "_" + counter++;
        }
        return currentName;
    }

    private ArrayList<String> getFastaAndSpectrumFiles(ArrayList<File> searchguiInputFiles) {
        ArrayList<String> result = new ArrayList<String>();
        for (File searchGuiInputFile : searchguiInputFiles) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(searchGuiInputFile));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).equals("") || result.contains(line = System.getProperty("os.name").lastIndexOf("Windows") == -1 ? line.replaceAll("\\\\", "/") : line.replaceAll("/", "\\\\"))) continue;
                    result.add(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private void loadFastaAndSpectrumFiles(ArrayList<File> inputFiles, ArrayList<File> dataFolders) {
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Loading Spectrum Files. Please Wait...");
        ArrayList<String> neededFastaAndSpectrumFiles = this.getFastaAndSpectrumFiles(inputFiles);
        String missing = "";
        int nMissingSpectrumFiles = 0;
        boolean fastaFileFound = false;
        String tempFastaFile = null;
        HashSet<String> spectrumFileNames = new HashSet<String>();
        for (File file : this.spectrumFiles) {
            spectrumFileNames.add(file.getName());
        }
        int cpt = 0;
        int total = neededFastaAndSpectrumFiles.size() - 1;
        block5: for (String path : neededFastaAndSpectrumFiles) {
            if (path.toLowerCase().endsWith(".mgf") || path.toLowerCase().endsWith(".mgf.gz") || path.toLowerCase().endsWith(".mzml") || path.toLowerCase().endsWith(".mzml.gz")) {
                this.progressDialog.setTitle("Loading Spectrum Files (" + ++cpt + " of " + total + "). Please Wait...");
                File tempSpectrumFile = new File(path);
                String spectrumFileName = tempSpectrumFile.getName();
                if (spectrumFileNames.contains(tempSpectrumFile.getName())) continue;
                boolean loaded = false;
                if (tempSpectrumFile.exists()) {
                    try {
                        File folder = CmsFolder.getParentFolder() == null ? tempSpectrumFile.getParentFile() : new File(CmsFolder.getParentFolder());
                        this.msFileHandler.register(tempSpectrumFile, folder, (WaitingHandler)this.progressDialog);
                        loaded = true;
                        this.spectrumFiles.add(tempSpectrumFile);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (loaded) continue;
                for (File folder : dataFolders) {
                    File[] fileArray = folder.listFiles();
                    int n = fileArray.length;
                    for (int i = 0; i < n; ++i) {
                        File file = fileArray[i];
                        if (!file.getName().equals(spectrumFileName)) continue;
                        try {
                            folder = CmsFolder.getParentFolder() == null ? file.getParentFile() : new File(CmsFolder.getParentFolder());
                            this.msFileHandler.register(file, folder, (WaitingHandler)this.progressDialog);
                            loaded = true;
                            this.spectrumFiles.add(file);
                            break;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    if (!loaded) continue;
                    break;
                }
                if (loaded) continue;
                ++nMissingSpectrumFiles;
                missing = missing + tempSpectrumFile.getName() + "\n";
                continue;
            }
            if (!path.toLowerCase().endsWith(".fasta")) continue;
            tempFastaFile = path;
            File providedFastaFile = new File(tempFastaFile);
            if (providedFastaFile.exists()) {
                this.fastaFile = providedFastaFile;
                this.fastaFileTxt.setText(this.fastaFile.getName());
                fastaFileFound = true;
                continue;
            }
            boolean found = false;
            for (File folder : dataFolders) {
                for (File tempFile : folder.listFiles()) {
                    if (!tempFile.getName().equals(providedFastaFile.getName())) continue;
                    this.fastaFile = tempFile;
                    this.fastaFileTxt.setText(this.fastaFile.getName());
                    found = true;
                    break;
                }
                if (!found) continue;
                continue block5;
            }
        }
        if (this.fastaFile == null && !fastaFileFound && tempFastaFile != null) {
            JOptionPane.showMessageDialog(this, "FASTA file not found:\n" + tempFastaFile + "\nPlease locate it manually.", "FASTA File Not Found", 2);
        }
        if (nMissingSpectrumFiles > 0) {
            if (nMissingSpectrumFiles < 11) {
                JOptionPane.showMessageDialog(this, "Spectrum file(s) not found:\n" + missing + "\nPlease locate it/them manually.", "Spectrum File(s) Not Found", 2);
            } else {
                JOptionPane.showMessageDialog(this, "Spectrum files not found.\nPlease locate them manually.", "Spectrum File Not Found", 2);
            }
        }
        this.spectrumFilesTxt.setText(this.spectrumFiles.size() + " file(s) selected");
    }

    public void checkFastaFile() {
        FastaParameters fastaParameters = this.identificationParameters.getFastaParameters();
        try {
            FastaSummary fastaSummary = FastaSummary.getSummary((String)this.fastaFile.getAbsolutePath(), (FastaParameters)fastaParameters, (WaitingHandler)this.progressDialog);
            Integer nUniprot = (Integer)fastaSummary.databaseType.get(ProteinDatabase.UniProt);
            int total = fastaSummary.databaseType.values().stream().mapToInt(a -> a).sum();
            if (nUniprot == null || (double)nUniprot.intValue() / (double)total < 0.4) {
                this.showDataBaseHelpDialog();
            }
            if (!fastaParameters.isTargetDecoy()) {
                JOptionPane.showMessageDialog(this, "PeptideShaker validation requires the use of a taget-decoy database.\nSome features will be limited if using other types of databases.\n\nNote that using Automatic Decoy Search in Mascot is not supported.\n\nSee the PeptideShaker home page for details.", "No Decoys Found", 1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "An error occurred while parsing the fasta file.", "Error while parsing the file", 1);
        }
    }

    private void showDataBaseHelpDialog() {
        JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane((String)"We strongly recommend the use of UniProt databases. Some<br>features will be limited if using other databases.<br><br>See <a href=\"https://compomics.github.io/projects/searchgui/wiki/DatabaseHelp.html\">Database Help</a> for details."), "Database Information", 2);
    }

    private void setIdentificationParameters(IdentificationParameters newIdentificationParameters) {
        try {
            ValidationQcParameters validationQcParameters = newIdentificationParameters.getIdValidationParameters().getValidationQCParameters();
            if (validationQcParameters == null || validationQcParameters.getPsmFilters() == null || validationQcParameters.getPeptideFilters() == null || validationQcParameters.getProteinFilters() == null || validationQcParameters.getPsmFilters().isEmpty() && validationQcParameters.getPeptideFilters().isEmpty() && validationQcParameters.getProteinFilters().isEmpty()) {
                MatchesValidator.setDefaultMatchesQCFilters(validationQcParameters);
                this.identificationParametersFactory.addIdentificationParameters(newIdentificationParameters);
            }
            this.identificationParameters = newIdentificationParameters;
            Vector<String> parameterList = new Vector<String>();
            parameterList.add("-- Select --");
            for (String tempParameters : this.identificationParametersFactory.getParametersList()) {
                parameterList.add(tempParameters);
            }
            this.settingsComboBox.setModel(new DefaultComboBoxModel(parameterList));
            this.settingsComboBox.setSelectedItem(this.identificationParameters.getName());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Failed to import identification parameters from: " + newIdentificationParameters.getName() + ".", "Identification Parameters", 2);
            e.printStackTrace();
            this.identificationParameters = null;
        }
        this.validateInput();
    }

    @Override
    public void setIconImage(Image image) {
        super.setIconImage(image);
        if (this.welcomeDialog != null) {
            this.welcomeDialog.setIconImage(image);
        }
    }

    private void loadIdInputFiles(File[] selectedFiles) {
        HashMap<String, File> parameterFiles = new HashMap<String, File>();
        ArrayList<File> dataFolders = new ArrayList<File>();
        ArrayList<File> inputFiles = new ArrayList<File>();
        boolean loadCanceled = false;
        for (File newFile : selectedFiles) {
            if (newFile.isDirectory()) {
                File[] tempFiles;
                File dataFolder;
                if (!dataFolders.contains(newFile)) {
                    dataFolders.add(newFile);
                }
                if ((dataFolder = new File(newFile, PeptideShaker.DATA_DIRECTORY)).exists() && !dataFolders.contains(dataFolder)) {
                    dataFolders.add(dataFolder);
                }
                for (File file : tempFiles = newFile.listFiles()) {
                    String lowerCaseName = file.getName().toLowerCase();
                    if (lowerCaseName.endsWith(".zip")) {
                        boolean bl = loadCanceled = !this.loadZipFile(file, parameterFiles, dataFolders, inputFiles);
                        if (!loadCanceled) continue;
                        break;
                    }
                    this.loadIdFile(file, parameterFiles, inputFiles);
                }
            } else {
                String lowerCaseName;
                File dataFolder;
                File parentFolder = newFile.getParentFile();
                if (!dataFolders.contains(parentFolder)) {
                    dataFolders.add(parentFolder);
                }
                if ((dataFolder = new File(parentFolder, PeptideShaker.DATA_DIRECTORY)).exists() && !dataFolders.contains(dataFolder)) {
                    dataFolders.add(dataFolder);
                }
                if ((lowerCaseName = newFile.getName().toLowerCase()).endsWith(".zip")) {
                    boolean bl = loadCanceled = !this.loadZipFile(newFile, parameterFiles, dataFolders, inputFiles);
                    if (loadCanceled) {
                        break;
                    }
                } else {
                    this.loadIdFile(newFile, parameterFiles, inputFiles);
                }
                for (File file : newFile.getParentFile().listFiles()) {
                    String name = file.getName();
                    if (name.equals(SEARCHGUI_INPUT)) {
                        inputFiles.add(file);
                    } else if (name.toLowerCase().endsWith(".par")) {
                        parameterFiles.put(name, file);
                    }
                    if (!file.getName().endsWith("usermods.xml")) continue;
                    this.modificationFiles.add(file);
                }
            }
            this.peptideShakerGUI.getLastSelectedFolder().setLastSelectedFolder(newFile.getAbsolutePath());
            if (loadCanceled) break;
        }
        if (!loadCanceled) {
            File parameterFile = null;
            ArrayList names = new ArrayList(parameterFiles.keySet());
            if (parameterFiles.size() == 1) {
                ArrayList fileNames = new ArrayList(parameterFiles.keySet());
                parameterFile = (File)parameterFiles.get(fileNames.get(0));
            } else if (parameterFiles.size() > 1) {
                boolean equalParameters = true;
                try {
                    IdentificationParameters identificationParameters0 = IdentificationParameters.getIdentificationParameters((File)((File)parameterFiles.get(names.get(0))));
                    for (int i = 1; i < names.size(); ++i) {
                        IdentificationParameters identificationParametersI = IdentificationParameters.getIdentificationParameters((File)parameterFiles.get(names.get(i)));
                        if (identificationParameters0.equals(identificationParametersI)) continue;
                        equalParameters = false;
                        break;
                    }
                }
                catch (IOException e) {
                    equalParameters = false;
                }
                if (equalParameters) {
                    parameterFile = (File)parameterFiles.get(names.get(0));
                } else {
                    this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                    ArrayList<File> parameterFilesList = new ArrayList<File>(parameterFiles.values());
                    FileSelectionDialog fileSelection = new FileSelectionDialog((JDialog)this, parameterFilesList, "Select the wanted SearchGUI parameters file.");
                    if (!fileSelection.isCanceled()) {
                        parameterFile = fileSelection.getSelectedFile();
                    }
                    this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")));
                }
            }
            this.loadFastaAndSpectrumFiles(inputFiles, dataFolders);
            this.idFilesTxt.setText(this.idFiles.size() + " file(s) selected");
            if (parameterFile != null) {
                try {
                    if (!IdentificationParameters.supportedVersion((File)parameterFile)) {
                        JOptionPane.showMessageDialog(null, "The parameters were generated using an older version. Please update the parameters.", "Outdated Parameters", 2);
                    } else {
                        this.importSearchParameters(parameterFile, dataFolders, this.progressDialog);
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Error occurred while reading " + parameterFile + ". Please verify the search parameters.", "File Error", 0);
                    e.printStackTrace();
                }
            }
            if (this.fastaFile != null) {
                this.fastaFileTxt.setText(this.fastaFile.getName());
            }
            this.progressDialog.setRunFinished();
            this.validateInput();
        } else {
            this.progressDialog.setRunFinished();
            this.validateInput();
        }
    }

    private boolean loadZipFile(File file, HashMap<String, File> parameterFiles, ArrayList<File> dataFolders, ArrayList<File> inputFiles) {
        String newName = PsZipUtils.getTempFolderName(file.getName());
        String parentFolder = PsZipUtils.getUnzipParentFolder();
        if (parentFolder == null) {
            parentFolder = file.getParent();
        }
        File parentFolderFile = new File(parentFolder, PsZipUtils.getUnzipSubFolder());
        File destinationFolder = new File(parentFolderFile, newName);
        destinationFolder.mkdir();
        TempFilesManager.registerTempFolder((File)parentFolderFile);
        this.progressDialog.setWaitingText("Unzipping " + file.getName() + ". Please Wait...");
        try {
            ZipUtils.unzip((File)file, (File)destinationFolder, (WaitingHandler)this.progressDialog);
            this.progressDialog.setSecondaryProgressCounterIndeterminate(true);
            if (!this.progressDialog.isRunCanceled()) {
                File dataFolder = new File(destinationFolder, PeptideShaker.DATA_DIRECTORY);
                if (dataFolder.exists() && !dataFolders.contains(dataFolder)) {
                    File[] tempFiles;
                    dataFolders.add(dataFolder);
                    File[] fileArray = tempFiles = dataFolder.listFiles();
                    int n = fileArray.length;
                    for (int i = 0; i < n; ++i) {
                        File tempFile = fileArray[i];
                        String lowerCaseName = tempFile.getName().toLowerCase();
                        if (!lowerCaseName.endsWith(".fasta")) continue;
                        this.fastaFile = tempFile;
                        break;
                    }
                }
                for (File zippedFile : destinationFolder.listFiles()) {
                    this.loadIdFile(zippedFile, parameterFiles, inputFiles);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.peptideShakerGUI, e.getMessage(), "Unzip Error", 2);
            e.printStackTrace();
            this.idFiles.clear();
            this.modificationFiles.clear();
            return false;
        }
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Loading Files. Please Wait...");
        return !this.progressDialog.isRunCanceled();
    }

    private void loadIdFile(File file, HashMap<String, File> parameterFiles, ArrayList<File> inputFiles) {
        String lowerCaseName;
        if (file.getName().equals(SEARCHGUI_INPUT)) {
            inputFiles.add(file);
        }
        if ((lowerCaseName = file.getName().toLowerCase()).endsWith(".dat") || lowerCaseName.endsWith(".omx") || lowerCaseName.endsWith(".res") || lowerCaseName.endsWith(".xml") || lowerCaseName.endsWith(".mzid") || lowerCaseName.endsWith(".csv") || lowerCaseName.endsWith(".tsv") || lowerCaseName.endsWith(".sage") || lowerCaseName.endsWith(".tags") || lowerCaseName.endsWith(".pnovo.txt") || lowerCaseName.endsWith(".tide-search.target.txt") || lowerCaseName.endsWith(".psm.gz") || lowerCaseName.endsWith(".omx.gz") || lowerCaseName.endsWith(".res.gz") || lowerCaseName.endsWith(".xml.gz") || lowerCaseName.endsWith(".mzid.gz") || lowerCaseName.endsWith(".csv.gz") || lowerCaseName.endsWith(".tsv.gz") || lowerCaseName.endsWith(".sage.tsv.gz") || lowerCaseName.endsWith(".tags.gz") || lowerCaseName.endsWith(".pnovo.txt.gz") || lowerCaseName.endsWith(".tide-search.target.txt.gz") || lowerCaseName.endsWith(".psm.gz")) {
            if (!(lowerCaseName.endsWith("mods.xml") || lowerCaseName.endsWith("usermods.xml") || lowerCaseName.endsWith("settings.xml"))) {
                this.idFiles.add(file);
            } else if (lowerCaseName.endsWith("usermods.xml")) {
                this.modificationFiles.add(file);
            }
        } else if (lowerCaseName.endsWith(".par")) {
            parameterFiles.put(file.getName(), file);
        }
    }
}

