/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import com.compomics.software.CompomicsWrapper;
import com.compomics.software.ToolFactory;
import com.compomics.software.autoupdater.MavenJarFile;
import com.compomics.software.dialogs.JavaHomeOrMemoryDialogParent;
import com.compomics.software.dialogs.JavaParametersDialog;
import com.compomics.software.dialogs.ReporterSetupDialog;
import com.compomics.software.dialogs.SearchGuiSetupDialog;
import com.compomics.software.settings.PathKey;
import com.compomics.software.settings.UtilitiesPathParameters;
import com.compomics.software.settings.gui.PathParametersDialog;
import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.exceptions.exception_handlers.FrameExceptionHandler;
import com.compomics.util.experiment.ProjectParameters;
import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.biology.genes.ProteinGeneDetailsProvider;
import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.IonFactory;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationProvider;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.experiment.filtering.Filter;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.filtering.AssumptionFilter;
import com.compomics.util.experiment.identification.filtering.PsmFilter;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.peptide_shaker.Metrics;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.TagSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.io.mass_spectrometry.MsFileHandler;
import com.compomics.util.experiment.io.mass_spectrometry.mgf.MgfFileWriter;
import com.compomics.util.experiment.io.temp.TempFilesManager;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.gui.JOptionEditorPane;
import com.compomics.util.gui.PrivacyParametersDialog;
import com.compomics.util.gui.UtilitiesGUIDefaults;
import com.compomics.util.gui.error_handlers.BugReport;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.error_handlers.notification.NotesDialog;
import com.compomics.util.gui.error_handlers.notification.NotificationDialogParent;
import com.compomics.util.gui.export.graphics.ExportGraphicsDialog;
import com.compomics.util.gui.file_handling.FileAndFileFilter;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.filtering.FilterParameters;
import com.compomics.util.gui.parameters.SparklineColorsDialog;
import com.compomics.util.gui.parameters.identification.IdentificationParametersEditionDialog;
import com.compomics.util.gui.parameters.identification.IdentificationParametersOverviewDialog;
import com.compomics.util.gui.parameters.identification.advanced.AnnotationParametersDialog;
import com.compomics.util.gui.parameters.identification.advanced.BackgroundSpeciesDialog;
import com.compomics.util.gui.parameters.identification.advanced.ValidationQCParametersDialog;
import com.compomics.util.gui.parameters.identification.search.SearchParametersDialog;
import com.compomics.util.gui.parameters.tools.ProcessingParametersDialog;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.compression.ZipUtils;
import com.compomics.util.io.file.LastSelectedFolder;
import com.compomics.util.io.flat.SimpleFileWriter;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.GeneParameters;
import com.compomics.util.parameters.identification.advanced.IdMatchValidationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.advanced.ValidationQcParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.peptide_shaker.ProjectType;
import com.compomics.util.parameters.quantification.spectrum_counting.SpectrumCountingParameters;
import com.compomics.util.parameters.tools.ProcessingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.PeptideShakerWrapper;
import eu.isas.peptideshaker.export.ProjectExport;
import eu.isas.peptideshaker.gui.FractionDetailsDialog;
import eu.isas.peptideshaker.gui.JumpToPanel;
import eu.isas.peptideshaker.gui.NewDialog;
import eu.isas.peptideshaker.gui.SaveDialog;
import eu.isas.peptideshaker.gui.WelcomeDialog;
import eu.isas.peptideshaker.gui.export.FeaturesExportDialog;
import eu.isas.peptideshaker.gui.export.FollowUpExportDialog;
import eu.isas.peptideshaker.gui.export.MethodsSectionDialog;
import eu.isas.peptideshaker.gui.export.MzIdentMLExportDialog;
import eu.isas.peptideshaker.gui.filtering.FiltersDialog;
import eu.isas.peptideshaker.gui.parameters.ProjectDetailsDialog;
import eu.isas.peptideshaker.gui.parameters.ProjectParametersDialog;
import eu.isas.peptideshaker.gui.parameters.SpectrumColorsDialog;
import eu.isas.peptideshaker.gui.pride.PrideReshakeGUI;
import eu.isas.peptideshaker.gui.start.GettingStartedDialog;
import eu.isas.peptideshaker.gui.tabpanels.AnnotationPanel;
import eu.isas.peptideshaker.gui.tabpanels.GOEAPanel;
import eu.isas.peptideshaker.gui.tabpanels.ModificationsPanel;
import eu.isas.peptideshaker.gui.tabpanels.OverviewPanel;
import eu.isas.peptideshaker.gui.tabpanels.ProteinFractionsPanel;
import eu.isas.peptideshaker.gui.tabpanels.ProteinStructurePanel;
import eu.isas.peptideshaker.gui.tabpanels.QCPanel;
import eu.isas.peptideshaker.gui.tabpanels.SpectrumIdentificationPanel;
import eu.isas.peptideshaker.gui.tabpanels.ValidationPanel;
import eu.isas.peptideshaker.preferences.DisplayParameters;
import eu.isas.peptideshaker.preferences.PeptideShakerPathParameters;
import eu.isas.peptideshaker.preferences.ProjectDetails;
import eu.isas.peptideshaker.preferences.UserParameters;
import eu.isas.peptideshaker.processing.ProteinProcessor;
import eu.isas.peptideshaker.ptm.ModificationLocalizationScorer;
import eu.isas.peptideshaker.scoring.PSMaps;
import eu.isas.peptideshaker.utils.DisplayFeaturesGenerator;
import eu.isas.peptideshaker.utils.PsZipUtils;
import eu.isas.peptideshaker.utils.PsdbParent;
import eu.isas.peptideshaker.utils.StarHider;
import eu.isas.peptideshaker.validation.MatchesValidator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OptionalDataException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.jimmc.jshortcut.JShellLink;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.slf4j.LoggerFactory;

public class PeptideShakerGUI
extends JFrame
implements ClipboardOwner,
JavaHomeOrMemoryDialogParent,
NotificationDialogParent {
    private final String EXAMPLE_DATASET_PATH = "/resources/example_dataset/HeLa Example.psdb";
    private long selectedProteinKey = ExperimentObject.NO_KEY;
    private long selectedPeptideKey = ExperimentObject.NO_KEY;
    private String selectedSpectrumFile = null;
    private String selectedSpectrumTitle = null;
    public static final int OVER_VIEW_TAB_INDEX = 0;
    public static final int SPECTRUM_ID_TAB_INDEX = 1;
    public static final int PROTEIN_FRACTIONS_TAB_INDEX = 2;
    public static final int MODIFICATIONS_TAB_INDEX = 3;
    public static final int STRUCTURES_TAB_INDEX = 4;
    public static final int ANNOTATION_TAB_INDEX = 5;
    public static final int GO_ANALYSIS_TAB_INDEX = 6;
    public static final int VALIDATION_TAB_INDEX = 7;
    public static final int QC_PLOTS_TAB_INDEX = 8;
    private HashMap<Integer, Boolean> updateNeeded;
    private DecimalFormat scoreAndConfidenceDecimalFormat = new DecimalFormat("0");
    private static final String CONDA_APP_NAME = "peptide-shaker";
    private boolean dataSaved = true;
    private double bubbleScale = 1.0;
    private static boolean useLogFile;
    private LastSelectedFolder lastSelectedFolder;
    private ModificationFactory modificationFactory;
    private UtilitiesUserParameters utilitiesUserParameters;
    private ProcessingParameters processingParameters = new ProcessingParameters();
    private ProgressDialogX progressDialog;
    private OverviewPanel overviewPanel;
    private ProteinFractionsPanel proteinFractionsPanel;
    private ValidationPanel validationPanel;
    private ModificationsPanel modificationsPanel;
    private AnnotationPanel annotationPanel;
    private SpectrumIdentificationPanel spectrumIdentificationPanel;
    private ProteinStructurePanel proteinStructurePanel;
    private QCPanel qcPanel;
    private GOEAPanel goPanel;
    private FrameExceptionHandler exceptionHandler = new FrameExceptionHandler((JFrame)this, "https://github.com/compomics/peptide-shaker/issues");
    private JumpToPanel jumpToPanel;
    private DisplayFeaturesGenerator displayFeaturesGenerator;
    private HashMap<Integer, JCheckBoxMenuItem> chargeMenus = new HashMap();
    private HashMap<NeutralLoss, JCheckBoxMenuItem> lossMenus = new HashMap();
    public static String TITLED_BORDER_HORIZONTAL_PADDING;
    public static String TITLED_BORDER_HORIZONTAL_PADDING_HTML;
    private ArrayList<String> publishedTweets = new ArrayList();
    private ArrayList<String> newTweets = new ArrayList();
    private ArrayList<String> currentNotes = new ArrayList();
    private ArrayList<String> currentTips = new ArrayList();
    private PsdbParent psdbParent = new PsdbParent(PeptideShaker.getMatchesFolder());
    private boolean openingExistingProject = false;
    private StarHider starHider;
    private boolean darkTheme = false;
    public static final Color DARK_THEME_BACKGROUND_COLOR;
    private JCheckBoxMenuItem aIonCheckBoxMenuItem;
    private JMenuItem aboutJMenuItem;
    private JCheckBoxMenuItem adaptCheckBoxMenuItem;
    private JCheckBoxMenuItem allCheckBoxMenuItem;
    private JTabbedPane allTabsJTabbedPane;
    private JMenuItem annotationColorsJMenuItem;
    private JMenuBar annotationMenuBar;
    private JMenuItem annotationPreferencesMenu;
    private JPanel annotationsJPanel;
    private JCheckBoxMenuItem bIonCheckBoxMenuItem;
    private JLayeredPane backgroundLayeredPane;
    private JPanel backgroundPanel;
    private JCheckBoxMenuItem barsCheckBoxMenuItem;
    private JMenuItem bubblePlotJMenuItem;
    private JMenuItem bubbleScaleJMenuItem;
    private JCheckBoxMenuItem cIonCheckBoxMenuItem;
    private JMenu chargeMenu;
    private JMenuItem configurationFilesSettings;
    private JCheckBoxMenuItem darkThemeCheckBoxMenuItem;
    private ButtonGroup deNovoChargeButtonGroup;
    private JRadioButtonMenuItem deNovoChargeOneJRadioButtonMenuItem;
    private JRadioButtonMenuItem deNovoChargeTwoJRadioButtonMenuItem;
    private JMenu deNovoMenu;
    private JCheckBoxMenuItem defaultAnnotationCheckBoxMenuItem;
    private JMenuItem editIdSettingsFilesMenuItem;
    private JMenu editMenu;
    private JMenuItem exitJMenuItem;
    private JMenu exportGraphicsMenu;
    private JMenuItem exportIntensityHistogramGraphicsJMenuItem;
    private JMenu exportJMenu;
    private JMenuItem exportMassErrorPlotGraphicsJMenuItem;
    private JMenuItem exportMzIdentMLMenuItem;
    private JMenuItem exportProjectMenuItem;
    private JMenuItem exportSequenceFragmentationGraphicsJMenuItem;
    private JMenuItem exportSpectrumAndPlotsGraphicsJMenuItem;
    private JMenuItem exportSpectrumGraphicsJMenuItem;
    private JPopupMenu.Separator exportSpectrumGraphicsSeparator;
    private JMenu exportSpectrumMenu;
    private JMenuItem exportSpectrumValuesJMenuItem;
    private JMenu fileJMenu;
    private JMenuItem findJMenuItem;
    private JCheckBoxMenuItem fixedModsJCheckBoxMenuItem;
    private JMenuItem followUpAnalysisMenuItem;
    private JCheckBoxMenuItem forwardIonsDeNovoCheckBoxMenuItem;
    private JMenuItem fractionDetailsJMenuItem;
    private JMenuItem gettingStartedMenuItem;
    private JPanel goJPanel;
    private JMenu helpJMenu;
    private JMenuItem helpJMenuItem;
    private JMenu helpMenu;
    private JMenuItem helpMenuItem;
    private JCheckBoxMenuItem highResAnnotationCheckBoxMenuItem;
    private JMenuItem identificationFeaturesMenuItem;
    private JCheckBoxMenuItem immoniumIonsCheckMenu;
    private JRadioButtonMenuItem intensityIonTableRadioButtonMenuItem;
    private ButtonGroup ionTableButtonGroup;
    private JMenu ionsMenu;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator10;
    private JPopupMenu.Separator jSeparator11;
    private JPopupMenu.Separator jSeparator12;
    private JPopupMenu.Separator jSeparator13;
    private JPopupMenu.Separator jSeparator14;
    private JPopupMenu.Separator jSeparator15;
    private JPopupMenu.Separator jSeparator16;
    private JPopupMenu.Separator jSeparator17;
    private JPopupMenu.Separator jSeparator18;
    private JPopupMenu.Separator jSeparator19;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator20;
    private JPopupMenu.Separator jSeparator21;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JPopupMenu.Separator jSeparator9;
    private JMenuItem javaOptionsJMenuItem;
    private JMenuItem logReportMenu;
    private JMenu lossMenu;
    private JMenu lossSplitter;
    private JMenuBar menuBar;
    private JMenuItem methodsSectionMenuItem;
    private JPanel modificationJPanel;
    private JRadioButtonMenuItem mzIonTableRadioButtonMenuItem;
    private JMenuItem newJMenuItem;
    private JButton newsButton;
    private JButton notesButton;
    private JMenuItem openExampleMenuItem;
    private JMenuItem openJMenuItem;
    private JMenu openRecentJMenu;
    private JMenu otherMenu;
    private JMenu overViewTabViewMenu;
    private JPanel overviewJPanel;
    private JCheckBoxMenuItem peptidesAndPsmsJCheckBoxMenuItem;
    private JCheckBoxMenuItem precursorCheckMenu;
    private JMenuItem preferencesMenuItem;
    private JMenuItem privacyMenuItem;
    private JMenuItem processingMenuItem;
    private JMenu projectExportMenu;
    private JMenuItem projectPropertiesMenuItem;
    private JMenuItem projectSettingsMenuItem;
    private JPanel proteinFractionsJPanel;
    private JPanel proteinStructureJPanel;
    private JCheckBoxMenuItem proteinsJCheckBoxMenuItem;
    private ButtonGroup psmSortOrderButtonGroup;
    private JMenu psmSortOrderMenu;
    private JRadioButtonMenuItem psmSortRtRadioButtonMenuItem;
    private JRadioButtonMenuItem psmSortScoreRadioButtonMenuItem;
    private JPanel qcJPanel;
    private JMenuItem quantifyMenuItem;
    private JCheckBoxMenuItem relatedIonsCheckMenu;
    private JCheckBoxMenuItem reporterIonsCheckMenu;
    private JMenuItem reporterPreferencesJMenuItem;
    private JMenu resetAnnotationMenu;
    private JMenuItem reshakeMenuItem;
    private JCheckBoxMenuItem rewindIonsDeNovoCheckBoxMenuItem;
    private JMenuItem saveMenuItem;
    private JCheckBoxMenuItem scoresJCheckBoxMenuItem;
    private JMenuItem searchGuiPreferencesJMenuItem;
    private JMenuItem searchParametersMenu;
    private JCheckBoxMenuItem sequenceCoverageJCheckBoxMenuItem;
    private JMenu settingsMenu;
    private JMenuItem sparklineColorsMenuItem;
    private JCheckBoxMenuItem sparklinesJCheckBoxMenuItem;
    private JMenuItem speciesJMenuItem;
    private JCheckBoxMenuItem spectrumJCheckBoxMenuItem;
    private JPanel spectrumJPanel;
    private JCheckBoxMenuItem spectrumSlidersCheckBoxMenuItem;
    private JMenu splitterMenu2;
    private JMenu splitterMenu3;
    private JMenu splitterMenu4;
    private JMenu splitterMenu5;
    private JMenu splitterMenu6;
    private JMenu splitterMenu7;
    private JMenu splitterMenu8;
    private JMenu splitterMenu9;
    private JMenuItem starHideJMenuItem;
    private JPanel statsJPanel;
    private JButton tipsButton;
    private JMenu toolsMenu;
    private JCheckBoxMenuItem validatedProteinsOnlyJCheckBoxMenuItem;
    private JMenuItem validationQcMenuItem;
    private JMenu viewJMenu;
    private JCheckBoxMenuItem xIonCheckBoxMenuItem;
    private JCheckBoxMenuItem yIonCheckBoxMenuItem;
    private JCheckBoxMenuItem zIonCheckBoxMenuItem;

    public static void main(String[] args) {
        try {
            Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field loggerField = loggerClass.getDeclaredField("logger");
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Object unsafe = unsafeField.get(null);
            Long offset = (Long)unsafeClass.getMethod("staticFieldOffset", Field.class).invoke(unsafe, loggerField);
            unsafeClass.getMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class).invoke(unsafe, loggerClass, offset, null);
        }
        catch (Throwable loggerClass) {
            // empty catch block
        }
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = loggerContext.getLogger("org.zoodb");
        logger.setLevel(Level.toLevel((String)"ERROR"));
        logger = loggerContext.getLogger("org.springframework");
        logger.setLevel(Level.toLevel((String)"ERROR"));
        boolean numbusLookAndFeelSet = false;
        try {
            numbusLookAndFeelSet = UtilitiesGUIDefaults.setLookAndFeel();
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            UIDefaults defaults = lookAndFeel.getDefaults();
            defaults.put("ScrollBar.minimumThumbSize", new Dimension(30, 30));
        }
        catch (Exception lookAndFeel) {
            // empty catch block
        }
        if (!numbusLookAndFeelSet) {
            JOptionPane.showMessageDialog(null, "Failed to set the default look and feel. Using backup look and feel.\nPeptideShaker will work but not look as good as it should...", "Look and Feel", 2);
        }
        if (!System.getProperty("java.version").startsWith("1.6")) {
            TITLED_BORDER_HORIZONTAL_PADDING = "   ";
            TITLED_BORDER_HORIZONTAL_PADDING_HTML = "&nbsp;&nbsp;&nbsp;";
        }
        ProteinGeneDetailsProvider geneFactory = new ProteinGeneDetailsProvider();
        try {
            geneFactory.initialize(PeptideShaker.getConfigFolder());
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "An error occurred while loading the gene mappings.", "Gene Mapping File Error", 0);
        }
        try {
            SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
            speciesFactory.initiate(PeptideShaker.getConfigFolder());
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "An error occurred while loading the species mapping.", "File Error", 0);
        }
        File psdbFile = null;
        boolean psdb = false;
        String zipUrl = null;
        boolean url = false;
        String zipUrlDownloadFolder = null;
        boolean downloadFolder = false;
        String pxAccession = null;
        boolean pxAccessionProvided = false;
        boolean pxAccessionPrivate = false;
        for (String arg : args) {
            if (psdb) {
                psdbFile = new File(arg);
                psdb = false;
            } else if (url) {
                zipUrl = arg;
                url = false;
            } else if (downloadFolder) {
                zipUrlDownloadFolder = arg;
                downloadFolder = false;
            } else if (pxAccessionProvided) {
                pxAccession = arg;
                pxAccessionProvided = false;
            }
            if (arg.equals("-psdb")) {
                psdb = true;
                continue;
            }
            if (arg.equals("-zipUrl")) {
                url = true;
                continue;
            }
            if (arg.equals("-zipUrlFolder")) {
                downloadFolder = true;
                continue;
            }
            if (arg.equals("-pxAccession")) {
                pxAccessionProvided = true;
                continue;
            }
            if (!arg.equals("-pxAccessionPrivate")) continue;
            pxAccessionPrivate = true;
        }
        if (zipUrl != null && zipUrlDownloadFolder == null) {
            zipUrl = null;
            JOptionPane.showMessageDialog(null, "Setting the download folder is mandatory when opening a URL. Please use the -zipUrlFolder option.", "Downloading URL Error", 2);
        }
        new PeptideShakerGUI(psdbFile, zipUrl, zipUrlDownloadFolder, pxAccession, pxAccessionPrivate, true);
    }

    private void setPathConfiguration() throws IOException {
        File pathConfigurationFile = new File(PeptideShaker.getConfigFolder(), "resources/conf/paths.txt");
        if (pathConfigurationFile.exists()) {
            PeptideShakerPathParameters.loadPathParametersFromFile(pathConfigurationFile);
        }
    }

    public PeptideShakerGUI() {
    }

    public PeptideShakerGUI(File psdbFile, String zipURL, String zipUrlDownloadFolder, String pxAccession, boolean pxAccessionPrivate, boolean showWelcomeDialog) {
        this.setUpLogFile(true);
        try {
            this.setPathConfiguration();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (!PeptideShakerPathParameters.getErrorKeys().isEmpty()) {
                this.editPathSettings(null);
            }
        }
        catch (Exception e) {
            this.editPathSettings(null);
        }
        this.loadUserParameters();
        boolean newVersion = false;
        if (!PeptideShaker.getJarFilePath().equalsIgnoreCase(".") && !CompomicsWrapper.appRunningIntoConda((String)CONDA_APP_NAME) && this.utilitiesUserParameters.isAutoUpdate()) {
            newVersion = this.checkForNewVersion();
        }
        if (!newVersion) {
            boolean javaVersionWarning;
            if (!PeptideShaker.getJarFilePath().equalsIgnoreCase(".")) {
                this.utilitiesUserParameters.setPeptideShakerPath(new File(PeptideShaker.getJarFilePath(), "PeptideShaker-" + PeptideShaker.getVersion() + ".jar").getAbsolutePath());
                UtilitiesUserParameters.saveUserParameters((UtilitiesUserParameters)this.utilitiesUserParameters);
            }
            boolean java64bit = CompomicsWrapper.is64BitJava();
            boolean memoryOk = this.utilitiesUserParameters.getMemoryParameter() >= 4000;
            String javaVersion = System.getProperty("java.version");
            boolean bl = javaVersionWarning = javaVersion.startsWith("1.5") || javaVersion.startsWith("1.6") || javaVersion.startsWith("1.7");
            if (!PeptideShaker.getJarFilePath().equalsIgnoreCase(".") && System.getProperty("os.name").lastIndexOf("Windows") != -1 && new File(PeptideShaker.getJarFilePath() + "/resources/conf/firstRun").exists()) {
                int value;
                boolean fileDeleted = new File(PeptideShaker.getJarFilePath() + "/resources/conf/firstRun").delete();
                if (!fileDeleted) {
                    JOptionPane.showMessageDialog(this, "Failed to delete the file /resources/conf/firstRun.\nPlease delete it manually.", "File Error", 0);
                }
                if ((value = JOptionPane.showConfirmDialog(this, "Create a shortcut to PeptideShaker on the desktop?", "Create Desktop Shortcut?", 0, 3)) == 0) {
                    this.addShortcutAtDeskTop();
                }
            }
            PeptideShaker.instantiateFacories(this.utilitiesUserParameters);
            this.modificationFactory = ModificationFactory.getInstance();
            EnzymeFactory.getInstance();
            UIManager.put("TitledBorder.titleColor", new Color(59, 59, 59));
            this.initComponents();
            this.psmSortRtRadioButtonMenuItem.setSelected(this.utilitiesUserParameters.getSortPsmsOnRt());
            this.reshakeMenuItem.setVisible(false);
            this.quantifyMenuItem.setVisible(false);
            this.jSeparator2.setVisible(false);
            this.reporterPreferencesJMenuItem.setVisible(false);
            this.darkThemeCheckBoxMenuItem.setVisible(false);
            this.notesButton.setVisible(false);
            this.newsButton.setVisible(false);
            this.tipsButton.setVisible(false);
            this.overviewPanel = new OverviewPanel(this);
            this.overviewJPanel.add(this.overviewPanel);
            this.spectrumIdentificationPanel = new SpectrumIdentificationPanel(this);
            this.proteinFractionsPanel = new ProteinFractionsPanel(this);
            this.proteinFractionsJPanel.add(this.proteinFractionsPanel);
            this.modificationsPanel = new ModificationsPanel(this);
            this.proteinStructurePanel = new ProteinStructurePanel(this);
            this.proteinStructureJPanel.add(this.proteinStructurePanel);
            this.annotationPanel = new AnnotationPanel(this);
            this.validationPanel = new ValidationPanel(this);
            this.jumpToPanel = new JumpToPanel(this);
            this.jumpToPanel.setEnabled(false);
            this.menuBar.add(Box.createHorizontalGlue());
            this.menuBar.add(this.jumpToPanel);
            this.setUpPanels(true);
            this.repaintPanels();
            this.updateRecentProjectsList();
            this.updateFrameTitle();
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
            this.setExtendedState(6);
            this.setLocationRelativeTo(null);
            if (psdbFile != null) {
                this.setVisible(true);
                if (psdbFile.getName().endsWith(".zip")) {
                    this.importPeptideShakerZipFile(psdbFile);
                } else {
                    this.importPeptideShakerFile(psdbFile, false);
                }
            } else if (zipURL != null) {
                this.setVisible(true);
                this.importPeptideShakerZipFromURL(zipURL, zipUrlDownloadFolder);
            } else if (pxAccession != null) {
                new PrideReshakeGUI(this, pxAccession, pxAccessionPrivate);
            } else if (showWelcomeDialog) {
                new WelcomeDialog(this, !java64bit || !memoryOk, javaVersionWarning, true);
            }
        }
    }

    public void loadUserParameters() {
        try {
            this.utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
            this.lastSelectedFolder = this.utilitiesUserParameters.getLastSelectedFolder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.lastSelectedFolder == null) {
            this.lastSelectedFolder = new LastSelectedFolder();
        }
        this.psdbParent.loadUserParameters();
    }

    public void setProject(ProjectParameters projectParameters) {
        this.psdbParent.setProject(projectParameters);
        this.updateFrameTitle();
    }

    private void setupTabComponents() {
    }

    public void updateFrameTitle() {
        if (this.getProjectParameters() != null) {
            this.setTitle("PeptideShaker " + PeptideShaker.getVersion() + " - " + this.getProjectParameters().getProjectUniqueName());
        } else {
            this.setTitle("PeptideShaker " + PeptideShaker.getVersion());
        }
    }

    public void resetFrameTitle() {
        this.setTitle("PeptideShaker " + PeptideShaker.getVersion());
    }

    public LastSelectedFolder getLastSelectedFolder() {
        if (this.lastSelectedFolder == null) {
            this.lastSelectedFolder = new LastSelectedFolder();
            this.utilitiesUserParameters.setLastSelectedFolder(this.lastSelectedFolder);
        }
        return this.lastSelectedFolder;
    }

    public void setLastSelectedFolder(LastSelectedFolder lastSelectedFolder) {
        this.lastSelectedFolder = lastSelectedFolder;
    }

    private void initComponents() {
        this.annotationMenuBar = new JMenuBar();
        this.splitterMenu5 = new JMenu();
        this.ionsMenu = new JMenu();
        this.aIonCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.bIonCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.cIonCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.xIonCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.yIonCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.zIonCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.splitterMenu8 = new JMenu();
        this.otherMenu = new JMenu();
        this.precursorCheckMenu = new JCheckBoxMenuItem();
        this.immoniumIonsCheckMenu = new JCheckBoxMenuItem();
        this.relatedIonsCheckMenu = new JCheckBoxMenuItem();
        this.reporterIonsCheckMenu = new JCheckBoxMenuItem();
        this.lossSplitter = new JMenu();
        this.lossMenu = new JMenu();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.adaptCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.splitterMenu2 = new JMenu();
        this.chargeMenu = new JMenu();
        this.splitterMenu3 = new JMenu();
        this.deNovoMenu = new JMenu();
        this.forwardIonsDeNovoCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.rewindIonsDeNovoCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jSeparator19 = new JPopupMenu.Separator();
        this.deNovoChargeOneJRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.deNovoChargeTwoJRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.splitterMenu9 = new JMenu();
        this.settingsMenu = new JMenu();
        this.allCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.highResAnnotationCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.barsCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.bubbleScaleJMenuItem = new JMenuItem();
        this.intensityIonTableRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.mzIonTableRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.defaultAnnotationCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jSeparator14 = new JPopupMenu.Separator();
        this.annotationColorsJMenuItem = new JMenuItem();
        this.splitterMenu4 = new JMenu();
        this.exportGraphicsMenu = new JMenu();
        this.exportSpectrumMenu = new JMenu();
        this.exportSpectrumGraphicsJMenuItem = new JMenuItem();
        this.exportSpectrumAndPlotsGraphicsJMenuItem = new JMenuItem();
        this.exportSpectrumGraphicsSeparator = new JPopupMenu.Separator();
        this.exportSequenceFragmentationGraphicsJMenuItem = new JMenuItem();
        this.exportIntensityHistogramGraphicsJMenuItem = new JMenuItem();
        this.exportMassErrorPlotGraphicsJMenuItem = new JMenuItem();
        this.bubblePlotJMenuItem = new JMenuItem();
        this.exportSpectrumValuesJMenuItem = new JMenuItem();
        this.splitterMenu6 = new JMenu();
        this.helpJMenu = new JMenu();
        this.helpMenuItem = new JMenuItem();
        this.splitterMenu7 = new JMenu();
        this.resetAnnotationMenu = new JMenu();
        this.ionTableButtonGroup = new ButtonGroup();
        this.deNovoChargeButtonGroup = new ButtonGroup();
        this.psmSortOrderButtonGroup = new ButtonGroup();
        this.backgroundPanel = new JPanel();
        this.backgroundLayeredPane = new JLayeredPane();
        this.allTabsJTabbedPane = new JTabbedPane();
        this.overviewJPanel = new JPanel();
        this.spectrumJPanel = new JPanel();
        this.proteinFractionsJPanel = new JPanel();
        this.modificationJPanel = new JPanel();
        this.proteinStructureJPanel = new JPanel();
        this.annotationsJPanel = new JPanel();
        this.goJPanel = new JPanel();
        this.statsJPanel = new JPanel();
        this.qcJPanel = new JPanel();
        this.newsButton = new JButton();
        this.notesButton = new JButton();
        this.tipsButton = new JButton();
        this.menuBar = new JMenuBar();
        this.fileJMenu = new JMenu();
        this.newJMenuItem = new JMenuItem();
        this.jSeparator18 = new JPopupMenu.Separator();
        this.openJMenuItem = new JMenuItem();
        this.openRecentJMenu = new JMenu();
        this.jSeparator20 = new JPopupMenu.Separator();
        this.openExampleMenuItem = new JMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.reshakeMenuItem = new JMenuItem();
        this.quantifyMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.projectPropertiesMenuItem = new JMenuItem();
        this.projectSettingsMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.saveMenuItem = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.exitJMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.searchParametersMenu = new JMenuItem();
        this.annotationPreferencesMenu = new JMenuItem();
        this.validationQcMenuItem = new JMenuItem();
        this.speciesJMenuItem = new JMenuItem();
        this.sparklineColorsMenuItem = new JMenuItem();
        this.jSeparator13 = new JPopupMenu.Separator();
        this.preferencesMenuItem = new JMenuItem();
        this.fractionDetailsJMenuItem = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.javaOptionsJMenuItem = new JMenuItem();
        this.processingMenuItem = new JMenuItem();
        this.editIdSettingsFilesMenuItem = new JMenuItem();
        this.configurationFilesSettings = new JMenuItem();
        this.privacyMenuItem = new JMenuItem();
        this.jSeparator12 = new JPopupMenu.Separator();
        this.findJMenuItem = new JMenuItem();
        this.starHideJMenuItem = new JMenuItem();
        this.jSeparator15 = new JPopupMenu.Separator();
        this.toolsMenu = new JMenu();
        this.searchGuiPreferencesJMenuItem = new JMenuItem();
        this.reporterPreferencesJMenuItem = new JMenuItem();
        this.exportJMenu = new JMenu();
        this.identificationFeaturesMenuItem = new JMenuItem();
        this.followUpAnalysisMenuItem = new JMenuItem();
        this.methodsSectionMenuItem = new JMenuItem();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.projectExportMenu = new JMenu();
        this.exportProjectMenuItem = new JMenuItem();
        this.exportMzIdentMLMenuItem = new JMenuItem();
        this.viewJMenu = new JMenu();
        this.overViewTabViewMenu = new JMenu();
        this.proteinsJCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.peptidesAndPsmsJCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.spectrumJCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.sequenceCoverageJCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.sparklinesJCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.spectrumSlidersCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jSeparator11 = new JPopupMenu.Separator();
        this.fixedModsJCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.scoresJCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.validatedProteinsOnlyJCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.psmSortOrderMenu = new JMenu();
        this.psmSortScoreRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.psmSortRtRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.jSeparator21 = new JPopupMenu.Separator();
        this.darkThemeCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.helpMenu = new JMenu();
        this.helpJMenuItem = new JMenuItem();
        this.gettingStartedMenuItem = new JMenuItem();
        this.jSeparator17 = new JPopupMenu.Separator();
        this.logReportMenu = new JMenuItem();
        this.jSeparator16 = new JPopupMenu.Separator();
        this.aboutJMenuItem = new JMenuItem();
        this.annotationMenuBar.setBorder(BorderFactory.createEtchedBorder());
        this.splitterMenu5.setText("|");
        this.splitterMenu5.setEnabled(false);
        this.annotationMenuBar.add(this.splitterMenu5);
        this.ionsMenu.setText("Ions");
        this.ionsMenu.setEnabled(false);
        this.aIonCheckBoxMenuItem.setText("a");
        this.aIonCheckBoxMenuItem.setToolTipText("a-ions");
        this.aIonCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.aIonCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.ionsMenu.add(this.aIonCheckBoxMenuItem);
        this.bIonCheckBoxMenuItem.setText("b");
        this.bIonCheckBoxMenuItem.setToolTipText("b-ions");
        this.bIonCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.bIonCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.ionsMenu.add(this.bIonCheckBoxMenuItem);
        this.cIonCheckBoxMenuItem.setText("c");
        this.cIonCheckBoxMenuItem.setToolTipText("c-ions");
        this.cIonCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.cIonCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.ionsMenu.add(this.cIonCheckBoxMenuItem);
        this.ionsMenu.add(this.jSeparator6);
        this.xIonCheckBoxMenuItem.setText("x");
        this.xIonCheckBoxMenuItem.setToolTipText("x-ions");
        this.xIonCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.xIonCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.ionsMenu.add(this.xIonCheckBoxMenuItem);
        this.yIonCheckBoxMenuItem.setText("y");
        this.yIonCheckBoxMenuItem.setToolTipText("y-ions");
        this.yIonCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.yIonCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.ionsMenu.add(this.yIonCheckBoxMenuItem);
        this.zIonCheckBoxMenuItem.setText("z");
        this.zIonCheckBoxMenuItem.setToolTipText("z-ions");
        this.zIonCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.zIonCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.ionsMenu.add(this.zIonCheckBoxMenuItem);
        this.annotationMenuBar.add(this.ionsMenu);
        this.splitterMenu8.setText("|");
        this.splitterMenu8.setEnabled(false);
        this.annotationMenuBar.add(this.splitterMenu8);
        this.otherMenu.setText("Other");
        this.otherMenu.setEnabled(false);
        this.precursorCheckMenu.setSelected(true);
        this.precursorCheckMenu.setText("Precursor");
        this.precursorCheckMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.precursorCheckMenuActionPerformed(evt);
            }
        });
        this.otherMenu.add(this.precursorCheckMenu);
        this.immoniumIonsCheckMenu.setSelected(true);
        this.immoniumIonsCheckMenu.setText("Immonium");
        this.immoniumIonsCheckMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.immoniumIonsCheckMenuActionPerformed(evt);
            }
        });
        this.otherMenu.add(this.immoniumIonsCheckMenu);
        this.relatedIonsCheckMenu.setSelected(true);
        this.relatedIonsCheckMenu.setText("Related");
        this.relatedIonsCheckMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.relatedIonsCheckMenuActionPerformed(evt);
            }
        });
        this.otherMenu.add(this.relatedIonsCheckMenu);
        this.reporterIonsCheckMenu.setSelected(true);
        this.reporterIonsCheckMenu.setText("Reporter");
        this.reporterIonsCheckMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.reporterIonsCheckMenuActionPerformed(evt);
            }
        });
        this.otherMenu.add(this.reporterIonsCheckMenu);
        this.annotationMenuBar.add(this.otherMenu);
        this.lossSplitter.setText("|");
        this.lossSplitter.setEnabled(false);
        this.annotationMenuBar.add(this.lossSplitter);
        this.lossMenu.setText("Loss");
        this.lossMenu.setEnabled(false);
        this.lossMenu.add(this.jSeparator7);
        this.adaptCheckBoxMenuItem.setText("Adapt");
        this.adaptCheckBoxMenuItem.setToolTipText("Adapt losses to sequence and modifications");
        this.adaptCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.adaptCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.lossMenu.add(this.adaptCheckBoxMenuItem);
        this.annotationMenuBar.add(this.lossMenu);
        this.splitterMenu2.setText("|");
        this.splitterMenu2.setEnabled(false);
        this.annotationMenuBar.add(this.splitterMenu2);
        this.chargeMenu.setText("Charge");
        this.chargeMenu.setEnabled(false);
        this.annotationMenuBar.add(this.chargeMenu);
        this.splitterMenu3.setText("|");
        this.splitterMenu3.setEnabled(false);
        this.annotationMenuBar.add(this.splitterMenu3);
        this.deNovoMenu.setText("De Novo");
        this.forwardIonsDeNovoCheckBoxMenuItem.setText("b-ions");
        this.forwardIonsDeNovoCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.forwardIonsDeNovoCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.deNovoMenu.add(this.forwardIonsDeNovoCheckBoxMenuItem);
        this.rewindIonsDeNovoCheckBoxMenuItem.setText("y-ions");
        this.rewindIonsDeNovoCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.rewindIonsDeNovoCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.deNovoMenu.add(this.rewindIonsDeNovoCheckBoxMenuItem);
        this.deNovoMenu.add(this.jSeparator19);
        this.deNovoChargeButtonGroup.add(this.deNovoChargeOneJRadioButtonMenuItem);
        this.deNovoChargeOneJRadioButtonMenuItem.setSelected(true);
        this.deNovoChargeOneJRadioButtonMenuItem.setText("Single Charge");
        this.deNovoChargeOneJRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.deNovoChargeOneJRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.deNovoMenu.add(this.deNovoChargeOneJRadioButtonMenuItem);
        this.deNovoChargeButtonGroup.add(this.deNovoChargeTwoJRadioButtonMenuItem);
        this.deNovoChargeTwoJRadioButtonMenuItem.setText("Double Charge");
        this.deNovoChargeTwoJRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.deNovoChargeTwoJRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.deNovoMenu.add(this.deNovoChargeTwoJRadioButtonMenuItem);
        this.annotationMenuBar.add(this.deNovoMenu);
        this.splitterMenu9.setText("|");
        this.splitterMenu9.setEnabled(false);
        this.annotationMenuBar.add(this.splitterMenu9);
        this.settingsMenu.setText("Settings");
        this.settingsMenu.setEnabled(false);
        this.allCheckBoxMenuItem.setText("Show All Peaks");
        this.allCheckBoxMenuItem.setToolTipText("Show all peaks or just the annotated peaks");
        this.allCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.allCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.allCheckBoxMenuItem);
        this.highResAnnotationCheckBoxMenuItem.setSelected(true);
        this.highResAnnotationCheckBoxMenuItem.setText("High Resolution");
        this.highResAnnotationCheckBoxMenuItem.setToolTipText("Use high resolution annotation");
        this.highResAnnotationCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.highResAnnotationCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.highResAnnotationCheckBoxMenuItem);
        this.barsCheckBoxMenuItem.setText("Show Bars");
        this.barsCheckBoxMenuItem.setToolTipText("Add bars highlighting the fragment ion types");
        this.barsCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.barsCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.barsCheckBoxMenuItem);
        this.bubbleScaleJMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 3));
        this.bubbleScaleJMenuItem.setText("Bubble Plot Scale");
        this.bubbleScaleJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.bubbleScaleJMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.bubbleScaleJMenuItem);
        this.ionTableButtonGroup.add(this.intensityIonTableRadioButtonMenuItem);
        this.intensityIonTableRadioButtonMenuItem.setSelected(true);
        this.intensityIonTableRadioButtonMenuItem.setText("Intensity Ion Table");
        this.intensityIonTableRadioButtonMenuItem.setToolTipText("Bar charts with peak intensities");
        this.intensityIonTableRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.intensityIonTableRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.intensityIonTableRadioButtonMenuItem);
        this.ionTableButtonGroup.add(this.mzIonTableRadioButtonMenuItem);
        this.mzIonTableRadioButtonMenuItem.setText("m/z Ion Table");
        this.mzIonTableRadioButtonMenuItem.setToolTipText("Traditional ion table with m/z values");
        this.mzIonTableRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.mzIonTableRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.mzIonTableRadioButtonMenuItem);
        this.settingsMenu.add(this.jSeparator5);
        this.defaultAnnotationCheckBoxMenuItem.setSelected(true);
        this.defaultAnnotationCheckBoxMenuItem.setText("Automatic Annotation");
        this.defaultAnnotationCheckBoxMenuItem.setToolTipText("Use automatic annotation");
        this.defaultAnnotationCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.defaultAnnotationCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.defaultAnnotationCheckBoxMenuItem);
        this.settingsMenu.add(this.jSeparator14);
        this.annotationColorsJMenuItem.setText("Annotation Colors");
        this.annotationColorsJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.annotationColorsJMenuItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.annotationColorsJMenuItem);
        this.annotationMenuBar.add(this.settingsMenu);
        this.splitterMenu4.setText("|");
        this.splitterMenu4.setEnabled(false);
        this.annotationMenuBar.add(this.splitterMenu4);
        this.exportGraphicsMenu.setText("Export");
        this.exportGraphicsMenu.setEnabled(false);
        this.exportSpectrumMenu.setText("Figure");
        this.exportSpectrumGraphicsJMenuItem.setText("Spectrum");
        this.exportSpectrumGraphicsJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.exportSpectrumGraphicsJMenuItemActionPerformed(evt);
            }
        });
        this.exportSpectrumMenu.add(this.exportSpectrumGraphicsJMenuItem);
        this.exportSpectrumAndPlotsGraphicsJMenuItem.setText("Spectrum & Plots");
        this.exportSpectrumAndPlotsGraphicsJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.exportSpectrumAndPlotsGraphicsJMenuItemActionPerformed(evt);
            }
        });
        this.exportSpectrumMenu.add(this.exportSpectrumAndPlotsGraphicsJMenuItem);
        this.exportSpectrumMenu.add(this.exportSpectrumGraphicsSeparator);
        this.exportSequenceFragmentationGraphicsJMenuItem.setText("Sequence Fragmentation");
        this.exportSequenceFragmentationGraphicsJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.exportSequenceFragmentationGraphicsJMenuItemActionPerformed(evt);
            }
        });
        this.exportSpectrumMenu.add(this.exportSequenceFragmentationGraphicsJMenuItem);
        this.exportIntensityHistogramGraphicsJMenuItem.setText("Intensity Histogram");
        this.exportIntensityHistogramGraphicsJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.exportIntensityHistogramGraphicsJMenuItemActionPerformed(evt);
            }
        });
        this.exportSpectrumMenu.add(this.exportIntensityHistogramGraphicsJMenuItem);
        this.exportMassErrorPlotGraphicsJMenuItem.setText("m/z Error Plot");
        this.exportMassErrorPlotGraphicsJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.exportMassErrorPlotGraphicsJMenuItemActionPerformed(evt);
            }
        });
        this.exportSpectrumMenu.add(this.exportMassErrorPlotGraphicsJMenuItem);
        this.exportGraphicsMenu.add(this.exportSpectrumMenu);
        this.bubblePlotJMenuItem.setText("Bubble Plot");
        this.bubblePlotJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.bubblePlotJMenuItemActionPerformed(evt);
            }
        });
        this.exportGraphicsMenu.add(this.bubblePlotJMenuItem);
        this.exportSpectrumValuesJMenuItem.setText("Spectrum as MGF");
        this.exportSpectrumValuesJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.exportSpectrumValuesJMenuItemActionPerformed(evt);
            }
        });
        this.exportGraphicsMenu.add(this.exportSpectrumValuesJMenuItem);
        this.annotationMenuBar.add(this.exportGraphicsMenu);
        this.splitterMenu6.setText("|");
        this.splitterMenu6.setEnabled(false);
        this.annotationMenuBar.add(this.splitterMenu6);
        this.helpJMenu.setText("Help");
        this.helpJMenu.setEnabled(false);
        this.helpMenuItem.setText("Help");
        this.helpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.helpMenuItemActionPerformed(evt);
            }
        });
        this.helpJMenu.add(this.helpMenuItem);
        this.annotationMenuBar.add(this.helpJMenu);
        this.splitterMenu7.setText("|");
        this.splitterMenu7.setEnabled(false);
        this.annotationMenuBar.add(this.splitterMenu7);
        this.resetAnnotationMenu.setText("<html><a href>Reset Annotation</a></html>");
        this.resetAnnotationMenu.setFocusable(false);
        this.resetAnnotationMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                PeptideShakerGUI.this.resetAnnotationMenuSelected(evt);
            }
        });
        this.annotationMenuBar.add(this.resetAnnotationMenu);
        this.setDefaultCloseOperation(0);
        this.setTitle("PeptideShaker");
        this.setMinimumSize(new Dimension(1280, 750));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                PeptideShakerGUI.this.formComponentResized(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PeptideShakerGUI.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(255, 255, 255));
        this.backgroundPanel.setPreferredSize(new Dimension(1260, 800));
        this.allTabsJTabbedPane.setTabPlacement(4);
        this.allTabsJTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PeptideShakerGUI.this.allTabsJTabbedPaneStateChanged(evt);
            }
        });
        this.overviewJPanel.setOpaque(false);
        this.overviewJPanel.setPreferredSize(new Dimension(900, 800));
        this.overviewJPanel.setLayout(new BoxLayout(this.overviewJPanel, 2));
        this.allTabsJTabbedPane.addTab("Overview", this.overviewJPanel);
        this.spectrumJPanel.setLayout(new BoxLayout(this.spectrumJPanel, 2));
        this.allTabsJTabbedPane.addTab("Spectrum IDs", this.spectrumJPanel);
        this.proteinFractionsJPanel.setOpaque(false);
        this.proteinFractionsJPanel.setLayout(new BoxLayout(this.proteinFractionsJPanel, 2));
        this.allTabsJTabbedPane.addTab("Fractions", this.proteinFractionsJPanel);
        this.modificationJPanel.setOpaque(false);
        this.modificationJPanel.setLayout(new BoxLayout(this.modificationJPanel, 2));
        this.allTabsJTabbedPane.addTab("Modifications", this.modificationJPanel);
        this.proteinStructureJPanel.setOpaque(false);
        this.proteinStructureJPanel.setLayout(new BoxLayout(this.proteinStructureJPanel, 2));
        this.allTabsJTabbedPane.addTab("3D Structures", this.proteinStructureJPanel);
        this.annotationsJPanel.setOpaque(false);
        this.annotationsJPanel.setLayout(new BoxLayout(this.annotationsJPanel, 2));
        this.allTabsJTabbedPane.addTab("Annotation", this.annotationsJPanel);
        this.goJPanel.setOpaque(false);
        this.goJPanel.setLayout(new BoxLayout(this.goJPanel, 2));
        this.allTabsJTabbedPane.addTab("GO Analysis", this.goJPanel);
        this.statsJPanel.setOpaque(false);
        this.statsJPanel.setLayout(new BoxLayout(this.statsJPanel, 2));
        this.allTabsJTabbedPane.addTab("Validation", this.statsJPanel);
        this.qcJPanel.setOpaque(false);
        this.qcJPanel.setLayout(new BoxLayout(this.qcJPanel, 2));
        this.allTabsJTabbedPane.addTab("QC Plots", this.qcJPanel);
        this.backgroundLayeredPane.add(this.allTabsJTabbedPane);
        this.allTabsJTabbedPane.setBounds(0, 0, 1280, 860);
        this.newsButton.setBackground(new Color(204, 204, 204));
        this.newsButton.setFont(this.newsButton.getFont().deriveFont(this.newsButton.getFont().getStyle() | 1));
        this.newsButton.setForeground(new Color(255, 255, 255));
        this.newsButton.setText("News");
        this.newsButton.setBorder(null);
        this.newsButton.setContentAreaFilled(false);
        this.newsButton.setOpaque(true);
        this.newsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                PeptideShakerGUI.this.newsButtonMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PeptideShakerGUI.this.newsButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PeptideShakerGUI.this.newsButtonMouseExited(evt);
            }
        });
        this.backgroundLayeredPane.setLayer(this.newsButton, JLayeredPane.MODAL_LAYER);
        this.backgroundLayeredPane.add(this.newsButton);
        this.newsButton.setBounds(1205, 825, 70, 20);
        this.notesButton.setBackground(new Color(204, 204, 204));
        this.notesButton.setFont(this.notesButton.getFont().deriveFont(this.notesButton.getFont().getStyle() | 1));
        this.notesButton.setForeground(new Color(255, 255, 255));
        this.notesButton.setText("Notes");
        this.notesButton.setBorder(null);
        this.notesButton.setBorderPainted(false);
        this.notesButton.setContentAreaFilled(false);
        this.notesButton.setOpaque(true);
        this.notesButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PeptideShakerGUI.this.notesButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PeptideShakerGUI.this.notesButtonMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                PeptideShakerGUI.this.notesButtonMouseReleased(evt);
            }
        });
        this.backgroundLayeredPane.setLayer(this.notesButton, JLayeredPane.MODAL_LAYER);
        this.backgroundLayeredPane.add(this.notesButton);
        this.notesButton.setBounds(1205, 775, 70, 20);
        this.tipsButton.setBackground(new Color(204, 204, 204));
        this.tipsButton.setFont(this.tipsButton.getFont().deriveFont(this.tipsButton.getFont().getStyle() | 1));
        this.tipsButton.setForeground(new Color(255, 255, 255));
        this.tipsButton.setText("Tips");
        this.tipsButton.setBorder(null);
        this.tipsButton.setContentAreaFilled(false);
        this.tipsButton.setOpaque(true);
        this.tipsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PeptideShakerGUI.this.tipsButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PeptideShakerGUI.this.tipsButtonMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                PeptideShakerGUI.this.tipsButtonMouseReleased(evt);
            }
        });
        this.backgroundLayeredPane.setLayer(this.tipsButton, JLayeredPane.MODAL_LAYER);
        this.backgroundLayeredPane.add(this.tipsButton);
        this.tipsButton.setBounds(1205, 800, 70, 20);
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1278, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundLayeredPane, -1, 1278, Short.MAX_VALUE)));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 862, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundLayeredPane, -1, 862, Short.MAX_VALUE)));
        this.fileJMenu.setMnemonic('F');
        this.fileJMenu.setText("File");
        this.newJMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newJMenuItem.setMnemonic('N');
        this.newJMenuItem.setText("New Project...");
        this.newJMenuItem.setToolTipText("Create a new PeptideShaker project");
        this.newJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.newJMenuItemActionPerformed(evt);
            }
        });
        this.fileJMenu.add(this.newJMenuItem);
        this.fileJMenu.add(this.jSeparator18);
        this.openJMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openJMenuItem.setMnemonic('O');
        this.openJMenuItem.setText("Open Project...");
        this.openJMenuItem.setToolTipText("Open an existing PeptideShaker project");
        this.openJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.openJMenuItemActionPerformed(evt);
            }
        });
        this.fileJMenu.add(this.openJMenuItem);
        this.openRecentJMenu.setMnemonic('R');
        this.openRecentJMenu.setText("Open Recent Project");
        this.fileJMenu.add(this.openRecentJMenu);
        this.fileJMenu.add(this.jSeparator20);
        this.openExampleMenuItem.setMnemonic('E');
        this.openExampleMenuItem.setText("Open Example");
        this.openExampleMenuItem.setToolTipText("Open a PeptideShaker example project");
        this.openExampleMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.openExampleMenuItemActionPerformed(evt);
            }
        });
        this.fileJMenu.add(this.openExampleMenuItem);
        this.fileJMenu.add(this.jSeparator8);
        this.reshakeMenuItem.setMnemonic('H');
        this.reshakeMenuItem.setText("Reshake...");
        this.reshakeMenuItem.setToolTipText("<html>\nReanalyze PRIDE experiments.<br>\n</html>");
        this.reshakeMenuItem.setEnabled(false);
        this.reshakeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.reshakeMenuItemActionPerformed(evt);
            }
        });
        this.fileJMenu.add(this.reshakeMenuItem);
        this.quantifyMenuItem.setMnemonic('R');
        this.quantifyMenuItem.setText("Reporter Ions...");
        this.quantifyMenuItem.setToolTipText("<html>\nQuantify your proteins using reporter ions.<br>\n(Coming soon...)\n</html>");
        this.quantifyMenuItem.setEnabled(false);
        this.quantifyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.quantifyMenuItemActionPerformed(evt);
            }
        });
        this.fileJMenu.add(this.quantifyMenuItem);
        this.fileJMenu.add(this.jSeparator2);
        this.projectPropertiesMenuItem.setMnemonic('P');
        this.projectPropertiesMenuItem.setText("Project Properties");
        this.projectPropertiesMenuItem.setEnabled(false);
        this.projectPropertiesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.projectPropertiesMenuItemActionPerformed(evt);
            }
        });
        this.fileJMenu.add(this.projectPropertiesMenuItem);
        this.projectSettingsMenuItem.setMnemonic('I');
        this.projectSettingsMenuItem.setText("Project Settings");
        this.projectSettingsMenuItem.setEnabled(false);
        this.projectSettingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.projectSettingsMenuItemActionPerformed(evt);
            }
        });
        this.fileJMenu.add(this.projectSettingsMenuItem);
        this.fileJMenu.add(this.jSeparator1);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.setMnemonic('S');
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.setEnabled(false);
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileJMenu.add(this.saveMenuItem);
        this.fileJMenu.add(this.jSeparator9);
        this.exitJMenuItem.setMnemonic('x');
        this.exitJMenuItem.setText("Exit");
        this.exitJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.exitJMenuItemActionPerformed(evt);
            }
        });
        this.fileJMenu.add(this.exitJMenuItem);
        this.menuBar.add(this.fileJMenu);
        this.editMenu.setMnemonic('E');
        this.editMenu.setText("Edit");
        this.searchParametersMenu.setMnemonic('S');
        this.searchParametersMenu.setText("Search Settings");
        this.searchParametersMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.searchParametersMenuActionPerformed(evt);
            }
        });
        this.editMenu.add(this.searchParametersMenu);
        this.annotationPreferencesMenu.setMnemonic('A');
        this.annotationPreferencesMenu.setText("Spectrum Annotations");
        this.annotationPreferencesMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.annotationPreferencesMenuActionPerformed(evt);
            }
        });
        this.editMenu.add(this.annotationPreferencesMenu);
        this.validationQcMenuItem.setMnemonic('V');
        this.validationQcMenuItem.setText("Validation Filters");
        this.validationQcMenuItem.setEnabled(false);
        this.validationQcMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.validationQcMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.validationQcMenuItem);
        this.speciesJMenuItem.setMnemonic('B');
        this.speciesJMenuItem.setText("Background Species");
        this.speciesJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.speciesJMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.speciesJMenuItem);
        this.sparklineColorsMenuItem.setText("Sparkline Colors");
        this.sparklineColorsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.sparklineColorsMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.sparklineColorsMenuItem);
        this.editMenu.add(this.jSeparator13);
        this.preferencesMenuItem.setMnemonic('O');
        this.preferencesMenuItem.setText("Project Preferences");
        this.preferencesMenuItem.setEnabled(false);
        this.preferencesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.preferencesMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.preferencesMenuItem);
        this.fractionDetailsJMenuItem.setMnemonic('R');
        this.fractionDetailsJMenuItem.setText("Fraction Details");
        this.fractionDetailsJMenuItem.setEnabled(false);
        this.fractionDetailsJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.fractionDetailsJMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.fractionDetailsJMenuItem);
        this.editMenu.add(this.jSeparator4);
        this.javaOptionsJMenuItem.setMnemonic('J');
        this.javaOptionsJMenuItem.setText("Java Settings");
        this.javaOptionsJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.javaOptionsJMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.javaOptionsJMenuItem);
        this.processingMenuItem.setMnemonic('C');
        this.processingMenuItem.setText("Processing Settings");
        this.processingMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.processingMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.processingMenuItem);
        this.editIdSettingsFilesMenuItem.setMnemonic('D');
        this.editIdSettingsFilesMenuItem.setText("Identification Settings");
        this.editIdSettingsFilesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.editIdSettingsFilesMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.editIdSettingsFilesMenuItem);
        this.configurationFilesSettings.setMnemonic('E');
        this.configurationFilesSettings.setText("Resource Settings");
        this.configurationFilesSettings.setToolTipText("Set paths to resource folders");
        this.configurationFilesSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.configurationFilesSettingsActionPerformed(evt);
            }
        });
        this.editMenu.add(this.configurationFilesSettings);
        this.privacyMenuItem.setMnemonic('V');
        this.privacyMenuItem.setText("Privacy Settings");
        this.privacyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.privacyMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.privacyMenuItem);
        this.editMenu.add(this.jSeparator12);
        this.findJMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.findJMenuItem.setMnemonic('F');
        this.findJMenuItem.setText("Find...");
        this.findJMenuItem.setToolTipText("Find a protein or peptide");
        this.findJMenuItem.setEnabled(false);
        this.findJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.findJMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.findJMenuItem);
        this.starHideJMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.starHideJMenuItem.setMnemonic('L');
        this.starHideJMenuItem.setText("Filters");
        this.starHideJMenuItem.setEnabled(false);
        this.starHideJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.starHideJMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.starHideJMenuItem);
        this.editMenu.add(this.jSeparator15);
        this.toolsMenu.setMnemonic('T');
        this.toolsMenu.setText("Tools");
        this.searchGuiPreferencesJMenuItem.setText("SearchGUI");
        this.searchGuiPreferencesJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.searchGuiPreferencesJMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.searchGuiPreferencesJMenuItem);
        this.reporterPreferencesJMenuItem.setText("Reporter");
        this.reporterPreferencesJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.reporterPreferencesJMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.reporterPreferencesJMenuItem);
        this.editMenu.add(this.toolsMenu);
        this.menuBar.add(this.editMenu);
        this.exportJMenu.setMnemonic('x');
        this.exportJMenu.setText("Export");
        this.identificationFeaturesMenuItem.setMnemonic('I');
        this.identificationFeaturesMenuItem.setText("Identification Features");
        this.identificationFeaturesMenuItem.setEnabled(false);
        this.identificationFeaturesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.identificationFeaturesMenuItemActionPerformed(evt);
            }
        });
        this.exportJMenu.add(this.identificationFeaturesMenuItem);
        this.followUpAnalysisMenuItem.setMnemonic('F');
        this.followUpAnalysisMenuItem.setText("Follow Up Analysis");
        this.followUpAnalysisMenuItem.setEnabled(false);
        this.followUpAnalysisMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.followUpAnalysisMenuItemActionPerformed(evt);
            }
        });
        this.exportJMenu.add(this.followUpAnalysisMenuItem);
        this.methodsSectionMenuItem.setMnemonic('M');
        this.methodsSectionMenuItem.setText("Methods Section");
        this.methodsSectionMenuItem.setToolTipText("<html>\nExport a draft of the method<br>\nsection for your manuscript\n</html>");
        this.methodsSectionMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.methodsSectionMenuItemActionPerformed(evt);
            }
        });
        this.exportJMenu.add(this.methodsSectionMenuItem);
        this.exportJMenu.add(this.jSeparator10);
        this.projectExportMenu.setText("PeptideShaker Project As");
        this.exportProjectMenuItem.setMnemonic('Z');
        this.exportProjectMenuItem.setText("Zip File");
        this.exportProjectMenuItem.setToolTipText("Export the complete project as a zip file");
        this.exportProjectMenuItem.setEnabled(false);
        this.exportProjectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.exportProjectMenuItemActionPerformed(evt);
            }
        });
        this.projectExportMenu.add(this.exportProjectMenuItem);
        this.exportMzIdentMLMenuItem.setMnemonic('M');
        this.exportMzIdentMLMenuItem.setText("mzIdentML");
        this.exportMzIdentMLMenuItem.setToolTipText("Export the project as mzIdentML");
        this.exportMzIdentMLMenuItem.setEnabled(false);
        this.exportMzIdentMLMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.exportMzIdentMLMenuItemActionPerformed(evt);
            }
        });
        this.projectExportMenu.add(this.exportMzIdentMLMenuItem);
        this.exportJMenu.add(this.projectExportMenu);
        this.menuBar.add(this.exportJMenu);
        this.viewJMenu.setMnemonic('V');
        this.viewJMenu.setText("View");
        this.overViewTabViewMenu.setMnemonic('O');
        this.overViewTabViewMenu.setText("Overview");
        this.proteinsJCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 3));
        this.proteinsJCheckBoxMenuItem.setMnemonic('P');
        this.proteinsJCheckBoxMenuItem.setSelected(true);
        this.proteinsJCheckBoxMenuItem.setText("Proteins");
        this.proteinsJCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.proteinsJCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.overViewTabViewMenu.add(this.proteinsJCheckBoxMenuItem);
        this.peptidesAndPsmsJCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 3));
        this.peptidesAndPsmsJCheckBoxMenuItem.setMnemonic('E');
        this.peptidesAndPsmsJCheckBoxMenuItem.setSelected(true);
        this.peptidesAndPsmsJCheckBoxMenuItem.setText("Peptides & PSMs");
        this.peptidesAndPsmsJCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.peptidesAndPsmsJCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.overViewTabViewMenu.add(this.peptidesAndPsmsJCheckBoxMenuItem);
        this.spectrumJCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.spectrumJCheckBoxMenuItem.setMnemonic('S');
        this.spectrumJCheckBoxMenuItem.setSelected(true);
        this.spectrumJCheckBoxMenuItem.setText("Spectrum");
        this.spectrumJCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.spectrumJCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.overViewTabViewMenu.add(this.spectrumJCheckBoxMenuItem);
        this.sequenceCoverageJCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 3));
        this.sequenceCoverageJCheckBoxMenuItem.setMnemonic('C');
        this.sequenceCoverageJCheckBoxMenuItem.setSelected(true);
        this.sequenceCoverageJCheckBoxMenuItem.setText("Sequence Coverage");
        this.sequenceCoverageJCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.sequenceCoverageJCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.overViewTabViewMenu.add(this.sequenceCoverageJCheckBoxMenuItem);
        this.viewJMenu.add(this.overViewTabViewMenu);
        this.viewJMenu.add(this.jSeparator3);
        this.sparklinesJCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(74, 10));
        this.sparklinesJCheckBoxMenuItem.setMnemonic('J');
        this.sparklinesJCheckBoxMenuItem.setSelected(true);
        this.sparklinesJCheckBoxMenuItem.setText("JSparklines");
        this.sparklinesJCheckBoxMenuItem.setToolTipText("View sparklines or the underlying numbers");
        this.sparklinesJCheckBoxMenuItem.setEnabled(false);
        this.sparklinesJCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.sparklinesJCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.viewJMenu.add(this.sparklinesJCheckBoxMenuItem);
        this.spectrumSlidersCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 10));
        this.spectrumSlidersCheckBoxMenuItem.setMnemonic('L');
        this.spectrumSlidersCheckBoxMenuItem.setText("Spectrum Sliders");
        this.spectrumSlidersCheckBoxMenuItem.setToolTipText("Show the accuracy and intensity level sliders");
        this.spectrumSlidersCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.spectrumSlidersCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.viewJMenu.add(this.spectrumSlidersCheckBoxMenuItem);
        this.viewJMenu.add(this.jSeparator11);
        this.fixedModsJCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 10));
        this.fixedModsJCheckBoxMenuItem.setMnemonic('F');
        this.fixedModsJCheckBoxMenuItem.setText("Fixed Modifications");
        this.fixedModsJCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.fixedModsJCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.viewJMenu.add(this.fixedModsJCheckBoxMenuItem);
        this.scoresJCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 10));
        this.scoresJCheckBoxMenuItem.setMnemonic('c');
        this.scoresJCheckBoxMenuItem.setText("Scores");
        this.scoresJCheckBoxMenuItem.setEnabled(false);
        this.scoresJCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.scoresJCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.viewJMenu.add(this.scoresJCheckBoxMenuItem);
        this.validatedProteinsOnlyJCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 10));
        this.validatedProteinsOnlyJCheckBoxMenuItem.setMnemonic('N');
        this.validatedProteinsOnlyJCheckBoxMenuItem.setText("Validated Proteins Only");
        this.validatedProteinsOnlyJCheckBoxMenuItem.setEnabled(false);
        this.validatedProteinsOnlyJCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.validatedProteinsOnlyJCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.viewJMenu.add(this.validatedProteinsOnlyJCheckBoxMenuItem);
        this.psmSortOrderMenu.setText("PSM Sort Order");
        this.psmSortOrderButtonGroup.add(this.psmSortScoreRadioButtonMenuItem);
        this.psmSortScoreRadioButtonMenuItem.setSelected(true);
        this.psmSortScoreRadioButtonMenuItem.setText("Score");
        this.psmSortScoreRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.psmSortScoreRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.psmSortOrderMenu.add(this.psmSortScoreRadioButtonMenuItem);
        this.psmSortOrderButtonGroup.add(this.psmSortRtRadioButtonMenuItem);
        this.psmSortRtRadioButtonMenuItem.setText("Retention Time");
        this.psmSortRtRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.psmSortRtRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.psmSortOrderMenu.add(this.psmSortRtRadioButtonMenuItem);
        this.viewJMenu.add(this.psmSortOrderMenu);
        this.viewJMenu.add(this.jSeparator21);
        this.darkThemeCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 10));
        this.darkThemeCheckBoxMenuItem.setText("Dark Theme (beta)");
        this.darkThemeCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.darkThemeCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.viewJMenu.add(this.darkThemeCheckBoxMenuItem);
        this.menuBar.add(this.viewJMenu);
        this.helpMenu.setMnemonic('H');
        this.helpMenu.setText("Help");
        this.helpJMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpJMenuItem.setMnemonic('H');
        this.helpJMenuItem.setText("Help");
        this.helpJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.helpJMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpJMenuItem);
        this.gettingStartedMenuItem.setMnemonic('G');
        this.gettingStartedMenuItem.setText("Getting Started...");
        this.gettingStartedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.gettingStartedMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.gettingStartedMenuItem);
        this.helpMenu.add(this.jSeparator17);
        this.logReportMenu.setMnemonic('B');
        this.logReportMenu.setText("Bug Report");
        this.logReportMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.logReportMenuActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.logReportMenu);
        this.helpMenu.add(this.jSeparator16);
        this.aboutJMenuItem.setMnemonic('A');
        this.aboutJMenuItem.setText("About");
        this.aboutJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeptideShakerGUI.this.aboutJMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutJMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, 1278, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, 862, Short.MAX_VALUE));
        this.pack();
    }

    private void newJMenuItemActionPerformed(ActionEvent evt) {
        if (!this.dataSaved && this.getProjectParameters() != null) {
            int value = JOptionPane.showConfirmDialog(this, "Do you want to save the changes to " + this.getProjectParameters().getProjectUniqueName() + "?", "Unsaved Changes", 1, 3);
            if (value == 0) {
                this.saveMenuItemActionPerformed(null);
                new NewDialog(this, true);
            } else if (value != 2 && value != -1) {
                this.clearData(true, true);
                new NewDialog(this, true);
            }
        } else {
            this.clearData(true, true);
            new NewDialog(this, true);
        }
    }

    private void exitJMenuItemActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void helpJMenuItemActionPerformed(ActionEvent evt) {
        new HelpDialog((Frame)this, this.getClass().getResource("/helpFiles/PeptideShaker.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "PeptideShaker - Help");
    }

    private void aboutJMenuItemActionPerformed(ActionEvent evt) {
        new HelpDialog((Frame)this, this.getClass().getResource("/helpFiles/AboutPeptideShaker.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "About PeptideShaker " + PeptideShaker.getVersion());
    }

    private void annotationPreferencesMenuActionPerformed(ActionEvent evt) {
        AnnotationParameters newAnnotationSettings;
        ModificationParameters ptmSettings = this.getIdentificationParameters().getSearchParameters().getModificationParameters();
        HashSet neutralLosses = IonFactory.getNeutralLosses((ModificationParameters)ptmSettings);
        ArrayList reporterIons = new ArrayList(IonFactory.getReporterIons((ModificationParameters)ptmSettings));
        AnnotationParametersDialog annotationSettingsDialog = new AnnotationParametersDialog((Frame)this, this.getIdentificationParameters().getAnnotationParameters(), this.getIdentificationParameters().getSearchParameters().getFragmentIonAccuracy(), neutralLosses, reporterIons, true);
        if (!annotationSettingsDialog.isCanceled() && !(newAnnotationSettings = annotationSettingsDialog.getAnnotationSettings()).isSameAs(this.getIdentificationParameters().getAnnotationParameters())) {
            this.getIdentificationParameters().setAnnotationParameters(newAnnotationSettings);
            this.updateSpectrumAnnotations();
            this.setDataSaved(false);
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.isVisible()) {
            this.backgroundLayeredPane.getComponent(3).setBounds(0, 0, this.backgroundLayeredPane.getWidth(), this.backgroundLayeredPane.getHeight());
            this.backgroundLayeredPane.revalidate();
            this.backgroundLayeredPane.repaint();
            this.backgroundLayeredPane.getComponent(0).setBounds(this.backgroundLayeredPane.getWidth() - this.backgroundLayeredPane.getComponent(0).getWidth() - 12, this.backgroundLayeredPane.getHeight() - this.backgroundLayeredPane.getComponent(0).getHeight() - 15, this.backgroundLayeredPane.getComponent(0).getWidth(), this.backgroundLayeredPane.getComponent(0).getHeight());
            this.backgroundLayeredPane.getComponent(1).setBounds(this.backgroundLayeredPane.getWidth() - this.backgroundLayeredPane.getComponent(1).getWidth() - 12, this.backgroundLayeredPane.getHeight() - this.backgroundLayeredPane.getComponent(1).getHeight() - 59, this.backgroundLayeredPane.getComponent(1).getWidth(), this.backgroundLayeredPane.getComponent(1).getHeight());
            this.backgroundLayeredPane.getComponent(2).setBounds(this.backgroundLayeredPane.getWidth() - this.backgroundLayeredPane.getComponent(2).getWidth() - 12, this.backgroundLayeredPane.getHeight() - this.backgroundLayeredPane.getComponent(2).getHeight() - 37, this.backgroundLayeredPane.getComponent(2).getWidth(), this.backgroundLayeredPane.getComponent(2).getHeight());
            if (this.overviewPanel != null) {
                this.overviewPanel.setDisplayOptions(this.proteinsJCheckBoxMenuItem.isSelected(), this.peptidesAndPsmsJCheckBoxMenuItem.isSelected(), this.sequenceCoverageJCheckBoxMenuItem.isSelected(), this.spectrumJCheckBoxMenuItem.isSelected());
                this.overviewPanel.updateSeparators();
            }
            if (this.validationPanel != null) {
                this.validationPanel.updateSeparators();
            }
        }
    }

    private void searchParametersMenuActionPerformed(ActionEvent evt) {
        SearchParameters searchParameters = this.getIdentificationParameters().getSearchParameters();
        if (searchParameters == null) {
            this.setDefaultParameters();
            searchParameters = this.getIdentificationParameters().getSearchParameters();
        }
        new SearchParametersDialog((Frame)this, searchParameters, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true, true, this.getLastSelectedFolder(), this.getIdentificationParameters().getName(), false);
    }

    private void sparklinesJCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.overviewPanel.showSparkLines(this.sparklinesJCheckBoxMenuItem.isSelected());
        this.proteinFractionsPanel.showSparkLines(this.sparklinesJCheckBoxMenuItem.isSelected());
        this.modificationsPanel.showSparkLines(this.sparklinesJCheckBoxMenuItem.isSelected());
        this.spectrumIdentificationPanel.showSparkLines(this.sparklinesJCheckBoxMenuItem.isSelected());
        this.proteinStructurePanel.showSparkLines(this.sparklinesJCheckBoxMenuItem.isSelected());
        this.goPanel.showSparkLines(this.sparklinesJCheckBoxMenuItem.isSelected());
    }

    private void sequenceCoverageJCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.overviewPanel.setDisplayOptions(this.proteinsJCheckBoxMenuItem.isSelected(), this.peptidesAndPsmsJCheckBoxMenuItem.isSelected(), this.sequenceCoverageJCheckBoxMenuItem.isSelected(), this.spectrumJCheckBoxMenuItem.isSelected());
        this.overviewPanel.updateSeparators();
    }

    private void spectrumJCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        final boolean showProteins = this.proteinsJCheckBoxMenuItem.isSelected();
        final boolean showPeptidesAndPsms = this.peptidesAndPsmsJCheckBoxMenuItem.isSelected();
        final boolean showCoverage = this.sequenceCoverageJCheckBoxMenuItem.isSelected();
        final boolean showSpectrum = this.spectrumJCheckBoxMenuItem.isSelected();
        if (!showPeptidesAndPsms && !showSpectrum) {
            this.overviewPanel.setDisplayOptions(showProteins, true, showCoverage, false);
            this.overviewPanel.updateSeparators();
            this.overviewPanel.setDisplayOptions(showProteins, false, showCoverage, false);
            this.overviewPanel.updateSeparators();
        } else if (!showPeptidesAndPsms && showSpectrum) {
            this.overviewPanel.setDisplayOptions(showProteins, true, showCoverage, false);
            this.overviewPanel.updateSeparators();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PeptideShakerGUI.this.overviewPanel.setDisplayOptions(showProteins, showPeptidesAndPsms, showCoverage, showSpectrum);
                    PeptideShakerGUI.this.overviewPanel.updateSeparators();
                }
            });
        } else {
            this.overviewPanel.setDisplayOptions(showProteins, showPeptidesAndPsms, showCoverage, showSpectrum);
            this.overviewPanel.updateSeparators();
        }
    }

    private void peptidesAndPsmsJCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.overviewPanel.setDisplayOptions(this.proteinsJCheckBoxMenuItem.isSelected(), this.peptidesAndPsmsJCheckBoxMenuItem.isSelected(), this.sequenceCoverageJCheckBoxMenuItem.isSelected(), this.spectrumJCheckBoxMenuItem.isSelected());
        this.overviewPanel.updateSeparators();
    }

    private void proteinsJCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.overviewPanel.setDisplayOptions(this.proteinsJCheckBoxMenuItem.isSelected(), this.peptidesAndPsmsJCheckBoxMenuItem.isSelected(), this.sequenceCoverageJCheckBoxMenuItem.isSelected(), this.spectrumJCheckBoxMenuItem.isSelected());
        this.overviewPanel.updateSeparators();
    }

    private void bubbleScaleJMenuItemActionPerformed(ActionEvent evt) {
        String input = JOptionPane.showInputDialog(this, "Bubble Scale:", this.bubbleScale);
        if (input != null) {
            try {
                this.bubbleScale = Double.valueOf(input);
                this.overviewPanel.updateBubblePlot();
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Bubble scale has to be a number.", "Input Error", 0);
            }
        }
    }

    private void exportSpectrumGraphicsJMenuItemActionPerformed(ActionEvent evt) {
        this.exportSpectrumAsFigure();
    }

    private void allTabsJTabbedPaneStateChanged(ChangeEvent evt) {
        if (this.getIdentification() != null) {
            final int selectedIndex = this.allTabsJTabbedPane.getSelectedIndex();
            if (!(selectedIndex == 7 || !this.validationPanel.isInitiated() || this.validationPanel.thresholdUpdated() && this.validationPanel.pepWindowApplied())) {
                int value = JOptionPane.showConfirmDialog(this, "Discard the changed validation settings?", "Discard Settings?", 1, 3);
                if (value == 0) {
                    this.validationPanel.resetAllThresholds();
                    this.updateNeeded.put(7, true);
                } else {
                    this.updateNeeded.put(7, false);
                    this.allTabsJTabbedPane.setSelectedIndex(7);
                }
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProteinMatch proteinMatch;
                        if (selectedIndex == 0) {
                            if (((Boolean)PeptideShakerGUI.this.updateNeeded.get(0)).booleanValue()) {
                                PeptideShakerGUI.this.overviewPanel.displayResults();
                            } else {
                                PeptideShakerGUI.this.overviewPanel.updateSelection(true);
                            }
                        } else if (selectedIndex == 2) {
                            if (((Boolean)PeptideShakerGUI.this.updateNeeded.get(2)).booleanValue()) {
                                PeptideShakerGUI.this.proteinFractionsPanel.displayResults();
                            } else {
                                PeptideShakerGUI.this.proteinFractionsPanel.updateSelection();
                            }
                        } else if (selectedIndex == 4) {
                            if (((Boolean)PeptideShakerGUI.this.updateNeeded.get(4)).booleanValue()) {
                                PeptideShakerGUI.this.resetPanel(4);
                                PeptideShakerGUI.this.proteinStructurePanel.displayResults();
                            } else {
                                PeptideShakerGUI.this.proteinStructurePanel.updateSelection(true);
                            }
                        } else if (selectedIndex == 6 && ((Boolean)PeptideShakerGUI.this.updateNeeded.get(6)).booleanValue()) {
                            PeptideShakerGUI.this.resetPanel(6);
                            PeptideShakerGUI.this.goPanel.displayResults();
                        } else if (selectedIndex == 1) {
                            if (((Boolean)PeptideShakerGUI.this.updateNeeded.get(1)).booleanValue()) {
                                PeptideShakerGUI.this.resetPanel(1);
                                PeptideShakerGUI.this.spectrumIdentificationPanel.displayResults();
                            } else {
                                PeptideShakerGUI.this.spectrumIdentificationPanel.updateSelection();
                            }
                        } else if (selectedIndex == 3) {
                            if (((Boolean)PeptideShakerGUI.this.updateNeeded.get(3)).booleanValue()) {
                                PeptideShakerGUI.this.modificationsPanel.displayResults();
                            } else {
                                PeptideShakerGUI.this.modificationsPanel.updateSelection();
                            }
                        } else if (selectedIndex == 8 && ((Boolean)PeptideShakerGUI.this.updateNeeded.get(8)).booleanValue()) {
                            PeptideShakerGUI.this.qcPanel.displayResults();
                        } else if (selectedIndex == 7 && ((Boolean)PeptideShakerGUI.this.updateNeeded.get(7)).booleanValue()) {
                            PeptideShakerGUI.this.validationPanel.displayResults();
                        }
                        if (selectedIndex == 5 && (proteinMatch = (ProteinMatch)PeptideShakerGUI.this.getIdentification().retrieveObject(PeptideShakerGUI.this.selectedProteinKey)) != null) {
                            PeptideShakerGUI.this.annotationPanel.updateBasicProteinAnnotation(proteinMatch.getLeadingAccession());
                        }
                        AnnotationParameters annotationParameters = PeptideShakerGUI.this.getIdentificationParameters().getAnnotationParameters();
                        switch (selectedIndex) {
                            case 0: {
                                PeptideShakerGUI.this.overviewPanel.showSpectrumAnnotationMenu();
                                PeptideShakerGUI.this.overviewPanel.setIntensitySliderValue((int)(annotationParameters.getAnnotationIntensityLimit() * 100.0));
                                break;
                            }
                            case 1: {
                                PeptideShakerGUI.this.spectrumIdentificationPanel.showSpectrumAnnotationMenu();
                                PeptideShakerGUI.this.spectrumIdentificationPanel.setIntensitySliderValue((int)(annotationParameters.getAnnotationIntensityLimit() * 100.0));
                                break;
                            }
                            case 3: {
                                PeptideShakerGUI.this.modificationsPanel.showSpectrumAnnotationMenu();
                                PeptideShakerGUI.this.modificationsPanel.setIntensitySliderValue((int)(annotationParameters.getAnnotationIntensityLimit() * 100.0));
                                break;
                            }
                        }
                        if (selectedIndex == 0 || selectedIndex == 1 || selectedIndex == 3) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        PeptideShakerGUI.this.updateSpectrumAnnotations();
                                    }
                                    catch (Exception e) {
                                        PeptideShakerGUI.this.catchException(e);
                                    }
                                }
                            });
                        }
                        if (selectedIndex == 0 || selectedIndex == 4 || selectedIndex == 2) {
                            PeptideShakerGUI.this.jumpToPanel.setEnabled(true);
                            PeptideShakerGUI.this.jumpToPanel.setType(JumpToPanel.JumpType.protein);
                        } else if (selectedIndex == 3) {
                            PeptideShakerGUI.this.jumpToPanel.setEnabled(true);
                            PeptideShakerGUI.this.jumpToPanel.setType(JumpToPanel.JumpType.peptide);
                        } else if (selectedIndex == 1) {
                            PeptideShakerGUI.this.jumpToPanel.setEnabled(true);
                            PeptideShakerGUI.this.jumpToPanel.setType(JumpToPanel.JumpType.psm);
                        } else {
                            PeptideShakerGUI.this.jumpToPanel.setEnabled(false);
                        }
                        PeptideShakerGUI.this.jumpToPanel.setColor(Color.black);
                    }
                    catch (Exception e) {
                        PeptideShakerGUI.this.catchException(e);
                    }
                }
            }, "TabThread").start();
        }
    }

    private void bubblePlotJMenuItemActionPerformed(ActionEvent evt) {
        this.exportBubblePlotAsFigure();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.close();
    }

    private void scoresJCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        try {
            this.getDisplayParameters().showScores(this.scoresJCheckBoxMenuItem.isSelected());
            this.overviewPanel.updateScores();
            this.spectrumIdentificationPanel.updateScores();
            this.proteinStructurePanel.updateScores();
            this.proteinFractionsPanel.updateScores();
            this.goPanel.updateScores();
            this.sparklinesJCheckBoxMenuItemActionPerformed(null);
        }
        catch (Exception e) {
            this.catchException(e);
        }
    }

    private void openJMenuItemActionPerformed(ActionEvent evt) {
        String lastSelectedFolderPath;
        String zipFileFilterDescription;
        String psdbFileFilterDescription;
        FileAndFileFilter selectedFileAndFilter;
        if (!this.dataSaved && this.getProjectParameters() != null) {
            int value = JOptionPane.showConfirmDialog(this, "Do you want to save the changes to " + this.getProjectParameters().getProjectUniqueName() + "?", "Unsaved Changes", 1, 3);
            if (value == 0) {
                this.saveMenuItemActionPerformed(null);
            } else if (value == 2 || value == -1) {
                return;
            }
        }
        if ((selectedFileAndFilter = FileChooserUtil.getUserSelectedFile((Component)this, (String[])new String[]{".psdb", ".zip"}, (String[])new String[]{psdbFileFilterDescription = "PeptideShaker (.psdb)", zipFileFilterDescription = "Zipped PeptideShaker (.zip)"}, (String)"Open PeptideShaker Project", (String)(lastSelectedFolderPath = this.lastSelectedFolder.getLastSelectedFolder()), null, (boolean)true, (boolean)false, (boolean)false, (int)0)) != null) {
            File selectedFile = selectedFileAndFilter.getFile();
            this.lastSelectedFolder.setLastSelectedFolder(selectedFile.getParent());
            if (selectedFile.getName().endsWith(".zip")) {
                this.importPeptideShakerZipFile(selectedFile);
            } else if (selectedFile.getName().endsWith(".psdb")) {
                this.exceptionHandler.setIgnoreExceptions(true);
                this.clearData(true, true);
                this.exceptionHandler.setIgnoreExceptions(false);
                this.clearParameters();
                this.getUserParameters().addRecentProject(selectedFile);
                this.updateRecentProjectsList();
                this.importPeptideShakerFile(selectedFile, false);
                this.lastSelectedFolder.setLastSelectedFolder(selectedFile.getAbsolutePath());
            } else {
                JOptionPane.showMessageDialog(this, "Not a PeptideShaker file (.psdb).", "Unsupported File.", 2);
            }
        }
    }

    private void preferencesMenuItemActionPerformed(ActionEvent evt) {
        ProjectParametersDialog projectParametersDialog = new ProjectParametersDialog((Frame)this, this.getSpectrumCountingParameters(), this.getDisplayParameters());
        if (!projectParametersDialog.isCanceled()) {
            DisplayParameters newDisplayParameters;
            SpectrumCountingParameters newSpectrumCountingParameters = projectParametersDialog.getSpectrumCountingParameters();
            if (!newSpectrumCountingParameters.isSameAs(this.getSpectrumCountingParameters())) {
                this.setSpectrumCountingParameters(newSpectrumCountingParameters);
                this.getIdentificationFeaturesGenerator().clearSpectrumCounting();
                this.setUpdated(0, false);
                this.setUpdated(4, false);
                this.setUpdated(8, false);
                this.updateTabbedPanes();
                this.setDataSaved(false);
            }
            if ((newDisplayParameters = projectParametersDialog.getDisplayParameters()).getnAASurroundingPeptides() != this.getDisplayParameters().getnAASurroundingPeptides()) {
                this.getDisplayParameters().setnAASurroundingPeptides(newDisplayParameters.getnAASurroundingPeptides());
                this.updateSurroundingAminoAcids();
            }
        }
    }

    private void identificationFeaturesMenuItemActionPerformed(ActionEvent evt) {
        new FeaturesExportDialog(this);
    }

    private void followUpAnalysisMenuItemActionPerformed(ActionEvent evt) {
        new FollowUpExportDialog(this);
    }

    private void aIonCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.deselectDefaultAnnotationMenuItem();
        this.updateSpectrumAnnotations();
    }

    private void bIonCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.deselectDefaultAnnotationMenuItem();
        this.updateSpectrumAnnotations();
    }

    private void cIonCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.deselectDefaultAnnotationMenuItem();
        this.updateSpectrumAnnotations();
    }

    private void xIonCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.deselectDefaultAnnotationMenuItem();
        this.updateSpectrumAnnotations();
    }

    private void yIonCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.deselectDefaultAnnotationMenuItem();
        this.updateSpectrumAnnotations();
    }

    private void zIonCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.deselectDefaultAnnotationMenuItem();
        this.updateSpectrumAnnotations();
    }

    private void allCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.updateSpectrumAnnotations();
    }

    private void barsCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.getDisplayParameters().setShowBars(this.barsCheckBoxMenuItem.isSelected());
        this.updateSpectrumAnnotations();
    }

    private void intensityIonTableRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.getDisplayParameters().setIntensityIonTable(this.intensityIonTableRadioButtonMenuItem.isSelected());
        this.updateSpectrumAnnotations();
    }

    private void mzIonTableRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.getDisplayParameters().setIntensityIonTable(this.intensityIonTableRadioButtonMenuItem.isSelected());
        this.updateSpectrumAnnotations();
    }

    private void helpMenuItemActionPerformed(ActionEvent evt) {
        int selectedTabIndex = this.allTabsJTabbedPane.getSelectedIndex();
        this.setCursor(new Cursor(3));
        block0 : switch (selectedTabIndex) {
            case 0: {
                int spectrumTabIndex = this.overviewPanel.getSelectedSpectrumTabIndex();
                switch (spectrumTabIndex) {
                    case 0: {
                        new HelpDialog((Frame)this, this.getClass().getResource("/helpFiles/IonTable.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Ion Table - Help");
                        break block0;
                    }
                    case 1: {
                        new HelpDialog((Frame)this, this.getClass().getResource("/helpFiles/BubblePlot.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Bubble Plot - Help");
                        break block0;
                    }
                    case 2: {
                        new HelpDialog((Frame)this, this.getClass().getResource("/helpFiles/SpectrumPanel.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Spetrum Panel - Help");
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                new HelpDialog((Frame)this, this.getClass().getResource("/helpFiles/SpectrumPanel.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Spectrum Panel - Help");
                break;
            }
            case 3: {
                new HelpDialog((Frame)this, this.getClass().getResource("/helpFiles/PTMPanel.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Modification Analysis - Help");
                break;
            }
        }
        this.setCursor(new Cursor(0));
    }

    private void exportSpectrumValuesJMenuItemActionPerformed(ActionEvent evt) {
        try {
            this.exportSelectedSpectraAsMgf();
        }
        catch (Exception e) {
            this.catchException(e);
        }
    }

    private void defaultAnnotationCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.updateSpectrumAnnotations();
    }

    private void projectPropertiesMenuItemActionPerformed(ActionEvent evt) {
        new ProjectDetailsDialog(this);
    }

    private void exportSequenceFragmentationGraphicsJMenuItemActionPerformed(ActionEvent evt) {
        this.exportSequenceFragmentationAsFigure();
    }

    private void exportIntensityHistogramGraphicsJMenuItemActionPerformed(ActionEvent evt) {
        this.exportIntensityHistogramAsFigure();
    }

    private void exportMassErrorPlotGraphicsJMenuItemActionPerformed(ActionEvent evt) {
        this.exportMassErrorPlotAsFigure();
    }

    private void projectSettingsMenuItemActionPerformed(ActionEvent evt) {
        IdentificationParameters identificationParameters = this.getIdentificationParameters();
        new IdentificationParametersEditionDialog((Frame)this, identificationParameters, this.getNormalIcon(), this.getWaitingIcon(), this.lastSelectedFolder, false);
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        new SaveDialog(this, true);
    }

    private void spectrumSlidersCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.psdbParent.getUserParameters().setShowSliders(this.spectrumSlidersCheckBoxMenuItem.isSelected());
        this.overviewPanel.updateSeparators();
        this.spectrumIdentificationPanel.updateSeparators();
        this.modificationsPanel.updateSeparators();
    }

    private void starHideJMenuItemActionPerformed(ActionEvent evt) {
        new FiltersDialog(this);
    }

    private void findJMenuItemActionPerformed(ActionEvent evt) {
        this.jumpToPanel.selectTextField();
    }

    private void logReportMenuActionPerformed(ActionEvent evt) {
        new BugReport((JFrame)this, this.lastSelectedFolder, "PeptideShaker", CONDA_APP_NAME, PeptideShaker.getVersion(), CONDA_APP_NAME, "PeptideShaker", new File(PeptideShaker.getConfigFolder() + "/resources/PeptideShaker.log"));
    }

    private void javaOptionsJMenuItemActionPerformed(ActionEvent evt) {
        new JavaParametersDialog((JFrame)this, (JavaHomeOrMemoryDialogParent)this, null, "PeptideShaker", true);
    }

    private void adaptCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.deselectDefaultAnnotationMenuItem();
        this.updateSpectrumAnnotations();
    }

    private void annotationColorsJMenuItemActionPerformed(ActionEvent evt) {
        new SpectrumColorsDialog(this);
    }

    private void precursorCheckMenuActionPerformed(ActionEvent evt) {
        this.deselectDefaultAnnotationMenuItem();
        this.updateSpectrumAnnotations();
    }

    private void immoniumIonsCheckMenuActionPerformed(ActionEvent evt) {
        this.deselectDefaultAnnotationMenuItem();
        this.updateSpectrumAnnotations();
    }

    private void reporterIonsCheckMenuActionPerformed(ActionEvent evt) {
        this.deselectDefaultAnnotationMenuItem();
        this.updateSpectrumAnnotations();
    }

    private void searchGuiPreferencesJMenuItemActionPerformed(ActionEvent evt) {
        try {
            new SearchGuiSetupDialog((JFrame)this, true);
            this.loadUserParameters();
        }
        catch (Exception ex) {
            this.catchException(ex);
        }
    }

    private void gettingStartedMenuItemActionPerformed(ActionEvent evt) {
        new GettingStartedDialog(this, null, false);
    }

    private void forwardIonsDeNovoCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.updateSpectrumAnnotations();
    }

    private void rewindIonsDeNovoCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.updateSpectrumAnnotations();
    }

    private void fractionDetailsJMenuItemActionPerformed(ActionEvent evt) {
        new FractionDetailsDialog(this, true);
    }

    private void reshakeMenuItemActionPerformed(ActionEvent evt) {
    }

    private void quantifyMenuItemActionPerformed(ActionEvent evt) {
        final PeptideShakerGUI finalRef = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ToolFactory.startReporter((JFrame)finalRef);
                }
                catch (Exception e) {
                    PeptideShakerGUI.this.catchException(e);
                }
            }
        }, "StartReporter").start();
    }

    private void reporterPreferencesJMenuItemActionPerformed(ActionEvent evt) {
        try {
            new ReporterSetupDialog((JFrame)this, true);
            this.loadUserParameters();
        }
        catch (Exception ex) {
            this.catchException(ex);
        }
    }

    private void deNovoChargeOneJRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.updateSpectrumAnnotations();
    }

    private void deNovoChargeTwoJRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.updateSpectrumAnnotations();
    }

    private void tipsButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void tipsButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void notesButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void notesButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void newsButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void newsButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void fixedModsJCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        for (String modName : this.getIdentificationParameters().getSearchParameters().getModificationParameters().getFixedModifications()) {
            this.getDisplayParameters().setDisplayedModification(modName, this.fixedModsJCheckBoxMenuItem.isSelected());
        }
        this.updateModificationColorCoding();
    }

    private void validatedProteinsOnlyJCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.getDisplayParameters().showValidatedProteinsOnly(this.validatedProteinsOnlyJCheckBoxMenuItem.isSelected());
        this.resetSelectedItems();
        this.setUpdated(0, false);
        this.setUpdated(2, false);
        this.setUpdated(3, false);
        this.setUpdated(4, false);
        this.setUpdated(6, false);
        this.setUpdated(8, false);
        this.setUpdated(2, false);
        this.updateTabbedPanes();
    }

    private void exportSpectrumAndPlotsGraphicsJMenuItemActionPerformed(ActionEvent evt) {
        int selectedTabIndex = this.allTabsJTabbedPane.getSelectedIndex();
        if (selectedTabIndex == 0) {
            new ExportGraphicsDialog((JFrame)this, this.getNormalIcon(), this.getWaitingIcon(), true, this.overviewPanel.getSpectrumAndPlots(), this.lastSelectedFolder);
        }
    }

    private void exportProjectMenuItemActionPerformed(ActionEvent evt) {
        this.exportProjectAsZip();
    }

    private void speciesJMenuItemActionPerformed(ActionEvent evt) {
        try {
            IdentificationParameters identificationParameters = this.getIdentificationParameters();
            GeneParameters geneParameters = identificationParameters.getGeneParameters();
            FastaSummary fastaSummary = FastaSummary.getSummary((String)this.getProjectDetails().getFastaFile(), (FastaParameters)identificationParameters.getFastaParameters(), null);
            BackgroundSpeciesDialog backgroundSpeciesDialog = new BackgroundSpeciesDialog((JFrame)this, geneParameters, fastaSummary);
            if (!backgroundSpeciesDialog.isCanceled()) {
                geneParameters = backgroundSpeciesDialog.getGeneParameters();
                identificationParameters.setGeneParameters(geneParameters);
                if (this.allTabsJTabbedPane.getSelectedIndex() == 6) {
                    this.goPanel.updateMappings();
                } else {
                    this.updateNeeded.put(6, true);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, new String[]{"FASTA Import Error.", "File " + this.getProjectDetails().getFastaFile() + " could not be imported."}, "FASTA Import Error", 2);
            e.printStackTrace();
        }
    }

    private void newsButtonMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://twitter.com/compomics");
        this.newsButton.setText("News");
        for (String tweetId : this.newTweets) {
            this.utilitiesUserParameters.getReadTweets().add(tweetId);
        }
        for (String tweetId : this.publishedTweets) {
            this.utilitiesUserParameters.getReadTweets().add(tweetId);
        }
        this.publishedTweets.clear();
        UtilitiesUserParameters.saveUserParameters((UtilitiesUserParameters)this.utilitiesUserParameters);
        this.setCursor(new Cursor(0));
    }

    private void notesButtonMouseReleased(MouseEvent evt) {
        NotesDialog notesDialog = new NotesDialog((Frame)this, false, this.currentNotes);
        notesDialog.setLocation(this.getWidth() - notesDialog.getWidth() - 25 + this.getX(), this.getHeight() - notesDialog.getHeight() - 25 + this.getY());
        notesDialog.setVisible(true);
        this.currentNotes = new ArrayList();
        this.updateNotesNotificationCounter();
    }

    private void exportMzIdentMLMenuItemActionPerformed(ActionEvent evt) {
        new MzIdentMLExportDialog(this, true);
    }

    private void openExampleMenuItemActionPerformed(ActionEvent evt) {
        this.openExampleFile();
    }

    private void highResAnnotationCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.updateSpectrumAnnotations();
    }

    private void methodsSectionMenuItemActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new MethodsSectionDialog(this, true);
        this.setCursor(new Cursor(0));
    }

    private void privacyMenuItemActionPerformed(ActionEvent evt) {
        new PrivacyParametersDialog((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
    }

    private void tipsButtonMouseReleased(MouseEvent evt) {
        NotesDialog notesDialog = new NotesDialog((Frame)this, false, this.currentTips);
        notesDialog.setLocation(this.getWidth() - notesDialog.getWidth() - 25 + this.getX(), this.getHeight() - notesDialog.getHeight() - 25 + this.getY());
        notesDialog.setVisible(true);
        this.currentTips = new ArrayList();
        this.updateTipsNotificationCounter();
    }

    private void configurationFilesSettingsActionPerformed(ActionEvent evt) {
        this.editPathSettings(null);
    }

    private void validationQcMenuItemActionPerformed(ActionEvent evt) {
        ValidationQcParameters newParameters;
        final IdMatchValidationParameters idValidationParameters = this.getIdentificationParameters().getIdValidationParameters();
        final ValidationQcParameters validationQCParameters = idValidationParameters.getValidationQCParameters();
        ValidationQCParametersDialog validationQCParametersDialog = new ValidationQCParametersDialog((Frame)this, validationQCParameters, this.getIdentificationParameters().getSearchParameters().getModificationParameters().getAllModifications(), true);
        if (!validationQCParametersDialog.isCanceled() && !(newParameters = validationQCParametersDialog.getValidationQCParameters()).isSameAs(validationQCParameters)) {
            idValidationParameters.setValidationQCParameters(newParameters);
            for (Filter filter : newParameters.getPsmFilters()) {
                PsmFilter psmFilter = (PsmFilter)filter;
                AssumptionFilter assumptionFilter = psmFilter.getAssumptionFilter();
                assumptionFilter.clear();
                for (String itemName : psmFilter.getItemsNames()) {
                    assumptionFilter.setFilterItem(itemName, psmFilter.getComparatorForItem(itemName), psmFilter.getValue(itemName));
                }
            }
            this.progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            this.progressDialog.setTitle("Validating. Please Wait...");
            this.progressDialog.setPrimaryProgressCounterIndeterminate(false);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        PeptideShakerGUI.this.progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("RecalculateThread"){

                @Override
                public void run() {
                    PeptideShakerGUI peptideShakerGUI = PeptideShakerGUI.this;
                    try {
                        PSMaps pSMaps = new PSMaps();
                        pSMaps = (PSMaps)peptideShakerGUI.getIdentification().getUrParam((UrParameter)pSMaps);
                        MatchesValidator matchesValidator = new MatchesValidator(pSMaps.getPsmMap(), pSMaps.getPeptideMap(), pSMaps.getProteinMap());
                        matchesValidator.validateIdentifications(peptideShakerGUI.getIdentification(), peptideShakerGUI.getMetrics(), pSMaps.getInputMap(), (WaitingHandler)PeptideShakerGUI.this.progressDialog, (ExceptionHandler)PeptideShakerGUI.this.exceptionHandler, peptideShakerGUI.getIdentificationFeaturesGenerator(), peptideShakerGUI.getSequenceProvider(), peptideShakerGUI.getProteinDetailsProvider(), peptideShakerGUI.getSpectrumProvider(), peptideShakerGUI.getGeneMaps(), peptideShakerGUI.getIdentificationParameters(), peptideShakerGUI.getProjectType(), peptideShakerGUI.getProcessingParameters());
                        PeptideShakerGUI.this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
                        ProteinProcessor proteinProcessor = new ProteinProcessor(peptideShakerGUI.getIdentification(), peptideShakerGUI.getIdentificationParameters(), peptideShakerGUI.getIdentificationFeaturesGenerator(), peptideShakerGUI.getSequenceProvider());
                        proteinProcessor.processProteins(new ModificationLocalizationScorer(), peptideShakerGUI.getMetrics(), (ModificationProvider)PeptideShakerGUI.this.modificationFactory, (WaitingHandler)PeptideShakerGUI.this.progressDialog, (ExceptionHandler)peptideShakerGUI.getExceptionHandler(), peptideShakerGUI.getProcessingParameters());
                        if (!PeptideShakerGUI.this.progressDialog.isRunCanceled()) {
                            peptideShakerGUI.getMetrics().setnValidatedProteins(-1);
                            peptideShakerGUI.getMetrics().setnConfidentProteins(-1);
                            peptideShakerGUI.setUpdated(0, false);
                            peptideShakerGUI.setUpdated(2, false);
                            peptideShakerGUI.setUpdated(4, false);
                            peptideShakerGUI.setUpdated(3, false);
                            peptideShakerGUI.setUpdated(8, false);
                            peptideShakerGUI.setUpdated(1, false);
                            peptideShakerGUI.setDataSaved(false);
                        } else {
                            idValidationParameters.setValidationQCParameters(validationQCParameters);
                        }
                    }
                    catch (Exception e) {
                        peptideShakerGUI.catchException(e);
                    }
                    PeptideShakerGUI.this.progressDialog.setRunFinished();
                    PeptideShakerGUI.this.repaintPanels();
                }
            }.start();
        }
    }

    private void psmSortScoreRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.utilitiesUserParameters.setSortPsmsOnRt(Boolean.valueOf(!this.psmSortScoreRadioButtonMenuItem.isSelected()));
        this.overviewPanel.updatePsmOrder();
    }

    private void psmSortRtRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.psmSortScoreRadioButtonMenuItemActionPerformed(null);
    }

    private void resetAnnotationMenuSelected(MenuEvent evt) {
        this.defaultAnnotationCheckBoxMenuItem.setSelected(true);
        this.defaultAnnotationCheckBoxMenuItemActionPerformed(null);
    }

    private void processingMenuItemActionPerformed(ActionEvent evt) {
        ProcessingParametersDialog processingParametersDialog = new ProcessingParametersDialog((Frame)this, this.processingParameters, true);
        if (!processingParametersDialog.isCanceled()) {
            this.processingParameters = processingParametersDialog.getProcessingParameters();
        }
    }

    private void editIdSettingsFilesMenuItemActionPerformed(ActionEvent evt) {
        new IdentificationParametersOverviewDialog((Frame)this);
    }

    private void relatedIonsCheckMenuActionPerformed(ActionEvent evt) {
        this.deselectDefaultAnnotationMenuItem();
        this.updateSpectrumAnnotations();
    }

    private void sparklineColorsMenuItemActionPerformed(ActionEvent evt) {
        new SparklineColorsDialog((JFrame)this, this.utilitiesUserParameters);
        this.utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        this.scoresJCheckBoxMenuItemActionPerformed(null);
    }

    private void darkThemeCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.darkTheme = this.darkThemeCheckBoxMenuItem.isSelected();
        try {
            if (this.darkTheme) {
                this.backgroundPanel.setBackground(DARK_THEME_BACKGROUND_COLOR);
                UtilitiesGUIDefaults.setLookAndFeel();
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                UIDefaults defaults = lookAndFeel.getDefaults();
                defaults.put("ScrollBar.minimumThumbSize", new Dimension(30, 30));
                UIManager.put("control", new Color(128, 128, 128));
                UIManager.put("info", new Color(128, 128, 128));
                UIManager.put("nimbusBase", new Color(18, 30, 49));
                UIManager.put("nimbusAlertYellow", new Color(248, 187, 0));
                UIManager.put("nimbusDisabledText", new Color(128, 128, 128));
                UIManager.put("nimbusFocus", new Color(115, 164, 209));
                UIManager.put("nimbusGreen", new Color(176, 179, 50));
                UIManager.put("nimbusInfoBlue", new Color(66, 139, 221));
                UIManager.put("nimbusLightBackground", new Color(18, 30, 49));
                UIManager.put("nimbusOrange", new Color(191, 98, 4));
                UIManager.put("nimbusRed", new Color(169, 46, 34));
                UIManager.put("nimbusSelectedText", new Color(255, 255, 255));
                UIManager.put("nimbusSelectionBackground", new Color(104, 93, 156));
                UIManager.put("text", new Color(230, 230, 230));
                UIManager.put("Table.alternateRowColor", new Color(180, 180, 180));
                defaults.put("defaultFont", new Font("Segoe UI", 0, 12));
                SwingUtilities.updateComponentTreeUI(this);
                this.repaint();
            } else {
                this.backgroundPanel.setBackground(Color.WHITE);
                UtilitiesGUIDefaults.setLookAndFeel();
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                UIDefaults defaults = lookAndFeel.getDefaults();
                defaults.put("ScrollBar.minimumThumbSize", new Dimension(30, 30));
                UIManager.put("control", new Color(214, 217, 223));
                UIManager.put("info", new Color(242, 242, 189));
                UIManager.put("nimbusBase", new Color(51, 98, 140));
                UIManager.put("nimbusAlertYellow", new Color(255, 220, 35));
                UIManager.put("nimbusDisabledText", new Color(142, 143, 145));
                UIManager.put("nimbusFocus", new Color(115, 164, 209));
                UIManager.put("nimbusGreen", new Color(176, 179, 50));
                UIManager.put("nimbusInfoBlue", new Color(47, 92, 180));
                UIManager.put("nimbusLightBackground", new Color(255, 255, 255));
                UIManager.put("nimbusOrange", new Color(191, 98, 4));
                UIManager.put("nimbusRed", new Color(169, 46, 34));
                UIManager.put("nimbusSelectedText", new Color(255, 255, 255));
                UIManager.put("nimbusSelectionBackground", new Color(57, 105, 138));
                UIManager.put("text", new Color(0, 0, 0));
                UIManager.put("Table.alternateRowColor", new Color(242, 242, 242));
                UIManager.getLookAndFeelDefaults().put("Table:\"Table.cellRenderer\".background", Color.WHITE);
                defaults.put("defaultFont", new Font("Segoe UI", 0, 12));
                SwingUtilities.updateComponentTreeUI(this);
                this.repaint();
            }
            this.overviewPanel.enableDarkTheme(this.darkTheme);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void editPathSettings(WelcomeDialog welcomeDialog) {
        try {
            HashMap<PeptideShakerPathParameters.PeptideShakerPathKey, String> pathSettings = new HashMap<PeptideShakerPathParameters.PeptideShakerPathKey, String>();
            for (PeptideShakerPathParameters.PeptideShakerPathKey peptideShakerPathKey : PeptideShakerPathParameters.PeptideShakerPathKey.values()) {
                pathSettings.put(peptideShakerPathKey, PeptideShakerPathParameters.getPathPreference(peptideShakerPathKey));
            }
            for (PeptideShakerPathParameters.PeptideShakerPathKey peptideShakerPathKey : UtilitiesPathParameters.UtilitiesPathKey.values()) {
                pathSettings.put(peptideShakerPathKey, UtilitiesPathParameters.getPathParameter((UtilitiesPathParameters.UtilitiesPathKey)peptideShakerPathKey));
            }
            PathParametersDialog pathSettingsDialog = new PathParametersDialog((Frame)this, "PeptideShaker", pathSettings);
            if (!pathSettingsDialog.isCanceled()) {
                HashMap newSettings = pathSettingsDialog.getKeyToPathMap();
                for (PathKey pathKey : pathSettings.keySet()) {
                    String oldPath = (String)pathSettings.get(pathKey);
                    String newPath = (String)newSettings.get(pathKey);
                    if (!(oldPath == null && newPath != null || oldPath != null && newPath == null) && (oldPath == null || newPath == null || oldPath.equals(newPath))) continue;
                    PeptideShakerPathParameters.setPathParameters(pathKey, newPath);
                }
                File destinationFile = new File(PeptideShaker.getConfigFolder(), "resources/conf/paths.txt");
                PeptideShakerPathParameters.writeConfigurationToFile(destinationFile);
                if (welcomeDialog != null) {
                    welcomeDialog.setVisible(false);
                }
                this.restart();
            }
        }
        catch (Exception e) {
            this.catchException(e);
        }
    }

    public void initiateDisplay() {
        this.allTabsJTabbedPaneStateChanged(null);
    }

    public void displayResults() {
        try {
            this.sequenceCoverageJCheckBoxMenuItem.setSelected(true);
            ArrayList allVariableMods = this.modificationFactory.getModifications();
            for (String tempFixed : this.getIdentificationParameters().getSearchParameters().getModificationParameters().getFixedModifications()) {
                allVariableMods.remove(tempFixed);
            }
            this.getDisplayParameters().setDefaultSelection(allVariableMods);
            this.overviewPanel.setDisplayOptions(true, true, true, true);
            this.overviewPanel.updateSeparators();
            this.validationPanel.updateSeparators();
            this.scoresJCheckBoxMenuItem.setSelected(false);
            this.repaintPanels();
            this.jumpToPanel.setEnabled(true);
            this.saveMenuItem.setEnabled(true);
            this.identificationFeaturesMenuItem.setEnabled(true);
            this.followUpAnalysisMenuItem.setEnabled(true);
            this.projectPropertiesMenuItem.setEnabled(true);
            this.projectSettingsMenuItem.setEnabled(true);
            this.preferencesMenuItem.setEnabled(true);
            this.findJMenuItem.setEnabled(true);
            this.starHideJMenuItem.setEnabled(true);
            this.validationQcMenuItem.setEnabled(true);
            this.ionsMenu.setEnabled(true);
            this.otherMenu.setEnabled(true);
            this.lossMenu.setEnabled(true);
            this.chargeMenu.setEnabled(true);
            this.settingsMenu.setEnabled(true);
            this.exportGraphicsMenu.setEnabled(true);
            this.helpJMenu.setEnabled(true);
            this.scoresJCheckBoxMenuItem.setEnabled(true);
            this.sparklinesJCheckBoxMenuItem.setEnabled(true);
            this.quantifyMenuItem.setEnabled(true);
            this.speciesJMenuItem.setEnabled(true);
            this.spectrumSlidersCheckBoxMenuItem.setSelected(this.getUserParameters().showSliders());
            this.projectExportMenu.setEnabled(true);
            this.exportProjectMenuItem.setEnabled(true);
            if (null != this.psdbParent.getProjectType()) {
                switch (this.psdbParent.getProjectType()) {
                    case protein: {
                        this.allTabsJTabbedPane.setEnabledAt(0, true);
                        this.allTabsJTabbedPane.setEnabledAt(1, true);
                        boolean fractions = this.getIdentification().getFractions().size() > 1;
                        this.allTabsJTabbedPane.setEnabledAt(2, fractions);
                        this.fractionDetailsJMenuItem.setEnabled(fractions);
                        this.allTabsJTabbedPane.setEnabledAt(3, true);
                        this.allTabsJTabbedPane.setEnabledAt(4, true);
                        this.allTabsJTabbedPane.setEnabledAt(5, true);
                        this.allTabsJTabbedPane.setEnabledAt(6, true);
                        this.allTabsJTabbedPane.setEnabledAt(7, true);
                        this.allTabsJTabbedPane.setEnabledAt(8, true);
                        this.allTabsJTabbedPane.setSelectedIndex(0);
                        this.exportMzIdentMLMenuItem.setEnabled(true);
                        this.exportMzIdentMLMenuItem.setToolTipText("Export the project as mzIdentML");
                        break;
                    }
                    case peptide: {
                        this.allTabsJTabbedPane.setEnabledAt(0, false);
                        this.allTabsJTabbedPane.setEnabledAt(1, true);
                        this.allTabsJTabbedPane.setEnabledAt(2, false);
                        this.allTabsJTabbedPane.setEnabledAt(3, true);
                        this.allTabsJTabbedPane.setEnabledAt(4, false);
                        this.allTabsJTabbedPane.setEnabledAt(5, false);
                        this.allTabsJTabbedPane.setEnabledAt(6, false);
                        this.allTabsJTabbedPane.setEnabledAt(7, true);
                        this.allTabsJTabbedPane.setEnabledAt(8, true);
                        this.allTabsJTabbedPane.setSelectedIndex(1);
                        this.exportMzIdentMLMenuItem.setEnabled(false);
                        this.exportMzIdentMLMenuItem.setToolTipText("Not available for your PeptideShaker project type");
                        break;
                    }
                    case psm: {
                        this.allTabsJTabbedPane.setEnabledAt(0, false);
                        this.allTabsJTabbedPane.setEnabledAt(1, true);
                        this.allTabsJTabbedPane.setEnabledAt(2, false);
                        this.allTabsJTabbedPane.setEnabledAt(3, false);
                        this.allTabsJTabbedPane.setEnabledAt(4, false);
                        this.allTabsJTabbedPane.setEnabledAt(5, false);
                        this.allTabsJTabbedPane.setEnabledAt(6, false);
                        this.allTabsJTabbedPane.setEnabledAt(7, true);
                        this.allTabsJTabbedPane.setEnabledAt(8, true);
                        this.allTabsJTabbedPane.setSelectedIndex(1);
                        this.exportMzIdentMLMenuItem.setEnabled(false);
                        this.exportMzIdentMLMenuItem.setToolTipText("Not available for your PeptideShaker project type");
                        break;
                    }
                }
            }
            boolean targetDecoy = this.getIdentificationParameters().getFastaParameters().isTargetDecoy();
            this.allTabsJTabbedPane.setEnabledAt(7, targetDecoy);
            this.validatedProteinsOnlyJCheckBoxMenuItem.setEnabled(targetDecoy);
        }
        catch (Exception e) {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
            e.printStackTrace();
            this.catchException(e);
            JOptionPane.showMessageDialog(null, "A problem occurred when loading the data.\nSee /resources/PeptideShaker.log for more details.", "Loading Failed!", 0);
        }
    }

    public void disableSpectrumDisplay() {
        this.spectrumJPanel.setEnabled(false);
        this.modificationsPanel.setEnabled(false);
        this.overviewPanel.updateSeparators();
    }

    public void setUpLogFile(boolean redirectOutputStream) {
        if (useLogFile && !PeptideShaker.getConfigFolder().toString().equalsIgnoreCase(".")) {
            try {
                String path = PeptideShaker.getConfigFolder() + "/resources/PeptideShaker.log";
                File file = new File(path);
                System.setErr(new PrintStream(new FileOutputStream(file, true)));
                if (redirectOutputStream) {
                    System.setOut(new PrintStream(new FileOutputStream(file, true)));
                }
                if (!file.exists()) {
                    boolean fileCreated = file.createNewFile();
                    if (fileCreated) {
                        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                        bw.close();
                    } else {
                        JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane((String)"Failed to create the file log file.<br>Please <a href=\"https://github.com/compomics/peptide-shaker/issues\">contact the developers</a>."), "File Error", 0);
                    }
                }
                System.err.println(System.getProperty("line.separator") + System.getProperty("line.separator") + new Date() + ": PeptideShaker version " + PeptideShaker.getVersion() + ".");
                System.err.println("Memory given to the Java virtual machine: " + Runtime.getRuntime().maxMemory() + ".");
                System.err.println("Total amount of memory in the Java virtual machine: " + Runtime.getRuntime().totalMemory() + ".");
                System.err.println("Free memory: " + Runtime.getRuntime().freeMemory() + ".");
                System.err.println("Java version: " + System.getProperty("java.version") + ".");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "An error occurred when trying to create the PeptideShaker log file.", "Error Creating Log File", 0);
                e.printStackTrace();
            }
        }
    }

    public UserParameters getUserParameters() {
        return this.psdbParent.getUserParameters();
    }

    public UtilitiesUserParameters getUtilitiesUserParameters() {
        return this.utilitiesUserParameters;
    }

    public void setUtilitiesUserParameters(UtilitiesUserParameters utilitiesUserParameters) {
        this.utilitiesUserParameters = utilitiesUserParameters;
    }

    public void setDefaultParameters() {
        this.psdbParent.setDefaultParameters();
        this.updateAnnotationMenu();
    }

    public void updateAnnotationMenu() {
        IdentificationParameters identificationParameters = this.getIdentificationParameters();
        AnnotationParameters annotationParameters = identificationParameters.getAnnotationParameters();
        SearchParameters searchParameters = identificationParameters.getSearchParameters();
        if (searchParameters.getForwardIons().contains(0)) {
            this.forwardIonsDeNovoCheckBoxMenuItem.setText("a-ions");
        }
        if (searchParameters.getForwardIons().contains(1)) {
            this.forwardIonsDeNovoCheckBoxMenuItem.setText("b-ions");
        }
        if (searchParameters.getForwardIons().contains(2)) {
            this.forwardIonsDeNovoCheckBoxMenuItem.setText("c-ions");
        }
        this.forwardIonsDeNovoCheckBoxMenuItem.repaint();
        if (searchParameters.getRewindIons().contains(3)) {
            this.rewindIonsDeNovoCheckBoxMenuItem.setText("x-ions");
        }
        if (searchParameters.getRewindIons().contains(4)) {
            this.rewindIonsDeNovoCheckBoxMenuItem.setText("y-ions");
        }
        if (searchParameters.getRewindIons().contains(5)) {
            this.rewindIonsDeNovoCheckBoxMenuItem.setText("z-ions");
        }
        this.rewindIonsDeNovoCheckBoxMenuItem.repaint();
        if (annotationParameters.getDeNovoCharge() == 1) {
            this.deNovoChargeOneJRadioButtonMenuItem.isSelected();
        } else {
            this.deNovoChargeTwoJRadioButtonMenuItem.isSelected();
        }
    }

    public void updateSpectrumAnnotations() {
        int selectedTabIndex = this.allTabsJTabbedPane.getSelectedIndex();
        IdentificationParameters identificationParameters = this.getIdentificationParameters();
        AnnotationParameters annotationParameters = identificationParameters.getAnnotationParameters();
        SearchParameters searchParameters = identificationParameters.getSearchParameters();
        if (selectedTabIndex == 0) {
            this.overviewPanel.setIntensitySliderValue((int)(annotationParameters.getAnnotationIntensityLimit() * 100.0));
            this.overviewPanel.setAccuracySliderValue((int)(annotationParameters.getFragmentIonAccuracy() / searchParameters.getFragmentIonAccuracy() * 100.0));
            this.overviewPanel.updateSpectrum();
        } else if (selectedTabIndex == 1) {
            this.spectrumIdentificationPanel.setIntensitySliderValue((int)(annotationParameters.getAnnotationIntensityLimit() * 100.0));
            this.spectrumIdentificationPanel.setAccuracySliderValue((int)(annotationParameters.getFragmentIonAccuracy() / searchParameters.getFragmentIonAccuracy() * 100.0));
            this.spectrumIdentificationPanel.updateSpectrum();
        } else if (selectedTabIndex == 3) {
            this.modificationsPanel.setIntensitySliderValue((int)(annotationParameters.getAnnotationIntensityLimit() * 100.0));
            this.modificationsPanel.setAccuracySliderValue((int)(annotationParameters.getFragmentIonAccuracy() / searchParameters.getFragmentIonAccuracy() * 100.0));
            this.modificationsPanel.updateGraphics(null);
        }
    }

    public void updateModificationColorCoding() {
        this.modificationsPanel.updateModificationColors();
        this.overviewPanel.updateModificationColors();
        this.spectrumIdentificationPanel.updateModificationColors();
        this.proteinStructurePanel.updateModificationColors();
    }

    public ProjectParameters getProjectParameters() {
        return this.psdbParent.getProjectParameters();
    }

    public Identification getIdentification() {
        return this.psdbParent.getIdentification();
    }

    public SequenceProvider getSequenceProvider() {
        return this.psdbParent.getSequenceProvider();
    }

    public SpectrumProvider getSpectrumProvider() {
        return this.psdbParent.getSpectrumProvider();
    }

    public void setSequenceProvider(SequenceProvider sequenceProvider) {
        this.psdbParent.setSequenceProvider(sequenceProvider);
    }

    public ProteinDetailsProvider getProteinDetailsProvider() {
        return this.psdbParent.getProteinDetailsProvider();
    }

    public void setProteinDetailsProvider(ProteinDetailsProvider proteinDetailsProvider) {
        this.psdbParent.setProteinDetailsProvider(proteinDetailsProvider);
    }

    public void setMsFileHandler(MsFileHandler msFileHandler) {
        this.psdbParent.setMsFileHandler(msFileHandler);
    }

    public void setIdentification(Identification identification) {
        this.psdbParent.setIdentification(identification);
    }

    public FilterParameters getFilterParameters() {
        return this.psdbParent.getFilterParameters();
    }

    public DisplayParameters getDisplayParameters() {
        return this.psdbParent.getDisplayParameters();
    }

    public void setFilterParameters(FilterParameters filterParameters) {
        this.psdbParent.setFilterParameters(filterParameters);
    }

    public void setDisplayParameters(DisplayParameters displayParameters) {
        this.psdbParent.setDisplayParameters(displayParameters);
    }

    public SpectrumCountingParameters getSpectrumCountingParameters() {
        return this.psdbParent.getSpectrumCountingParameters();
    }

    public void setSpectrumCountingParameters(SpectrumCountingParameters spectrumCountingParameters) {
        this.psdbParent.setSpectrumCountingParameters(spectrumCountingParameters);
    }

    public IdentificationParameters getIdentificationParameters() {
        return this.psdbParent.getIdentificationParameters();
    }

    public void setIdentificationParameters(IdentificationParameters identificationParameters) {
        this.psdbParent.setIdentificationParameters(identificationParameters);
        this.setSelectedItems();
        this.backgroundPanel.revalidate();
        this.backgroundPanel.repaint();
        this.dataSaved = false;
    }

    public ProcessingParameters getProcessingParameters() {
        return this.processingParameters;
    }

    public void setProcessingParameters(ProcessingParameters processingParameters) {
        this.processingParameters = processingParameters;
    }

    public void resetModificationFactory() {
        this.modificationFactory.reloadFactory();
        this.modificationFactory = ModificationFactory.getInstance();
    }

    public Color getSparklineColor() {
        return this.utilitiesUserParameters.getSparklineColor();
    }

    public void setSparklineColor(Color sparklineColor) {
        this.utilitiesUserParameters.setSparklineColor(sparklineColor);
    }

    public Color getSparklineColorNonValidated() {
        return this.utilitiesUserParameters.getSparklineColorNonValidated();
    }

    public void setSparklineColorNonValidated(Color sparklineColorNonValidated) {
        this.utilitiesUserParameters.setSparklineColorNonValidated(sparklineColorNonValidated);
    }

    public Color getSparklineColorNotFound() {
        return this.utilitiesUserParameters.getSparklineColorNotFound();
    }

    public Color getSparklineColorPossible() {
        return this.utilitiesUserParameters.getSparklineColorPossible();
    }

    public void setSparklineColorPossible(Color sparklineColorPossible) {
        this.utilitiesUserParameters.setSparklineColorPossible(sparklineColorPossible);
    }

    public double getBubbleScale() {
        return this.bubbleScale;
    }

    public void setSelectedItems(long proteinKey, long peptideKey, String spectrumFile, String spectrumTitle) {
        this.selectedProteinKey = proteinKey;
        this.selectedPeptideKey = peptideKey;
        this.selectedSpectrumFile = spectrumFile;
        this.selectedSpectrumTitle = spectrumTitle;
    }

    public void updateSelectionInCurrentTab() {
        int selectedIndex = this.allTabsJTabbedPane.getSelectedIndex();
        switch (selectedIndex) {
            case 0: {
                this.overviewPanel.updateSelection(true);
                return;
            }
            case 4: {
                this.proteinStructurePanel.updateSelection(true);
                return;
            }
            case 1: {
                this.spectrumIdentificationPanel.updateSelection();
                return;
            }
            case 3: {
                this.modificationsPanel.updateSelection();
                return;
            }
            case 2: {
                this.proteinFractionsPanel.updateSelection();
                return;
            }
        }
    }

    public void resetSelectedItems() {
        this.setSelectedItems(ExperimentObject.NO_KEY, ExperimentObject.NO_KEY, null, null);
    }

    public void setSelectedItems() {
        int selectedIndex = this.allTabsJTabbedPane.getSelectedIndex();
        if (selectedIndex == 0) {
            this.overviewPanel.newItemSelection();
        } else if (selectedIndex == 3) {
            this.modificationsPanel.newItemSelection();
        } else if (selectedIndex == 4) {
            this.proteinStructurePanel.newItemSelection();
        } else if (selectedIndex == 2) {
            this.proteinFractionsPanel.newItemSelection();
        }
    }

    public long getSelectedProteinKey() {
        return this.selectedProteinKey;
    }

    public long getSelectedPeptideKey() {
        return this.selectedPeptideKey;
    }

    public String getSelectedSpectrumFile() {
        return this.selectedSpectrumFile;
    }

    public String getSelectedSpectrumTitle() {
        return this.selectedSpectrumTitle;
    }

    public void clearData(boolean clearDatabaseFolder, boolean updateGuiComponents) {
        this.selectedProteinKey = ExperimentObject.NO_KEY;
        this.selectedPeptideKey = ExperimentObject.NO_KEY;
        this.selectedSpectrumFile = null;
        this.selectedSpectrumTitle = null;
        this.psdbParent.setProjectDetails(null);
        this.resetIdentificationFeaturesGenerator();
        if (updateGuiComponents) {
            this.scoresJCheckBoxMenuItem.setSelected(false);
            this.setUpPanels(true);
            this.repaintPanels();
        }
        if (clearDatabaseFolder) {
            this.clearDatabaseFolder();
        }
        this.psdbParent.setPsdbFile(null);
        this.psdbParent.close();
        this.dataSaved = false;
    }

    private void clearDatabaseFolder() {
        File matchFolder;
        boolean databaseClosed = true;
        if (this.getIdentification() != null) {
            try {
                this.getIdentification().close(false);
                this.psdbParent.setIdentification(null);
            }
            catch (Exception e) {
                databaseClosed = false;
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Failed to close the database.", "Database Error", 2);
            }
        }
        if (databaseClosed && (matchFolder = PeptideShaker.getMatchesFolder()).exists()) {
            File[] tempFiles = matchFolder.listFiles();
            if (tempFiles != null) {
                for (File currentFile : tempFiles) {
                    IoUtil.deleteDir((File)currentFile);
                }
            }
            if (matchFolder.listFiles() != null && matchFolder.listFiles().length > 0) {
                JOptionPane.showMessageDialog(null, "Failed to empty the database folder:\n" + matchFolder.getPath() + ".", "Database Cleanup Failed", 2);
            }
        }
    }

    public void clearParameters() {
        this.resetModificationFactory();
        this.setDefaultParameters();
    }

    private void resetPanel(int tabIndex) {
        switch (tabIndex) {
            case 0: {
                this.overviewPanel.clearData();
                return;
            }
            case 3: {
                this.modificationsPanel = new ModificationsPanel(this);
                this.modificationJPanel.removeAll();
                this.modificationJPanel.add(this.modificationsPanel);
                return;
            }
            case 1: {
                this.spectrumIdentificationPanel = new SpectrumIdentificationPanel(this);
                this.spectrumJPanel.removeAll();
                this.spectrumJPanel.add(this.spectrumIdentificationPanel);
                return;
            }
            case 2: {
                this.proteinFractionsPanel = new ProteinFractionsPanel(this);
                this.proteinFractionsJPanel.removeAll();
                this.proteinFractionsJPanel.add(this.proteinFractionsPanel);
                return;
            }
            case 4: {
                this.proteinStructurePanel.clearData();
                return;
            }
            case 5: {
                this.annotationPanel = new AnnotationPanel(this);
                this.annotationsJPanel.removeAll();
                this.annotationsJPanel.add(this.annotationPanel);
                return;
            }
            case 8: {
                this.qcPanel = new QCPanel(this);
                this.qcJPanel.removeAll();
                this.qcJPanel.add(this.qcPanel);
                return;
            }
            case 6: {
                this.goPanel = new GOEAPanel(this);
                this.goJPanel.removeAll();
                this.goJPanel.add(this.goPanel);
                return;
            }
            case 7: {
                this.validationPanel = new ValidationPanel(this);
                this.statsJPanel.removeAll();
                this.statsJPanel.add(this.validationPanel);
            }
        }
    }

    private void setUpPanels(boolean setupValidationTab) {
        this.updateNeeded = new HashMap();
        for (int tabIndex = 0; tabIndex < this.allTabsJTabbedPane.getTabCount(); ++tabIndex) {
            if (tabIndex == 7) {
                if (setupValidationTab) {
                    this.updateNeeded.put(tabIndex, true);
                    this.resetPanel(tabIndex);
                    continue;
                }
                this.updateNeeded.put(tabIndex, false);
                continue;
            }
            this.updateNeeded.put(tabIndex, true);
            this.resetPanel(tabIndex);
        }
    }

    private void repaintPanels() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PeptideShakerGUI.this.overviewPanel.updateSeparators();
                PeptideShakerGUI.this.overviewJPanel.revalidate();
                PeptideShakerGUI.this.overviewJPanel.repaint();
            }
        });
        this.validationPanel.updatePlotSizes();
        this.statsJPanel.revalidate();
        this.statsJPanel.repaint();
        this.modificationJPanel.revalidate();
        this.modificationJPanel.repaint();
        this.spectrumJPanel.revalidate();
        this.spectrumJPanel.repaint();
        this.proteinFractionsJPanel.revalidate();
        this.proteinFractionsJPanel.repaint();
        this.proteinStructureJPanel.revalidate();
        this.proteinStructureJPanel.repaint();
        this.annotationsJPanel.revalidate();
        this.annotationsJPanel.repaint();
        this.qcPanel.revalidate();
        this.qcPanel.repaint();
        this.goPanel.revalidate();
        this.goPanel.repaint();
    }

    public OverviewPanel getOverviewPanel() {
        return this.overviewPanel;
    }

    public ProteinFractionsPanel getProteinFractionsPanel() {
        return this.proteinFractionsPanel;
    }

    public ValidationPanel getValidationPanel() {
        return this.validationPanel;
    }

    public ModificationsPanel getModificationsPanel() {
        return this.modificationsPanel;
    }

    public ProteinStructurePanel getProteinStructurePanel() {
        return this.proteinStructurePanel;
    }

    public SpectrumIdentificationPanel getSpectrumIdentificationPanel() {
        return this.spectrumIdentificationPanel;
    }

    public GOEAPanel getGOPanel() {
        return this.goPanel;
    }

    public int getPreferredColumnWidth(JTable table, int colIndex, int margin) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        TableColumn col = colModel.getColumn(colIndex);
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        int width = comp.getPreferredSize().width;
        for (int r = 0; r < table.getRowCount(); ++r) {
            renderer = table.getCellRenderer(r, colIndex);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, colIndex), false, false, r, colIndex);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        return width += 2 * margin;
    }

    public void enableSpectrumExport(boolean enable) {
        if (this.exportSpectrumGraphicsJMenuItem.isVisible()) {
            this.exportSpectrumGraphicsJMenuItem.setEnabled(enable);
        }
    }

    public void updateMainMatch(String mainMatch, int proteinInferenceType) {
        try {
            ModificationLocalizationScorer ptmScorer = new ModificationLocalizationScorer();
            Identification identification = this.getIdentification();
            SequenceProvider sequenceProvider = this.getSequenceProvider();
            ProteinMatch proteinMatch = identification.getProteinMatch(this.selectedProteinKey);
            ptmScorer.scorePTMs(identification, proteinMatch, this.getIdentificationParameters(), false, (ModificationProvider)this.modificationFactory, sequenceProvider, null);
        }
        catch (Exception e) {
            this.catchException(e);
        }
        this.overviewPanel.updateProteinTable();
        this.proteinStructurePanel.updateMainMatch(mainMatch, proteinInferenceType);
    }

    public void setDataSaved(boolean dataSaved) {
        if (!this.openingExistingProject) {
            this.dataSaved = dataSaved;
        }
    }

    public int getSelectedTab() {
        return this.allTabsJTabbedPane.getSelectedIndex();
    }

    public long[] getDisplayedProteins() {
        int selectedTab = this.getSelectedTab();
        switch (selectedTab) {
            case 0: {
                return this.overviewPanel.getDisplayedProteins();
            }
            case 4: {
                return this.proteinStructurePanel.getDisplayedProteins();
            }
            case 2: {
                return this.proteinFractionsPanel.getDisplayedProteins();
            }
            case 3: {
                return this.modificationsPanel.getDisplayedProteinMatches();
            }
        }
        return null;
    }

    public long[] getDisplayedPeptides() {
        int selectedTab = this.getSelectedTab();
        switch (selectedTab) {
            case 0: {
                return this.overviewPanel.getDisplayedPeptides();
            }
            case 4: {
                return this.proteinStructurePanel.getDisplayedPeptides();
            }
            case 2: {
                return this.proteinFractionsPanel.getDisplayedPeptides();
            }
            case 3: {
                return this.modificationsPanel.getDisplayedPeptides();
            }
        }
        return null;
    }

    public long[] getDisplayedSpectrumMatches() {
        int selectedTab = this.getSelectedTab();
        switch (selectedTab) {
            case 0: {
                return this.overviewPanel.getDisplayedSpectrumMatches();
            }
            case 3: {
                return this.modificationsPanel.getDisplayedSpectrumMatches();
            }
        }
        return null;
    }

    public long[] getDisplayedAssumptions() {
        int selectedTab = this.getSelectedTab();
        switch (selectedTab) {
            case 0: {
                return this.overviewPanel.getDisplayedSpectrumMatches();
            }
            case 3: {
                return this.modificationsPanel.getDisplayedSpectrumMatches();
            }
        }
        return null;
    }

    public void openProteinLinks(String links) {
        links = links.substring("<html><a href=\"".length());
        String[] allLinks = links.split("<a href=\"");
        int value = 0;
        if (allLinks.length > 5) {
            value = JOptionPane.showConfirmDialog(this, "This will open " + allLinks.length + " tabs in your web browser. Continue?", "Open Tabs?", 0, 3);
        }
        if (value == 0) {
            this.setCursor(new Cursor(3));
            for (String link : allLinks) {
                link = link.substring(0, link.indexOf("\""));
                BareBonesBrowserLaunch.openURL((String)link);
            }
            this.setCursor(new Cursor(0));
        }
    }

    public DecimalFormat getScoreAndConfidenceDecimalFormat() {
        return this.scoreAndConfidenceDecimalFormat;
    }

    public void catchException(Exception e) {
        this.exceptionHandler.catchException(e);
    }

    public FrameExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void close() {
        if (this.getExtendedState() == 1 || !this.isActive()) {
            this.setExtendedState(6);
        }
        if (!this.dataSaved && this.getProjectParameters() != null) {
            int value = JOptionPane.showConfirmDialog(this, "Do you want to save the changes to " + this.getProjectParameters().getProjectUniqueName() + "?", "Unsaved Changes", 1, 3);
            if (value == 0) {
                this.saveProjectAs(true, false);
            } else if (value == 1) {
                this.closePeptideShaker();
            }
        } else {
            this.closePeptideShaker();
        }
    }

    private void closePeptideShaker() {
        this.exceptionHandler.setIgnoreExceptions(true);
        this.progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.getProgressBar().setStringPainted(false);
        this.progressDialog.getProgressBar().setIndeterminate(true);
        this.progressDialog.setTitle("Closing. Please Wait...");
        final PeptideShakerGUI finalRef = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PeptideShakerGUI.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    PeptideShakerGUI.this.overviewPanel.selfUpdating(false);
                    PeptideShakerGUI.this.proteinFractionsPanel.selfUpdating(false);
                    PeptideShakerGUI.this.proteinStructurePanel.selfUpdating(false);
                    if (!PeptideShakerGUI.this.progressDialog.isRunCanceled()) {
                        PeptideShakerGUI.this.psdbParent.saveUserParameters();
                        PeptideShakerGUI.this.psdbParent.close();
                        TempFilesManager.deleteTempFolders();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PeptideShakerGUI.this.catchException(e);
                }
                finally {
                    PeptideShakerGUI.this.progressDialog.setRunFinished();
                    finalRef.setVisible(false);
                    PeptideShakerGUI.this.clearData(true, true);
                    System.exit(0);
                }
            }
        });
    }

    public void restart() {
        if (this.getExtendedState() == 1 || !this.isActive()) {
            this.setExtendedState(6);
        }
        if (!this.dataSaved && this.getProjectParameters() != null) {
            int value = JOptionPane.showConfirmDialog(this, "Do you want to save the changes to " + this.getProjectParameters().getProjectUniqueName() + "?", "Unsaved Changes", 1, 3);
            if (value == 0) {
                this.saveMenuItemActionPerformed(null);
            } else if (value == 2 || value == -1) {
                return;
            }
        }
        this.progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.getProgressBar().setStringPainted(false);
        this.progressDialog.getProgressBar().setIndeterminate(true);
        this.progressDialog.setTitle("Closing. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PeptideShakerGUI.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("RestartThread"){

            @Override
            public void run() {
                try {
                    PeptideShakerGUI.this.psdbParent.saveUserParameters();
                    PeptideShakerGUI.this.clearData(true, false);
                    TempFilesManager.deleteTempFolders();
                    UtilitiesUserParameters.saveUserParameters((UtilitiesUserParameters)PeptideShakerGUI.this.utilitiesUserParameters);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PeptideShakerGUI.this.catchException(e);
                }
                PeptideShakerGUI.this.progressDialog.setRunFinished();
                PeptideShakerGUI.this.dispose();
                new PeptideShakerWrapper();
                System.exit(0);
            }
        }.start();
    }

    public void updateAnnotationMenus(SpecificAnnotationParameters specificAnnotationParameters, int precursorCharge, HashSet<String> modNames) {
        this.aIonCheckBoxMenuItem.setSelected(false);
        this.bIonCheckBoxMenuItem.setSelected(false);
        this.cIonCheckBoxMenuItem.setSelected(false);
        this.xIonCheckBoxMenuItem.setSelected(false);
        this.yIonCheckBoxMenuItem.setSelected(false);
        this.zIonCheckBoxMenuItem.setSelected(false);
        this.precursorCheckMenu.setSelected(false);
        this.immoniumIonsCheckMenu.setSelected(false);
        this.relatedIonsCheckMenu.setSelected(false);
        this.reporterIonsCheckMenu.setSelected(false);
        block15: for (Ion.IonType ionType : specificAnnotationParameters.getIonTypes().keySet()) {
            if (null == ionType) continue;
            switch (ionType) {
                case IMMONIUM_ION: {
                    this.immoniumIonsCheckMenu.setSelected(true);
                    break;
                }
                case RELATED_ION: {
                    this.relatedIonsCheckMenu.setSelected(true);
                    break;
                }
                case PRECURSOR_ION: {
                    this.precursorCheckMenu.setSelected(true);
                    break;
                }
                case REPORTER_ION: {
                    this.reporterIonsCheckMenu.setSelected(true);
                    break;
                }
                case PEPTIDE_FRAGMENT_ION: {
                    Iterator iterator = ((HashSet)specificAnnotationParameters.getIonTypes().get(ionType)).iterator();
                    while (iterator.hasNext()) {
                        int subtype = (Integer)iterator.next();
                        switch (subtype) {
                            case 0: {
                                this.aIonCheckBoxMenuItem.setSelected(true);
                                break;
                            }
                            case 1: {
                                this.bIonCheckBoxMenuItem.setSelected(true);
                                break;
                            }
                            case 2: {
                                this.cIonCheckBoxMenuItem.setSelected(true);
                                break;
                            }
                            case 3: {
                                this.xIonCheckBoxMenuItem.setSelected(true);
                                break;
                            }
                            case 4: {
                                this.yIonCheckBoxMenuItem.setSelected(true);
                                break;
                            }
                            case 5: {
                                this.zIonCheckBoxMenuItem.setSelected(true);
                                break;
                            }
                        }
                    }
                    continue block15;
                }
            }
        }
        for (JCheckBoxMenuItem lossMenuItem : this.lossMenus.values()) {
            this.lossMenu.remove(lossMenuItem);
        }
        this.lossMenu.setVisible(true);
        this.lossSplitter.setVisible(true);
        this.lossMenus.clear();
        TreeSet lossesNames = new TreeSet();
        lossesNames.addAll(IonFactory.getDefaultNeutralLosses());
        lossesNames.addAll(modNames.stream().flatMap(modName -> this.modificationFactory.getModification(modName).getNeutralLosses().stream()).map(neutralLoss -> neutralLoss.name).collect(Collectors.toSet()));
        if (lossesNames.isEmpty()) {
            this.lossMenu.setVisible(false);
            this.lossSplitter.setVisible(false);
        } else {
            int lossCounter = 0;
            for (String neutralLossName : lossesNames) {
                NeutralLoss neutralLoss2 = NeutralLoss.getNeutralLoss((String)neutralLossName);
                boolean selected = false;
                for (String specificNeutralLossName : specificAnnotationParameters.getNeutralLossesMap().getAccountedNeutralLosses()) {
                    NeutralLoss specificNeutralLoss = NeutralLoss.getNeutralLoss((String)specificNeutralLossName);
                    if (!neutralLoss2.isSameAs(specificNeutralLoss)) continue;
                    selected = true;
                    break;
                }
                JCheckBoxMenuItem lossMenuItem = new JCheckBoxMenuItem(neutralLossName);
                lossMenuItem.setSelected(selected);
                lossMenuItem.setEnabled(!specificAnnotationParameters.isNeutralLossesAuto());
                lossMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        PeptideShakerGUI.this.deselectDefaultAnnotationMenuItem();
                        PeptideShakerGUI.this.updateSpectrumAnnotations();
                    }
                });
                this.lossMenus.put(neutralLoss2, lossMenuItem);
                this.lossMenu.add((Component)lossMenuItem, lossCounter++);
            }
            this.adaptCheckBoxMenuItem.setSelected(specificAnnotationParameters.isNeutralLossesAuto());
        }
        this.chargeMenus.clear();
        this.chargeMenu.removeAll();
        Integer charge = 1;
        while (charge < Math.max(precursorCharge, 2)) {
            Serializable chargeMenuItem = new JCheckBoxMenuItem(charge + "+");
            chargeMenuItem.setSelected(specificAnnotationParameters.getSelectedCharges().contains(charge));
            chargeMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PeptideShakerGUI.this.deselectDefaultAnnotationMenuItem();
                    PeptideShakerGUI.this.updateSpectrumAnnotations();
                }
            });
            this.chargeMenus.put(charge, (JCheckBoxMenuItem)chargeMenuItem);
            this.chargeMenu.add((JMenuItem)chargeMenuItem);
            chargeMenuItem = charge;
            charge = charge + 1;
        }
        AnnotationParameters annotationParameters = this.getIdentificationParameters().getAnnotationParameters();
        this.highResAnnotationCheckBoxMenuItem.setSelected(annotationParameters.getTiesResolution() == SpectrumAnnotator.TiesResolution.mostAccurateMz);
        this.allCheckBoxMenuItem.setSelected(annotationParameters.showAllPeaks());
        DisplayParameters displayParameters = this.getDisplayParameters();
        this.barsCheckBoxMenuItem.setSelected(displayParameters.showBars());
        this.intensityIonTableRadioButtonMenuItem.setSelected(displayParameters.useIntensityIonTable());
    }

    public SpecificAnnotationParameters getSpecificAnnotationParameters(String spectrumFile, String spectrumTitle, SpectrumIdentificationAssumption spectrumIdentificationAssumption) {
        SequenceProvider sequenceProvider = this.getSequenceProvider();
        IdentificationParameters identificationParameters = this.getIdentificationParameters();
        ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
        SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
        AnnotationParameters annotationParameters = this.getIdentificationParameters().getAnnotationParameters();
        SpecificAnnotationParameters specificAnnotationParameters = annotationParameters.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, spectrumIdentificationAssumption, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, (SpectrumAnnotator)new PeptideSpectrumAnnotator());
        if (!this.defaultAnnotationCheckBoxMenuItem.isSelected()) {
            Iterator<NeutralLoss> reporterIons;
            specificAnnotationParameters.clearIonTypes();
            if (this.aIonCheckBoxMenuItem.isSelected()) {
                specificAnnotationParameters.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, 0);
                specificAnnotationParameters.addIonType(Ion.IonType.TAG_FRAGMENT_ION, 0);
            }
            if (this.bIonCheckBoxMenuItem.isSelected()) {
                specificAnnotationParameters.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, 1);
                specificAnnotationParameters.addIonType(Ion.IonType.TAG_FRAGMENT_ION, 1);
            }
            if (this.cIonCheckBoxMenuItem.isSelected()) {
                specificAnnotationParameters.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, 2);
                specificAnnotationParameters.addIonType(Ion.IonType.TAG_FRAGMENT_ION, 2);
            }
            if (this.xIonCheckBoxMenuItem.isSelected()) {
                specificAnnotationParameters.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, 3);
                specificAnnotationParameters.addIonType(Ion.IonType.TAG_FRAGMENT_ION, 3);
            }
            if (this.yIonCheckBoxMenuItem.isSelected()) {
                specificAnnotationParameters.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, 4);
                specificAnnotationParameters.addIonType(Ion.IonType.TAG_FRAGMENT_ION, 4);
            }
            if (this.zIonCheckBoxMenuItem.isSelected()) {
                specificAnnotationParameters.addIonType(Ion.IonType.PEPTIDE_FRAGMENT_ION, 5);
                specificAnnotationParameters.addIonType(Ion.IonType.TAG_FRAGMENT_ION, 5);
            }
            if (this.precursorCheckMenu.isSelected()) {
                specificAnnotationParameters.addIonType(Ion.IonType.PRECURSOR_ION);
            }
            if (this.immoniumIonsCheckMenu.isSelected()) {
                specificAnnotationParameters.addIonType(Ion.IonType.IMMONIUM_ION);
            }
            if (this.relatedIonsCheckMenu.isSelected()) {
                specificAnnotationParameters.addIonType(Ion.IonType.RELATED_ION);
            }
            if (this.reporterIonsCheckMenu.isSelected()) {
                reporterIons = new ArrayList(IonFactory.getReporterIons((ModificationParameters)this.getIdentificationParameters().getSearchParameters().getModificationParameters()));
                Iterator iterator = ((ArrayList)((Object)reporterIons)).iterator();
                while (iterator.hasNext()) {
                    int subtype = (Integer)iterator.next();
                    specificAnnotationParameters.addIonType(Ion.IonType.REPORTER_ION, subtype);
                }
            }
            if (!this.adaptCheckBoxMenuItem.isSelected()) {
                specificAnnotationParameters.setNeutralLossesAuto(false);
                specificAnnotationParameters.clearNeutralLosses();
                for (NeutralLoss neutralLoss : this.lossMenus.keySet()) {
                    if (!this.lossMenus.get(neutralLoss).isSelected()) continue;
                    specificAnnotationParameters.addNeutralLoss(neutralLoss);
                }
            }
            specificAnnotationParameters.clearCharges();
            reporterIons = this.chargeMenus.keySet().iterator();
            while (reporterIons.hasNext()) {
                int charge = (Integer)reporterIons.next();
                if (!this.chargeMenus.get(charge).isSelected()) continue;
                specificAnnotationParameters.addSelectedCharge(charge);
            }
        } else {
            this.selectDefaultAnnotationMenuItem();
        }
        SpectrumAnnotator.TiesResolution tiesResolution = this.highResAnnotationCheckBoxMenuItem.isSelected() ? SpectrumAnnotator.TiesResolution.mostAccurateMz : SpectrumAnnotator.TiesResolution.mostIntense;
        annotationParameters.setTiesResolution(tiesResolution);
        annotationParameters.setShowAllPeaks(this.allCheckBoxMenuItem.isSelected());
        annotationParameters.setShowForwardIonDeNovoTags(this.forwardIonsDeNovoCheckBoxMenuItem.isSelected());
        annotationParameters.setShowRewindIonDeNovoTags(this.rewindIonsDeNovoCheckBoxMenuItem.isSelected());
        DisplayParameters displayParameters = this.getDisplayParameters();
        this.barsCheckBoxMenuItem.setSelected(displayParameters.showBars());
        this.intensityIonTableRadioButtonMenuItem.setSelected(displayParameters.useIntensityIonTable());
        if (this.deNovoChargeOneJRadioButtonMenuItem.isSelected()) {
            annotationParameters.setDeNovoCharge(1);
        } else {
            annotationParameters.setDeNovoCharge(2);
        }
        return specificAnnotationParameters;
    }

    public JMenuBar getAnnotationMenuBar() {
        return this.annotationMenuBar;
    }

    public void updateAnnotationMenuBarVisableOptions(boolean showSpectrumOptions, boolean showBubblePlotOptions, boolean showIonTableOptions, boolean showPtmPlotOptions, boolean showSingleSpectrumExportOptions) {
        this.allCheckBoxMenuItem.setVisible(showSpectrumOptions);
        this.exportSpectrumGraphicsJMenuItem.setVisible(showSpectrumOptions);
        this.exportSpectrumMenu.setVisible(showSpectrumOptions);
        this.highResAnnotationCheckBoxMenuItem.setVisible(showSpectrumOptions || showBubblePlotOptions);
        this.exportSpectrumAndPlotsGraphicsJMenuItem.setVisible(showSingleSpectrumExportOptions && this.allTabsJTabbedPane.getSelectedIndex() == 0);
        this.exportSpectrumGraphicsSeparator.setVisible(showSingleSpectrumExportOptions && this.allTabsJTabbedPane.getSelectedIndex() == 0);
        this.exportSequenceFragmentationGraphicsJMenuItem.setVisible(showSingleSpectrumExportOptions && this.allTabsJTabbedPane.getSelectedIndex() == 0);
        this.exportIntensityHistogramGraphicsJMenuItem.setVisible(showSingleSpectrumExportOptions && this.allTabsJTabbedPane.getSelectedIndex() == 0);
        this.exportMassErrorPlotGraphicsJMenuItem.setVisible(showSingleSpectrumExportOptions && this.allTabsJTabbedPane.getSelectedIndex() == 0);
        this.exportSpectrumValuesJMenuItem.setVisible(showSingleSpectrumExportOptions);
        this.barsCheckBoxMenuItem.setVisible(showBubblePlotOptions);
        this.bubblePlotJMenuItem.setVisible(showBubblePlotOptions);
        this.bubbleScaleJMenuItem.setVisible(showBubblePlotOptions);
        this.intensityIonTableRadioButtonMenuItem.setVisible(showIonTableOptions);
        this.mzIonTableRadioButtonMenuItem.setVisible(showIonTableOptions);
        if (this.settingsMenu.isEnabled()) {
            this.exportGraphicsMenu.setEnabled(!showIonTableOptions);
        }
    }

    public void updateRecentProjectsList() {
        this.openRecentJMenu.removeAll();
        ArrayList<String> paths = this.psdbParent.getUserParameters().getRecentProjects();
        int counter = 1;
        for (String line : paths) {
            JMenuItem menuItem = new JMenuItem(counter++ + ": " + line);
            final String filePath = line;
            final PeptideShakerGUI temp = this;
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    boolean open = true;
                    if (!PeptideShakerGUI.this.dataSaved && PeptideShakerGUI.this.getProjectParameters() != null) {
                        int value = JOptionPane.showConfirmDialog(temp, "Do you want to save the changes to " + PeptideShakerGUI.this.getProjectParameters().getProjectUniqueName() + "?", "Unsaved Changes", 1, 3);
                        if (value == 0) {
                            PeptideShakerGUI.this.saveMenuItemActionPerformed(null);
                            open = false;
                        } else if (value == 2 || value == -1) {
                            open = false;
                        }
                    }
                    if (open) {
                        if (!new File(filePath).exists()) {
                            JOptionPane.showMessageDialog(null, "File not found.", "File Error", 0);
                            temp.getUserParameters().removeRecentProject(filePath);
                        } else {
                            PeptideShakerGUI.this.clearData(true, true);
                            PeptideShakerGUI.this.clearParameters();
                            PeptideShakerGUI.this.importPeptideShakerFile(new File(filePath), false);
                            PeptideShakerGUI.this.psdbParent.getUserParameters().addRecentProject(filePath);
                            PeptideShakerGUI.this.lastSelectedFolder.setLastSelectedFolder(new File(filePath).getAbsolutePath());
                        }
                        PeptideShakerGUI.this.updateRecentProjectsList();
                    }
                }
            });
            this.openRecentJMenu.add(menuItem);
        }
        if (this.openRecentJMenu.getItemCount() == 0) {
            JMenuItem menuItem = new JMenuItem("(empty)");
            menuItem.setEnabled(false);
            this.openRecentJMenu.add(menuItem);
        }
    }

    public void loadRecentProjectsList(JPopupMenu menu, WelcomeDialog welcomeDialog) {
        final WelcomeDialog tempWelcomeDialog = welcomeDialog;
        menu.removeAll();
        ArrayList<String> paths = this.psdbParent.getUserParameters().getRecentProjects();
        int counter = 1;
        for (String line : paths) {
            JMenuItem menuItem = new JMenuItem(counter++ + ": " + line);
            final String filePath = line;
            final PeptideShakerGUI temp = this;
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    File projectFile = new File(filePath);
                    if (!projectFile.exists()) {
                        JOptionPane.showMessageDialog(null, "File not found!", "File Error", 0);
                        temp.getUserParameters().removeRecentProject(filePath);
                    } else {
                        tempWelcomeDialog.setVisible(false);
                        tempWelcomeDialog.dispose();
                        PeptideShakerGUI.this.setVisible(true);
                        PeptideShakerGUI.this.clearData(true, true);
                        PeptideShakerGUI.this.clearParameters();
                        if (filePath.endsWith(".zip")) {
                            PeptideShakerGUI.this.importPeptideShakerZipFile(projectFile);
                        } else {
                            PeptideShakerGUI.this.importPeptideShakerFile(new File(filePath), false);
                        }
                        PeptideShakerGUI.this.psdbParent.getUserParameters().addRecentProject(filePath);
                        PeptideShakerGUI.this.lastSelectedFolder.setLastSelectedFolder(filePath);
                    }
                    PeptideShakerGUI.this.updateRecentProjectsList();
                }
            });
            menu.add(menuItem);
        }
        if (menu.getComponentCount() == 0) {
            JMenuItem menuItem = new JMenuItem("(empty)");
            menuItem.setEnabled(false);
            menu.add(menuItem);
        }
    }

    public ProjectDetails getProjectDetails() {
        return this.psdbParent.getProjectDetails();
    }

    public void setProjectDetails(ProjectDetails projectDetails) {
        this.psdbParent.setProjectDetails(projectDetails);
    }

    public void importPeptideShakerZipFromURL(final String zipURL, final String destinationFolder) {
        final PeptideShakerGUI peptideShakerGUI = this;
        this.progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.setWaitingText("Downloading PeptideShaker Project. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PeptideShakerGUI.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("DownloadingUrlThread"){

            @Override
            public void run() {
                try {
                    URL url = new URL(zipURL);
                    String path = url.getPath();
                    if (!path.endsWith(".zip")) {
                        path = path + ".zip";
                    }
                    File tmpFile = new File(destinationFolder, new File(path).getName());
                    IoUtil.saveUrl((File)tmpFile, (String)zipURL, (int)IoUtil.getFileSize((URL)url), null, null, (WaitingHandler)PeptideShakerGUI.this.progressDialog);
                    PeptideShakerGUI.this.progressDialog.setRunFinished();
                    PeptideShakerGUI.this.importPeptideShakerZipFile(tmpFile);
                }
                catch (Exception e) {
                    PeptideShakerGUI.this.progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(peptideShakerGUI, e.getMessage(), "Download Error", 2);
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void importPeptideShakerZipFile(final File zipFile) {
        String newName = PsZipUtils.getTempFolderName(zipFile.getName());
        String parentFolder = PsZipUtils.getUnzipParentFolder();
        if (parentFolder == null) {
            parentFolder = zipFile.getParent();
        }
        File parentFolderFile = new File(parentFolder, PsZipUtils.getUnzipSubFolder());
        final File destinationFolder = new File(parentFolderFile, newName);
        destinationFolder.mkdir();
        TempFilesManager.registerTempFolder((File)parentFolderFile);
        final PeptideShakerGUI peptideShakerGUI = this;
        this.progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.setWaitingText("Unzipping " + zipFile.getName() + ". Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PeptideShakerGUI.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("UnzippingThread"){

            @Override
            public void run() {
                try {
                    ZipUtils.unzip((File)zipFile, (File)destinationFolder, (WaitingHandler)PeptideShakerGUI.this.progressDialog);
                    PeptideShakerGUI.this.progressDialog.setSecondaryProgressCounterIndeterminate(true);
                    if (!PeptideShakerGUI.this.progressDialog.isRunCanceled()) {
                        for (File file : destinationFolder.listFiles()) {
                            if (!file.getName().toLowerCase().endsWith(".psdb")) continue;
                            PeptideShakerGUI.this.exceptionHandler.setIgnoreExceptions(true);
                            PeptideShakerGUI.this.clearData(true, true);
                            PeptideShakerGUI.this.exceptionHandler.setIgnoreExceptions(false);
                            PeptideShakerGUI.this.clearParameters();
                            PeptideShakerGUI.this.getUserParameters().addRecentProject(zipFile);
                            PeptideShakerGUI.this.updateRecentProjectsList();
                            PeptideShakerGUI.this.progressDialog.setRunFinished();
                            PeptideShakerGUI.this.importPeptideShakerFile(file, true);
                            PeptideShakerGUI.this.lastSelectedFolder.setLastSelectedFolder(file.getAbsolutePath());
                            return;
                        }
                        PeptideShakerGUI.this.progressDialog.setRunFinished();
                        JOptionPane.showMessageDialog(peptideShakerGUI, "No PeptideShaker project was found in the zip file.", "No PeptideShaker Project Found", 2);
                    }
                    PeptideShakerGUI.this.progressDialog.setRunFinished();
                }
                catch (Exception e) {
                    PeptideShakerGUI.this.progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(peptideShakerGUI, e.getMessage(), "Unzip Error", 2);
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void importPeptideShakerFile(File psFile, boolean importFromZip) {
        this.psdbParent.setPsdbFile(psFile);
        this.psdbParent.setPsdbImportFromZip(importFromZip);
        final PeptideShakerGUI peptideShakerGUI = this;
        this.progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Importing Project. Please Wait...");
        this.resetFrameTitle();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PeptideShakerGUI.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("ImportThread"){

            @Override
            public void run() {
                try {
                    PeptideShakerGUI.this.resetModificationFactory();
                    PeptideShakerGUI.this.setDefaultParameters();
                    PeptideShakerGUI.this.setCurentNotes(new ArrayList<String>(0));
                    PeptideShakerGUI.this.updateNotesNotificationCounter();
                    PeptideShakerGUI.this.openingExistingProject = true;
                    PeptideShakerGUI.this.psdbParent.loadPsdbFile(PeptideShaker.getMatchesFolder(), (WaitingHandler)PeptideShakerGUI.this.progressDialog, PeptideShakerGUI.this.psdbParent.getPsdbImportFromZip());
                    String error = PeptideShaker.loadModifications(PeptideShakerGUI.this.getIdentificationParameters().getSearchParameters());
                    if (error != null) {
                        JOptionPane.showMessageDialog(peptideShakerGUI, error, "Modification Definition Changed", 2);
                    }
                    PeptideShakerGUI.this.resetDisplayFeaturesGenerator();
                    if (PeptideShakerGUI.this.progressDialog.isRunCanceled()) {
                        PeptideShakerGUI.this.clearData(true, true);
                        PeptideShakerGUI.this.clearParameters();
                        PeptideShakerGUI.this.progressDialog.setRunFinished();
                        PeptideShakerGUI.this.openingExistingProject = false;
                        return;
                    }
                    PeptideShakerGUI.this.progressDialog.setTitle("Loading FASTA File. Please Wait...");
                    boolean fileFound = true;
                    try {
                        FastaSummary fastaSummary = PeptideShakerGUI.this.psdbParent.loadFastaFile((WaitingHandler)PeptideShakerGUI.this.progressDialog);
                        if (fastaSummary == null) {
                            fileFound = false;
                        }
                    }
                    catch (IOException e) {
                        fileFound = false;
                    }
                    if (!fileFound && !PeptideShakerGUI.this.locateFastaFileManually()) {
                        String fastaFilePath = PeptideShakerGUI.this.getProjectDetails().getFastaFile();
                        JOptionPane.showMessageDialog(peptideShakerGUI, "An error occurred while reading:\n" + fastaFilePath + ".\n\nFile not found.", "File Input Error", 0);
                        PeptideShakerGUI.this.clearData(true, true);
                        PeptideShakerGUI.this.clearParameters();
                        PeptideShakerGUI.this.progressDialog.setRunFinished();
                        PeptideShakerGUI.this.openingExistingProject = false;
                        return;
                    }
                    if (PeptideShakerGUI.this.progressDialog.isRunCanceled()) {
                        PeptideShakerGUI.this.clearData(true, true);
                        PeptideShakerGUI.this.clearParameters();
                        PeptideShakerGUI.this.progressDialog.setRunFinished();
                        PeptideShakerGUI.this.openingExistingProject = false;
                        return;
                    }
                    PeptideShakerGUI.this.progressDialog.setTitle("Loading Spectrum Files. Please Wait...");
                    PeptideShakerGUI.this.progressDialog.resetPrimaryProgressCounter();
                    PeptideShakerGUI.this.progressDialog.setMaxPrimaryProgressCounter(PeptideShakerGUI.this.getIdentification().getSpectrumIdentification().size() + 1);
                    PeptideShakerGUI.this.progressDialog.increasePrimaryProgressCounter();
                    ProjectDetails projectParameters = PeptideShakerGUI.this.psdbParent.getProjectDetails();
                    Set<String> fileNames = PeptideShakerGUI.this.getProjectDetails().getSpectrumFileNames();
                    ArrayList spectrumFiles = fileNames.stream().map(projectParameters::getSpectrumFilePath).map(path -> new File((String)path)).collect(Collectors.toCollection(ArrayList::new));
                    int cpt = 0;
                    int total = fileNames.size();
                    for (String spectrumFileName : PeptideShakerGUI.this.getIdentification().getFractions()) {
                        boolean found;
                        PeptideShakerGUI.this.progressDialog.setTitle("Loading Spectrum Files (" + ++cpt + " of " + total + "). Please Wait...");
                        PeptideShakerGUI.this.progressDialog.increasePrimaryProgressCounter();
                        try {
                            found = PeptideShakerGUI.this.psdbParent.loadSpectrumFile(spectrumFileName, spectrumFiles, (WaitingHandler)PeptideShakerGUI.this.progressDialog);
                        }
                        catch (Exception e) {
                            found = false;
                        }
                        if (!found) {
                            JOptionPane.showMessageDialog(peptideShakerGUI, "Spectrum file not found: '" + spectrumFileName + "'.\nPlease select the spectrum file or the folder containing it manually.", "File Not Found", 2);
                            JFileChooser fileChooser = new JFileChooser(PeptideShakerGUI.this.getLastSelectedFolder().getLastSelectedFolder());
                            fileChooser.setDialogTitle("Open Spectrum File");
                            FileFilter filter = new FileFilter(){

                                @Override
                                public boolean accept(File myFile) {
                                    return myFile.getName().toLowerCase().endsWith(".mgf") || myFile.getName().toLowerCase().endsWith(".mgf.gz") || myFile.getName().toLowerCase().endsWith(".mzml") || myFile.getName().toLowerCase().endsWith(".mzml.gz") || myFile.isDirectory();
                                }

                                @Override
                                public String getDescription() {
                                    return "Supported formats: mgf or mzML (.mgf, .mg.gz, .mzml, .mzml.gz)";
                                }
                            };
                            fileChooser.setFileFilter(filter);
                            int returnVal = fileChooser.showDialog(peptideShakerGUI, "Open");
                            if (returnVal == 0) {
                                File spectrumFolder = fileChooser.getSelectedFile();
                                if (!spectrumFolder.isDirectory()) {
                                    spectrumFolder = spectrumFolder.getParentFile();
                                }
                                PeptideShakerGUI.this.lastSelectedFolder.setLastSelectedFolder(spectrumFolder.getAbsolutePath());
                                found = false;
                                for (File file : spectrumFolder.listFiles()) {
                                    for (String spectrumFileName2 : PeptideShakerGUI.this.getIdentification().getFractions()) {
                                        try {
                                            String fileName = IoUtil.removeExtension((String)file.getName());
                                            if (spectrumFileName2.equals(fileName)) {
                                                PeptideShakerGUI.this.psdbParent.loadSpectrumFile(file, (WaitingHandler)PeptideShakerGUI.this.progressDialog);
                                                spectrumFiles.add(file);
                                            }
                                            if (!fileName.equals(spectrumFileName2)) continue;
                                            found = true;
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                                if (found) {
                                    try {
                                        found = PeptideShakerGUI.this.psdbParent.loadSpectrumFile(spectrumFileName, spectrumFiles, (WaitingHandler)PeptideShakerGUI.this.progressDialog);
                                    }
                                    catch (Exception e) {
                                        found = false;
                                    }
                                }
                                if (!found) {
                                    JOptionPane.showMessageDialog(peptideShakerGUI, spectrumFileName + " was not found in the given folder.", "File Input Error", 0);
                                    PeptideShakerGUI.this.clearData(true, true);
                                    PeptideShakerGUI.this.clearParameters();
                                    PeptideShakerGUI.this.progressDialog.setRunFinished();
                                    PeptideShakerGUI.this.openingExistingProject = false;
                                    return;
                                }
                            }
                        }
                        if (!PeptideShakerGUI.this.progressDialog.isRunCanceled()) continue;
                        PeptideShakerGUI.this.clearData(true, true);
                        PeptideShakerGUI.this.clearParameters();
                        PeptideShakerGUI.this.progressDialog.setRunFinished();
                        PeptideShakerGUI.this.openingExistingProject = false;
                        return;
                    }
                    PeptideShakerGUI.this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
                    PeptideShakerGUI.this.progressDialog.setRunFinished();
                    peptideShakerGUI.displayResults();
                    PeptideShakerGUI.this.allTabsJTabbedPaneStateChanged(null);
                    peptideShakerGUI.updateFrameTitle();
                    PeptideShakerGUI.this.dataSaved = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PeptideShakerGUI.this.openingExistingProject = false;
                        }
                    });
                }
                catch (OutOfMemoryError error) {
                    System.err.println("Ran out of memory!");
                    System.err.println("Memory given to the Java virtual machine: " + Runtime.getRuntime().maxMemory() + ".");
                    System.err.println("Memory used by the Java virtual machine: " + Runtime.getRuntime().totalMemory() + ".");
                    System.err.println("Free memory in the Java virtual machine: " + Runtime.getRuntime().freeMemory() + ".");
                    Runtime.getRuntime().gc();
                    String message = "PeptideShaker used up all the available memory and had to be stopped.<br>Memory boundaries are changed in the the Welcome Dialog (Settings<br>& Help > Settings > Java Memory Settings) or in the Edit menu (Edit<br>Java Options). See also <a href=\"https://compomics.github.io/projects/compomics-utilities/wiki/JavaTroubleShooting.html\">JavaTroubleShooting</a>.";
                    JOptionPane.showMessageDialog(PeptideShakerGUI.this, JOptionEditorPane.getJOptionEditorPane((String)message), "Out Of Memory", 0);
                    PeptideShakerGUI.this.progressDialog.setRunFinished();
                    error.printStackTrace();
                }
                catch (OptionalDataException e) {
                    PeptideShakerGUI.this.progressDialog.setRunFinished();
                    if (e.eof) {
                        JOptionPane.showMessageDialog(peptideShakerGUI, "An error occurred while reading:\n" + PeptideShakerGUI.this.psdbParent.getPsdbFile() + ".\n\nThe end of the file was reached unexpectedly. The file seems to be corrupt and cannot\nbe opened. If the file is a copy, make sure that it is identical to the original file.", "File Input Error", 0);
                    } else {
                        JOptionPane.showMessageDialog(peptideShakerGUI, "An error occurred while reading:\n" + PeptideShakerGUI.this.psdbParent.getPsdbFile() + ".\n\nPlease verify that the version used to create the file\nis compatible with your version of PeptideShaker.", "File Input Error", 0);
                    }
                    e.printStackTrace();
                }
                catch (EOFException e) {
                    PeptideShakerGUI.this.progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(peptideShakerGUI, "An error occurred while reading:\n" + PeptideShakerGUI.this.psdbParent.getPsdbFile() + ".\n\nThe end of the file was reached unexpectedly. The file seems to be corrupt and cannot\nbe opened. If the file is a copy, make sure that it is identical to the original file.", "File Input Error", 0);
                    e.printStackTrace();
                }
                catch (Exception e) {
                    PeptideShakerGUI.this.progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(peptideShakerGUI, "An error occurred while reading:\n" + PeptideShakerGUI.this.psdbParent.getPsdbFile() + ".\n\nPlease verify that the version used to create the file\nis compatible with your version of PeptideShaker.", "File Input Error", 0);
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private boolean locateFastaFileManually() throws FileNotFoundException, ClassNotFoundException, IOException {
        File selectedFastaFile;
        String fastaFilePath = this.getProjectDetails().getFastaFile();
        JOptionPane.showMessageDialog(this, "FASTA file " + fastaFilePath + " was not found.\n\nPlease locate it manually.", "File Input Error", 2);
        LastSelectedFolder tempLastSelectedFolder = this.getLastSelectedFolder();
        JFileChooser fileChooser = new JFileChooser(tempLastSelectedFolder.getLastSelectedFolder());
        fileChooser.setDialogTitle("Open FASTA File");
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith("fasta") || myFile.getName().toLowerCase().endsWith("fas") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Supported formats: FASTA format (.fasta or .fas)";
            }
        };
        fileChooser.setFileFilter(filter);
        int returnVal = fileChooser.showDialog(this, "Open");
        if (returnVal == 0 && (selectedFastaFile = fileChooser.getSelectedFile()).exists()) {
            tempLastSelectedFolder.setLastSelectedFolder(selectedFastaFile.getAbsolutePath());
            this.getProjectDetails().setFastaFile(selectedFastaFile);
            this.dataSaved = false;
            this.psdbParent.loadFastaFile((WaitingHandler)this.progressDialog);
            return true;
        }
        return false;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void exportSelectedSpectraAsMgf() throws IOException {
        File selectedFile;
        int selectedTabIndex = this.allTabsJTabbedPane.getSelectedIndex();
        TreeMap<String, TreeSet<String>> selectedSpectra = null;
        if (selectedTabIndex == 0) {
            selectedSpectra = this.overviewPanel.getSelectedSpectrumTitles();
        } else if (selectedTabIndex == 1) {
            selectedSpectra = this.spectrumIdentificationPanel.getSelectedSpectrumTitles();
        } else if (selectedTabIndex == 3) {
            selectedSpectra = this.modificationsPanel.getSelectedSpectrumTitles();
        }
        if (selectedSpectra != null && !selectedSpectra.isEmpty() && (selectedFile = this.getUserSelectedFile("selected_spectra.mgf", ".mgf", "Mascot Generic Format (*.mgf)", "Save As...", false)) != null) {
            try (SimpleFileWriter writer = new SimpleFileWriter(selectedFile, false);){
                for (Map.Entry<String, TreeSet<String>> entry : selectedSpectra.entrySet()) {
                    String spectrumFile = entry.getKey();
                    for (String spectrumTitle : entry.getValue()) {
                        Spectrum spectrum = this.getSpectrumProvider().getSpectrum(spectrumFile, spectrumTitle);
                        if (spectrum == null) {
                            throw new IllegalArgumentException("Spectrum " + spectrumTitle + " in " + spectrumFile + " not found.");
                        }
                        writer.write(MgfFileWriter.asMgf((String)spectrumTitle, (Spectrum)spectrum), true);
                    }
                }
                JOptionPane.showMessageDialog(this, "Spectrum saved to " + selectedFile.getPath() + ".", "File Saved", 1);
            }
        }
    }

    public void exportAnnotatedSpectrum() throws IOException {
        File selectedFile;
        int selectedTabIndex = this.allTabsJTabbedPane.getSelectedIndex();
        HashMap<Long, ArrayList<SpectrumIdentificationAssumption>> selectedAssumptions = null;
        if (selectedTabIndex == 0) {
            selectedAssumptions = this.overviewPanel.getSelectedIdentificationAssumptions();
        } else if (selectedTabIndex == 1) {
            selectedAssumptions = this.spectrumIdentificationPanel.getSelectedIdentificationAssumptions();
        } else if (selectedTabIndex == 3) {
            selectedAssumptions = this.modificationsPanel.getSelectedIdentificationAssumptions();
        }
        if (selectedAssumptions != null && !selectedAssumptions.isEmpty() && (selectedFile = this.getUserSelectedFile("annotated_spectra.txt", ".txt", "Text (*.txt)", "Save As...", false)) != null) {
            SequenceProvider sequenceProvider = this.getSequenceProvider();
            IdentificationParameters identificationParameters = this.getIdentificationParameters();
            ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
            SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
            AnnotationParameters annotationParameters = this.getIdentificationParameters().getAnnotationParameters();
            PeptideSpectrumAnnotator peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();
            TagSpectrumAnnotator tagSpectrumAnnotator = new TagSpectrumAnnotator();
            try (SimpleFileWriter writer = new SimpleFileWriter(selectedFile, false);){
                for (long spectrumMatchKey : selectedAssumptions.keySet()) {
                    SpectrumMatch spectrumMatch = this.getIdentification().getSpectrumMatch(spectrumMatchKey);
                    String spectrumFile = spectrumMatch.getSpectrumFile();
                    String spectrumTitle = spectrumMatch.getSpectrumTitle();
                    Spectrum spectrum = this.getSpectrumProvider().getSpectrum(spectrumFile, spectrumTitle);
                    if (spectrum == null) {
                        throw new IllegalArgumentException("Spectrum " + spectrumTitle + " in " + spectrumFile + " not found.");
                    }
                    IonMatch[] annotations = null;
                    ArrayList<SpectrumIdentificationAssumption> assumptions = selectedAssumptions.get(spectrumMatchKey);
                    if (assumptions != null && !assumptions.isEmpty()) {
                        for (SpectrumIdentificationAssumption assumption : assumptions) {
                            String identifier;
                            SpecificAnnotationParameters exportAnnotationParameters = this.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, assumption);
                            if (assumption instanceof PeptideAssumption) {
                                PeptideAssumption peptideAssumption = (PeptideAssumption)assumption;
                                Peptide peptide = peptideAssumption.getPeptide();
                                annotations = peptideSpectrumAnnotator.getSpectrumAnnotation(annotationParameters, exportAnnotationParameters, spectrumFile, spectrumTitle, spectrum, peptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
                                identifier = peptide.getTaggedModifiedSequence(modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, false, false, true, this.getDisplayParameters().getDisplayedModifications());
                            } else if (assumption instanceof TagAssumption) {
                                TagAssumption tagAssumption = (TagAssumption)assumption;
                                IonMatch[] tag = tagAssumption.getTag();
                                annotations = tagSpectrumAnnotator.getSpectrumAnnotation(annotationParameters, modificationParameters, modificationSequenceMatchingParameters, exportAnnotationParameters, spectrumFile, spectrumTitle, spectrum, (Tag)tag);
                                identifier = tag.getTaggedModifiedSequence(modificationParameters, false, false, true, true, modificationSequenceMatchingParameters, this.getDisplayParameters().getDisplayedModifications());
                            } else {
                                throw new UnsupportedOperationException("Spectrum annotation not implemented for identification assumption of type " + assumption.getClass() + ".");
                            }
                            HashMap<Double, ArrayList<IonMatch>> annotationMap = new HashMap<Double, ArrayList<IonMatch>>();
                            if (annotations != null) {
                                for (IonMatch ionMatch : annotations) {
                                    double mz = ionMatch.peakMz;
                                    ArrayList<IonMatch> matchesAtMz = (ArrayList<IonMatch>)annotationMap.get(mz);
                                    if (matchesAtMz == null) {
                                        matchesAtMz = new ArrayList<IonMatch>(1);
                                        annotationMap.put(mz, matchesAtMz);
                                    }
                                    matchesAtMz.add(ionMatch);
                                }
                            }
                            writer.writeLine(new String[]{"File: " + spectrumFile, "Spectrum: " + spectrumTitle, "Peptide: " + identifier});
                            writer.writeLine(new String[]{"m/z", "Intensity", "Ion", "Theoretic m/z", "Absolute Error"});
                            for (int i = 0; i < spectrum.mz.length; ++i) {
                                double mz = spectrum.mz[i];
                                double intensity = spectrum.intensity[i];
                                ArrayList matches = (ArrayList)annotationMap.get(mz);
                                if (matches != null) {
                                    for (IonMatch ionMatch : matches) {
                                        writer.writeLine(new String[]{Double.toString(mz), Double.toString(intensity), ionMatch.getPeakAnnotation(), Double.toString(ionMatch.ion.getTheoreticMz(Integer.valueOf(ionMatch.charge))), Double.toString(ionMatch.getAbsoluteError())});
                                    }
                                    continue;
                                }
                                writer.writeLine(new String[]{Double.toString(mz), Double.toString(intensity), "", "", ""});
                            }
                        }
                        continue;
                    }
                    writer.writeLine(new String[]{"File: " + spectrumFile, "Spectrum: " + spectrumTitle});
                    writer.writeLine(new String[]{"m/z", "Intensity", "Ion", "Theoretic m/z", "Absolute Error"});
                    for (int i = 0; i < spectrum.mz.length; ++i) {
                        double mz = spectrum.mz[i];
                        double intensity = spectrum.intensity[i];
                        writer.writeLine(new String[]{Double.toString(mz), Double.toString(intensity), "", "", ""});
                    }
                }
                JOptionPane.showMessageDialog(this, "Spectrum saved to " + selectedFile.getPath() + ".", "File Saved", 1);
            }
        }
    }

    public void exportSpectrumAsFigure() {
        int selectedTabIndex = this.allTabsJTabbedPane.getSelectedIndex();
        if (selectedTabIndex == 0) {
            new ExportGraphicsDialog((JFrame)this, this.getNormalIcon(), this.getWaitingIcon(), true, this.overviewPanel.getSpectrum(), this.lastSelectedFolder);
        } else if (selectedTabIndex == 1) {
            new ExportGraphicsDialog((JFrame)this, this.getNormalIcon(), this.getWaitingIcon(), true, this.spectrumIdentificationPanel.getSpectrum(), this.lastSelectedFolder);
        } else if (selectedTabIndex == 3) {
            new ExportGraphicsDialog((JFrame)this, this.getNormalIcon(), this.getWaitingIcon(), true, this.modificationsPanel.getSpectrum(), this.lastSelectedFolder);
        }
    }

    public void exportSequenceFragmentationAsFigure() {
        int selectedTabIndex = this.allTabsJTabbedPane.getSelectedIndex();
        if (selectedTabIndex == 0) {
            new ExportGraphicsDialog((JFrame)this, this.getNormalIcon(), this.getWaitingIcon(), true, this.overviewPanel.getSequenceFragmentationPlot(), this.lastSelectedFolder);
        }
    }

    public void exportIntensityHistogramAsFigure() {
        int selectedTabIndex = this.allTabsJTabbedPane.getSelectedIndex();
        if (selectedTabIndex == 0) {
            ChartPanel chartPanel = this.overviewPanel.getIntensityHistogramPlot().getChartPanel();
            ChartPanel tempChartPanel = new ChartPanel(chartPanel.getChart(), false);
            tempChartPanel.setBounds(new Rectangle(chartPanel.getBounds().width * 5, chartPanel.getBounds().height * 5));
            new ExportGraphicsDialog((JFrame)this, this.getNormalIcon(), this.getWaitingIcon(), true, tempChartPanel, this.lastSelectedFolder);
        }
    }

    public void exportMassErrorPlotAsFigure() {
        int selectedTabIndex = this.allTabsJTabbedPane.getSelectedIndex();
        if (selectedTabIndex == 0) {
            if (this.overviewPanel.getMassErrorPlot() != null) {
                ChartPanel chartPanel = this.overviewPanel.getMassErrorPlot().getChartPanel();
                ChartPanel tempChartPanel = new ChartPanel(chartPanel.getChart(), false);
                tempChartPanel.setBounds(new Rectangle(chartPanel.getBounds().width * 5, chartPanel.getBounds().height * 5));
                new ExportGraphicsDialog((JFrame)this, this.getNormalIcon(), this.getWaitingIcon(), true, tempChartPanel, this.lastSelectedFolder);
            } else {
                JOptionPane.showMessageDialog(this, "No m/z error plot to export!", "Export Error", 1);
            }
        }
    }

    public void exportBubblePlotAsFigure() {
        int selectedIndex = this.allTabsJTabbedPane.getSelectedIndex();
        if (selectedIndex == 0) {
            new ExportGraphicsDialog((JFrame)this, this.getNormalIcon(), this.getWaitingIcon(), true, this.overviewPanel.getBubblePlot(), this.lastSelectedFolder);
        } else if (selectedIndex == 1) {
            new ExportGraphicsDialog((JFrame)this, this.getNormalIcon(), this.getWaitingIcon(), true, this.spectrumIdentificationPanel.getBubblePlot(), this.lastSelectedFolder);
        }
    }

    public void setDisplayOptions(boolean displayProteins, boolean displayPeptidesAndPsms, boolean displayCoverage, boolean displaySpectrum) {
        if (!(displayProteins || displayPeptidesAndPsms || displayCoverage || displaySpectrum)) {
            displayProteins = true;
        }
        this.proteinsJCheckBoxMenuItem.setSelected(displayProteins);
        this.peptidesAndPsmsJCheckBoxMenuItem.setSelected(displayPeptidesAndPsms);
        this.sequenceCoverageJCheckBoxMenuItem.setSelected(displayCoverage);
        this.spectrumJCheckBoxMenuItem.setSelected(displaySpectrum);
        this.overviewPanel.setDisplayOptions(this.proteinsJCheckBoxMenuItem.isSelected(), this.peptidesAndPsmsJCheckBoxMenuItem.isSelected(), this.sequenceCoverageJCheckBoxMenuItem.isSelected(), this.spectrumJCheckBoxMenuItem.isSelected());
        this.overviewPanel.updateSeparators();
    }

    public HashMap<Double, String> getCurrentMassDeltas() {
        HashMap<Double, String> knownMassDeltas = new HashMap<Double, String>();
        knownMassDeltas.put(AminoAcid.A.getMonoisotopicMass(), "A");
        knownMassDeltas.put(AminoAcid.R.getMonoisotopicMass(), "R");
        knownMassDeltas.put(AminoAcid.N.getMonoisotopicMass(), "N");
        knownMassDeltas.put(AminoAcid.D.getMonoisotopicMass(), "D");
        knownMassDeltas.put(AminoAcid.C.getMonoisotopicMass(), "C");
        knownMassDeltas.put(AminoAcid.Q.getMonoisotopicMass(), "Q");
        knownMassDeltas.put(AminoAcid.E.getMonoisotopicMass(), "E");
        knownMassDeltas.put(AminoAcid.G.getMonoisotopicMass(), "G");
        knownMassDeltas.put(AminoAcid.H.getMonoisotopicMass(), "H");
        knownMassDeltas.put(AminoAcid.I.getMonoisotopicMass(), "I/L");
        knownMassDeltas.put(AminoAcid.K.getMonoisotopicMass(), "K");
        knownMassDeltas.put(AminoAcid.M.getMonoisotopicMass(), "M");
        knownMassDeltas.put(AminoAcid.F.getMonoisotopicMass(), "F");
        knownMassDeltas.put(AminoAcid.P.getMonoisotopicMass(), "P");
        knownMassDeltas.put(AminoAcid.S.getMonoisotopicMass(), "S");
        knownMassDeltas.put(AminoAcid.T.getMonoisotopicMass(), "T");
        knownMassDeltas.put(AminoAcid.W.getMonoisotopicMass(), "W");
        knownMassDeltas.put(AminoAcid.Y.getMonoisotopicMass(), "Y");
        knownMassDeltas.put(AminoAcid.V.getMonoisotopicMass(), "V");
        knownMassDeltas.put(AminoAcid.U.getMonoisotopicMass(), "U");
        knownMassDeltas.put(AminoAcid.O.getMonoisotopicMass(), "O");
        SearchParameters searchParameters = this.getIdentificationParameters().getSearchParameters();
        ModificationParameters modificationProfile = searchParameters.getModificationParameters();
        ArrayList modificationList = modificationProfile.getAllModifications();
        Collections.sort(modificationList);
        for (String modName : modificationList) {
            Modification modification = this.modificationFactory.getModification(modName);
            if (modification.getModificationType() != ModificationType.modaa) continue;
            Iterator iterator = modification.getPattern().getAminoAcidsAtTarget().iterator();
            while (iterator.hasNext()) {
                char aa = ((Character)iterator.next()).charValue();
                AminoAcid aminoAcid = AminoAcid.getAminoAcid((char)aa);
                double massKey = aminoAcid.getMonoisotopicMass() + modification.getMass();
                String annotationValue = String.join((CharSequence)"", Character.toString(aa), "<", modification.getShortName(), ">");
                knownMassDeltas.put(massKey, annotationValue);
            }
        }
        return knownMassDeltas;
    }

    public void saveProject(boolean aCloseWhenDone, boolean aExportToZipWhenDone) {
        if (this.psdbParent.getPsdbFile() != null && this.psdbParent.getPsdbFile().equals(new File(PeptideShaker.getJarFilePath() + "/resources/example_dataset/HeLa Example.psdb"))) {
            int value = JOptionPane.showConfirmDialog(this, "Overwriting the example project is not possible.\nPlease save to a different location.", "Example Project", 2, 2);
            if (value == 0) {
                this.saveProjectAs(aCloseWhenDone, aExportToZipWhenDone);
            }
        } else {
            final boolean closeWhenDone = aCloseWhenDone;
            final boolean exportToZipWhenDone = aExportToZipWhenDone;
            this.progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.progressDialog.setTitle("Saving. Please Wait...");
            final JPanel tempPanel = (JPanel)this.allTabsJTabbedPane.getSelectedComponent();
            final Component tempComp = tempPanel.getComponent(0);
            Rectangle rect = tempComp.getBounds();
            BufferedImage captureImage = new BufferedImage(rect.width, rect.height, 2);
            tempComp.paint(captureImage.getGraphics());
            tempPanel.removeAll();
            tempPanel.add(new JLabel(new ImageIcon(captureImage)));
            tempPanel.repaint();
            this.overviewPanel.selfUpdating(false);
            this.proteinFractionsPanel.selfUpdating(false);
            this.proteinStructurePanel.selfUpdating(false);
            final PeptideShakerGUI tempRef = this;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        PeptideShakerGUI.this.progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("SaveThread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        PeptideShakerGUI.this.progressDialog.setWaitingText("Saving Results. Please Wait...");
                        PeptideShakerGUI.this.modificationFactory.saveFactory();
                        ArrayList<String> dataFiles = new ArrayList<String>();
                        File dataFolder = new File(PeptideShakerGUI.this.psdbParent.getPsdbFile().getParentFile(), "data");
                        String fastaFile = PeptideShakerGUI.this.getProjectDetails().getFastaFile();
                        if (fastaFile.lastIndexOf(".PeptideShaker_unzip_temp") != -1) {
                            dataFiles.add(fastaFile);
                            String string = IoUtil.getExtension((String)fastaFile);
                            File FMFile = new File(new File(fastaFile).getAbsolutePath().replace(string, ".fmi"));
                            dataFiles.add(FMFile.getAbsolutePath());
                            PeptideShakerGUI.this.getProjectDetails().setFastaFile(new File(dataFolder, IoUtil.getFileName((String)fastaFile)));
                        }
                        for (String fileName : PeptideShakerGUI.this.getSpectrumProvider().getOrderedFileNamesWithoutExtensions()) {
                            String cmsFilePath = (String)PeptideShakerGUI.this.getSpectrumProvider().getCmsFilePaths().get(fileName);
                            String msFilePath = (String)PeptideShakerGUI.this.getSpectrumProvider().getFilePaths().get(fileName);
                            if (cmsFilePath.lastIndexOf(".PeptideShaker_unzip_temp") != -1) {
                                dataFiles.add(cmsFilePath);
                                PeptideShakerGUI.this.getSpectrumProvider().getCmsFilePaths().put(fileName, new File(dataFolder, IoUtil.getFileName((File)new File(cmsFilePath))).getAbsolutePath());
                            }
                            if (msFilePath.lastIndexOf(".PeptideShaker_unzip_temp") == -1) continue;
                            dataFiles.add(msFilePath);
                            PeptideShakerGUI.this.getSpectrumProvider().getFilePaths().put(fileName, new File(dataFolder, IoUtil.getFileName((File)new File(msFilePath))).getAbsolutePath());
                        }
                        if (!dataFiles.isEmpty()) {
                            boolean bl = dataFolder.mkdir();
                            if (bl) {
                                for (String tempFile : dataFiles) {
                                    File tempDataFile = new File(tempFile);
                                    IoUtil.copyFile((File)tempDataFile, (File)new File(dataFolder, IoUtil.getFileName((File)tempDataFile)));
                                }
                            } else {
                                JOptionPane.showMessageDialog(tempRef, "Data folder could not be created.", "Save Error", 0);
                            }
                        }
                        PeptideShakerGUI.this.psdbParent.saveProject((WaitingHandler)PeptideShakerGUI.this.progressDialog, closeWhenDone);
                        if (!PeptideShakerGUI.this.progressDialog.isRunCanceled()) {
                            PeptideShakerGUI.this.progressDialog.setRunFinished();
                            PeptideShakerGUI.this.psdbParent.getUserParameters().addRecentProject(PeptideShakerGUI.this.psdbParent.getPsdbFile());
                            PeptideShakerGUI.this.updateRecentProjectsList();
                            String string = PeptideShakerGUI.this.psdbParent.getExtendedProjectReport(null);
                            if (string != null) {
                                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss");
                                String fileName = "PeptideShaker Report " + PeptideShakerGUI.this.psdbParent.getPsdbFile().getName() + " " + df.format(new Date()) + ".html";
                                File psReportFile = new File(PeptideShakerGUI.this.psdbParent.getPsdbFile().getParentFile(), fileName);
                                FileWriter fw = new FileWriter(psReportFile);
                                fw.write(string);
                                fw.close();
                            }
                            if (closeWhenDone) {
                                PeptideShakerGUI.this.closePeptideShaker();
                            } else {
                                JOptionPane.showMessageDialog(tempRef, "Project successfully saved.", "Save Successful", 1);
                                PeptideShakerGUI.this.dataSaved = true;
                                if (exportToZipWhenDone) {
                                    PeptideShakerGUI.this.exportProjectAsZip();
                                }
                            }
                        } else {
                            PeptideShakerGUI.this.progressDialog.setRunFinished();
                            JOptionPane.showMessageDialog(tempRef, "Saving of the project was cancelled by the user.", "Save Cancelled", 2);
                        }
                    }
                    catch (Exception e) {
                        PeptideShakerGUI.this.progressDialog.setRunFinished();
                        e.printStackTrace();
                        PeptideShakerGUI.this.catchException(e);
                    }
                    finally {
                        PeptideShakerGUI.this.overviewPanel.selfUpdating(true);
                        PeptideShakerGUI.this.proteinFractionsPanel.selfUpdating(true);
                        PeptideShakerGUI.this.proteinStructurePanel.selfUpdating(true);
                        tempPanel.removeAll();
                        tempPanel.add(tempComp);
                        tempPanel.repaint();
                    }
                }
            }.start();
        }
    }

    public void setUpdated(int tabIndex, boolean updated) {
        this.updateNeeded.put(tabIndex, !updated);
    }

    public void updateTabbedPanes() {
        this.repaintPanels();
        this.allTabsJTabbedPaneStateChanged(null);
    }

    public StarHider getStarHider() {
        this.progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        if (this.starHider == null) {
            this.starHider = new StarHider(this.getIdentification(), this.getFilterParameters(), this.getSequenceProvider(), this.getProteinDetailsProvider(), this.getSpectrumProvider(), this.getGeneMaps(), this.getIdentificationFeaturesGenerator(), this.getIdentificationParameters(), this.getMetrics(), this.progressDialog, this.getProcessingParameters().getnThreads(), (ExceptionHandler)this.exceptionHandler);
        }
        return this.starHider;
    }

    public IdentificationFeaturesGenerator getIdentificationFeaturesGenerator() {
        return this.psdbParent.getIdentificationFeaturesGenerator();
    }

    public void resetIdentificationFeaturesGenerator() {
        this.psdbParent.resetIdentificationFeaturesGenerator();
    }

    public void setIdentificationFeaturesGenerator(IdentificationFeaturesGenerator identificationFeaturesGenerator) {
        this.psdbParent.setIdentificationFeaturesGenerator(identificationFeaturesGenerator);
    }

    public void resetDisplayFeaturesGenerator() {
        this.displayFeaturesGenerator = new DisplayFeaturesGenerator(this.getIdentificationParameters(), this.getDisplayParameters(), this.getSequenceProvider(), this.getProteinDetailsProvider());
    }

    public DisplayFeaturesGenerator getDisplayFeaturesGenerator() {
        return this.displayFeaturesGenerator;
    }

    public Metrics getMetrics() {
        return this.psdbParent.getMetrics();
    }

    public void setMetrics(Metrics metrics) {
        this.psdbParent.setMetrics(metrics);
    }

    public ProjectType getProjectType() {
        return this.psdbParent.getProjectType();
    }

    public void setProjectType(ProjectType projectType) {
        this.psdbParent.setProjectType(projectType);
    }

    public GeneMaps getGeneMaps() {
        return this.psdbParent.getGeneMaps();
    }

    public void setGeneMaps(GeneMaps geneMaps) {
        this.psdbParent.setGeneMaps(geneMaps);
    }

    public void spectrumFileSelectionChanged(String spectrumFile) {
        this.jumpToPanel.setSpectrumFile(spectrumFile);
    }

    public void saveProjectAs(boolean closeWhenDone, boolean aExportToZipWhenDone) {
        File selectedFile;
        if (this.psdbParent.getPsdbFile() != null) {
            this.lastSelectedFolder.setLastSelectedFolder(this.psdbParent.getPsdbFile().getParentFile().getAbsolutePath());
            selectedFile = this.getUserSelectedFile(this.psdbParent.getPsdbFile().getName(), ".psdb", "PeptideShaker Database format (*.psdb)", "Save As...", false);
        } else {
            selectedFile = this.getUserSelectedFile(this.psdbParent.getProjectParameters().getProjectUniqueName() + ".psdb", ".psdb", "PeptideShaker Database format (*.psdb)", "Save As...", false);
        }
        this.psdbParent.setPsdbFile(selectedFile);
        if (selectedFile != null) {
            this.saveProject(closeWhenDone, aExportToZipWhenDone);
        }
    }

    public File getUserSelectedFile(String aSuggestedFileName, String aFileEnding, String aFileFormatDescription, String aDialogTitle, boolean openDialog) {
        File selectedFile = FileChooserUtil.getUserSelectedFile((Component)this, (String)aFileEnding, (String)aFileFormatDescription, (String)aDialogTitle, (String)this.lastSelectedFolder.getLastSelectedFolder(), (String)aSuggestedFileName, (boolean)openDialog);
        if (selectedFile != null) {
            if (selectedFile.isDirectory()) {
                this.lastSelectedFolder.setLastSelectedFolder(selectedFile.getAbsolutePath());
            } else {
                this.lastSelectedFolder.setLastSelectedFolder(selectedFile.getParentFile().getAbsolutePath());
            }
        }
        return selectedFile;
    }

    public void jumpToTab(int tabIndex) {
        this.allTabsJTabbedPane.setSelectedIndex(tabIndex);
    }

    public boolean showSparklines() {
        return this.sparklinesJCheckBoxMenuItem.isSelected();
    }

    public void updateSurroundingAminoAcids() {
        this.overviewPanel.updateSurroundingAminoAcids();
    }

    private void addShortcutAtDeskTop() {
        String jarFilePath = PeptideShaker.getJarFilePath();
        if (!jarFilePath.equalsIgnoreCase(".")) {
            if (jarFilePath.startsWith("\\") && !jarFilePath.startsWith("\\\\")) {
                jarFilePath = jarFilePath.substring(1);
            }
            String iconFileLocation = jarFilePath + "\\resources\\peptide-shaker.ico";
            String jarFileLocation = jarFilePath + "\\PeptideShaker-" + PeptideShaker.getVersion() + ".jar";
            try {
                JShellLink link = new JShellLink();
                link.setFolder(JShellLink.getDirectory((String)"desktop"));
                link.setName("Peptide Shaker " + PeptideShaker.getVersion());
                link.setIconLocation(iconFileLocation);
                link.setPath(jarFileLocation);
                link.save();
            }
            catch (Exception e) {
                System.out.println("An error occurred when trying to create a desktop shortcut...");
                e.printStackTrace();
            }
        }
    }

    public void checkNewsFeed() {
    }

    private ArrayList<String> getNewTweets() {
        ArrayList<String> tweets = new ArrayList<String>();
        try {
            String strLine;
            URL url = new URL("https://twitter.com/compomics");
            URLConnection spoof = url.openConnection();
            spoof.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0; H010818)");
            BufferedReader in = new BufferedReader(new InputStreamReader(spoof.getInputStream()));
            while ((strLine = in.readLine()) != null) {
                if (strLine.lastIndexOf("dir=\"ltr\" data-aria-label-part=\"0\"") == -1) continue;
                String tweetId = strLine.substring(strLine.indexOf(">") + 1, strLine.indexOf("</p>") - 1);
                if (this.utilitiesUserParameters.getReadTweets().contains(tweetId) || this.publishedTweets.contains(tweetId)) continue;
                tweets.add(tweetId);
            }
        }
        catch (UnknownHostException e) {
            System.out.println("Unable to get twitter feed in off line mode.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tweets;
    }

    public void openExampleFile() {
        boolean open = true;
        if (!this.dataSaved && this.getProjectParameters() != null) {
            int value = JOptionPane.showConfirmDialog(this, "Do you want to save the changes to " + this.getProjectParameters().getProjectUniqueName() + "?", "Unsaved Changes", 1, 3);
            if (value == 0) {
                this.saveMenuItemActionPerformed(null);
                open = false;
            } else if (value == 2 || value == -1) {
                open = false;
            }
        }
        if (open) {
            String filePath = PeptideShaker.getJarFilePath() + "/resources/example_dataset/HeLa Example.psdb";
            if (!new File(filePath).exists()) {
                JOptionPane.showMessageDialog(null, "File not found!", "File Error", 0);
            } else {
                this.clearData(true, true);
                this.clearParameters();
                this.importPeptideShakerFile(new File(filePath), false);
                this.psdbParent.getUserParameters().addRecentProject(filePath);
            }
            this.updateRecentProjectsList();
        }
    }

    public void updateFilterSettingsField(String text) {
    }

    public void exportProjectAsZip() {
        if (!this.dataSaved) {
            int option = JOptionPane.showConfirmDialog(this, "You first need to save the project.", "Unsaved Data", 2);
            if (option == 0) {
                this.saveProjectAs(false, true);
            }
        } else if (this.psdbParent.getPsdbFile() != null) {
            String suggestedFileName = this.psdbParent.getPsdbFile().getName();
            File selectedFile = this.getUserSelectedFile(suggestedFileName = suggestedFileName.substring(0, suggestedFileName.lastIndexOf(".")) + ".zip", ".zip", "Compressed file format (*.zip)", "Export As Zip...", false);
            if (selectedFile != null) {
                final File zipFile = selectedFile;
                this.progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
                this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
                this.progressDialog.setTitle("Exporting Project. Please Wait...");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PeptideShakerGUI.this.progressDialog.setVisible(true);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }, "ProgressDialog").start();
                new Thread("ExportThread"){

                    @Override
                    public void run() {
                        File psdbFile = PeptideShakerGUI.this.psdbParent.getPsdbFile();
                        File fastaFile = new File(PeptideShakerGUI.this.getProjectDetails().getFastaFile());
                        try {
                            ProjectExport.exportProjectAsZip(zipFile, fastaFile, PeptideShakerGUI.this.getSpectrumProvider(), null, null, null, psdbFile, false, (WaitingHandler)PeptideShakerGUI.this.progressDialog);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            PeptideShakerGUI.this.progressDialog.setRunFinished();
                            JOptionPane.showMessageDialog(PeptideShakerGUI.this, "Could not zip files.", "Zip Error", 1);
                            return;
                        }
                        boolean processCancelled = PeptideShakerGUI.this.progressDialog.isRunCanceled();
                        PeptideShakerGUI.this.progressDialog.setRunFinished();
                        if (!processCancelled) {
                            int BYTES_PER_MEGABYTE = 0x100000;
                            double sizeOfZippedFile = Util.roundDouble((double)((double)zipFile.length() / 1048576.0), (int)2);
                            JOptionPane.showMessageDialog(PeptideShakerGUI.this, "Project zipped to '" + zipFile.getAbsolutePath() + "' (" + sizeOfZippedFile + " MB)", "Export Sucessful", 1);
                        }
                    }
                }.start();
            }
        }
    }

    public Image getNormalIcon() {
        return Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif"));
    }

    public Image getWaitingIcon() {
        return Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif"));
    }

    public long getDefaultPsmSelection(long peptideKey) {
        if (peptideKey == ExperimentObject.NO_KEY) {
            return ExperimentObject.NO_KEY;
        }
        long[] psmKeys = this.getIdentificationFeaturesGenerator().getSortedPsmKeys(peptideKey, this.utilitiesUserParameters.getSortPsmsOnRt(), false);
        return psmKeys.length > 0 ? psmKeys[0] : ExperimentObject.NO_KEY;
    }

    public long getDefaultPeptideSelection(long proteinKey) {
        if (proteinKey == ExperimentObject.NO_KEY) {
            return ExperimentObject.NO_KEY;
        }
        long[] peptideKeys = this.getIdentificationFeaturesGenerator().getSortedPeptideKeys(proteinKey);
        return peptideKeys.length > 0 ? peptideKeys[0] : ExperimentObject.NO_KEY;
    }

    public void clearGeneMappings() {
        this.goPanel.clearOldResults();
        this.dataSaved = false;
    }

    public void notificationClicked(String notificationType) {
        if (notificationType.equalsIgnoreCase("note") || notificationType.equalsIgnoreCase("notes")) {
            this.notesButtonMouseReleased(null);
        } else if (notificationType.equalsIgnoreCase("tip") || notificationType.equalsIgnoreCase("tips")) {
            this.tipsButtonMouseReleased(null);
        } else if (notificationType.equalsIgnoreCase("tweet") || notificationType.equalsIgnoreCase("tweets")) {
            this.newsButtonMouseReleased(null);
        }
    }

    public void addNote(String note) {
        this.currentNotes.add(note);
        this.updateNotesNotificationCounter();
    }

    public void setCurentNotes(ArrayList<String> currentNotes) {
        this.currentNotes = currentNotes;
        this.updateNotesNotificationCounter();
    }

    public void updateNotesNotificationCounter() {
        if (this.currentNotes.size() > 0) {
            this.notesButton.setText("Notes (" + this.currentNotes.size() + ")");
        } else {
            this.notesButton.setText("Notes");
        }
    }

    public void showNotesNotification() {
    }

    public void addTip(String tip) {
        this.currentTips.add(tip);
        this.updateTipsNotificationCounter();
    }

    public void setCurentTips(ArrayList<String> currentTips) {
        this.currentTips = currentTips;
        this.updateTipsNotificationCounter();
    }

    public void updateTipsNotificationCounter() {
        if (this.currentTips.size() > 0) {
            this.tipsButton.setText("Tips (" + this.currentTips.size() + ")");
        } else {
            this.tipsButton.setText("Tips");
        }
    }

    public void showTipsNotification() {
    }

    public String getExtendedProjectReport() {
        return this.psdbParent.getExtendedProjectReport(null);
    }

    public boolean checkForNewVersion() {
        try {
            File jarFile = new File(PeptideShakerGUI.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            MavenJarFile oldMavenJarFile = new MavenJarFile(jarFile.toURI());
            URL jarRepository = new URL("https", "genesis.ugent.be", "/archiva/repository/maven2/");
            return CompomicsWrapper.checkForNewDeployedVersion((String)"PeptideShaker", (MavenJarFile)oldMavenJarFile, (URL)jarRepository, (String)"peptide-shaker.ico", (boolean)false, (boolean)true, (boolean)true, (Image)Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), (Image)Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), (boolean)true);
        }
        catch (UnknownHostException ex) {
            System.out.println("Checking for new version failed. No internet connection.");
            return false;
        }
        catch (ConnectException ex) {
            System.out.println("Checking for new version failed. Connection refused.");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void selectDefaultAnnotationMenuItem() {
        this.defaultAnnotationCheckBoxMenuItem.setSelected(true);
        this.resetAnnotationMenu.setVisible(false);
    }

    private void deselectDefaultAnnotationMenuItem() {
        this.defaultAnnotationCheckBoxMenuItem.setSelected(false);
        this.resetAnnotationMenu.setVisible(true);
    }

    static {
        XYBarRenderer.setDefaultBarPainter((XYBarPainter)new StandardXYBarPainter());
        useLogFile = true;
        TITLED_BORDER_HORIZONTAL_PADDING = "";
        TITLED_BORDER_HORIZONTAL_PADDING_HTML = "";
        DARK_THEME_BACKGROUND_COLOR = new Color(18, 18, 18);
    }
}

