/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.export;

import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.export.report.ReportEditor;
import com.compomics.util.gui.file_handling.FileAndFileFilter;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.export.ExportFactory;
import com.compomics.util.io.export.ExportFormat;
import com.compomics.util.io.export.ExportScheme;
import com.compomics.util.waiting.WaitingHandler;
import com.google.common.collect.Lists;
import eu.isas.peptideshaker.export.PSExportFactory;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;

public class FeaturesExportDialog
extends JDialog {
    private final PeptideShakerGUI peptideShakerGUI;
    private static ProgressDialogX progressDialog;
    private final PSExportFactory exportFactory = PSExportFactory.getInstance();
    private ArrayList<String> exportSchemesNames;
    private JLabel addReportLabel;
    private JMenuItem addReportMenuItem;
    private JPanel backgroundPanel;
    private JPanel customReportsPanel;
    private JMenuItem editReportMenuItem;
    private JButton exitButton;
    private JButton exportReportButton;
    private JPanel featuresPanel;
    private JButton helpJButton;
    private JLabel helpLabel;
    private JMenuItem removeReportMenuItem;
    private JMenuItem reportDocumentationMenuItem;
    private JPopupMenu reportDocumentationPopupMenu;
    private JPopupMenu.Separator reportPopUpMenuSeparator;
    private JTable reportsTable;
    private JScrollPane reportsTableScrollPane;

    public FeaturesExportDialog(PeptideShakerGUI peptideShakerGUI) {
        super((Frame)peptideShakerGUI, true);
        this.peptideShakerGUI = peptideShakerGUI;
        this.initComponents();
        this.setUpGUI();
        this.pack();
        this.setLocationRelativeTo(peptideShakerGUI);
        this.updateReportsList();
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.reportsTable.getTableHeader().setReorderingAllowed(false);
        this.reportsTable.getColumn(" ").setMaxWidth(30);
        this.reportsTable.getColumn(" ").setMinWidth(30);
        this.reportsTableScrollPane.getViewport().setOpaque(false);
    }

    private void initComponents() {
        this.reportDocumentationPopupMenu = new JPopupMenu();
        this.addReportMenuItem = new JMenuItem();
        this.removeReportMenuItem = new JMenuItem();
        this.editReportMenuItem = new JMenuItem();
        this.reportPopUpMenuSeparator = new JPopupMenu.Separator();
        this.reportDocumentationMenuItem = new JMenuItem();
        this.backgroundPanel = new JPanel();
        this.featuresPanel = new JPanel();
        this.customReportsPanel = new JPanel();
        this.reportsTableScrollPane = new JScrollPane();
        this.reportsTable = new JTable();
        this.exportReportButton = new JButton();
        this.helpLabel = new JLabel();
        this.addReportLabel = new JLabel();
        this.exitButton = new JButton();
        this.helpJButton = new JButton();
        this.addReportMenuItem.setText("Add");
        this.addReportMenuItem.setToolTipText("Add a new report type");
        this.addReportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeaturesExportDialog.this.addReportMenuItemActionPerformed(evt);
            }
        });
        this.reportDocumentationPopupMenu.add(this.addReportMenuItem);
        this.removeReportMenuItem.setText("Remove");
        this.removeReportMenuItem.setToolTipText("Remove the report type");
        this.removeReportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeaturesExportDialog.this.removeReportMenuItemActionPerformed(evt);
            }
        });
        this.reportDocumentationPopupMenu.add(this.removeReportMenuItem);
        this.editReportMenuItem.setText("Edit");
        this.editReportMenuItem.setToolTipText("Edit the report");
        this.editReportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeaturesExportDialog.this.editReportMenuItemActionPerformed(evt);
            }
        });
        this.reportDocumentationPopupMenu.add(this.editReportMenuItem);
        this.reportDocumentationPopupMenu.add(this.reportPopUpMenuSeparator);
        this.reportDocumentationMenuItem.setText("Documentation");
        this.reportDocumentationMenuItem.setToolTipText("Export the report documentation to file");
        this.reportDocumentationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeaturesExportDialog.this.reportDocumentationMenuItemActionPerformed(evt);
            }
        });
        this.reportDocumentationPopupMenu.add(this.reportDocumentationMenuItem);
        this.setTitle("Export Features");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.featuresPanel.setBorder(BorderFactory.createTitledBorder("Report"));
        this.featuresPanel.setOpaque(false);
        this.customReportsPanel.setBackground(new Color(230, 230, 230));
        this.reportsTable.setModel(new ReportsTableModel());
        this.reportsTable.setSelectionMode(0);
        this.reportsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FeaturesExportDialog.this.reportsTableMouseClicked(evt);
            }
        });
        this.reportsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FeaturesExportDialog.this.reportsTableKeyReleased(evt);
            }
        });
        this.reportsTableScrollPane.setViewportView(this.reportsTable);
        this.exportReportButton.setText("Export");
        this.exportReportButton.setEnabled(false);
        this.exportReportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeaturesExportDialog.this.exportReportButtonActionPerformed(evt);
            }
        });
        this.helpLabel.setFont(this.helpLabel.getFont().deriveFont(this.helpLabel.getFont().getStyle() | 2));
        this.helpLabel.setText("Right click on a row in the table for additional options.");
        this.addReportLabel.setText("<html> <a href>Add new report type.</a> </html>");
        this.addReportLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FeaturesExportDialog.this.addReportLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                FeaturesExportDialog.this.addReportLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                FeaturesExportDialog.this.addReportLabelMouseExited(evt);
            }
        });
        GroupLayout customReportsPanelLayout = new GroupLayout(this.customReportsPanel);
        this.customReportsPanel.setLayout(customReportsPanelLayout);
        customReportsPanelLayout.setHorizontalGroup(customReportsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customReportsPanelLayout.createSequentialGroup().addContainerGap().addGroup(customReportsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.reportsTableScrollPane, GroupLayout.Alignment.TRAILING, -1, 651, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, customReportsPanelLayout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.addReportLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.helpLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 199, Short.MAX_VALUE).addComponent(this.exportReportButton))).addContainerGap()));
        customReportsPanelLayout.setVerticalGroup(customReportsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customReportsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.reportsTableScrollPane, -1, 298, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(customReportsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exportReportButton).addComponent(this.helpLabel).addComponent(this.addReportLabel, -2, -1, -2)).addContainerGap()));
        GroupLayout featuresPanelLayout = new GroupLayout(this.featuresPanel);
        this.featuresPanel.setLayout(featuresPanelLayout);
        featuresPanelLayout.setHorizontalGroup(featuresPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(featuresPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.customReportsPanel, -2, -1, -2).addContainerGap(15, Short.MAX_VALUE)));
        featuresPanelLayout.setVerticalGroup(featuresPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(featuresPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.customReportsPanel, -2, -1, -2)));
        this.exitButton.setText("Exit");
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeaturesExportDialog.this.exitButtonActionPerformed(evt);
            }
        });
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                FeaturesExportDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                FeaturesExportDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeaturesExportDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.helpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.exitButton).addContainerGap()).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.featuresPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.featuresPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton).addComponent(this.exitButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/FeatureExport.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Export Features - Help");
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exitButtonActionPerformed(ActionEvent evt) {
        try {
            PSExportFactory.saveFactory(this.exportFactory);
        }
        catch (Exception e) {
            this.peptideShakerGUI.catchException(e);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void exportReportButtonActionPerformed(ActionEvent evt) {
        this.writeSelectedReport();
    }

    private void reportsTableMouseClicked(MouseEvent evt) {
        if (evt != null && this.reportsTable.rowAtPoint(evt.getPoint()) != -1) {
            this.reportsTable.setRowSelectionInterval(this.reportsTable.rowAtPoint(evt.getPoint()), this.reportsTable.rowAtPoint(evt.getPoint()));
        }
        if (evt != null && evt.getButton() == 3 && this.reportsTable.getSelectedRow() != -1) {
            String schemeName = (String)this.reportsTable.getValueAt(this.reportsTable.getSelectedRow(), 1);
            ExportScheme exportScheme = this.exportFactory.getExportScheme(schemeName);
            this.editReportMenuItem.setVisible(exportScheme.isEditable());
            this.removeReportMenuItem.setVisible(exportScheme.isEditable());
            this.reportDocumentationPopupMenu.show(this.reportsTable, evt.getX(), evt.getY());
        }
        if (evt != null && evt.getButton() == 1 && evt.getClickCount() == 2) {
            this.writeSelectedReport();
        }
        this.exportReportButton.setEnabled(this.reportsTable.getSelectedRow() != -1);
    }

    private void reportsTableKeyReleased(KeyEvent evt) {
        this.reportsTableMouseClicked(null);
    }

    private void reportDocumentationMenuItemActionPerformed(ActionEvent evt) {
        this.writeDocumentationOfSelectedReport();
    }

    private void editReportMenuItemActionPerformed(ActionEvent evt) {
        String reportName = (String)this.reportsTable.getValueAt(this.reportsTable.getSelectedRow(), 1);
        new ReportEditor((Frame)this.peptideShakerGUI, (ExportFactory)this.exportFactory, reportName, true);
        int selectedRow = this.reportsTable.getSelectedRow();
        this.updateReportsList();
        ((DefaultTableModel)this.reportsTable.getModel()).fireTableDataChanged();
        if (selectedRow != -1) {
            this.reportsTable.setRowSelectionInterval(selectedRow, selectedRow);
        }
        this.reportsTableMouseClicked(null);
    }

    private void addReportMenuItemActionPerformed(ActionEvent evt) {
        new ReportEditor((Frame)this.peptideShakerGUI, (ExportFactory)this.exportFactory);
        int selectedRow = this.reportsTable.getSelectedRow();
        this.updateReportsList();
        ((DefaultTableModel)this.reportsTable.getModel()).fireTableDataChanged();
        if (selectedRow != -1) {
            this.reportsTable.setRowSelectionInterval(selectedRow, selectedRow);
        }
        this.reportsTableMouseClicked(null);
    }

    private void removeReportMenuItemActionPerformed(ActionEvent evt) {
        String reportName = (String)this.reportsTable.getValueAt(this.reportsTable.getSelectedRow(), 1);
        this.exportFactory.removeExportScheme(reportName);
        this.updateReportsList();
        ((DefaultTableModel)this.reportsTable.getModel()).fireTableDataChanged();
        this.reportsTableMouseClicked(null);
    }

    private void addReportLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void addReportLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void addReportLabelMouseClicked(MouseEvent evt) {
        this.addReportMenuItemActionPerformed(null);
    }

    private void updateReportsList() {
        this.exportSchemesNames = Lists.newArrayList((Object[])PSExportFactory.getDefaultExportSchemesNames());
        this.exportSchemesNames.addAll(this.exportFactory.getUserSchemesNames());
    }

    private void writeSelectedReport() {
        final String schemeName = (String)this.reportsTable.getValueAt(this.reportsTable.getSelectedRow(), 1);
        String lastSelectedFolderPath = this.peptideShakerGUI.getLastSelectedFolder().getLastSelectedFolder();
        String[] extensionsOptions = new String[]{".xls", ".txt", ".gz"};
        String textFileFilterDescription = "Tab separated text file (.txt)";
        String gzipFileFilterDescription = "Gzipped tab separated text file (.gz)";
        String excelFileFilterDescription = "Excel Workbook (.xls)";
        String[] fileFiltersDescriptionsOptions = new String[]{excelFileFilterDescription, textFileFilterDescription, gzipFileFilterDescription};
        FileAndFileFilter selectedFileAndFilter = FileChooserUtil.getUserSelectedFile((Component)this, (String[])extensionsOptions, (String[])fileFiltersDescriptionsOptions, (String)"Export Report", (String)lastSelectedFolderPath, (String)schemeName, (boolean)false, (boolean)true, (boolean)false, (int)1);
        if (selectedFileAndFilter != null) {
            boolean gzip;
            ExportFormat exportFormat;
            final File selectedFile = selectedFileAndFilter.getFile();
            if (selectedFileAndFilter.getFileFilter().getDescription().equalsIgnoreCase(textFileFilterDescription)) {
                exportFormat = ExportFormat.text;
                gzip = false;
            } else if (selectedFileAndFilter.getFileFilter().getDescription().equalsIgnoreCase(gzipFileFilterDescription)) {
                exportFormat = ExportFormat.text;
                gzip = true;
            } else {
                exportFormat = ExportFormat.excel;
                gzip = false;
            }
            progressDialog = new ProgressDialogX((JDialog)this, (Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            progressDialog.setTitle("Exporting Report. Please Wait...");
            final String filePath = selectedFile.getPath();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("ExportThread"){

                @Override
                public void run() {
                    try {
                        ExportScheme exportScheme = FeaturesExportDialog.this.exportFactory.getExportScheme(schemeName);
                        progressDialog.setTitle("Exporting. Please Wait...");
                        PSExportFactory.writeExport(exportScheme, selectedFile, exportFormat, gzip, FeaturesExportDialog.this.peptideShakerGUI.getProjectParameters().getProjectUniqueName(), FeaturesExportDialog.this.peptideShakerGUI.getProjectDetails(), FeaturesExportDialog.this.peptideShakerGUI.getIdentification(), FeaturesExportDialog.this.peptideShakerGUI.getIdentificationFeaturesGenerator(), FeaturesExportDialog.this.peptideShakerGUI.getGeneMaps(), null, null, null, FeaturesExportDialog.this.peptideShakerGUI.getDisplayParameters().getnAASurroundingPeptides(), FeaturesExportDialog.this.peptideShakerGUI.getIdentificationParameters(), FeaturesExportDialog.this.peptideShakerGUI.getSequenceProvider(), FeaturesExportDialog.this.peptideShakerGUI.getProteinDetailsProvider(), FeaturesExportDialog.this.peptideShakerGUI.getSpectrumProvider(), FeaturesExportDialog.this.peptideShakerGUI.getSpectrumCountingParameters(), (WaitingHandler)progressDialog);
                        boolean processCancelled = progressDialog.isRunCanceled();
                        progressDialog.setRunFinished();
                        if (!processCancelled) {
                            JOptionPane.showMessageDialog(FeaturesExportDialog.this.peptideShakerGUI, "Data copied to file:\n" + filePath, "Data Exported.", 1);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        if (e.getMessage().contains("Invalid row number (65536)")) {
                            progressDialog.setRunFinished();
                            JOptionPane.showMessageDialog(FeaturesExportDialog.this.peptideShakerGUI, "An error occurred while generating the output. This format can contain only 65,535 lines.\nPlease use a text export instead.", "Output Error.", 0);
                            e.printStackTrace();
                        } else {
                            progressDialog.setRunFinished();
                            JOptionPane.showMessageDialog(FeaturesExportDialog.this.peptideShakerGUI, "An error occurred while generating the output.", "Output Error.", 0);
                            e.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        progressDialog.setRunFinished();
                        JOptionPane.showMessageDialog(FeaturesExportDialog.this.peptideShakerGUI, "An error occurred while generating the output.", "Output Error.", 0);
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    private void writeDocumentationOfSelectedReport() {
        final String schemeName = (String)this.reportsTable.getValueAt(this.reportsTable.getSelectedRow(), 1);
        String textFileFilterDescription = "Tab separated text file (.txt)";
        String excelFileFilterDescription = "Excel Workbook (.xls)";
        String lastSelectedFolderPath = this.peptideShakerGUI.getLastSelectedFolder().getLastSelectedFolder();
        FileAndFileFilter selectedFileAndFilter = FileChooserUtil.getUserSelectedFile((Component)this, (String[])new String[]{".txt", ".xls"}, (String[])new String[]{textFileFilterDescription, excelFileFilterDescription}, (String)"Export Report", (String)lastSelectedFolderPath, (String)(schemeName + "_documentation"), (boolean)false, (boolean)true, (boolean)false, (int)0);
        if (selectedFileAndFilter != null) {
            final File selectedFile = selectedFileAndFilter.getFile();
            final ExportFormat exportFormat = selectedFileAndFilter.getFileFilter().getDescription().equalsIgnoreCase(textFileFilterDescription) ? ExportFormat.text : ExportFormat.excel;
            progressDialog = new ProgressDialogX((JDialog)this, (Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("ExportThread"){

                @Override
                public void run() {
                    boolean error = false;
                    try {
                        ExportScheme exportScheme = FeaturesExportDialog.this.exportFactory.getExportScheme(schemeName);
                        PSExportFactory.writeDocumentation(exportScheme, exportFormat, selectedFile);
                    }
                    catch (Exception e) {
                        error = true;
                        FeaturesExportDialog.this.peptideShakerGUI.catchException(e);
                    }
                    progressDialog.setRunFinished();
                    if (!error) {
                        JOptionPane.showMessageDialog(FeaturesExportDialog.this.peptideShakerGUI, "Documentation saved to '" + selectedFile.getAbsolutePath() + "'.", "Documentation Saved", 1);
                    }
                }
            }.start();
        }
    }

    private class ReportsTableModel
    extends DefaultTableModel {
        @Override
        public int getRowCount() {
            if (FeaturesExportDialog.this.exportSchemesNames == null) {
                return 0;
            }
            return FeaturesExportDialog.this.exportSchemesNames.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return FeaturesExportDialog.this.exportSchemesNames.get(row);
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

