/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.export;

import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.file.LastSelectedFolder;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.followup.InclusionListExport;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.gui.export.FollowUpExportDialog;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;

public class InclusionListExportDialog
extends JDialog {
    private final FollowUpExportDialog followupPreferencesDialog;
    private static ProgressDialogX progressDialog;
    private final InclusionListExport.ExportFormat exportFormat;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JCheckBox degeneratedCheck;
    private JLabel jLabel1;
    private JLabel minRtWindowUnitLabel;
    private JCheckBox miscleavedCheck;
    private JButton okButton;
    private JPanel peptideFilterPanel;
    private JPanel proteinFilterPanel;
    private JCheckBox reactiveCheck;
    private JCheckBox relatedProteinsCheck;
    private JCheckBox relatredAndUnrelatedCheck;
    private JPanel rtFilterPanel;
    private JTextField rtWindow;
    private JCheckBox unrelatedCheck;

    public InclusionListExportDialog(FollowUpExportDialog followupPreferencesDialog, InclusionListExport.ExportFormat exportFormat, boolean modal) {
        super((Dialog)followupPreferencesDialog, modal);
        this.followupPreferencesDialog = followupPreferencesDialog;
        this.exportFormat = exportFormat;
        this.initComponents();
        this.setLocationRelativeTo(followupPreferencesDialog);
        this.setVisible(true);
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.proteinFilterPanel = new JPanel();
        this.relatedProteinsCheck = new JCheckBox();
        this.relatredAndUnrelatedCheck = new JCheckBox();
        this.unrelatedCheck = new JCheckBox();
        this.peptideFilterPanel = new JPanel();
        this.miscleavedCheck = new JCheckBox();
        this.reactiveCheck = new JCheckBox();
        this.degeneratedCheck = new JCheckBox();
        this.rtFilterPanel = new JPanel();
        this.rtWindow = new JTextField();
        this.minRtWindowUnitLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Export Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.proteinFilterPanel.setBorder(BorderFactory.createTitledBorder("Protein Exclusion Filter"));
        this.proteinFilterPanel.setOpaque(false);
        this.relatedProteinsCheck.setText("Related Proteins");
        this.relatedProteinsCheck.setIconTextGap(15);
        this.relatedProteinsCheck.setOpaque(false);
        this.relatredAndUnrelatedCheck.setText("Related and Unrelated Proteins");
        this.relatredAndUnrelatedCheck.setIconTextGap(15);
        this.relatredAndUnrelatedCheck.setOpaque(false);
        this.unrelatedCheck.setSelected(true);
        this.unrelatedCheck.setText("Unrelated Proteins");
        this.unrelatedCheck.setIconTextGap(15);
        this.unrelatedCheck.setOpaque(false);
        GroupLayout proteinFilterPanelLayout = new GroupLayout(this.proteinFilterPanel);
        this.proteinFilterPanel.setLayout(proteinFilterPanelLayout);
        proteinFilterPanelLayout.setHorizontalGroup(proteinFilterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinFilterPanelLayout.createSequentialGroup().addContainerGap().addGroup(proteinFilterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.relatedProteinsCheck, -2, 169, -2).addComponent(this.relatredAndUnrelatedCheck).addComponent(this.unrelatedCheck)).addContainerGap(97, Short.MAX_VALUE)));
        proteinFilterPanelLayout.setVerticalGroup(proteinFilterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinFilterPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.relatedProteinsCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.relatredAndUnrelatedCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unrelatedCheck).addContainerGap(-1, Short.MAX_VALUE)));
        this.peptideFilterPanel.setBorder(BorderFactory.createTitledBorder("Peptide Exclusion Filter"));
        this.peptideFilterPanel.setOpaque(false);
        this.miscleavedCheck.setSelected(true);
        this.miscleavedCheck.setText("Miscleaved Peptides");
        this.miscleavedCheck.setIconTextGap(15);
        this.miscleavedCheck.setOpaque(false);
        this.reactiveCheck.setSelected(true);
        this.reactiveCheck.setText("Reactive Peptides");
        this.reactiveCheck.setIconTextGap(15);
        this.reactiveCheck.setOpaque(false);
        this.degeneratedCheck.setSelected(true);
        this.degeneratedCheck.setText("Shared Peptides");
        this.degeneratedCheck.setIconTextGap(15);
        this.degeneratedCheck.setOpaque(false);
        GroupLayout peptideFilterPanelLayout = new GroupLayout(this.peptideFilterPanel);
        this.peptideFilterPanel.setLayout(peptideFilterPanelLayout);
        peptideFilterPanelLayout.setHorizontalGroup(peptideFilterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptideFilterPanelLayout.createSequentialGroup().addContainerGap().addGroup(peptideFilterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.degeneratedCheck).addComponent(this.reactiveCheck).addComponent(this.miscleavedCheck, -2, 169, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        peptideFilterPanelLayout.setVerticalGroup(peptideFilterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptideFilterPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.miscleavedCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reactiveCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.degeneratedCheck).addContainerGap(-1, Short.MAX_VALUE)));
        this.rtFilterPanel.setBorder(BorderFactory.createTitledBorder("Retention Time Filter"));
        this.rtFilterPanel.setOpaque(false);
        this.rtWindow.setHorizontalAlignment(0);
        this.rtWindow.setText("20");
        this.minRtWindowUnitLabel.setText("s");
        this.jLabel1.setText("Min RT Window");
        GroupLayout rtFilterPanelLayout = new GroupLayout(this.rtFilterPanel);
        this.rtFilterPanel.setLayout(rtFilterPanelLayout);
        rtFilterPanelLayout.setHorizontalGroup(rtFilterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rtFilterPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rtWindow).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.minRtWindowUnitLabel).addContainerGap()));
        rtFilterPanelLayout.setVerticalGroup(rtFilterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rtFilterPanelLayout.createSequentialGroup().addContainerGap().addGroup(rtFilterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rtWindow, -2, -1, -2).addComponent(this.minRtWindowUnitLabel).addComponent(this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InclusionListExportDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InclusionListExportDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.peptideFilterPanel, -1, -1, Short.MAX_VALUE).addComponent(this.proteinFilterPanel, -1, -1, Short.MAX_VALUE).addComponent(this.rtFilterPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinFilterPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideFilterPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rtFilterPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            LastSelectedFolder lastSelectedFolder = this.followupPreferencesDialog.getPeptideShakerGUI().getLastSelectedFolder();
            String folder = lastSelectedFolder.getLastSelectedFolder("export");
            if (folder == null) {
                folder = lastSelectedFolder.getLastSelectedFolder();
            }
            final JFileChooser fileChooser = new JFileChooser(folder);
            fileChooser.setDialogTitle("Select Destination File");
            fileChooser.setMultiSelectionEnabled(false);
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File myFile) {
                    return myFile.isDirectory() || myFile.getName().endsWith(((InclusionListExportDialog)InclusionListExportDialog.this).exportFormat.extension);
                }

                @Override
                public String getDescription() {
                    switch (InclusionListExportDialog.this.exportFormat) {
                        case Thermo: {
                            return "(Thermo inclusion list) .txt";
                        }
                        case ABI: {
                            return "(ABI inclusion list) .txt";
                        }
                        case Bruker: {
                            return "(Bruker inclusion list) .csv";
                        }
                        case MassLynx: {
                            return "(MassLynx inclusion list) .txt";
                        }
                    }
                    return "(unknown format) .txt";
                }
            };
            fileChooser.setFileFilter(filter);
            int returnVal = fileChooser.showSaveDialog(this);
            if (returnVal == 0) {
                File tempOutputFile = fileChooser.getSelectedFile();
                tempOutputFile = InclusionListExport.ExportFormat.verifyFileExtension(tempOutputFile, this.exportFormat);
                int outcome = 0;
                if (tempOutputFile.exists()) {
                    outcome = JOptionPane.showConfirmDialog(this, "Should " + tempOutputFile + " be overwritten?", "Selected File Already Exists", 0, 2);
                }
                if (outcome == 0) {
                    this.dispose();
                    progressDialog = new ProgressDialogX((JDialog)this, (Frame)this.followupPreferencesDialog.getPeptideShakerGUI(), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
                    progressDialog.setPrimaryProgressCounterIndeterminate(true);
                    progressDialog.setTitle("Exporting. Please Wait...");
                    final File outputFile = tempOutputFile;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            progressDialog.setVisible(true);
                        }
                    }, "ProgressDialog").start();
                    new Thread("SaveThread"){

                        @Override
                        public void run() {
                            try {
                                PeptideShakerGUI peptideShakerGUI = InclusionListExportDialog.this.followupPreferencesDialog.getPeptideShakerGUI();
                                double rtWindowDouble = Double.parseDouble(InclusionListExportDialog.this.rtWindow.getText());
                                InclusionListExport.exportInclusionList(outputFile, peptideShakerGUI.getIdentification(), peptideShakerGUI.getIdentificationFeaturesGenerator(), peptideShakerGUI.getSpectrumProvider(), InclusionListExportDialog.this.getProteinFilters(), InclusionListExportDialog.this.getPeptideFilters(), InclusionListExportDialog.this.exportFormat, peptideShakerGUI.getIdentificationParameters().getSearchParameters(), rtWindowDouble, (WaitingHandler)progressDialog, peptideShakerGUI.getFilterParameters());
                                boolean processCancelled = progressDialog.isRunCanceled();
                                progressDialog.setRunFinished();
                                if (!processCancelled) {
                                    JOptionPane.showMessageDialog(InclusionListExportDialog.this.followupPreferencesDialog, "Inclusion list saved to " + fileChooser.getSelectedFile().getName() + ".", "Save Complete", 1);
                                }
                            }
                            catch (Exception e) {
                                progressDialog.setRunFinished();
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(InclusionListExportDialog.this.followupPreferencesDialog, "An error occurred when saving the file.", "Saving Failed", 0);
                            }
                        }
                    }.start();
                }
            }
        }
    }

    private boolean validateInput() {
        try {
            Double.valueOf(this.rtWindow.getText().trim());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the RT minimal window.", "Wrong input", 2);
            return false;
        }
        return true;
    }

    private ArrayList<Integer> getProteinFilters() {
        ArrayList<Integer> proteinFilters = new ArrayList<Integer>();
        if (this.relatedProteinsCheck.isSelected()) {
            proteinFilters.add(1);
        }
        if (this.relatredAndUnrelatedCheck.isSelected()) {
            proteinFilters.add(2);
        }
        if (this.unrelatedCheck.isSelected()) {
            proteinFilters.add(3);
        }
        return proteinFilters;
    }

    private ArrayList<InclusionListExport.PeptideFilterType> getPeptideFilters() {
        ArrayList<InclusionListExport.PeptideFilterType> peptideFilters = new ArrayList<InclusionListExport.PeptideFilterType>();
        if (this.miscleavedCheck.isSelected()) {
            peptideFilters.add(InclusionListExport.PeptideFilterType.miscleaved);
        }
        if (this.degeneratedCheck.isSelected()) {
            peptideFilters.add(InclusionListExport.PeptideFilterType.degenerated);
        }
        if (this.reactiveCheck.isSelected()) {
            peptideFilters.add(InclusionListExport.PeptideFilterType.reactive);
        }
        return peptideFilters;
    }
}

