/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.filtering;

import com.compomics.util.experiment.filtering.Filter;
import com.compomics.util.experiment.identification.filtering.MatchFilter;
import com.compomics.util.experiment.identification.filtering.PeptideFilter;
import com.compomics.util.experiment.identification.filtering.ProteinFilter;
import com.compomics.util.experiment.identification.filtering.PsmFilter;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.filtering.FilterDialog;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.NimbusCheckBoxRenderer;

public class FiltersDialog
extends JDialog {
    private final PeptideShakerGUI peptideShakerGUI;
    private HashMap<String, ProteinFilter> proteinStarFilters;
    private HashMap<String, ProteinFilter> proteinHideFilters;
    private HashMap<String, PeptideFilter> peptideStarFilters;
    private HashMap<String, PeptideFilter> peptideHideFilters;
    private HashMap<String, PsmFilter> psmStarFilters;
    private HashMap<String, PsmFilter> psmHideFilters;
    private ArrayList<String> allModifications;
    private JButton addHiddenPeptides;
    private JButton addHiddenProtein;
    private JButton addHiddenPsm;
    private JButton addStarredPeptides;
    private JButton addStarredProtein;
    private JButton addStarredPsm;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JButton clearHiddenPeptides;
    private JButton clearHiddenProtein;
    private JButton clearHiddenPsm;
    private JButton clearStarredPeptides;
    private JButton clearStarredProtein;
    private JButton clearStarredPsm;
    private JButton deleteHiddenPeptides;
    private JButton deleteHiddenProtein;
    private JButton deleteHiddenPsm;
    private JButton deleteStarredPeptides;
    private JButton deleteStarredProtein;
    private JButton deleteStarredPsm;
    private JButton editHiddenPeptides;
    private JButton editHiddenProtein;
    private JButton editHiddenPsm;
    private JButton editStarredPeptides;
    private JButton editStarredProtein;
    private JButton editStarredPsm;
    private JPanel hiddenPeptidesPanel;
    private JScrollPane hiddenPeptidesScrollPane;
    private JTable hiddenPeptidesTable;
    private JPanel hiddenProteinsPanel;
    private JScrollPane hiddenProteinsScrollPane;
    private JTable hiddenProteinsTable;
    private JTable hiddenPsmTable;
    private JPanel hiddenPsmsPanel;
    private JScrollPane hiddenPsmsScrollPane;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JSplitPane peptidesSplitPane;
    private JSplitPane proteinsSplitPane;
    private JSplitPane psmsSplitPane;
    private JPanel starredPeptidesPanel;
    private JScrollPane starredPeptidesScrollPane;
    private JTable starredPeptidesTable;
    private JPanel starredProteinsPanel;
    private JScrollPane starredProteinsScrollPane;
    private JTable starredProteinsTable;
    private JTable starredPsmTable;
    private JPanel starredPsmsPanel;
    private JScrollPane starredPsmsScrollPane;
    private JTabbedPane tabbedPane;

    public FiltersDialog(PeptideShakerGUI peptideShakerGUI) {
        super((Frame)peptideShakerGUI, true);
        this.initComponents();
        this.setTableProperties();
        this.peptideShakerGUI = peptideShakerGUI;
        this.allModifications = peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters().getAllModifications();
        this.setLocationRelativeTo(peptideShakerGUI);
        this.updateMaps();
        this.fillTables();
    }

    private void setTableProperties() {
        this.starredProteinsTable.getTableHeader().setReorderingAllowed(false);
        this.hiddenProteinsTable.getTableHeader().setReorderingAllowed(false);
        this.starredPeptidesTable.getTableHeader().setReorderingAllowed(false);
        this.hiddenPeptidesTable.getTableHeader().setReorderingAllowed(false);
        this.starredPsmTable.getTableHeader().setReorderingAllowed(false);
        this.hiddenPsmTable.getTableHeader().setReorderingAllowed(false);
        this.starredProteinsTable.setAutoCreateRowSorter(true);
        this.hiddenProteinsTable.setAutoCreateRowSorter(true);
        this.starredPeptidesTable.setAutoCreateRowSorter(true);
        this.hiddenPeptidesTable.setAutoCreateRowSorter(true);
        this.starredPsmTable.setAutoCreateRowSorter(true);
        this.hiddenPsmTable.setAutoCreateRowSorter(true);
        this.starredProteinsTable.getColumn("").setMaxWidth(50);
        this.hiddenProteinsTable.getColumn("").setMaxWidth(50);
        this.starredPeptidesTable.getColumn("").setMaxWidth(50);
        this.hiddenPeptidesTable.getColumn("").setMaxWidth(50);
        this.starredPsmTable.getColumn("").setMaxWidth(50);
        this.hiddenPsmTable.getColumn("").setMaxWidth(50);
        this.starredProteinsTable.getColumn("").setMinWidth(50);
        this.hiddenProteinsTable.getColumn("").setMinWidth(50);
        this.starredPeptidesTable.getColumn("").setMinWidth(50);
        this.hiddenPeptidesTable.getColumn("").setMinWidth(50);
        this.starredPsmTable.getColumn("").setMinWidth(50);
        this.hiddenPsmTable.getColumn("").setMinWidth(50);
        this.starredProteinsTable.getColumn(" ").setMaxWidth(30);
        this.hiddenProteinsTable.getColumn(" ").setMaxWidth(30);
        this.starredPeptidesTable.getColumn(" ").setMaxWidth(30);
        this.hiddenPeptidesTable.getColumn(" ").setMaxWidth(30);
        this.starredPsmTable.getColumn(" ").setMaxWidth(30);
        this.hiddenPsmTable.getColumn(" ").setMaxWidth(30);
        this.starredProteinsTable.getColumn(" ").setMinWidth(30);
        this.hiddenProteinsTable.getColumn(" ").setMinWidth(30);
        this.starredPeptidesTable.getColumn(" ").setMinWidth(30);
        this.hiddenPeptidesTable.getColumn(" ").setMinWidth(30);
        this.starredPsmTable.getColumn(" ").setMinWidth(30);
        this.hiddenPsmTable.getColumn(" ").setMinWidth(30);
        this.starredProteinsScrollPane.getViewport().setOpaque(false);
        this.hiddenProteinsScrollPane.getViewport().setOpaque(false);
        this.starredPeptidesScrollPane.getViewport().setOpaque(false);
        this.hiddenPeptidesScrollPane.getViewport().setOpaque(false);
        this.starredPsmsScrollPane.getViewport().setOpaque(false);
        this.hiddenPsmsScrollPane.getViewport().setOpaque(false);
        this.starredProteinsTable.getColumn(" ").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        this.hiddenProteinsTable.getColumn(" ").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        this.starredPeptidesTable.getColumn(" ").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        this.hiddenPeptidesTable.getColumn(" ").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        this.starredPsmTable.getColumn(" ").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        this.hiddenPsmTable.getColumn(" ").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
    }

    private void updateMaps() {
        this.proteinStarFilters = new HashMap();
        this.proteinHideFilters = new HashMap();
        this.peptideStarFilters = new HashMap();
        this.peptideHideFilters = new HashMap();
        this.psmStarFilters = new HashMap();
        this.psmHideFilters = new HashMap();
        this.proteinStarFilters.putAll(this.peptideShakerGUI.getFilterParameters().getProteinStarFilters());
        this.proteinHideFilters.putAll(this.peptideShakerGUI.getFilterParameters().getProteinHideFilters());
        this.peptideStarFilters.putAll(this.peptideShakerGUI.getFilterParameters().getPeptideStarFilters());
        this.peptideHideFilters.putAll(this.peptideShakerGUI.getFilterParameters().getPeptideHideFilters());
        this.psmStarFilters.putAll(this.peptideShakerGUI.getFilterParameters().getPsmStarFilters());
        this.psmHideFilters.putAll(this.peptideShakerGUI.getFilterParameters().getPsmHideFilters());
    }

    private void emptyTables() {
        while (this.hiddenProteinsTable.getRowCount() > 0) {
            ((DefaultTableModel)this.hiddenProteinsTable.getModel()).removeRow(0);
        }
        while (this.starredProteinsTable.getRowCount() > 0) {
            ((DefaultTableModel)this.starredProteinsTable.getModel()).removeRow(0);
        }
        while (this.hiddenPeptidesTable.getRowCount() > 0) {
            ((DefaultTableModel)this.hiddenPeptidesTable.getModel()).removeRow(0);
        }
        while (this.starredPeptidesTable.getRowCount() > 0) {
            ((DefaultTableModel)this.starredPeptidesTable.getModel()).removeRow(0);
        }
        while (this.hiddenPsmTable.getRowCount() > 0) {
            ((DefaultTableModel)this.hiddenPsmTable.getModel()).removeRow(0);
        }
        while (this.starredPsmTable.getRowCount() > 0) {
            ((DefaultTableModel)this.starredPsmTable.getModel()).removeRow(0);
        }
    }

    private void fillTables() {
        for (MatchFilter matchFilter : this.proteinStarFilters.values()) {
            ((DefaultTableModel)this.starredProteinsTable.getModel()).addRow(new Object[]{this.starredProteinsTable.getRowCount() + 1, matchFilter.isActive(), matchFilter.getName(), matchFilter.getDescription()});
        }
        for (MatchFilter matchFilter : this.peptideStarFilters.values()) {
            ((DefaultTableModel)this.starredPeptidesTable.getModel()).addRow(new Object[]{this.starredPeptidesTable.getRowCount() + 1, matchFilter.isActive(), matchFilter.getName(), matchFilter.getDescription()});
        }
        for (MatchFilter matchFilter : this.psmStarFilters.values()) {
            ((DefaultTableModel)this.starredPsmTable.getModel()).addRow(new Object[]{this.starredPsmTable.getRowCount() + 1, matchFilter.isActive(), matchFilter.getName(), matchFilter.getDescription()});
        }
        for (MatchFilter matchFilter : this.proteinHideFilters.values()) {
            ((DefaultTableModel)this.hiddenProteinsTable.getModel()).addRow(new Object[]{this.hiddenProteinsTable.getRowCount() + 1, matchFilter.isActive(), matchFilter.getName(), matchFilter.getDescription()});
        }
        for (MatchFilter matchFilter : this.peptideHideFilters.values()) {
            ((DefaultTableModel)this.hiddenPeptidesTable.getModel()).addRow(new Object[]{this.hiddenPeptidesTable.getRowCount() + 1, matchFilter.isActive(), matchFilter.getName(), matchFilter.getDescription()});
        }
        for (MatchFilter matchFilter : this.psmHideFilters.values()) {
            ((DefaultTableModel)this.hiddenPsmTable.getModel()).addRow(new Object[]{this.hiddenPsmTable.getRowCount() + 1, matchFilter.isActive(), matchFilter.getName(), matchFilter.getDescription()});
        }
        this.setVisible(true);
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.proteinsSplitPane = new JSplitPane();
        this.starredProteinsPanel = new JPanel();
        this.starredProteinsScrollPane = new JScrollPane();
        this.starredProteinsTable = new JTable();
        this.addStarredProtein = new JButton();
        this.editStarredProtein = new JButton();
        this.clearStarredProtein = new JButton();
        this.deleteStarredProtein = new JButton();
        this.hiddenProteinsPanel = new JPanel();
        this.hiddenProteinsScrollPane = new JScrollPane();
        this.hiddenProteinsTable = new JTable();
        this.addHiddenProtein = new JButton();
        this.editHiddenProtein = new JButton();
        this.clearHiddenProtein = new JButton();
        this.deleteHiddenProtein = new JButton();
        this.peptidesSplitPane = new JSplitPane();
        this.starredPeptidesPanel = new JPanel();
        this.starredPeptidesScrollPane = new JScrollPane();
        this.starredPeptidesTable = new JTable();
        this.addStarredPeptides = new JButton();
        this.editStarredPeptides = new JButton();
        this.clearStarredPeptides = new JButton();
        this.deleteStarredPeptides = new JButton();
        this.hiddenPeptidesPanel = new JPanel();
        this.hiddenPeptidesScrollPane = new JScrollPane();
        this.hiddenPeptidesTable = new JTable();
        this.addHiddenPeptides = new JButton();
        this.editHiddenPeptides = new JButton();
        this.clearHiddenPeptides = new JButton();
        this.deleteHiddenPeptides = new JButton();
        this.psmsSplitPane = new JSplitPane();
        this.starredPsmsPanel = new JPanel();
        this.starredPsmsScrollPane = new JScrollPane();
        this.starredPsmTable = new JTable();
        this.addStarredPsm = new JButton();
        this.editStarredPsm = new JButton();
        this.clearStarredPsm = new JButton();
        this.deleteStarredPsm = new JButton();
        this.hiddenPsmsPanel = new JPanel();
        this.hiddenPsmsScrollPane = new JScrollPane();
        this.hiddenPsmTable = new JTable();
        this.addHiddenPsm = new JButton();
        this.editHiddenPsm = new JButton();
        this.clearHiddenPsm = new JButton();
        this.deleteHiddenPsm = new JButton();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.openDialogHelpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Filter Selection");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.tabbedPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                FiltersDialog.this.tabbedPaneComponentResized(evt);
            }
        });
        this.proteinsSplitPane.setBorder(null);
        this.proteinsSplitPane.setDividerLocation(200);
        this.proteinsSplitPane.setDividerSize(-1);
        this.proteinsSplitPane.setOrientation(0);
        this.proteinsSplitPane.setResizeWeight(0.5);
        this.proteinsSplitPane.setOpaque(false);
        this.starredProteinsPanel.setBorder(BorderFactory.createTitledBorder("Starred Proteins"));
        this.starredProteinsPanel.setOpaque(false);
        this.starredProteinsPanel.setPreferredSize(new Dimension(613, 195));
        this.starredProteinsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"", " ", "Name", "Description"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Boolean.class, String.class, String.class};
                this.canEdit = new boolean[]{false, true, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.starredProteinsTable.setSelectionMode(0);
        this.starredProteinsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                FiltersDialog.this.starredProteinsTableMouseReleased(evt);
            }
        });
        this.starredProteinsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FiltersDialog.this.starredProteinsTableKeyReleased(evt);
            }
        });
        this.starredProteinsScrollPane.setViewportView(this.starredProteinsTable);
        this.addStarredProtein.setText("Add");
        this.addStarredProtein.setToolTipText("Add a starred proteins filter");
        this.addStarredProtein.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.addStarredProteinActionPerformed(evt);
            }
        });
        this.editStarredProtein.setText("Edit");
        this.editStarredProtein.setToolTipText("Edit selected filter");
        this.editStarredProtein.setEnabled(false);
        this.editStarredProtein.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.editStarredProteinActionPerformed(evt);
            }
        });
        this.clearStarredProtein.setText("Clear");
        this.clearStarredProtein.setToolTipText("Remove all starred proteins filters");
        this.clearStarredProtein.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.clearStarredProteinActionPerformed(evt);
            }
        });
        this.deleteStarredProtein.setText("Delete");
        this.deleteStarredProtein.setToolTipText("Delete selected filter");
        this.deleteStarredProtein.setEnabled(false);
        this.deleteStarredProtein.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.deleteStarredProteinActionPerformed(evt);
            }
        });
        GroupLayout starredProteinsPanelLayout = new GroupLayout(this.starredProteinsPanel);
        this.starredProteinsPanel.setLayout(starredProteinsPanelLayout);
        starredProteinsPanelLayout.setHorizontalGroup(starredProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(starredProteinsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.starredProteinsScrollPane, -1, 561, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(starredProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.editStarredProtein, GroupLayout.Alignment.TRAILING, -2, 57, -2).addComponent(this.addStarredProtein, GroupLayout.Alignment.TRAILING, -2, 57, -2).addComponent(this.clearStarredProtein, -1, -1, Short.MAX_VALUE).addComponent(this.deleteStarredProtein, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        starredProteinsPanelLayout.linkSize(0, this.addStarredProtein, this.clearStarredProtein, this.deleteStarredProtein, this.editStarredProtein);
        starredProteinsPanelLayout.setVerticalGroup(starredProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(starredProteinsPanelLayout.createSequentialGroup().addContainerGap().addGroup(starredProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.starredProteinsScrollPane, -2, 0, Short.MAX_VALUE).addGroup(starredProteinsPanelLayout.createSequentialGroup().addComponent(this.addStarredProtein).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editStarredProtein).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteStarredProtein).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearStarredProtein).addGap(0, 45, Short.MAX_VALUE))).addContainerGap()));
        this.proteinsSplitPane.setLeftComponent(this.starredProteinsPanel);
        this.hiddenProteinsPanel.setBorder(BorderFactory.createTitledBorder("Hidden Proteins"));
        this.hiddenProteinsPanel.setOpaque(false);
        this.hiddenProteinsPanel.setPreferredSize(new Dimension(613, 195));
        this.hiddenProteinsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"", " ", "Name", "Description"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Boolean.class, String.class, String.class};
                this.canEdit = new boolean[]{false, true, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.hiddenProteinsTable.setSelectionMode(0);
        this.hiddenProteinsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                FiltersDialog.this.hiddenProteinsTableMouseReleased(evt);
            }
        });
        this.hiddenProteinsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FiltersDialog.this.hiddenProteinsTableKeyReleased(evt);
            }
        });
        this.hiddenProteinsScrollPane.setViewportView(this.hiddenProteinsTable);
        this.addHiddenProtein.setText("Add");
        this.addHiddenProtein.setToolTipText("Add a hidden proteins filter");
        this.addHiddenProtein.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.addHiddenProteinActionPerformed(evt);
            }
        });
        this.editHiddenProtein.setText("Edit");
        this.editHiddenProtein.setToolTipText("Edit selected filter");
        this.editHiddenProtein.setEnabled(false);
        this.editHiddenProtein.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.editHiddenProteinActionPerformed(evt);
            }
        });
        this.clearHiddenProtein.setText("Clear");
        this.clearHiddenProtein.setToolTipText("Remove all hidden proteins filters");
        this.clearHiddenProtein.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.clearHiddenProteinActionPerformed(evt);
            }
        });
        this.deleteHiddenProtein.setText("Delete");
        this.deleteHiddenProtein.setToolTipText("Delete selected filter");
        this.deleteHiddenProtein.setEnabled(false);
        this.deleteHiddenProtein.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.deleteHiddenProteinActionPerformed(evt);
            }
        });
        GroupLayout hiddenProteinsPanelLayout = new GroupLayout(this.hiddenProteinsPanel);
        this.hiddenProteinsPanel.setLayout(hiddenProteinsPanelLayout);
        hiddenProteinsPanelLayout.setHorizontalGroup(hiddenProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(hiddenProteinsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.hiddenProteinsScrollPane, -1, 561, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(hiddenProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editHiddenProtein, GroupLayout.Alignment.TRAILING, -2, 57, -2).addComponent(this.addHiddenProtein, GroupLayout.Alignment.TRAILING, -2, 57, -2).addComponent(this.deleteHiddenProtein, GroupLayout.Alignment.TRAILING).addComponent(this.clearHiddenProtein, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        hiddenProteinsPanelLayout.linkSize(0, this.addHiddenProtein, this.clearHiddenProtein, this.deleteHiddenProtein, this.editHiddenProtein);
        hiddenProteinsPanelLayout.setVerticalGroup(hiddenProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(hiddenProteinsPanelLayout.createSequentialGroup().addContainerGap().addGroup(hiddenProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hiddenProteinsScrollPane, -2, 0, Short.MAX_VALUE).addGroup(hiddenProteinsPanelLayout.createSequentialGroup().addComponent(this.addHiddenProtein).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editHiddenProtein).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteHiddenProtein).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearHiddenProtein).addGap(0, 48, Short.MAX_VALUE))).addContainerGap()));
        this.proteinsSplitPane.setRightComponent(this.hiddenProteinsPanel);
        this.tabbedPane.addTab("Proteins", this.proteinsSplitPane);
        this.peptidesSplitPane.setBorder(null);
        this.peptidesSplitPane.setDividerLocation(200);
        this.peptidesSplitPane.setDividerSize(-1);
        this.peptidesSplitPane.setOrientation(0);
        this.peptidesSplitPane.setResizeWeight(0.5);
        this.peptidesSplitPane.setOpaque(false);
        this.starredPeptidesPanel.setBorder(BorderFactory.createTitledBorder("Starred Peptides"));
        this.starredPeptidesPanel.setOpaque(false);
        this.starredPeptidesPanel.setPreferredSize(new Dimension(613, 195));
        this.starredPeptidesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"", " ", "Name", "Description"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Boolean.class, String.class, String.class};
                this.canEdit = new boolean[]{false, true, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.starredPeptidesTable.setSelectionMode(0);
        this.starredPeptidesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                FiltersDialog.this.starredPeptidesTableMouseReleased(evt);
            }
        });
        this.starredPeptidesTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FiltersDialog.this.starredPeptidesTableKeyReleased(evt);
            }
        });
        this.starredPeptidesScrollPane.setViewportView(this.starredPeptidesTable);
        this.addStarredPeptides.setText("Add");
        this.addStarredPeptides.setToolTipText("Add a starred peptides filter");
        this.addStarredPeptides.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.addStarredPeptidesActionPerformed(evt);
            }
        });
        this.editStarredPeptides.setText("Edit");
        this.editStarredPeptides.setToolTipText("Edit selected filter");
        this.editStarredPeptides.setEnabled(false);
        this.editStarredPeptides.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.editStarredPeptidesActionPerformed(evt);
            }
        });
        this.clearStarredPeptides.setText("Clear");
        this.clearStarredPeptides.setToolTipText("Remove all starred peptides filters");
        this.clearStarredPeptides.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.clearStarredPeptidesActionPerformed(evt);
            }
        });
        this.deleteStarredPeptides.setText("Delete");
        this.deleteStarredPeptides.setToolTipText("Delete selected filter");
        this.deleteStarredPeptides.setEnabled(false);
        this.deleteStarredPeptides.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.deleteStarredPeptidesActionPerformed(evt);
            }
        });
        GroupLayout starredPeptidesPanelLayout = new GroupLayout(this.starredPeptidesPanel);
        this.starredPeptidesPanel.setLayout(starredPeptidesPanelLayout);
        starredPeptidesPanelLayout.setHorizontalGroup(starredPeptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(starredPeptidesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.starredPeptidesScrollPane, -1, 561, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(starredPeptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editStarredPeptides, GroupLayout.Alignment.TRAILING, -2, 57, -2).addComponent(this.addStarredPeptides, GroupLayout.Alignment.TRAILING, -2, 57, -2).addGroup(GroupLayout.Alignment.TRAILING, starredPeptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.deleteStarredPeptides, GroupLayout.Alignment.TRAILING).addComponent(this.clearStarredPeptides))).addContainerGap()));
        starredPeptidesPanelLayout.linkSize(0, this.addStarredPeptides, this.clearStarredPeptides, this.deleteStarredPeptides, this.editStarredPeptides);
        starredPeptidesPanelLayout.setVerticalGroup(starredPeptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(starredPeptidesPanelLayout.createSequentialGroup().addContainerGap().addGroup(starredPeptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(starredPeptidesPanelLayout.createSequentialGroup().addComponent(this.addStarredPeptides).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editStarredPeptides).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteStarredPeptides).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearStarredPeptides).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.starredPeptidesScrollPane, -1, 155, Short.MAX_VALUE)).addContainerGap()));
        this.peptidesSplitPane.setLeftComponent(this.starredPeptidesPanel);
        this.hiddenPeptidesPanel.setBorder(BorderFactory.createTitledBorder("Hidden Peptides"));
        this.hiddenPeptidesPanel.setOpaque(false);
        this.hiddenPeptidesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"", " ", "Name", "Description"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Boolean.class, String.class, String.class};
                this.canEdit = new boolean[]{false, true, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.hiddenPeptidesTable.setSelectionMode(0);
        this.hiddenPeptidesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                FiltersDialog.this.hiddenPeptidesTableMouseReleased(evt);
            }
        });
        this.hiddenPeptidesTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FiltersDialog.this.hiddenPeptidesTableKeyReleased(evt);
            }
        });
        this.hiddenPeptidesScrollPane.setViewportView(this.hiddenPeptidesTable);
        this.addHiddenPeptides.setText("Add");
        this.addHiddenPeptides.setToolTipText("Add a hidden peptides filter");
        this.addHiddenPeptides.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.addHiddenPeptidesActionPerformed(evt);
            }
        });
        this.editHiddenPeptides.setText("Edit");
        this.editHiddenPeptides.setToolTipText("Edit selected filter");
        this.editHiddenPeptides.setEnabled(false);
        this.editHiddenPeptides.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.editHiddenPeptidesActionPerformed(evt);
            }
        });
        this.clearHiddenPeptides.setText("Clear");
        this.clearHiddenPeptides.setToolTipText("Remove all hidden peptides filters");
        this.clearHiddenPeptides.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.clearHiddenPeptidesActionPerformed(evt);
            }
        });
        this.deleteHiddenPeptides.setText("Delete");
        this.deleteHiddenPeptides.setToolTipText("Delete selected filter");
        this.deleteHiddenPeptides.setEnabled(false);
        this.deleteHiddenPeptides.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.deleteHiddenPeptidesActionPerformed(evt);
            }
        });
        GroupLayout hiddenPeptidesPanelLayout = new GroupLayout(this.hiddenPeptidesPanel);
        this.hiddenPeptidesPanel.setLayout(hiddenPeptidesPanelLayout);
        hiddenPeptidesPanelLayout.setHorizontalGroup(hiddenPeptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(hiddenPeptidesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.hiddenPeptidesScrollPane, -1, 561, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(hiddenPeptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, hiddenPeptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.editHiddenPeptides, GroupLayout.Alignment.TRAILING, -2, 57, -2).addComponent(this.addHiddenPeptides, GroupLayout.Alignment.TRAILING, -2, 57, -2).addComponent(this.clearHiddenPeptides, -1, -1, Short.MAX_VALUE)).addComponent(this.deleteHiddenPeptides, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        hiddenPeptidesPanelLayout.linkSize(0, this.addHiddenPeptides, this.clearHiddenPeptides, this.deleteHiddenPeptides, this.editHiddenPeptides);
        hiddenPeptidesPanelLayout.setVerticalGroup(hiddenPeptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(hiddenPeptidesPanelLayout.createSequentialGroup().addContainerGap().addGroup(hiddenPeptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(hiddenPeptidesPanelLayout.createSequentialGroup().addComponent(this.addHiddenPeptides).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editHiddenPeptides).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteHiddenPeptides).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearHiddenPeptides).addGap(0, 48, Short.MAX_VALUE)).addComponent(this.hiddenPeptidesScrollPane, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        this.peptidesSplitPane.setRightComponent(this.hiddenPeptidesPanel);
        this.tabbedPane.addTab("Peptides", this.peptidesSplitPane);
        this.psmsSplitPane.setBorder(null);
        this.psmsSplitPane.setDividerLocation(200);
        this.psmsSplitPane.setDividerSize(-1);
        this.psmsSplitPane.setOrientation(0);
        this.psmsSplitPane.setResizeWeight(0.5);
        this.psmsSplitPane.setOpaque(false);
        this.starredPsmsPanel.setBorder(BorderFactory.createTitledBorder("Starred PSMs"));
        this.starredPsmsPanel.setOpaque(false);
        this.starredPsmsPanel.setPreferredSize(new Dimension(613, 195));
        this.starredPsmTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"", " ", "Name", "Description"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Boolean.class, String.class, String.class};
                this.canEdit = new boolean[]{false, true, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.starredPsmTable.setSelectionMode(0);
        this.starredPsmTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                FiltersDialog.this.starredPsmTableMouseReleased(evt);
            }
        });
        this.starredPsmTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FiltersDialog.this.starredPsmTableKeyReleased(evt);
            }
        });
        this.starredPsmsScrollPane.setViewportView(this.starredPsmTable);
        this.addStarredPsm.setText("Add");
        this.addStarredPsm.setToolTipText("Add a starred PSMs filter");
        this.addStarredPsm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.addStarredPsmActionPerformed(evt);
            }
        });
        this.editStarredPsm.setText("Edit");
        this.editStarredPsm.setToolTipText("Edit selected filter");
        this.editStarredPsm.setEnabled(false);
        this.editStarredPsm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.editStarredPsmActionPerformed(evt);
            }
        });
        this.clearStarredPsm.setText("Clear");
        this.clearStarredPsm.setToolTipText("Remove all starred PSMs filters");
        this.clearStarredPsm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.clearStarredPsmActionPerformed(evt);
            }
        });
        this.deleteStarredPsm.setText("Delete");
        this.deleteStarredPsm.setToolTipText("Delete selected filter");
        this.deleteStarredPsm.setEnabled(false);
        this.deleteStarredPsm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.deleteStarredPsmActionPerformed(evt);
            }
        });
        GroupLayout starredPsmsPanelLayout = new GroupLayout(this.starredPsmsPanel);
        this.starredPsmsPanel.setLayout(starredPsmsPanelLayout);
        starredPsmsPanelLayout.setHorizontalGroup(starredPsmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(starredPsmsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.starredPsmsScrollPane, -1, 561, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(starredPsmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, starredPsmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.editStarredPsm, GroupLayout.Alignment.TRAILING, -2, 57, -2).addComponent(this.addStarredPsm, GroupLayout.Alignment.TRAILING, -2, 57, -2).addComponent(this.clearStarredPsm, -1, -1, Short.MAX_VALUE)).addComponent(this.deleteStarredPsm, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        starredPsmsPanelLayout.linkSize(0, this.addStarredPsm, this.clearStarredPsm, this.deleteStarredPsm, this.editStarredPsm);
        starredPsmsPanelLayout.setVerticalGroup(starredPsmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(starredPsmsPanelLayout.createSequentialGroup().addContainerGap().addGroup(starredPsmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.starredPsmsScrollPane, -1, 155, Short.MAX_VALUE).addGroup(starredPsmsPanelLayout.createSequentialGroup().addComponent(this.addStarredPsm).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editStarredPsm).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteStarredPsm).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearStarredPsm).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.psmsSplitPane.setLeftComponent(this.starredPsmsPanel);
        this.hiddenPsmsPanel.setBorder(BorderFactory.createTitledBorder("Hidden PSMs"));
        this.hiddenPsmsPanel.setOpaque(false);
        this.hiddenPsmTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"", " ", "Name", "Description"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Boolean.class, String.class, String.class};
                this.canEdit = new boolean[]{false, true, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.hiddenPsmTable.setSelectionMode(0);
        this.hiddenPsmTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                FiltersDialog.this.hiddenPsmTableMouseReleased(evt);
            }
        });
        this.hiddenPsmTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FiltersDialog.this.hiddenPsmTableKeyReleased(evt);
            }
        });
        this.hiddenPsmsScrollPane.setViewportView(this.hiddenPsmTable);
        this.addHiddenPsm.setText("Add");
        this.addHiddenPsm.setToolTipText("Add a hidden PSMs filter");
        this.addHiddenPsm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.addHiddenPsmActionPerformed(evt);
            }
        });
        this.editHiddenPsm.setText("Edit");
        this.editHiddenPsm.setToolTipText("Edit selected filter");
        this.editHiddenPsm.setEnabled(false);
        this.editHiddenPsm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.editHiddenPsmActionPerformed(evt);
            }
        });
        this.clearHiddenPsm.setText("Clear");
        this.clearHiddenPsm.setToolTipText("Remove all hidden PSMs filters");
        this.clearHiddenPsm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.clearHiddenPsmActionPerformed(evt);
            }
        });
        this.deleteHiddenPsm.setText("Delete");
        this.deleteHiddenPsm.setToolTipText("Delete selected filter");
        this.deleteHiddenPsm.setEnabled(false);
        this.deleteHiddenPsm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.deleteHiddenPsmActionPerformed(evt);
            }
        });
        GroupLayout hiddenPsmsPanelLayout = new GroupLayout(this.hiddenPsmsPanel);
        this.hiddenPsmsPanel.setLayout(hiddenPsmsPanelLayout);
        hiddenPsmsPanelLayout.setHorizontalGroup(hiddenPsmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(hiddenPsmsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.hiddenPsmsScrollPane, -1, 561, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(hiddenPsmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, hiddenPsmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.editHiddenPsm, GroupLayout.Alignment.TRAILING, -2, 57, -2).addComponent(this.addHiddenPsm, GroupLayout.Alignment.TRAILING, -2, 57, -2).addComponent(this.clearHiddenPsm, -1, -1, Short.MAX_VALUE)).addComponent(this.deleteHiddenPsm, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        hiddenPsmsPanelLayout.linkSize(0, this.addHiddenPsm, this.clearHiddenPsm, this.deleteHiddenPsm, this.editHiddenPsm);
        hiddenPsmsPanelLayout.setVerticalGroup(hiddenPsmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(hiddenPsmsPanelLayout.createSequentialGroup().addContainerGap().addGroup(hiddenPsmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(hiddenPsmsPanelLayout.createSequentialGroup().addComponent(this.addHiddenPsm).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editHiddenPsm).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteHiddenPsm).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearHiddenPsm).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.hiddenPsmsScrollPane, -1, 158, Short.MAX_VALUE)).addContainerGap()));
        this.psmsSplitPane.setRightComponent(this.hiddenPsmsPanel);
        this.tabbedPane.addTab("PSMs", this.psmsSplitPane);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.setPreferredSize(new Dimension(65, 23));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                FiltersDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                FiltersDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.openDialogHelpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -1, 430, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.okButton, -2, -1, -2).addComponent(this.cancelButton)).addContainerGap()));
        backgroundPanelLayout.linkSize(1, this.cancelButton, this.okButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.peptideShakerGUI.getFilterParameters().setProteinStarFilters(this.proteinStarFilters);
        this.peptideShakerGUI.getFilterParameters().setProteinHideFilters(this.proteinHideFilters);
        this.peptideShakerGUI.getFilterParameters().setPeptideStarFilters(this.peptideStarFilters);
        this.peptideShakerGUI.getFilterParameters().setPeptideHideFilters(this.peptideHideFilters);
        this.peptideShakerGUI.getFilterParameters().setPsmStarFilters(this.psmStarFilters);
        this.peptideShakerGUI.getFilterParameters().setPsmHideFilters(this.psmHideFilters);
        this.setVisible(false);
        this.peptideShakerGUI.resetSelectedItems();
        this.peptideShakerGUI.setUpdated(0, false);
        this.peptideShakerGUI.setUpdated(2, false);
        this.peptideShakerGUI.setUpdated(3, false);
        this.peptideShakerGUI.setUpdated(4, false);
        this.peptideShakerGUI.setUpdated(6, false);
        this.peptideShakerGUI.setUpdated(8, false);
        this.peptideShakerGUI.setUpdated(2, false);
        this.peptideShakerGUI.getStarHider().starHide();
        this.peptideShakerGUI.updateTabbedPanes();
        this.dispose();
    }

    private void starredProteinsTableKeyReleased(KeyEvent evt) {
        int column = this.starredProteinsTable.getSelectedColumn();
        int row = this.starredProteinsTable.getSelectedRow();
        if (column == 2) {
            String newName = (String)this.starredProteinsTable.getValueAt(row, column);
            ArrayList<String> others = new ArrayList<String>();
            for (int i = 0; i < this.starredProteinsTable.getRowCount(); ++i) {
                if (i == row) continue;
                others.add((String)this.starredProteinsTable.getValueAt(i, column));
            }
            if (others.contains(newName)) {
                int outcome = 0;
                if (this.peptideShakerGUI.getFilterParameters().filterExists(newName)) {
                    outcome = JOptionPane.showConfirmDialog(this, "Should protein filter " + newName + " be overwritten?", "Selected Name Already Exists", 0, 2);
                }
                if (outcome != 0) {
                    for (ProteinFilter proteinFilter : this.proteinStarFilters.values()) {
                        if (others.contains(proteinFilter.getName())) continue;
                        this.starredProteinsTable.setValueAt(proteinFilter.getName(), row, column);
                    }
                    return;
                }
            }
            Collection<ProteinFilter> values = this.proteinStarFilters.values();
            for (ProteinFilter proteinFilter : values) {
                if (others.contains(proteinFilter.getName())) continue;
                String oldName = proteinFilter.getName();
                proteinFilter.setName(newName);
                this.proteinStarFilters.remove(oldName);
                this.proteinStarFilters.put(newName, proteinFilter);
            }
        }
        if (column == 3) {
            String name = (String)this.starredProteinsTable.getValueAt(row, 2);
            this.proteinStarFilters.get(name).setDescription((String)this.starredProteinsTable.getValueAt(row, column));
        }
        if (this.starredProteinsTable.isEditing()) {
            this.editStarredProtein.setEnabled(false);
            this.deleteStarredProtein.setEnabled(false);
        } else if (this.starredProteinsTable.getSelectedRow() != -1) {
            this.editStarredProtein.setEnabled(true);
            this.deleteStarredProtein.setEnabled(true);
        }
    }

    private void starredProteinsTableMouseReleased(MouseEvent evt) {
        int column = this.starredProteinsTable.getSelectedColumn();
        int row = this.starredProteinsTable.getSelectedRow();
        if (row != -1 && evt.getButton() == 1) {
            String key = (String)this.starredProteinsTable.getValueAt(row, 2);
            MatchFilter matchFilter = (MatchFilter)this.proteinStarFilters.get(key);
            if (evt.getClickCount() == 1 && column == 1) {
                matchFilter.setActive(!matchFilter.isActive());
            }
        }
        if (this.starredProteinsTable.isEditing()) {
            this.editStarredProtein.setEnabled(false);
            this.deleteStarredProtein.setEnabled(false);
        } else if (this.starredProteinsTable.getSelectedRow() != -1) {
            this.editStarredProtein.setEnabled(true);
            this.deleteStarredProtein.setEnabled(true);
        }
    }

    private void starredPeptidesTableMouseReleased(MouseEvent evt) {
        int column = this.starredPeptidesTable.getSelectedColumn();
        int row = this.starredPeptidesTable.getSelectedRow();
        if (row != -1 && evt.getButton() == 1) {
            String key = (String)this.starredPeptidesTable.getValueAt(row, 2);
            MatchFilter matchFilter = (MatchFilter)this.peptideStarFilters.get(key);
            if (evt.getClickCount() == 1) {
                if (column == 1) {
                    matchFilter.setActive(!matchFilter.isActive());
                }
            } else if (evt.getClickCount() != 2 || column != 2) {
                // empty if block
            }
        }
        if (this.starredPeptidesTable.isEditing()) {
            this.editStarredPeptides.setEnabled(false);
            this.deleteStarredPeptides.setEnabled(false);
        } else if (this.starredPeptidesTable.getSelectedRow() != -1) {
            this.editStarredPeptides.setEnabled(true);
            this.deleteStarredPeptides.setEnabled(true);
        }
    }

    private void starredPsmTableMouseReleased(MouseEvent evt) {
        int column = this.starredPsmTable.getSelectedColumn();
        int row = this.starredPsmTable.getSelectedRow();
        if (row != -1 && evt.getButton() == 1) {
            String key = (String)this.starredPsmTable.getValueAt(row, 2);
            MatchFilter matchFilter = (MatchFilter)this.psmStarFilters.get(key);
            if (evt.getClickCount() == 1) {
                if (column == 1) {
                    matchFilter.setActive(!matchFilter.isActive());
                }
            } else if (evt.getClickCount() != 2 || column != 2) {
                // empty if block
            }
        }
        if (this.starredPsmTable.isEditing()) {
            this.editStarredPsm.setEnabled(false);
            this.deleteStarredPsm.setEnabled(false);
        } else if (this.starredPsmTable.getSelectedRow() != -1) {
            this.editStarredPsm.setEnabled(true);
            this.deleteStarredPsm.setEnabled(true);
        }
    }

    private void hiddenProteinsTableMouseReleased(MouseEvent evt) {
        int column = this.hiddenProteinsTable.getSelectedColumn();
        int row = this.hiddenProteinsTable.getSelectedRow();
        if (row != -1 && evt.getButton() == 1) {
            String key = (String)this.hiddenProteinsTable.getValueAt(row, 2);
            MatchFilter matchFilter = (MatchFilter)this.proteinHideFilters.get(key);
            if (evt.getClickCount() == 1) {
                if (column == 1) {
                    matchFilter.setActive(!matchFilter.isActive());
                }
            } else if (evt.getClickCount() != 2 || column != 2) {
                // empty if block
            }
        }
        if (this.hiddenProteinsTable.isEditing()) {
            this.editHiddenProtein.setEnabled(false);
            this.deleteHiddenProtein.setEnabled(false);
        } else if (this.hiddenProteinsTable.getSelectedRow() != -1) {
            this.editHiddenProtein.setEnabled(true);
            this.deleteHiddenProtein.setEnabled(true);
        }
    }

    private void hiddenPeptidesTableMouseReleased(MouseEvent evt) {
        int column = this.hiddenPeptidesTable.getSelectedColumn();
        int row = this.hiddenPeptidesTable.getSelectedRow();
        if (row != -1 && evt.getButton() == 1) {
            String key = (String)this.hiddenPeptidesTable.getValueAt(row, 2);
            MatchFilter matchFilter = (MatchFilter)this.peptideHideFilters.get(key);
            if (evt.getClickCount() == 1) {
                if (column == 1) {
                    matchFilter.setActive(!matchFilter.isActive());
                }
            } else if (evt.getClickCount() != 2 || column != 2) {
                // empty if block
            }
        }
        if (this.hiddenPeptidesTable.isEditing()) {
            this.editHiddenPeptides.setEnabled(false);
            this.deleteHiddenPeptides.setEnabled(false);
        } else if (this.hiddenPeptidesTable.getSelectedRow() != -1) {
            this.editHiddenPeptides.setEnabled(true);
            this.deleteHiddenPeptides.setEnabled(true);
        }
    }

    private void hiddenPsmTableMouseReleased(MouseEvent evt) {
        int column = this.hiddenPsmTable.getSelectedColumn();
        int row = this.hiddenPsmTable.getSelectedRow();
        if (row != -1 && evt.getButton() == 1) {
            String key = (String)this.hiddenPsmTable.getValueAt(row, 2);
            MatchFilter matchFilter = (MatchFilter)this.psmHideFilters.get(key);
            if (evt.getClickCount() == 1) {
                if (column == 1) {
                    matchFilter.setActive(!matchFilter.isActive());
                }
            } else if (evt.getClickCount() != 2 || column != 2) {
                // empty if block
            }
        }
        if (this.hiddenPsmTable.isEditing()) {
            this.editHiddenPsm.setEnabled(false);
            this.deleteHiddenPsm.setEnabled(false);
        } else if (this.hiddenPsmTable.getSelectedRow() != -1) {
            this.editHiddenPsm.setEnabled(true);
            this.deleteHiddenPsm.setEnabled(true);
        }
    }

    private void addStarredPsmActionPerformed(ActionEvent evt) {
        PsmFilter newFilter = (PsmFilter)this.createPsmFilter();
        if (newFilter != null) {
            int value;
            String filterName = newFilter.getName();
            if (this.psmStarFilters.containsKey(filterName) && (value = JOptionPane.showConfirmDialog(this, "A filter named " + filterName + " already exists. Overwrite?", "Overwrite Filter?", 0)) == 1) {
                return;
            }
            this.psmStarFilters.put(filterName, newFilter);
            this.updateTables();
        }
    }

    private void addStarredProteinActionPerformed(ActionEvent evt) {
        ProteinFilter newFilter = (ProteinFilter)this.createProteinFilter();
        if (newFilter != null) {
            int value;
            String filterName = newFilter.getName();
            if (this.proteinStarFilters.containsKey(filterName) && (value = JOptionPane.showConfirmDialog(this, "A filter named " + filterName + " already exists. Overwrite?", "Overwrite Filter?", 0)) == 1) {
                return;
            }
            this.proteinStarFilters.put(filterName, newFilter);
            this.updateTables();
        }
    }

    private void addHiddenProteinActionPerformed(ActionEvent evt) {
        ProteinFilter newFilter = (ProteinFilter)this.createProteinFilter();
        if (newFilter != null) {
            int value;
            String filterName = newFilter.getName();
            if (this.proteinHideFilters.containsKey(filterName) && (value = JOptionPane.showConfirmDialog(this, "A filter named " + filterName + " already exists. Overwrite?", "Overwrite Filter?", 0)) == 1) {
                return;
            }
            this.proteinHideFilters.put(filterName, newFilter);
            this.updateTables();
        }
    }

    private void addStarredPeptidesActionPerformed(ActionEvent evt) {
        PeptideFilter newFilter = (PeptideFilter)this.createPeptideFilter();
        if (newFilter != null) {
            int value;
            String filterName = newFilter.getName();
            if (this.peptideStarFilters.containsKey(filterName) && (value = JOptionPane.showConfirmDialog(this, "A filter named " + filterName + " already exists. Overwrite?", "Overwrite Filter?", 0)) == 1) {
                return;
            }
            this.peptideStarFilters.put(filterName, newFilter);
            this.updateTables();
        }
    }

    private void addHiddenPeptidesActionPerformed(ActionEvent evt) {
        PeptideFilter newFilter = (PeptideFilter)this.createPeptideFilter();
        if (newFilter != null) {
            int value;
            String filterName = newFilter.getName();
            if (this.peptideHideFilters.containsKey(filterName) && (value = JOptionPane.showConfirmDialog(this, "A filter named " + filterName + " already exists. Overwrite?", "Overwrite Filter?", 0)) == 1) {
                return;
            }
            this.peptideHideFilters.put(filterName, newFilter);
            this.updateTables();
        }
    }

    private void addHiddenPsmActionPerformed(ActionEvent evt) {
        PsmFilter newFilter = (PsmFilter)this.createPsmFilter();
        if (newFilter != null) {
            int value;
            String filterName = newFilter.getName();
            if (this.psmHideFilters.containsKey(filterName) && (value = JOptionPane.showConfirmDialog(this, "A filter named " + filterName + " already exists. Overwrite?", "Overwrite Filter?", 0)) == 1) {
                return;
            }
            this.psmHideFilters.put(filterName, newFilter);
            this.updateTables();
        }
    }

    private void clearStarredProteinActionPerformed(ActionEvent evt) {
        this.proteinStarFilters.clear();
        this.updateTables();
        this.editStarredProtein.setEnabled(false);
        this.deleteStarredProtein.setEnabled(false);
    }

    private void clearHiddenProteinActionPerformed(ActionEvent evt) {
        this.proteinHideFilters.clear();
        this.updateTables();
        this.editHiddenProtein.setEnabled(false);
        this.deleteHiddenProtein.setEnabled(false);
    }

    private void clearStarredPeptidesActionPerformed(ActionEvent evt) {
        this.peptideStarFilters.clear();
        this.updateTables();
        this.editStarredPeptides.setEnabled(false);
        this.deleteStarredPeptides.setEnabled(false);
    }

    private void clearHiddenPeptidesActionPerformed(ActionEvent evt) {
        this.peptideHideFilters.clear();
        this.updateTables();
        this.editHiddenPeptides.setEnabled(false);
        this.deleteHiddenPeptides.setEnabled(false);
    }

    private void clearStarredPsmActionPerformed(ActionEvent evt) {
        this.psmStarFilters.clear();
        this.updateTables();
        this.editStarredPsm.setEnabled(false);
        this.deleteStarredPsm.setEnabled(false);
    }

    private void clearHiddenPsmActionPerformed(ActionEvent evt) {
        this.psmHideFilters.clear();
        this.updateTables();
        this.editHiddenPsm.setEnabled(false);
        this.deleteHiddenPsm.setEnabled(false);
    }

    private void editStarredProteinActionPerformed(ActionEvent evt) {
        int row = this.starredProteinsTable.getSelectedRow();
        if (row >= 0) {
            String selectedFilterName = (String)this.starredProteinsTable.getValueAt(row, 2);
            ProteinFilter proteinFilter = this.proteinStarFilters.get(selectedFilterName);
            this.editFilter((Filter)proteinFilter);
            this.updateTables();
        }
    }

    private void editHiddenProteinActionPerformed(ActionEvent evt) {
        int row = this.hiddenProteinsTable.getSelectedRow();
        if (row >= 0) {
            String selectedFilterName = (String)this.hiddenProteinsTable.getValueAt(row, 2);
            ProteinFilter proteinFilter = this.proteinHideFilters.get(selectedFilterName);
            this.editFilter((Filter)proteinFilter);
            this.updateTables();
        }
    }

    private void editStarredPeptidesActionPerformed(ActionEvent evt) {
        int row = this.starredPeptidesTable.getSelectedRow();
        if (row >= 0) {
            String selectedFilterName = (String)this.starredPeptidesTable.getValueAt(row, 2);
            PeptideFilter peptideFilter = this.peptideStarFilters.get(selectedFilterName);
            this.editFilter((Filter)peptideFilter);
            this.updateTables();
        }
    }

    private void editHiddenPeptidesActionPerformed(ActionEvent evt) {
        int row = this.hiddenPeptidesTable.getSelectedRow();
        if (row >= 0) {
            String selectedFilterName = (String)this.hiddenPeptidesTable.getValueAt(row, 2);
            PeptideFilter peptideFilter = this.peptideHideFilters.get(selectedFilterName);
            this.editFilter((Filter)peptideFilter);
            this.updateTables();
        }
    }

    private void editStarredPsmActionPerformed(ActionEvent evt) {
        int row = this.starredPsmTable.getSelectedRow();
        if (row >= 0) {
            String selectedFilterName = (String)this.starredPsmTable.getValueAt(row, 2);
            PsmFilter psmFilter = this.psmStarFilters.get(selectedFilterName);
            this.editFilter((Filter)psmFilter);
            this.updateTables();
        }
    }

    private void editHiddenPsmActionPerformed(ActionEvent evt) {
        int row = this.hiddenPsmTable.getSelectedRow();
        if (row >= 0) {
            String selectedFilterName = (String)this.hiddenPsmTable.getValueAt(row, 2);
            PsmFilter psmFilter = this.psmHideFilters.get(selectedFilterName);
            this.editFilter((Filter)psmFilter);
            this.updateTables();
        }
    }

    private void hiddenProteinsTableKeyReleased(KeyEvent evt) {
        int column = this.hiddenProteinsTable.getSelectedColumn();
        int row = this.hiddenProteinsTable.getSelectedRow();
        if (column == 2) {
            String newName = (String)this.hiddenProteinsTable.getValueAt(row, column);
            ArrayList<String> others = new ArrayList<String>();
            for (int i = 0; i < this.hiddenProteinsTable.getRowCount(); ++i) {
                if (i == row) continue;
                others.add((String)this.hiddenProteinsTable.getValueAt(i, column));
            }
            if (others.contains(newName)) {
                int outcome = 0;
                if (this.peptideShakerGUI.getFilterParameters().filterExists(newName)) {
                    outcome = JOptionPane.showConfirmDialog(this, "Should protein filter " + newName + " be overwritten?", "Selected Name Already Exists", 0, 2);
                }
                if (outcome != 0) {
                    for (ProteinFilter proteinFilter : this.proteinHideFilters.values()) {
                        if (others.contains(proteinFilter.getName())) continue;
                        this.hiddenProteinsTable.setValueAt(proteinFilter.getName(), row, column);
                    }
                    return;
                }
            }
            for (ProteinFilter proteinFilter : this.proteinHideFilters.values()) {
                if (others.contains(proteinFilter.getName())) continue;
                String oldName = proteinFilter.getName();
                proteinFilter.setName(newName);
                this.proteinHideFilters.remove(oldName);
                this.proteinHideFilters.put(newName, proteinFilter);
            }
        }
        if (column == 3) {
            String name = (String)this.hiddenProteinsTable.getValueAt(row, 2);
            this.proteinHideFilters.get(name).setDescription((String)this.hiddenProteinsTable.getValueAt(row, column));
        }
        if (this.hiddenProteinsTable.isEditing()) {
            this.editHiddenProtein.setEnabled(false);
            this.deleteHiddenProtein.setEnabled(false);
        } else if (this.hiddenProteinsTable.getSelectedRow() != -1) {
            this.editHiddenProtein.setEnabled(true);
            this.deleteHiddenProtein.setEnabled(true);
        }
    }

    private void starredPeptidesTableKeyReleased(KeyEvent evt) {
        int column = this.starredPeptidesTable.getSelectedColumn();
        int row = this.starredPeptidesTable.getSelectedRow();
        if (column == 2) {
            String newName = (String)this.starredPeptidesTable.getValueAt(row, column);
            ArrayList<String> others = new ArrayList<String>();
            for (int i = 0; i < this.starredPeptidesTable.getRowCount(); ++i) {
                if (i == row) continue;
                others.add((String)this.starredPeptidesTable.getValueAt(i, column));
            }
            if (others.contains(newName)) {
                int outcome = 0;
                if (this.peptideShakerGUI.getFilterParameters().filterExists(newName)) {
                    outcome = JOptionPane.showConfirmDialog(this, "Should peptide filter " + newName + " be overwritten?", "Selected Name Already Exists", 0, 2);
                }
                if (outcome != 0) {
                    for (PeptideFilter peptideFilter : this.peptideStarFilters.values()) {
                        if (others.contains(peptideFilter.getName())) continue;
                        this.starredPeptidesTable.setValueAt(peptideFilter.getName(), row, column);
                    }
                    return;
                }
            }
            for (PeptideFilter peptideFilter : this.peptideStarFilters.values()) {
                if (others.contains(peptideFilter.getName())) continue;
                String oldName = peptideFilter.getName();
                peptideFilter.setName(newName);
                this.peptideStarFilters.remove(oldName);
                this.peptideStarFilters.put(newName, peptideFilter);
            }
        }
        if (column == 3) {
            String name = (String)this.starredPeptidesTable.getValueAt(row, 2);
            this.peptideStarFilters.get(name).setDescription((String)this.starredPeptidesTable.getValueAt(row, column));
        }
        if (this.starredPeptidesTable.isEditing()) {
            this.editStarredPeptides.setEnabled(false);
            this.deleteStarredPeptides.setEnabled(false);
        } else if (this.starredPeptidesTable.getSelectedRow() != -1) {
            this.editStarredPeptides.setEnabled(true);
            this.deleteStarredPeptides.setEnabled(true);
        }
    }

    private void hiddenPeptidesTableKeyReleased(KeyEvent evt) {
        int column = this.hiddenPeptidesTable.getSelectedColumn();
        int row = this.hiddenPeptidesTable.getSelectedRow();
        if (column == 2) {
            String newName = (String)this.hiddenPeptidesTable.getValueAt(row, column);
            ArrayList<String> others = new ArrayList<String>();
            for (int i = 0; i < this.hiddenPeptidesTable.getRowCount(); ++i) {
                if (i == row) continue;
                others.add((String)this.hiddenPeptidesTable.getValueAt(i, column));
            }
            if (others.contains(newName)) {
                int outcome = 0;
                if (this.peptideShakerGUI.getFilterParameters().filterExists(newName)) {
                    outcome = JOptionPane.showConfirmDialog(this, "Should peptide filter " + newName + " be overwritten?", "Selected Name Already Exists", 0, 2);
                }
                if (outcome != 0) {
                    for (PeptideFilter peptideFilter : this.peptideHideFilters.values()) {
                        if (others.contains(peptideFilter.getName())) continue;
                        this.hiddenPeptidesTable.setValueAt(peptideFilter.getName(), row, column);
                    }
                    return;
                }
            }
            for (PeptideFilter peptideFilter : this.peptideHideFilters.values()) {
                if (others.contains(peptideFilter.getName())) continue;
                String oldName = peptideFilter.getName();
                peptideFilter.setName(newName);
                this.peptideHideFilters.remove(oldName);
                this.peptideHideFilters.put(newName, peptideFilter);
            }
        }
        if (column == 3) {
            String name = (String)this.hiddenPeptidesTable.getValueAt(row, 2);
            this.peptideHideFilters.get(name).setDescription((String)this.hiddenPeptidesTable.getValueAt(row, column));
        }
        if (this.hiddenPeptidesTable.isEditing()) {
            this.editHiddenPeptides.setEnabled(false);
            this.deleteHiddenPeptides.setEnabled(false);
        } else if (this.hiddenPeptidesTable.getSelectedRow() != -1) {
            this.editHiddenPeptides.setEnabled(true);
            this.deleteHiddenPeptides.setEnabled(true);
        }
    }

    private void starredPsmTableKeyReleased(KeyEvent evt) {
        int column = this.starredPsmTable.getSelectedColumn();
        int row = this.starredPsmTable.getSelectedRow();
        if (column == 2) {
            String newName = (String)this.starredPsmTable.getValueAt(row, column);
            ArrayList<String> others = new ArrayList<String>();
            for (int i = 0; i < this.starredPsmTable.getRowCount(); ++i) {
                if (i == row) continue;
                others.add((String)this.starredPsmTable.getValueAt(i, column));
            }
            if (others.contains(newName)) {
                int outcome = 0;
                if (this.peptideShakerGUI.getFilterParameters().filterExists(newName)) {
                    outcome = JOptionPane.showConfirmDialog(this, "Should psm filter " + newName + " be overwritten?", "Selected Name Already Exists", 0, 2);
                }
                if (outcome != 0) {
                    for (PsmFilter psmFilter : this.psmStarFilters.values()) {
                        if (others.contains(psmFilter.getName())) continue;
                        this.starredPsmTable.setValueAt(psmFilter.getName(), row, column);
                    }
                    return;
                }
            }
            for (PsmFilter psmFilter : this.psmStarFilters.values()) {
                if (others.contains(psmFilter.getName())) continue;
                String oldName = psmFilter.getName();
                psmFilter.setName(newName);
                this.psmStarFilters.remove(oldName);
                this.psmStarFilters.put(newName, psmFilter);
            }
        }
        if (column == 3) {
            String name = (String)this.starredPsmTable.getValueAt(row, 2);
            this.psmStarFilters.get(name).setDescription((String)this.starredPsmTable.getValueAt(row, column));
        }
        if (this.starredPsmTable.isEditing()) {
            this.editStarredPsm.setEnabled(false);
            this.deleteStarredPsm.setEnabled(false);
        } else if (this.starredPsmTable.getSelectedRow() != -1) {
            this.editStarredPsm.setEnabled(true);
            this.deleteStarredPsm.setEnabled(true);
        }
    }

    private void hiddenPsmTableKeyReleased(KeyEvent evt) {
        int column = this.hiddenPsmTable.getSelectedColumn();
        int row = this.hiddenPsmTable.getSelectedRow();
        if (column == 2) {
            String newName = (String)this.hiddenPsmTable.getValueAt(row, column);
            ArrayList<String> others = new ArrayList<String>();
            for (int i = 0; i < this.hiddenPsmTable.getRowCount(); ++i) {
                if (i == row) continue;
                others.add((String)this.hiddenPsmTable.getValueAt(i, column));
            }
            if (others.contains(newName)) {
                int outcome = 0;
                if (this.peptideShakerGUI.getFilterParameters().filterExists(newName)) {
                    outcome = JOptionPane.showConfirmDialog(this, "Should psm filter " + newName + " be overwritten?", "Selected Name Already Exists", 0, 2);
                }
                if (outcome != 0) {
                    for (PsmFilter psmFilter : this.psmHideFilters.values()) {
                        if (others.contains(psmFilter.getName())) continue;
                        this.hiddenPsmTable.setValueAt(psmFilter.getName(), row, column);
                    }
                    return;
                }
            }
            for (PsmFilter psmFilter : this.psmHideFilters.values()) {
                if (others.contains(psmFilter.getName())) continue;
                String oldName = psmFilter.getName();
                psmFilter.setName(newName);
                this.psmHideFilters.remove(oldName);
                this.psmHideFilters.put(newName, psmFilter);
            }
        }
        if (column == 3) {
            String name = (String)this.hiddenPsmTable.getValueAt(row, 2);
            this.psmHideFilters.get(name).setDescription((String)this.hiddenPsmTable.getValueAt(row, column));
        }
        if (row != -1) {
            this.editHiddenPsm.setEnabled(true);
            this.deleteHiddenPsm.setEnabled(true);
        }
        if (this.hiddenPsmTable.isEditing()) {
            this.editHiddenPsm.setEnabled(false);
            this.deleteHiddenPsm.setEnabled(false);
        } else if (this.hiddenPsmTable.getSelectedRow() != -1) {
            this.editHiddenPsm.setEnabled(true);
            this.deleteHiddenPsm.setEnabled(true);
        }
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/FilterSelection.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Filter Selection - Help");
        this.setCursor(new Cursor(0));
    }

    private void tabbedPaneComponentResized(ComponentEvent evt) {
        this.proteinsSplitPane.setDividerLocation(0.5);
        this.peptidesSplitPane.setDividerLocation(0.5);
        this.psmsSplitPane.setDividerLocation(0.5);
    }

    private void deleteStarredProteinActionPerformed(ActionEvent evt) {
        int row = this.starredProteinsTable.getSelectedRow();
        if (row >= 0) {
            String selectedFilterName = (String)this.starredProteinsTable.getValueAt(row, 2);
            this.proteinStarFilters.remove(selectedFilterName);
            this.emptyTables();
            this.fillTables();
        }
    }

    private void deleteHiddenProteinActionPerformed(ActionEvent evt) {
        int row = this.hiddenProteinsTable.getSelectedRow();
        if (row >= 0) {
            String selectedFilterName = (String)this.hiddenProteinsTable.getValueAt(row, 2);
            this.proteinHideFilters.remove(selectedFilterName);
            this.emptyTables();
            this.fillTables();
        }
    }

    private void deleteStarredPeptidesActionPerformed(ActionEvent evt) {
        int row = this.starredPeptidesTable.getSelectedRow();
        if (row >= 0) {
            String selectedFilterName = (String)this.starredPeptidesTable.getValueAt(row, 2);
            this.peptideStarFilters.remove(selectedFilterName);
            this.emptyTables();
            this.fillTables();
        }
    }

    private void deleteHiddenPeptidesActionPerformed(ActionEvent evt) {
        int row = this.hiddenPeptidesTable.getSelectedRow();
        if (row >= 0) {
            String selectedFilterName = (String)this.hiddenPeptidesTable.getValueAt(row, 2);
            this.peptideHideFilters.remove(selectedFilterName);
            this.emptyTables();
            this.fillTables();
        }
    }

    private void deleteStarredPsmActionPerformed(ActionEvent evt) {
        int row = this.starredPsmTable.getSelectedRow();
        if (row >= 0) {
            String selectedFilterName = (String)this.starredPsmTable.getValueAt(row, 2);
            this.psmStarFilters.remove(selectedFilterName);
            this.emptyTables();
            this.fillTables();
        }
    }

    private void deleteHiddenPsmActionPerformed(ActionEvent evt) {
        int row = this.hiddenPsmTable.getSelectedRow();
        if (row >= 0) {
            String selectedFilterName = (String)this.hiddenPsmTable.getValueAt(row, 2);
            this.psmHideFilters.remove(selectedFilterName);
            this.emptyTables();
            this.fillTables();
        }
    }

    public Filter createPsmFilter() {
        FilterDialog filterDialog = new FilterDialog((JDialog)this, (MatchFilter)new PsmFilter(), this.allModifications);
        if (!filterDialog.isCanceled()) {
            return filterDialog.getFilter();
        }
        return null;
    }

    public Filter createPeptideFilter() {
        FilterDialog filterDialog = new FilterDialog((JDialog)this, (MatchFilter)new PeptideFilter(), this.allModifications);
        if (!filterDialog.isCanceled()) {
            return filterDialog.getFilter();
        }
        return null;
    }

    public Filter createProteinFilter() {
        FilterDialog filterDialog = new FilterDialog((JDialog)this, (MatchFilter)new ProteinFilter(), this.allModifications);
        if (!filterDialog.isCanceled()) {
            return filterDialog.getFilter();
        }
        return null;
    }

    public Filter editFilter(Filter filter) {
        FilterDialog filterDialog = new FilterDialog((JDialog)this, (MatchFilter)filter, this.allModifications);
        if (!filterDialog.isCanceled()) {
            return filterDialog.getFilter();
        }
        return null;
    }

    public void updateTables() {
        this.emptyTables();
        this.fillTables();
    }
}

