/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.pride;

import com.compomics.software.dialogs.ProteoWizardSetupDialog;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.mass_spectrometry.proteowizard.ProteoWizardMsFormat;
import com.compomics.util.gui.JOptionEditorPane;
import com.compomics.util.gui.TableProperties;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.file.LastSelectedFolder;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.gui.pride.PrideReshakeGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import no.uib.jsparklines.extra.HtmlLinksRenderer;
import no.uib.jsparklines.extra.NimbusCheckBoxRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;

public class PrideReshakeSetupDialog
extends JDialog {
    private final PrideReshakeGUI prideReShakeGUI;
    private ArrayList<String> filesTableToolTips;
    private static ProgressDialogX progressDialog;
    private boolean isFileBeingDownloaded = false;
    private final LastSelectedFolder lastSelectedFolder;
    private JButton aboutButton;
    private JPanel backgroundPanel;
    private JButton browseDatabaseSettingsButton;
    private JButton browseWorkingFolderButton;
    private JLabel dataTypeSeparatorLabel;
    private JPanel databasePanel;
    private JLabel databaseSettingsLbl;
    private JTextField databaseSettingsTxt;
    private JLabel deselectAllLabel;
    private JLabel downloadUniProtJLabel;
    private JLabel peptideShakerHomePageLabel;
    private JButton reshakeButton;
    private JLabel searchSettingsLabel;
    private JPanel searchSettingsPanel;
    private JScrollPane searchSettingsScrollPane;
    private JTable searchSettingsTable;
    private JLabel selectAllLabel;
    private JTextField speciesJTextField;
    private JLabel speciesLabel;
    private JLabel spectrumLabel;
    private JPanel spectrumPanel;
    private JTable spectrumTable;
    private JScrollPane spectrumTableScrollPane;
    private JLabel workingFolderLbl;
    private JPanel workingFolderPanel;
    private JTextField workingFolderTxt;

    public PrideReshakeSetupDialog(PrideReshakeGUI prideReShakeGUI, boolean modal) {
        super((Frame)prideReShakeGUI, modal);
        this.lastSelectedFolder = prideReShakeGUI.getPeptideShakerGUI().getLastSelectedFolder();
        this.initComponents();
        this.prideReShakeGUI = prideReShakeGUI;
        this.setUpGUI();
        this.validateInput(false);
        this.setLocationRelativeTo(prideReShakeGUI);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.spectrumTableScrollPane.getViewport().setOpaque(false);
        this.searchSettingsScrollPane.getViewport().setOpaque(false);
        this.spectrumTable.getTableHeader().setReorderingAllowed(false);
        this.searchSettingsTable.getTableHeader().setReorderingAllowed(false);
        this.spectrumTable.setAutoCreateRowSorter(true);
        this.searchSettingsTable.setAutoCreateRowSorter(true);
        this.filesTableToolTips = new ArrayList();
        this.filesTableToolTips.add(null);
        this.filesTableToolTips.add("Assay Accession Numbers");
        this.filesTableToolTips.add("File Type");
        this.filesTableToolTips.add("File");
        this.filesTableToolTips.add("Download File");
        this.filesTableToolTips.add("File Size (MB)");
        this.filesTableToolTips.add("Selected");
        int fixedColumnWidth = 110;
        this.spectrumTable.getColumn("Assay").setMaxWidth(fixedColumnWidth);
        this.spectrumTable.getColumn("Assay").setMinWidth(fixedColumnWidth);
        this.spectrumTable.getColumn(" ").setMaxWidth(50);
        this.spectrumTable.getColumn(" ").setMinWidth(50);
        this.spectrumTable.getColumn("  ").setMaxWidth(30);
        this.spectrumTable.getColumn("  ").setMinWidth(30);
        this.spectrumTable.getColumn("Type").setMaxWidth(fixedColumnWidth);
        this.spectrumTable.getColumn("Type").setMinWidth(fixedColumnWidth);
        this.spectrumTable.getColumn("Download").setMaxWidth(fixedColumnWidth);
        this.spectrumTable.getColumn("Download").setMinWidth(fixedColumnWidth);
        this.spectrumTable.getColumn("Size (MB)").setMaxWidth(fixedColumnWidth);
        this.spectrumTable.getColumn("Size (MB)").setMinWidth(fixedColumnWidth);
        this.searchSettingsTable.getColumn("Assay").setMaxWidth(fixedColumnWidth);
        this.searchSettingsTable.getColumn("Assay").setMinWidth(fixedColumnWidth);
        this.searchSettingsTable.getColumn(" ").setMaxWidth(50);
        this.searchSettingsTable.getColumn(" ").setMinWidth(50);
        this.searchSettingsTable.getColumn("  ").setMaxWidth(30);
        this.searchSettingsTable.getColumn("  ").setMinWidth(30);
        this.searchSettingsTable.getColumn("Type").setMaxWidth(fixedColumnWidth);
        this.searchSettingsTable.getColumn("Type").setMinWidth(fixedColumnWidth);
        this.searchSettingsTable.getColumn("Download").setMaxWidth(fixedColumnWidth);
        this.searchSettingsTable.getColumn("Download").setMinWidth(fixedColumnWidth);
        this.searchSettingsTable.getColumn("Size (MB)").setMaxWidth(fixedColumnWidth);
        this.searchSettingsTable.getColumn("Size (MB)").setMinWidth(fixedColumnWidth);
        this.spectrumTable.getColumn("Assay").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        this.searchSettingsTable.getColumn("Assay").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        this.spectrumTable.getColumn("Download").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        this.searchSettingsTable.getColumn("Download").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        this.spectrumTable.getColumn("  ").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        this.searchSettingsTable.getColumn("  ").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        JPanel spectrumCorner = new JPanel();
        spectrumCorner.setBackground(this.spectrumTable.getTableHeader().getBackground());
        this.spectrumTableScrollPane.setCorner("UPPER_RIGHT_CORNER", spectrumCorner);
        JPanel settingsCorner = new JPanel();
        settingsCorner.setBackground(this.searchSettingsTable.getTableHeader().getBackground());
        this.searchSettingsScrollPane.setCorner("UPPER_RIGHT_CORNER", settingsCorner);
        this.speciesJTextField.setText(this.prideReShakeGUI.getCurrentSpeciesList());
        if (this.prideReShakeGUI.getCurrentSpeciesList() == null || this.prideReShakeGUI.getCurrentSpeciesList().trim().isEmpty()) {
            this.downloadUniProtJLabel.setEnabled(false);
        }
        this.updateTables();
    }

    private void updateTables() {
        TableModel filesTableModel = this.prideReShakeGUI.getFilesTable().getRowSorter().getModel();
        double maxFileSize = 0.0;
        for (int i = 0; i < filesTableModel.getRowCount(); ++i) {
            ((DefaultTableModel)this.spectrumTable.getModel()).addRow(new Object[]{this.spectrumTable.getRowCount() + 1, filesTableModel.getValueAt(i, 1), filesTableModel.getValueAt(i, 2), filesTableModel.getValueAt(i, 3), filesTableModel.getValueAt(i, 4), filesTableModel.getValueAt(i, 5), true});
            ((DefaultTableModel)this.searchSettingsTable.getModel()).addRow(new Object[]{this.searchSettingsTable.getRowCount() + 1, filesTableModel.getValueAt(i, 1), filesTableModel.getValueAt(i, 2), filesTableModel.getValueAt(i, 3), filesTableModel.getValueAt(i, 4), filesTableModel.getValueAt(i, 5), i == 0});
            double tempFileSize = (Double)filesTableModel.getValueAt(i, this.spectrumTable.getColumn("Size (MB)").getModelIndex());
            if (!(tempFileSize > maxFileSize)) continue;
            maxFileSize = tempFileSize;
        }
        ArrayList<1> spectrumFileFilters = new ArrayList<1>();
        RowFilter<Object, Object> reshakeableFilter = new RowFilter<Object, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry) {
                return PrideReshakeSetupDialog.this.isFileReshakeable((String)entry.getValue(PrideReshakeSetupDialog.this.spectrumTable.getColumn("File").getModelIndex()), (String)entry.getValue(PrideReshakeSetupDialog.this.spectrumTable.getColumn("Type").getModelIndex()));
            }
        };
        spectrumFileFilters.add(reshakeableFilter);
        RowFilter allSpectrumFileFilters = RowFilter.andFilter(spectrumFileFilters);
        if (this.spectrumTable.getRowSorter() != null) {
            ((TableRowSorter)this.spectrumTable.getRowSorter()).setRowFilter(allSpectrumFileFilters);
        }
        for (int i = 0; i < this.spectrumTable.getRowCount(); ++i) {
            this.spectrumTable.setValueAt(i + 1, i, 0);
        }
        ArrayList<2> searchSettingsFilesFilters = new ArrayList<2>();
        RowFilter<Object, Object> searchSettingsFilter = new RowFilter<Object, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry) {
                return PrideReshakeSetupDialog.this.isFileSearchSettingsExtractable((String)entry.getValue(PrideReshakeSetupDialog.this.searchSettingsTable.getColumn("File").getModelIndex()), (String)entry.getValue(PrideReshakeSetupDialog.this.searchSettingsTable.getColumn("Type").getModelIndex()));
            }
        };
        searchSettingsFilesFilters.add(searchSettingsFilter);
        RowFilter allSearchSettingsFilesFilters = RowFilter.andFilter(searchSettingsFilesFilters);
        if (this.searchSettingsTable.getRowSorter() != null) {
            ((TableRowSorter)this.searchSettingsTable.getRowSorter()).setRowFilter(allSearchSettingsFilesFilters);
        }
        for (int i = 0; i < this.searchSettingsTable.getRowCount(); ++i) {
            this.searchSettingsTable.setValueAt(i + 1, i, 0);
        }
        ((TitledBorder)this.spectrumPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Spectrum Files (" + this.spectrumTable.getRowCount() + ")");
        this.spectrumPanel.repaint();
        ((TitledBorder)this.searchSettingsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Search Settings (" + this.searchSettingsTable.getRowCount() + ")");
        this.searchSettingsPanel.repaint();
        this.spectrumTable.getColumn("Size (MB)").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxFileSize), this.prideReShakeGUI.getPeptideShakerGUI().getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.spectrumTable.getColumn("Size (MB)").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
        ((JSparklinesBarChartTableCellRenderer)this.spectrumTable.getColumn("Size (MB)").getCellRenderer()).setLogScale(true);
        ((JSparklinesBarChartTableCellRenderer)this.spectrumTable.getColumn("Size (MB)").getCellRenderer()).setMinimumChartValue(1.0);
        this.searchSettingsTable.getColumn("Size (MB)").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxFileSize), this.prideReShakeGUI.getPeptideShakerGUI().getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.searchSettingsTable.getColumn("Size (MB)").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
        ((JSparklinesBarChartTableCellRenderer)this.searchSettingsTable.getColumn("Size (MB)").getCellRenderer()).setLogScale(true);
        ((JSparklinesBarChartTableCellRenderer)this.searchSettingsTable.getColumn("Size (MB)").getCellRenderer()).setMinimumChartValue(1.0);
    }

    private boolean isFileReshakeable(String fileName, String fileType) {
        boolean reshakeable = false;
        if (this.prideReShakeGUI.getReshakeableFiles().containsKey(fileType)) {
            for (String fileEnding : this.prideReShakeGUI.getReshakeableFiles().get(fileType)) {
                if (fileName.toLowerCase().endsWith(".pride.mgf.gz") && fileName.toLowerCase().endsWith(".pride.mztab.gz")) {
                    return false;
                }
                if (!fileName.toLowerCase().endsWith(fileEnding)) continue;
                reshakeable = true;
                break;
            }
        }
        return reshakeable;
    }

    private boolean isFileSearchSettingsExtractable(String fileName, String fileType) {
        boolean containsSearchSettings = false;
        if (this.prideReShakeGUI.getSearchSettingsFiles().containsKey(fileType)) {
            for (String fileEnding : this.prideReShakeGUI.getSearchSettingsFiles().get(fileType)) {
                if (!fileName.toLowerCase().endsWith(fileEnding)) continue;
                containsSearchSettings = true;
                break;
            }
        }
        return containsSearchSettings;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.spectrumPanel = new JPanel();
        this.spectrumLabel = new JLabel();
        this.spectrumTableScrollPane = new JScrollPane();
        this.spectrumTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)PrideReshakeSetupDialog.this.filesTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.selectAllLabel = new JLabel();
        this.dataTypeSeparatorLabel = new JLabel();
        this.deselectAllLabel = new JLabel();
        this.searchSettingsPanel = new JPanel();
        this.searchSettingsLabel = new JLabel();
        this.searchSettingsScrollPane = new JScrollPane();
        this.searchSettingsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)PrideReshakeSetupDialog.this.filesTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.databasePanel = new JPanel();
        this.speciesLabel = new JLabel();
        this.speciesJTextField = new JTextField();
        this.downloadUniProtJLabel = new JLabel();
        this.databaseSettingsLbl = new JLabel();
        this.databaseSettingsTxt = new JTextField();
        this.browseDatabaseSettingsButton = new JButton();
        this.workingFolderPanel = new JPanel();
        this.workingFolderLbl = new JLabel();
        this.workingFolderTxt = new JTextField();
        this.browseWorkingFolderButton = new JButton();
        this.reshakeButton = new JButton();
        this.aboutButton = new JButton();
        this.peptideShakerHomePageLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Reshake Settings");
        this.setMinimumSize(new Dimension(780, 700));
        this.backgroundPanel.setBackground(new Color(255, 255, 255));
        this.spectrumPanel.setBorder(BorderFactory.createTitledBorder(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Spectrum Files"));
        this.spectrumPanel.setOpaque(false);
        this.spectrumLabel.setFont(this.spectrumLabel.getFont().deriveFont(this.spectrumLabel.getFont().getStyle() | 2));
        this.spectrumLabel.setText("Select the spectrum files to reanalyze: peak lists, raw files or PRIDE XML.");
        this.spectrumTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Assay", "Type", "File", "Download", "Size (MB)", "  "}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, String.class, String.class, String.class, Long.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.spectrumTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                PrideReshakeSetupDialog.this.spectrumTableMouseReleased(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PrideReshakeSetupDialog.this.spectrumTableMouseExited(evt);
            }
        });
        this.spectrumTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                PrideReshakeSetupDialog.this.spectrumTableMouseMoved(evt);
            }
        });
        this.spectrumTableScrollPane.setViewportView(this.spectrumTable);
        this.selectAllLabel.setText("<html><a href=\"dummy\">Select All</a></html>  ");
        this.selectAllLabel.setToolTipText("Open the PeptideShaker web page");
        this.selectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PrideReshakeSetupDialog.this.selectAllLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PrideReshakeSetupDialog.this.selectAllLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PrideReshakeSetupDialog.this.selectAllLabelMouseExited(evt);
            }
        });
        this.dataTypeSeparatorLabel.setText("/");
        this.deselectAllLabel.setText("<html><a href=\"dummy\">Deselect All</a></html>\n\n");
        this.deselectAllLabel.setToolTipText("Open the PeptideShaker web page");
        this.deselectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PrideReshakeSetupDialog.this.deselectAllLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PrideReshakeSetupDialog.this.deselectAllLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PrideReshakeSetupDialog.this.deselectAllLabelMouseExited(evt);
            }
        });
        GroupLayout spectrumPanelLayout = new GroupLayout(this.spectrumPanel);
        this.spectrumPanel.setLayout(spectrumPanelLayout);
        spectrumPanelLayout.setHorizontalGroup(spectrumPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.spectrumLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.selectAllLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataTypeSeparatorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deselectAllLabel, -2, -1, -2).addGap(23, 23, 23)).addGroup(GroupLayout.Alignment.TRAILING, spectrumPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.spectrumTableScrollPane).addContainerGap()));
        spectrumPanelLayout.setVerticalGroup(spectrumPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, spectrumPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.spectrumTableScrollPane, -1, 174, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(spectrumPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deselectAllLabel, -2, -1, -2).addComponent(this.selectAllLabel, -2, -1, -2).addComponent(this.dataTypeSeparatorLabel)).addComponent(this.spectrumLabel)).addContainerGap()));
        this.searchSettingsPanel.setBorder(BorderFactory.createTitledBorder(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Search Settings"));
        this.searchSettingsPanel.setOpaque(false);
        this.searchSettingsLabel.setFont(this.searchSettingsLabel.getFont().deriveFont(this.searchSettingsLabel.getFont().getStyle() | 2));
        this.searchSettingsLabel.setText("Select the file to extract the search parameters from: mzIdentML or PRIDE XML.");
        this.searchSettingsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Assay", "Type", "File", "Download", "Size (MB)", "  "}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, String.class, String.class, String.class, Long.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.searchSettingsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                PrideReshakeSetupDialog.this.searchSettingsTableMouseReleased(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PrideReshakeSetupDialog.this.searchSettingsTableMouseExited(evt);
            }
        });
        this.searchSettingsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                PrideReshakeSetupDialog.this.searchSettingsTableMouseMoved(evt);
            }
        });
        this.searchSettingsScrollPane.setViewportView(this.searchSettingsTable);
        GroupLayout searchSettingsPanelLayout = new GroupLayout(this.searchSettingsPanel);
        this.searchSettingsPanel.setLayout(searchSettingsPanelLayout);
        searchSettingsPanelLayout.setHorizontalGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchSettingsScrollPane).addGroup(searchSettingsPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.searchSettingsLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        searchSettingsPanelLayout.setVerticalGroup(searchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, searchSettingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.searchSettingsScrollPane, -1, 174, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchSettingsLabel).addContainerGap()));
        this.databasePanel.setBorder(BorderFactory.createTitledBorder(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Sequence Database"));
        this.databasePanel.setOpaque(false);
        this.speciesLabel.setText("Species");
        this.speciesJTextField.setEditable(false);
        this.speciesJTextField.setHorizontalAlignment(0);
        this.speciesJTextField.setMargin(new Insets(2, 4, 2, 2));
        this.downloadUniProtJLabel.setForeground(new Color(0, 0, 255));
        this.downloadUniProtJLabel.setHorizontalAlignment(0);
        this.downloadUniProtJLabel.setText("<html><u>UniProt</u></html>");
        this.downloadUniProtJLabel.setToolTipText("Click to Download UniProt Database");
        this.downloadUniProtJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PrideReshakeSetupDialog.this.downloadUniProtJLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PrideReshakeSetupDialog.this.downloadUniProtJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PrideReshakeSetupDialog.this.downloadUniProtJLabelMouseExited(evt);
            }
        });
        this.databaseSettingsLbl.setForeground(new Color(0, 0, 255));
        this.databaseSettingsLbl.setText("<html><u>Database</u></html>");
        this.databaseSettingsLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PrideReshakeSetupDialog.this.databaseSettingsLblMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PrideReshakeSetupDialog.this.databaseSettingsLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PrideReshakeSetupDialog.this.databaseSettingsLblMouseExited(evt);
            }
        });
        this.databaseSettingsTxt.setEditable(false);
        this.databaseSettingsTxt.setMargin(new Insets(2, 4, 2, 2));
        this.browseDatabaseSettingsButton.setText("Browse");
        this.browseDatabaseSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrideReshakeSetupDialog.this.browseDatabaseSettingsButtonActionPerformed(evt);
            }
        });
        GroupLayout databasePanelLayout = new GroupLayout(this.databasePanel);
        this.databasePanel.setLayout(databasePanelLayout);
        databasePanelLayout.setHorizontalGroup(databasePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(databasePanelLayout.createSequentialGroup().addContainerGap().addGroup(databasePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.databaseSettingsLbl, -2, 70, -2).addComponent(this.speciesLabel, -2, 70, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(databasePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.speciesJTextField).addComponent(this.databaseSettingsTxt)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(databasePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.downloadUniProtJLabel).addComponent(this.browseDatabaseSettingsButton, -1, 80, Short.MAX_VALUE)).addContainerGap()));
        databasePanelLayout.setVerticalGroup(databasePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, databasePanelLayout.createSequentialGroup().addContainerGap().addGroup(databasePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.speciesLabel).addComponent(this.speciesJTextField, -2, -1, -2).addComponent(this.downloadUniProtJLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(databasePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.databaseSettingsLbl, -2, -1, -2).addComponent(this.browseDatabaseSettingsButton).addComponent(this.databaseSettingsTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.workingFolderPanel.setBorder(BorderFactory.createTitledBorder(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Output Folder"));
        this.workingFolderPanel.setOpaque(false);
        this.workingFolderLbl.setText("Folder");
        this.workingFolderTxt.setEditable(false);
        this.workingFolderTxt.setMargin(new Insets(2, 4, 2, 2));
        this.browseWorkingFolderButton.setText("Browse");
        this.browseWorkingFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrideReshakeSetupDialog.this.browseWorkingFolderButtonActionPerformed(evt);
            }
        });
        GroupLayout workingFolderPanelLayout = new GroupLayout(this.workingFolderPanel);
        this.workingFolderPanel.setLayout(workingFolderPanelLayout);
        workingFolderPanelLayout.setHorizontalGroup(workingFolderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(workingFolderPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.workingFolderLbl, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.workingFolderTxt).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.browseWorkingFolderButton, -2, 80, -2).addContainerGap()));
        workingFolderPanelLayout.setVerticalGroup(workingFolderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(workingFolderPanelLayout.createSequentialGroup().addContainerGap().addGroup(workingFolderPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.workingFolderLbl).addComponent(this.browseWorkingFolderButton).addComponent(this.workingFolderTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.reshakeButton.setBackground(new Color(0, 153, 0));
        this.reshakeButton.setFont(this.reshakeButton.getFont().deriveFont(this.reshakeButton.getFont().getStyle() | 1));
        this.reshakeButton.setForeground(new Color(255, 255, 255));
        this.reshakeButton.setText("  Start Reshaking!  ");
        this.reshakeButton.setEnabled(false);
        this.reshakeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrideReshakeSetupDialog.this.reshakeButtonActionPerformed(evt);
            }
        });
        this.aboutButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/peptide-shaker-medium-orange-shadow.png")));
        this.aboutButton.setToolTipText("Open the PeptideShaker web page");
        this.aboutButton.setBorder(null);
        this.aboutButton.setBorderPainted(false);
        this.aboutButton.setContentAreaFilled(false);
        this.aboutButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PrideReshakeSetupDialog.this.aboutButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PrideReshakeSetupDialog.this.aboutButtonMouseExited(evt);
            }
        });
        this.aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrideReshakeSetupDialog.this.aboutButtonActionPerformed(evt);
            }
        });
        this.peptideShakerHomePageLabel.setFont(this.peptideShakerHomePageLabel.getFont().deriveFont(this.peptideShakerHomePageLabel.getFont().getStyle() | 2));
        this.peptideShakerHomePageLabel.setText("Select the files to reanalyze, provide the search settings and click Start the Reshaking!");
        this.peptideShakerHomePageLabel.setToolTipText("Open the PeptideShaker web page");
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.databasePanel, -1, -1, Short.MAX_VALUE).addComponent(this.workingFolderPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.spectrumPanel, -1, -1, Short.MAX_VALUE).addComponent(this.searchSettingsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.aboutButton).addGap(44, 44, 44).addComponent(this.peptideShakerHomePageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 197, Short.MAX_VALUE).addComponent(this.reshakeButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.spectrumPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchSettingsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.databasePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.workingFolderPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.aboutButton).addComponent(this.peptideShakerHomePageLabel).addComponent(this.reshakeButton, -2, 53, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void reshakeButtonActionPerformed(ActionEvent evt) {
        boolean msConvertRequired = false;
        block0: for (int i = 0; i < this.spectrumTable.getRowCount(); ++i) {
            if (!((Boolean)this.spectrumTable.getValueAt(i, this.spectrumTable.getColumn("  ").getModelIndex())).booleanValue()) continue;
            String fileName = (String)this.spectrumTable.getValueAt(i, this.spectrumTable.getColumn("File").getModelIndex());
            for (ProteoWizardMsFormat format : ProteoWizardMsFormat.values()) {
                if (format == ProteoWizardMsFormat.mgf || !fileName.toLowerCase().endsWith(format.fileNameEnding)) continue;
                msConvertRequired = true;
                continue block0;
            }
        }
        boolean proteoWizardFolderOk = true;
        if (msConvertRequired && this.prideReShakeGUI.getPeptideShakerGUI().getUtilitiesUserParameters().getProteoWizardPath() == null && !(proteoWizardFolderOk = this.editProteoWizardInstallation())) {
            JOptionPane.showMessageDialog(this, "ProteoWizard folder not set. Currently supported spectrum formats are mgf and PRIDE XML.", "ProteoWizard Setup Error", 2);
        }
        if (proteoWizardFolderOk) {
            progressDialog = new ProgressDialogX((Frame)this.prideReShakeGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Checking Files. Please Wait...");
            this.isFileBeingDownloaded = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("FileExistsThread"){

                @Override
                public void run() {
                    int fileSizeInBytes;
                    Double fileSizeInMB;
                    String link;
                    int i;
                    ArrayList<String> selectedSpectrumFileLinks = new ArrayList<String>();
                    ArrayList<String> selectedFileNames = new ArrayList<String>();
                    String selectedSearchSettingsFileLink = null;
                    ArrayList<Integer> fileSizes = new ArrayList<Integer>();
                    for (i = 0; i < PrideReshakeSetupDialog.this.spectrumTable.getRowCount(); ++i) {
                        if (!((Boolean)PrideReshakeSetupDialog.this.spectrumTable.getValueAt(i, PrideReshakeSetupDialog.this.spectrumTable.getColumn("  ").getModelIndex())).booleanValue()) continue;
                        link = (String)PrideReshakeSetupDialog.this.spectrumTable.getValueAt(i, PrideReshakeSetupDialog.this.spectrumTable.getColumn("Download").getModelIndex());
                        link = link.substring(link.indexOf("\"") + 1);
                        boolean exists = IoUtil.checkIfURLExists((String)(link = link.substring(0, link.indexOf("\""))), (String)PrideReshakeSetupDialog.this.prideReShakeGUI.getUserName(), (String)PrideReshakeSetupDialog.this.prideReShakeGUI.getPassword());
                        if (!exists && link.endsWith(".gz")) {
                            link = link.substring(0, link.length() - 3);
                            exists = IoUtil.checkIfURLExists((String)link, (String)PrideReshakeSetupDialog.this.prideReShakeGUI.getUserName(), (String)PrideReshakeSetupDialog.this.prideReShakeGUI.getPassword());
                        }
                        if (exists) {
                            String fileName = (String)PrideReshakeSetupDialog.this.spectrumTable.getValueAt(i, PrideReshakeSetupDialog.this.spectrumTable.getColumn("File").getModelIndex());
                            selectedFileNames.add(fileName);
                            selectedSpectrumFileLinks.add(link);
                            fileSizeInMB = (Double)PrideReshakeSetupDialog.this.spectrumTable.getValueAt(i, PrideReshakeSetupDialog.this.spectrumTable.getColumn("Size (MB)").getModelIndex());
                            fileSizeInBytes = fileSizeInMB != null ? Double.valueOf(fileSizeInMB * 1024.0 * 1024.0).intValue() : -1;
                            fileSizes.add(fileSizeInBytes);
                            continue;
                        }
                        JOptionPane.showMessageDialog(PrideReshakeSetupDialog.this, JOptionEditorPane.getJOptionEditorPane((String)("PRIDE web service access error. Cannot open:<br>" + link + "<br>Please contact the <a href=\"https://www.ebi.ac.uk/support/index.php?query=pride\">PRIDE team</a>.")), "PRIDE Access Error", 2);
                        System.out.println("Not found: " + link + "!");
                    }
                    for (i = 0; i < PrideReshakeSetupDialog.this.searchSettingsTable.getRowCount(); ++i) {
                        if (!((Boolean)PrideReshakeSetupDialog.this.searchSettingsTable.getValueAt(i, PrideReshakeSetupDialog.this.searchSettingsTable.getColumn("  ").getModelIndex())).booleanValue()) continue;
                        link = (String)PrideReshakeSetupDialog.this.searchSettingsTable.getValueAt(i, PrideReshakeSetupDialog.this.searchSettingsTable.getColumn("Download").getModelIndex());
                        link = link.substring(link.indexOf("\"") + 1);
                        link = link.substring(0, link.indexOf("\""));
                        String selectedSearchSettingsFileName = (String)PrideReshakeSetupDialog.this.searchSettingsTable.getValueAt(i, PrideReshakeSetupDialog.this.searchSettingsTable.getColumn("File").getModelIndex());
                        if (!selectedSpectrumFileLinks.contains(link)) {
                            boolean exists = IoUtil.checkIfURLExists((String)link, (String)PrideReshakeSetupDialog.this.prideReShakeGUI.getUserName(), (String)PrideReshakeSetupDialog.this.prideReShakeGUI.getPassword());
                            if (!exists && link.endsWith(".gz")) {
                                exists = !selectedSpectrumFileLinks.contains(link = link.substring(0, link.length() - 3)) ? IoUtil.checkIfURLExists((String)link, (String)PrideReshakeSetupDialog.this.prideReShakeGUI.getUserName(), (String)PrideReshakeSetupDialog.this.prideReShakeGUI.getPassword()) : true;
                            }
                            if (exists) {
                                selectedSearchSettingsFileLink = link;
                                selectedFileNames.add(selectedSearchSettingsFileName);
                                fileSizeInMB = (Double)PrideReshakeSetupDialog.this.searchSettingsTable.getValueAt(i, PrideReshakeSetupDialog.this.searchSettingsTable.getColumn("Size (MB)").getModelIndex());
                                fileSizeInBytes = fileSizeInMB != null ? Double.valueOf(fileSizeInMB * 1024.0 * 1024.0).intValue() : -1;
                                fileSizes.add(fileSizeInBytes);
                                continue;
                            }
                            JOptionPane.showMessageDialog(PrideReshakeSetupDialog.this, JOptionEditorPane.getJOptionEditorPane((String)("PRIDE web service access error. Cannot open:<br>" + link + "<br>Please contact the <a href=\"https://www.ebi.ac.uk/support/index.php?query=pride\">PRIDE team</a>.")), "PRIDE Access Error", 2);
                            System.out.println("Not found: " + link + "!");
                            continue;
                        }
                        selectedSearchSettingsFileLink = link;
                    }
                    boolean download = true;
                    if (selectedSpectrumFileLinks.isEmpty()) {
                        download = false;
                    }
                    progressDialog.setRunFinished();
                    if (download) {
                        PrideReshakeSetupDialog.this.prideReShakeGUI.downloadPrideDatasets(PrideReshakeSetupDialog.this.workingFolderTxt.getText(), selectedSpectrumFileLinks, selectedFileNames, selectedSearchSettingsFileLink, PrideReshakeSetupDialog.this.databaseSettingsTxt.getText(), PrideReshakeSetupDialog.this.speciesJTextField.getText(), fileSizes);
                    } else {
                        JOptionPane.showMessageDialog(PrideReshakeSetupDialog.this, "No spectrum files found. Reshake canceled.", "File Error", 2);
                    }
                }
            }.start();
        }
    }

    private void downloadUniProtJLabelMouseEntered(MouseEvent evt) {
        if (this.downloadUniProtJLabel.isEnabled()) {
            this.setCursor(new Cursor(12));
        }
    }

    private void downloadUniProtJLabelMouseExited(MouseEvent evt) {
        if (this.downloadUniProtJLabel.isEnabled()) {
            this.setCursor(new Cursor(0));
        }
    }

    private void browseDatabaseSettingsButtonActionPerformed(ActionEvent evt) {
        File startLocation = null;
        if (this.prideReShakeGUI.getPeptideShakerGUI().getUtilitiesUserParameters().getDbFolder() != null && this.prideReShakeGUI.getPeptideShakerGUI().getUtilitiesUserParameters().getDbFolder().exists()) {
            startLocation = this.prideReShakeGUI.getPeptideShakerGUI().getUtilitiesUserParameters().getDbFolder();
        }
        if (startLocation == null) {
            startLocation = new File(this.lastSelectedFolder.getLastSelectedFolder());
        }
        JFileChooser fc = new JFileChooser(startLocation);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith("fasta") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "FASTA (.fasta)";
            }
        };
        fc.setFileFilter(filter);
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            File file = fc.getSelectedFile();
            File folder = file.getParentFile();
            this.prideReShakeGUI.getPeptideShakerGUI().getUtilitiesUserParameters().setDbFolder(folder);
            this.lastSelectedFolder.setLastSelectedFolder("fastaFile", folder.getAbsolutePath());
            if (file.getName().contains(" ")) {
                JOptionPane.showMessageDialog(this, "Your FASTA file name contains white space and ougth to be renamed.", "File Name Warning", 2);
            }
            this.databaseSettingsTxt.setText(file.getAbsolutePath());
        }
        this.validateInput(false);
    }

    private void browseWorkingFolderButtonActionPerformed(ActionEvent evt) {
        File selectedFolder = FileChooserUtil.getUserSelectedFolder((Component)this, (String)"Select Working Folder", (String)this.lastSelectedFolder.getLastSelectedFolder(), (String)"Working Folder", (String)"Select", (boolean)false);
        if (selectedFolder != null) {
            this.lastSelectedFolder.setLastSelectedFolder(selectedFolder.getAbsolutePath());
            this.workingFolderTxt.setText(selectedFolder.getAbsolutePath());
        }
        this.validateInput(false);
    }

    private void searchSettingsTableMouseReleased(MouseEvent evt) {
        int row = this.searchSettingsTable.rowAtPoint(evt.getPoint());
        int column = this.searchSettingsTable.columnAtPoint(evt.getPoint());
        if (column == this.searchSettingsTable.getColumn("  ").getModelIndex() && row != -1 && ((Boolean)this.searchSettingsTable.getValueAt(row, this.searchSettingsTable.getColumn("  ").getModelIndex())).booleanValue()) {
            for (int i = 0; i < this.searchSettingsTable.getRowCount(); ++i) {
                this.searchSettingsTable.setValueAt(i == row, i, this.searchSettingsTable.getColumn("  ").getModelIndex());
            }
        }
        this.validateInput(false);
        row = this.searchSettingsTable.getSelectedRow();
        column = this.searchSettingsTable.getSelectedColumn();
        if (column == this.searchSettingsTable.getColumn("Assay").getModelIndex() && evt.getButton() == 1 && ((String)this.searchSettingsTable.getValueAt(row, column)).lastIndexOf("<a href=\"") != -1) {
            String link = (String)this.searchSettingsTable.getValueAt(row, column);
            link = link.substring(link.indexOf("\"") + 1);
            link = link.substring(0, link.indexOf("\""));
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL((String)link);
            this.setCursor(new Cursor(0));
        } else if (column == this.searchSettingsTable.getColumn("Download").getModelIndex() && evt.getButton() == 1 && ((String)this.searchSettingsTable.getValueAt(row, column)).lastIndexOf("<a href=\"") != -1) {
            String tempLink = (String)this.searchSettingsTable.getValueAt(row, column);
            tempLink = tempLink.substring(tempLink.indexOf("\"") + 1);
            final String link = tempLink.substring(0, tempLink.indexOf("\""));
            Double fileSizeInMB = (Double)this.searchSettingsTable.getValueAt(row, this.searchSettingsTable.getColumn("Size (MB)").getModelIndex());
            final int fileSizeInBytes = fileSizeInMB != null ? Double.valueOf(fileSizeInMB * 1024.0 * 1024.0).intValue() : -1;
            final String fileName = (String)this.spectrumTable.getValueAt(row, this.spectrumTable.getColumn("File").getModelIndex());
            final File downloadFolder = FileChooserUtil.getUserSelectedFolder((Component)this, (String)"Select Download Folder", (String)this.lastSelectedFolder.getLastSelectedFolder(), (String)"Download Folder", (String)"Select", (boolean)false);
            if (downloadFolder != null) {
                this.lastSelectedFolder.setLastSelectedFolder(downloadFolder.getAbsolutePath());
                progressDialog = new ProgressDialogX((Frame)this.prideReShakeGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
                progressDialog.setPrimaryProgressCounterIndeterminate(true);
                progressDialog.setTitle("Downloading File. Please Wait...");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            progressDialog.setVisible(true);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }, "ProgressDialog").start();
                Thread thread = new Thread("DownloadThread"){

                    @Override
                    public void run() {
                        try {
                            File downLoadLocation = new File(downloadFolder, fileName);
                            File savedFile = IoUtil.saveUrl((File)downLoadLocation, (String)link, (int)fileSizeInBytes, (String)PrideReshakeSetupDialog.this.prideReShakeGUI.getUserName(), (String)PrideReshakeSetupDialog.this.prideReShakeGUI.getPassword(), (WaitingHandler)progressDialog);
                            boolean canceled = progressDialog.isRunCanceled();
                            progressDialog.setRunFinished();
                            if (!canceled) {
                                JOptionPane.showMessageDialog(PrideReshakeSetupDialog.this, savedFile.getName() + " downloaded to\n" + savedFile + ".", "Download Complete", 1);
                            } else if (downLoadLocation.exists()) {
                                downLoadLocation.delete();
                            }
                        }
                        catch (MalformedURLException e) {
                            progressDialog.setRunFinished();
                            PrideReshakeSetupDialog.this.prideReShakeGUI.getPeptideShakerGUI().catchException(e);
                        }
                        catch (IOException e) {
                            progressDialog.setRunFinished();
                            PrideReshakeSetupDialog.this.prideReShakeGUI.getPeptideShakerGUI().catchException(e);
                        }
                    }
                };
                thread.start();
            }
        }
    }

    private void spectrumTableMouseMoved(MouseEvent evt) {
        int row = this.spectrumTable.rowAtPoint(evt.getPoint());
        int column = this.spectrumTable.columnAtPoint(evt.getPoint());
        this.spectrumTable.setToolTipText(null);
        if (row != -1 && column != -1 && (column == this.spectrumTable.getColumn("Assay").getModelIndex() || column == this.spectrumTable.getColumn("Download").getModelIndex()) && this.spectrumTable.getValueAt(row, column) != null) {
            String tempValue = (String)this.spectrumTable.getValueAt(row, column);
            if (tempValue.lastIndexOf("<a href=\"") != -1) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void spectrumTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void spectrumTableMouseReleased(MouseEvent evt) {
        if (evt != null) {
            int row = this.spectrumTable.getSelectedRow();
            int column = this.spectrumTable.getSelectedColumn();
            if (column == this.spectrumTable.getColumn("Assay").getModelIndex() && evt.getButton() == 1 && ((String)this.spectrumTable.getValueAt(row, column)).lastIndexOf("<a href=\"") != -1) {
                String link = (String)this.spectrumTable.getValueAt(row, column);
                link = link.substring(link.indexOf("\"") + 1);
                link = link.substring(0, link.indexOf("\""));
                this.setCursor(new Cursor(3));
                BareBonesBrowserLaunch.openURL((String)link);
                this.setCursor(new Cursor(0));
            } else if (column == this.spectrumTable.getColumn("Download").getModelIndex() && evt.getButton() == 1 && ((String)this.spectrumTable.getValueAt(row, column)).lastIndexOf("<a href=\"") != -1) {
                String tempLink = (String)this.spectrumTable.getValueAt(row, column);
                tempLink = tempLink.substring(tempLink.indexOf("\"") + 1);
                final String link = tempLink.substring(0, tempLink.indexOf("\""));
                Double fileSizeInMB = (Double)this.spectrumTable.getValueAt(row, this.spectrumTable.getColumn("Size (MB)").getModelIndex());
                final int fileSizeInBytes = fileSizeInMB != null ? Double.valueOf(fileSizeInMB * 1024.0 * 1024.0).intValue() : -1;
                final String fileName = (String)this.spectrumTable.getValueAt(row, this.spectrumTable.getColumn("File").getModelIndex());
                final File downloadFolder = FileChooserUtil.getUserSelectedFolder((Component)this, (String)"Select Download Folder", (String)this.lastSelectedFolder.getLastSelectedFolder(), (String)"Download Folder", (String)"Select", (boolean)false);
                if (downloadFolder != null) {
                    this.lastSelectedFolder.setLastSelectedFolder(downloadFolder.getAbsolutePath());
                    progressDialog = new ProgressDialogX((Frame)this.prideReShakeGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
                    progressDialog.setPrimaryProgressCounterIndeterminate(true);
                    progressDialog.setTitle("Downloading File. Please Wait...");
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                progressDialog.setVisible(true);
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                // empty catch block
                            }
                        }
                    }, "ProgressDialog").start();
                    Thread thread = new Thread("DownloadThread"){

                        @Override
                        public void run() {
                            try {
                                File downLoadLocation = new File(downloadFolder, fileName);
                                File savedFile = IoUtil.saveUrl((File)downLoadLocation, (String)link, (int)fileSizeInBytes, (String)PrideReshakeSetupDialog.this.prideReShakeGUI.getUserName(), (String)PrideReshakeSetupDialog.this.prideReShakeGUI.getPassword(), (WaitingHandler)progressDialog);
                                boolean canceled = progressDialog.isRunCanceled();
                                progressDialog.setRunFinished();
                                if (!canceled) {
                                    JOptionPane.showMessageDialog(PrideReshakeSetupDialog.this, savedFile.getName() + " downloaded to\n" + savedFile + ".", "Download Complete", 1);
                                } else if (downLoadLocation.exists()) {
                                    downLoadLocation.delete();
                                }
                            }
                            catch (MalformedURLException e) {
                                progressDialog.setRunFinished();
                                PrideReshakeSetupDialog.this.prideReShakeGUI.getPeptideShakerGUI().catchException(e);
                            }
                            catch (IOException e) {
                                progressDialog.setRunFinished();
                                PrideReshakeSetupDialog.this.prideReShakeGUI.getPeptideShakerGUI().catchException(e);
                            }
                        }
                    };
                    thread.start();
                }
            }
            this.validateInput(false);
        }
    }

    private void searchSettingsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void searchSettingsTableMouseMoved(MouseEvent evt) {
        int row = this.searchSettingsTable.rowAtPoint(evt.getPoint());
        int column = this.searchSettingsTable.columnAtPoint(evt.getPoint());
        this.searchSettingsTable.setToolTipText(null);
        if (row != -1 && column != -1 && (column == this.searchSettingsTable.getColumn("Assay").getModelIndex() || column == this.spectrumTable.getColumn("Download").getModelIndex()) && this.searchSettingsTable.getValueAt(row, column) != null) {
            String tempValue = (String)this.searchSettingsTable.getValueAt(row, column);
            if (tempValue.lastIndexOf("<a href=\"") != -1) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void aboutButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://compomics.github.io/projects/peptide-shaker.html");
        this.setCursor(new Cursor(0));
    }

    private void aboutButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void aboutButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void selectAllLabelMouseClicked(MouseEvent evt) {
        for (int i = 0; i < this.spectrumTable.getRowCount(); ++i) {
            this.spectrumTable.setValueAt(true, i, this.spectrumTable.getColumn("  ").getModelIndex());
        }
        this.validateInput(false);
    }

    private void selectAllLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void selectAllLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void deselectAllLabelMouseClicked(MouseEvent evt) {
        for (int i = 0; i < this.spectrumTable.getRowCount(); ++i) {
            this.spectrumTable.setValueAt(false, i, this.spectrumTable.getColumn("  ").getModelIndex());
        }
        this.validateInput(false);
    }

    private void deselectAllLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void deselectAllLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void databaseSettingsLblMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL((String)"https://compomics.github.io/projects/searchgui/wiki/DatabaseHelp.html");
        this.setCursor(new Cursor(0));
    }

    private void databaseSettingsLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void databaseSettingsLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void downloadUniProtJLabelMouseClicked(MouseEvent evt) {
        if (this.downloadUniProtJLabel.isEnabled()) {
            String tempSpecies = this.speciesJTextField.getText().trim();
            String[] allSpecies = tempSpecies.split(", ");
            boolean combinedSearch = true;
            if (allSpecies.length > 1) {
                int option = JOptionPane.showConfirmDialog(this, "You have multiple species. Combine into one UniProt search?\nChoosing 'No' will open one UniProt web page per species.", "Multiple Species", 1);
                if (option == 2 || option == -1) {
                    return;
                }
                combinedSearch = option == 0;
            }
            String link = "https://www.uniprot.org/uniprot/?query=";
            for (int i = 0; i < allSpecies.length; ++i) {
                String species = allSpecies[i];
                if (species.endsWith(")")) {
                    species = species.substring(0, species.indexOf("(")).trim();
                }
                species = species.replaceAll(" ", "%20");
                if (combinedSearch) {
                    if (i > 0) {
                        link = link + "+OR+";
                    }
                    link = link + "organism%3A%22" + species + "%22";
                    continue;
                }
                link = "https://www.uniprot.org/uniprot/?query=organism%3A%22" + species + "%22&sort=score";
                this.setCursor(new Cursor(3));
                BareBonesBrowserLaunch.openURL((String)link);
                this.setCursor(new Cursor(0));
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (combinedSearch) {
                link = link + "&sort=score";
                this.setCursor(new Cursor(3));
                BareBonesBrowserLaunch.openURL((String)link);
                this.setCursor(new Cursor(0));
            }
        }
    }

    public boolean validateInput(boolean showMessage) {
        boolean valid = true;
        if (this.databaseSettingsTxt.getText() == null || this.databaseSettingsTxt.getText().trim().isEmpty()) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a search database.", "Search Database Not Found", 2);
            }
            valid = false;
        } else {
            File test = new File(this.databaseSettingsTxt.getText().trim());
            if (!test.exists()) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "The database file could not be found.", "Search Database Not Found", 2);
                }
                valid = false;
            }
        }
        if (this.workingFolderTxt.getText().trim().isEmpty()) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a working folder.", "Working Folder", 2);
            }
            valid = false;
        }
        int spectrumCounter = 0;
        for (int i = 0; i < this.spectrumTable.getRowCount() && spectrumCounter == 0; ++i) {
            if (!((Boolean)this.spectrumTable.getValueAt(i, this.spectrumTable.getColumn("  ").getModelIndex())).booleanValue()) continue;
            ++spectrumCounter;
        }
        if (spectrumCounter == 0) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to select at least one specturm file.", "Spectrum Files", 2);
            }
            valid = false;
        }
        int searchSettingsCount = 0;
        for (int i = 0; i < this.searchSettingsTable.getRowCount(); ++i) {
            if (!((Boolean)this.searchSettingsTable.getValueAt(i, this.searchSettingsTable.getColumn("  ").getModelIndex())).booleanValue()) continue;
            ++searchSettingsCount;
        }
        if (searchSettingsCount > 1) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You can only select one file to extract seach settings from.", "Search Settings Error", 2);
            }
            valid = false;
        }
        this.reshakeButton.setEnabled(valid);
        return valid;
    }

    public boolean editProteoWizardInstallation() {
        boolean canceled = false;
        try {
            ProteoWizardSetupDialog proteoWizardSetupDialog = new ProteoWizardSetupDialog((JDialog)this, true);
            canceled = proteoWizardSetupDialog.isDialogCanceled();
            if (!canceled) {
                try {
                    this.prideReShakeGUI.getPeptideShakerGUI().setUtilitiesUserParameters(UtilitiesUserParameters.loadUserParameters());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "An error occurred when reading the user preferences.", "File Error", 0);
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return !canceled;
    }
}

