/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.tablemodels;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.gui.tablemodels.SelfUpdatingTableModel;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.utils.DisplayFeaturesGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import no.uib.jsparklines.data.ArrrayListDataPoints;
import no.uib.jsparklines.data.StartIndexes;
import no.uib.jsparklines.renderers.JSparklinesArrayListBarChartTableCellRenderer;

public class PeptideTableModel
extends SelfUpdatingTableModel {
    private Identification identification;
    private IdentificationFeaturesGenerator identificationFeaturesGenerator;
    private DisplayFeaturesGenerator displayFeaturesGenerator;
    private final ExceptionHandler exceptionHandler;
    private long[] peptideKeys = null;
    private String proteinAccession;
    private boolean showScores = false;

    public PeptideTableModel() {
        this.identification = null;
        this.identificationFeaturesGenerator = null;
        this.displayFeaturesGenerator = null;
        this.peptideKeys = new long[0];
        this.proteinAccession = null;
        this.showScores = false;
        this.exceptionHandler = null;
    }

    public PeptideTableModel(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, DisplayFeaturesGenerator displayFeaturesGenerator, String proteinAccession, long[] peptideKeys, boolean displayScores, ExceptionHandler exceptionHandler) {
        this.identification = identification;
        this.identificationFeaturesGenerator = identificationFeaturesGenerator;
        this.displayFeaturesGenerator = displayFeaturesGenerator;
        this.peptideKeys = peptideKeys;
        this.proteinAccession = proteinAccession;
        this.showScores = displayScores;
        this.exceptionHandler = exceptionHandler;
    }

    public void updateDataModel(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, DisplayFeaturesGenerator displayFeaturesGenerator, String proteinAccession, long[] peptideKeys) {
        this.identification = identification;
        this.identificationFeaturesGenerator = identificationFeaturesGenerator;
        this.displayFeaturesGenerator = displayFeaturesGenerator;
        this.peptideKeys = peptideKeys;
        this.proteinAccession = proteinAccession;
    }

    public void showScores(boolean showScores) {
        this.showScores = showScores;
    }

    public void reset() {
        this.peptideKeys = null;
    }

    public int getRowCount() {
        return this.peptideKeys == null ? 0 : this.peptideKeys.length;
    }

    public int getColumnCount() {
        return 8;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return " ";
            }
            case 1: {
                return "  ";
            }
            case 2: {
                return "PI";
            }
            case 3: {
                return "Sequence";
            }
            case 4: {
                return "Start";
            }
            case 5: {
                return "#Spectra";
            }
            case 6: {
                return this.showScores ? "Score" : "Confidence";
            }
            case 7: {
                return "";
            }
        }
        return "";
    }

    public Object getValueAt(int row, int column) {
        int viewIndex = this.getViewIndex(row);
        if (viewIndex < this.peptideKeys.length) {
            if (column == 0) {
                return viewIndex + 1;
            }
            long peptideKey = this.peptideKeys[viewIndex];
            PeptideMatch peptideMatch = this.identification.getPeptideMatch(peptideKey);
            switch (column) {
                case 1: {
                    PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                    return psParameter.getStarred();
                }
                case 2: {
                    PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                    return psParameter.getProteinInferenceGroupClass();
                }
                case 3: {
                    return this.displayFeaturesGenerator.getTaggedPeptideSequence(peptideMatch, true, true, true);
                }
                case 4: {
                    int[] startIndexes = (int[])peptideMatch.getPeptide().getProteinMapping().get(this.proteinAccession);
                    return new StartIndexes(Arrays.stream(startIndexes).map(site -> site + 1).boxed().collect(Collectors.toCollection(ArrayList::new)));
                }
                case 5: {
                    double nConfidentSpectra = this.identificationFeaturesGenerator.getNConfidentSpectraForPeptide(peptideKey);
                    double nDoubtfulSpectra = (double)this.identificationFeaturesGenerator.getNValidatedSpectraForPeptide(peptideKey) - nConfidentSpectra;
                    int nSpectra = peptideMatch.getSpectrumMatchesKeys().length;
                    ArrayList<Double> doubleValues = new ArrayList<Double>(3);
                    doubleValues.add(nConfidentSpectra);
                    doubleValues.add(nDoubtfulSpectra);
                    doubleValues.add((double)nSpectra - nConfidentSpectra - nDoubtfulSpectra);
                    ArrrayListDataPoints arrrayListDataPoints = new ArrrayListDataPoints(doubleValues, JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType.sumOfNumbers);
                    return arrrayListDataPoints;
                }
                case 6: {
                    PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                    return this.showScores ? psParameter.getTransformedScore() : psParameter.getConfidence();
                }
                case 7: {
                    PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                    return psParameter.getMatchValidationLevel().getIndex();
                }
            }
            return null;
        }
        return null;
    }

    public boolean isInstantiated() {
        return this.identification != null;
    }

    public Class getColumnClass(int columnIndex) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, columnIndex) == null) continue;
            return this.getValueAt(i, columnIndex).getClass();
        }
        return String.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    protected void catchException(Exception e) {
        this.setSelfUpdating(false);
        this.exceptionHandler.catchException(e);
    }

    protected int loadDataForRows(ArrayList<Integer> rows, WaitingHandler waitingHandler) {
        boolean canceled = rows.parallelStream().map(i -> this.identification.getPeptideMatch(this.peptideKeys[i])).map(peptideMatch -> this.identificationFeaturesGenerator.getNValidatedSpectraForPeptide(peptideMatch.getKey())).anyMatch(dummy -> waitingHandler.isRunCanceled());
        return canceled ? rows.get(0) : rows.get(rows.size() - 1);
    }
}

