/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.tablemodels;

import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.utils.ProteinUtils;
import com.compomics.util.experiment.personalization.UrParameter;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;

public class ProteinFractionTableModel
extends DefaultTableModel {
    private PeptideShakerGUI peptideShakerGUI;
    private Identification identification;
    private long[] proteinKeys = null;
    private ArrayList<String> fileNames = new ArrayList();
    private boolean modelInitiated = false;

    public ProteinFractionTableModel(PeptideShakerGUI peptideShakerGUI) {
        this.setUpTableModel(peptideShakerGUI);
        this.modelInitiated = true;
    }

    public ProteinFractionTableModel() {
    }

    public void updateDataModel(PeptideShakerGUI peptideShakerGUI) {
        this.setUpTableModel(peptideShakerGUI);
    }

    private void setUpTableModel(PeptideShakerGUI peptideShakerGUI) {
        this.peptideShakerGUI = peptideShakerGUI;
        this.identification = peptideShakerGUI.getIdentification();
        this.fileNames = new ArrayList();
        if (this.identification != null) {
            this.proteinKeys = peptideShakerGUI.getDisplayParameters().showValidatedProteinsOnly() ? peptideShakerGUI.getIdentificationFeaturesGenerator().getValidatedProteins(peptideShakerGUI.getFilterParameters()) : peptideShakerGUI.getIdentificationFeaturesGenerator().getProcessedProteinKeys(null, peptideShakerGUI.getFilterParameters(), false);
            for (String spectrumFileName : this.identification.getFractions()) {
                this.fileNames.add(spectrumFileName);
            }
        }
    }

    public void reset() {
        this.proteinKeys = null;
    }

    @Override
    public int getRowCount() {
        return this.proteinKeys == null ? 0 : this.proteinKeys.length;
    }

    @Override
    public int getColumnCount() {
        return this.fileNames.size() + 6;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return " ";
        }
        if (column == 1) {
            return "Accession";
        }
        if (column == 2) {
            return "Description";
        }
        if (column > 2 && column - 3 < this.fileNames.size()) {
            return this.fileNames.get(column - 3);
        }
        if (column == this.fileNames.size() + 3) {
            return "MW";
        }
        if (column == this.fileNames.size() + 4) {
            return "Confidence";
        }
        if (column == this.fileNames.size() + 5) {
            return "  ";
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int column) {
        ProteinMatch proteinMatch = this.identification.getProteinMatch(this.proteinKeys[row]);
        if (column == 0) {
            return row + 1;
        }
        if (column == 1) {
            return this.peptideShakerGUI.getDisplayFeaturesGenerator().getDatabaseLink(proteinMatch.getLeadingAccession());
        }
        if (column == 2) {
            return this.peptideShakerGUI.getProteinDetailsProvider().getSimpleDescription(proteinMatch.getLeadingAccession());
        }
        if (column > 2 && column - 3 < this.fileNames.size()) {
            String fraction = this.fileNames.get(column - 3);
            PSParameter psParameter = new PSParameter();
            if ((psParameter = (PSParameter)proteinMatch.getUrParam((UrParameter)psParameter)).getFractionScore() != null && psParameter.getFractions().contains(fraction)) {
                return psParameter.getFractionConfidence(fraction);
            }
            return 0.0;
        }
        if (column == this.fileNames.size() + 3) {
            String mainMatch = proteinMatch.getLeadingAccession();
            ProteinUtils.computeMolecularWeight((String)this.peptideShakerGUI.getSequenceProvider().getSequence(mainMatch));
        } else {
            if (column == this.fileNames.size() + 4) {
                PSParameter psParameter = (PSParameter)proteinMatch.getUrParam((UrParameter)PSParameter.dummy);
                return psParameter.getConfidence();
            }
            if (column == this.fileNames.size() + 5) {
                PSParameter psParameter = (PSParameter)proteinMatch.getUrParam((UrParameter)PSParameter.dummy);
                psParameter = (PSParameter)proteinMatch.getUrParam((UrParameter)psParameter);
                return psParameter.getMatchValidationLevel().getIndex();
            }
        }
        return "";
    }

    public Class getColumnClass(int columnIndex) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, columnIndex) == null) continue;
            return this.getValueAt(i, columnIndex).getClass();
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public boolean isModelInitiated() {
        return this.modelInitiated;
    }

    public void setModelInitiated(boolean modelInitiated) {
        this.modelInitiated = modelInitiated;
    }
}

