/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.tablemodels;

import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.personalization.UrParameter;
import eu.isas.peptideshaker.utils.DisplayFeaturesGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.DefaultTableModel;
import no.uib.jsparklines.data.ArrrayListDataPoints;
import no.uib.jsparklines.renderers.JSparklinesArrayListBarChartTableCellRenderer;

public class ProteinGoTableModel
extends DefaultTableModel {
    private final Identification identification;
    private final ProteinDetailsProvider proteinDetailsProvider;
    private final IdentificationFeaturesGenerator identificationFeaturesGenerator;
    private final DisplayFeaturesGenerator displayFeaturesGenerator;
    private boolean showScores = true;
    private ArrayList<Long> proteinGroupKeys = null;

    public ProteinGoTableModel(Identification identification, ProteinDetailsProvider proteinDetailsProvider, IdentificationFeaturesGenerator identificationFeaturesGenerator, DisplayFeaturesGenerator displayFeaturesGenerator, ArrayList<Long> proteinGroupKeys, boolean showScores) {
        this.identification = identification;
        this.proteinDetailsProvider = proteinDetailsProvider;
        this.identificationFeaturesGenerator = identificationFeaturesGenerator;
        this.displayFeaturesGenerator = displayFeaturesGenerator;
        this.proteinGroupKeys = proteinGroupKeys;
        this.showScores = showScores;
    }

    public void updateDataModel(ArrayList<Long> proteinGroupKeys) {
        this.proteinGroupKeys = proteinGroupKeys;
    }

    public void reset() {
        this.proteinGroupKeys = null;
    }

    @Override
    public int getRowCount() {
        return this.proteinGroupKeys == null ? 0 : this.proteinGroupKeys.size();
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return " ";
            }
            case 1: {
                return "Accession";
            }
            case 2: {
                return "Description";
            }
            case 3: {
                return "Coverage";
            }
            case 4: {
                return "#Peptides";
            }
            case 5: {
                return "#Spectra";
            }
            case 6: {
                return "MS2 Quant.";
            }
            case 7: {
                return this.showScores ? "Score" : "Confidence";
            }
            case 8: {
                return "  ";
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int column) {
        long proteinGroupKey = this.proteinGroupKeys.get(row);
        ProteinMatch proteinMatch = this.identification.getProteinMatch(proteinGroupKey);
        switch (column) {
            case 0: {
                return row + 1;
            }
            case 1: {
                String mainMatch = proteinMatch.getLeadingAccession();
                return this.displayFeaturesGenerator.getDatabaseLink(mainMatch);
            }
            case 2: {
                return this.proteinDetailsProvider.getSimpleDescription(proteinMatch.getLeadingAccession());
            }
            case 3: {
                HashMap sequenceCoverage = this.identificationFeaturesGenerator.getSequenceCoverage(proteinGroupKey);
                Double sequenceCoverageConfident = 100.0 * (Double)sequenceCoverage.get(MatchValidationLevel.confident.getIndex());
                Double sequenceCoverageDoubtful = 100.0 * (Double)sequenceCoverage.get(MatchValidationLevel.doubtful.getIndex());
                Double sequenceCoverageNotValidated = 100.0 * (Double)sequenceCoverage.get(MatchValidationLevel.not_validated.getIndex());
                double possibleCoverage = 100.0 * this.identificationFeaturesGenerator.getObservableCoverage(proteinGroupKey);
                ArrayList<Double> doubleValues = new ArrayList<Double>(4);
                doubleValues.add(sequenceCoverageConfident);
                doubleValues.add(sequenceCoverageDoubtful);
                doubleValues.add(sequenceCoverageNotValidated);
                doubleValues.add(possibleCoverage - sequenceCoverageConfident - sequenceCoverageDoubtful - sequenceCoverageNotValidated);
                ArrrayListDataPoints arrrayListDataPoints = new ArrrayListDataPoints(doubleValues, JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType.sumExceptLastNumber);
                return arrrayListDataPoints;
            }
            case 4: {
                double nConfidentPeptides = this.identificationFeaturesGenerator.getNConfidentPeptides(proteinGroupKey);
                double nDoubtfulPeptides = (double)this.identificationFeaturesGenerator.getNValidatedPeptides(proteinGroupKey) - nConfidentPeptides;
                ArrayList<Double> doubleValues = new ArrayList<Double>(3);
                doubleValues.add(nConfidentPeptides);
                doubleValues.add(nDoubtfulPeptides);
                doubleValues.add((double)proteinMatch.getPeptideCount() - nConfidentPeptides - nDoubtfulPeptides);
                ArrrayListDataPoints arrrayListDataPoints = new ArrrayListDataPoints(doubleValues, JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType.sumOfNumbers);
                return arrrayListDataPoints;
            }
            case 5: {
                double nConfidentSpectra = this.identificationFeaturesGenerator.getNConfidentSpectra(proteinGroupKey);
                double nDoubtfulSpectra = (double)this.identificationFeaturesGenerator.getNValidatedSpectra(proteinGroupKey) - nConfidentSpectra;
                int nSpectra = this.identificationFeaturesGenerator.getNSpectra(proteinGroupKey);
                ArrayList<Double> doubleValues = new ArrayList<Double>(3);
                doubleValues.add(nConfidentSpectra);
                doubleValues.add(nDoubtfulSpectra);
                doubleValues.add((double)nSpectra - nConfidentSpectra - nDoubtfulSpectra);
                ArrrayListDataPoints arrrayListDataPoints = new ArrrayListDataPoints(doubleValues, JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType.sumOfNumbers);
                return arrrayListDataPoints;
            }
            case 6: {
                return this.identificationFeaturesGenerator.getSpectrumCounting(proteinGroupKey);
            }
            case 7: {
                PSParameter psParameter = (PSParameter)proteinMatch.getUrParam((UrParameter)PSParameter.dummy);
                return this.showScores ? psParameter.getTransformedScore() : psParameter.getConfidence();
            }
            case 8: {
                PSParameter psParameter = (PSParameter)proteinMatch.getUrParam((UrParameter)PSParameter.dummy);
                return psParameter.getMatchValidationLevel().getIndex();
            }
        }
        return "";
    }

    public Class getColumnClass(int columnIndex) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, columnIndex) == null) continue;
            return this.getValueAt(i, columnIndex).getClass();
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public ArrayList<Long> getProteins() {
        return this.proteinGroupKeys;
    }
}

