/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.tabpanels;

import com.compomics.util.ArrayUtil;
import com.compomics.util.Util;
import com.compomics.util.experiment.biology.ions.Charge;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.PeptideMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.ModificationScoring;
import com.compomics.util.experiment.identification.peptide_shaker.PSModificationScores;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.utils.ModificationUtils;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.gui.TableProperties;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.export.graphics.ExportGraphicsDialog;
import com.compomics.util.gui.protein.ModificationProfile;
import com.compomics.util.gui.protein.SequenceModificationPanel;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.gui.ModificationSiteInferenceDialog;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.gui.protein_inference.ProteinInferencePeptideLevelDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.TrueFalseIconRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesColorTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerColorTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerIconTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntervalChartTableCellRenderer;
import no.uib.jsparklines.renderers.util.GradientColorCoding;
import org.jfree.chart.plot.PlotOrientation;

public class ModificationsPanel
extends JPanel {
    private ProgressDialogX progressDialog;
    private int currentModificationRow = -1;
    private ArrayList<String> selectedPeptidesTableToolTips;
    private ArrayList<String> relatedPeptidesTableToolTips;
    private ArrayList<String> selectedPsmsTableToolTips;
    private ArrayList<String> relatedPsmsTableToolTips;
    private ArrayList<String> modificationTableToolTips;
    private final PeptideShakerGUI peptideShakerGUI;
    private final HashMap<String, HashSet<Long>> peptideMap = new HashMap();
    public static final String NO_MODIFICATION = "No modifications";
    private Identification identification;
    private ArrayList<Long> displayedPeptides = new ArrayList();
    private ArrayList<Long> relatedPeptides = new ArrayList();
    private boolean relatedSelected = false;
    private SpectrumPanel spectrumPanel;
    private HashMap<Integer, String> proteinInferenceTooltipMap;
    private HashMap<Integer, String> modificationConfidenceTooltipMap;
    private final ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private JPanel aScoreGradientPanel;
    private JLabel aScoreMaxValueJLabel;
    private JLabel aScoreMinValueJLabel;
    private JSlider accuracySlider;
    private JPanel contextMenuModPsmsBackgroundPanel;
    private JPanel contextMenuModificationBackgroundPanel;
    private JPanel contextMenuModifiedPeptidesBackgroundPanel;
    private JPanel contextMenuRelatedPeptidesBackgroundPanel;
    private JPanel contextMenuRelatedPsmsBackgroundPanel;
    private JPanel contextMenuSpectrumBackgroundPanel;
    private JPanel deltaScoreGradientPanel;
    private JLabel deltaScoreMaxValueJLabel;
    private JLabel deltaScoreMinValueJLabel;
    private JButton exportModifiedPeptideProfileJButton;
    private JButton exportModifiedPsmsJButton;
    private JButton exportRelatedPeptideProfileJButton;
    private JButton exportRelatedPsmsJButton;
    private JButton exportSpectrumJButton;
    private JSlider intensitySlider;
    private JPanel modPsmsPanel;
    private JPanel modificationAndPeptideSelectionPanel;
    private JScrollPane modificationJScrollPane;
    private JTable modificationJTable;
    private JLayeredPane modificationLayeredLayeredPane;
    private JPanel modificationLayeredPanel;
    private JPanel modificationPanel;
    private JButton modificationProfileHelpJButton;
    private JPanel modificationProfileRelatedPeptideJPanel;
    private JPanel modificationProfileSelectedPeptideJPanel;
    private JButton modificationSelectionHelpJButton;
    private JLayeredPane modifiedPeptidesLayeredPane;
    private JPanel modifiedPeptidesPanel;
    private JButton modifiedPsmsHelpJButton;
    private JPanel modsPsmsLayeredPanel;
    private JSplitPane peptideTablesJSplitPane;
    private JTable peptidesTable;
    private JScrollPane peptidesTableJScrollPane;
    private JPanel psmAScoresJPanel;
    private JScrollPane psmAScoresScrollPane;
    private JTable psmAScoresTable;
    private JPanel psmDeltaScoresJPanel;
    private JTable psmDeltaScoresTable;
    private JScrollPane psmDeltaScrollPane;
    private JSplitPane psmSpectraSplitPane;
    private JSplitPane psmSplitPane;
    private JLayeredPane psmsModPeptidesLayeredPane;
    private JScrollPane psmsModifiedTableJScrollPane;
    private JLayeredPane psmsRelatedPeptidesJLayeredPane;
    private JScrollPane psmsRelatedTableJScrollPane;
    private JPanel relatedPeptidesJPanel;
    private JSplitPane relatedPeptidesJSplitPane;
    private JPanel relatedPeptidesPanel;
    private JTable relatedPeptidesTable;
    private JScrollPane relatedPeptidesTableJScrollPane;
    private JLayeredPane relatedPeptiesLayeredPane;
    private JButton relatedProfileHelpJButton;
    private JButton relatedPsmsHelpJButton;
    private JPanel relatedPsmsJPanel;
    private JPanel relatedPsmsPanel;
    private JTable relatedPsmsTable;
    private JPanel selectedPeptidesJPanel;
    private JSplitPane selectedPeptidesJSplitPane;
    private JTable selectedPsmsTable;
    private JPanel sliderPanel;
    private JSplitPane slidersSplitPane;
    private JPanel spectrumAndFragmentIonJPanel;
    private JPanel spectrumAndFragmentIonPanel;
    private JPanel spectrumAnnotationMenuPanel;
    private JPanel spectrumChartJPanel;
    private JButton spectrumHelpJButton;
    private JPanel spectrumJPanel;
    private JToolBar spectrumJToolBar;
    private JLayeredPane spectrumLayeredPane;
    private JTabbedPane spectrumTabbedPane;

    public ModificationsPanel(PeptideShakerGUI peptideShakerGUI) {
        this.peptideShakerGUI = peptideShakerGUI;
        this.initComponents();
        this.addGradientScoreColors();
        this.modificationJTable.setAutoCreateRowSorter(true);
        this.peptidesTable.setAutoCreateRowSorter(true);
        this.relatedPeptidesTable.setAutoCreateRowSorter(true);
        this.selectedPsmsTable.setAutoCreateRowSorter(true);
        this.relatedPsmsTable.setAutoCreateRowSorter(true);
        this.relatedPeptidesTableJScrollPane.getViewport().setOpaque(false);
        this.psmsModifiedTableJScrollPane.getViewport().setOpaque(false);
        this.psmsRelatedTableJScrollPane.getViewport().setOpaque(false);
        this.peptidesTableJScrollPane.getViewport().setOpaque(false);
        this.modificationJScrollPane.getViewport().setOpaque(false);
        this.psmAScoresScrollPane.getViewport().setOpaque(false);
        this.psmDeltaScrollPane.getViewport().setOpaque(false);
        this.setTableProperties();
        this.spectrumTabbedPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.updateSeparators();
        this.formComponentResized(null);
    }

    private void addGradientScoreColors() {
        final Color startColor = Color.WHITE;
        final Color endColor = Color.BLUE;
        JPanel deltaScoreGradientJPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics grphcs) {
                Graphics2D g2d = (Graphics2D)grphcs;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                GradientPaint gp = new GradientPaint(0.0f, (float)this.getHeight() / 2.0f, startColor, this.getWidth(), (float)this.getHeight() / 2.0f, endColor);
                g2d.setPaint(gp);
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(grphcs);
            }
        };
        deltaScoreGradientJPanel.setOpaque(false);
        this.deltaScoreGradientPanel.add(deltaScoreGradientJPanel);
        JPanel aScoreGradientJPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics grphcs) {
                Graphics2D g2d = (Graphics2D)grphcs;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                GradientPaint gp = new GradientPaint(0.0f, (float)this.getHeight() / 2.0f, startColor, this.getWidth(), (float)this.getHeight() / 2.0f, endColor);
                g2d.setPaint(gp);
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(grphcs);
            }
        };
        aScoreGradientJPanel.setOpaque(false);
        this.aScoreGradientPanel.add(aScoreGradientJPanel);
    }

    private void setTableProperties() {
        JPanel modificationCorner = new JPanel();
        modificationCorner.setBackground(this.modificationJTable.getTableHeader().getBackground());
        this.modificationJScrollPane.setCorner("UPPER_RIGHT_CORNER", modificationCorner);
        JPanel modifiedPeptidesCorner = new JPanel();
        modifiedPeptidesCorner.setBackground(this.peptidesTable.getTableHeader().getBackground());
        this.peptidesTableJScrollPane.setCorner("UPPER_RIGHT_CORNER", modifiedPeptidesCorner);
        JPanel relatedPeptidesCorner = new JPanel();
        relatedPeptidesCorner.setBackground(this.relatedPeptidesTable.getTableHeader().getBackground());
        this.relatedPeptidesTableJScrollPane.setCorner("UPPER_RIGHT_CORNER", relatedPeptidesCorner);
        JPanel psmMatchesCorner = new JPanel();
        psmMatchesCorner.setBackground(this.selectedPsmsTable.getTableHeader().getBackground());
        this.psmsModifiedTableJScrollPane.setCorner("UPPER_RIGHT_CORNER", psmMatchesCorner);
        JPanel psmRelatedMatchesCorner = new JPanel();
        psmRelatedMatchesCorner.setBackground(this.relatedPsmsTable.getTableHeader().getBackground());
        this.psmsRelatedTableJScrollPane.setCorner("UPPER_RIGHT_CORNER", psmRelatedMatchesCorner);
        JPanel aScoreTableCorner = new JPanel();
        aScoreTableCorner.setBackground(this.relatedPsmsTable.getTableHeader().getBackground());
        this.psmAScoresScrollPane.setCorner("UPPER_RIGHT_CORNER", aScoreTableCorner);
        JPanel deltaScoreTableCorner = new JPanel();
        deltaScoreTableCorner.setBackground(this.relatedPsmsTable.getTableHeader().getBackground());
        this.psmDeltaScrollPane.setCorner("UPPER_RIGHT_CORNER", deltaScoreTableCorner);
        this.modificationJTable.getColumn("  ").setMaxWidth(35);
        this.modificationJTable.getColumn("  ").setMinWidth(35);
        this.modificationJTable.getColumn("#").setMaxWidth(50);
        this.modificationJTable.getColumn("#").setMinWidth(50);
        this.peptidesTable.getColumn("   ").setMaxWidth(30);
        this.peptidesTable.getColumn("   ").setMinWidth(30);
        this.peptidesTable.getColumn(" ").setMaxWidth(45);
        this.peptidesTable.getColumn(" ").setMinWidth(45);
        this.peptidesTable.getColumn("Modification").setMaxWidth(45);
        this.peptidesTable.getColumn("Modification").setMinWidth(45);
        this.peptidesTable.getColumn("  ").setMaxWidth(30);
        this.peptidesTable.getColumn("  ").setMinWidth(30);
        this.peptidesTable.getColumn("PI").setMaxWidth(37);
        this.peptidesTable.getColumn("PI").setMinWidth(37);
        this.peptidesTable.getColumn("Peptide").setMaxWidth(80);
        this.peptidesTable.getColumn("Peptide").setMinWidth(80);
        this.relatedPeptidesTable.getColumn("   ").setMaxWidth(30);
        this.relatedPeptidesTable.getColumn("   ").setMinWidth(30);
        this.relatedPeptidesTable.getColumn(" ").setMaxWidth(45);
        this.relatedPeptidesTable.getColumn(" ").setMinWidth(45);
        this.relatedPeptidesTable.getColumn("PI").setMaxWidth(37);
        this.relatedPeptidesTable.getColumn("PI").setMinWidth(37);
        this.relatedPeptidesTable.getColumn("  ").setMaxWidth(30);
        this.relatedPeptidesTable.getColumn("  ").setMinWidth(30);
        this.relatedPeptidesTable.getColumn("Modification").setMaxWidth(45);
        this.relatedPeptidesTable.getColumn("Modification").setMinWidth(45);
        this.relatedPeptidesTable.getColumn("Peptide").setMaxWidth(80);
        this.relatedPeptidesTable.getColumn("Peptide").setMinWidth(80);
        this.selectedPsmsTable.getColumn("   ").setMaxWidth(30);
        this.selectedPsmsTable.getColumn("   ").setMinWidth(30);
        this.selectedPsmsTable.getColumn(" ").setMaxWidth(45);
        this.selectedPsmsTable.getColumn(" ").setMinWidth(45);
        this.selectedPsmsTable.getColumn("Modification").setMaxWidth(45);
        this.selectedPsmsTable.getColumn("Modification").setMinWidth(45);
        this.selectedPsmsTable.getColumn("Charge").setMaxWidth(90);
        this.selectedPsmsTable.getColumn("Charge").setMinWidth(90);
        this.selectedPsmsTable.getColumn("  ").setMaxWidth(30);
        this.selectedPsmsTable.getColumn("  ").setMinWidth(30);
        this.relatedPsmsTable.getColumn("   ").setMaxWidth(30);
        this.relatedPsmsTable.getColumn("   ").setMinWidth(30);
        this.relatedPsmsTable.getColumn(" ").setMaxWidth(45);
        this.relatedPsmsTable.getColumn(" ").setMinWidth(45);
        this.relatedPsmsTable.getColumn("Modification").setMaxWidth(45);
        this.relatedPsmsTable.getColumn("Modification").setMinWidth(45);
        this.relatedPsmsTable.getColumn("Charge").setMaxWidth(90);
        this.relatedPsmsTable.getColumn("Charge").setMinWidth(90);
        this.relatedPsmsTable.getColumn("  ").setMaxWidth(30);
        this.relatedPsmsTable.getColumn("  ").setMinWidth(30);
        this.peptidesTable.getTableHeader().setReorderingAllowed(false);
        this.relatedPeptidesTable.getTableHeader().setReorderingAllowed(false);
        this.selectedPsmsTable.getTableHeader().setReorderingAllowed(false);
        this.relatedPsmsTable.getTableHeader().setReorderingAllowed(false);
        this.psmAScoresTable.getTableHeader().setReorderingAllowed(false);
        this.psmDeltaScoresTable.getTableHeader().setReorderingAllowed(false);
        TableCellRenderer renderer = this.psmAScoresTable.getTableHeader().getDefaultRenderer();
        JLabel label = (JLabel)((Object)renderer);
        label.setHorizontalAlignment(0);
        renderer = this.psmDeltaScoresTable.getTableHeader().getDefaultRenderer();
        label = (JLabel)((Object)renderer);
        label.setHorizontalAlignment(0);
        HashMap<Integer, Color> proteinInferenceColorMap = new HashMap<Integer, Color>();
        proteinInferenceColorMap.put(0, this.peptideShakerGUI.getSparklineColor());
        proteinInferenceColorMap.put(1, Color.YELLOW);
        proteinInferenceColorMap.put(2, Color.ORANGE);
        proteinInferenceColorMap.put(3, Color.RED);
        this.proteinInferenceTooltipMap = new HashMap();
        this.proteinInferenceTooltipMap.put(0, "Unique to a single protein");
        this.proteinInferenceTooltipMap.put(1, "Belongs to a group of related proteins");
        this.proteinInferenceTooltipMap.put(2, "Belongs to a group of related and unrelated proteins");
        this.proteinInferenceTooltipMap.put(3, "Belongs to unrelated proteins");
        this.peptidesTable.getColumn("PI").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.lightGray, proteinInferenceColorMap, this.proteinInferenceTooltipMap));
        this.relatedPeptidesTable.getColumn("PI").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.lightGray, proteinInferenceColorMap, this.proteinInferenceTooltipMap));
        this.peptidesTable.getColumn("   ").setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/star_yellow.png")), new ImageIcon(this.getClass().getResource("/icons/star_grey.png")), new ImageIcon(this.getClass().getResource("/icons/star_grey.png")), "Starred", null, null));
        this.relatedPeptidesTable.getColumn("   ").setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/star_yellow.png")), new ImageIcon(this.getClass().getResource("/icons/star_grey.png")), new ImageIcon(this.getClass().getResource("/icons/star_grey.png")), "Starred", null, null));
        HashMap<Integer, Color> modificationConfidenceColorMap = new HashMap<Integer, Color>();
        modificationConfidenceColorMap.put(-1, Color.lightGray);
        modificationConfidenceColorMap.put(0, Color.RED);
        modificationConfidenceColorMap.put(1, Color.ORANGE);
        modificationConfidenceColorMap.put(2, Color.YELLOW);
        modificationConfidenceColorMap.put(3, this.peptideShakerGUI.getSparklineColor());
        this.modificationConfidenceTooltipMap = new HashMap();
        this.modificationConfidenceTooltipMap.put(-1, "(No Modifications)");
        this.modificationConfidenceTooltipMap.put(0, "Random Assignment");
        this.modificationConfidenceTooltipMap.put(1, "Doubtful Assignment");
        this.modificationConfidenceTooltipMap.put(2, "Confident Assignment");
        this.modificationConfidenceTooltipMap.put(3, "Very Confident Assignment");
        this.peptidesTable.getColumn("Modification").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.lightGray, modificationConfidenceColorMap, this.modificationConfidenceTooltipMap));
        this.relatedPeptidesTable.getColumn("Modification").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.lightGray, modificationConfidenceColorMap, this.modificationConfidenceTooltipMap));
        this.selectedPsmsTable.getColumn("Modification").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.lightGray, modificationConfidenceColorMap, this.modificationConfidenceTooltipMap));
        this.relatedPsmsTable.getColumn("Modification").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.lightGray, modificationConfidenceColorMap, this.modificationConfidenceTooltipMap));
        this.peptidesTable.getColumn("Peptide").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.peptidesTable.getColumn("Peptide").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 20, this.peptideShakerGUI.getScoreAndConfidenceDecimalFormat());
        this.peptidesTable.getColumn("  ").setCellRenderer((TableCellRenderer)new JSparklinesIntegerIconTableCellRenderer(MatchValidationLevel.getIconMap(this.getClass()), MatchValidationLevel.getTooltipMap()));
        this.relatedPeptidesTable.getColumn("Peptide").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.relatedPeptidesTable.getColumn("Peptide").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 20, this.peptideShakerGUI.getScoreAndConfidenceDecimalFormat());
        this.relatedPeptidesTable.getColumn("  ").setCellRenderer((TableCellRenderer)new JSparklinesIntegerIconTableCellRenderer(MatchValidationLevel.getIconMap(this.getClass()), MatchValidationLevel.getTooltipMap()));
        this.selectedPsmsTable.getColumn("Charge").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(10.0), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.selectedPsmsTable.getColumn("Charge").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 30);
        this.selectedPsmsTable.getColumn("  ").setCellRenderer((TableCellRenderer)new JSparklinesIntegerIconTableCellRenderer(MatchValidationLevel.getIconMap(this.getClass()), MatchValidationLevel.getTooltipMap()));
        this.selectedPsmsTable.getColumn("RT").setCellRenderer((TableCellRenderer)new JSparklinesIntervalChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(0.0), Double.valueOf(1000.0), Double.valueOf(10.0), this.peptideShakerGUI.getSparklineColor(), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesIntervalChartTableCellRenderer)this.selectedPsmsTable.getColumn("RT").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() + 5);
        ((JSparklinesIntervalChartTableCellRenderer)this.selectedPsmsTable.getColumn("RT").getCellRenderer()).showReferenceLine(true, 0.02, Color.BLACK);
        this.selectedPsmsTable.getColumn("   ").setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/star_yellow.png")), new ImageIcon(this.getClass().getResource("/icons/star_grey.png")), new ImageIcon(this.getClass().getResource("/icons/star_grey.png")), "Starred", null, null));
        this.relatedPsmsTable.getColumn("Charge").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(10.0), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.relatedPsmsTable.getColumn("Charge").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 30);
        this.relatedPsmsTable.getColumn("  ").setCellRenderer((TableCellRenderer)new JSparklinesIntegerIconTableCellRenderer(MatchValidationLevel.getIconMap(this.getClass()), MatchValidationLevel.getTooltipMap()));
        this.relatedPsmsTable.getColumn("RT").setCellRenderer((TableCellRenderer)new JSparklinesIntervalChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(0.0), Double.valueOf(1000.0), Double.valueOf(10.0), this.peptideShakerGUI.getSparklineColor(), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesIntervalChartTableCellRenderer)this.relatedPsmsTable.getColumn("RT").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() + 5);
        ((JSparklinesIntervalChartTableCellRenderer)this.relatedPsmsTable.getColumn("RT").getCellRenderer()).showReferenceLine(true, 0.02, Color.BLACK);
        this.relatedPsmsTable.getColumn("   ").setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/star_yellow.png")), new ImageIcon(this.getClass().getResource("/icons/star_grey.png")), new ImageIcon(this.getClass().getResource("/icons/star_grey.png")), "Starred", null, null));
        this.modificationJTable.getColumn("  ").setCellRenderer((TableCellRenderer)new JSparklinesColorTableCellRenderer());
        this.selectedPeptidesTableToolTips = new ArrayList();
        this.selectedPeptidesTableToolTips.add(null);
        this.selectedPeptidesTableToolTips.add("Starred");
        this.selectedPeptidesTableToolTips.add("Peptide Inference Class");
        this.selectedPeptidesTableToolTips.add("Peptide Sequence");
        this.selectedPeptidesTableToolTips.add("Modification Location Confidence");
        this.selectedPeptidesTableToolTips.add("Peptide Confidence");
        this.selectedPeptidesTableToolTips.add("Peptide Validated");
        this.relatedPeptidesTableToolTips = new ArrayList();
        this.relatedPeptidesTableToolTips.add(null);
        this.relatedPeptidesTableToolTips.add("Starred");
        this.relatedPeptidesTableToolTips.add("Peptide Inference Class");
        this.relatedPeptidesTableToolTips.add("Peptide Sequence");
        this.relatedPeptidesTableToolTips.add("Modification Location Confidence");
        this.relatedPeptidesTableToolTips.add("Peptide Confidence");
        this.relatedPeptidesTableToolTips.add("Peptide Validated");
        this.selectedPsmsTableToolTips = new ArrayList();
        this.selectedPsmsTableToolTips.add(null);
        this.selectedPsmsTableToolTips.add("Starred");
        this.selectedPsmsTableToolTips.add("Peptide Sequence");
        this.selectedPsmsTableToolTips.add("Modification Location Confidence");
        this.selectedPsmsTableToolTips.add("Precursor Charge");
        this.selectedPsmsTableToolTips.add("Precursor Retention Time");
        this.selectedPsmsTableToolTips.add("PSM Validated");
        this.relatedPsmsTableToolTips = new ArrayList();
        this.relatedPsmsTableToolTips.add(null);
        this.relatedPsmsTableToolTips.add("Starred");
        this.relatedPsmsTableToolTips.add("Peptide Sequence");
        this.relatedPsmsTableToolTips.add("Modification Location Confidence");
        this.relatedPsmsTableToolTips.add("Precursor Charge");
        this.relatedPsmsTableToolTips.add("Precursor Retention Time");
        this.relatedPsmsTableToolTips.add("PSM Validated");
        this.modificationTableToolTips = new ArrayList();
        this.modificationTableToolTips.add("Color");
        this.modificationTableToolTips.add("Name");
        this.modificationTableToolTips.add("Frequency");
    }

    private void initComponents() {
        this.modificationAndPeptideSelectionPanel = new JPanel();
        this.modificationPanel = new JPanel();
        this.modificationLayeredLayeredPane = new JLayeredPane();
        this.modificationLayeredPanel = new JPanel();
        this.modificationJScrollPane = new JScrollPane();
        this.modificationJTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)ModificationsPanel.this.modificationTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.modificationSelectionHelpJButton = new JButton();
        this.contextMenuModificationBackgroundPanel = new JPanel();
        this.peptideTablesJSplitPane = new JSplitPane();
        this.modifiedPeptidesPanel = new JPanel();
        this.modifiedPeptidesLayeredPane = new JLayeredPane();
        this.selectedPeptidesJPanel = new JPanel();
        this.selectedPeptidesJSplitPane = new JSplitPane();
        this.peptidesTableJScrollPane = new JScrollPane();
        this.peptidesTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)ModificationsPanel.this.selectedPeptidesTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }

            @Override
            public boolean getScrollableTracksViewportWidth() {
                if (this.autoResizeMode != 0 && this.getParent() instanceof JViewport) {
                    return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
                }
                return false;
            }
        };
        this.modificationProfileSelectedPeptideJPanel = new JPanel();
        this.modificationProfileHelpJButton = new JButton();
        this.exportModifiedPeptideProfileJButton = new JButton();
        this.contextMenuModifiedPeptidesBackgroundPanel = new JPanel();
        this.relatedPeptidesJPanel = new JPanel();
        this.relatedPeptiesLayeredPane = new JLayeredPane();
        this.relatedPeptidesPanel = new JPanel();
        this.relatedPeptidesJSplitPane = new JSplitPane();
        this.relatedPeptidesTableJScrollPane = new JScrollPane();
        this.relatedPeptidesTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)ModificationsPanel.this.relatedPeptidesTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }

            @Override
            public boolean getScrollableTracksViewportWidth() {
                if (this.autoResizeMode != 0 && this.getParent() instanceof JViewport) {
                    return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
                }
                return false;
            }
        };
        this.modificationProfileRelatedPeptideJPanel = new JPanel();
        this.relatedProfileHelpJButton = new JButton();
        this.exportRelatedPeptideProfileJButton = new JButton();
        this.contextMenuRelatedPeptidesBackgroundPanel = new JPanel();
        this.psmSpectraSplitPane = new JSplitPane();
        this.spectrumAndFragmentIonJPanel = new JPanel();
        this.spectrumLayeredPane = new JLayeredPane();
        this.spectrumAndFragmentIonPanel = new JPanel();
        this.slidersSplitPane = new JSplitPane();
        this.spectrumTabbedPane = new JTabbedPane();
        this.psmAScoresJPanel = new JPanel();
        this.psmAScoresScrollPane = new JScrollPane();
        this.psmAScoresTable = new JTable();
        this.aScoreMinValueJLabel = new JLabel();
        this.aScoreGradientPanel = new JPanel();
        this.aScoreMaxValueJLabel = new JLabel();
        this.psmDeltaScoresJPanel = new JPanel();
        this.psmDeltaScrollPane = new JScrollPane();
        this.psmDeltaScoresTable = new JTable();
        this.deltaScoreGradientPanel = new JPanel();
        this.deltaScoreMinValueJLabel = new JLabel();
        this.deltaScoreMaxValueJLabel = new JLabel();
        this.spectrumJPanel = new JPanel();
        this.spectrumJToolBar = new JToolBar();
        this.spectrumAnnotationMenuPanel = new JPanel();
        this.spectrumChartJPanel = new JPanel();
        this.sliderPanel = new JPanel();
        this.accuracySlider = new JSlider();
        this.intensitySlider = new JSlider();
        this.spectrumHelpJButton = new JButton();
        this.exportSpectrumJButton = new JButton();
        this.contextMenuSpectrumBackgroundPanel = new JPanel();
        this.psmSplitPane = new JSplitPane();
        this.modPsmsPanel = new JPanel();
        this.psmsModPeptidesLayeredPane = new JLayeredPane();
        this.modsPsmsLayeredPanel = new JPanel();
        this.psmsModifiedTableJScrollPane = new JScrollPane();
        this.selectedPsmsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)ModificationsPanel.this.selectedPsmsTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }

            @Override
            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                super.changeSelection(rowIndex, columnIndex, !extend, extend);
            }
        };
        this.modifiedPsmsHelpJButton = new JButton();
        this.exportModifiedPsmsJButton = new JButton();
        this.contextMenuModPsmsBackgroundPanel = new JPanel();
        this.relatedPsmsJPanel = new JPanel();
        this.psmsRelatedPeptidesJLayeredPane = new JLayeredPane();
        this.relatedPsmsPanel = new JPanel();
        this.psmsRelatedTableJScrollPane = new JScrollPane();
        this.relatedPsmsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)ModificationsPanel.this.selectedPsmsTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }

            @Override
            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                super.changeSelection(rowIndex, columnIndex, !extend, extend);
            }
        };
        this.relatedPsmsHelpJButton = new JButton();
        this.exportRelatedPsmsJButton = new JButton();
        this.contextMenuRelatedPsmsBackgroundPanel = new JPanel();
        this.setBackground(new Color(255, 255, 255));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ModificationsPanel.this.formComponentResized(evt);
            }
        });
        this.modificationAndPeptideSelectionPanel.setOpaque(false);
        this.modificationPanel.setOpaque(false);
        this.modificationLayeredPanel.setBorder(BorderFactory.createTitledBorder(null, "Variable Modifications", 0, 0, new Font("sansserif", 1, 14)));
        this.modificationLayeredPanel.setOpaque(false);
        this.modificationJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"  ", "Modification", "#"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.modificationJTable.setOpaque(false);
        this.modificationJTable.setSelectionMode(0);
        this.modificationJTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ModificationsPanel.this.modificationJTableMouseMoved(evt);
            }
        });
        this.modificationJTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsPanel.this.modificationJTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationsPanel.this.modificationJTableMouseReleased(evt);
            }
        });
        this.modificationJTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ModificationsPanel.this.modificationJTableKeyReleased(evt);
            }
        });
        this.modificationJScrollPane.setViewportView(this.modificationJTable);
        GroupLayout modificationLayeredPanelLayout = new GroupLayout(this.modificationLayeredPanel);
        this.modificationLayeredPanel.setLayout(modificationLayeredPanelLayout);
        modificationLayeredPanelLayout.setHorizontalGroup(modificationLayeredPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 262, Short.MAX_VALUE).addGroup(modificationLayeredPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modificationLayeredPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.modificationJScrollPane, -1, 250, Short.MAX_VALUE).addContainerGap())));
        modificationLayeredPanelLayout.setVerticalGroup(modificationLayeredPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 355, Short.MAX_VALUE).addGroup(modificationLayeredPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modificationLayeredPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.modificationJScrollPane, -1, 343, Short.MAX_VALUE).addContainerGap())));
        this.modificationLayeredLayeredPane.add(this.modificationLayeredPanel);
        this.modificationLayeredPanel.setBounds(0, 0, 290, 400);
        this.modificationSelectionHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.modificationSelectionHelpJButton.setToolTipText("Help");
        this.modificationSelectionHelpJButton.setBorder(null);
        this.modificationSelectionHelpJButton.setBorderPainted(false);
        this.modificationSelectionHelpJButton.setContentAreaFilled(false);
        this.modificationSelectionHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.modificationSelectionHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsPanel.this.modificationSelectionHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsPanel.this.modificationSelectionHelpJButtonMouseExited(evt);
            }
        });
        this.modificationSelectionHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsPanel.this.modificationSelectionHelpJButtonActionPerformed(evt);
            }
        });
        this.modificationLayeredLayeredPane.setLayer(this.modificationSelectionHelpJButton, JLayeredPane.POPUP_LAYER);
        this.modificationLayeredLayeredPane.add(this.modificationSelectionHelpJButton);
        this.modificationSelectionHelpJButton.setBounds(240, 0, 10, 19);
        this.contextMenuModificationBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuModificationBackgroundPanelLayout = new GroupLayout(this.contextMenuModificationBackgroundPanel);
        this.contextMenuModificationBackgroundPanel.setLayout(contextMenuModificationBackgroundPanelLayout);
        contextMenuModificationBackgroundPanelLayout.setHorizontalGroup(contextMenuModificationBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        contextMenuModificationBackgroundPanelLayout.setVerticalGroup(contextMenuModificationBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.modificationLayeredLayeredPane.setLayer(this.contextMenuModificationBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.modificationLayeredLayeredPane.add(this.contextMenuModificationBackgroundPanel);
        this.contextMenuModificationBackgroundPanel.setBounds(230, 0, 20, 19);
        GroupLayout modificationPanelLayout = new GroupLayout(this.modificationPanel);
        this.modificationPanel.setLayout(modificationPanelLayout);
        modificationPanelLayout.setHorizontalGroup(modificationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modificationLayeredLayeredPane, -1, 331, Short.MAX_VALUE));
        modificationPanelLayout.setVerticalGroup(modificationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modificationLayeredLayeredPane));
        this.peptideTablesJSplitPane.setBorder(null);
        this.peptideTablesJSplitPane.setDividerLocation(170);
        this.peptideTablesJSplitPane.setDividerSize(0);
        this.peptideTablesJSplitPane.setOrientation(0);
        this.peptideTablesJSplitPane.setResizeWeight(0.5);
        this.modifiedPeptidesPanel.setOpaque(false);
        this.selectedPeptidesJPanel.setBorder(BorderFactory.createTitledBorder(null, "Modified Peptides", 0, 0, new Font("sansserif", 1, 14)));
        this.selectedPeptidesJPanel.setOpaque(false);
        this.selectedPeptidesJSplitPane.setBorder(null);
        this.selectedPeptidesJSplitPane.setDividerLocation(400);
        this.selectedPeptidesJSplitPane.setDividerSize(0);
        this.selectedPeptidesJSplitPane.setResizeWeight(0.5);
        this.peptidesTable.setModel(new PeptideTable());
        this.peptidesTable.setOpaque(false);
        this.peptidesTable.setSelectionMode(0);
        this.peptidesTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ModificationsPanel.this.peptidesTableMouseMoved(evt);
            }
        });
        this.peptidesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsPanel.this.peptidesTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationsPanel.this.peptidesTableMouseReleased(evt);
            }
        });
        this.peptidesTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ModificationsPanel.this.peptidesTableKeyReleased(evt);
            }
        });
        this.peptidesTableJScrollPane.setViewportView(this.peptidesTable);
        this.selectedPeptidesJSplitPane.setLeftComponent(this.peptidesTableJScrollPane);
        this.modificationProfileSelectedPeptideJPanel.setBackground(new Color(255, 255, 255));
        this.modificationProfileSelectedPeptideJPanel.setOpaque(false);
        this.modificationProfileSelectedPeptideJPanel.setLayout(new GridLayout(3, 1));
        this.selectedPeptidesJSplitPane.setRightComponent(this.modificationProfileSelectedPeptideJPanel);
        GroupLayout selectedPeptidesJPanelLayout = new GroupLayout(this.selectedPeptidesJPanel);
        this.selectedPeptidesJPanel.setLayout(selectedPeptidesJPanelLayout);
        selectedPeptidesJPanelLayout.setHorizontalGroup(selectedPeptidesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, selectedPeptidesJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.selectedPeptidesJSplitPane, -1, 774, Short.MAX_VALUE).addContainerGap()));
        selectedPeptidesJPanelLayout.setVerticalGroup(selectedPeptidesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(selectedPeptidesJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.selectedPeptidesJSplitPane, -1, 113, Short.MAX_VALUE).addContainerGap()));
        this.modifiedPeptidesLayeredPane.add(this.selectedPeptidesJPanel);
        this.selectedPeptidesJPanel.setBounds(0, 0, 810, 170);
        this.modificationProfileHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.modificationProfileHelpJButton.setToolTipText("Help");
        this.modificationProfileHelpJButton.setBorder(null);
        this.modificationProfileHelpJButton.setBorderPainted(false);
        this.modificationProfileHelpJButton.setContentAreaFilled(false);
        this.modificationProfileHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.modificationProfileHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsPanel.this.modificationProfileHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsPanel.this.modificationProfileHelpJButtonMouseExited(evt);
            }
        });
        this.modificationProfileHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsPanel.this.modificationProfileHelpJButtonActionPerformed(evt);
            }
        });
        this.modifiedPeptidesLayeredPane.setLayer(this.modificationProfileHelpJButton, JLayeredPane.POPUP_LAYER);
        this.modifiedPeptidesLayeredPane.add(this.modificationProfileHelpJButton);
        this.modificationProfileHelpJButton.setBounds(747, 0, 10, 19);
        this.exportModifiedPeptideProfileJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportModifiedPeptideProfileJButton.setToolTipText("Export");
        this.exportModifiedPeptideProfileJButton.setBorder(null);
        this.exportModifiedPeptideProfileJButton.setBorderPainted(false);
        this.exportModifiedPeptideProfileJButton.setContentAreaFilled(false);
        this.exportModifiedPeptideProfileJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportModifiedPeptideProfileJButton.setEnabled(false);
        this.exportModifiedPeptideProfileJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportModifiedPeptideProfileJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsPanel.this.exportModifiedPeptideProfileJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsPanel.this.exportModifiedPeptideProfileJButtonMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationsPanel.this.exportModifiedPeptideProfileJButtonMouseReleased(evt);
            }
        });
        this.modifiedPeptidesLayeredPane.setLayer(this.exportModifiedPeptideProfileJButton, JLayeredPane.POPUP_LAYER);
        this.modifiedPeptidesLayeredPane.add(this.exportModifiedPeptideProfileJButton);
        this.exportModifiedPeptideProfileJButton.setBounds(730, 0, 10, 19);
        this.contextMenuModifiedPeptidesBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuModifiedPeptidesBackgroundPanelLayout = new GroupLayout(this.contextMenuModifiedPeptidesBackgroundPanel);
        this.contextMenuModifiedPeptidesBackgroundPanel.setLayout(contextMenuModifiedPeptidesBackgroundPanelLayout);
        contextMenuModifiedPeptidesBackgroundPanelLayout.setHorizontalGroup(contextMenuModifiedPeptidesBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuModifiedPeptidesBackgroundPanelLayout.setVerticalGroup(contextMenuModifiedPeptidesBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.modifiedPeptidesLayeredPane.setLayer(this.contextMenuModifiedPeptidesBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.modifiedPeptidesLayeredPane.add(this.contextMenuModifiedPeptidesBackgroundPanel);
        this.contextMenuModifiedPeptidesBackgroundPanel.setBounds(730, 0, 30, 19);
        GroupLayout modifiedPeptidesPanelLayout = new GroupLayout(this.modifiedPeptidesPanel);
        this.modifiedPeptidesPanel.setLayout(modifiedPeptidesPanelLayout);
        modifiedPeptidesPanelLayout.setHorizontalGroup(modifiedPeptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 740, Short.MAX_VALUE).addGroup(modifiedPeptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modifiedPeptidesLayeredPane, -1, 740, Short.MAX_VALUE)));
        modifiedPeptidesPanelLayout.setVerticalGroup(modifiedPeptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 170, Short.MAX_VALUE).addGroup(modifiedPeptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modifiedPeptidesLayeredPane, -1, 170, Short.MAX_VALUE)));
        this.peptideTablesJSplitPane.setLeftComponent(this.modifiedPeptidesPanel);
        this.relatedPeptidesJPanel.setOpaque(false);
        this.relatedPeptidesPanel.setBorder(BorderFactory.createTitledBorder(null, "Related Peptides", 0, 0, new Font("sansserif", 1, 14)));
        this.relatedPeptidesPanel.setOpaque(false);
        this.relatedPeptidesJSplitPane.setBorder(null);
        this.relatedPeptidesJSplitPane.setDividerLocation(400);
        this.relatedPeptidesJSplitPane.setDividerSize(0);
        this.relatedPeptidesTable.setModel(new RelatedPeptidesTable());
        this.relatedPeptidesTable.setOpaque(false);
        this.relatedPeptidesTable.setSelectionMode(0);
        this.relatedPeptidesTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ModificationsPanel.this.relatedPeptidesTableMouseMoved(evt);
            }
        });
        this.relatedPeptidesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsPanel.this.relatedPeptidesTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationsPanel.this.relatedPeptidesTableMouseReleased(evt);
            }
        });
        this.relatedPeptidesTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ModificationsPanel.this.relatedPeptidesTableKeyReleased(evt);
            }
        });
        this.relatedPeptidesTableJScrollPane.setViewportView(this.relatedPeptidesTable);
        this.relatedPeptidesJSplitPane.setLeftComponent(this.relatedPeptidesTableJScrollPane);
        this.modificationProfileRelatedPeptideJPanel.setBackground(new Color(255, 255, 255));
        this.modificationProfileRelatedPeptideJPanel.setOpaque(false);
        this.modificationProfileRelatedPeptideJPanel.setLayout(new GridLayout(3, 1));
        this.relatedPeptidesJSplitPane.setRightComponent(this.modificationProfileRelatedPeptideJPanel);
        GroupLayout relatedPeptidesPanelLayout = new GroupLayout(this.relatedPeptidesPanel);
        this.relatedPeptidesPanel.setLayout(relatedPeptidesPanelLayout);
        relatedPeptidesPanelLayout.setHorizontalGroup(relatedPeptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 798, Short.MAX_VALUE).addGroup(relatedPeptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(relatedPeptidesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.relatedPeptidesJSplitPane, -1, 774, Short.MAX_VALUE).addContainerGap())));
        relatedPeptidesPanelLayout.setVerticalGroup(relatedPeptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 185, Short.MAX_VALUE).addGroup(relatedPeptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(relatedPeptidesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.relatedPeptidesJSplitPane, -1, 173, Short.MAX_VALUE).addContainerGap())));
        this.relatedPeptiesLayeredPane.add(this.relatedPeptidesPanel);
        this.relatedPeptidesPanel.setBounds(0, 0, 810, 230);
        this.relatedProfileHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.relatedProfileHelpJButton.setToolTipText("Help");
        this.relatedProfileHelpJButton.setBorder(null);
        this.relatedProfileHelpJButton.setBorderPainted(false);
        this.relatedProfileHelpJButton.setContentAreaFilled(false);
        this.relatedProfileHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.relatedProfileHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsPanel.this.relatedProfileHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsPanel.this.relatedProfileHelpJButtonMouseExited(evt);
            }
        });
        this.relatedProfileHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsPanel.this.relatedProfileHelpJButtonActionPerformed(evt);
            }
        });
        this.relatedPeptiesLayeredPane.setLayer(this.relatedProfileHelpJButton, JLayeredPane.POPUP_LAYER);
        this.relatedPeptiesLayeredPane.add(this.relatedProfileHelpJButton);
        this.relatedProfileHelpJButton.setBounds(750, 0, 10, 19);
        this.exportRelatedPeptideProfileJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportRelatedPeptideProfileJButton.setToolTipText("Export");
        this.exportRelatedPeptideProfileJButton.setBorder(null);
        this.exportRelatedPeptideProfileJButton.setBorderPainted(false);
        this.exportRelatedPeptideProfileJButton.setContentAreaFilled(false);
        this.exportRelatedPeptideProfileJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportRelatedPeptideProfileJButton.setEnabled(false);
        this.exportRelatedPeptideProfileJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportRelatedPeptideProfileJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsPanel.this.exportRelatedPeptideProfileJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsPanel.this.exportRelatedPeptideProfileJButtonMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationsPanel.this.exportRelatedPeptideProfileJButtonMouseReleased(evt);
            }
        });
        this.relatedPeptiesLayeredPane.setLayer(this.exportRelatedPeptideProfileJButton, JLayeredPane.POPUP_LAYER);
        this.relatedPeptiesLayeredPane.add(this.exportRelatedPeptideProfileJButton);
        this.exportRelatedPeptideProfileJButton.setBounds(740, 0, 10, 19);
        this.contextMenuRelatedPeptidesBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuRelatedPeptidesBackgroundPanelLayout = new GroupLayout(this.contextMenuRelatedPeptidesBackgroundPanel);
        this.contextMenuRelatedPeptidesBackgroundPanel.setLayout(contextMenuRelatedPeptidesBackgroundPanelLayout);
        contextMenuRelatedPeptidesBackgroundPanelLayout.setHorizontalGroup(contextMenuRelatedPeptidesBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuRelatedPeptidesBackgroundPanelLayout.setVerticalGroup(contextMenuRelatedPeptidesBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.relatedPeptiesLayeredPane.setLayer(this.contextMenuRelatedPeptidesBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.relatedPeptiesLayeredPane.add(this.contextMenuRelatedPeptidesBackgroundPanel);
        this.contextMenuRelatedPeptidesBackgroundPanel.setBounds(730, 0, 30, 19);
        GroupLayout relatedPeptidesJPanelLayout = new GroupLayout(this.relatedPeptidesJPanel);
        this.relatedPeptidesJPanel.setLayout(relatedPeptidesJPanelLayout);
        relatedPeptidesJPanelLayout.setHorizontalGroup(relatedPeptidesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.relatedPeptiesLayeredPane, GroupLayout.Alignment.TRAILING, -1, 740, Short.MAX_VALUE));
        relatedPeptidesJPanelLayout.setVerticalGroup(relatedPeptidesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.relatedPeptiesLayeredPane, -1, 230, Short.MAX_VALUE));
        this.peptideTablesJSplitPane.setRightComponent(this.relatedPeptidesJPanel);
        GroupLayout modificationAndPeptideSelectionPanelLayout = new GroupLayout(this.modificationAndPeptideSelectionPanel);
        this.modificationAndPeptideSelectionPanel.setLayout(modificationAndPeptideSelectionPanelLayout);
        modificationAndPeptideSelectionPanelLayout.setHorizontalGroup(modificationAndPeptideSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modificationAndPeptideSelectionPanelLayout.createSequentialGroup().addComponent(this.modificationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideTablesJSplitPane, -1, 742, Short.MAX_VALUE)));
        modificationAndPeptideSelectionPanelLayout.setVerticalGroup(modificationAndPeptideSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modificationPanel, -1, -1, Short.MAX_VALUE).addComponent(this.peptideTablesJSplitPane));
        this.psmSpectraSplitPane.setBorder(null);
        this.psmSpectraSplitPane.setDividerLocation(500);
        this.psmSpectraSplitPane.setDividerSize(0);
        this.psmSpectraSplitPane.setResizeWeight(0.5);
        this.spectrumAndFragmentIonJPanel.setOpaque(false);
        this.spectrumAndFragmentIonJPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                ModificationsPanel.this.spectrumAndFragmentIonJPanelMouseWheelMoved(evt);
            }
        });
        this.spectrumAndFragmentIonPanel.setBorder(BorderFactory.createTitledBorder(null, "Spectrum & Fragment Ions", 0, 0, new Font("sansserif", 1, 14)));
        this.spectrumAndFragmentIonPanel.setOpaque(false);
        this.slidersSplitPane.setBorder(null);
        this.slidersSplitPane.setDividerLocation(500);
        this.slidersSplitPane.setDividerSize(0);
        this.spectrumTabbedPane.setBackground(new Color(255, 255, 255));
        this.spectrumTabbedPane.setTabPlacement(3);
        this.spectrumTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ModificationsPanel.this.spectrumTabbedPaneStateChanged(evt);
            }
        });
        this.psmAScoresJPanel.setOpaque(false);
        this.psmAScoresTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.psmAScoresTable.setOpaque(false);
        this.psmAScoresScrollPane.setViewportView(this.psmAScoresTable);
        this.aScoreMinValueJLabel.setHorizontalAlignment(0);
        this.aScoreMinValueJLabel.setText("0%");
        this.aScoreGradientPanel.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.aScoreGradientPanel.setToolTipText("A-Score Certainty");
        this.aScoreGradientPanel.setLayout(new BorderLayout());
        this.aScoreMaxValueJLabel.setText("100%");
        GroupLayout psmAScoresJPanelLayout = new GroupLayout(this.psmAScoresJPanel);
        this.psmAScoresJPanel.setLayout(psmAScoresJPanelLayout);
        psmAScoresJPanelLayout.setHorizontalGroup(psmAScoresJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psmAScoresJPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.aScoreMinValueJLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.aScoreGradientPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.aScoreMaxValueJLabel).addGap(20, 20, 20)).addGroup(psmAScoresJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psmAScoresScrollPane, -2, 0, Short.MAX_VALUE).addContainerGap()));
        psmAScoresJPanelLayout.linkSize(0, this.aScoreMaxValueJLabel, this.aScoreMinValueJLabel);
        psmAScoresJPanelLayout.setVerticalGroup(psmAScoresJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psmAScoresJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psmAScoresScrollPane, -1, 318, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(psmAScoresJPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.aScoreMinValueJLabel).addComponent(this.aScoreGradientPanel, -2, 17, -2).addComponent(this.aScoreMaxValueJLabel)).addContainerGap()));
        this.spectrumTabbedPane.addTab("Probabilistic Scores", this.psmAScoresJPanel);
        this.psmDeltaScoresJPanel.setOpaque(false);
        this.psmDeltaScoresTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.psmDeltaScoresTable.setOpaque(false);
        this.psmDeltaScrollPane.setViewportView(this.psmDeltaScoresTable);
        this.deltaScoreGradientPanel.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.deltaScoreGradientPanel.setToolTipText("Delta Score Certainty");
        this.deltaScoreGradientPanel.setLayout(new BorderLayout());
        this.deltaScoreMinValueJLabel.setHorizontalAlignment(0);
        this.deltaScoreMinValueJLabel.setText("0%");
        this.deltaScoreMaxValueJLabel.setText("100%");
        GroupLayout psmDeltaScoresJPanelLayout = new GroupLayout(this.psmDeltaScoresJPanel);
        this.psmDeltaScoresJPanel.setLayout(psmDeltaScoresJPanelLayout);
        psmDeltaScoresJPanelLayout.setHorizontalGroup(psmDeltaScoresJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psmDeltaScoresJPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.deltaScoreMinValueJLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.deltaScoreGradientPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.deltaScoreMaxValueJLabel).addGap(20, 20, 20)).addGroup(GroupLayout.Alignment.TRAILING, psmDeltaScoresJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psmDeltaScrollPane, -2, 0, Short.MAX_VALUE).addContainerGap()));
        psmDeltaScoresJPanelLayout.linkSize(0, this.deltaScoreMaxValueJLabel, this.deltaScoreMinValueJLabel);
        psmDeltaScoresJPanelLayout.setVerticalGroup(psmDeltaScoresJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psmDeltaScoresJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psmDeltaScrollPane, -1, 318, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(psmDeltaScoresJPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.deltaScoreMinValueJLabel).addComponent(this.deltaScoreGradientPanel, -2, 17, -2).addComponent(this.deltaScoreMaxValueJLabel)).addContainerGap()));
        this.spectrumTabbedPane.addTab("D-Scores", this.psmDeltaScoresJPanel);
        this.spectrumJPanel.setBackground(new Color(255, 255, 255));
        this.spectrumJToolBar.setBackground(new Color(255, 255, 255));
        this.spectrumJToolBar.setBorder(null);
        this.spectrumJToolBar.setFloatable(false);
        this.spectrumJToolBar.setRollover(true);
        this.spectrumJToolBar.setBorderPainted(false);
        this.spectrumAnnotationMenuPanel.setLayout(new BoxLayout(this.spectrumAnnotationMenuPanel, 2));
        this.spectrumJToolBar.add(this.spectrumAnnotationMenuPanel);
        this.spectrumChartJPanel.setOpaque(false);
        this.spectrumChartJPanel.setLayout(new BoxLayout(this.spectrumChartJPanel, 1));
        GroupLayout spectrumJPanelLayout = new GroupLayout(this.spectrumJPanel);
        this.spectrumJPanel.setLayout(spectrumJPanelLayout);
        spectrumJPanelLayout.setHorizontalGroup(spectrumJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.spectrumJToolBar, -1, 116, Short.MAX_VALUE).addContainerGap()).addComponent(this.spectrumChartJPanel, -1, 128, Short.MAX_VALUE));
        spectrumJPanelLayout.setVerticalGroup(spectrumJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, spectrumJPanelLayout.createSequentialGroup().addComponent(this.spectrumChartJPanel, -1, 353, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.spectrumJToolBar, -2, -1, -2)));
        this.spectrumTabbedPane.addTab("Spectrum", this.spectrumJPanel);
        this.spectrumTabbedPane.setSelectedIndex(2);
        this.slidersSplitPane.setLeftComponent(this.spectrumTabbedPane);
        this.sliderPanel.setMaximumSize(new Dimension(36, 312));
        this.sliderPanel.setOpaque(false);
        this.sliderPanel.setPreferredSize(new Dimension(36, 312));
        this.accuracySlider.setOrientation(1);
        this.accuracySlider.setPaintTicks(true);
        this.accuracySlider.setToolTipText("Annotation Accuracy");
        this.accuracySlider.setValue(100);
        this.accuracySlider.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                ModificationsPanel.this.accuracySliderMouseWheelMoved(evt);
            }
        });
        this.accuracySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ModificationsPanel.this.accuracySliderStateChanged(evt);
            }
        });
        this.intensitySlider.setOrientation(1);
        this.intensitySlider.setPaintTicks(true);
        this.intensitySlider.setToolTipText("Annotation Intensity Level");
        this.intensitySlider.setValue(75);
        this.intensitySlider.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                ModificationsPanel.this.intensitySliderMouseWheelMoved(evt);
            }
        });
        this.intensitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ModificationsPanel.this.intensitySliderStateChanged(evt);
            }
        });
        GroupLayout sliderPanelLayout = new GroupLayout(this.sliderPanel);
        this.sliderPanel.setLayout(sliderPanelLayout);
        sliderPanelLayout.setHorizontalGroup(sliderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sliderPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(sliderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.intensitySlider, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.accuracySlider, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addGap(0, 0, 0)));
        sliderPanelLayout.setVerticalGroup(sliderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sliderPanelLayout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.accuracySlider, -1, 142, Short.MAX_VALUE).addGap(27, 27, 27).addComponent(this.intensitySlider, -1, 142, Short.MAX_VALUE).addGap(47, 47, 47)));
        this.slidersSplitPane.setRightComponent(this.sliderPanel);
        GroupLayout spectrumAndFragmentIonPanelLayout = new GroupLayout(this.spectrumAndFragmentIonPanel);
        this.spectrumAndFragmentIonPanel.setLayout(spectrumAndFragmentIonPanelLayout);
        spectrumAndFragmentIonPanelLayout.setHorizontalGroup(spectrumAndFragmentIonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumAndFragmentIonPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.slidersSplitPane, -1, 534, Short.MAX_VALUE).addContainerGap()));
        spectrumAndFragmentIonPanelLayout.setVerticalGroup(spectrumAndFragmentIonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumAndFragmentIonPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.slidersSplitPane, -1, 383, Short.MAX_VALUE).addContainerGap()));
        this.spectrumLayeredPane.add(this.spectrumAndFragmentIonPanel);
        this.spectrumAndFragmentIonPanel.setBounds(0, 0, 570, 440);
        this.spectrumHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.spectrumHelpJButton.setToolTipText("Help");
        this.spectrumHelpJButton.setBorder(null);
        this.spectrumHelpJButton.setBorderPainted(false);
        this.spectrumHelpJButton.setContentAreaFilled(false);
        this.spectrumHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.spectrumHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsPanel.this.spectrumHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsPanel.this.spectrumHelpJButtonMouseExited(evt);
            }
        });
        this.spectrumHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsPanel.this.spectrumHelpJButtonActionPerformed(evt);
            }
        });
        this.spectrumLayeredPane.setLayer(this.spectrumHelpJButton, JLayeredPane.POPUP_LAYER);
        this.spectrumLayeredPane.add(this.spectrumHelpJButton);
        this.spectrumHelpJButton.setBounds(540, 0, 10, 19);
        this.exportSpectrumJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportSpectrumJButton.setToolTipText("Export");
        this.exportSpectrumJButton.setBorder(null);
        this.exportSpectrumJButton.setBorderPainted(false);
        this.exportSpectrumJButton.setContentAreaFilled(false);
        this.exportSpectrumJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportSpectrumJButton.setEnabled(false);
        this.exportSpectrumJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportSpectrumJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsPanel.this.exportSpectrumJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsPanel.this.exportSpectrumJButtonMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationsPanel.this.exportSpectrumJButtonMouseReleased(evt);
            }
        });
        this.spectrumLayeredPane.setLayer(this.exportSpectrumJButton, JLayeredPane.POPUP_LAYER);
        this.spectrumLayeredPane.add(this.exportSpectrumJButton);
        this.exportSpectrumJButton.setBounds(530, 0, 10, 19);
        this.contextMenuSpectrumBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuSpectrumBackgroundPanelLayout = new GroupLayout(this.contextMenuSpectrumBackgroundPanel);
        this.contextMenuSpectrumBackgroundPanel.setLayout(contextMenuSpectrumBackgroundPanelLayout);
        contextMenuSpectrumBackgroundPanelLayout.setHorizontalGroup(contextMenuSpectrumBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuSpectrumBackgroundPanelLayout.setVerticalGroup(contextMenuSpectrumBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.spectrumLayeredPane.setLayer(this.contextMenuSpectrumBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.spectrumLayeredPane.add(this.contextMenuSpectrumBackgroundPanel);
        this.contextMenuSpectrumBackgroundPanel.setBounds(530, 0, 30, 19);
        GroupLayout spectrumAndFragmentIonJPanelLayout = new GroupLayout(this.spectrumAndFragmentIonJPanel);
        this.spectrumAndFragmentIonJPanel.setLayout(spectrumAndFragmentIonJPanelLayout);
        spectrumAndFragmentIonJPanelLayout.setHorizontalGroup(spectrumAndFragmentIonJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumAndFragmentIonJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.spectrumLayeredPane, -1, 569, Short.MAX_VALUE)));
        spectrumAndFragmentIonJPanelLayout.setVerticalGroup(spectrumAndFragmentIonJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spectrumLayeredPane, -1, 440, Short.MAX_VALUE));
        this.psmSpectraSplitPane.setRightComponent(this.spectrumAndFragmentIonJPanel);
        this.psmSplitPane.setBorder(null);
        this.psmSplitPane.setDividerSize(0);
        this.psmSplitPane.setOrientation(0);
        this.modPsmsPanel.setOpaque(false);
        this.modsPsmsLayeredPanel.setBorder(BorderFactory.createTitledBorder(null, "Peptide Spectrum Matches - Modified Peptide", 0, 0, new Font("sansserif", 1, 14)));
        this.modsPsmsLayeredPanel.setOpaque(false);
        this.selectedPsmsTable.setModel(new PsmsTable(false));
        this.selectedPsmsTable.setOpaque(false);
        this.selectedPsmsTable.setSelectionMode(0);
        this.selectedPsmsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ModificationsPanel.this.selectedPsmsTableMouseMoved(evt);
            }
        });
        this.selectedPsmsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationsPanel.this.selectedPsmsTableMouseReleased(evt);
            }
        });
        this.selectedPsmsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ModificationsPanel.this.selectedPsmsTableKeyReleased(evt);
            }
        });
        this.psmsModifiedTableJScrollPane.setViewportView(this.selectedPsmsTable);
        GroupLayout modsPsmsLayeredPanelLayout = new GroupLayout(this.modsPsmsLayeredPanel);
        this.modsPsmsLayeredPanel.setLayout(modsPsmsLayeredPanelLayout);
        modsPsmsLayeredPanelLayout.setHorizontalGroup(modsPsmsLayeredPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 488, Short.MAX_VALUE).addGroup(modsPsmsLayeredPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modsPsmsLayeredPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psmsModifiedTableJScrollPane, -1, 464, Short.MAX_VALUE).addContainerGap())));
        modsPsmsLayeredPanelLayout.setVerticalGroup(modsPsmsLayeredPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 145, Short.MAX_VALUE).addGroup(modsPsmsLayeredPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modsPsmsLayeredPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psmsModifiedTableJScrollPane, -1, 133, Short.MAX_VALUE).addContainerGap())));
        this.psmsModPeptidesLayeredPane.add(this.modsPsmsLayeredPanel);
        this.modsPsmsLayeredPanel.setBounds(0, 0, 500, 190);
        this.modifiedPsmsHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.modifiedPsmsHelpJButton.setToolTipText("Help");
        this.modifiedPsmsHelpJButton.setBorder(null);
        this.modifiedPsmsHelpJButton.setBorderPainted(false);
        this.modifiedPsmsHelpJButton.setContentAreaFilled(false);
        this.modifiedPsmsHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.modifiedPsmsHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsPanel.this.modifiedPsmsHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsPanel.this.modifiedPsmsHelpJButtonMouseExited(evt);
            }
        });
        this.modifiedPsmsHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsPanel.this.modifiedPsmsHelpJButtonActionPerformed(evt);
            }
        });
        this.psmsModPeptidesLayeredPane.setLayer(this.modifiedPsmsHelpJButton, JLayeredPane.POPUP_LAYER);
        this.psmsModPeptidesLayeredPane.add(this.modifiedPsmsHelpJButton);
        this.modifiedPsmsHelpJButton.setBounds(480, 0, 10, 19);
        this.exportModifiedPsmsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportModifiedPsmsJButton.setToolTipText("Copy to Clipboard");
        this.exportModifiedPsmsJButton.setBorder(null);
        this.exportModifiedPsmsJButton.setBorderPainted(false);
        this.exportModifiedPsmsJButton.setContentAreaFilled(false);
        this.exportModifiedPsmsJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportModifiedPsmsJButton.setEnabled(false);
        this.exportModifiedPsmsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportModifiedPsmsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsPanel.this.exportModifiedPsmsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsPanel.this.exportModifiedPsmsJButtonMouseExited(evt);
            }
        });
        this.exportModifiedPsmsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsPanel.this.exportModifiedPsmsJButtonActionPerformed(evt);
            }
        });
        this.psmsModPeptidesLayeredPane.setLayer(this.exportModifiedPsmsJButton, JLayeredPane.POPUP_LAYER);
        this.psmsModPeptidesLayeredPane.add(this.exportModifiedPsmsJButton);
        this.exportModifiedPsmsJButton.setBounds(470, 0, 10, 19);
        this.contextMenuModPsmsBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuModPsmsBackgroundPanelLayout = new GroupLayout(this.contextMenuModPsmsBackgroundPanel);
        this.contextMenuModPsmsBackgroundPanel.setLayout(contextMenuModPsmsBackgroundPanelLayout);
        contextMenuModPsmsBackgroundPanelLayout.setHorizontalGroup(contextMenuModPsmsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuModPsmsBackgroundPanelLayout.setVerticalGroup(contextMenuModPsmsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.psmsModPeptidesLayeredPane.setLayer(this.contextMenuModPsmsBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.psmsModPeptidesLayeredPane.add(this.contextMenuModPsmsBackgroundPanel);
        this.contextMenuModPsmsBackgroundPanel.setBounds(460, 0, 30, 19);
        GroupLayout modPsmsPanelLayout = new GroupLayout(this.modPsmsPanel);
        this.modPsmsPanel.setLayout(modPsmsPanelLayout);
        modPsmsPanelLayout.setHorizontalGroup(modPsmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.psmsModPeptidesLayeredPane, -1, 500, Short.MAX_VALUE));
        modPsmsPanelLayout.setVerticalGroup(modPsmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.psmsModPeptidesLayeredPane));
        this.psmSplitPane.setTopComponent(this.modPsmsPanel);
        this.relatedPsmsJPanel.setOpaque(false);
        this.relatedPsmsPanel.setBorder(BorderFactory.createTitledBorder(null, "Peptide Spectrum Matches - Releated Peptide", 0, 0, new Font("sansserif", 1, 14)));
        this.relatedPsmsPanel.setOpaque(false);
        this.relatedPsmsTable.setModel(new PsmsTable(true));
        this.relatedPsmsTable.setOpaque(false);
        this.relatedPsmsTable.setSelectionMode(0);
        this.relatedPsmsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ModificationsPanel.this.relatedPsmsTableMouseMoved(evt);
            }
        });
        this.relatedPsmsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationsPanel.this.relatedPsmsTableMouseReleased(evt);
            }
        });
        this.relatedPsmsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ModificationsPanel.this.relatedPsmsTableKeyReleased(evt);
            }
        });
        this.psmsRelatedTableJScrollPane.setViewportView(this.relatedPsmsTable);
        GroupLayout relatedPsmsPanelLayout = new GroupLayout(this.relatedPsmsPanel);
        this.relatedPsmsPanel.setLayout(relatedPsmsPanelLayout);
        relatedPsmsPanelLayout.setHorizontalGroup(relatedPsmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 488, Short.MAX_VALUE).addGroup(relatedPsmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(relatedPsmsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psmsRelatedTableJScrollPane, -1, 464, Short.MAX_VALUE).addContainerGap())));
        relatedPsmsPanelLayout.setVerticalGroup(relatedPsmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 205, Short.MAX_VALUE).addGroup(relatedPsmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(relatedPsmsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psmsRelatedTableJScrollPane, -1, 193, Short.MAX_VALUE).addContainerGap())));
        this.psmsRelatedPeptidesJLayeredPane.add(this.relatedPsmsPanel);
        this.relatedPsmsPanel.setBounds(0, 0, 500, 250);
        this.relatedPsmsHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.relatedPsmsHelpJButton.setToolTipText("Help");
        this.relatedPsmsHelpJButton.setBorder(null);
        this.relatedPsmsHelpJButton.setBorderPainted(false);
        this.relatedPsmsHelpJButton.setContentAreaFilled(false);
        this.relatedPsmsHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.relatedPsmsHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsPanel.this.relatedPsmsHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsPanel.this.relatedPsmsHelpJButtonMouseExited(evt);
            }
        });
        this.relatedPsmsHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsPanel.this.relatedPsmsHelpJButtonActionPerformed(evt);
            }
        });
        this.psmsRelatedPeptidesJLayeredPane.setLayer(this.relatedPsmsHelpJButton, JLayeredPane.POPUP_LAYER);
        this.psmsRelatedPeptidesJLayeredPane.add(this.relatedPsmsHelpJButton);
        this.relatedPsmsHelpJButton.setBounds(480, 0, 10, 19);
        this.exportRelatedPsmsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportRelatedPsmsJButton.setToolTipText("Copy to Clipboard");
        this.exportRelatedPsmsJButton.setBorder(null);
        this.exportRelatedPsmsJButton.setBorderPainted(false);
        this.exportRelatedPsmsJButton.setContentAreaFilled(false);
        this.exportRelatedPsmsJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportRelatedPsmsJButton.setEnabled(false);
        this.exportRelatedPsmsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportRelatedPsmsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsPanel.this.exportRelatedPsmsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsPanel.this.exportRelatedPsmsJButtonMouseExited(evt);
            }
        });
        this.exportRelatedPsmsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsPanel.this.exportRelatedPsmsJButtonActionPerformed(evt);
            }
        });
        this.psmsRelatedPeptidesJLayeredPane.setLayer(this.exportRelatedPsmsJButton, JLayeredPane.POPUP_LAYER);
        this.psmsRelatedPeptidesJLayeredPane.add(this.exportRelatedPsmsJButton);
        this.exportRelatedPsmsJButton.setBounds(470, 0, 10, 19);
        this.contextMenuRelatedPsmsBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuRelatedPsmsBackgroundPanelLayout = new GroupLayout(this.contextMenuRelatedPsmsBackgroundPanel);
        this.contextMenuRelatedPsmsBackgroundPanel.setLayout(contextMenuRelatedPsmsBackgroundPanelLayout);
        contextMenuRelatedPsmsBackgroundPanelLayout.setHorizontalGroup(contextMenuRelatedPsmsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuRelatedPsmsBackgroundPanelLayout.setVerticalGroup(contextMenuRelatedPsmsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.psmsRelatedPeptidesJLayeredPane.setLayer(this.contextMenuRelatedPsmsBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.psmsRelatedPeptidesJLayeredPane.add(this.contextMenuRelatedPsmsBackgroundPanel);
        this.contextMenuRelatedPsmsBackgroundPanel.setBounds(460, 0, 30, 19);
        GroupLayout relatedPsmsJPanelLayout = new GroupLayout(this.relatedPsmsJPanel);
        this.relatedPsmsJPanel.setLayout(relatedPsmsJPanelLayout);
        relatedPsmsJPanelLayout.setHorizontalGroup(relatedPsmsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.psmsRelatedPeptidesJLayeredPane, -1, 500, Short.MAX_VALUE));
        relatedPsmsJPanelLayout.setVerticalGroup(relatedPsmsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.psmsRelatedPeptidesJLayeredPane, -1, 437, Short.MAX_VALUE));
        this.psmSplitPane.setRightComponent(this.relatedPsmsJPanel);
        this.psmSpectraSplitPane.setLeftComponent(this.psmSplitPane);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.psmSpectraSplitPane, GroupLayout.Alignment.LEADING).addComponent(this.modificationAndPeptideSelectionPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.modificationAndPeptideSelectionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.psmSpectraSplitPane, -1, 442, Short.MAX_VALUE).addContainerGap()));
    }

    private void peptidesTableKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 38 || evt.getKeyCode() == 40 || evt.getKeyCode() == 33 || evt.getKeyCode() == 34) {
            this.peptidesTableMouseReleased(null);
        }
    }

    private void relatedPeptidesTableKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 38 || evt.getKeyCode() == 40 || evt.getKeyCode() == 33 || evt.getKeyCode() == 34) {
            this.relatedPeptidesTableMouseReleased(null);
        }
    }

    private void selectedPsmsTableKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 38 || evt.getKeyCode() == 40 || evt.getKeyCode() == 33 || evt.getKeyCode() == 34) {
            this.selectedPsmsTableMouseReleased(null);
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        this.peptideTablesJSplitPane.setDividerLocation(this.peptideTablesJSplitPane.getHeight() / 2);
        this.psmSpectraSplitPane.setDividerLocation(this.psmSpectraSplitPane.getWidth() / 2);
        this.psmSplitPane.setDividerLocation(this.psmSplitPane.getHeight() / 2);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModificationsPanel.this.selectedPeptidesJSplitPane.setDividerLocation(ModificationsPanel.this.selectedPeptidesJSplitPane.getWidth() / 2);
                ModificationsPanel.this.updateUI();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModificationsPanel.this.modifiedPeptidesLayeredPane.getComponent(0).setBounds(ModificationsPanel.this.modifiedPeptidesLayeredPane.getWidth() - ModificationsPanel.this.modifiedPeptidesLayeredPane.getComponent(0).getWidth() - 10, -3, ModificationsPanel.this.modifiedPeptidesLayeredPane.getComponent(0).getWidth(), ModificationsPanel.this.modifiedPeptidesLayeredPane.getComponent(0).getHeight());
                ModificationsPanel.this.modifiedPeptidesLayeredPane.getComponent(1).setBounds(ModificationsPanel.this.modifiedPeptidesLayeredPane.getWidth() - ModificationsPanel.this.modifiedPeptidesLayeredPane.getComponent(1).getWidth() - 20, -3, ModificationsPanel.this.modifiedPeptidesLayeredPane.getComponent(1).getWidth(), ModificationsPanel.this.modifiedPeptidesLayeredPane.getComponent(1).getHeight());
                ModificationsPanel.this.modifiedPeptidesLayeredPane.getComponent(2).setBounds(ModificationsPanel.this.modifiedPeptidesLayeredPane.getWidth() - ModificationsPanel.this.modifiedPeptidesLayeredPane.getComponent(2).getWidth() - 5, -3, ModificationsPanel.this.modifiedPeptidesLayeredPane.getComponent(2).getWidth(), ModificationsPanel.this.modifiedPeptidesLayeredPane.getComponent(2).getHeight());
                ModificationsPanel.this.modifiedPeptidesLayeredPane.getComponent(3).setBounds(0, 0, ModificationsPanel.this.modifiedPeptidesLayeredPane.getWidth(), ModificationsPanel.this.modifiedPeptidesLayeredPane.getHeight());
                ModificationsPanel.this.modifiedPeptidesLayeredPane.revalidate();
                ModificationsPanel.this.modifiedPeptidesLayeredPane.repaint();
                ModificationsPanel.this.relatedPeptiesLayeredPane.getComponent(0).setBounds(ModificationsPanel.this.relatedPeptiesLayeredPane.getWidth() - ModificationsPanel.this.relatedPeptiesLayeredPane.getComponent(0).getWidth() - 10, -5, ModificationsPanel.this.relatedPeptiesLayeredPane.getComponent(0).getWidth(), ModificationsPanel.this.relatedPeptiesLayeredPane.getComponent(0).getHeight());
                ModificationsPanel.this.relatedPeptiesLayeredPane.getComponent(1).setBounds(ModificationsPanel.this.relatedPeptiesLayeredPane.getWidth() - ModificationsPanel.this.relatedPeptiesLayeredPane.getComponent(1).getWidth() - 20, -5, ModificationsPanel.this.relatedPeptiesLayeredPane.getComponent(1).getWidth(), ModificationsPanel.this.relatedPeptiesLayeredPane.getComponent(1).getHeight());
                ModificationsPanel.this.relatedPeptiesLayeredPane.getComponent(2).setBounds(ModificationsPanel.this.relatedPeptiesLayeredPane.getWidth() - ModificationsPanel.this.relatedPeptiesLayeredPane.getComponent(2).getWidth() - 5, -3, ModificationsPanel.this.relatedPeptiesLayeredPane.getComponent(2).getWidth(), ModificationsPanel.this.relatedPeptiesLayeredPane.getComponent(2).getHeight());
                ModificationsPanel.this.relatedPeptiesLayeredPane.getComponent(3).setBounds(0, 0, ModificationsPanel.this.relatedPeptiesLayeredPane.getWidth(), ModificationsPanel.this.relatedPeptiesLayeredPane.getHeight());
                ModificationsPanel.this.relatedPeptiesLayeredPane.revalidate();
                ModificationsPanel.this.relatedPeptiesLayeredPane.repaint();
                ModificationsPanel.this.modificationLayeredLayeredPane.getComponent(0).setBounds(ModificationsPanel.this.modificationLayeredLayeredPane.getWidth() - ModificationsPanel.this.modificationLayeredLayeredPane.getComponent(0).getWidth() - 10, -5, ModificationsPanel.this.modificationLayeredLayeredPane.getComponent(0).getWidth(), ModificationsPanel.this.modificationLayeredLayeredPane.getComponent(0).getHeight());
                ModificationsPanel.this.modificationLayeredLayeredPane.getComponent(1).setBounds(ModificationsPanel.this.modificationLayeredLayeredPane.getWidth() - ModificationsPanel.this.modificationLayeredLayeredPane.getComponent(1).getWidth() - 5, -3, ModificationsPanel.this.modificationLayeredLayeredPane.getComponent(1).getWidth(), ModificationsPanel.this.modificationLayeredLayeredPane.getComponent(1).getHeight());
                ModificationsPanel.this.modificationLayeredLayeredPane.getComponent(2).setBounds(0, 0, ModificationsPanel.this.modificationLayeredLayeredPane.getWidth(), ModificationsPanel.this.modificationLayeredLayeredPane.getHeight());
                ModificationsPanel.this.modificationLayeredLayeredPane.revalidate();
                ModificationsPanel.this.modificationLayeredLayeredPane.repaint();
                ModificationsPanel.this.psmsModPeptidesLayeredPane.getComponent(0).setBounds(ModificationsPanel.this.psmsModPeptidesLayeredPane.getWidth() - ModificationsPanel.this.psmsModPeptidesLayeredPane.getComponent(0).getWidth() - 10, -5, ModificationsPanel.this.psmsModPeptidesLayeredPane.getComponent(0).getWidth(), ModificationsPanel.this.psmsModPeptidesLayeredPane.getComponent(0).getHeight());
                ModificationsPanel.this.psmsModPeptidesLayeredPane.getComponent(1).setBounds(ModificationsPanel.this.psmsModPeptidesLayeredPane.getWidth() - ModificationsPanel.this.psmsModPeptidesLayeredPane.getComponent(1).getWidth() - 20, -5, ModificationsPanel.this.psmsModPeptidesLayeredPane.getComponent(1).getWidth(), ModificationsPanel.this.psmsModPeptidesLayeredPane.getComponent(1).getHeight());
                ModificationsPanel.this.psmsModPeptidesLayeredPane.getComponent(2).setBounds(ModificationsPanel.this.psmsModPeptidesLayeredPane.getWidth() - ModificationsPanel.this.psmsModPeptidesLayeredPane.getComponent(2).getWidth() - 5, -3, ModificationsPanel.this.psmsModPeptidesLayeredPane.getComponent(2).getWidth(), ModificationsPanel.this.psmsModPeptidesLayeredPane.getComponent(2).getHeight());
                ModificationsPanel.this.psmsModPeptidesLayeredPane.getComponent(3).setBounds(0, 0, ModificationsPanel.this.psmsModPeptidesLayeredPane.getWidth(), ModificationsPanel.this.psmsModPeptidesLayeredPane.getHeight());
                ModificationsPanel.this.psmsModPeptidesLayeredPane.revalidate();
                ModificationsPanel.this.psmsModPeptidesLayeredPane.repaint();
                ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.getComponent(0).setBounds(ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.getWidth() - ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.getComponent(0).getWidth() - 10, -5, ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.getComponent(0).getWidth(), ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.getComponent(0).getHeight());
                ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.getComponent(1).setBounds(ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.getWidth() - ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.getComponent(1).getWidth() - 20, -5, ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.getComponent(1).getWidth(), ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.getComponent(1).getHeight());
                ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.getComponent(2).setBounds(ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.getWidth() - ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.getComponent(2).getWidth() - 5, -3, ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.getComponent(2).getWidth(), ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.getComponent(2).getHeight());
                ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.getComponent(3).setBounds(0, 0, ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.getWidth(), ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.getHeight());
                ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.revalidate();
                ModificationsPanel.this.psmsRelatedPeptidesJLayeredPane.repaint();
                ModificationsPanel.this.spectrumLayeredPane.getComponent(0).setBounds(ModificationsPanel.this.spectrumLayeredPane.getWidth() - ModificationsPanel.this.spectrumLayeredPane.getComponent(0).getWidth() - 10, -5, ModificationsPanel.this.spectrumLayeredPane.getComponent(0).getWidth(), ModificationsPanel.this.spectrumLayeredPane.getComponent(0).getHeight());
                ModificationsPanel.this.spectrumLayeredPane.getComponent(1).setBounds(ModificationsPanel.this.spectrumLayeredPane.getWidth() - ModificationsPanel.this.spectrumLayeredPane.getComponent(1).getWidth() - 20, -5, ModificationsPanel.this.spectrumLayeredPane.getComponent(1).getWidth(), ModificationsPanel.this.spectrumLayeredPane.getComponent(1).getHeight());
                ModificationsPanel.this.spectrumLayeredPane.getComponent(2).setBounds(ModificationsPanel.this.spectrumLayeredPane.getWidth() - ModificationsPanel.this.spectrumLayeredPane.getComponent(2).getWidth() - 5, -3, ModificationsPanel.this.spectrumLayeredPane.getComponent(2).getWidth(), ModificationsPanel.this.spectrumLayeredPane.getComponent(2).getHeight());
                ModificationsPanel.this.spectrumLayeredPane.getComponent(3).setBounds(0, 0, ModificationsPanel.this.spectrumLayeredPane.getWidth(), ModificationsPanel.this.spectrumLayeredPane.getHeight());
                ModificationsPanel.this.spectrumLayeredPane.revalidate();
                ModificationsPanel.this.spectrumLayeredPane.repaint();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ModificationsPanel.this.peptideShakerGUI.getUserParameters().showSliders()) {
                            ModificationsPanel.this.slidersSplitPane.setDividerLocation(ModificationsPanel.this.slidersSplitPane.getWidth() - 30);
                        } else {
                            ModificationsPanel.this.slidersSplitPane.setDividerLocation(ModificationsPanel.this.slidersSplitPane.getWidth());
                        }
                    }
                });
            }
        });
    }

    private void peptidesTableMouseReleased(MouseEvent evt) {
        final MouseEvent finalEvt = evt;
        this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(false);
        this.progressDialog.setTitle("Getting Peptides. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ModificationsPanel.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("DisplayThread"){

            @Override
            public void run() {
                ModificationsPanel.this.relatedSelected = false;
                if (!ModificationsPanel.this.progressDialog.isRunCanceled()) {
                    ModificationsPanel.this.updateRelatedPeptidesTable(ModificationsPanel.this.progressDialog);
                }
                if (!ModificationsPanel.this.progressDialog.isRunCanceled()) {
                    ModificationsPanel.this.updateSelectedPsmTable(ModificationsPanel.this.progressDialog, true);
                }
                if (!ModificationsPanel.this.progressDialog.isRunCanceled()) {
                    ModificationsPanel.this.updateRelatedPsmTable(ModificationsPanel.this.progressDialog, false);
                }
                if (!ModificationsPanel.this.progressDialog.isRunCanceled()) {
                    ModificationsPanel.this.updateModificationProfiles(ModificationsPanel.this.progressDialog);
                }
                if (!ModificationsPanel.this.progressDialog.isRunCanceled()) {
                    ModificationsPanel.this.updateModificationProfilesTable(ModificationsPanel.this.progressDialog);
                }
                if (!ModificationsPanel.this.progressDialog.isRunCanceled()) {
                    ModificationsPanel.this.newItemSelection();
                }
                if (finalEvt != null) {
                    int row = ModificationsPanel.this.peptidesTable.rowAtPoint(finalEvt.getPoint());
                    int column = ModificationsPanel.this.peptidesTable.columnAtPoint(finalEvt.getPoint());
                    if (row != -1 && !ModificationsPanel.this.progressDialog.isRunCanceled()) {
                        ModificationsPanel.this.peptidesTable.setRowSelectionInterval(row, row);
                        if (column == ModificationsPanel.this.peptidesTable.getColumn("PI").getModelIndex()) {
                            ModificationsPanel.this.progressDialog.setRunFinished();
                            try {
                                long peptideKey = ModificationsPanel.this.getSelectedPeptide(false);
                                new ProteinInferencePeptideLevelDialog(ModificationsPanel.this.peptideShakerGUI, true, peptideKey, null, ModificationsPanel.this.peptideShakerGUI.getGeneMaps());
                            }
                            catch (Exception e) {
                                ModificationsPanel.this.peptideShakerGUI.catchException(e);
                            }
                        } else if (column == ModificationsPanel.this.peptidesTable.getColumn("Modification").getModelIndex()) {
                            if (ModificationsPanel.this.peptidesTable.getValueAt(row, column) != null && (Integer)ModificationsPanel.this.peptidesTable.getValueAt(row, column) != -1) {
                                ModificationsPanel.this.progressDialog.setRunFinished();
                                new ModificationSiteInferenceDialog(ModificationsPanel.this.peptideShakerGUI, ModificationsPanel.this.getSelectedPeptide(), ModificationsPanel.this.modificationFactory.getModification(ModificationsPanel.this.getSelectedModification()));
                            }
                        } else if (column == ModificationsPanel.this.peptidesTable.getColumn("   ").getModelIndex()) {
                            try {
                                long peptideKey = ModificationsPanel.this.getSelectedPeptide(false);
                                PSParameter psParameter = (PSParameter)((PeptideMatch)ModificationsPanel.this.peptideShakerGUI.getIdentification().retrieveObject(peptideKey)).getUrParam((UrParameter)PSParameter.dummy);
                                if (!psParameter.getStarred()) {
                                    ModificationsPanel.this.peptideShakerGUI.getStarHider().starPeptide(peptideKey);
                                } else {
                                    ModificationsPanel.this.peptideShakerGUI.getStarHider().unStarPeptide(peptideKey);
                                }
                                ModificationsPanel.this.peptideShakerGUI.setDataSaved(false);
                            }
                            catch (Exception e) {
                                ModificationsPanel.this.peptideShakerGUI.catchException(e);
                            }
                        }
                    }
                }
                ModificationsPanel.this.progressDialog.setRunFinished();
            }
        }.start();
    }

    private void relatedPeptidesTableMouseReleased(MouseEvent evt) {
        final MouseEvent finalEvt = evt;
        this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Getting Related Peptides. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ModificationsPanel.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }).start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModificationsPanel.this.relatedSelected = true;
                if (!ModificationsPanel.this.progressDialog.isRunCanceled()) {
                    ModificationsPanel.this.updateSelectedPsmTable(ModificationsPanel.this.progressDialog, false);
                }
                if (!ModificationsPanel.this.progressDialog.isRunCanceled()) {
                    ModificationsPanel.this.updateRelatedPsmTable(ModificationsPanel.this.progressDialog, true);
                }
                if (!ModificationsPanel.this.progressDialog.isRunCanceled()) {
                    ModificationsPanel.this.updateModificationProfiles(ModificationsPanel.this.progressDialog);
                }
                if (!ModificationsPanel.this.progressDialog.isRunCanceled()) {
                    ModificationsPanel.this.updateModificationProfilesTable(ModificationsPanel.this.progressDialog);
                }
                if (!ModificationsPanel.this.progressDialog.isRunCanceled()) {
                    ModificationsPanel.this.newItemSelection();
                }
                if (finalEvt != null && !ModificationsPanel.this.progressDialog.isRunCanceled()) {
                    int row = ModificationsPanel.this.relatedPeptidesTable.rowAtPoint(finalEvt.getPoint());
                    int column = ModificationsPanel.this.relatedPeptidesTable.columnAtPoint(finalEvt.getPoint());
                    if (row != -1) {
                        ModificationsPanel.this.relatedPeptidesTable.setRowSelectionInterval(row, row);
                        if (column == ModificationsPanel.this.relatedPeptidesTable.getColumn("PI").getModelIndex()) {
                            try {
                                long peptideKey = ModificationsPanel.this.getSelectedPeptide(true);
                                ModificationsPanel.this.progressDialog.setRunFinished();
                                new ProteinInferencePeptideLevelDialog(ModificationsPanel.this.peptideShakerGUI, true, peptideKey, null, ModificationsPanel.this.peptideShakerGUI.getGeneMaps());
                            }
                            catch (Exception e) {
                                ModificationsPanel.this.peptideShakerGUI.catchException(e);
                            }
                        } else if (column == ModificationsPanel.this.relatedPeptidesTable.getColumn("Modification").getModelIndex()) {
                            if (ModificationsPanel.this.relatedPeptidesTable.getValueAt(row, column) != null && (Integer)ModificationsPanel.this.relatedPeptidesTable.getValueAt(row, column) != -1) {
                                ModificationsPanel.this.progressDialog.setRunFinished();
                                new ModificationSiteInferenceDialog(ModificationsPanel.this.peptideShakerGUI, ModificationsPanel.this.getSelectedPeptide(), ModificationsPanel.this.modificationFactory.getModification(ModificationsPanel.this.getSelectedModification()));
                            }
                        } else if (column == ModificationsPanel.this.peptidesTable.getColumn("   ").getModelIndex()) {
                            try {
                                long peptideKey = ModificationsPanel.this.getSelectedPeptide(true);
                                PSParameter psParameter = (PSParameter)((PeptideMatch)ModificationsPanel.this.peptideShakerGUI.getIdentification().retrieveObject(peptideKey)).getUrParam((UrParameter)PSParameter.dummy);
                                if (!psParameter.getStarred()) {
                                    ModificationsPanel.this.peptideShakerGUI.getStarHider().starPeptide(peptideKey);
                                } else {
                                    ModificationsPanel.this.peptideShakerGUI.getStarHider().unStarPeptide(peptideKey);
                                }
                                ModificationsPanel.this.peptideShakerGUI.setDataSaved(false);
                            }
                            catch (Exception e) {
                                ModificationsPanel.this.peptideShakerGUI.catchException(e);
                            }
                        }
                    }
                }
                ModificationsPanel.this.progressDialog.setRunFinished();
            }
        });
    }

    private void selectedPsmsTableMouseReleased(MouseEvent evt) {
        if (evt != null) {
            int column = this.selectedPsmsTable.columnAtPoint(evt.getPoint());
            int row = this.selectedPsmsTable.rowAtPoint(evt.getPoint());
            if (column == this.selectedPsmsTable.getColumn("   ").getModelIndex()) {
                PeptideMatch peptideMatch = (PeptideMatch)this.identification.retrieveObject(this.getSelectedPeptide(false));
                int psmIndex = this.selectedPsmsTable.convertRowIndexToModel(row);
                long psmKey = peptideMatch.getSpectrumMatchesKeys()[psmIndex];
                SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(psmKey);
                PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam((UrParameter)PSParameter.dummy);
                if (!psParameter.getStarred()) {
                    this.peptideShakerGUI.getStarHider().starPsm(psmKey);
                } else {
                    this.peptideShakerGUI.getStarHider().unStarPsm(psmKey);
                }
                this.peptideShakerGUI.setDataSaved(false);
                this.selectedPsmsTable.revalidate();
                this.selectedPsmsTable.repaint();
            }
        }
        this.setCursor(new Cursor(3));
        try {
            this.relatedSelected = false;
            this.updateGraphics(null);
        }
        catch (Exception e) {
            this.peptideShakerGUI.catchException(e);
            e.printStackTrace();
        }
        this.setCursor(new Cursor(0));
        this.spectrumTabbedPaneStateChanged(null);
        this.newItemSelection();
    }

    private void peptidesTableMouseMoved(MouseEvent evt) {
        int row = this.peptidesTable.rowAtPoint(evt.getPoint());
        int column = this.peptidesTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column != -1 && this.peptidesTable.getValueAt(row, column) != null) {
            if (column == this.peptidesTable.getColumn("Sequence").getModelIndex()) {
                this.setCursor(new Cursor(0));
                long peptideMatchKey = this.displayedPeptides.get((Integer)this.peptidesTable.getValueAt(row, 0) - 1);
                PeptideMatch peptideMatch = this.identification.getPeptideMatch(peptideMatchKey);
                this.peptidesTable.setToolTipText(this.peptideShakerGUI.getDisplayFeaturesGenerator().getPeptideModificationTooltipAsHtml(peptideMatch));
            } else if (column == this.peptidesTable.getColumn("PI").getModelIndex()) {
                this.setCursor(new Cursor(12));
            } else if (column == this.peptidesTable.getColumn("Modification").getModelIndex()) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
                this.peptidesTable.setToolTipText(null);
            }
        } else {
            this.peptidesTable.setToolTipText(null);
        }
    }

    private void peptidesTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void relatedPeptidesTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void relatedPeptidesTableMouseMoved(MouseEvent evt) {
        int row = this.relatedPeptidesTable.rowAtPoint(evt.getPoint());
        int column = this.relatedPeptidesTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column != -1 && this.relatedPeptidesTable.getValueAt(row, column) != null) {
            if (column == this.relatedPeptidesTable.getColumn("Sequence").getModelIndex()) {
                this.setCursor(new Cursor(0));
                try {
                    this.relatedPeptidesTable.setToolTipText(this.peptideShakerGUI.getDisplayFeaturesGenerator().getPeptideModificationTooltipAsHtml((PeptideMatch)this.identification.retrieveObject(this.relatedPeptides.get((Integer)this.relatedPeptidesTable.getValueAt(row, 0) - 1).longValue())));
                }
                catch (Exception e) {
                    this.peptideShakerGUI.catchException(e);
                    e.printStackTrace();
                }
            } else if (column == this.relatedPeptidesTable.getColumn("PI").getModelIndex()) {
                this.setCursor(new Cursor(12));
            } else if (column == this.relatedPeptidesTable.getColumn("Modification").getModelIndex()) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
                this.relatedPeptidesTable.setToolTipText(null);
            }
        } else {
            this.relatedPeptidesTable.setToolTipText(null);
        }
    }

    private void modificationJTableMouseReleased(MouseEvent evt) {
        final MouseEvent finalEvt = evt;
        final ModificationsPanel finalRef = this;
        this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(false);
        this.progressDialog.setTitle("Getting Modifications. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ModificationsPanel.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                int row = ModificationsPanel.this.modificationJTable.rowAtPoint(finalEvt.getPoint());
                int column = ModificationsPanel.this.modificationJTable.columnAtPoint(finalEvt.getPoint());
                if (row != -1 && column == ModificationsPanel.this.modificationJTable.getColumn("  ").getModelIndex()) {
                    Color newColor;
                    if (row != ModificationsPanel.this.currentModificationRow) {
                        ModificationsPanel.this.updatePeptideTable(ModificationsPanel.this.progressDialog);
                    }
                    if ((newColor = JColorChooser.showDialog(finalRef, "Pick a Color", (Color)ModificationsPanel.this.modificationJTable.getValueAt(row, column))) != null) {
                        ModificationsPanel.this.modificationJTable.setValueAt(newColor, row, column);
                        if (!((String)ModificationsPanel.this.modificationJTable.getValueAt(row, ModificationsPanel.this.modificationJTable.getColumn("Modification").getModelIndex())).equalsIgnoreCase("no modification")) {
                            ModificationsPanel.this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters().setColor((String)ModificationsPanel.this.modificationJTable.getValueAt(row, ModificationsPanel.this.modificationJTable.getColumn("  ").getModelIndex()), newColor.getRGB());
                            ModificationsPanel.this.peptideShakerGUI.updateModificationColorCoding();
                        }
                    }
                } else {
                    ModificationsPanel.this.updatePeptideTable(ModificationsPanel.this.progressDialog);
                }
                ModificationsPanel.this.currentModificationRow = row;
                ModificationsPanel.this.progressDialog.setRunFinished();
                ModificationsPanel.this.newItemSelection();
            }
        }).start();
    }

    private void modificationJTableKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 38 || evt.getKeyCode() == 40 || evt.getKeyCode() == 33 || evt.getKeyCode() == 34) {
            this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.progressDialog.setTitle("Getting Peptides. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ModificationsPanel.this.progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }).start();
            new Thread("DisplayThread"){

                @Override
                public void run() {
                    ModificationsPanel.this.updatePeptideTable(ModificationsPanel.this.progressDialog);
                    ModificationsPanel.this.progressDialog.setRunFinished();
                    ModificationsPanel.this.newItemSelection();
                }
            }.start();
        }
    }

    private void intensitySliderMouseWheelMoved(MouseWheelEvent evt) {
        this.spectrumAndFragmentIonJPanelMouseWheelMoved(evt);
    }

    private void intensitySliderStateChanged(ChangeEvent evt) {
        this.peptideShakerGUI.getIdentificationParameters().getAnnotationParameters().setIntensityLimit((double)Integer.valueOf(this.intensitySlider.getValue()).intValue() / 100.0);
        this.peptideShakerGUI.updateSpectrumAnnotations();
        this.peptideShakerGUI.setDataSaved(false);
        this.intensitySlider.setToolTipText("Annotation Level: " + this.intensitySlider.getValue() + "%");
        this.updateSpectrumSliderToolTip();
    }

    private void spectrumAndFragmentIonJPanelMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.isControlDown()) {
            if (evt.getWheelRotation() > 0) {
                this.accuracySlider.setValue(this.accuracySlider.getValue() - 1);
            } else {
                int oldValue = this.accuracySlider.getValue();
                int newValue = this.accuracySlider.getValue() + 1;
                this.accuracySlider.setValue(newValue);
                while (oldValue == this.accuracySlider.getValue()) {
                    this.accuracySlider.setValue(newValue++);
                }
            }
        } else if (evt.getWheelRotation() > 0) {
            this.intensitySlider.setValue(this.intensitySlider.getValue() - 1);
        } else {
            int oldValue = this.intensitySlider.getValue();
            int newValue = this.intensitySlider.getValue() + 1;
            this.intensitySlider.setValue(newValue);
            while (oldValue == this.intensitySlider.getValue()) {
                this.intensitySlider.setValue(newValue++);
            }
        }
        this.updateSpectrumSliderToolTip();
    }

    private void modificationJTableMouseMoved(MouseEvent evt) {
        int row = this.modificationJTable.rowAtPoint(evt.getPoint());
        int column = this.modificationJTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column == this.modificationJTable.getColumn("  ").getModelIndex()) {
            this.setCursor(new Cursor(12));
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void modificationJTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void selectedPsmsTableMouseMoved(MouseEvent evt) {
        int row = this.selectedPsmsTable.rowAtPoint(evt.getPoint());
        int column = this.selectedPsmsTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column != -1 && this.selectedPsmsTable.getValueAt(row, column) != null) {
            if (column == this.selectedPsmsTable.getColumn("Sequence").getModelIndex()) {
                PeptideMatch peptideMatch = this.identification.getPeptideMatch(this.getSelectedPeptide(false));
                long spectrumMatchKey = peptideMatch.getSpectrumMatchesKeys()[row];
                SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(spectrumMatchKey);
                this.selectedPsmsTable.setToolTipText(this.peptideShakerGUI.getDisplayFeaturesGenerator().getPeptideModificationTooltipAsHtml(spectrumMatch));
            } else {
                this.selectedPsmsTable.setToolTipText(null);
            }
        } else {
            this.selectedPsmsTable.setToolTipText(null);
        }
    }

    private void accuracySliderStateChanged(ChangeEvent evt) {
        SearchParameters searchParameters = this.peptideShakerGUI.getIdentificationParameters().getSearchParameters();
        double accuracy = (double)this.accuracySlider.getValue() / 100.0 * searchParameters.getFragmentIonAccuracy();
        this.peptideShakerGUI.getIdentificationParameters().getAnnotationParameters().setFragmentIonAccuracy(accuracy);
        this.peptideShakerGUI.updateSpectrumAnnotations();
        this.peptideShakerGUI.setDataSaved(false);
        this.accuracySlider.setToolTipText("Annotation Accuracy: " + Util.roundDouble((double)accuracy, (int)2) + " " + searchParameters.getFragmentAccuracyType());
        this.updateSpectrumSliderToolTip();
    }

    private void accuracySliderMouseWheelMoved(MouseWheelEvent evt) {
        this.spectrumAndFragmentIonJPanelMouseWheelMoved(evt);
    }

    private void relatedPsmsTableMouseReleased(MouseEvent evt) {
        if (evt != null) {
            int column = this.relatedPsmsTable.columnAtPoint(evt.getPoint());
            int row = this.relatedPsmsTable.rowAtPoint(evt.getPoint());
            if (column == this.relatedPsmsTable.getColumn("   ").getModelIndex()) {
                PeptideMatch peptideMatch = this.identification.getPeptideMatch(this.getSelectedPeptide(true));
                long psmKey = peptideMatch.getSpectrumMatchesKeys()[this.relatedPsmsTable.convertRowIndexToModel(row)];
                SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(psmKey);
                PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam((UrParameter)PSParameter.dummy);
                if (!psParameter.getStarred()) {
                    this.peptideShakerGUI.getStarHider().starPsm(psmKey);
                } else {
                    this.peptideShakerGUI.getStarHider().unStarPsm(psmKey);
                }
                this.peptideShakerGUI.setDataSaved(false);
                this.relatedPsmsTable.revalidate();
                this.relatedPsmsTable.repaint();
            }
        }
        this.setCursor(new Cursor(3));
        try {
            this.relatedSelected = true;
            this.updateGraphics(null);
        }
        catch (Exception e) {
            this.peptideShakerGUI.catchException(e);
            e.printStackTrace();
        }
        this.setCursor(new Cursor(0));
        this.spectrumTabbedPaneStateChanged(null);
        this.newItemSelection();
    }

    private void relatedPsmsTableMouseMoved(MouseEvent evt) {
        int row = this.relatedPsmsTable.rowAtPoint(evt.getPoint());
        int column = this.relatedPsmsTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column != -1 && this.relatedPsmsTable.getValueAt(row, column) != null) {
            if (column == this.relatedPsmsTable.getColumn("Sequence").getModelIndex()) {
                PeptideMatch peptideMatch = this.identification.getPeptideMatch(this.getSelectedPeptide(true));
                long psmKey = peptideMatch.getSpectrumMatchesKeys()[this.relatedPsmsTable.convertRowIndexToModel(row)];
                SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(psmKey);
                this.relatedPsmsTable.setToolTipText(this.peptideShakerGUI.getDisplayFeaturesGenerator().getPeptideModificationTooltipAsHtml(spectrumMatch));
            } else {
                this.relatedPsmsTable.setToolTipText(null);
            }
        } else {
            this.relatedPsmsTable.setToolTipText(null);
        }
    }

    private void relatedPsmsTableKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 38 || evt.getKeyCode() == 40 || evt.getKeyCode() == 33 || evt.getKeyCode() == 34) {
            this.relatedPsmsTableMouseReleased(null);
        }
    }

    private void modificationProfileHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/ModificationPanel.html"), "#Peptides", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Modification Analysis - Help");
        this.setCursor(new Cursor(0));
    }

    private void modificationProfileHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void modificationProfileHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportModifiedPeptideProfileJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportModifiedPeptideProfileJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void relatedProfileHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void relatedProfileHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void relatedProfileHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/ModificationPanel.html"), "#RelatedPeptides", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Modification Analysis - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportRelatedPeptideProfileJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportRelatedPeptideProfileJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void modificationSelectionHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void modificationSelectionHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void modificationSelectionHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/ModificationPanel.html"), "#Selection", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Modification Analysis - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportModifiedPsmsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportModifiedPsmsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportModifiedPsmsJButtonActionPerformed(ActionEvent evt) {
        this.copyTableContentToFileOrClipboard(TableIndex.MODIFIED_PSMS_TABLE);
    }

    private void modifiedPsmsHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void modifiedPsmsHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void modifiedPsmsHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/ModificationPanel.html"), "#PSMs", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Modification Analysis - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportRelatedPsmsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportRelatedPsmsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportRelatedPsmsJButtonActionPerformed(ActionEvent evt) {
        this.copyTableContentToFileOrClipboard(TableIndex.RELATED_PSMS_TABLE);
    }

    private void relatedPsmsHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void relatedPsmsHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void relatedPsmsHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/ModificationPanel.html"), "#RelatedPSMs", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Modification Analysis - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportSpectrumJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportSpectrumJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void spectrumHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void spectrumHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void spectrumHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        int spectrumTabIndex = this.spectrumTabbedPane.getSelectedIndex();
        if (spectrumTabIndex == 0) {
            new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/ModificationPanel.html"), "#Modification", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Modification Analysis - Help");
        } else if (spectrumTabIndex == 1) {
            new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/ModificationPanel.html"), "#DeltaScore", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Modification Analysis - Help");
        } else if (spectrumTabIndex == 2) {
            new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/ModificationPanel.html"), "#Spectrum", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Modification Analysis - Help");
        }
        this.setCursor(new Cursor(0));
    }

    private void exportSpectrumJButtonMouseReleased(MouseEvent evt) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Spectrum");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsPanel.this.peptideShakerGUI.exportSpectrumAsFigure();
            }
        });
        popupMenu.add(menuItem);
        menuItem = new JMenuItem("Spectrum as MGF");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    ModificationsPanel.this.peptideShakerGUI.exportSelectedSpectraAsMgf();
                }
                catch (Exception e) {
                    ModificationsPanel.this.peptideShakerGUI.catchException(e);
                }
            }
        });
        popupMenu.add(menuItem);
        menuItem = new JMenuItem("Spectrum Annotation");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    ModificationsPanel.this.peptideShakerGUI.exportAnnotatedSpectrum();
                }
                catch (Exception e) {
                    ModificationsPanel.this.peptideShakerGUI.catchException(e);
                }
            }
        });
        popupMenu.add(menuItem);
        int index = this.spectrumTabbedPane.getSelectedIndex();
        if (index == 0) {
            menuItem = new JMenuItem("Table to Clipboard");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ModificationsPanel.this.copyTableContentToFileOrClipboard(TableIndex.A_SCORES_TABLE);
                }
            });
            popupMenu.add(new JSeparator());
            popupMenu.add(menuItem);
        } else if (index == 1) {
            menuItem = new JMenuItem("Table to Clipboard");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ModificationsPanel.this.copyTableContentToFileOrClipboard(TableIndex.DELTA_SCORES_TABLE);
                }
            });
            popupMenu.add(new JSeparator());
            popupMenu.add(menuItem);
        }
        popupMenu.show(this.exportSpectrumJButton, evt.getX(), evt.getY());
    }

    private void exportRelatedPeptideProfileJButtonMouseReleased(MouseEvent evt) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Table to File");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsPanel.this.copyTableContentToFileOrClipboard(TableIndex.RELATED_PEPTIDES_TABLE);
            }
        });
        popupMenu.add(menuItem);
        if (this.modificationProfileRelatedPeptideJPanel.getComponentCount() == 2) {
            menuItem = new JMenuItem("Modification Profile Plot");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    new ExportGraphicsDialog((JFrame)ModificationsPanel.this.peptideShakerGUI, ModificationsPanel.this.peptideShakerGUI.getNormalIcon(), ModificationsPanel.this.peptideShakerGUI.getWaitingIcon(), true, ModificationsPanel.this.modificationProfileRelatedPeptideJPanel.getComponent(1), ModificationsPanel.this.peptideShakerGUI.getLastSelectedFolder());
                }
            });
            popupMenu.add(menuItem);
        }
        popupMenu.show(this.exportRelatedPeptideProfileJButton, evt.getX(), evt.getY());
    }

    private void exportModifiedPeptideProfileJButtonMouseReleased(MouseEvent evt) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Table to File");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsPanel.this.copyTableContentToFileOrClipboard(TableIndex.MODIFIED_PEPTIDES_TABLE);
            }
        });
        popupMenu.add(menuItem);
        menuItem = new JMenuItem("Modification Profile Plot");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new ExportGraphicsDialog((JFrame)ModificationsPanel.this.peptideShakerGUI, ModificationsPanel.this.peptideShakerGUI.getNormalIcon(), ModificationsPanel.this.peptideShakerGUI.getWaitingIcon(), true, ModificationsPanel.this.modificationProfileSelectedPeptideJPanel.getComponent(1), ModificationsPanel.this.peptideShakerGUI.getLastSelectedFolder());
            }
        });
        popupMenu.add(menuItem);
        popupMenu.show(this.exportModifiedPeptideProfileJButton, evt.getX(), evt.getY());
    }

    private void spectrumTabbedPaneStateChanged(ChangeEvent evt) {
        int index;
        if (this.peptideShakerGUI.getAnnotationMenuBar() != null && (index = this.spectrumTabbedPane.getSelectedIndex()) == 2) {
            this.spectrumAnnotationMenuPanel.removeAll();
            this.spectrumAnnotationMenuPanel.add(this.peptideShakerGUI.getAnnotationMenuBar());
            this.peptideShakerGUI.updateAnnotationMenuBarVisableOptions(true, false, false, false, this.selectedPsmsTable.getSelectedRow() != -1 && this.relatedPsmsTable.getSelectedRow() == -1 || this.selectedPsmsTable.getSelectedRow() == -1 && this.relatedPsmsTable.getSelectedRow() != -1);
        }
    }

    public long[] getDisplayedProteinMatches() {
        return Arrays.stream(this.getDisplayedPeptides()).flatMap(peptideKey -> this.identification.getProteinMatches(peptideKey).stream().mapToLong(a -> a)).distinct().toArray();
    }

    public long[] getDisplayedPeptides() {
        return LongStream.concat(this.displayedPeptides.stream().mapToLong(a -> a), this.relatedPeptides.stream().mapToLong(a -> a)).toArray();
    }

    public long[] getDisplayedSpectrumMatches() {
        return Arrays.stream(this.getDisplayedPeptides()).flatMap(peptideKey -> Arrays.stream(this.identification.getPeptideMatch(peptideKey).getSpectrumMatchesKeys())).toArray();
    }

    public void showSparkLines(boolean showSparkLines) {
        ((JSparklinesBarChartTableCellRenderer)this.peptidesTable.getColumn("Peptide").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.relatedPeptidesTable.getColumn("Peptide").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.selectedPsmsTable.getColumn("Charge").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesIntervalChartTableCellRenderer)this.selectedPsmsTable.getColumn("RT").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.relatedPsmsTable.getColumn("Charge").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesIntervalChartTableCellRenderer)this.relatedPsmsTable.getColumn("RT").getCellRenderer()).showNumbers(!showSparkLines);
        this.updatePsmScoresCellRenderers();
        this.psmAScoresTable.revalidate();
        this.psmAScoresTable.repaint();
        this.psmDeltaScoresTable.revalidate();
        this.psmDeltaScoresTable.repaint();
        this.peptidesTable.revalidate();
        this.peptidesTable.repaint();
        this.relatedPeptidesTable.revalidate();
        this.relatedPeptidesTable.repaint();
        this.selectedPsmsTable.revalidate();
        this.selectedPsmsTable.repaint();
        this.relatedPsmsTable.revalidate();
        this.relatedPsmsTable.repaint();
    }

    private void createPeptideMap(ProgressDialogX progressDialogX) {
        PeptideMatch peptideMatch;
        HashSet<Long> notModifiedPeptides = new HashSet<Long>();
        PeptideMatchesIterator peptideMatchesIterator = this.identification.getPeptideMatchesIterator((WaitingHandler)progressDialogX);
        while ((peptideMatch = peptideMatchesIterator.next()) != null) {
            long peptideKey = peptideMatch.getKey();
            Peptide peptide = peptideMatch.getPeptide();
            if (!PeptideUtils.isDecoy((Peptide)peptide, (SequenceProvider)this.peptideShakerGUI.getSequenceProvider())) {
                if (peptide.getVariableModifications().length == 0) {
                    notModifiedPeptides.add(peptideKey);
                } else {
                    for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
                        String modName = modificationMatch.getModification();
                        HashSet<Long> peptideKeysForModifications = this.peptideMap.get(modName);
                        if (peptideKeysForModifications == null) {
                            peptideKeysForModifications = new HashSet();
                            this.peptideMap.put(modName, peptideKeysForModifications);
                        }
                        peptideKeysForModifications.add(peptideKey);
                    }
                }
            }
            if (progressDialogX == null) continue;
            if (progressDialogX.isRunCanceled()) {
                return;
            }
            progressDialogX.increasePrimaryProgressCounter();
        }
        this.peptideMap.put(NO_MODIFICATION, notModifiedPeptides);
    }

    public String getSelectedModification() {
        return (String)this.modificationJTable.getValueAt(this.modificationJTable.getSelectedRow(), this.modificationJTable.getColumn("Modification").getModelIndex());
    }

    public void displayResults() {
        this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Updating Data. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ModificationsPanel.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }).start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SpectrumProvider spectrumProvider = ModificationsPanel.this.peptideShakerGUI.getSpectrumProvider();
                    ModificationsPanel.this.selectedPsmsTable.getColumn("RT").setCellRenderer((TableCellRenderer)new JSparklinesIntervalChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(0.0), Double.valueOf(spectrumProvider.getMaxPrecRT()), Double.valueOf(spectrumProvider.getMaxPrecRT() / 50.0), ModificationsPanel.this.peptideShakerGUI.getSparklineColor(), ModificationsPanel.this.peptideShakerGUI.getSparklineColor()));
                    ((JSparklinesIntervalChartTableCellRenderer)ModificationsPanel.this.selectedPsmsTable.getColumn("RT").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() + 5);
                    ((JSparklinesIntervalChartTableCellRenderer)ModificationsPanel.this.selectedPsmsTable.getColumn("RT").getCellRenderer()).showReferenceLine(true, 0.02, Color.BLACK);
                    ModificationsPanel.this.relatedPsmsTable.getColumn("RT").setCellRenderer((TableCellRenderer)new JSparklinesIntervalChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(0.0), Double.valueOf(spectrumProvider.getMaxPrecRT()), Double.valueOf(spectrumProvider.getMaxPrecRT() / 50.0), ModificationsPanel.this.peptideShakerGUI.getSparklineColor(), ModificationsPanel.this.peptideShakerGUI.getSparklineColor()));
                    ((JSparklinesIntervalChartTableCellRenderer)ModificationsPanel.this.relatedPsmsTable.getColumn("RT").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() + 5);
                    ((JSparklinesIntervalChartTableCellRenderer)ModificationsPanel.this.relatedPsmsTable.getColumn("RT").getCellRenderer()).showReferenceLine(true, 0.02, Color.BLACK);
                    ModificationsPanel.this.identification = ModificationsPanel.this.peptideShakerGUI.getIdentification();
                    ModificationsPanel.this.createPeptideMap(ModificationsPanel.this.progressDialog);
                    DefaultTableModel dm = (DefaultTableModel)ModificationsPanel.this.modificationJTable.getModel();
                    dm.getDataVector().removeAllElements();
                    dm.fireTableDataChanged();
                    ModificationParameters modificationProfile = ModificationsPanel.this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters();
                    ArrayList allVariableMods = ModificationsPanel.this.modificationFactory.getModifications();
                    Collections.sort(allVariableMods);
                    for (String tempFixed : ModificationsPanel.this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters().getFixedModifications()) {
                        allVariableMods.remove(tempFixed);
                    }
                    for (String modification : allVariableMods) {
                        if (modification.equalsIgnoreCase(ModificationsPanel.NO_MODIFICATION) || !ModificationsPanel.this.peptideMap.containsKey(modification)) continue;
                        ((DefaultTableModel)ModificationsPanel.this.modificationJTable.getModel()).addRow(new Object[]{new Color(modificationProfile.getColor(modification)), modification, ((HashSet)ModificationsPanel.this.peptideMap.get(modification)).size()});
                    }
                    ((DefaultTableModel)ModificationsPanel.this.modificationJTable.getModel()).addRow(new Object[]{Color.lightGray, ModificationsPanel.NO_MODIFICATION, ((HashSet)ModificationsPanel.this.peptideMap.get(ModificationsPanel.NO_MODIFICATION)).size()});
                    ((TitledBorder)ModificationsPanel.this.modificationLayeredPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Variable Modifications (" + ModificationsPanel.this.modificationJTable.getRowCount() + ")");
                    ModificationsPanel.this.modificationLayeredPanel.repaint();
                    SearchParameters searchParameters = ModificationsPanel.this.peptideShakerGUI.getIdentificationParameters().getSearchParameters();
                    double accuracy = (double)ModificationsPanel.this.accuracySlider.getValue() / 100.0 * searchParameters.getFragmentIonAccuracy();
                    ModificationsPanel.this.accuracySlider.setToolTipText("Annotation Accuracy: " + Util.roundDouble((double)accuracy, (int)2) + " " + searchParameters.getFragmentAccuracyType());
                    ModificationsPanel.this.intensitySlider.setToolTipText("Annotation Level: " + ModificationsPanel.this.intensitySlider.getValue() + "%");
                    int maxCharge = ModificationsPanel.this.peptideShakerGUI.getMetrics().getMaxCharge();
                    ((JSparklinesBarChartTableCellRenderer)ModificationsPanel.this.selectedPsmsTable.getColumn("Charge").getCellRenderer()).setMaxValue((double)maxCharge);
                    ((JSparklinesBarChartTableCellRenderer)ModificationsPanel.this.relatedPsmsTable.getColumn("Charge").getCellRenderer()).setMaxValue((double)maxCharge);
                    ModificationsPanel.this.exportModifiedPeptideProfileJButton.setEnabled(true);
                    ModificationsPanel.this.exportRelatedPeptideProfileJButton.setEnabled(true);
                    ModificationsPanel.this.exportSpectrumJButton.setEnabled(true);
                    ModificationsPanel.this.exportModifiedPsmsJButton.setEnabled(true);
                    ModificationsPanel.this.exportRelatedPsmsJButton.setEnabled(true);
                    ModificationsPanel.this.selectedPeptidesJSplitPane.setDividerLocation(0.5);
                    ModificationsPanel.this.relatedPeptidesJSplitPane.setDividerLocation(0.5);
                    ModificationsPanel.this.peptideShakerGUI.setUpdated(3, true);
                    if (ModificationsPanel.this.currentModificationRow != -1) {
                        ModificationsPanel.this.updatePeptideTable(ModificationsPanel.this.progressDialog);
                    }
                    ModificationsPanel.this.progressDialog.setRunFinished();
                }
                catch (Exception e) {
                    ModificationsPanel.this.peptideShakerGUI.catchException(e);
                }
            }
        });
    }

    private void updateSelection(ProgressDialogX progressDialog) {
        long psmKey;
        SpectrumMatch spectrumMatch;
        long selectedKey = this.peptideShakerGUI.getSelectedPeptideKey();
        String spectrumFile = this.peptideShakerGUI.getSelectedSpectrumFile();
        String spectrumTitle = this.peptideShakerGUI.getSelectedSpectrumTitle();
        if (selectedKey == ExperimentObject.NO_KEY && spectrumFile != null && spectrumTitle != null && (spectrumMatch = this.identification.getSpectrumMatch(psmKey = SpectrumMatch.getKey((String)spectrumFile, (String)spectrumTitle))) != null && spectrumMatch.getBestPeptideAssumption() != null) {
            Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
            selectedKey = peptide.getMatchingKey(this.peptideShakerGUI.getIdentificationParameters().getSequenceMatchingParameters());
        }
        if (selectedKey != ExperimentObject.NO_KEY) {
            int row = 0;
            for (long displayedPeptide : this.displayedPeptides) {
                if (displayedPeptide == selectedKey) {
                    this.peptidesTable.setRowSelectionInterval(row, row);
                    this.peptidesTable.scrollRectToVisible(this.peptidesTable.getCellRect(row, 0, false));
                    this.relatedSelected = false;
                    this.updateRelatedPeptidesTable(progressDialog);
                    this.updateSelectedPsmTable(progressDialog, true);
                    this.updateRelatedPsmTable(progressDialog, false);
                    this.updateModificationProfiles(progressDialog);
                    this.updateModificationProfilesTable(progressDialog);
                    if (this.relatedPeptidesTable.getSelectedRow() >= 0) {
                        this.relatedPeptidesTable.removeRowSelectionInterval(this.relatedPeptidesTable.getSelectedRow(), this.relatedPeptidesTable.getSelectedRow());
                    }
                    if (spectrumFile != null && spectrumTitle != null) {
                        long psmKey2 = SpectrumMatch.getKey((String)spectrumFile, (String)spectrumTitle);
                        row = 0;
                        PeptideMatch peptideMatch = (PeptideMatch)this.identification.retrieveObject(this.getSelectedPeptide(false));
                        for (long displayedPsm : peptideMatch.getSpectrumMatchesKeys()) {
                            if (displayedPsm == psmKey2) {
                                this.selectedPsmsTable.setRowSelectionInterval(row, row);
                                this.selectedPsmsTable.scrollRectToVisible(this.selectedPsmsTable.getCellRect(row, 0, false));
                                while (this.relatedPsmsTable.getSelectedRow() >= 0) {
                                    this.relatedPsmsTable.removeRowSelectionInterval(this.relatedPsmsTable.getSelectedRow(), this.relatedPsmsTable.getSelectedRow());
                                }
                                this.selectedPsmsTableMouseReleased(null);
                                return;
                            }
                            ++row;
                        }
                    }
                    this.selectedPsmsTable.setRowSelectionInterval(0, 0);
                    this.selectedPsmsTable.scrollRectToVisible(this.selectedPsmsTable.getCellRect(0, 0, false));
                    while (this.relatedPsmsTable.getSelectedRow() >= 0) {
                        this.relatedPsmsTable.removeRowSelectionInterval(this.relatedPsmsTable.getSelectedRow(), this.selectedPsmsTable.getSelectedRow());
                    }
                    this.selectedPsmsTableMouseReleased(null);
                    return;
                }
                ++row;
            }
            row = 0;
            for (long displayedPeptide : this.relatedPeptides) {
                if (displayedPeptide == selectedKey) {
                    this.relatedPeptidesTable.setRowSelectionInterval(row, row);
                    this.relatedPeptidesTable.scrollRectToVisible(this.relatedPeptidesTable.getCellRect(row, 0, false));
                    if (this.peptidesTable.getSelectedRow() >= 0) {
                        this.peptidesTable.removeRowSelectionInterval(this.peptidesTable.getSelectedRow(), this.peptidesTable.getSelectedRow());
                    }
                    this.relatedSelected = true;
                    this.updateSelectedPsmTable(progressDialog, false);
                    this.updateRelatedPsmTable(progressDialog, true);
                    this.updateModificationProfiles(progressDialog);
                    this.updateModificationProfilesTable(progressDialog);
                    if (spectrumFile != null && spectrumTitle != null) {
                        long psmKey3 = SpectrumMatch.getKey((String)spectrumFile, (String)spectrumTitle);
                        row = 0;
                        PeptideMatch peptideMatch = (PeptideMatch)this.identification.retrieveObject(this.getSelectedPeptide(true));
                        for (long displayedPsm : peptideMatch.getSpectrumMatchesKeys()) {
                            if (displayedPsm == psmKey3) {
                                this.relatedPsmsTable.setRowSelectionInterval(row, row);
                                this.relatedPsmsTable.scrollRectToVisible(this.relatedPsmsTable.getCellRect(row, 0, false));
                                while (this.selectedPsmsTable.getSelectedRow() >= 0) {
                                    this.selectedPsmsTable.removeRowSelectionInterval(this.selectedPsmsTable.getSelectedRow(), this.selectedPsmsTable.getSelectedRow());
                                }
                                this.relatedPsmsTableMouseReleased(null);
                                return;
                            }
                            ++row;
                        }
                    }
                    this.relatedPsmsTable.setRowSelectionInterval(0, 0);
                    this.relatedPsmsTable.scrollRectToVisible(this.relatedPsmsTable.getCellRect(0, 0, false));
                    while (this.selectedPsmsTable.getSelectedRow() >= 0) {
                        this.selectedPsmsTable.removeRowSelectionInterval(this.selectedPsmsTable.getSelectedRow(), this.selectedPsmsTable.getSelectedRow());
                    }
                    this.relatedPsmsTableMouseReleased(null);
                    return;
                }
                ++row;
            }
        }
    }

    public void updateSelection() {
        this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Updating Selection. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ModificationsPanel.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }).start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModificationsPanel.this.updateSelection(ModificationsPanel.this.progressDialog);
                ModificationsPanel.this.progressDialog.setRunFinished();
            }
        });
    }

    public void updatePeptideTable(ProgressDialogX progressDialog) {
        if (this.modificationJTable.getSelectedRow() != -1) {
            progressDialog.setTitle("Getting Peptides. Please Wait...");
            this.spectrumChartJPanel.removeAll();
            this.spectrumChartJPanel.revalidate();
            this.spectrumChartJPanel.repaint();
            TreeMap<Double, TreeSet<Long>> scoreToPeptideMap = new TreeMap<Double, TreeSet<Long>>();
            String modKey = (String)this.modificationJTable.getValueAt(this.modificationJTable.getSelectedRow(), this.modificationJTable.getColumn("Modification").getModelIndex());
            HashSet<Long> modKeys = this.peptideMap.get(modKey);
            if (modKeys != null) {
                progressDialog.setPrimaryProgressCounterIndeterminate(false);
                progressDialog.setValue(0);
                progressDialog.setMaxPrimaryProgressCounter(modKeys.size());
                for (long peptideKey : modKeys) {
                    progressDialog.increasePrimaryProgressCounter();
                    if (progressDialog.isRunCanceled()) break;
                    PeptideMatch peptideMatch = (PeptideMatch)this.identification.retrieveObject(peptideKey);
                    PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                    double p = psParameter.getProbability();
                    if (psParameter.getHidden()) continue;
                    TreeSet<Long> peptideKeys = (TreeSet<Long>)scoreToPeptideMap.get(p);
                    if (peptideKeys == null) {
                        peptideKeys = new TreeSet<Long>();
                        scoreToPeptideMap.put(p, peptideKeys);
                    }
                    peptideKeys.add(peptideKey);
                }
                if (progressDialog.isRunCanceled()) {
                    return;
                }
                this.displayedPeptides = scoreToPeptideMap.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
                if (progressDialog.isRunCanceled()) {
                    return;
                }
            } else {
                this.displayedPeptides = new ArrayList(0);
            }
            ((DefaultTableModel)this.peptidesTable.getModel()).fireTableDataChanged();
            if (this.peptidesTable.getRowCount() > 0) {
                this.peptidesTable.setRowSelectionInterval(0, 0);
                this.peptidesTable.scrollRectToVisible(this.peptidesTable.getCellRect(0, 0, false));
                this.updateRelatedPeptidesTable(progressDialog);
                this.updateModificationProfiles(progressDialog);
                this.updateModificationProfilesTable(progressDialog);
            } else {
                this.modificationProfileSelectedPeptideJPanel.removeAll();
                this.modificationProfileSelectedPeptideJPanel.revalidate();
                this.modificationProfileSelectedPeptideJPanel.repaint();
                this.modificationProfileRelatedPeptideJPanel.removeAll();
                this.modificationProfileRelatedPeptideJPanel.revalidate();
                this.modificationProfileRelatedPeptideJPanel.repaint();
                this.relatedPeptides = new ArrayList(0);
                ((DefaultTableModel)this.relatedPeptidesTable.getModel()).fireTableDataChanged();
            }
            String selectedModification = "";
            if (this.modificationJTable.getSelectedRow() != -1) {
                selectedModification = "- " + this.modificationJTable.getValueAt(this.modificationJTable.getSelectedRow(), this.modificationJTable.getColumn("Modification").getModelIndex()) + " ";
            }
            ((TitledBorder)this.selectedPeptidesJPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Modified Peptides " + selectedModification + "(" + this.peptidesTable.getRowCount() + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
            this.selectedPeptidesJPanel.repaint();
            ((TitledBorder)this.relatedPeptidesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Related Peptides (" + this.relatedPeptidesTable.getRowCount() + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
            this.relatedPeptidesPanel.repaint();
            int peptideTableWidth = this.peptideShakerGUI.getPreferredColumnWidth(this.peptidesTable, this.peptidesTable.getColumn("Sequence").getModelIndex(), 1);
            int relatedPeptideWidth = this.peptideShakerGUI.getPreferredColumnWidth(this.relatedPeptidesTable, this.relatedPeptidesTable.getColumn("Sequence").getModelIndex(), 1);
            int width = Math.max(peptideTableWidth, relatedPeptideWidth);
            this.peptidesTable.getColumn("Sequence").setMinWidth(width);
            this.relatedPeptidesTable.getColumn("Sequence").setMinWidth(width);
            this.updateSelectedPsmTable(progressDialog, true);
            if (progressDialog.isRunCanceled()) {
                return;
            }
            this.updateRelatedPsmTable(progressDialog, false);
            if (progressDialog.isRunCanceled()) {
                return;
            }
            this.updateSelection(progressDialog);
        }
    }

    public void updateRelatedPeptidesTable(ProgressDialogX progressDialog) {
        TreeMap<Double, TreeSet<Long>> scoreToKeyMap = new TreeMap<Double, TreeSet<Long>>();
        int selectedPeptideIndex = (Integer)this.peptidesTable.getValueAt(this.peptidesTable.getSelectedRow(), 0) - 1;
        long peptideKey = this.displayedPeptides.get(selectedPeptideIndex);
        PeptideMatch peptideMatch = this.identification.getPeptideMatch(peptideKey);
        String referenceSequence = peptideMatch.getPeptide().getSequence();
        progressDialog.setPrimaryProgressCounterIndeterminate(false);
        progressDialog.setValue(0);
        progressDialog.setMaxPrimaryProgressCounter(this.identification.getPeptideIdentification().size());
        Iterator iterator = this.identification.getPeptideIdentification().iterator();
        while (iterator.hasNext()) {
            String newSequence;
            long newKey = (Long)iterator.next();
            if (progressDialog.isRunCanceled()) break;
            progressDialog.increasePrimaryProgressCounter();
            PeptideMatch newMatch = this.identification.getPeptideMatch(newKey);
            PSParameter psParameter = (PSParameter)newMatch.getUrParam((UrParameter)PSParameter.dummy);
            if (psParameter.getHidden() || !(newSequence = newMatch.getPeptide().getSequence()).contains(referenceSequence) && !referenceSequence.contains(newSequence) || newKey == peptideKey) continue;
            double p = psParameter.getProbability();
            TreeSet<Long> keysAtScore = (TreeSet<Long>)scoreToKeyMap.get(p);
            if (keysAtScore == null) {
                keysAtScore = new TreeSet<Long>();
                scoreToKeyMap.put(p, keysAtScore);
            }
            keysAtScore.add(newKey);
        }
        if (!progressDialog.isRunCanceled()) {
            progressDialog.setTitle("Sorting Related Peptides. Please Wait...");
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.relatedPeptides = scoreToKeyMap.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
            ((DefaultTableModel)this.relatedPeptidesTable.getModel()).fireTableDataChanged();
            if (this.relatedPeptides.size() > 0) {
                this.relatedPeptidesTable.setRowSelectionInterval(0, 0);
                this.relatedPeptidesTable.scrollRectToVisible(this.relatedPeptidesTable.getCellRect(0, 0, false));
                this.updateModificationProfiles(progressDialog);
            } else {
                this.modificationProfileRelatedPeptideJPanel.removeAll();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int peptideTableWidth = ModificationsPanel.this.peptideShakerGUI.getPreferredColumnWidth(ModificationsPanel.this.peptidesTable, ModificationsPanel.this.peptidesTable.getColumn("Sequence").getModelIndex(), 1);
                    int relatedPeptideWidth = ModificationsPanel.this.peptideShakerGUI.getPreferredColumnWidth(ModificationsPanel.this.relatedPeptidesTable, ModificationsPanel.this.relatedPeptidesTable.getColumn("Sequence").getModelIndex(), 1);
                    int width = Math.max(peptideTableWidth, relatedPeptideWidth);
                    ModificationsPanel.this.peptidesTable.getColumn("Sequence").setMinWidth(width);
                    ModificationsPanel.this.relatedPeptidesTable.getColumn("Sequence").setMinWidth(width);
                }
            });
            ((TitledBorder)this.relatedPeptidesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Related Peptides (" + this.relatedPeptidesTable.getRowCount() + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
            this.relatedPeptidesPanel.repaint();
        }
    }

    private void updateSelectedPsmTable(ProgressDialogX progressDialog, boolean selectRow) {
        ((DefaultTableModel)this.selectedPsmsTable.getModel()).fireTableDataChanged();
        ((DefaultTableModel)this.relatedPsmsTable.getModel()).fireTableDataChanged();
        if (this.selectedPsmsTable.getRowCount() > 0) {
            this.selectedPsmsTable.setRowSelectionInterval(0, 0);
            this.selectedPsmsTable.scrollRectToVisible(this.selectedPsmsTable.getCellRect(0, 0, false));
            try {
                if (selectRow) {
                    if (this.selectedPsmsTable.getRowCount() > 0) {
                        this.selectedPsmsTable.setRowSelectionInterval(0, 0);
                        this.selectedPsmsTable.scrollRectToVisible(this.selectedPsmsTable.getCellRect(0, 0, false));
                        this.updateGraphics(progressDialog);
                    }
                    while (this.relatedPsmsTable.getSelectedRow() >= 0) {
                        this.relatedPsmsTable.removeRowSelectionInterval(this.relatedPsmsTable.getSelectedRow(), this.relatedPsmsTable.getSelectedRow());
                    }
                } else {
                    while (this.selectedPsmsTable.getSelectedRow() >= 0) {
                        this.selectedPsmsTable.removeRowSelectionInterval(this.selectedPsmsTable.getSelectedRow(), this.selectedPsmsTable.getSelectedRow());
                    }
                }
            }
            catch (Exception e) {
                this.peptideShakerGUI.catchException(e);
                e.printStackTrace();
            }
        }
        this.spectrumTabbedPaneStateChanged(null);
        ((TitledBorder)this.modsPsmsLayeredPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Peptide Spectrum Matches - Modified Peptide (" + this.selectedPsmsTable.getRowCount() + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        this.modsPsmsLayeredPanel.repaint();
    }

    private void updateRelatedPsmTable(ProgressDialogX progressDialog, boolean selectRow) {
        ((DefaultTableModel)this.relatedPsmsTable.getModel()).fireTableDataChanged();
        if (selectRow) {
            if (this.relatedPsmsTable.getRowCount() > 0) {
                this.relatedPsmsTable.setRowSelectionInterval(0, 0);
                this.relatedPsmsTable.scrollRectToVisible(this.relatedPsmsTable.getCellRect(0, 0, false));
                this.updateGraphics(progressDialog);
            }
            while (this.selectedPsmsTable.getSelectedRow() >= 0) {
                this.selectedPsmsTable.removeRowSelectionInterval(this.selectedPsmsTable.getSelectedRow(), this.selectedPsmsTable.getSelectedRow());
            }
        } else {
            while (this.relatedPsmsTable.getSelectedRow() >= 0) {
                this.relatedPsmsTable.removeRowSelectionInterval(this.relatedPsmsTable.getSelectedRow(), this.relatedPsmsTable.getSelectedRow());
            }
        }
        double lowRT = Double.MAX_VALUE;
        double highRT = Double.MIN_VALUE;
        boolean retentionTimeValues = false;
        if (this.relatedPsmsTable.getRowCount() > 0) {
            progressDialog.setTitle("Updating Selected PSMs. Please Wait...");
            progressDialog.setPrimaryProgressCounterIndeterminate(false);
            progressDialog.setValue(0);
            progressDialog.setMaxPrimaryProgressCounter(this.relatedPsmsTable.getRowCount());
        }
        SpectrumProvider spectrumProvider = this.peptideShakerGUI.getSpectrumProvider();
        for (int i = 0; i < this.relatedPsmsTable.getRowCount(); ++i) {
            progressDialog.increasePrimaryProgressCounter();
            PeptideMatch peptideMatch = this.identification.getPeptideMatch(this.getSelectedPeptide(true));
            long spectrumMatchKey = peptideMatch.getSpectrumMatchesKeys()[i];
            SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(spectrumMatchKey);
            String spectrumFile = spectrumMatch.getSpectrumFile();
            String spectrumTitle = spectrumMatch.getSpectrumTitle();
            Precursor precursor = spectrumProvider.getPrecursor(spectrumFile, spectrumTitle);
            if (precursor == null) continue;
            double retentionTime = precursor.rt;
            if (!retentionTimeValues && retentionTime != -1.0) {
                retentionTimeValues = true;
            }
            if (lowRT > retentionTime) {
                lowRT = retentionTime;
            }
            if (!(highRT < retentionTime)) continue;
            highRT = retentionTime;
        }
        if (retentionTimeValues) {
            JSparklinesIntervalChartTableCellRenderer rtCellRenderer = new JSparklinesIntervalChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(0.0), Double.valueOf(spectrumProvider.getMaxPrecRT()), Double.valueOf(spectrumProvider.getMaxPrecRT() / 50.0), this.peptideShakerGUI.getSparklineColor(), this.peptideShakerGUI.getSparklineColor());
            this.relatedPsmsTable.getColumn("RT").setCellRenderer((TableCellRenderer)rtCellRenderer);
            rtCellRenderer.showNumberAndChart(true, TableProperties.getLabelWidth() + 5);
            ((JSparklinesIntervalChartTableCellRenderer)this.relatedPsmsTable.getColumn("RT").getCellRenderer()).showReferenceLine(true, 0.02, Color.BLACK);
        }
        this.spectrumTabbedPaneStateChanged(null);
        ((TitledBorder)this.relatedPsmsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Peptide Spectrum Matches - Related Peptide (" + this.relatedPsmsTable.getRowCount() + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        this.relatedPsmsPanel.repaint();
    }

    public void updateGraphics(ProgressDialogX progressDialog) {
        if (progressDialog != null) {
            progressDialog.setTitle("Updating Graphics. Please Wait...");
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
        }
        if (this.getSelectedPeptide() != ExperimentObject.NO_KEY) {
            if (this.selectedPsmsTable.getSelectedRow() != -1 && this.relatedPsmsTable.getSelectedRow() != -1) {
                this.updateSpectrum(this.getSelectedPsmsKeys(false)[0], this.getSelectedPsmsKeys(true)[0]);
            } else if (this.selectedPsmsTable.getSelectedRow() != -1 && this.relatedPsmsTable.getSelectedRow() == -1) {
                this.updateSpectrum(this.getSelectedPsmsKeys(false)[0], null);
            } else if (this.selectedPsmsTable.getSelectedRow() == -1 && this.relatedPsmsTable.getSelectedRow() != -1) {
                this.updateSpectrum(this.getSelectedPsmsKeys(true)[0], null);
            }
        }
    }

    public void updateSpectrum(long spectrumMatchKey, Long secondSpectrumMatchKey) {
        SpectrumProvider spectrumProvider = this.peptideShakerGUI.getSpectrumProvider();
        this.spectrumChartJPanel.removeAll();
        this.spectrumChartJPanel.revalidate();
        this.spectrumChartJPanel.repaint();
        SequenceProvider sequenceProvider = this.peptideShakerGUI.getSequenceProvider();
        IdentificationParameters identificationParameters = this.peptideShakerGUI.getIdentificationParameters();
        AnnotationParameters annotationParameters = identificationParameters.getAnnotationParameters();
        ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
        SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
        SpectrumMatch firstSpectrumMatch = this.identification.getSpectrumMatch(spectrumMatchKey);
        String firstSpectrumFile = firstSpectrumMatch.getSpectrumFile();
        String firstSpectrumTitle = firstSpectrumMatch.getSpectrumTitle();
        Spectrum firstSpectrum = spectrumProvider.getSpectrum(firstSpectrumFile, firstSpectrumTitle);
        SpectrumMatch secondSpectrumMatch = null;
        if (firstSpectrum != null && firstSpectrum.mz.length > 0) {
            String secondSpectrumTitle;
            String secondSpectrumFile;
            Spectrum secondSpectrum;
            double[] intensityArray = secondSpectrumMatchKey == null ? firstSpectrum.intensity : ArrayUtil.scaleToMax((double[])firstSpectrum.intensity, (boolean)true);
            this.spectrumPanel = new SpectrumPanel(firstSpectrum.mz, intensityArray, firstSpectrum.getPrecursor().mz, Charge.toString((int)firstSpectrumMatch.getBestPeptideAssumption().getIdentificationCharge()), "", 40, false, false, false, 2, false);
            SpectrumPanel.setKnownMassDeltas(this.peptideShakerGUI.getCurrentMassDeltas());
            this.spectrumPanel.setDeltaMassWindow(this.peptideShakerGUI.getIdentificationParameters().getAnnotationParameters().getFragmentIonAccuracy());
            this.spectrumPanel.setBorder(null);
            this.spectrumPanel.setDataPointAndLineColor(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedPeakColor(), 0);
            this.spectrumPanel.setPeakWaterMarkColor(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumBackgroundPeakColor());
            this.spectrumPanel.setPeakWidth(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedPeakWidth());
            this.spectrumPanel.setBackgroundPeakWidth(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumBackgroundPeakWidth());
            HashSet<String> allModifications = new HashSet<String>(2);
            PeptideAssumption firstPeptideAssumption = firstSpectrumMatch.getBestPeptideAssumption();
            Peptide firstPeptide = firstPeptideAssumption.getPeptide();
            int identificationChargeFirstPsm = firstSpectrumMatch.getBestPeptideAssumption().getIdentificationCharge();
            int identificationChargeSecondPsm = 0;
            allModifications.addAll(ModificationUtils.getAllModifications((Peptide)firstPeptide, (ModificationParameters)modificationParameters, (SequenceProvider)sequenceProvider, (SequenceMatchingParameters)modificationSequenceMatchingParameters));
            PeptideSpectrumAnnotator spectrumAnnotator = new PeptideSpectrumAnnotator();
            SpecificAnnotationParameters specificAnnotationParameters = this.peptideShakerGUI.getSpecificAnnotationParameters(firstSpectrumFile, firstSpectrumTitle, (SpectrumIdentificationAssumption)firstPeptideAssumption);
            IonMatch[] annotations = spectrumAnnotator.getSpectrumAnnotation(annotationParameters, specificAnnotationParameters, firstSpectrumFile, firstSpectrumTitle, firstSpectrum, firstPeptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
            this.spectrumPanel.setAnnotations((List)SpectrumAnnotator.getSpectrumAnnotation((IonMatch[])annotations), annotationParameters.getTiesResolution() == SpectrumAnnotator.TiesResolution.mostIntense);
            this.spectrumPanel.showAnnotatedPeaksOnly(!annotationParameters.showAllPeaks());
            this.spectrumPanel.setYAxisZoomExcludesBackgroundPeaks(annotationParameters.yAxisZoomExcludesBackgroundPeaks());
            SearchParameters searchParameters = this.peptideShakerGUI.getIdentificationParameters().getSearchParameters();
            Integer forwardIon = (Integer)searchParameters.getForwardIons().get(0);
            Integer rewindIon = (Integer)searchParameters.getRewindIons().get(0);
            this.spectrumPanel.addAutomaticDeNovoSequencing(firstPeptide, annotations, forwardIon.intValue(), rewindIon.intValue(), annotationParameters.getDeNovoCharge(), annotationParameters.showForwardIonDeNovoTags(), annotationParameters.showRewindIonDeNovoTags(), false, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
            if (secondSpectrumMatchKey != null && (secondSpectrum = spectrumProvider.getSpectrum(secondSpectrumFile = (secondSpectrumMatch = this.identification.getSpectrumMatch(secondSpectrumMatchKey.longValue())).getSpectrumFile(), secondSpectrumTitle = secondSpectrumMatch.getSpectrumTitle())) != null && secondSpectrum.mz.length > 0) {
                this.spectrumPanel.addMirroredSpectrum(secondSpectrum.mz, ArrayUtil.scaleToMax((double[])secondSpectrum.intensity, (boolean)true), secondSpectrum.getPrecursor().mz, Charge.toString((int)secondSpectrumMatch.getBestPeptideAssumption().getIdentificationCharge()), "", false, this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedMirroredPeakColor(), this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedMirroredPeakColor());
                PeptideAssumption secondPeptideAssumption = secondSpectrumMatch.getBestPeptideAssumption();
                Peptide secondPeptide = secondPeptideAssumption.getPeptide();
                identificationChargeSecondPsm = secondSpectrumMatch.getBestPeptideAssumption().getIdentificationCharge();
                allModifications.addAll(ModificationUtils.getAllModifications((Peptide)secondPeptide, (ModificationParameters)modificationParameters, (SequenceProvider)sequenceProvider, (SequenceMatchingParameters)modificationSequenceMatchingParameters));
                specificAnnotationParameters = this.peptideShakerGUI.getSpecificAnnotationParameters(secondSpectrumFile, secondSpectrumTitle, (SpectrumIdentificationAssumption)secondPeptideAssumption);
                IonMatch[] mirroredAnnotations = spectrumAnnotator.getSpectrumAnnotation(annotationParameters, specificAnnotationParameters, secondSpectrumFile, secondSpectrumTitle, secondSpectrum, secondPeptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
                this.spectrumPanel.setAnnotationsMirrored((List)SpectrumAnnotator.getSpectrumAnnotation((IonMatch[])mirroredAnnotations));
                this.spectrumPanel.addAutomaticDeNovoSequencing(secondPeptide, annotations, forwardIon.intValue(), rewindIon.intValue(), annotationParameters.getDeNovoCharge(), annotationParameters.showForwardIonDeNovoTags(), annotationParameters.showRewindIonDeNovoTags(), true, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
                this.spectrumPanel.rescale(0.0, this.spectrumPanel.getMaxXAxisValue());
            }
            this.spectrumChartJPanel.add((Component)this.spectrumPanel);
            this.peptideShakerGUI.updateAnnotationMenus(specificAnnotationParameters, Math.max(identificationChargeFirstPsm, identificationChargeSecondPsm), allModifications);
            String modifiedSequence = this.peptideShakerGUI.getDisplayFeaturesGenerator().getTaggedPeptideSequence(firstSpectrumMatch, false, false, true);
            if (secondSpectrumMatchKey != null) {
                modifiedSequence = modifiedSequence + " vs. " + this.peptideShakerGUI.getDisplayFeaturesGenerator().getTaggedPeptideSequence(secondSpectrumMatch, false, false, true);
            }
            ((TitledBorder)this.spectrumAndFragmentIonPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Spectrum & Fragment Ions (" + modifiedSequence + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
            this.spectrumAndFragmentIonPanel.revalidate();
            this.spectrumAndFragmentIonPanel.repaint();
        }
        this.spectrumChartJPanel.revalidate();
        this.spectrumChartJPanel.repaint();
    }

    private ArrayList<ModificationProfile> getModificationProfile(Peptide peptide, PSModificationScores scores) {
        ArrayList<ModificationProfile> profiles = new ArrayList<ModificationProfile>();
        if (scores != null) {
            for (String modName : scores.getScoredModifications()) {
                Color modificationColor = new Color(this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters().getColor(modName));
                ModificationProfile tempProfile = new ModificationProfile(modName, new double[peptide.getSequence().length()][2], modificationColor);
                ModificationScoring locationScoring = scores.getModificationScoring(modName);
                for (int aa = 1; aa <= peptide.getSequence().length(); ++aa) {
                    tempProfile.getProfile()[aa - 1][0] = locationScoring.getDeltaScore(aa);
                    tempProfile.getProfile()[aa - 1][1] = locationScoring.getProbabilisticScore(aa);
                }
                profiles.add(tempProfile);
            }
        }
        return profiles;
    }

    private long getSelectedPeptide(boolean relatedPeptide) {
        if (relatedPeptide) {
            if (this.relatedPeptides.isEmpty()) {
                return ExperimentObject.NO_KEY;
            }
            int index = this.relatedPeptidesTable.getSelectedRow();
            if (index == -1) {
                index = 0;
            }
            return this.relatedPeptides.get((Integer)this.relatedPeptidesTable.getValueAt(index, 0) - 1);
        }
        if (this.displayedPeptides.isEmpty()) {
            return ExperimentObject.NO_KEY;
        }
        int index = this.peptidesTable.getSelectedRow();
        if (index == -1) {
            index = 0;
        }
        return this.displayedPeptides.get((Integer)this.peptidesTable.getValueAt(index, 0) - 1);
    }

    private long getSelectedPeptide() {
        return this.getSelectedPeptide(this.relatedSelected);
    }

    private long[] getSelectedPsmsKeys(boolean relatedPeptide) {
        PeptideMatch peptideMatch = this.identification.getPeptideMatch(this.getSelectedPeptide(relatedPeptide));
        JTable psmTable = relatedPeptide ? this.relatedPsmsTable : this.selectedPsmsTable;
        return Arrays.stream(psmTable.getSelectedRows()).mapToLong(row -> peptideMatch.getSpectrumMatchesKeys()[row]).toArray();
    }

    public long[] getSelectedPsmsKeys() {
        return this.getSelectedPsmsKeys(this.relatedSelected);
    }

    public TreeMap<String, TreeSet<String>> getSelectedSpectrumTitles() {
        TreeMap<String, TreeSet<String>> result = new TreeMap<String, TreeSet<String>>();
        for (long psmKey : this.getSelectedPsmsKeys()) {
            SpectrumMatch spectrumMatch = this.peptideShakerGUI.getIdentification().getSpectrumMatch(psmKey);
            String spectrumFile = spectrumMatch.getSpectrumFile();
            String spectrumTitle = spectrumMatch.getSpectrumTitle();
            TreeSet<String> spectrumTitles = result.get(spectrumFile);
            if (spectrumTitles == null) {
                spectrumTitles = new TreeSet();
                result.put(spectrumFile, spectrumTitles);
            }
            spectrumTitles.add(spectrumTitle);
        }
        return result;
    }

    public HashMap<Long, ArrayList<SpectrumIdentificationAssumption>> getSelectedIdentificationAssumptions() {
        ArrayList<PeptideAssumption> assumptions;
        SpectrumMatch spectrumMatch;
        Long spectrumKey;
        int n;
        HashMap<Long, ArrayList<SpectrumIdentificationAssumption>> result = new HashMap<Long, ArrayList<SpectrumIdentificationAssumption>>(2);
        long[] lArray = this.getSelectedPsmsKeys(false);
        int n2 = lArray.length;
        for (n = 0; n < n2; ++n) {
            spectrumKey = lArray[n];
            spectrumMatch = this.identification.getSpectrumMatch(spectrumKey.longValue());
            assumptions = new ArrayList<PeptideAssumption>(1);
            assumptions.add(spectrumMatch.getBestPeptideAssumption());
            result.put(spectrumKey, assumptions);
        }
        lArray = this.getSelectedPsmsKeys(true);
        n2 = lArray.length;
        for (n = 0; n < n2; ++n) {
            spectrumKey = lArray[n];
            spectrumMatch = this.identification.getSpectrumMatch(spectrumKey.longValue());
            assumptions = new ArrayList(1);
            assumptions.add(spectrumMatch.getBestPeptideAssumption());
            result.put(spectrumKey, assumptions);
        }
        return result;
    }

    public Component getSpectrum() {
        return this.spectrumJPanel.getComponent(1);
    }

    private void updateModificationProfile(PeptideMatch peptideMatch, boolean selectedPeptideProfile) {
        try {
            JPanel tempPanel;
            SequenceProvider sequenceProvider = this.peptideShakerGUI.getSequenceProvider();
            IdentificationParameters identificationParameters = this.peptideShakerGUI.getIdentificationParameters();
            ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
            SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
            PSModificationScores scores = (PSModificationScores)peptideMatch.getUrParam((UrParameter)PSModificationScores.dummy);
            ArrayList<ModificationProfile> profiles = this.getModificationProfile(peptideMatch.getPeptide(), scores);
            Peptide peptide = peptideMatch.getPeptide();
            String nTerminalAsString = PeptideUtils.getNtermAsString((boolean)true, (String[][])new String[][]{peptide.getFixedModifications(modificationParameters, sequenceProvider, modificationSequenceMatchingParameters), peptide.getIndexedVariableModifications()});
            String cTerminalAsString = PeptideUtils.getCtermAsString((boolean)true, (int)peptide.getSequence().length(), (String[][])new String[][]{peptide.getFixedModifications(modificationParameters, sequenceProvider, modificationSequenceMatchingParameters), peptide.getIndexedVariableModifications()});
            String peptideAnnotation = String.join((CharSequence)"-", nTerminalAsString, peptideMatch.getPeptide().getSequence(), cTerminalAsString);
            String probabilisticScore = this.peptideShakerGUI.getIdentificationParameters().getModificationLocalizationParameters().getSelectedProbabilisticScore().getName();
            SequenceModificationPanel sequenceModificationPanel = new SequenceModificationPanel(peptideAnnotation, profiles, true, "D-score", probabilisticScore);
            if (selectedPeptideProfile) {
                this.modificationProfileSelectedPeptideJPanel.removeAll();
                sequenceModificationPanel.setOpaque(true);
                sequenceModificationPanel.setBackground(Color.WHITE);
                sequenceModificationPanel.setMinimumSize(new Dimension(sequenceModificationPanel.getPreferredSize().width, sequenceModificationPanel.getHeight()));
                tempPanel = new JPanel();
                tempPanel.setBackground(Color.WHITE);
                tempPanel.setOpaque(true);
                this.modificationProfileSelectedPeptideJPanel.add(tempPanel);
                this.modificationProfileSelectedPeptideJPanel.add((Component)sequenceModificationPanel);
                this.modificationProfileSelectedPeptideJPanel.revalidate();
                this.modificationProfileSelectedPeptideJPanel.repaint();
            } else {
                this.modificationProfileRelatedPeptideJPanel.removeAll();
                sequenceModificationPanel.setOpaque(true);
                sequenceModificationPanel.setBackground(Color.WHITE);
                sequenceModificationPanel.setMinimumSize(new Dimension(sequenceModificationPanel.getPreferredSize().width, sequenceModificationPanel.getHeight()));
                tempPanel = new JPanel();
                tempPanel.setBackground(Color.WHITE);
                tempPanel.setOpaque(true);
                this.modificationProfileRelatedPeptideJPanel.add(tempPanel);
                this.modificationProfileRelatedPeptideJPanel.add((Component)sequenceModificationPanel);
                this.modificationProfileRelatedPeptideJPanel.revalidate();
                this.modificationProfileRelatedPeptideJPanel.repaint();
            }
            double selectedPeptideProfileWidth = 1.0 - sequenceModificationPanel.getPreferredSize().getWidth() / this.selectedPeptidesJSplitPane.getSize().getWidth();
            double relatedPeptideProfileWidth = 1.0 - sequenceModificationPanel.getPreferredSize().getWidth() / this.relatedPeptidesJSplitPane.getSize().getWidth();
            if (this.modificationProfileSelectedPeptideJPanel.getComponentCount() == 2) {
                selectedPeptideProfileWidth = 1.0 - this.modificationProfileSelectedPeptideJPanel.getComponent(1).getPreferredSize().getWidth() / this.selectedPeptidesJSplitPane.getSize().getWidth();
            }
            if (this.modificationProfileRelatedPeptideJPanel.getComponentCount() == 2) {
                relatedPeptideProfileWidth = 1.0 - this.modificationProfileRelatedPeptideJPanel.getComponent(1).getPreferredSize().getWidth() / this.relatedPeptidesJSplitPane.getSize().getWidth();
            }
            double splitterLocation = Math.min(selectedPeptideProfileWidth, relatedPeptideProfileWidth);
            this.selectedPeptidesJSplitPane.setDividerLocation(splitterLocation);
            this.selectedPeptidesJSplitPane.revalidate();
            this.selectedPeptidesJSplitPane.repaint();
            this.relatedPeptidesJSplitPane.setDividerLocation(splitterLocation);
            this.relatedPeptidesJSplitPane.revalidate();
            this.relatedPeptidesJSplitPane.repaint();
        }
        catch (Exception e) {
            this.peptideShakerGUI.catchException(e);
            e.printStackTrace();
        }
    }

    public void showSpectrumAnnotationMenu() {
        this.spectrumTabbedPaneStateChanged(null);
    }

    public void setIntensitySliderValue(int value) {
        this.intensitySlider.setValue(value);
    }

    public void setAccuracySliderValue(int value) {
        this.accuracySlider.setValue(value);
    }

    public void updateModificationColors() {
        this.setCursor(new Cursor(3));
        for (int i = 0; i < this.modificationJTable.getRowCount(); ++i) {
            String modName = (String)this.modificationJTable.getValueAt(i, this.modificationJTable.getColumn("Modification").getModelIndex());
            this.modificationJTable.setValueAt(this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters().getColor(modName), i, this.modificationJTable.getColumn("  ").getModelIndex());
        }
        this.updateModificationProfiles(null);
        this.setCursor(new Cursor(0));
    }

    public void updateModificationProfiles(ProgressDialogX progressDialog) {
        if (progressDialog != null) {
            progressDialog.setTitle("Updating Modification Profile. Please Wait...");
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
        }
        try {
            if (this.peptidesTable.getSelectedRow() != -1) {
                this.updateModificationProfile((PeptideMatch)this.identification.retrieveObject(this.displayedPeptides.get((Integer)this.peptidesTable.getValueAt(this.peptidesTable.getSelectedRow(), 0) - 1).longValue()), true);
            }
            if (this.relatedPeptidesTable.getSelectedRow() != -1) {
                this.updateModificationProfile((PeptideMatch)this.identification.retrieveObject(this.relatedPeptides.get((Integer)this.relatedPeptidesTable.getValueAt(this.relatedPeptidesTable.getSelectedRow(), 0) - 1).longValue()), false);
            }
        }
        catch (Exception e) {
            this.peptideShakerGUI.catchException(e);
            e.printStackTrace();
        }
    }

    private void copyTableContentToFileOrClipboard(TableIndex index) {
        final TableIndex tableIndex = index;
        String exportName = "export";
        switch (tableIndex.ordinal()) {
            case 0: {
                exportName = "Modified peptides table";
                break;
            }
            case 1: {
                exportName = "Related peptides table";
                break;
            }
            case 2: {
                exportName = "Modified PSMs table";
                break;
            }
            case 3: {
                exportName = "Related PSMs table";
                break;
            }
            case 4: {
                exportName = "PSM table";
                break;
            }
            case 5: {
                exportName = "A score table";
                break;
            }
            case 6: {
                exportName = "Delta score table";
                break;
            }
        }
        final File selectedFile = this.peptideShakerGUI.getUserSelectedFile(exportName, ".txt", "Tab separated text file (.txt)", "Export...", false);
        if (selectedFile != null && (tableIndex == TableIndex.MODIFIED_PEPTIDES_TABLE || tableIndex == TableIndex.RELATED_PEPTIDES_TABLE || tableIndex == TableIndex.MODIFIED_PSMS_TABLE || tableIndex == TableIndex.RELATED_PSMS_TABLE || tableIndex == TableIndex.MODIFICATION__TABLE || tableIndex == TableIndex.A_SCORES_TABLE || tableIndex == TableIndex.DELTA_SCORES_TABLE)) {
            this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.progressDialog.setTitle("Copying to File. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ModificationsPanel.this.progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }).start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        BufferedWriter writer = new BufferedWriter(new FileWriter(selectedFile));
                        if (null != tableIndex) {
                            switch (tableIndex.ordinal()) {
                                case 0: {
                                    Util.tableToFile((JTable)ModificationsPanel.this.peptidesTable, (String)"\t", (ProgressDialogX)ModificationsPanel.this.progressDialog, (boolean)true, (BufferedWriter)writer);
                                    break;
                                }
                                case 1: {
                                    Util.tableToFile((JTable)ModificationsPanel.this.relatedPeptidesTable, (String)"\t", (ProgressDialogX)ModificationsPanel.this.progressDialog, (boolean)true, (BufferedWriter)writer);
                                    break;
                                }
                                case 2: {
                                    Util.tableToFile((JTable)ModificationsPanel.this.selectedPsmsTable, (String)"\t", (ProgressDialogX)ModificationsPanel.this.progressDialog, (boolean)true, (BufferedWriter)writer);
                                    break;
                                }
                                case 3: {
                                    Util.tableToFile((JTable)ModificationsPanel.this.relatedPsmsTable, (String)"\t", (ProgressDialogX)ModificationsPanel.this.progressDialog, (boolean)true, (BufferedWriter)writer);
                                    break;
                                }
                                case 4: {
                                    break;
                                }
                                case 5: {
                                    Util.tableToFile((JTable)ModificationsPanel.this.psmAScoresTable, (String)"\t", (ProgressDialogX)ModificationsPanel.this.progressDialog, (boolean)false, (BufferedWriter)writer);
                                    break;
                                }
                                case 6: {
                                    Util.tableToFile((JTable)ModificationsPanel.this.psmDeltaScoresTable, (String)"\t", (ProgressDialogX)ModificationsPanel.this.progressDialog, (boolean)false, (BufferedWriter)writer);
                                    break;
                                }
                            }
                        }
                        writer.close();
                        boolean processCancelled = ModificationsPanel.this.progressDialog.isRunCanceled();
                        ModificationsPanel.this.progressDialog.setRunFinished();
                        if (!processCancelled) {
                            JOptionPane.showMessageDialog(ModificationsPanel.this.peptideShakerGUI, "Data copied to file:\n" + selectedFile.getAbsolutePath(), "Data Exported", 1);
                        }
                    }
                    catch (Exception e) {
                        ModificationsPanel.this.progressDialog.setRunFinished();
                        JOptionPane.showMessageDialog(ModificationsPanel.this.peptideShakerGUI, "An error occurred while generating the output.", "Output Error", 0);
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public void updateSeparators() {
        this.formComponentResized(null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ModificationsPanel.this.peptideShakerGUI.getUserParameters().showSliders()) {
                    ModificationsPanel.this.slidersSplitPane.setDividerLocation(ModificationsPanel.this.slidersSplitPane.getWidth() - 30);
                } else {
                    ModificationsPanel.this.slidersSplitPane.setDividerLocation(ModificationsPanel.this.slidersSplitPane.getWidth());
                }
                ModificationsPanel.this.modificationAndPeptideSelectionPanel.revalidate();
                ModificationsPanel.this.modificationAndPeptideSelectionPanel.repaint();
                ModificationsPanel.this.formComponentResized(null);
            }
        });
        this.formComponentResized(null);
    }

    private void updateSpectrumSliderToolTip() {
        SearchParameters searchParameters = this.peptideShakerGUI.getIdentificationParameters().getSearchParameters();
        double accuracy = (double)this.accuracySlider.getValue() / 100.0 * searchParameters.getFragmentIonAccuracy();
        this.spectrumTabbedPane.setToolTipText("<html>Accuracy: " + Util.roundDouble((double)accuracy, (int)2) + " " + searchParameters.getFragmentAccuracyType() + "<br>Level: " + this.intensitySlider.getValue() + "%</html>");
        ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(this.spectrumTabbedPane, 0, 0L, 0, this.spectrumTabbedPane.getWidth() - 50, this.spectrumTabbedPane.getY() + 20, 0, false));
    }

    public void newItemSelection() {
        long peptideKey = this.getSelectedPeptide();
        String spectrumFile = null;
        String spectrumTitle = null;
        if (this.selectedPsmsTable.getSelectedRow() != -1) {
            long psmKey = this.getSelectedPsmsKeys(false)[0];
            SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(psmKey);
            spectrumFile = spectrumMatch.getSpectrumFile();
            spectrumTitle = spectrumMatch.getSpectrumTitle();
        } else if (this.relatedPsmsTable.getSelectedRow() != -1) {
            long psmKey = this.getSelectedPsmsKeys(true)[0];
            SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(psmKey);
            spectrumFile = spectrumMatch.getSpectrumFile();
            spectrumTitle = spectrumMatch.getSpectrumTitle();
        }
        this.peptideShakerGUI.setSelectedItems(ExperimentObject.NO_KEY, peptideKey, spectrumFile, spectrumTitle);
    }

    private void updateModificationProfilesTable(ProgressDialogX progressDialog) {
        if (this.spectrumTabbedPane.isEnabledAt(0)) {
            progressDialog.setTitle("Updating Modification Profile Table. Please Wait...");
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.psmAScoresTable.setModel(new DefaultTableModel(){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    if (columnIndex == 0) {
                        return Double.class;
                    }
                    return Double.class;
                }
            });
            this.psmDeltaScoresTable.setModel(new DefaultTableModel(){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    if (columnIndex == 0) {
                        return Double.class;
                    }
                    return Double.class;
                }
            });
            if (this.peptidesTable.getSelectedRow() != -1) {
                try {
                    PeptideMatch peptideMatch = (PeptideMatch)this.identification.retrieveObject(this.displayedPeptides.get((Integer)this.peptidesTable.getValueAt(this.peptidesTable.getSelectedRow(), 0) - 1).longValue());
                    String sequence = peptideMatch.getPeptide().getSequence();
                    ((DefaultTableModel)this.psmAScoresTable.getModel()).addColumn("");
                    ((DefaultTableModel)this.psmDeltaScoresTable.getModel()).addColumn("");
                    for (int i = 0; i < sequence.length(); ++i) {
                        String columnName = "" + sequence.charAt(i) + (i + 1);
                        ((DefaultTableModel)this.psmAScoresTable.getModel()).addColumn(columnName);
                        ((DefaultTableModel)this.psmDeltaScoresTable.getModel()).addColumn(columnName);
                    }
                    String selectedModificationName = this.getSelectedModification();
                    Modification selectedModification = this.modificationFactory.getModification(selectedModificationName);
                    for (int i = 0; i < peptideMatch.getSpectrumMatchesKeys().length; ++i) {
                        long spectrumMatchKey = peptideMatch.getSpectrumMatchesKeys()[i];
                        SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(spectrumMatchKey);
                        PSModificationScores modificationScores = (PSModificationScores)spectrumMatch.getUrParam((UrParameter)PSModificationScores.dummy);
                        ((DefaultTableModel)this.psmAScoresTable.getModel()).addRow(new Object[]{i + 1});
                        ((DefaultTableModel)this.psmDeltaScoresTable.getModel()).addRow(new Object[]{i + 1});
                        if (modificationScores == null) continue;
                        HashMap<Integer, Double> dScores = new HashMap<Integer, Double>();
                        HashMap<Integer, Double> pScores = new HashMap<Integer, Double>();
                        for (String modName : modificationScores.getScoredModifications()) {
                            int site;
                            Modification modification = this.modificationFactory.getModification(modName);
                            if (modification.getMass() != selectedModification.getMass()) continue;
                            ModificationScoring modificationScoring = modificationScores.getModificationScoring(modName);
                            Iterator iterator = modificationScoring.getDSites().iterator();
                            while (iterator.hasNext()) {
                                site = (Integer)iterator.next();
                                double modificationDScore = modificationScoring.getDeltaScore(site);
                                Double tableDScore = (Double)dScores.get(site);
                                if (tableDScore != null && !(tableDScore < modificationDScore)) continue;
                                dScores.put(site, modificationDScore);
                            }
                            iterator = modificationScoring.getProbabilisticSites().iterator();
                            while (iterator.hasNext()) {
                                site = (Integer)iterator.next();
                                double modificationPScore = modificationScoring.getProbabilisticScore(site);
                                Double tablePScore = (Double)pScores.get(site);
                                if (tablePScore != null && !(tablePScore < modificationPScore)) continue;
                                pScores.put(site, modificationPScore);
                            }
                        }
                        Iterator<Object> iterator = dScores.keySet().iterator();
                        while (iterator.hasNext()) {
                            int site = (Integer)iterator.next();
                            this.psmDeltaScoresTable.setValueAt(dScores.get(site), i, site);
                        }
                        iterator = pScores.keySet().iterator();
                        while (iterator.hasNext()) {
                            int site = (Integer)iterator.next();
                            this.psmAScoresTable.setValueAt(pScores.get(site), i, site);
                        }
                    }
                    this.updatePsmScoresCellRenderers();
                }
                catch (Exception e) {
                    this.peptideShakerGUI.catchException(e);
                }
            }
        }
    }

    private void updatePsmScoresCellRenderers() {
        int i;
        for (i = 1; i < this.psmAScoresTable.getColumnCount(); ++i) {
            if (this.peptideShakerGUI.showSparklines()) {
                this.psmAScoresTable.getColumn(this.psmAScoresTable.getColumnName(i)).setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(0.0), Double.valueOf(100.0)));
                ((JSparklinesBarChartTableCellRenderer)this.psmAScoresTable.getColumn(this.psmAScoresTable.getColumnName(i)).getCellRenderer()).showAsHeatMap(GradientColorCoding.ColorGradient.GreenWhiteBlue, false);
                continue;
            }
            ((JSparklinesBarChartTableCellRenderer)this.psmAScoresTable.getColumn(this.psmAScoresTable.getColumnName(i)).getCellRenderer()).showNumbers(true);
        }
        for (i = 1; i < this.psmDeltaScoresTable.getColumnCount(); ++i) {
            if (this.peptideShakerGUI.showSparklines()) {
                this.psmDeltaScoresTable.getColumn(this.psmDeltaScoresTable.getColumnName(i)).setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(0.0), Double.valueOf(100.0)));
                ((JSparklinesBarChartTableCellRenderer)this.psmDeltaScoresTable.getColumn(this.psmDeltaScoresTable.getColumnName(i)).getCellRenderer()).showAsHeatMap(GradientColorCoding.ColorGradient.GreenWhiteBlue, false);
                continue;
            }
            ((JSparklinesBarChartTableCellRenderer)this.psmDeltaScoresTable.getColumn(this.psmDeltaScoresTable.getColumnName(i)).getCellRenderer()).showNumbers(true);
        }
    }

    private static enum TableIndex {
        MODIFIED_PEPTIDES_TABLE,
        RELATED_PEPTIDES_TABLE,
        MODIFIED_PSMS_TABLE,
        RELATED_PSMS_TABLE,
        MODIFICATION__TABLE,
        A_SCORES_TABLE,
        DELTA_SCORES_TABLE;

    }

    private class PeptideTable
    extends DefaultTableModel {
        private PeptideTable() {
        }

        @Override
        public int getRowCount() {
            return ModificationsPanel.this.displayedPeptides.size();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "   ";
                }
                case 2: {
                    return "PI";
                }
                case 3: {
                    return "Sequence";
                }
                case 4: {
                    return "Modification";
                }
                case 5: {
                    return "Peptide";
                }
                case 6: {
                    return "  ";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                if (row >= ModificationsPanel.this.displayedPeptides.size()) {
                    return "";
                }
                if (column == 0) {
                    return row + 1;
                }
                long key = (Long)ModificationsPanel.this.displayedPeptides.get(row);
                PeptideMatch peptideMatch = ModificationsPanel.this.identification.getPeptideMatch(key);
                PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                switch (column) {
                    case 1: {
                        return psParameter.getStarred();
                    }
                    case 2: {
                        return psParameter.getProteinInferenceGroupClass();
                    }
                    case 3: {
                        return ModificationsPanel.this.peptideShakerGUI.getDisplayFeaturesGenerator().getTaggedPeptideSequence(peptideMatch, true, true, true);
                    }
                    case 4: {
                        PSModificationScores ptmScores = (PSModificationScores)peptideMatch.getUrParam((UrParameter)PSModificationScores.dummy);
                        if (ptmScores != null && ptmScores.getModificationScoring(ModificationsPanel.this.getSelectedModification()) != null) {
                            ModificationScoring ptmScoring = ptmScores.getModificationScoring(ModificationsPanel.this.getSelectedModification());
                            return ptmScoring.getMinimalLocalizationConfidence();
                        }
                        return -1;
                    }
                    case 5: {
                        return psParameter.getConfidence();
                    }
                    case 6: {
                        return psParameter.getMatchValidationLevel().getIndex();
                    }
                }
                return "";
            }
            catch (Exception e) {
                ModificationsPanel.this.peptideShakerGUI.catchException(e);
                return "";
            }
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return Double.valueOf(0.0).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    private class RelatedPeptidesTable
    extends DefaultTableModel {
        private RelatedPeptidesTable() {
        }

        @Override
        public int getRowCount() {
            return ModificationsPanel.this.relatedPeptides.size();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "   ";
                }
                case 2: {
                    return "PI";
                }
                case 3: {
                    return "Sequence";
                }
                case 4: {
                    return "Modification";
                }
                case 5: {
                    return "Peptide";
                }
                case 6: {
                    return "  ";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                if (row >= ModificationsPanel.this.displayedPeptides.size()) {
                    return "";
                }
                if (column == 0) {
                    return row + 1;
                }
                long key = (Long)ModificationsPanel.this.relatedPeptides.get(row);
                PeptideMatch peptideMatch = ModificationsPanel.this.identification.getPeptideMatch(key);
                PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                switch (column) {
                    case 1: {
                        return psParameter.getStarred();
                    }
                    case 2: {
                        return psParameter.getProteinInferenceGroupClass();
                    }
                    case 3: {
                        return ModificationsPanel.this.peptideShakerGUI.getDisplayFeaturesGenerator().getTaggedPeptideSequence(peptideMatch, true, true, true);
                    }
                    case 4: {
                        PSModificationScores ptmScores = (PSModificationScores)peptideMatch.getUrParam((UrParameter)PSModificationScores.dummy);
                        if (ptmScores != null && ptmScores.getModificationScoring(ModificationsPanel.this.getSelectedModification()) != null) {
                            ModificationScoring ptmScoring = ptmScores.getModificationScoring(ModificationsPanel.this.getSelectedModification());
                            return ptmScoring.getMinimalLocalizationConfidence();
                        }
                        return -1;
                    }
                    case 5: {
                        return psParameter.getConfidence();
                    }
                    case 6: {
                        return psParameter.getMatchValidationLevel().getIndex();
                    }
                }
                return "";
            }
            catch (Exception e) {
                ModificationsPanel.this.peptideShakerGUI.catchException(e);
                return "";
            }
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return Double.valueOf(0.0).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    private class PsmsTable
    extends DefaultTableModel {
        private Boolean relatedTable;

        public PsmsTable(boolean relatedTable) {
            this.relatedTable = relatedTable;
        }

        @Override
        public int getRowCount() {
            if (this.relatedTable == null) {
                return 0;
            }
            if (!this.relatedTable.booleanValue() && ModificationsPanel.this.peptidesTable.getSelectedRow() != -1 || this.relatedTable.booleanValue() && ModificationsPanel.this.relatedPeptidesTable.getSelectedRow() != -1) {
                try {
                    return ((PeptideMatch)ModificationsPanel.this.identification.retrieveObject(ModificationsPanel.this.getSelectedPeptide(this.relatedTable))).getSpectrumCount();
                }
                catch (Exception e) {
                    ModificationsPanel.this.peptideShakerGUI.catchException(e);
                    return 0;
                }
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "   ";
                }
                case 2: {
                    return "Sequence";
                }
                case 3: {
                    return "Modification";
                }
                case 4: {
                    return "Charge";
                }
                case 5: {
                    return "RT";
                }
                case 6: {
                    return "  ";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return row + 1;
            }
            long peptideMatchKey = ModificationsPanel.this.getSelectedPeptide(this.relatedTable);
            PeptideMatch peptideMatch = ModificationsPanel.this.identification.getPeptideMatch(peptideMatchKey);
            long spectrumMatchKey = peptideMatch.getSpectrumMatchesKeys()[row];
            SpectrumMatch spectrumMatch = ModificationsPanel.this.identification.getSpectrumMatch(spectrumMatchKey);
            PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam((UrParameter)PSParameter.dummy);
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return psParameter.getStarred();
                }
                case 2: {
                    return ModificationsPanel.this.peptideShakerGUI.getDisplayFeaturesGenerator().getTaggedPeptideSequence(spectrumMatch, true, true, true);
                }
                case 3: {
                    PSModificationScores ptmScores = (PSModificationScores)spectrumMatch.getUrParam((UrParameter)PSModificationScores.dummy);
                    if (ptmScores != null && ptmScores.getModificationScoring(ModificationsPanel.this.getSelectedModification()) != null) {
                        ModificationScoring ptmScoring = ptmScores.getModificationScoring(ModificationsPanel.this.getSelectedModification());
                        return ptmScoring.getMinimalLocalizationConfidence();
                    }
                    return -1;
                }
                case 4: {
                    return spectrumMatch.getBestPeptideAssumption().getIdentificationCharge();
                }
                case 5: {
                    String spectrumFile = spectrumMatch.getSpectrumFile();
                    String spectrumTitle = spectrumMatch.getSpectrumTitle();
                    double precursorRT = ModificationsPanel.this.peptideShakerGUI.getSpectrumProvider().getPrecursorRt(spectrumFile, spectrumTitle);
                    return precursorRT;
                }
                case 6: {
                    return psParameter.getMatchValidationLevel().getIndex();
                }
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return Double.valueOf(0.0).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

