/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.preferences;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.io.IoUtil;
import com.compomics.util.pride.prideobjects.ContactGroup;
import com.compomics.util.pride.prideobjects.Instrument;
import com.compomics.util.pride.prideobjects.Protocol;
import com.compomics.util.pride.prideobjects.ReferenceGroup;
import com.compomics.util.pride.prideobjects.Sample;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;

public class ProjectDetails
extends ExperimentObject {
    private final ArrayList<String> identificationFiles = new ArrayList();
    private HashMap<String, HashMap<String, ArrayList<String>>> identificationAlgorithms = new HashMap();
    private HashMap<String, String> spectrumFiles = new HashMap();
    private String fastaFilePath;
    private Date creationDate;
    private String report;
    private String prideExperimentTitle;
    private String prideExperimentLabel;
    private String prideExperimentProjectTitle;
    private String prideExperimentDescription;
    private ReferenceGroup prideReferenceGroup;
    private ContactGroup prideContactGroup;
    private Sample prideSample;
    private Protocol prideProtocol;
    private Instrument prideInstrument;
    private String prideOutputFolder;
    private String mzIdentMLOutputFile;
    private Boolean includeProteinSequences;
    private String peptideShakerVersion;
    private String contactFirstName;
    private String contactLastName;
    private String contactEmail;
    private String contactUrl;
    private String contactAddress;
    private String organizationName;
    private String organizationEmail;
    private String organizationUrl;
    private String organizationAddress;
    private HashMap<Integer, Advocate> userAdvocateMapping;

    public ArrayList<String> getIdentificationFiles() {
        return this.identificationFiles;
    }

    public void addIdentificationFiles(File identificationFile) {
        String path = identificationFile.getAbsolutePath();
        this.identificationFiles.add(path);
    }

    public void addSpectrumFilePath(String spectrumFilePath) {
        String fileName = IoUtil.getFileName((String)spectrumFilePath);
        this.spectrumFiles.put(IoUtil.removeExtension((String)fileName), spectrumFilePath);
    }

    public Set<String> getSpectrumFileNames() {
        return this.spectrumFiles.keySet();
    }

    public String getSpectrumFilePath(String fileName) {
        return this.spectrumFiles.get(fileName);
    }

    public void setFastaFile(File fastaFile) {
        this.fastaFilePath = fastaFile.getAbsolutePath();
    }

    public String getFastaFile() {
        return this.fastaFilePath;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getPeptideShakerVersion() {
        return this.peptideShakerVersion;
    }

    public void setPeptideShakerVersion(String peptideShakerVersion) {
        this.peptideShakerVersion = peptideShakerVersion;
    }

    public String getReport() {
        return this.report == null ? "(report not saved)" : this.report;
    }

    public void setReport(String report) {
        this.report = report;
    }

    public String getPrideExperimentTitle() {
        return this.prideExperimentTitle;
    }

    public void setPrideExperimentTitle(String prideExperimentTitle) {
        this.prideExperimentTitle = prideExperimentTitle;
    }

    public String getPrideExperimentLabel() {
        return this.prideExperimentLabel;
    }

    public void setPrideExperimentLabel(String prideExperimentLabel) {
        this.prideExperimentLabel = prideExperimentLabel;
    }

    public String getPrideExperimentProjectTitle() {
        return this.prideExperimentProjectTitle;
    }

    public void setPrideExperimentProjectTitle(String prideExperimentProjectTitle) {
        this.prideExperimentProjectTitle = prideExperimentProjectTitle;
    }

    public String getPrideExperimentDescription() {
        return this.prideExperimentDescription;
    }

    public void setPrideExperimentDescription(String prideExperimentDescription) {
        this.prideExperimentDescription = prideExperimentDescription;
    }

    public ReferenceGroup getPrideReferenceGroup() {
        return this.prideReferenceGroup;
    }

    public void setPrideReferenceGroup(ReferenceGroup prideReferenceGroup) {
        this.prideReferenceGroup = prideReferenceGroup;
    }

    public ContactGroup getPrideContactGroup() {
        return this.prideContactGroup;
    }

    public void setPrideContactGroup(ContactGroup prideContactGroup) {
        this.prideContactGroup = prideContactGroup;
    }

    public Sample getPrideSample() {
        return this.prideSample;
    }

    public void setPrideSample(Sample prideSample) {
        this.prideSample = prideSample;
    }

    public Protocol getPrideProtocol() {
        return this.prideProtocol;
    }

    public void setPrideProtocol(Protocol prideProtocol) {
        this.prideProtocol = prideProtocol;
    }

    public Instrument getPrideInstrument() {
        return this.prideInstrument;
    }

    public void setPrideInstrument(Instrument prideInstrument) {
        this.prideInstrument = prideInstrument;
    }

    public String getPrideOutputFolder() {
        return this.prideOutputFolder;
    }

    public void setPrideOutputFolder(String prideOutputFolder) {
        this.prideOutputFolder = prideOutputFolder;
    }

    public String getMzIdentMLOutputFile() {
        return this.mzIdentMLOutputFile;
    }

    public void setMzIdentOutputFile(String mzIdentMLOutputFile) {
        this.mzIdentMLOutputFile = mzIdentMLOutputFile;
    }

    public boolean hasIdentificationAlgorithms() {
        return this.identificationAlgorithms != null;
    }

    public ArrayList<Integer> getIdentificationAlgorithms() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (HashMap<String, ArrayList<String>> advocateVersions : this.identificationAlgorithms.values()) {
            for (String advocateName : advocateVersions.keySet()) {
                Advocate advocate = Advocate.getAdvocate((String)advocateName);
                if (advocate == null) {
                    throw new IllegalArgumentException("Identification algorithm " + advocateName + " not recognized.");
                }
                int advocateId = advocate.getIndex();
                if (result.contains(advocateId)) continue;
                result.add(advocateId);
            }
        }
        return result;
    }

    public HashMap<String, ArrayList<String>> getAlgorithmNameToVersionsMap() {
        HashMap<String, ArrayList<String>> algorithmNameToVersionMap = new HashMap<String, ArrayList<String>>();
        for (HashMap<String, ArrayList<String>> fileMapping : this.identificationAlgorithms.values()) {
            for (String softwareName : fileMapping.keySet()) {
                ArrayList<String> newVersions = fileMapping.get(softwareName);
                if (newVersions == null || newVersions.isEmpty()) continue;
                ArrayList<String> currentVersions = algorithmNameToVersionMap.get(softwareName);
                if (currentVersions == null) {
                    currentVersions = new ArrayList<String>(newVersions);
                    algorithmNameToVersionMap.put(softwareName, currentVersions);
                    continue;
                }
                for (String version : newVersions) {
                    if (currentVersions.contains(version)) continue;
                    currentVersions.add(version);
                }
            }
        }
        return algorithmNameToVersionMap;
    }

    public HashMap<String, ArrayList<String>> getIdentificationAlgorithmsForFile(String idFileName) {
        return this.identificationAlgorithms == null ? null : this.identificationAlgorithms.get(idFileName);
    }

    public void setIdentificationAlgorithmsForFile(String idFileName, HashMap<String, ArrayList<String>> fileIdentificationAlgorithms) {
        this.identificationAlgorithms.put(idFileName, fileIdentificationAlgorithms);
    }

    public String getContactFirstName() {
        return this.contactFirstName;
    }

    public void setContactFirstName(String contactFirstName) {
        this.contactFirstName = contactFirstName;
    }

    public String getContactLastName() {
        return this.contactLastName;
    }

    public void setContactLastName(String contactLastName) {
        this.contactLastName = contactLastName;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public void setContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
    }

    public String getContactUrl() {
        return this.contactUrl;
    }

    public void setContactUrl(String contactUrl) {
        this.contactUrl = contactUrl;
    }

    public String getContactAddress() {
        return this.contactAddress;
    }

    public void setContactAddress(String contactAddress) {
        this.contactAddress = contactAddress;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getOrganizationEmail() {
        return this.organizationEmail;
    }

    public void setOrganizationEmail(String organizationEmail) {
        this.organizationEmail = organizationEmail;
    }

    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    public void setOrganizationUrl(String organizationUrl) {
        this.organizationUrl = organizationUrl;
    }

    public String getOrganizationAddress() {
        return this.organizationAddress;
    }

    public void setOrganizationAddress(String organizationAddress) {
        this.organizationAddress = organizationAddress;
    }

    public HashMap<Integer, Advocate> getUserAdvocateMapping() {
        return this.userAdvocateMapping;
    }

    public void setUserAdvocateMapping(HashMap<Integer, Advocate> userAdvocateMapping) {
        this.userAdvocateMapping = userAdvocateMapping;
    }

    public Boolean getIncludeProteinSequences() {
        if (this.includeProteinSequences == null) {
            this.includeProteinSequences = false;
        }
        return this.includeProteinSequences;
    }

    public void setIncludeProteinSequences(Boolean includeProteinSequences) {
        this.includeProteinSequences = includeProteinSequences;
    }
}

