/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.processing;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.modifications.ModificationProvider;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches_iterators.ProteinMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.Metrics;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.utils.ProteinUtils;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.tools.ProcessingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.ptm.ModificationLocalizationScorer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ProteinProcessor {
    private final Identification identification;
    private final IdentificationParameters identificationParameters;
    private final IdentificationFeaturesGenerator identificationFeaturesGenerator;
    private final SequenceProvider sequenceProvider;

    public ProteinProcessor(Identification identification, IdentificationParameters identificationParameters, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider) {
        this.identification = identification;
        this.identificationParameters = identificationParameters;
        this.identificationFeaturesGenerator = identificationFeaturesGenerator;
        this.sequenceProvider = sequenceProvider;
    }

    public void processProteins(ModificationLocalizationScorer modificationLocalizationScorer, Metrics metrics, ModificationProvider modificationProvider, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, ProcessingParameters processingParameters) throws InterruptedException, TimeoutException {
        waitingHandler.setWaitingText("Scoring Protein Modification Localization. Please Wait...");
        int max = this.identification.getProteinIdentification().size();
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(max);
        ExecutorService pool = Executors.newFixedThreadPool(processingParameters.getnThreads());
        ProteinMatchesIterator proteinMatchesIterator = this.identification.getProteinMatchesIterator(waitingHandler);
        ArrayList<ProteinRunnable> runnables = new ArrayList<ProteinRunnable>(processingParameters.getnThreads());
        for (int i = 1; i <= processingParameters.getnThreads(); ++i) {
            ProteinRunnable runnable = new ProteinRunnable(proteinMatchesIterator, modificationLocalizationScorer, modificationProvider, waitingHandler, exceptionHandler);
            pool.submit(runnable);
            runnables.add(runnable);
        }
        if (waitingHandler.isRunCanceled()) {
            pool.shutdownNow();
        }
        pool.shutdown();
        if (!pool.awaitTermination(this.identification.getProteinIdentification().size(), TimeUnit.MINUTES)) {
            throw new InterruptedException("Protein matches validation timed out. Please contact the developers.");
        }
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        if (metrics != null) {
            metrics.setMaxSpectrumCounting(Double.valueOf(runnables.stream().mapToDouble(ProteinRunnable::getMaxSpectrumCounting).sum()));
            metrics.setnValidatedProteins(runnables.stream().mapToInt(ProteinRunnable::getnValidatedProteins).sum());
            metrics.setnConfidentProteins(runnables.stream().mapToInt(ProteinRunnable::getnConfidentProteins).sum());
            metrics.setMaxNPeptides(Integer.valueOf(runnables.stream().mapToInt(ProteinRunnable::getMaxPeptides).max().orElse(0)));
            metrics.setMaxNPsms(Integer.valueOf(runnables.stream().mapToInt(ProteinRunnable::getMaxPsms).max().orElse(0)));
            metrics.setMaxMW(Double.valueOf(runnables.stream().mapToDouble(ProteinRunnable::getMaxMW).max().orElse(0.0)));
            metrics.setMaxProteinAccessionLength(runnables.stream().mapToInt(ProteinRunnable::getMaxProteinAccessionLength).max().orElse(0));
            TreeMap orderMap1 = new TreeMap();
            for (int i = 0; i < runnables.size(); ++i) {
                HashMap<Double, HashMap<Integer, HashMap<Integer, HashSet<Long>>>> threadMap1 = ((ProteinRunnable)runnables.get(i)).getOrderMap();
                for (Map.Entry<Double, HashMap<Integer, HashMap<Integer, HashSet<Long>>>> entry1 : threadMap1.entrySet()) {
                    double key1 = entry1.getKey();
                    HashMap<Integer, HashMap<Integer, HashSet<Long>>> threadMap2 = entry1.getValue();
                    TreeMap orderMap2 = (TreeMap)orderMap1.get(key1);
                    if (orderMap2 == null) {
                        orderMap2 = new TreeMap();
                        orderMap1.put(key1, orderMap2);
                    }
                    for (Map.Entry<Integer, HashMap<Integer, HashSet<Long>>> entry2 : threadMap2.entrySet()) {
                        int key2 = entry2.getKey();
                        HashMap<Integer, HashSet<Long>> threadMap3 = entry2.getValue();
                        TreeMap<Integer, TreeSet<Long>> orderMap3 = (TreeMap<Integer, TreeSet<Long>>)orderMap2.get(key2);
                        if (orderMap3 == null) {
                            orderMap3 = new TreeMap<Integer, TreeSet<Long>>();
                            orderMap2.put(key2, orderMap3);
                        }
                        for (Map.Entry<Integer, HashSet<Long>> entry3 : threadMap3.entrySet()) {
                            int key3 = entry3.getKey();
                            HashSet<Long> threadSet = entry3.getValue();
                            TreeSet<Long> orderedSet = (TreeSet<Long>)orderMap3.get(key3);
                            if (orderedSet == null) {
                                orderedSet = new TreeSet<Long>();
                                orderMap3.put(key3, orderedSet);
                            }
                            orderedSet.addAll(threadSet);
                        }
                    }
                }
            }
            long[] proteinKeys = orderMap1.values().stream().flatMap(map -> map.values().stream()).flatMap(map -> map.values().stream()).flatMap(set -> set.stream()).mapToLong(a -> a).toArray();
            metrics.setProteinKeys(proteinKeys);
        }
    }

    private class ProteinRunnable
    implements Runnable {
        private final ProteinMatchesIterator proteinMatchesIterator;
        private final ModificationLocalizationScorer modificationLocalizationScorer;
        private final ModificationProvider modificationProvider;
        private final WaitingHandler waitingHandler;
        private final ExceptionHandler exceptionHandler;
        private int nValidatedProteins = 0;
        private int nConfidentProteins = 0;
        private double maxSpectrumCounting = 0.0;
        private HashMap<Double, HashMap<Integer, HashMap<Integer, HashSet<Long>>>> orderMap = new HashMap();
        private double maxMW = 0.0;
        private int maxProteinAccessionLength = 6;
        private int maxPeptides = 0;
        private int maxPsms = 0;

        public ProteinRunnable(ProteinMatchesIterator proteinMatchesIterator, ModificationLocalizationScorer modificationLocalizationScorer, ModificationProvider modificationProvider, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) {
            this.proteinMatchesIterator = proteinMatchesIterator;
            this.modificationLocalizationScorer = modificationLocalizationScorer;
            this.waitingHandler = waitingHandler;
            this.exceptionHandler = exceptionHandler;
            this.modificationProvider = modificationProvider;
        }

        @Override
        public void run() {
            try {
                ProteinMatch proteinMatch;
                while ((proteinMatch = this.proteinMatchesIterator.next()) != null && !this.waitingHandler.isRunCanceled()) {
                    double tempSpectrumCounting;
                    long proteinKey = proteinMatch.getKey();
                    this.modificationLocalizationScorer.scorePTMs(ProteinProcessor.this.identification, proteinMatch, ProteinProcessor.this.identificationParameters, false, this.modificationProvider, ProteinProcessor.this.sequenceProvider, this.waitingHandler);
                    PSParameter psParameter = (PSParameter)proteinMatch.getUrParam((UrParameter)PSParameter.dummy);
                    if (!proteinMatch.isDecoy()) {
                        int nPsms;
                        HashSet<Long> nSpectraList;
                        int nPeptides;
                        HashMap<Integer, HashSet<Long>> nPeptidesMap;
                        double score = psParameter.getScore();
                        HashMap<Integer, HashMap<Integer, HashSet<Long>>> scoreMap = this.orderMap.get(score);
                        if (scoreMap == null) {
                            scoreMap = new HashMap(1);
                            this.orderMap.put(score, scoreMap);
                        }
                        if ((nPeptidesMap = scoreMap.get(-(nPeptides = proteinMatch.getPeptideMatchesKeys().length))) == null) {
                            nPeptidesMap = new HashMap(1);
                            scoreMap.put(-nPeptides, nPeptidesMap);
                            if (nPeptides > this.maxPeptides) {
                                this.maxPeptides = nPeptides;
                            }
                        }
                        if ((nSpectraList = nPeptidesMap.get(-(nPsms = Arrays.stream(proteinMatch.getPeptideMatchesKeys()).mapToObj(peptideKey -> ProteinProcessor.this.identification.getPeptideMatch(peptideKey)).mapToInt(peptideMatch -> peptideMatch.getSpectrumCount()).sum()))) == null) {
                            nSpectraList = new HashSet(1);
                            nPeptidesMap.put(-nPsms, nSpectraList);
                            if (nPsms > this.maxPsms) {
                                this.maxPsms = nPsms;
                            }
                        }
                        nSpectraList.add(proteinMatch.getKey());
                        String mainAccession = proteinMatch.getLeadingAccession();
                        String proteinSequence = ProteinProcessor.this.sequenceProvider.getSequence(mainAccession);
                        double mw = ProteinUtils.computeMolecularWeight((String)proteinSequence);
                        if (mw > this.maxMW) {
                            this.maxMW = mw;
                        }
                        if (mainAccession.length() > this.maxProteinAccessionLength) {
                            this.maxProteinAccessionLength = proteinMatch.getLeadingAccession().length();
                        }
                        if (psParameter.getMatchValidationLevel().isValidated()) {
                            ++this.nValidatedProteins;
                            if (psParameter.getMatchValidationLevel() == MatchValidationLevel.confident) {
                                ++this.nConfidentProteins;
                            }
                        }
                    }
                    if (ProteinProcessor.this.identificationFeaturesGenerator != null && (tempSpectrumCounting = ProteinProcessor.this.identificationFeaturesGenerator.getNormalizedSpectrumCounting(proteinKey)) > this.maxSpectrumCounting) {
                        this.maxSpectrumCounting = tempSpectrumCounting;
                    }
                    this.waitingHandler.increaseSecondaryProgressCounter();
                }
            }
            catch (Exception e) {
                this.exceptionHandler.catchException(e);
            }
        }

        public int getnValidatedProteins() {
            return this.nValidatedProteins;
        }

        public int getnConfidentProteins() {
            return this.nConfidentProteins;
        }

        public double getMaxSpectrumCounting() {
            return this.maxSpectrumCounting;
        }

        public HashMap<Double, HashMap<Integer, HashMap<Integer, HashSet<Long>>>> getOrderMap() {
            return this.orderMap;
        }

        public double getMaxMW() {
            return this.maxMW;
        }

        public int getMaxProteinAccessionLength() {
            return this.maxProteinAccessionLength;
        }

        public int getMaxPeptides() {
            return this.maxPeptides;
        }

        public int getMaxPsms() {
            return this.maxPsms;
        }
    }
}

