/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.protein_inference;

import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.ProteinInferenceParameters;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.threading.SimpleSemaphore;
import com.compomics.util.waiting.WaitingHandler;
import com.google.common.collect.Sets;
import eu.isas.peptideshaker.protein_inference.ProteinInference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Collectors;

public class GroupSimplification {
    private final int[] nDeleted = new int[ProteinInference.GroupSimplificationOption.values().length];

    public void removeRedundantGroups(Identification identification, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, WaitingHandler waitingHandler) {
        int max = identification.getProteinIdentification().size();
        if (waitingHandler != null) {
            waitingHandler.setWaitingText("Symplifying Protein Groups. Please Wait...");
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressCounter(max);
        }
        HashSet proteinGroupKeys = identification.getProteinIdentification();
        HashSet toDelete = new HashSet();
        HashMap processedKeys = new HashMap();
        SimpleSemaphore mutex = new SimpleSemaphore(1);
        proteinGroupKeys.stream().filter(key -> !processedKeys.containsKey(key)).map(key -> identification.getProteinMatch(key.longValue())).filter(proteinMatch -> proteinMatch.getNProteins() > 1).forEach(proteinSharedGroup -> this.removeRedundantGroups(identification, identificationParameters, sequenceProvider, proteinDetailsProvider, (ProteinMatch)proteinSharedGroup, processedKeys, toDelete, mutex, waitingHandler));
        int totalSimplified = Arrays.stream(this.nDeleted).sum();
        if (totalSimplified > 0) {
            if (waitingHandler != null) {
                waitingHandler.appendReport(toDelete.size() + " unlikely protein mappings found:", true, true);
                String padding = "    ";
                for (int i = 0; i < ProteinInference.GroupSimplificationOption.values().length; ++i) {
                    int iSimplified = this.nDeleted[i];
                    if (iSimplified <= 0) continue;
                    ProteinInference.GroupSimplificationOption option = ProteinInference.GroupSimplificationOption.values()[i];
                    waitingHandler.appendReport(padding + "- " + iSimplified + " " + option.description + ".", true, true);
                }
                waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                waitingHandler.setMaxSecondaryProgressCounter(toDelete.size());
            }
            toDelete.stream().forEach(key -> {
                identification.removeObject(key.longValue());
                if (waitingHandler != null) {
                    if (waitingHandler.isRunCanceled()) {
                        return;
                    }
                    waitingHandler.increaseSecondaryProgressCounter();
                }
            });
        }
    }

    public void removeRedundantGroups(Identification identification, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, ProteinMatch proteinSharedGroup, HashMap<Long, long[]> processedKeys, HashSet<Long> toDelete, SimpleSemaphore mutex, WaitingHandler waitingHandler) {
        if (waitingHandler.isRunCanceled()) {
            return;
        }
        long sharedKey = proteinSharedGroup.getKey();
        mutex.acquire();
        if (!processedKeys.containsKey(sharedKey)) {
            ProteinMatch[] reducedGroups = this.getSubgroup(identification, proteinSharedGroup, processedKeys, toDelete, sequenceProvider, proteinDetailsProvider, identificationParameters);
            if (reducedGroups != null) {
                long[] reducedGroupKeys = new long[reducedGroups.length];
                processedKeys.put(sharedKey, reducedGroupKeys);
                for (int i = 0; i < reducedGroups.length; ++i) {
                    long reducedGroupKey;
                    ProteinMatch reducedGroup = reducedGroups[i];
                    reducedGroupKeys[i] = reducedGroupKey = reducedGroup.getKey();
                }
                toDelete.add(sharedKey);
            } else {
                long[] reducedGroupKeys = new long[]{sharedKey};
                processedKeys.put(sharedKey, reducedGroupKeys);
            }
        }
        mutex.release();
        waitingHandler.increaseSecondaryProgressCounter();
    }

    private ProteinMatch[] getSubgroup(Identification identification, ProteinMatch sharedProteinMatch, HashMap<Long, long[]> processedKeys, HashSet<Long> toDelete, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, IdentificationParameters identificationParameters) {
        long sharedKey = sharedProteinMatch.getKey();
        Object[] accessions = sharedProteinMatch.getAccessions();
        HashSet accessionsAsSet = Sets.newHashSet((Object[])accessions);
        HashMap<Long, ProteinMatch> subgroups = new HashMap<Long, ProteinMatch>(0);
        for (Object accession2 : accessions) {
            HashSet otherGroups = (HashSet)identification.getProteinMap().get(accession2);
            Iterator iterator = otherGroups.iterator();
            while (iterator.hasNext()) {
                ProteinMatch simplerProteinMatch;
                String[] uniqueAccessions;
                long uniqueKey = (Long)iterator.next();
                if (uniqueKey == sharedKey || toDelete.contains(uniqueKey) || subgroups.containsKey(uniqueKey) || accessions.length <= (uniqueAccessions = (simplerProteinMatch = identification.getProteinMatch(uniqueKey)).getAccessions()).length || !Arrays.stream(uniqueAccessions).allMatch(uniqueAccession -> accessionsAsSet.contains(uniqueAccession))) continue;
                if (uniqueAccessions.length > 1) {
                    long[] reducedGroupKeys = processedKeys.get(uniqueKey);
                    if (reducedGroupKeys == null) {
                        ProteinMatch[] reducedGroups = this.getSubgroup(identification, simplerProteinMatch, processedKeys, toDelete, sequenceProvider, proteinDetailsProvider, identificationParameters);
                        if (reducedGroups != null) {
                            reducedGroupKeys = new long[reducedGroups.length];
                            processedKeys.put(uniqueKey, reducedGroupKeys);
                            for (int i = 0; i < reducedGroups.length; ++i) {
                                long reducedGroupKey2;
                                ProteinMatch reducedGroup = reducedGroups[i];
                                reducedGroupKeys[i] = reducedGroupKey2 = reducedGroup.getKey();
                                subgroups.put(reducedGroupKey2, reducedGroup);
                            }
                            toDelete.add(sharedKey);
                            continue;
                        }
                        reducedGroupKeys = new long[]{uniqueKey};
                        processedKeys.put(uniqueKey, reducedGroupKeys);
                        subgroups.put(uniqueKey, simplerProteinMatch);
                        continue;
                    }
                    Arrays.stream(reducedGroupKeys).forEach(reducedGroupKey -> subgroups.put(reducedGroupKey, identification.getProteinMatch(reducedGroupKey)));
                    continue;
                }
                subgroups.put(uniqueKey, simplerProteinMatch);
            }
        }
        if (subgroups.isEmpty()) {
            return null;
        }
        HashSet coveredAccessionsSet = subgroups.values().stream().flatMap(proteinMatch -> Arrays.stream(proteinMatch.getAccessions())).collect(Collectors.toCollection(HashSet::new));
        String[] uniqueAccessions = (String[])Arrays.stream(accessions).filter(accession -> !coveredAccessionsSet.contains(accession)).toArray(String[]::new);
        String[] coveredAccessions = coveredAccessionsSet.toArray(new String[coveredAccessionsSet.size()]);
        int bestSimplification = ProteinInference.GroupSimplificationOption.values().length - 1;
        for (String uniqueAccession2 : uniqueAccessions) {
            ProteinInference.GroupSimplificationOption groupSimplificationOption = this.getSimplificationOption(sharedProteinMatch, uniqueAccession2, coveredAccessions, sequenceProvider, proteinDetailsProvider, identificationParameters, identification);
            if (groupSimplificationOption == null) {
                return null;
            }
            if (groupSimplificationOption.index >= bestSimplification) continue;
            bestSimplification = groupSimplificationOption.index;
        }
        int n = bestSimplification;
        this.nDeleted[n] = this.nDeleted[n] + 1;
        toDelete.add(sharedKey);
        return subgroups.values().toArray(new ProteinMatch[subgroups.size()]);
    }

    private ProteinInference.GroupSimplificationOption getSimplificationOption(ProteinMatch sharedMatch, String accession, String[] coveredAccessions, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, IdentificationParameters identificationParameters, Identification identification) {
        DigestionParameters digestionParameters;
        ProteinInferenceParameters proteinInferenceParameters = identificationParameters.getProteinInferenceParameters();
        if (proteinInferenceParameters.getSimplifyGroupsEvidence() && GroupSimplification.isLowerEvidence(accession, coveredAccessions, proteinDetailsProvider)) {
            return ProteinInference.GroupSimplificationOption.lowerEvidence;
        }
        if (proteinInferenceParameters.getSimplifyGroupsVariants()) {
            double threshold = proteinInferenceParameters.getConfidenceThreshold();
            if (Arrays.stream(sharedMatch.getPeptideMatchesKeys()).mapToDouble(key -> ((PSParameter)identification.getPeptideMatch(key).getUrParam((UrParameter)PSParameter.dummy)).getConfidence()).allMatch(confidence -> confidence <= threshold)) {
                return ProteinInference.GroupSimplificationOption.lowerConfidence;
            }
        }
        if (proteinInferenceParameters.getSimplifyGroupsEnzymaticity() && (digestionParameters = identificationParameters.getSearchParameters().getDigestionParameters()).getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme && Arrays.stream(sharedMatch.getPeptideMatchesKeys()).mapToObj(key -> identification.getPeptideMatch(key)).allMatch(peptideMatch -> !PeptideUtils.isEnzymatic((Peptide)peptideMatch.getPeptide(), (SequenceProvider)sequenceProvider, (ArrayList)digestionParameters.getEnzymes()))) {
            return ProteinInference.GroupSimplificationOption.nonEnzymatic;
        }
        if (proteinInferenceParameters.getSimplifyGroupsVariants() && identificationParameters.getPeptideVariantsParameters().getnVariants() > 0 && Arrays.stream(sharedMatch.getPeptideMatchesKeys()).mapToObj(key -> identification.getPeptideMatch(key)).allMatch(peptideMatch -> PeptideUtils.isVariant((Peptide)peptideMatch.getPeptide(), (String)accession))) {
            return ProteinInference.GroupSimplificationOption.variant;
        }
        return null;
    }

    public static boolean isLowerEvidence(String accession, String[] otherAccessions, ProteinDetailsProvider proteinDetailsProvider) {
        String description;
        Integer proteinEvidence = proteinDetailsProvider.getProteinEvidence(accession);
        if (proteinEvidence != null) {
            if (proteinEvidence <= 2) {
                return false;
            }
            Integer bestEvidenceOthers = null;
            for (String otherAccession : otherAccessions) {
                Integer evidence = proteinDetailsProvider.getProteinEvidence(otherAccession);
                if (evidence == null || bestEvidenceOthers != null && evidence >= bestEvidenceOthers) continue;
                bestEvidenceOthers = evidence;
            }
            if (bestEvidenceOthers != null) {
                return proteinEvidence > bestEvidenceOthers;
            }
        }
        if ((description = proteinDetailsProvider.getSimpleDescription(accession)) == null) {
            description = proteinDetailsProvider.getDescription(accession);
        }
        String descriptionFinal = description.toLowerCase();
        boolean proteinUncharacterized = Arrays.stream(ProteinInference.KEYWORDS_UNCHARACTERIZED).anyMatch(keyWord -> descriptionFinal.equals(keyWord));
        boolean otherUncharacterized = true;
        for (String otherAccession : otherAccessions) {
            description = proteinDetailsProvider.getSimpleDescription(otherAccession);
            if (description == null) {
                description = proteinDetailsProvider.getDescription(otherAccession);
            }
            String otherDescriptionFinal = description.toLowerCase();
            boolean tempUncharacterized = Arrays.stream(ProteinInference.KEYWORDS_UNCHARACTERIZED).anyMatch(keyWord -> otherDescriptionFinal.equals(keyWord));
            if (tempUncharacterized) continue;
            otherUncharacterized = false;
            break;
        }
        return !otherUncharacterized && proteinUncharacterized;
    }
}

