/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.ptm;

import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationProvider;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.modification.ModificationLocalizationScore;
import com.compomics.util.experiment.identification.modification.peptide_mapping.ModificationPeptideMapping;
import com.compomics.util.experiment.identification.modification.scores.PhosphoRS;
import com.compomics.util.experiment.identification.peptide_shaker.ModificationScoring;
import com.compomics.util.experiment.identification.peptide_shaker.PSModificationScores;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.utils.ModificationUtils;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.ModificationLocalizationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class ModificationLocalizationScorer
extends ExperimentObject {
    private final ModificationFactory modificationFactory = ModificationFactory.getInstance();
    public final int CONFIDENT_OFFSET = 200;
    public final int INFERRED_OFFSET = 100;

    public void attachDeltaScore(Identification identification, SpectrumMatch spectrumMatch, SequenceMatchingParameters sequenceMatchingParameters, ModificationProvider modificationProvider) {
        PSModificationScores modificationScores = (PSModificationScores)spectrumMatch.getUrParam((UrParameter)PSModificationScores.dummy);
        if (modificationScores == null) {
            modificationScores = new PSModificationScores();
            spectrumMatch.addUrParam((UrParameter)modificationScores);
        }
        Peptide psPeptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
        HashMap assumptions = spectrumMatch.getPeptideAssumptionsMap();
        String mainSequence = psPeptide.getSequence();
        HashMap modificationParameters = Arrays.stream(psPeptide.getVariableModifications()).collect(Collectors.groupingBy(ModificationMatch::getModification, HashMap::new, Collectors.mapping(ModificationMatch::getSite, Collectors.toList())));
        for (Map.Entry entry : modificationParameters.entrySet()) {
            String modName = (String)entry.getKey();
            List sites = (List)entry.getValue();
            Modification modification1 = modificationProvider.getModification(modName);
            Iterator iterator = sites.iterator();
            while (iterator.hasNext()) {
                int modSite = (Integer)iterator.next();
                double refP = 1.0;
                double secondaryP = 1.0;
                for (TreeMap algorithmAssumptions : assumptions.values()) {
                    for (ArrayList assumptionsAtScore : algorithmAssumptions.values()) {
                        for (PeptideAssumption peptideAssumption : assumptionsAtScore) {
                            PSParameter psParameter;
                            double p;
                            if (!peptideAssumption.getPeptide().getSequence().equals(mainSequence)) continue;
                            boolean modificationAtSite = false;
                            boolean modificationFound = false;
                            Peptide peptide = peptideAssumption.getPeptide();
                            for (ModificationMatch modMatch : peptide.getVariableModifications()) {
                                Modification modification2 = modificationProvider.getModification(modMatch.getModification());
                                if (modification1.getMass() != modification2.getMass()) continue;
                                modificationFound = true;
                                PSParameter psParameter2 = (PSParameter)peptideAssumption.getUrParam((UrParameter)PSParameter.dummy);
                                double p2 = psParameter2.getProbability();
                                if (modMatch.getSite() != modSite) continue;
                                modificationAtSite = true;
                                if (!(p2 < refP)) continue;
                                refP = p2;
                            }
                            if (modificationAtSite || !modificationFound || !((p = (psParameter = (PSParameter)peptideAssumption.getUrParam((UrParameter)PSParameter.dummy)).getProbability()) < secondaryP)) continue;
                            secondaryP = p;
                        }
                    }
                }
                ModificationScoring modificationScoring = modificationScores.getModificationScoring(modName);
                if (modificationScoring == null) {
                    modificationScoring = new ModificationScoring(modName);
                    modificationScores.addModificationScoring(modName, modificationScoring);
                }
                if (secondaryP < refP) {
                    secondaryP = refP;
                }
                double deltaScore = (secondaryP - refP) * 100.0;
                modificationScoring.setDeltaScore(modSite, deltaScore);
            }
            identification.updateObject(spectrumMatch.getKey(), (Object)spectrumMatch);
        }
    }

    private void attachProbabilisticScore(SpectrumMatch spectrumMatch, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, ModificationProvider modificationProvider, IdentificationParameters identificationParameters, PeptideSpectrumAnnotator peptideSpectrumAnnotator, Identification identification) {
        double modMass;
        SearchParameters searchParameters = identificationParameters.getSearchParameters();
        AnnotationParameters annotationParameters = identificationParameters.getAnnotationParameters();
        ModificationLocalizationParameters scoringParameters = identificationParameters.getModificationLocalizationParameters();
        SequenceMatchingParameters sequenceMatchingParameters = identificationParameters.getSequenceMatchingParameters();
        SequenceMatchingParameters modificationSequenceMatchingParameters = scoringParameters.getSequenceMatchingParameters();
        ModificationParameters modificationParameters = searchParameters.getModificationParameters();
        PSModificationScores modificationScores = (PSModificationScores)spectrumMatch.getUrParam((UrParameter)PSModificationScores.dummy);
        if (modificationScores != null) {
            modificationScores = new PSModificationScores();
            spectrumMatch.addUrParam((UrParameter)modificationScores);
        }
        HashMap<Double, ArrayList> modificationsMap = new HashMap<Double, ArrayList>(1);
        HashMap<Double, Integer> nMod = new HashMap<Double, Integer>(1);
        PeptideAssumption bestPeptideAssumption = spectrumMatch.getBestPeptideAssumption();
        Peptide peptide = bestPeptideAssumption.getPeptide();
        for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
            Modification refMod = modificationProvider.getModification(modificationMatch.getModification());
            modMass = refMod.getMass();
            if (!modificationsMap.containsKey(modMass)) {
                ArrayList modifications = this.modificationFactory.getSameMassNotFixedModifications(modMass, searchParameters).stream().map(modification -> modificationProvider.getModification(modification)).collect(Collectors.toCollection(ArrayList::new));
                modificationsMap.put(modMass, modifications);
                nMod.put(modMass, 1);
                continue;
            }
            nMod.put(modMass, (Integer)nMod.get(modMass) + 1);
        }
        if (!modificationsMap.isEmpty()) {
            String spectrumFile = spectrumMatch.getSpectrumFile();
            String spectrumTitle = spectrumMatch.getSpectrumTitle();
            Spectrum spectrum = spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
            SpecificAnnotationParameters specificAnnotationParameters = annotationParameters.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, (SpectrumIdentificationAssumption)bestPeptideAssumption, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, (SpectrumAnnotator)peptideSpectrumAnnotator);
            Iterator iterator = modificationsMap.keySet().iterator();
            while (iterator.hasNext()) {
                modMass = (Double)iterator.next();
                HashMap scores = null;
                if (scoringParameters.getSelectedProbabilisticScore() == ModificationLocalizationScore.PhosphoRS && (scores = PhosphoRS.getSequenceProbabilities((Peptide)peptide, (ArrayList)((ArrayList)modificationsMap.get(modMass)), (ModificationParameters)modificationParameters, (Spectrum)spectrum, (SequenceProvider)sequenceProvider, (AnnotationParameters)annotationParameters, (SpecificAnnotationParameters)specificAnnotationParameters, (boolean)scoringParameters.isProbabilisticScoreNeutralLosses(), (SequenceMatchingParameters)sequenceMatchingParameters, (SequenceMatchingParameters)modificationSequenceMatchingParameters, (PeptideSpectrumAnnotator)peptideSpectrumAnnotator, (ModificationProvider)modificationProvider)) == null) {
                    throw new IllegalArgumentException("An error occurred while scoring spectrum " + spectrumTitle + " of file " + spectrumFile + " with PhosphoRS.");
                }
                if (scores == null) continue;
                Modification mappedModification = null;
                String peptideSequence = peptide.getSequence();
                Iterator iterator2 = scores.keySet().iterator();
                while (iterator2.hasNext()) {
                    String modName;
                    ModificationScoring modificationScoring;
                    int site = (Integer)iterator2.next();
                    if (site == 0) {
                        for (Modification modification2 : (ArrayList)modificationsMap.get(modMass)) {
                            if (!modification2.getModificationType().isNTerm()) continue;
                            mappedModification = modification2;
                            break;
                        }
                        if (mappedModification == null) {
                            throw new IllegalArgumentException("Could not map the PTM of mass " + modMass + " on the N-terminus of the peptide " + peptideSequence + ".");
                        }
                    } else if (site == peptideSequence.length() + 1) {
                        for (Modification modification2 : (ArrayList)modificationsMap.get(modMass)) {
                            if (!modification2.getModificationType().isCTerm()) continue;
                            mappedModification = modification2;
                            break;
                        }
                        if (mappedModification == null) {
                            throw new IllegalArgumentException("Could not map the PTM of mass " + modMass + " on the C-terminus of the peptide " + peptideSequence + ".");
                        }
                    } else {
                        Iterator iterator3 = ((ArrayList)modificationsMap.get(modMass)).iterator();
                        if (iterator3.hasNext()) {
                            Modification modification2;
                            mappedModification = modification2 = (Modification)iterator3.next();
                        }
                        if (mappedModification == null) {
                            throw new IllegalArgumentException("Could not map the PTM of mass " + modMass + " at site " + site + " in peptide " + peptide.getSequence() + ".");
                        }
                    }
                    if ((modificationScoring = modificationScores.getModificationScoring(modName = mappedModification.getName())) == null) {
                        modificationScoring = new ModificationScoring(modName);
                        modificationScores.addModificationScoring(modName, modificationScoring);
                    }
                    modificationScoring.setProbabilisticScore(site, ((Double)scores.get(site)).doubleValue());
                }
            }
            identification.updateObject(spectrumMatch.getKey(), (Object)spectrumMatch);
        }
    }

    public void scorePTMs(Identification identification, SpectrumMatch spectrumMatch, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, ModificationProvider modificationProvider, IdentificationParameters identificationParameters, WaitingHandler waitingHandler, PeptideSpectrumAnnotator peptideSpectrumAnnotator) {
        SequenceMatchingParameters sequenceMatchingParameters = identificationParameters.getSequenceMatchingParameters();
        this.attachDeltaScore(identification, spectrumMatch, sequenceMatchingParameters, modificationProvider);
        ModificationLocalizationParameters scoringParameters = identificationParameters.getModificationLocalizationParameters();
        if (scoringParameters.isProbabilisticScoreCalculation()) {
            this.attachProbabilisticScore(spectrumMatch, sequenceProvider, spectrumProvider, modificationProvider, identificationParameters, peptideSpectrumAnnotator, identification);
        }
    }

    public void scorePTMs(Identification identification, PeptideMatch peptideMatch, IdentificationParameters identificationParameters, ModificationProvider modificationProvider, SequenceProvider sequenceProvider, WaitingHandler waitingHandler) {
        SequenceMatchingParameters sequenceMatchingParameters = identificationParameters.getSequenceMatchingParameters();
        SearchParameters searchParameters = identificationParameters.getSearchParameters();
        ModificationParameters modificationParameters = searchParameters.getModificationParameters();
        ModificationLocalizationParameters ModificationLocalizationParameters2 = identificationParameters.getModificationLocalizationParameters();
        Peptide peptide = peptideMatch.getPeptide();
        ModificationMatch[] originalMatches = peptide.getVariableModifications();
        if (originalMatches.length == 0) {
            return;
        }
        long originalKey = peptide.getMatchingKey(sequenceMatchingParameters);
        HashMap<Double, Integer> modificationOccurence = new HashMap<Double, Integer>(originalMatches.length);
        for (ModificationMatch modificationMatch : originalMatches) {
            String modName = modificationMatch.getModification();
            Modification modification = modificationProvider.getModification(modName);
            double modMass = modification.getMass();
            Integer occurrence = (Integer)modificationOccurence.get(modMass);
            if (occurrence == null) {
                modificationOccurence.put(modMass, 1);
                continue;
            }
            modificationOccurence.put(modMass, occurrence + 1);
        }
        PSModificationScores peptideScores = new PSModificationScores();
        HashMap modificationToSiteToScore = new HashMap(originalMatches.length);
        HashMap modificationToSiteToName = new HashMap(originalMatches.length);
        for (long spectrumKey : peptideMatch.getSpectrumMatchesKeys()) {
            SpectrumMatch spectrumMatch = identification.getSpectrumMatch(spectrumKey);
            PSModificationScores psmScores = (PSModificationScores)spectrumMatch.getUrParam((UrParameter)PSModificationScores.dummy);
            for (String modName : psmScores.getScoredModifications()) {
                Modification modification = modificationProvider.getModification(modName);
                double modMass = modification.getMass();
                if (!modificationOccurence.containsKey(modMass)) continue;
                HashMap<Integer, Double> siteToScore = (HashMap<Integer, Double>)modificationToSiteToScore.get(modMass);
                HashMap<Integer, String> siteToName = (HashMap<Integer, String>)modificationToSiteToName.get(modMass);
                if (siteToScore == null) {
                    siteToScore = new HashMap<Integer, Double>(2);
                    modificationToSiteToScore.put(modMass, siteToScore);
                    siteToName = new HashMap<Integer, String>(2);
                    modificationToSiteToName.put(modMass, siteToName);
                }
                ModificationScoring psmScoring = psmScores.getModificationScoring(modName);
                ModificationScoring peptideScoring = peptideScores.getModificationScoring(modName);
                if (peptideScoring == null) {
                    peptideScoring = new ModificationScoring(modName);
                    peptideScores.addModificationScoring(modName, peptideScoring);
                }
                Iterator iterator = psmScoring.getScoredSites().iterator();
                while (iterator.hasNext()) {
                    int site = (Integer)iterator.next();
                    double psmDScore = psmScoring.getDeltaScore(site);
                    double peptideDScore = peptideScoring.getDeltaScore(site);
                    if (peptideDScore < psmDScore) {
                        peptideScoring.setDeltaScore(site, psmDScore);
                    }
                    double psmPScore = psmScoring.getProbabilisticScore(site);
                    double peptidePScore = peptideScoring.getProbabilisticScore(site);
                    if (peptidePScore < psmPScore) {
                        peptideScoring.setProbabilisticScore(site, psmPScore);
                    }
                    int psmValidationLevel = psmScoring.getLocalizationConfidence(site);
                    int peptideValidationLevel = peptideScoring.getLocalizationConfidence(site);
                    if (peptideValidationLevel < psmValidationLevel) {
                        peptideScoring.setSiteConfidence(site, psmValidationLevel);
                    }
                    double psmScore = ModificationLocalizationParameters2.isProbabilisticScoreCalculation() ? psmPScore : psmDScore;
                    Double currentScore = (Double)siteToScore.get(site);
                    if (currentScore == null) {
                        siteToScore.put(site, psmScore);
                        siteToName.put(site, modName);
                        continue;
                    }
                    siteToScore.put(site, Math.max(currentScore, psmScore));
                }
            }
            for (ModificationMatch modificationMatch : spectrumMatch.getBestPeptideAssumption().getPeptide().getVariableModifications()) {
                HashMap siteToName;
                Double currentScore;
                HashMap siteToScore;
                int site;
                double modMass;
                if (modificationMatch.getConfident()) {
                    modMass = modificationProvider.getModification(modificationMatch.getModification()).getMass();
                    if (!modificationOccurence.containsKey(modMass)) continue;
                    site = modificationMatch.getSite();
                    siteToScore = (HashMap)modificationToSiteToScore.get(modMass);
                    currentScore = (Double)siteToScore.get(site);
                    if (currentScore == null) {
                        siteToScore.put(site, 200.0);
                        siteToName = (HashMap)modificationToSiteToName.get(modMass);
                        siteToName.put(site, modificationMatch.getModification());
                        continue;
                    }
                    siteToScore.put(site, currentScore + 200.0);
                    continue;
                }
                if (!modificationMatch.getInferred() || !modificationOccurence.containsKey(modMass = modificationProvider.getModification(modificationMatch.getModification()).getMass())) continue;
                site = modificationMatch.getSite();
                siteToScore = (HashMap)modificationToSiteToScore.get(modMass);
                currentScore = (Double)siteToScore.get(site);
                if (currentScore == null) {
                    siteToScore.put(site, 100.0);
                    siteToName = (HashMap)modificationToSiteToName.get(modMass);
                    siteToName.put(site, modificationMatch.getModification());
                    continue;
                }
                siteToScore.put(site, currentScore + 100.0);
            }
        }
        HashMap<Double, int[]> hashMap = new HashMap<Double, int[]>(modificationToSiteToScore.size());
        for (Map.Entry entry : modificationToSiteToScore.entrySet()) {
            double modMass = (Double)entry.getKey();
            int[] possibleSites = ((HashMap)entry.getValue()).keySet().stream().mapToInt(a -> a).toArray();
            hashMap.put(modMass, possibleSites);
        }
        HashMap mapping = ModificationPeptideMapping.mapModifications(hashMap, modificationOccurence, modificationToSiteToScore);
        ModificationMatch[] newModificationMatches = new ModificationMatch[originalMatches.length];
        int modI = 0;
        for (Map.Entry mappingEntry : mapping.entrySet()) {
            double modMass = (Double)mappingEntry.getKey();
            Iterator iterator = ((TreeSet)mappingEntry.getValue()).iterator();
            while (iterator.hasNext()) {
                int site = (Integer)iterator.next();
                String modName = (String)((HashMap)modificationToSiteToName.get(modMass)).get(site);
                if (modName == null) {
                    throw new IllegalArgumentException("No modification found at site " + site + " for modification mass " + modMass + ".");
                }
                ModificationMatch modificationMatch = new ModificationMatch(modName, site);
                double score = (Double)((HashMap)modificationToSiteToScore.get(modMass)).get(site);
                if (score > 200.0) {
                    modificationMatch.setConfident(true);
                } else if (score > 100.0) {
                    modificationMatch.setInferred(true);
                }
                newModificationMatches[modI] = modificationMatch;
                ++modI;
            }
        }
        if (modI < originalMatches.length) {
            throw new IllegalArgumentException(modI + " modifications found where " + originalMatches.length + " needed.");
        }
        peptide.setVariableModifications(newModificationMatches);
        SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
        double mass = peptide.getMass(modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
        peptide.setMass(mass);
        peptideMatch.addUrParam((UrParameter)peptideScores);
        long newKey = peptide.getMatchingKey(sequenceMatchingParameters);
        if (newKey != originalKey) {
            if (identification.getPeptideIdentification().contains(newKey)) {
                throw new IllegalArgumentException("Attempting to create duplicate peptide key: " + newKey + " from peptide " + originalKey + ".");
            }
            identification.removeObject(originalKey);
            identification.addObject(newKey, (Object)peptideMatch);
        } else {
            identification.updateObject(originalKey, (Object)peptideMatch);
        }
    }

    public void scorePTMs(Identification identification, ProteinMatch proteinMatch, IdentificationParameters identificationParameters, boolean scorePeptides, ModificationProvider modificationProvider, SequenceProvider sequenceProvider, WaitingHandler waitingHandler) {
        HashMap<Integer, HashMap<Double, String>> confidentSites = new HashMap<Integer, HashMap<Double, String>>();
        HashMap<Integer, HashMap<Double, String>> ambiguousSites = new HashMap<Integer, HashMap<Double, String>>();
        for (long peptideKey : proteinMatch.getPeptideMatchesKeys()) {
            PeptideMatch peptideMatch = identification.getPeptideMatch(peptideKey);
            Peptide peptide = peptideMatch.getPeptide();
            PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
            if (!psParameter.getMatchValidationLevel().isValidated() || peptide.getNVariableModifications() <= 0) continue;
            if (scorePeptides) {
                this.scorePTMs(identification, peptideMatch, identificationParameters, modificationProvider, sequenceProvider, waitingHandler);
            }
            int[] peptideStart = (int[])peptide.getProteinMapping().get(proteinMatch.getLeadingAccession());
            for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
                HashMap modificationsAtSite;
                int siteOnProtein;
                String modName = modificationMatch.getModification();
                double modMass = modificationProvider.getModification(modName).getMass();
                int siteOnPeptide = modificationMatch.getSite();
                if (modificationMatch.getConfident()) {
                    for (int peptideTempStart : peptideStart) {
                        siteOnProtein = siteOnPeptide == 0 ? peptideTempStart + 1 : (siteOnPeptide == peptide.getSequence().length() + 1 ? peptideTempStart + siteOnPeptide - 1 : peptideTempStart + siteOnPeptide);
                        modificationsAtSite = (HashMap)confidentSites.get(siteOnProtein);
                        if (modificationsAtSite == null) {
                            modificationsAtSite = new HashMap(1);
                            confidentSites.put(siteOnProtein, modificationsAtSite);
                        }
                        modificationsAtSite.put(modMass, modName);
                    }
                    continue;
                }
                for (int peptideTempStart : peptideStart) {
                    siteOnProtein = siteOnPeptide == 0 ? peptideTempStart + 1 : (siteOnPeptide == peptide.getSequence().length() + 1 ? peptideTempStart + siteOnPeptide - 1 : peptideTempStart + siteOnPeptide);
                    modificationsAtSite = (HashMap)ambiguousSites.get(siteOnProtein);
                    if (modificationsAtSite == null) {
                        modificationsAtSite = new HashMap(1);
                        ambiguousSites.put(siteOnProtein, modificationsAtSite);
                    }
                    modificationsAtSite.put(modMass, modName);
                }
            }
        }
        if (confidentSites.isEmpty() && ambiguousSites.isEmpty()) {
            return;
        }
        ArrayList<ModificationMatch> modificationsList = new ArrayList<ModificationMatch>(confidentSites.size());
        for (Map.Entry entry1 : confidentSites.entrySet()) {
            int site = (Integer)entry1.getKey();
            for (Map.Entry entry2 : ((HashMap)entry1.getValue()).entrySet()) {
                String modName = (String)entry2.getValue();
                ModificationMatch modificationMatch = new ModificationMatch(modName, site);
                modificationMatch.setConfident(true);
                modificationsList.add(modificationMatch);
            }
        }
        for (Map.Entry entry1 : ambiguousSites.entrySet()) {
            int site = (Integer)entry1.getKey();
            HashMap confidentModificationsAtSite = (HashMap)confidentSites.get(site);
            for (Map.Entry entry2 : ((HashMap)entry1.getValue()).entrySet()) {
                double mass = (Double)entry2.getKey();
                String modName = (String)entry2.getValue();
                if (confidentModificationsAtSite != null && confidentModificationsAtSite.containsKey(mass)) continue;
                ModificationMatch modificationMatch = new ModificationMatch(modName, site);
                modificationMatch.setConfident(false);
                modificationsList.add(modificationMatch);
            }
        }
        ModificationMatch[] modificationMatches = (ModificationMatch[])modificationsList.stream().toArray(ModificationMatch[]::new);
        proteinMatch.setVariableModifications(modificationMatches);
    }

    public void scorePeptidePtms(Identification identification, ModificationProvider modificationProvider, SequenceProvider sequenceProvider, WaitingHandler waitingHandler, IdentificationParameters identificationParameters) {
        waitingHandler.setWaitingText("Scoring Peptide Modification Localization. Please Wait...");
        int max = identification.getPeptideIdentification().size();
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(max);
        identification.getPeptideIdentification().stream().map(key -> identification.getPeptideMatch(key.longValue())).forEach(peptideMatch -> {
            this.scorePTMs(identification, (PeptideMatch)peptideMatch, identificationParameters, modificationProvider, sequenceProvider, waitingHandler);
            peptideMatch.getPeptide().getIndexedVariableModifications();
            waitingHandler.increaseSecondaryProgressCounter();
            if (waitingHandler.isRunCanceled()) {
                return;
            }
        });
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
    }

    public void modificationSiteInference(SpectrumMatch spectrumMatch, SequenceProvider sequenceProvider, ModificationProvider modificationProvider, IdentificationParameters identificationParameters) {
        Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
        int nVariableModifications = peptide.getNVariableModifications();
        if (nVariableModifications > 0) {
            SearchParameters searchParameters = identificationParameters.getSearchParameters();
            PSModificationScores modificationScores = (PSModificationScores)spectrumMatch.getUrParam((UrParameter)PSModificationScores.dummy);
            HashMap modMatchesMap = new HashMap(nVariableModifications);
            HashMap possiblePositions = new HashMap(nVariableModifications);
            for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
                HashMap<Integer, String> modPossibleSites;
                String modName = modificationMatch.getModification();
                Modification modification = modificationProvider.getModification(modName);
                double modMass = modification.getMass();
                ArrayList<ModificationMatch> modificationMatches = (ArrayList<ModificationMatch>)modMatchesMap.get(modMass);
                if (modificationMatches == null) {
                    modificationMatches = new ArrayList<ModificationMatch>(1);
                    modMatchesMap.put(modMass, modificationMatches);
                }
                if ((modPossibleSites = (HashMap<Integer, String>)possiblePositions.get(modMass)) == null) {
                    modPossibleSites = new HashMap<Integer, String>(1);
                    possiblePositions.put(modMass, modPossibleSites);
                }
                modificationMatches.add(modificationMatch);
                for (String similarModName : this.modificationFactory.getSameMassNotFixedModifications(modMass, searchParameters)) {
                    int[] possibleSites;
                    Modification similarModification = modificationProvider.getModification(similarModName);
                    if (modification.getMass() != modMass) continue;
                    for (int pos : possibleSites = ModificationUtils.getPossibleModificationSites((Peptide)peptide, (Modification)similarModification, (SequenceProvider)sequenceProvider, (SequenceMatchingParameters)identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters())) {
                        modPossibleSites.put(pos, similarModName);
                    }
                }
            }
            ModificationLocalizationParameters modificationScoringParameters = identificationParameters.getModificationLocalizationParameters();
            Set modMasses = modMatchesMap.keySet();
            ArrayList<ModificationMatch> assignedModifications = new ArrayList<ModificationMatch>(peptide.getNVariableModifications());
            HashMap<Double, int[]> modificationToPossibleSiteMap = new HashMap<Double, int[]>(nVariableModifications);
            HashMap<Double, Integer> modificationOccurrenceMap = new HashMap<Double, Integer>(nVariableModifications);
            HashMap modificationToSiteToScore = new HashMap(nVariableModifications);
            Iterator modMass = modMasses.iterator();
            while (modMass.hasNext()) {
                HashMap modificationPossibleSites;
                int nPossibleSites;
                double modMass2 = (Double)modMass.next();
                ArrayList modificationMatches = (ArrayList)modMatchesMap.get(modMass2);
                int nMods = modificationMatches.size();
                if (nMods <= (nPossibleSites = (modificationPossibleSites = (HashMap)possiblePositions.get(modMass2)).size())) {
                    int[] sites = modificationPossibleSites.keySet().stream().mapToInt(a -> a).toArray();
                    modificationToPossibleSiteMap.put(modMass2, sites);
                    modificationOccurrenceMap.put(modMass2, nMods);
                    HashMap<Integer, Double> siteToScoreMap = (HashMap<Integer, Double>)modificationToSiteToScore.get(modMass2);
                    if (siteToScoreMap == null) {
                        siteToScoreMap = new HashMap<Integer, Double>(sites.length);
                        modificationToSiteToScore.put(modMass2, siteToScoreMap);
                    }
                    for (int site : sites) {
                        String modName = (String)modificationPossibleSites.get(site);
                        ModificationScoring modificationScoring = modificationScores.getModificationScoring(modName);
                        double score = 0.0;
                        if (modificationScoring != null) {
                            score = modificationScoringParameters.isProbabilisticScoreCalculation() ? modificationScoring.getProbabilisticScore(site) : modificationScoring.getDeltaScore(site);
                        }
                        siteToScoreMap.put(site, score);
                    }
                    continue;
                }
                throw new IllegalArgumentException("The occurence of modification of mass " + modMass2 + " (" + modificationMatches.size() + ") is higher than the number of possible sites (" + modificationPossibleSites.size() + ") on sequence " + peptide.getSequence() + " in spectrum " + spectrumMatch.getKey() + ".");
            }
            HashMap matchedSiteByModification = ModificationPeptideMapping.mapModifications(modificationToPossibleSiteMap, modificationOccurrenceMap, modificationToSiteToScore);
            for (Map.Entry entry : matchedSiteByModification.entrySet()) {
                ArrayList modificationMatches;
                double modificationMass = (Double)entry.getKey();
                int[] sortedSelectedSites = ((TreeSet)entry.getValue()).stream().mapToInt(a -> a).toArray();
                if (sortedSelectedSites.length > (modificationMatches = (ArrayList)modMatchesMap.get(modificationMass)).size()) {
                    throw new IllegalArgumentException("More sites than modifications found when assigning confidence levels at mass " + modificationMass + ".");
                }
                HashMap modificationPossibleSites = (HashMap)possiblePositions.get(modificationMass);
                int nMods = modificationMatches.size();
                int nPossibleSites = modificationPossibleSites.size();
                double randomScoreThreshold = modificationScoringParameters.getSelectedProbabilisticScore().getRandomThreshold(nMods, nPossibleSites);
                double confidenceThreshold = modificationScoringParameters.getProbabilisticScoreThreshold();
                double dThreshold = modificationScoringParameters.getDScoreThreshold();
                for (int siteI = 0; siteI < sortedSelectedSites.length; ++siteI) {
                    int site = sortedSelectedSites[siteI];
                    String modName = (String)modificationPossibleSites.get(site);
                    ModificationScoring modificationScoring = modificationScores.getModificationScoring(modName);
                    if (modificationScoring == null) {
                        modificationScoring = new ModificationScoring(modName);
                        modificationScores.addModificationScoring(modName, modificationScoring);
                    }
                    ModificationMatch modificationMatch = new ModificationMatch(modName, site);
                    assignedModifications.add(modificationMatch);
                    double score = (Double)((HashMap)modificationToSiteToScore.get(modificationMass)).get(site);
                    if (nMods == nPossibleSites) {
                        modificationScoring.setSiteConfidence(site, 3);
                        modificationMatch.setConfident(true);
                        continue;
                    }
                    if (modificationScoringParameters.isProbabilisticScoreCalculation() && score >= confidenceThreshold || !modificationScoringParameters.isProbabilisticScoreCalculation() && score >= dThreshold) {
                        modificationScoring.setSiteConfidence(site, 2);
                        modificationMatch.setConfident(true);
                        continue;
                    }
                    if (modificationScoringParameters.isProbabilisticScoreCalculation() && score > randomScoreThreshold) {
                        modificationScoring.setSiteConfidence(site, 1);
                        modificationMatch.setConfident(false);
                        continue;
                    }
                    modificationScoring.setSiteConfidence(site, 0);
                    modificationMatch.setConfident(false);
                }
            }
            ModificationMatch[] modificationMatches = (ModificationMatch[])assignedModifications.stream().toArray(ModificationMatch[]::new);
            if (modificationMatches.length < nVariableModifications) {
                throw new IllegalArgumentException("Only " + modificationMatches.length + " modifications mapped where " + nVariableModifications + " required.");
            }
            peptide.setVariableModifications(modificationMatches);
        }
    }
}

