/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.recalibration;

import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.math.BasicMathFunctions;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class RunMzDeviation {
    private HashMap<Double, Double> precursorSlopes = new HashMap();
    private HashMap<Double, Double> precursorOffsets = new HashMap();
    private ArrayList<Double> precursorRTList;
    private HashMap<Double, TreeMap<Double, Double>> fragmentsRtDeviations = new HashMap();
    private double ms2Bin;
    public static final int rtBinSize = 202;
    public static final int mzBinSize = 101;

    public ArrayList<Double> getPrecursorRTList() {
        return this.precursorRTList;
    }

    public ArrayList<Double> getFragmentMZList(double precursorRT) {
        return new ArrayList<Double>(this.fragmentsRtDeviations.get(precursorRT).keySet());
    }

    public double getSlope(double rtBin) {
        return this.precursorSlopes.get(rtBin);
    }

    public double getOffset(double rtBin) {
        return this.precursorOffsets.get(rtBin);
    }

    public double getPrecursorMzCorrection(double precursorMz, double precursorRT) {
        double key1;
        double key2 = key1 = this.precursorRTList.get(0).doubleValue();
        if (precursorRT > key1) {
            key2 = key1 = this.precursorRTList.get(this.precursorRTList.size() - 1).doubleValue();
            if (precursorRT < key1) {
                for (int i = 0; i < this.precursorRTList.size() - 1; ++i) {
                    key1 = this.precursorRTList.get(i);
                    if (precursorRT == key1) {
                        key2 = precursorRT;
                        break;
                    }
                    key2 = this.precursorRTList.get(i + 1);
                    if (key1 < precursorRT && precursorRT < key2) break;
                }
            }
        }
        double slope = (this.precursorSlopes.get(key1) + this.precursorSlopes.get(key2)) / 2.0;
        double offset = (this.precursorOffsets.get(key1) + this.precursorOffsets.get(key2)) / 2.0;
        return slope * precursorMz + offset;
    }

    public double getFragmentMzError(double precursorRT, double fragmentMZ) {
        double mzKey1;
        double rtKey1;
        double rtKey2 = rtKey1 = this.precursorRTList.get(0).doubleValue();
        if (precursorRT > rtKey1) {
            rtKey2 = rtKey1 = this.precursorRTList.get(this.precursorRTList.size() - 1).doubleValue();
            if (precursorRT < rtKey1) {
                for (int i = 0; i < this.precursorRTList.size() - 1; ++i) {
                    rtKey1 = this.precursorRTList.get(i);
                    if (precursorRT == rtKey1) {
                        rtKey2 = precursorRT;
                        break;
                    }
                    rtKey2 = this.precursorRTList.get(i + 1);
                    if (rtKey1 < precursorRT && precursorRT < rtKey2) break;
                }
            }
        }
        ArrayList<Double> mzList = new ArrayList<Double>(this.fragmentsRtDeviations.get(rtKey1).keySet());
        Collections.sort(mzList);
        double mzKey2 = mzKey1 = mzList.get(0).doubleValue();
        if (fragmentMZ > mzKey1) {
            mzKey2 = mzKey1 = mzList.get(mzList.size() - 1).doubleValue();
            if (fragmentMZ < mzKey1) {
                for (int i = 0; i < mzList.size() - 1; ++i) {
                    mzKey1 = mzList.get(i);
                    if (fragmentMZ == mzKey1) {
                        mzKey2 = fragmentMZ;
                        break;
                    }
                    mzKey2 = mzList.get(i + 1);
                    if (mzKey1 < fragmentMZ && fragmentMZ < mzKey2) break;
                }
            }
        }
        double correction11 = this.fragmentsRtDeviations.get(rtKey1).get(mzKey1);
        double correction12 = this.fragmentsRtDeviations.get(rtKey1).get(mzKey2);
        double correction1 = correction11 * mzKey1 / (mzKey1 + mzKey2) + correction12 * mzKey2 / (mzKey1 + mzKey2);
        mzList = new ArrayList<Double>(this.fragmentsRtDeviations.get(rtKey2).keySet());
        Collections.sort(mzList);
        mzKey2 = mzKey1 = mzList.get(0).doubleValue();
        if (fragmentMZ > mzKey1) {
            mzKey2 = mzKey1 = mzList.get(mzList.size() - 1).doubleValue();
            if (fragmentMZ < mzKey1) {
                for (int i = 0; i < mzList.size() - 1; ++i) {
                    mzKey1 = mzList.get(i);
                    if (fragmentMZ == mzKey1) {
                        mzKey2 = fragmentMZ;
                        break;
                    }
                    mzKey2 = mzList.get(i + 1);
                    if (mzKey1 < fragmentMZ && fragmentMZ < mzKey2) break;
                }
            }
        }
        double correction21 = this.fragmentsRtDeviations.get(rtKey2).get(mzKey1);
        double correction22 = this.fragmentsRtDeviations.get(rtKey2).get(mzKey2);
        double correction2 = correction21 * mzKey1 / (mzKey1 + mzKey2) + correction22 * mzKey2 / (mzKey1 + mzKey2);
        return correction1 * rtKey1 / (rtKey1 + rtKey2) + correction2 * rtKey2 / (rtKey1 + rtKey2);
    }

    public double[] recalibrateFragmentMz(double precursorRT, double[] originalMz) {
        double[] result = new double[originalMz.length];
        for (int i = 0; i < originalMz.length; ++i) {
            double mz = originalMz[i];
            double correction = this.getFragmentMzError(precursorRT, mz);
            result[i] = mz - correction;
        }
        return result;
    }

    public RunMzDeviation(String spectrumFileNameWithoutExtension, Identification identification, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, IdentificationParameters identificationParameters, WaitingHandler waitingHandler) {
        ArrayList<Double> err1;
        ArrayList keys;
        Object modificationParameters;
        Object spectrumTitle;
        AnnotationParameters annotationPreferences = identificationParameters.getAnnotationParameters();
        PeptideSpectrumAnnotator spectrumAnnotator = new PeptideSpectrumAnnotator();
        this.ms2Bin = 100.0 * annotationPreferences.getFragmentIonAccuracy();
        HashMap precursorRawMap = new HashMap();
        HashMap fragmentRawMap = new HashMap();
        PSParameter psParameter = new PSParameter();
        if (waitingHandler != null) {
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(spectrumProvider.getSpectrumTitles(spectrumFileNameWithoutExtension).length);
        }
        Iterator iterator = ((HashSet)identification.getSpectrumIdentification().get(spectrumFileNameWithoutExtension)).iterator();
        while (iterator.hasNext()) {
            long spectrumKey = (Long)iterator.next();
            if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
            SpectrumMatch spectrumMatch = identification.getSpectrumMatch(spectrumKey);
            spectrumTitle = spectrumMatch.getSpectrumTitle();
            if ((psParameter = (PSParameter)spectrumMatch.getUrParam((UrParameter)psParameter)).getMatchValidationLevel().isValidated()) {
                PeptideAssumption bestPeptideAssumption;
                double precursorMz = spectrumProvider.getPrecursorMz(spectrumFileNameWithoutExtension, (String)spectrumTitle);
                double precursorRT = spectrumProvider.getPrecursorRt(spectrumFileNameWithoutExtension, (String)spectrumTitle);
                if (!precursorRawMap.containsKey(precursorRT)) {
                    precursorRawMap.put(precursorRT, new HashMap(1));
                }
                if (!((HashMap)precursorRawMap.get(precursorRT)).containsKey(precursorMz)) {
                    ((HashMap)precursorRawMap.get(precursorRT)).put(precursorMz, new ArrayList(1));
                }
                if ((bestPeptideAssumption = spectrumMatch.getBestPeptideAssumption()) != null) {
                    SearchParameters searchParameters = identificationParameters.getSearchParameters();
                    double error = bestPeptideAssumption.getDeltaMz(precursorMz, false, searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection());
                    ((ArrayList)((HashMap)precursorRawMap.get(precursorRT)).get(precursorMz)).add(error);
                    Spectrum spectrum = spectrumProvider.getSpectrum(spectrumFileNameWithoutExtension, (String)spectrumTitle);
                    modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                    SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                    SpecificAnnotationParameters specificAnnotationPreferences = annotationPreferences.getSpecificAnnotationParameters(spectrumFileNameWithoutExtension, (String)spectrumTitle, (SpectrumIdentificationAssumption)bestPeptideAssumption, (ModificationParameters)modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, (SpectrumAnnotator)spectrumAnnotator);
                    IonMatch[] ionMatches = spectrumAnnotator.getSpectrumAnnotation(annotationPreferences, specificAnnotationPreferences, spectrumFileNameWithoutExtension, (String)spectrumTitle, spectrum, bestPeptideAssumption.getPeptide(), (ModificationParameters)modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
                    HashMap spectrumFragmentMap = new HashMap();
                    for (IonMatch ionMatch : ionMatches) {
                        if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
                        double fragmentMz = ionMatch.peakMz;
                        int roundedValue = (int)(fragmentMz / this.ms2Bin);
                        double fragmentMzKey = (double)roundedValue * this.ms2Bin;
                        if (!spectrumFragmentMap.containsKey(fragmentMzKey)) {
                            spectrumFragmentMap.put(fragmentMzKey, new ArrayList(1));
                        }
                        ((ArrayList)spectrumFragmentMap.get(fragmentMzKey)).add(ionMatch.getAbsoluteError());
                    }
                    if (!fragmentRawMap.containsKey(precursorRT)) {
                        fragmentRawMap.put(precursorRT, new HashMap(1));
                    }
                    Iterator iterator2 = spectrumFragmentMap.keySet().iterator();
                    while (iterator2.hasNext()) {
                        double key = (Double)iterator2.next();
                        if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
                        if (!((HashMap)fragmentRawMap.get(precursorRT)).containsKey(key)) {
                            ((HashMap)fragmentRawMap.get(precursorRT)).put(key, new ArrayList(1));
                        }
                        ((ArrayList)((HashMap)fragmentRawMap.get(precursorRT)).get(key)).add(BasicMathFunctions.median((ArrayList)((ArrayList)spectrumFragmentMap.get(key))));
                    }
                }
            }
            if (waitingHandler == null) continue;
            waitingHandler.increaseSecondaryProgressCounter();
        }
        if (waitingHandler != null) {
            if (waitingHandler.isRunCanceled()) {
                return;
            }
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        if ((keys = new ArrayList(precursorRawMap.keySet())).isEmpty()) {
            throw new IllegalArgumentException("No validated PSM found for file " + spectrumFileNameWithoutExtension + ".");
        }
        Collections.sort(keys);
        int cpt1 = 0;
        TreeMap<Double, HashMap> precursorTempMap = new TreeMap<Double, HashMap>();
        HashMap<Double, HashMap> fragmentTempMap = new HashMap<Double, HashMap>();
        spectrumTitle = keys.iterator();
        block3: while (spectrumTitle.hasNext()) {
            double rt = (Double)spectrumTitle.next();
            if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
            HashMap tempValues = (HashMap)precursorRawMap.get(rt);
            precursorTempMap.put(rt, tempValues);
            fragmentTempMap.put(rt, (HashMap)fragmentRawMap.get(rt));
            for (ArrayList errors : tempValues.values()) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
                cpt1 += errors.size();
            }
            if (cpt1 <= 202) continue;
            double[] rtArray = precursorTempMap.keySet().stream().mapToDouble(a -> a).toArray();
            double rtRef2 = BasicMathFunctions.medianSorted((double[])rtArray);
            TreeMap mzToErrorMap = new TreeMap();
            block5: for (HashMap errors : precursorTempMap.values()) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
                modificationParameters = errors.keySet().iterator();
                while (modificationParameters.hasNext()) {
                    double mz = (Double)modificationParameters.next();
                    if (waitingHandler != null && waitingHandler.isRunCanceled()) continue block5;
                    ArrayList errorsAtMz = (ArrayList)errors.get(mz);
                    if (!mzToErrorMap.containsKey(mz)) {
                        mzToErrorMap.put(mz, new ArrayList(errorsAtMz.size()));
                    }
                    ((ArrayList)mzToErrorMap.get(mz)).addAll(errorsAtMz);
                }
            }
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                return;
            }
            ArrayList<Double> mz1 = new ArrayList();
            ArrayList<Double> mz2 = new ArrayList<Double>();
            err1 = new ArrayList();
            ArrayList<Double> err2 = new ArrayList<Double>();
            int cpt2 = 0;
            block7: for (Map.Entry entry : mzToErrorMap.entrySet()) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
                Iterator key = ((ArrayList)entry.getValue()).iterator();
                while (key.hasNext()) {
                    double err = (Double)key.next();
                    if (waitingHandler != null && waitingHandler.isRunCanceled()) continue block7;
                    if (cpt2 < cpt1 / 2) {
                        mz1.add((Double)entry.getKey());
                        err1.add(err);
                        ++cpt2;
                        continue;
                    }
                    mz2.add((Double)entry.getKey());
                    err2.add(err);
                }
            }
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                return;
            }
            double x1 = BasicMathFunctions.median((ArrayList)mz1);
            double x2 = BasicMathFunctions.median(mz2);
            double y1 = BasicMathFunctions.median((ArrayList)err1);
            double y2 = BasicMathFunctions.median(err2);
            double slope = x1 == x2 ? 0.0 : (y2 - y1) / (x2 - x1);
            double offset = (y2 + y1 - slope * (x1 + x2)) / 2.0;
            this.precursorSlopes.put(rtRef2, slope);
            this.precursorOffsets.put(rtRef2, offset);
            this.fragmentsRtDeviations.put(rtRef2, new TreeMap());
            mzToErrorMap = new TreeMap();
            block9: for (HashMap errors : fragmentTempMap.values()) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
                Iterator iterator3 = errors.keySet().iterator();
                while (iterator3.hasNext()) {
                    double d = (Double)iterator3.next();
                    if (waitingHandler != null && waitingHandler.isRunCanceled()) continue block9;
                    ArrayList errorsAtMz = (ArrayList)errors.get(d);
                    if (!mzToErrorMap.containsKey(d)) {
                        mzToErrorMap.put(d, new ArrayList(errorsAtMz.size()));
                    }
                    ((ArrayList)mzToErrorMap.get(d)).addAll(errorsAtMz);
                }
            }
            mz1 = new ArrayList<Double>();
            mz2 = new ArrayList();
            err1 = new ArrayList<Double>();
            err2 = new ArrayList();
            double mzRef = -1.0;
            for (Map.Entry entry : mzToErrorMap.entrySet()) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
                mz1.add((Double)entry.getKey());
                err1.addAll((Collection)entry.getValue());
                if (err1.size() < 101) continue;
                mzRef = BasicMathFunctions.median(mz1);
                double error = BasicMathFunctions.median(err1);
                this.fragmentsRtDeviations.get(rtRef2).put(mzRef, error);
                mz2.clear();
                err2.clear();
                mz2.addAll(mz1);
                err2.addAll(err1);
                mz1.clear();
                err1.clear();
            }
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                return;
            }
            if (!mz1.isEmpty()) {
                if (this.fragmentsRtDeviations.get(rtRef2) != null) {
                    this.fragmentsRtDeviations.get(rtRef2).remove(mzRef);
                }
                mz1.addAll(mz2);
                err1.addAll(err2);
                mzRef = BasicMathFunctions.median(mz1);
                double error = BasicMathFunctions.median(err1);
                this.fragmentsRtDeviations.get(rtRef2).put(mzRef, error);
            }
            for (Object tempRt : (Iterator)rtArray) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) continue block3;
                tempValues = (HashMap)precursorTempMap.get((double)tempRt);
                for (ArrayList errors : tempValues.values()) {
                    if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
                    cpt1 -= errors.size();
                }
                precursorTempMap.remove((double)tempRt);
                fragmentTempMap.remove((double)tempRt);
                if (cpt1 <= 202) continue block3;
            }
        }
        if (waitingHandler != null && waitingHandler.isRunCanceled()) {
            return;
        }
        if (this.precursorSlopes.isEmpty()) {
            double rtRef = BasicMathFunctions.median(keys);
            TreeMap mzToErrorMap = new TreeMap();
            block14: for (HashMap errors : precursorRawMap.values()) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
                Iterator rtRef2 = errors.keySet().iterator();
                while (rtRef2.hasNext()) {
                    double mz = (Double)rtRef2.next();
                    if (waitingHandler != null && waitingHandler.isRunCanceled()) continue block14;
                    if (!mzToErrorMap.containsKey(mz)) {
                        mzToErrorMap.put(mz, new ArrayList());
                    }
                    ((ArrayList)mzToErrorMap.get(mz)).addAll((Collection)errors.get(mz));
                }
            }
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                return;
            }
            ArrayList<Double> mz1 = new ArrayList<Double>();
            ArrayList<Double> mz2 = new ArrayList<Double>();
            ArrayList<Double> err12 = new ArrayList<Double>();
            ArrayList<Double> err2 = new ArrayList<Double>();
            int cpt2 = 0;
            block16: for (Map.Entry entry : mzToErrorMap.entrySet()) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
                err1 = ((ArrayList)entry.getValue()).iterator();
                while (err1.hasNext()) {
                    double err = (Double)err1.next();
                    if (waitingHandler != null && waitingHandler.isRunCanceled()) continue block16;
                    if (cpt2 < cpt1 / 2) {
                        mz1.add((Double)entry.getKey());
                        err12.add(err);
                        ++cpt2;
                        continue;
                    }
                    mz2.add((Double)entry.getKey());
                    err2.add(err);
                }
            }
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                return;
            }
            double x1 = BasicMathFunctions.median(mz1);
            double x2 = BasicMathFunctions.median(mz2);
            double y1 = BasicMathFunctions.median(err12);
            double y2 = BasicMathFunctions.median(err2);
            double slope = x1 == x2 ? 0.0 : (y2 - y1) / (x2 - x1);
            double offset = (y2 + y1 - slope * (x1 + x2)) / 2.0;
            this.precursorSlopes.put(rtRef, slope);
            this.precursorOffsets.put(rtRef, offset);
            Iterator<Object> roundedValue = keys.iterator();
            while (roundedValue.hasNext()) {
                double tempRt = (Double)roundedValue.next();
                if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
                HashMap tempValues = (HashMap)precursorTempMap.get(tempRt);
                for (ArrayList errors : tempValues.values()) {
                    if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
                    cpt1 -= errors.size();
                }
                precursorTempMap.remove(tempRt);
                if (cpt1 > 202) continue;
                break;
            }
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                return;
            }
            mzToErrorMap = new TreeMap();
            block20: for (HashMap errors : precursorTempMap.values()) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
                Iterator iterator4 = errors.keySet().iterator();
                while (iterator4.hasNext()) {
                    double mz = (Double)iterator4.next();
                    if (waitingHandler != null && waitingHandler.isRunCanceled()) continue block20;
                    if (!mzToErrorMap.containsKey(mz)) {
                        mzToErrorMap.put(mz, new ArrayList());
                    }
                    ((ArrayList)mzToErrorMap.get(mz)).addAll((Collection)errors.get(mz));
                }
            }
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                return;
            }
            this.fragmentsRtDeviations.put(rtRef, new TreeMap());
            mz1 = new ArrayList();
            mz2 = new ArrayList();
            err12 = new ArrayList();
            err2 = new ArrayList();
            for (Map.Entry entry : mzToErrorMap.entrySet()) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
                mz1.add((Double)entry.getKey());
                err12.addAll((Collection)entry.getValue());
                if (err12.size() < 101) continue;
                double mzRef = BasicMathFunctions.median(mz1);
                double error = BasicMathFunctions.median(err12);
                this.fragmentsRtDeviations.get(rtRef).put(mzRef, error);
                mz2.addAll(mz1);
                err2.addAll(err12);
                mz1.clear();
                err12.clear();
            }
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                return;
            }
            if (!mz1.isEmpty()) {
                TreeMap<Double, Double> rtDeviationAtRtRef = this.fragmentsRtDeviations.get(rtRef);
                mz1.addAll(mz2);
                err12.addAll(err2);
                double mzRef = BasicMathFunctions.median(mz1);
                double error = BasicMathFunctions.median(err12);
                rtDeviationAtRtRef.put(mzRef, error);
            }
        }
        if (waitingHandler != null && waitingHandler.isRunCanceled()) {
            return;
        }
        this.precursorRTList = new ArrayList<Double>(this.precursorSlopes.keySet());
        Collections.sort(this.precursorRTList);
    }
}

