/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.stirred;

import com.compomics.software.log.CliLogger;
import com.compomics.util.Util;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationProvider;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.protein_inference.FastaMapper;
import com.compomics.util.experiment.identification.protein_inference.fm_index.FMIndex;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.io.identification.writers.SimpleMzIdentMLExporter;
import com.compomics.util.experiment.io.mass_spectrometry.MsFileHandler;
import com.compomics.util.experiment.io.temp.TempFilesManager;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.compression.ZipUtils;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.waiting.Duration;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.fileimport.PsmImporter;
import eu.isas.peptideshaker.stirred.modules.IdImporter;
import eu.isas.peptideshaker.stirred.modules.StirRunnable;
import eu.isas.peptideshaker.utils.PsZipUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Stirred {
    public final String SOFTWARE_NAME = "PeptideShaker";
    public final String SOFTWARE_VERSION = PeptideShaker.getVersion();
    public final String SOFTWARE_URL = "https://compomics.github.io/projects/peptide-shaker.html";
    private final ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private final File inputFile;
    private final File spectrumFile;
    private final File fastaFile;
    private final File ouputFolder;
    private final File identificationParametersFile;
    private final File tempFolder;
    private final CliLogger cliLogger;
    private final int nThreads;
    private final int timeOutDays;
    private final String contactFirstName;
    private final String contactLastName;
    private final String contactAddress;
    private final String contactEmail;
    private final String contactOrganizationName;
    private final String contactOrganizationAddress;
    private final String contactOrganizationEmail;
    private final Duration totalDuration = new Duration();

    public Stirred(File inputFile, File spectrumFile, File fastaFile, File ouputFolder, File identificationParametersFile, File tempFolder, CliLogger cliLogger, int nThreads, int timeOutDays, String contactFirstName, String contactLastName, String contactAddress, String contactEmail, String contactOrganizationName, String contactOrganizationAddress, String contactOrganizationEmail) {
        this.inputFile = inputFile;
        this.spectrumFile = spectrumFile;
        this.fastaFile = fastaFile;
        this.ouputFolder = ouputFolder;
        this.identificationParametersFile = identificationParametersFile;
        this.tempFolder = tempFolder;
        this.cliLogger = cliLogger;
        this.nThreads = nThreads;
        this.timeOutDays = timeOutDays;
        this.contactFirstName = contactFirstName;
        this.contactLastName = contactLastName;
        this.contactAddress = contactAddress;
        this.contactEmail = contactEmail;
        this.contactOrganizationName = contactOrganizationName;
        this.contactOrganizationAddress = contactOrganizationAddress;
        this.contactOrganizationEmail = contactOrganizationEmail;
    }

    public void run() throws InterruptedException, TimeoutException, IOException {
        this.cliLogger.logMessage("Stirred process start");
        this.totalDuration.start();
        WaitingHandlerCLIImpl waitingHandler = new WaitingHandlerCLIImpl();
        String inputFileName = this.inputFile.getName();
        if (inputFileName.toLowerCase().endsWith(".zip")) {
            File dataFolder;
            File unzipFolder = new File(this.tempFolder, PsZipUtils.getUnzipSubFolder());
            unzipFolder.mkdir();
            TempFilesManager.registerTempFolder((File)unzipFolder);
            ZipUtils.unzip((File)this.inputFile, (File)unzipFolder, (WaitingHandler)waitingHandler);
            File dataFasta = this.fastaFile;
            File dataIdentificationParametersFile = this.identificationParametersFile;
            ArrayList<File> spectrumFiles = new ArrayList<File>();
            ArrayList<File> searchEngineResultsFiles = new ArrayList<File>();
            if (this.spectrumFile != null) {
                spectrumFiles.add(this.spectrumFile);
            }
            ArrayList files = Arrays.stream(unzipFolder.listFiles()).collect(Collectors.toCollection(ArrayList::new));
            File sguiInputFile = new File(unzipFolder, "searchGUI_input.txt");
            if (sguiInputFile.exists()) {
                Object line;
                SimpleFileReader reader = SimpleFileReader.getFileReader((File)sguiInputFile);
                while ((line = reader.readLine()) != null) {
                    if (((String)line).charAt(0) == '#') continue;
                    files.add(new File((String)line));
                }
            }
            if ((dataFolder = new File(unzipFolder, PeptideShaker.DATA_DIRECTORY)).exists() && dataFolder.isDirectory()) {
                files.addAll(Arrays.stream(dataFolder.listFiles()).collect(Collectors.toCollection(ArrayList::new)));
            }
            for (File file : files) {
                String fileNameLowerCase = file.getName().toLowerCase();
                if (this.fastaFile == null && fileNameLowerCase.endsWith(".fasta")) {
                    if (dataFasta != null) {
                        throw new IllegalArgumentException("More than one fasta file provided in the data folder, please specify the file to use via the command line option.");
                    }
                    dataFasta = file;
                }
                if (this.identificationParametersFile == null && fileNameLowerCase.endsWith(".par")) {
                    if (dataIdentificationParametersFile != null) {
                        throw new IllegalArgumentException("More than one identification parameters file provided in the data folder, please specify the file to use via the command line option.");
                    }
                    dataIdentificationParametersFile = file;
                }
                if (this.spectrumFile == null && (fileNameLowerCase.endsWith(".mzml") || fileNameLowerCase.endsWith(".mgf"))) {
                    spectrumFiles.add(file);
                }
                if (!fileNameLowerCase.endsWith(".omx") && !fileNameLowerCase.endsWith(".t.xml") && !fileNameLowerCase.endsWith(".pep.xml") && !fileNameLowerCase.endsWith(".dat") && !fileNameLowerCase.endsWith(".mzid") && !fileNameLowerCase.endsWith(".ms-amanda.csv") && !fileNameLowerCase.endsWith(".res") && !fileNameLowerCase.endsWith(".tide-search.target.txt") && !fileNameLowerCase.endsWith(".coss.tsv") && !fileNameLowerCase.endsWith(".sage.tsv") && !fileNameLowerCase.endsWith(".psm") && !fileNameLowerCase.endsWith(".omx.gz") && !fileNameLowerCase.endsWith(".t.xml.gz") && !fileNameLowerCase.endsWith(".pep.xml.gz") && !fileNameLowerCase.endsWith(".mzid.gz") && !fileNameLowerCase.endsWith(".ms-amanda.csv.gz") && !fileNameLowerCase.endsWith(".res.gz") && !fileNameLowerCase.endsWith(".tide-search.target.txt.gz") && !fileNameLowerCase.endsWith(".sage.tsv.gz") && !fileNameLowerCase.endsWith(".psm.gz")) continue;
                searchEngineResultsFiles.add(file);
            }
            if (searchEngineResultsFiles.isEmpty()) {
                throw new FileNotFoundException("No identification results found in " + this.inputFile + ".");
            }
            if (spectrumFiles.isEmpty()) {
                throw new FileNotFoundException("No spectrum file found in " + this.inputFile + ".");
            }
            if (dataFasta == null) {
                throw new FileNotFoundException("No fasta file found in " + this.inputFile + ".");
            }
            if (dataIdentificationParametersFile == null) {
                throw new FileNotFoundException("No identification parameters file found in " + this.inputFile + ".");
            }
            this.cliLogger.logMessage("    Importing identification parameters file from " + dataIdentificationParametersFile);
            IdentificationParameters identificationParameters = IdentificationParameters.getIdentificationParameters((File)dataIdentificationParametersFile);
            this.cliLogger.logMessage("    Importing protein sequences from " + dataFasta);
            FMIndex fmIndex = new FMIndex(dataFasta, identificationParameters.getFastaParameters(), (WaitingHandler)waitingHandler, true, identificationParameters.getPeptideVariantsParameters(), identificationParameters.getSearchParameters());
            FastaSummary fastaSummary = FastaSummary.getSummary((String)dataFasta.getAbsolutePath(), (FastaParameters)identificationParameters.getFastaParameters(), (WaitingHandler)waitingHandler);
            MsFileHandler msFileHandler = new MsFileHandler();
            for (File spectrumFile : spectrumFiles) {
                this.cliLogger.logMessage("    Importing spectra from " + spectrumFile);
                msFileHandler.register(spectrumFile, this.tempFolder, (WaitingHandler)waitingHandler);
            }
            File finalFasta = dataFasta;
            ((Stream)searchEngineResultsFiles.stream().parallel()).forEach(arg_0 -> this.lambda$run$0(finalFasta, fmIndex, fastaSummary, msFileHandler, identificationParameters, (WaitingHandler)waitingHandler, arg_0));
        } else {
            if (this.spectrumFile == null || !this.spectrumFile.exists()) {
                throw new FileNotFoundException("Spectrum file '" + this.spectrumFile + "' not found.");
            }
            if (this.fastaFile == null || !this.fastaFile.exists()) {
                throw new FileNotFoundException("Fasta file '" + this.fastaFile + "' not found.");
            }
            if (this.identificationParametersFile == null || !this.identificationParametersFile.exists()) {
                throw new FileNotFoundException("Fasta file '" + this.identificationParametersFile + "' not found.");
            }
            this.cliLogger.logMessage("    Importing identification parameters file from " + this.identificationParametersFile);
            IdentificationParameters identificationParameters = IdentificationParameters.getIdentificationParameters((File)this.identificationParametersFile);
            this.cliLogger.logMessage("    Importing protein sequences from " + this.fastaFile);
            FMIndex fmIndex = new FMIndex(this.fastaFile, identificationParameters.getFastaParameters(), (WaitingHandler)waitingHandler, true, identificationParameters.getPeptideVariantsParameters(), identificationParameters.getSearchParameters());
            FastaSummary fastaSummary = FastaSummary.getSummary((String)this.fastaFile.getAbsolutePath(), (FastaParameters)identificationParameters.getFastaParameters(), (WaitingHandler)waitingHandler);
            this.cliLogger.logMessage("    Importing spectra from " + this.spectrumFile);
            MsFileHandler msFileHandler = new MsFileHandler();
            msFileHandler.register(this.spectrumFile, this.tempFolder, (WaitingHandler)waitingHandler);
            File outputFile = new File(this.ouputFolder, IoUtil.removeExtension((String)inputFileName) + ".stirred.mzid.gz");
            this.process(this.inputFile, this.fastaFile, outputFile, fmIndex, fastaSummary, msFileHandler, identificationParameters, (WaitingHandler)waitingHandler);
        }
        this.totalDuration.end();
        this.cliLogger.logMessage("Stirred process completed (" + this.totalDuration.toString() + ")");
    }

    public void process(File searchEngineResultsFile, File fastaFile, File ouputFile, FMIndex fmIndex, FastaSummary fastaSummary, MsFileHandler msFileHandler, IdentificationParameters identificationParameters, WaitingHandler waitingHandler) throws InterruptedException, TimeoutException, IOException {
        String idFileName = searchEngineResultsFile.getName();
        this.cliLogger.logMessage("Starting stirred process of " + idFileName);
        this.cliLogger.logMessage(idFileName + ": Parsing identification results");
        IdImporter idImporter = new IdImporter(searchEngineResultsFile, this.cliLogger);
        ArrayList<SpectrumMatch> spectrumMatches = idImporter.loadSpectrumMatches(identificationParameters, (SpectrumProvider)msFileHandler, waitingHandler);
        HashMap softwareVersions = idImporter.getIdFileReader().getSoftwareVersions();
        TreeSet<String> fileNames = new TreeSet<String>();
        HashSet advocates = new HashSet();
        for (SpectrumMatch spectrumMatch : spectrumMatches) {
            fileNames.add(spectrumMatch.getSpectrumFile());
            advocates.addAll(spectrumMatch.getAdvocates());
        }
        ArrayList<File> spectrumFiles = new ArrayList<File>(fileNames.size());
        for (String fileName : fileNames) {
            String filePath = (String)msFileHandler.getFilePaths().get(fileName);
            if (filePath == null) {
                throw new FileNotFoundException("Spectrum file " + fileName + " used to create " + searchEngineResultsFile + " not found.");
            }
            spectrumFiles.add(new File(filePath));
        }
        if (advocates.contains(Advocate.xtandem.getIndex())) {
            PsmImporter.verifyXTandemModifications(identificationParameters);
        }
        this.cliLogger.logMessage(idFileName + ": Processing peptides from " + spectrumMatches.size() + " spectra");
        try (SimpleMzIdentMLExporter simpleMzIdentMLExporter = new SimpleMzIdentMLExporter("PeptideShaker", this.SOFTWARE_VERSION, "https://compomics.github.io/projects/peptide-shaker.html", this.tempFolder, ouputFile, spectrumFiles, searchEngineResultsFile, softwareVersions, fastaFile, identificationParameters, (SequenceProvider)fmIndex, (ProteinDetailsProvider)fmIndex, (SpectrumProvider)msFileHandler, (ModificationProvider)this.modificationFactory, fastaSummary, this.contactFirstName, this.contactLastName, this.contactAddress, this.contactEmail, this.contactOrganizationName, this.contactOrganizationAddress, this.contactOrganizationEmail, false);){
            ConcurrentLinkedQueue<SpectrumMatch> spectrumMatchesQueue = new ConcurrentLinkedQueue<SpectrumMatch>(spectrumMatches);
            ExecutorService pool = Executors.newFixedThreadPool(this.nThreads);
            ArrayList<StirRunnable> runnables = new ArrayList<StirRunnable>(this.nThreads);
            for (int i = 0; i < this.nThreads; ++i) {
                StirRunnable runnable = new StirRunnable(spectrumMatchesQueue, idImporter.getIdFileReader(), simpleMzIdentMLExporter, identificationParameters, (FastaMapper)fmIndex, (SequenceProvider)fmIndex, (SpectrumProvider)msFileHandler, this.cliLogger);
                runnables.add(runnable);
                pool.submit(runnable);
            }
            pool.shutdown();
            if (!pool.awaitTermination(this.timeOutDays, TimeUnit.DAYS)) {
                throw new TimeoutException("Analysis timed out (time out: " + this.timeOutDays + " days)");
            }
            int nPeptides = runnables.stream().mapToInt(StirRunnable::getnPeptides).sum();
            int nModificationIssues = runnables.stream().mapToInt(StirRunnable::getnModificationIssues).sum();
            double percentModificationIssues = Util.roundDouble((double)(100.0 * (double)nModificationIssues / (double)nPeptides), (int)1);
            this.cliLogger.logMessage(idFileName + ": " + nPeptides + " peptides processed.");
            if (nModificationIssues > 0) {
                this.cliLogger.logMessage(idFileName + ": " + nModificationIssues + " peptides (" + percentModificationIssues + "%) excluded due to unrecognized modification.");
            }
        }
        this.cliLogger.logMessage(idFileName + ": completed.");
    }

    private /* synthetic */ void lambda$run$0(File finalFasta, FMIndex fmIndex, FastaSummary fastaSummary, MsFileHandler msFileHandler, IdentificationParameters identificationParameters, WaitingHandler waitingHandler, File searchEngineResultsFile) {
        try {
            File outputFile = new File(this.ouputFolder, IoUtil.removeExtension((String)searchEngineResultsFile.getName()) + ".stirred.mzid.gz");
            this.process(searchEngineResultsFile, finalFasta, outputFile, fmIndex, fastaSummary, msFileHandler, identificationParameters, waitingHandler);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

