/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.stirred.modules;

import com.compomics.software.log.CliLogger;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationProvider;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.modification.scores.PhosphoRS;
import com.compomics.util.experiment.identification.modification.search_engine_mapping.ModificationLocalizationMapper;
import com.compomics.util.experiment.identification.modification.search_engine_mapping.ModificationNameMapper;
import com.compomics.util.experiment.identification.protein_inference.FastaMapper;
import com.compomics.util.experiment.identification.protein_inference.PeptideProteinMapping;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.io.identification.writers.SimpleMzIdentMLExporter;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.ModificationLocalizationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class StirRunnable
implements Runnable {
    private final ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private final IdfileReader idfileReader;
    private final ConcurrentLinkedQueue<SpectrumMatch> spectrumMatches;
    private final SimpleMzIdentMLExporter writer;
    private final IdentificationParameters identificationParameters;
    private final FastaMapper fastaMapper;
    private final SequenceProvider sequenceProvider;
    private final SpectrumProvider spectrumProvider;
    private final PeptideSpectrumAnnotator peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();
    private final CliLogger cliLogger;
    private int nModificationIssues = 0;
    private int nPeptides = 0;

    public StirRunnable(ConcurrentLinkedQueue<SpectrumMatch> spectrumMatches, IdfileReader idfileReader, SimpleMzIdentMLExporter writer, IdentificationParameters identificationParameters, FastaMapper fastaMapper, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, CliLogger cliLogger) {
        this.spectrumMatches = spectrumMatches;
        this.idfileReader = idfileReader;
        this.writer = writer;
        this.identificationParameters = identificationParameters;
        this.fastaMapper = fastaMapper;
        this.sequenceProvider = sequenceProvider;
        this.spectrumProvider = spectrumProvider;
        this.cliLogger = cliLogger;
    }

    @Override
    public void run() {
        try {
            SpectrumMatch spectrumMatch;
            while ((spectrumMatch = this.spectrumMatches.poll()) != null) {
                this.processSpectrumMatch(spectrumMatch);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.cliLogger.logError("An error occurred while processing the spectrum matches.");
            this.cliLogger.logError(t.getLocalizedMessage());
        }
    }

    private void processSpectrumMatch(SpectrumMatch spectrumMatch) {
        ArrayList<PeptideAssumption> peptideAssumptions = new ArrayList<PeptideAssumption>();
        ArrayList<TreeMap<Double, HashMap<Integer, Double>>> modificationScores = new ArrayList<TreeMap<Double, HashMap<Integer, Double>>>();
        for (TreeMap advocateMap : spectrumMatch.getPeptideAssumptionsMap().values()) {
            for (ArrayList assumptionsAtScore : advocateMap.values()) {
                for (PeptideAssumption peptideAssumption : assumptionsAtScore) {
                    TreeMap<Double, HashMap<Integer, Double>> peptideModificationScores = this.processPeptideAssumption(spectrumMatch, peptideAssumption);
                    if (peptideModificationScores != null) {
                        peptideAssumptions.add(peptideAssumption);
                        modificationScores.add(peptideModificationScores);
                    } else {
                        ++this.nModificationIssues;
                    }
                    ++this.nPeptides;
                }
            }
        }
        this.writer.addSpectrum(spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle(), peptideAssumptions, modificationScores, this.peptideSpectrumAnnotator);
    }

    private TreeMap<Double, HashMap<Integer, Double>> processPeptideAssumption(SpectrumMatch spectrumMatch, PeptideAssumption peptideAssumption) {
        Peptide peptide = peptideAssumption.getPeptide();
        this.proteinMapping(peptide);
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        ModificationParameters modificationParameters = searchParameters.getModificationParameters();
        SequenceMatchingParameters modificationSequenceMatchingParameters = this.identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
        ModificationMatch[] modificationMatches = peptide.getVariableModifications();
        HashMap expectedNames = new HashMap(modificationMatches.length);
        HashMap modNames = new HashMap(modificationMatches.length);
        for (ModificationMatch modMatch : modificationMatches) {
            HashMap tempNames = ModificationNameMapper.getPossibleModificationNames((Peptide)peptide, (ModificationMatch)modMatch, (IdfileReader)this.idfileReader, (SearchParameters)searchParameters, (SequenceMatchingParameters)modificationSequenceMatchingParameters, (SequenceProvider)this.sequenceProvider, (ModificationProvider)this.modificationFactory);
            HashSet allNames = tempNames.values().stream().flatMap(nameList -> nameList.stream()).collect(Collectors.toCollection(HashSet::new));
            modNames.put(modMatch, new ArrayList(allNames));
            Iterator iterator = tempNames.keySet().iterator();
            while (iterator.hasNext()) {
                int pos = (Integer)iterator.next();
                ArrayList<String> namesAtPosition = (ArrayList<String>)expectedNames.get(pos);
                if (namesAtPosition == null) {
                    namesAtPosition = new ArrayList<String>(2);
                    expectedNames.put(pos, namesAtPosition);
                }
                for (String modName : (HashSet)tempNames.get(pos)) {
                    if (namesAtPosition.contains(modName)) continue;
                    namesAtPosition.add(modName);
                }
            }
            modMatch.setConfident(true);
        }
        if (peptide.getVariableModifications().length > 0) {
            ModificationLocalizationMapper.modificationLocalization((Peptide)peptide, (IdentificationParameters)this.identificationParameters, (IdfileReader)this.idfileReader, (ModificationProvider)this.modificationFactory, (SequenceProvider)this.sequenceProvider);
        }
        boolean modsOK = true;
        for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
            String modName = modificationMatch.getModification();
            if (modName == null) {
                modsOK = false;
            }
            if (this.modificationFactory.getModification(modName) != null) continue;
            modsOK = false;
        }
        if (!modsOK) {
            return null;
        }
        peptide.setKey(Peptide.getKey((String)peptide.getSequence(), (ModificationMatch[])peptide.getVariableModifications()));
        peptide.getMass(modificationParameters, this.sequenceProvider, modificationSequenceMatchingParameters);
        TreeMap<Double, HashMap<Integer, Double>> modificationLocalizationScores = this.scoreModificationLocalization(spectrumMatch, peptideAssumption);
        return modificationLocalizationScores;
    }

    private void proteinMapping(Peptide peptide) {
        TreeMap<String, int[]> proteinIndexes;
        SequenceMatchingParameters sequenceMatchingPreferences = this.identificationParameters.getSequenceMatchingParameters();
        ArrayList peptideProteinMappings = this.fastaMapper.getProteinMapping(peptide.getSequence(), sequenceMatchingPreferences);
        HashMap sequenceIndexes = PeptideProteinMapping.getPeptideProteinIndexesMap((ArrayList)peptideProteinMappings);
        if (sequenceIndexes.size() == 1) {
            proteinIndexes = new TreeMap((Map)sequenceIndexes.values().stream().findAny().get());
        } else {
            proteinIndexes = new TreeMap<String, int[]>();
            for (HashMap tempIndexes : sequenceIndexes.values()) {
                for (Map.Entry entry : tempIndexes.entrySet()) {
                    String accession = (String)entry.getKey();
                    int[] newIndexes = (int[])entry.getValue();
                    int[] currentIndexes = (int[])proteinIndexes.get(accession);
                    if (currentIndexes == null) {
                        proteinIndexes.put(accession, newIndexes);
                        continue;
                    }
                    int[] mergedIndexes = IntStream.concat(Arrays.stream(currentIndexes), Arrays.stream(newIndexes)).distinct().sorted().toArray();
                    proteinIndexes.put(accession, mergedIndexes);
                }
            }
        }
        peptide.setProteinMapping(proteinIndexes);
        HashMap variantMatches = PeptideProteinMapping.getVariantMatches((ArrayList)peptideProteinMappings);
        peptide.setVariantMatches(variantMatches);
    }

    private TreeMap<Double, HashMap<Integer, Double>> scoreModificationLocalization(SpectrumMatch spectrumMatch, PeptideAssumption peptideAssumption) {
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        AnnotationParameters annotationParameters = this.identificationParameters.getAnnotationParameters();
        SequenceMatchingParameters sequenceMatchingParameters = this.identificationParameters.getSequenceMatchingParameters();
        ModificationParameters modificationParameters = this.identificationParameters.getSearchParameters().getModificationParameters();
        ModificationLocalizationParameters modificationLocalizationParameters = this.identificationParameters.getModificationLocalizationParameters();
        SequenceMatchingParameters modificationSequenceMatchingParameters = modificationLocalizationParameters.getSequenceMatchingParameters();
        Peptide peptide = peptideAssumption.getPeptide();
        String spectrumFile = spectrumMatch.getSpectrumFile();
        String spectrumTitle = spectrumMatch.getSpectrumTitle();
        Spectrum spectrum = this.spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
        HashMap<Double, ArrayList> modificationsMap = new HashMap<Double, ArrayList>(1);
        for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
            Modification refMod = this.modificationFactory.getModification(modificationMatch.getModification());
            double modMass = refMod.getMass();
            if (modificationsMap.containsKey(modMass)) continue;
            ArrayList modifications = this.modificationFactory.getSameMassNotFixedModifications(modMass, searchParameters).stream().map(modification -> this.modificationFactory.getModification(modification)).collect(Collectors.toCollection(ArrayList::new));
            modificationsMap.put(modMass, modifications);
        }
        SpecificAnnotationParameters specificAnnotationParameters = annotationParameters.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, (SpectrumIdentificationAssumption)peptideAssumption, modificationParameters, this.sequenceProvider, modificationSequenceMatchingParameters, (SpectrumAnnotator)this.peptideSpectrumAnnotator);
        return modificationsMap.entrySet().stream().collect(Collectors.toMap(entry -> (Double)entry.getKey(), entry -> PhosphoRS.getSequenceProbabilities((Peptide)peptide, (ArrayList)((ArrayList)entry.getValue()), (ModificationParameters)modificationParameters, (Spectrum)spectrum, (SequenceProvider)this.sequenceProvider, (AnnotationParameters)annotationParameters, (SpecificAnnotationParameters)specificAnnotationParameters, (boolean)modificationLocalizationParameters.isProbabilisticScoreNeutralLosses(), (SequenceMatchingParameters)sequenceMatchingParameters, (SequenceMatchingParameters)modificationSequenceMatchingParameters, (PeptideSpectrumAnnotator)this.peptideSpectrumAnnotator, (ModificationProvider)this.modificationFactory), (a, b) -> a, TreeMap::new));
    }

    public int getnModificationIssues() {
        return this.nModificationIssues;
    }

    public int getnPeptides() {
        return this.nPeptides;
    }
}

