/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.utils;

import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.pride.CvTerm;

public class DeepLcUtils {
    public static String getPeptideData(PeptideAssumption peptideAssumption, double retentionTime, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters, ModificationFactory modificationFactory) {
        return String.join((CharSequence)",", peptideAssumption.getPeptide().getSequence(), DeepLcUtils.getModifications(peptideAssumption.getPeptide(), modificationParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory), Double.toString(retentionTime));
    }

    public static String getModifications(Peptide peptide, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters, ModificationFactory modificationFactory) {
        String peptideSequence = peptide.getSequence();
        String[] fixedModifications = peptide.getFixedModifications(modificationParameters, sequenceProvider, sequenceMatchingParameters);
        StringBuilder modificationSites = new StringBuilder();
        for (int i = 0; i < fixedModifications.length; ++i) {
            if (fixedModifications[i] == null) continue;
            int site = i < peptideSequence.length() + 1 ? i : -1;
            String modName = fixedModifications[i];
            Modification modification = modificationFactory.getModification(modName);
            CvTerm cvTerm = modification.getUnimodCvTerm();
            if (cvTerm == null) {
                throw new IllegalArgumentException("No Unimod id found for modification " + modName + ".");
            }
            String unimodName = cvTerm.getName();
            if (modificationSites.length() > 0) {
                modificationSites.append('|');
            }
            modificationSites.append(site).append('|').append(unimodName);
        }
        String[] variableModifications = peptide.getIndexedVariableModifications();
        for (int i = 0; i < variableModifications.length; ++i) {
            if (variableModifications[i] == null) continue;
            int site = i < peptideSequence.length() + 1 ? i : -1;
            String modName = variableModifications[i];
            Modification modification = modificationFactory.getModification(modName);
            CvTerm cvTerm = modification.getUnimodCvTerm();
            if (cvTerm == null) {
                throw new IllegalArgumentException("No Unimod id found for modification " + modName + ".");
            }
            String unimodName = cvTerm.getName();
            if (modificationSites.length() > 0) {
                modificationSites.append('|');
            }
            modificationSites.append(site).append('|').append(unimodName);
        }
        return modificationSites.toString();
    }

    public static long getPeptideKey(String peptideData) {
        return ExperimentObject.asLong((String)peptideData);
    }
}

