/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.utils;

import com.compomics.util.db.object.ObjectsDB;
import com.compomics.util.experiment.ProjectParameters;
import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.IdentificationKeys;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesCache;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.peptide_shaker.Metrics;
import com.compomics.util.experiment.identification.protein_inference.fm_index.FMIndex;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.io.mass_spectrometry.MsFileHandler;
import com.compomics.util.experiment.io.mass_spectrometry.cms.CmsFolder;
import com.compomics.util.experiment.io.temp.TempFilesManager;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.experiment.quantification.spectrumcounting.SpectrumCountingMethod;
import com.compomics.util.gui.filtering.FilterParameters;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.compression.ZipUtils;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.peptide_shaker.ProjectType;
import com.compomics.util.parameters.quantification.spectrum_counting.SpectrumCountingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.export.PsdbExporter;
import eu.isas.peptideshaker.parameters.PeptideShakerParameters;
import eu.isas.peptideshaker.preferences.DisplayParameters;
import eu.isas.peptideshaker.preferences.ProjectDetails;
import eu.isas.peptideshaker.preferences.UserParameters;
import eu.isas.peptideshaker.preferences.UserPreferencesParent;
import eu.isas.peptideshaker.scoring.PSMaps;
import eu.isas.peptideshaker.utils.PsZipUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;

public class PsdbParent
extends UserPreferencesParent
implements AutoCloseable {
    protected Identification identification;
    protected IdentificationFeaturesGenerator identificationFeaturesGenerator;
    protected IdentificationParameters identificationParameters;
    protected SpectrumCountingParameters spectrumCountingParameters;
    protected ProjectDetails projectDetails;
    protected Metrics metrics;
    protected SequenceProvider sequenceProvider;
    protected ProteinDetailsProvider proteinDetailsProvider;
    protected MsFileHandler msFileHandler;
    protected GeneMaps geneMaps;
    protected FilterParameters filterParameters = new FilterParameters();
    protected DisplayParameters displayParameters = new DisplayParameters();
    protected File dbFolder;
    protected File psdbFile = null;
    public ProjectParameters projectParameters;
    protected ProjectType projectType;
    private boolean importFromZip = false;

    public PsdbParent() {
    }

    public PsdbParent(File dbFolder) {
        this.dbFolder = dbFolder;
    }

    public void loadPsdbFromZipFile(File zipFile, File dbFolder, WaitingHandler waitingHandler) throws IOException {
        String newName = PsZipUtils.getTempFolderName(zipFile.getName());
        String parentFolder = PsZipUtils.getUnzipParentFolder();
        if (parentFolder == null) {
            parentFolder = zipFile.getParent();
        }
        File parentFolderFile = new File(parentFolder, PsZipUtils.getUnzipSubFolder());
        File destinationFolder = new File(parentFolderFile, newName);
        destinationFolder.mkdir();
        TempFilesManager.registerTempFolder((File)parentFolderFile);
        waitingHandler.setWaitingText("Unzipping " + zipFile.getName() + ". Please Wait...");
        ZipUtils.unzip((File)zipFile, (File)destinationFolder, (WaitingHandler)waitingHandler);
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        if (!waitingHandler.isRunCanceled()) {
            for (File file : destinationFolder.listFiles()) {
                if (!file.getName().toLowerCase().endsWith(".psdb")) continue;
                this.psdbFile = file;
                this.loadPsdbFile(dbFolder, waitingHandler, true);
                return;
            }
        }
    }

    public void loadPsdbFile(File dbFolder, WaitingHandler waitingHandler, boolean openFromZip) throws IOException {
        if (this.identification != null) {
            this.identification.close(false);
        }
        if (!dbFolder.exists() && !dbFolder.mkdirs()) {
            throw new IOException("Impossible to create folder " + dbFolder.getAbsolutePath() + ".");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
        String dbName = "tempDB-" + df.format(new Date()) + ".psdb";
        File destinationFile = new File(dbFolder.getAbsolutePath(), dbName);
        IoUtil.copyFile((File)this.psdbFile, (File)destinationFile);
        ObjectsDB objectsDB = new ObjectsDB(dbFolder.getAbsolutePath(), destinationFile.getName(), false);
        PeptideShakerParameters psParameters = (PeptideShakerParameters)((Object)objectsDB.retrieveObject(PeptideShakerParameters.KEY));
        this.identificationParameters = psParameters.getIdentificationParameters();
        this.spectrumCountingParameters = psParameters.getSpectrumCountingPreferences();
        this.projectDetails = psParameters.getProjectDetails();
        this.metrics = psParameters.getMetrics();
        this.geneMaps = psParameters.getGeneMaps();
        this.filterParameters = psParameters.getFilterParameters();
        this.displayParameters = psParameters.getDisplayParameters();
        this.sequenceProvider = psParameters.getSequenceProvider();
        this.proteinDetailsProvider = psParameters.getProteinDetailsProvider();
        this.projectType = psParameters.getProjectType();
        FMIndex fmIndex = null;
        if (openFromZip) {
            File fmPath = new File(Paths.get(this.psdbFile.getParentFile().getAbsolutePath(), "data").toString());
            for (File file : fmPath.listFiles()) {
                if (!file.getAbsoluteFile().toString().toLowerCase().endsWith(".fasta")) continue;
                fmIndex = new FMIndex(file, psParameters.getIdentificationParameters().getFastaParameters(), waitingHandler, true, psParameters.getIdentificationParameters().getPeptideVariantsParameters(), psParameters.getIdentificationParameters().getSearchParameters());
                break;
            }
        } else {
            boolean fastaFileFound = false;
            try {
                FastaSummary fastaSummary = this.loadFastaFile(waitingHandler);
                if (fastaSummary != null) {
                    fastaFileFound = true;
                }
            }
            catch (IOException e) {
                fastaFileFound = false;
            }
            if (fastaFileFound) {
                File fastaFile = new File(psParameters.getProjectDetails().getFastaFile());
                fmIndex = new FMIndex(fastaFile, psParameters.getIdentificationParameters().getFastaParameters(), waitingHandler, true, psParameters.getIdentificationParameters().getPeptideVariantsParameters(), psParameters.getIdentificationParameters().getSearchParameters());
            } else {
                throw new IOException("FASTA file not found " + psParameters.getProjectDetails().getFastaFile() + ".");
            }
        }
        psParameters.setSequenceProvider((SequenceProvider)fmIndex);
        psParameters.setProteinDetailsProvider((ProteinDetailsProvider)fmIndex);
        this.sequenceProvider = fmIndex;
        this.proteinDetailsProvider = fmIndex;
        objectsDB.updateObject(PeptideShakerParameters.KEY, (Object)psParameters);
        this.projectParameters = (ProjectParameters)objectsDB.retrieveObject(ProjectParameters.key);
        this.identification = new Identification(objectsDB);
        IdentificationKeys identificationKeys = (IdentificationKeys)objectsDB.retrieveObject(IdentificationKeys.KEY);
        this.identification.setIdentificationKeys(identificationKeys);
        PSMaps psMaps = new PSMaps();
        psMaps = (PSMaps)((Object)objectsDB.retrieveObject(psMaps.getParameterKey()));
        this.identification.addUrParam((UrParameter)psMaps);
        this.msFileHandler = new MsFileHandler();
        this.identificationFeaturesGenerator = new IdentificationFeaturesGenerator(this.identification, this.identificationParameters, this.sequenceProvider, (SpectrumProvider)this.msFileHandler, this.metrics, this.spectrumCountingParameters);
        IdentificationFeaturesCache identificationFeaturesCache = psParameters.getIdentificationFeaturesCache();
        if (identificationFeaturesCache != null) {
            this.identificationFeaturesGenerator.setIdentificationFeaturesCache(psParameters.getIdentificationFeaturesCache());
            identificationFeaturesCache.setReadOnly(false);
        }
        if (waitingHandler != null && waitingHandler.isRunCanceled()) {
            waitingHandler.setRunFinished();
            return;
        }
        this.loadUserParameters();
        this.userPreferences.addRecentProject(this.psdbFile);
        this.saveUserParameters();
    }

    public void saveProject(WaitingHandler waitingHandler, boolean emptyCache) throws IOException {
        PsdbExporter.saveAs(this.psdbFile, waitingHandler, this.identification, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumCountingParameters, this.projectDetails, this.filterParameters, this.metrics, this.geneMaps, this.projectType, this.identificationFeaturesGenerator.getIdentificationFeaturesCache(), emptyCache, this.displayParameters, this.dbFolder);
        this.loadUserParameters();
        this.userPreferences.addRecentProject(this.psdbFile);
        this.saveUserParameters();
    }

    public boolean loadSpectrumFiles(WaitingHandler waitingHandler) throws IOException {
        return this.loadSpectrumFiles(null, waitingHandler);
    }

    public boolean loadSpectrumFiles(File folder, WaitingHandler waitingHandler) throws IOException {
        for (String spectrumFileNameWithoutExtension : this.projectDetails.getSpectrumFileNames()) {
            File providedSpectrumLocation = new File(this.projectDetails.getSpectrumFilePath(spectrumFileNameWithoutExtension));
            File projectFolder = this.psdbFile.getParentFile();
            boolean spectrumFileFound = providedSpectrumLocation.exists();
            if (!spectrumFileFound) {
                for (File tempFile : projectFolder.listFiles()) {
                    if (!IoUtil.removeExtension((String)tempFile.getName()).equalsIgnoreCase(spectrumFileNameWithoutExtension)) continue;
                    this.projectDetails.addSpectrumFilePath(tempFile.getAbsolutePath());
                    spectrumFileFound = true;
                }
            }
            if (!spectrumFileFound) {
                File dataFolder = new File(projectFolder, "data");
                File[] fileArray = dataFolder.listFiles();
                int n = fileArray.length;
                for (int tempFile = 0; tempFile < n; ++tempFile) {
                    File tempFile2 = fileArray[tempFile];
                    if (!IoUtil.removeExtension((String)tempFile2.getName()).equalsIgnoreCase(spectrumFileNameWithoutExtension)) continue;
                    this.projectDetails.addSpectrumFilePath(tempFile2.getAbsolutePath());
                    spectrumFileFound = true;
                }
            }
            if (!spectrumFileFound) {
                for (File tempFile : folder.listFiles()) {
                    if (!IoUtil.removeExtension((String)tempFile.getName()).equalsIgnoreCase(spectrumFileNameWithoutExtension)) continue;
                    this.projectDetails.addSpectrumFilePath(tempFile.getAbsolutePath());
                    spectrumFileFound = true;
                }
            }
            if (!spectrumFileFound) {
                return false;
            }
            File spectrumFile = new File(this.projectDetails.getSpectrumFilePath(spectrumFileNameWithoutExtension));
            folder = CmsFolder.getParentFolder() == null ? spectrumFile.getParentFile() : new File(CmsFolder.getParentFolder());
            this.msFileHandler.register(spectrumFile, folder, waitingHandler);
        }
        return true;
    }

    public boolean loadSpectrumFile(String spectrumFileName, ArrayList<File> spectrumFiles, WaitingHandler waitingHandler) throws IOException {
        File providedSpectrumLocation = new File(this.projectDetails.getSpectrumFilePath(spectrumFileName));
        File projectFolder = this.psdbFile.getParentFile();
        File dataFolder = new File(projectFolder, "data");
        boolean fileFound = providedSpectrumLocation.exists();
        if (!fileFound) {
            for (File tempFile : dataFolder.listFiles()) {
                if (fileFound || !IoUtil.removeExtension((String)tempFile.getName()).equalsIgnoreCase(spectrumFileName)) continue;
                this.projectDetails.addSpectrumFilePath(tempFile.getAbsolutePath());
                fileFound = true;
            }
            if (!fileFound) {
                for (File tempFile : projectFolder.listFiles()) {
                    if (fileFound || !IoUtil.removeExtension((String)tempFile.getName()).equalsIgnoreCase(spectrumFileName)) continue;
                    this.projectDetails.addSpectrumFilePath(tempFile.getAbsolutePath());
                    fileFound = true;
                }
            }
        }
        if (!fileFound) {
            return false;
        }
        File spectrumFile = new File(this.projectDetails.getSpectrumFilePath(spectrumFileName));
        File folder = CmsFolder.getParentFolder() == null ? spectrumFile.getParentFile() : new File(CmsFolder.getParentFolder());
        this.msFileHandler.register(spectrumFile, folder, waitingHandler);
        spectrumFiles.add(spectrumFile);
        return true;
    }

    public void loadSpectrumFile(File spectrumFile, WaitingHandler waitingHandler) throws IOException {
        this.projectDetails.addSpectrumFilePath(spectrumFile.getAbsolutePath());
        File folder = CmsFolder.getParentFolder() == null ? spectrumFile.getParentFile() : new File(CmsFolder.getParentFolder());
        this.msFileHandler.register(spectrumFile, folder, waitingHandler);
    }

    public FastaSummary loadFastaFile(WaitingHandler waitingHandler) throws IOException {
        File providedFastaLocation = new File(this.projectDetails.getFastaFile());
        if (!providedFastaLocation.exists()) {
            boolean fastaFileFound = false;
            if (this.psdbFile != null) {
                File projectFolder = this.psdbFile.getParentFile();
                File dataFolder = new File(projectFolder, "data");
                File fileInProjectFolder = new File(projectFolder, IoUtil.getFileName((File)providedFastaLocation));
                File fileInDataFolder = new File(dataFolder, IoUtil.getFileName((File)providedFastaLocation));
                if (fileInProjectFolder.exists()) {
                    this.projectDetails.setFastaFile(fileInProjectFolder);
                    fastaFileFound = true;
                } else if (fileInDataFolder.exists()) {
                    this.projectDetails.setFastaFile(fileInDataFolder);
                    fastaFileFound = true;
                }
            }
            if (!fastaFileFound) {
                throw new IOException("FASTA file not found: " + providedFastaLocation.getAbsolutePath());
            }
        }
        return FastaSummary.getSummary((String)this.projectDetails.getFastaFile(), (FastaParameters)this.identificationParameters.getFastaParameters(), (WaitingHandler)waitingHandler);
    }

    public Identification getIdentification() {
        return this.identification;
    }

    public IdentificationFeaturesGenerator getIdentificationFeaturesGenerator() {
        return this.identificationFeaturesGenerator;
    }

    public SpectrumCountingParameters getSpectrumCountingParameters() {
        return this.spectrumCountingParameters;
    }

    public ProjectDetails getProjectDetails() {
        return this.projectDetails;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public GeneMaps getGeneMaps() {
        return this.geneMaps;
    }

    public FilterParameters getFilterParameters() {
        return this.filterParameters;
    }

    public DisplayParameters getDisplayParameters() {
        return this.displayParameters;
    }

    public File getPsdbFile() {
        return this.psdbFile;
    }

    public boolean getPsdbImportFromZip() {
        return this.importFromZip;
    }

    public void setIdentificationFeaturesGenerator(IdentificationFeaturesGenerator identificationFeaturesGenerator) {
        this.identificationFeaturesGenerator = identificationFeaturesGenerator;
    }

    public void setSpectrumCountingParameters(SpectrumCountingParameters spectrumCountingPreferences) {
        this.spectrumCountingParameters = spectrumCountingPreferences;
        if (this.identificationFeaturesGenerator != null) {
            this.identificationFeaturesGenerator.setSpectrumCountingPreferences(spectrumCountingPreferences);
        }
    }

    public void setProjectDetails(ProjectDetails projectDetails) {
        this.projectDetails = projectDetails;
    }

    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    public void setGeneMaps(GeneMaps geneMaps) {
        this.geneMaps = geneMaps;
    }

    public ProjectParameters getProjectParameters() {
        return this.projectParameters;
    }

    public void setProject(ProjectParameters projectParameters) {
        this.projectParameters = projectParameters;
    }

    public void setFilterParameters(FilterParameters filterPreferences) {
        this.filterParameters = filterPreferences;
    }

    public void setDisplayParameters(DisplayParameters displayPreferences) {
        this.displayParameters = displayPreferences;
    }

    public void setPsdbFile(File psdbFile) {
        this.psdbFile = psdbFile;
    }

    public void setPsdbImportFromZip(boolean importFromZip) {
        this.importFromZip = importFromZip;
    }

    public UserParameters getUserParameters() {
        return this.userPreferences;
    }

    public void setIdentification(Identification identification) {
        this.identification = identification;
    }

    public void setDefaultParameters() {
        SearchParameters searchParameters = new SearchParameters();
        this.identificationParameters = new IdentificationParameters(searchParameters);
        this.spectrumCountingParameters = new SpectrumCountingParameters();
        this.spectrumCountingParameters.setSelectedMethod(SpectrumCountingMethod.NSAF);
        this.spectrumCountingParameters.setMatchValidationLevel(Integer.valueOf(MatchValidationLevel.doubtful.getIndex()));
    }

    public void resetIdentificationFeaturesGenerator() {
        this.identificationFeaturesGenerator = new IdentificationFeaturesGenerator(this.identification, this.identificationParameters, this.sequenceProvider, (SpectrumProvider)this.msFileHandler, this.metrics, this.spectrumCountingParameters);
    }

    public IdentificationParameters getIdentificationParameters() {
        return this.identificationParameters;
    }

    public void setIdentificationParameters(IdentificationParameters identificationParameters) {
        this.identificationParameters = identificationParameters;
    }

    public File getDbFolder() {
        return this.dbFolder;
    }

    public void setDbFolder(File dbFolder) {
        this.dbFolder = dbFolder;
    }

    public SequenceProvider getSequenceProvider() {
        return this.sequenceProvider;
    }

    public SpectrumProvider getSpectrumProvider() {
        return this.msFileHandler;
    }

    public void setMsFileHandler(MsFileHandler msFileHandler) {
        this.msFileHandler = msFileHandler;
    }

    public void setSequenceProvider(SequenceProvider sequenceProvider) {
        this.sequenceProvider = sequenceProvider;
    }

    public ProteinDetailsProvider getProteinDetailsProvider() {
        return this.proteinDetailsProvider;
    }

    public void setProteinDetailsProvider(ProteinDetailsProvider proteinDetailsProvider) {
        this.proteinDetailsProvider = proteinDetailsProvider;
    }

    public ProjectType getProjectType() {
        return this.projectType;
    }

    public void setProjectType(ProjectType projectType) {
        this.projectType = projectType;
    }

    public String getExtendedProjectReport(String waitingHandlerReport) {
        StringBuilder report = new StringBuilder();
        if (this.projectDetails != null && this.getIdentification() != null) {
            report.append("<html><br>");
            report.append("<b>Experiment</b>: ").append(this.projectParameters.getProjectUniqueName()).append("<br>");
            if (this.projectDetails.getCreationDate() != null) {
                report.append("<b>Creation Date:</b> ").append(this.projectDetails.getCreationDate()).append("<br><br>");
            }
            report.append("<b>Identification Files</b>:<br>");
            for (String idFilePath : this.projectDetails.getIdentificationFiles()) {
                File idFile = new File(idFilePath);
                report.append(idFile.getAbsolutePath()).append(" - ");
                HashMap<String, ArrayList<String>> versions = this.projectDetails.getIdentificationAlgorithmsForFile(idFile.getName());
                ArrayList<String> software = new ArrayList<String>(versions.keySet());
                Collections.sort(software);
                boolean first = true;
                for (String softwareName : software) {
                    if (first) {
                        first = false;
                    } else {
                        report.append(", ");
                    }
                    report.append(softwareName);
                    ArrayList<String> algorithmVersions = versions.get(softwareName);
                    if (algorithmVersions == null || algorithmVersions.isEmpty()) continue;
                    report.append(" - (");
                    boolean firstVersion = true;
                    for (String version : algorithmVersions) {
                        if (firstVersion) {
                            firstVersion = false;
                        } else {
                            report.append(", ");
                        }
                        if (version != null) {
                            report.append(version);
                            continue;
                        }
                        report.append("unknown version");
                    }
                    report.append(")");
                }
                report.append("<br>");
            }
            report.append("<br><b>Spectrum Files:</b><br>");
            for (String spectrumFileNames : this.projectDetails.getSpectrumFileNames()) {
                report.append(this.projectDetails.getSpectrumFilePath(spectrumFileNames)).append("<br>");
            }
            report.append("<br><b>FASTA File:</b><br>");
            report.append(this.projectDetails.getFastaFile()).append("<br>");
            report.append("<br><br><b>Report:</b><br>");
            if (waitingHandlerReport == null) {
                waitingHandlerReport = this.projectDetails.getReport();
            }
            if (waitingHandlerReport.lastIndexOf("<br>") == -1) {
                report.append("<pre>").append(waitingHandlerReport).append("</pre>");
            } else {
                report.append(waitingHandlerReport);
            }
            report.append("</html>");
        } else {
            report.append("<html><br>");
            report.append("<b>Report:</b><br>");
            if (waitingHandlerReport != null) {
                if (waitingHandlerReport.lastIndexOf("<br>") == -1) {
                    report.append("<pre>").append(waitingHandlerReport).append("</pre>");
                } else {
                    report.append(waitingHandlerReport);
                }
            }
            report.append("</html>");
        }
        return report.toString();
    }

    @Override
    public void close() {
        if (this.msFileHandler != null) {
            this.msFileHandler.close();
        }
    }
}

