/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.extra;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class TrueFalseIconRenderer
implements TableCellRenderer {
    private ImageIcon trueIcon;
    private ImageIcon falseIcon;
    private ImageIcon nullIcon;
    private String trueToolTip = null;
    private String falseToolTip = null;
    private String nullToolTip = null;

    public TrueFalseIconRenderer(ImageIcon trueIcon, ImageIcon falseIcon) {
        this.trueIcon = trueIcon;
        this.falseIcon = falseIcon;
    }

    public TrueFalseIconRenderer(ImageIcon trueIcon, ImageIcon falseIcon, String trueToolTip, String falseToolTip) {
        this.trueIcon = trueIcon;
        this.falseIcon = falseIcon;
        this.trueToolTip = trueToolTip;
        this.falseToolTip = falseToolTip;
    }

    public TrueFalseIconRenderer(ImageIcon trueIcon, ImageIcon falseIcon, ImageIcon nullIcon, String trueToolTip, String falseToolTip, String nullToolTip) {
        this.trueIcon = trueIcon;
        this.falseIcon = falseIcon;
        this.nullIcon = nullIcon;
        this.trueToolTip = trueToolTip;
        this.falseToolTip = falseToolTip;
        this.nullToolTip = nullToolTip;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Color bg = label.getBackground();
        label.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
        if (value != null && value instanceof Boolean) {
            label.setText(null);
            label.setHorizontalAlignment(0);
            if (((Boolean)value).booleanValue()) {
                label.setIcon(this.trueIcon);
                label.setToolTipText(this.trueToolTip);
            } else {
                label.setIcon(this.falseIcon);
                label.setToolTipText(this.falseToolTip);
            }
        } else {
            label.setIcon(this.nullIcon);
            label.setToolTipText(this.nullToolTip);
        }
        return label;
    }
}

