/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.renderers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.data.StartIndexes;
import no.uib.jsparklines.renderers.util.GradientColorCoding;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.IntervalBarRenderer;
import org.jfree.chart.renderer.category.LayeredBarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class JSparklinesMultiIntervalChartTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private int labelHorizontalAlignement = 4;
    private double minimumChartValue = 0.05;
    private double tooltipLowerValue = 0.01;
    private ChartPanel chartPanel;
    private JFreeChart chart;
    private JLabel valueLabel;
    private double maxValue = 1.0;
    private double minValue = 0.0;
    private boolean showNumbers = false;
    private boolean showNumberAndChart = false;
    private int widthOfValueLabel = 40;
    private Color plotBackgroundColor = null;
    private Color positiveValuesColor = new Color(255, 51, 51);
    private boolean gradientColoring = false;
    private double widthOfInterval;
    private boolean showReferenceLine = false;
    private double referenceLineWidth = 0.03;
    private Color referenceLineColor = Color.BLACK;
    private PlotOrientation plotOrientation;

    public JSparklinesMultiIntervalChartTableCellRenderer(PlotOrientation plotOrientation, Double maxValue, Double widthOfInterval, Color positiveValuesColor) {
        this.positiveValuesColor = positiveValuesColor;
        this.maxValue = maxValue;
        this.widthOfInterval = widthOfInterval;
        this.plotOrientation = plotOrientation;
        this.setUpRendererAndChart(plotOrientation);
    }

    private void setUpRendererAndChart(PlotOrientation plotOrientation) {
        this.setName("Table.cellRenderer");
        this.setLayout(new BorderLayout());
        this.valueLabel = new JLabel("");
        this.valueLabel.setMinimumSize(new Dimension(this.widthOfValueLabel, 0));
        this.valueLabel.setHorizontalAlignment(0);
        this.valueLabel.setFont(this.valueLabel.getFont().deriveFont((float)this.valueLabel.getFont().getSize() - 2.0f));
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        this.chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)false, (boolean)false, (boolean)false);
        this.chartPanel = new ChartPanel(this.chart);
        this.setLayout(new BoxLayout(this, 2));
        this.add(this.valueLabel);
        this.add((Component)this.chartPanel);
    }

    public void showReferenceLine(boolean showReferenceLine) {
        this.showReferenceLine = showReferenceLine;
    }

    public void showReferenceLine(boolean showReferenceLine, double lineWidth, Color color) {
        this.showReferenceLine = showReferenceLine;
        this.referenceLineWidth = lineWidth;
        this.referenceLineColor = color;
    }

    public void setGradientColoring(GradientColorCoding.ColorGradient colorGradient) {
        this.setGradientColoring(colorGradient, null);
    }

    public void setGradientColoring(GradientColorCoding.ColorGradient colorGradient, Color plotBackgroundColor) {
        this.gradientColoring = colorGradient != null;
        this.plotBackgroundColor = plotBackgroundColor;
        if (this.gradientColoring && Math.abs(this.minValue) > this.maxValue) {
            this.maxValue = Math.abs(this.minValue);
        }
    }

    public void setBackgroundColor(Color plotBackgroundColor) {
        this.plotBackgroundColor = plotBackgroundColor;
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel) {
        this.showNumberAndChart = showNumberAndChart;
        this.widthOfValueLabel = widthOfLabel;
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel, Font font, int horizontalAlignement) {
        this.showNumberAndChart = showNumberAndChart;
        this.widthOfValueLabel = widthOfLabel;
        this.labelHorizontalAlignement = horizontalAlignement;
        this.valueLabel.setFont(font);
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void showNumbers(boolean showNumbers) {
        this.showNumbers = showNumbers;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String numbersAsString;
        JComponent c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setBorder(c.getBorder());
        this.setOpaque(c.isOpaque());
        if (this.plotBackgroundColor != null) {
            this.setBackground(this.plotBackgroundColor);
        } else {
            this.setBackground(c.getBackground());
        }
        if (value == null || !(value instanceof StartIndexes)) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        StartIndexes startIndexes = (StartIndexes)value;
        ArrayList<Integer> indexes = startIndexes.getIndexes();
        if (this.showNumbers) {
            String numbersAsString2 = "";
            if (indexes.isEmpty()) {
                numbersAsString2 = null;
            } else {
                for (int i = 0; i < indexes.size() - 1; ++i) {
                    numbersAsString2 = numbersAsString2 + indexes.get(i) + ",";
                }
                numbersAsString2 = numbersAsString2 + indexes.get(indexes.size() - 1);
            }
            c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, numbersAsString2, isSelected, hasFocus, row, column);
            ((JLabel)c).setHorizontalAlignment(4);
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        if (indexes.isEmpty()) {
            numbersAsString = null;
        } else {
            numbersAsString = "<html>";
            for (int i = 0; i < indexes.size() - 1; ++i) {
                numbersAsString = numbersAsString + indexes.get(i) + ",";
            }
            numbersAsString = numbersAsString + indexes.get(indexes.size() - 1);
            numbersAsString = numbersAsString + "</html>";
        }
        this.setToolTipText(numbersAsString);
        if (this.showNumberAndChart) {
            if (indexes.isEmpty()) {
                this.valueLabel.setText(null);
            } else if (indexes.size() > 1) {
                this.valueLabel.setText(indexes.size() + "x");
            } else {
                this.valueLabel.setText("" + indexes.get(0));
            }
            Color bg = c.getBackground();
            this.valueLabel.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            if (this.labelHorizontalAlignement == 4) {
                this.valueLabel.setText(this.valueLabel.getText() + "  ");
            } else if (this.labelHorizontalAlignement == 2) {
                this.valueLabel.setText("  " + this.valueLabel.getText());
            }
            this.valueLabel.setForeground(c.getForeground());
            this.valueLabel.setHorizontalAlignment(this.labelHorizontalAlignement);
            this.valueLabel.setMinimumSize(new Dimension(this.widthOfValueLabel, 0));
            this.valueLabel.setSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
            this.valueLabel.setMaximumSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
            this.valueLabel.setPreferredSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
            this.valueLabel.setVisible(true);
        } else {
            this.valueLabel.setMinimumSize(new Dimension(0, 0));
            this.valueLabel.setSize(0, 0);
            this.valueLabel.setVisible(false);
        }
        DefaultCategoryDataset barChartDataset = new DefaultCategoryDataset();
        StackedBarRenderer renderer = new StackedBarRenderer();
        renderer.setShadowVisible(false);
        int indexCounter = 0;
        int seriesCounter = 0;
        for (int i = 0; i < indexes.size(); ++i) {
            barChartDataset.addValue((double)(indexes.get(i) - 1 - indexCounter), (Comparable)((Object)("" + seriesCounter)), (Comparable)((Object)"1"));
            renderer.setSeriesPaint(seriesCounter++, (Paint)new Color(0, 0, 0, 0));
            indexCounter += indexes.get(i) - 1 - indexCounter;
            barChartDataset.addValue(this.widthOfInterval, (Comparable)((Object)("" + seriesCounter)), (Comparable)((Object)"1"));
            renderer.setSeriesPaint(seriesCounter++, (Paint)this.positiveValuesColor);
            indexCounter = (int)((double)indexCounter + this.widthOfInterval);
        }
        if (!indexes.isEmpty()) {
            barChartDataset.addValue(this.maxValue - (double)indexCounter, (Comparable)((Object)("" + seriesCounter)), (Comparable)((Object)"1"));
            renderer.setSeriesPaint(seriesCounter++, (Paint)new Color(0, 0, 0, 0));
        }
        this.chart = ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)barChartDataset, (PlotOrientation)this.plotOrientation, (boolean)false, (boolean)false, (boolean)false);
        CategoryPlot plot = this.chart.getCategoryPlot();
        plot.getRangeAxis().setRange(this.minValue, this.maxValue * 1.02);
        plot.getDomainAxis().setUpperMargin(0.0);
        plot.getDomainAxis().setLowerMargin(0.0);
        plot.getRangeAxis().setUpperMargin(0.0);
        plot.getRangeAxis().setLowerMargin(0.0);
        plot.setOutlineVisible(false);
        plot.getRangeAxis().setVisible(false);
        plot.getDomainAxis().setVisible(false);
        plot.setRangeGridlinesVisible(false);
        if (this.showReferenceLine) {
            DefaultCategoryDataset referenceLineDataset = new DefaultCategoryDataset();
            referenceLineDataset.addValue(this.maxValue * 1.02, (Comparable)((Object)"A"), (Comparable)((Object)"B"));
            plot.setDataset(1, (CategoryDataset)referenceLineDataset);
            LayeredBarRenderer referenceLineRenderer = new LayeredBarRenderer();
            referenceLineRenderer.setSeriesBarWidth(0, this.referenceLineWidth);
            referenceLineRenderer.setSeriesFillPaint(0, (Paint)this.referenceLineColor);
            referenceLineRenderer.setSeriesPaint(0, (Paint)this.referenceLineColor);
            plot.setRenderer(1, (CategoryItemRenderer)referenceLineRenderer);
        }
        if (this.plotBackgroundColor != null && !isSelected) {
            plot.setBackgroundPaint((Paint)this.plotBackgroundColor);
            this.chartPanel.setBackground(this.plotBackgroundColor);
            this.chart.setBackgroundPaint((Paint)this.plotBackgroundColor);
        } else {
            Color bg = c.getBackground();
            plot.setBackgroundPaint((Paint)new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.chartPanel.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.chart.setBackgroundPaint((Paint)new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
        }
        plot.setRenderer(0, (CategoryItemRenderer)renderer);
        if (this.plotBackgroundColor != null) {
            this.chart.getPlot().setBackgroundPaint((Paint)this.plotBackgroundColor);
            this.chart.setBackgroundPaint((Paint)this.plotBackgroundColor);
        } else {
            this.chart.getPlot().setBackgroundPaint((Paint)c.getBackground());
            this.chart.setBackgroundPaint((Paint)c.getBackground());
        }
        this.chartPanel = new ChartPanel(this.chart);
        if (this.plotBackgroundColor != null) {
            this.chartPanel.setBackground(this.plotBackgroundColor);
        } else {
            this.chartPanel.setBackground(c.getBackground());
        }
        this.remove(1);
        this.add((Component)this.chartPanel);
        return this;
    }

    public double getMinimumChartValue() {
        return this.minimumChartValue;
    }

    public void setMinimumChartValue(double minimumChartValue) {
        this.minimumChartValue = minimumChartValue;
    }

    public double getTooltipLowerValue() {
        return this.tooltipLowerValue;
    }

    public void setTooltipLowerValue(double tooltipLowerValue) {
        this.tooltipLowerValue = tooltipLowerValue;
    }

    public void setPositiveValuesColor(Color positiveValuesColor) {
        this.positiveValuesColor = positiveValuesColor;
    }

    static {
        IntervalBarRenderer.setDefaultBarPainter((BarPainter)new StandardBarPainter());
    }
}

