/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.Intrinsics;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.ObjectShortAssociativeContainer;
import com.carrotsearch.hppc.ObjectShortMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectShortCursor;
import com.carrotsearch.hppc.hash.ObjectHashFunction;
import com.carrotsearch.hppc.hash.ObjectMurmurHash;
import com.carrotsearch.hppc.hash.ShortHashFunction;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import com.carrotsearch.hppc.procedures.ObjectShortProcedure;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectShortOpenHashMap<KType>
implements ObjectShortMap<KType> {
    private static final Comparator<Object> EQUALS_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return Intrinsics.equals(o1, o2) ? 0 : 1;
        }
    };
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final byte EMPTY = 0;
    public static final byte DELETED = 1;
    public static final byte ASSIGNED = 2;
    public KType[] keys;
    public short[] values;
    public byte[] states;
    public int deleted;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;
    public final ObjectHashFunction<? super KType> keyHashFunction;
    public final ShortHashFunction valueHashFunction;
    public final Comparator<? super KType> keyComparator;
    private KeySet keySetView;

    public ObjectShortOpenHashMap() {
        this(16);
    }

    public ObjectShortOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ObjectShortOpenHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, new ObjectMurmurHash());
    }

    public ObjectShortOpenHashMap(int initialCapacity, float loadFactor, ObjectHashFunction<? super KType> keyHashFunction) {
        this(initialCapacity, loadFactor, keyHashFunction, new ShortHashFunction(), EQUALS_COMPARATOR);
    }

    public ObjectShortOpenHashMap(int initialCapacity, float loadFactor, ObjectHashFunction<? super KType> keyHashFunction, ShortHashFunction valueHashFunction, Comparator<? super KType> keyComparator) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        assert (keyComparator != null) : "Key comparator must not be null.";
        this.keyComparator = keyComparator;
        this.valueHashFunction = valueHashFunction;
        this.keyHashFunction = keyHashFunction;
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    public ObjectShortOpenHashMap(ObjectShortAssociativeContainer<KType> container) {
        this((int)((float)container.size() * 1.75f));
        this.putAll(container);
    }

    @Override
    public short put(KType key, short value) {
        int slot;
        byte state;
        if (this.assigned + this.deleted >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        if ((state = this.states[slot = this.slotFor(key)]) != 2) {
            ++this.assigned;
        }
        if (state == 1) {
            --this.deleted;
        }
        short oldValue = this.values[slot];
        this.keys[slot] = key;
        this.values[slot] = value;
        this.states[slot] = 2;
        return oldValue;
    }

    @Override
    public final int putAll(ObjectShortAssociativeContainer<KType> container) {
        int count = this.assigned;
        for (ObjectShortCursor<KType> c : container) {
            this.put(c.key, c.value);
        }
        return this.assigned - count;
    }

    public final boolean putIfAbsent(KType key, short value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    public final short putOrAdd(KType key, short putValue, short additionValue) {
        int slot;
        byte state;
        if (this.assigned + this.deleted >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        if ((state = this.states[slot = this.slotFor(key)]) == 2) {
            int n = slot;
            short s = (short)(this.values[n] + additionValue);
            this.values[n] = s;
            return s;
        }
        ++this.assigned;
        if (state == 1) {
            --this.deleted;
        }
        this.states[slot] = 2;
        this.keys[slot] = key;
        this.values[slot] = putValue;
        return this.values[slot];
    }

    private void expandAndRehash() {
        KType[] oldKeys = this.keys;
        short[] oldValues = this.values;
        byte[] oldStates = this.states;
        if (this.assigned >= this.resizeThreshold) {
            this.allocateBuffers(this.nextCapacity(this.keys.length));
        } else {
            this.allocateBuffers(this.values.length);
        }
        for (int i = 0; i < oldStates.length; ++i) {
            if (oldStates[i] != 2) continue;
            int slot = this.slotFor(oldKeys[i]);
            this.keys[slot] = oldKeys[i];
            this.values[slot] = oldValues[i];
            this.states[slot] = 2;
            oldKeys[i] = null;
        }
        this.deleted = 0;
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = (Object[])Intrinsics.newKTypeArray(capacity);
        this.values = new short[capacity];
        this.states = new byte[capacity];
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
    }

    @Override
    public short remove(KType key) {
        int slot = this.slotFor(key);
        short value = this.values[slot];
        byte state = this.states[slot];
        if (state == 2) {
            ++this.deleted;
            --this.assigned;
            this.keys[slot] = Intrinsics.defaultKTypeValue();
            this.values[slot] = 0;
            this.states[slot] = 1;
        } else assert (0 == value) : "Default value expected.";
        return value;
    }

    @Override
    public final int removeAll(ObjectContainer<? extends KType> container) {
        int before = this.deleted;
        for (ObjectCursor<KType> objectCursor : container) {
            this.remove(objectCursor.value);
        }
        return this.deleted - before;
    }

    @Override
    public final int removeAll(ObjectPredicate<? super KType> predicate) {
        int before = this.deleted;
        KType[] keys = this.keys;
        short[] values = this.values;
        byte[] states = this.states;
        for (int i = 0; i < states.length; ++i) {
            if (states[i] != 2 || !predicate.apply(keys[i])) continue;
            ++this.deleted;
            --this.assigned;
            keys[i] = Intrinsics.defaultKTypeValue();
            values[i] = 0;
            states[i] = 1;
        }
        return this.deleted - before;
    }

    @Override
    public short get(KType key) {
        return this.values[this.slotFor(key)];
    }

    public short lget() {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.states[this.lastSlot] == 2) : "Last call to exists did not have any associated value.";
        return this.values[this.lastSlot];
    }

    public short lset(short key) {
        assert (this.lastSlot >= 0) : "Call containsKey() first.";
        assert (this.states[this.lastSlot] == 2) : "Last call to exists did not have any associated value.";
        short previous = this.values[this.lastSlot];
        this.values[this.lastSlot] = key;
        return previous;
    }

    @Override
    public boolean containsKey(KType key) {
        this.lastSlot = this.slotFor(key);
        int slot = this.lastSlot;
        return this.states[slot] == 2;
    }

    protected int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    public int slotFor(KType key) {
        int slots = this.states.length;
        int bucketMask = slots - 1;
        int slot = this.keyHashFunction.hash(key) & bucketMask;
        int i = 0;
        int deletedSlot = -1;
        byte state;
        while ((state = this.states[slot]) != 0) {
            if (state == 2 && this.keyComparator.compare(this.keys[slot], key) == 0) {
                return slot;
            }
            if (state == 1 && deletedSlot < 0) {
                deletedSlot = slot;
            }
            slot = slot + ++i & bucketMask;
        }
        return deletedSlot != -1 ? deletedSlot : slot;
    }

    @Override
    public void clear() {
        this.deleted = 0;
        this.assigned = 0;
        Arrays.fill(this.states, (byte)0);
        Arrays.fill(this.keys, null);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (ObjectShortCursor<KType> c : this) {
            h += this.keyHashFunction.hash(c.key) + this.valueHashFunction.hash(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            ObjectShortMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof ObjectShortMap && (other = (ObjectShortMap)obj).size() == this.size()) {
                for (ObjectShortCursor<KType> c : this) {
                    if (other.containsKey(c.key)) {
                        short v = other.get(c.key);
                        if (Intrinsics.equals(c.value, v)) continue;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<ObjectShortCursor<KType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ObjectShortProcedure<KType>> T forEach(T procedure) {
        KType[] keys = this.keys;
        short[] values = this.values;
        byte[] states = this.states;
        for (int i = 0; i < states.length; ++i) {
            if (states[i] != 2) continue;
            procedure.apply(keys[i], values[i]);
        }
        return procedure;
    }

    public KeySet keySet() {
        if (this.keySetView == null) {
            this.keySetView = new KeySet();
        }
        return this.keySetView;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ObjectShortCursor<KType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static <KType> ObjectShortOpenHashMap<KType> from(KType[] keys, short[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectShortOpenHashMap<KType> map = new ObjectShortOpenHashMap<KType>();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <KType> ObjectShortOpenHashMap<KType> from(ObjectShortAssociativeContainer<KType> container) {
        return new ObjectShortOpenHashMap<KType>(container);
    }

    private final class KeySetIterator
    implements Iterator<ObjectCursor<KType>> {
        private static final int NOT_CACHED = -1;
        private static final int AT_END = -2;
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private int nextIndex = -1;

        public KeySetIterator() {
            this.cursor.index = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                int i;
                for (i = this.cursor.index + 1; i < ObjectShortOpenHashMap.this.keys.length && ObjectShortOpenHashMap.this.states[i] != 2; ++i) {
                }
                this.nextIndex = i != ObjectShortOpenHashMap.this.keys.length ? i : -2;
            }
            return this.nextIndex != -2;
        }

        @Override
        public ObjectCursor<KType> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.cursor.index = this.nextIndex;
            this.cursor.value = ObjectShortOpenHashMap.this.keys[this.nextIndex];
            this.nextIndex = -1;
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public final class KeySet
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final ObjectShortOpenHashMap<KType> owner;

        public KeySet() {
            this.owner = ObjectShortOpenHashMap.this;
        }

        @Override
        public boolean contains(KType e) {
            return ObjectShortOpenHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            KType[] localKeys = this.owner.keys;
            byte[] localStates = this.owner.states;
            for (int i = 0; i < localStates.length; ++i) {
                if (localStates[i] != 2) continue;
                procedure.apply(localKeys[i]);
            }
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            KType[] localKeys = this.owner.keys;
            byte[] localStates = this.owner.states;
            for (int i = 0; i < localStates.length && (localStates[i] != 2 || predicate.apply(localKeys[i])); ++i) {
            }
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeySetIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAllOccurrences(KType e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }
    }

    private final class EntryIterator
    implements Iterator<ObjectShortCursor<KType>> {
        private static final int NOT_CACHED = -1;
        private static final int AT_END = -2;
        private final ObjectShortCursor<KType> cursor = new ObjectShortCursor();
        private int nextIndex = -1;

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                int i;
                for (i = this.cursor.index + 1; i < ObjectShortOpenHashMap.this.keys.length && ObjectShortOpenHashMap.this.states[i] != 2; ++i) {
                }
                this.nextIndex = i != ObjectShortOpenHashMap.this.keys.length ? i : -2;
            }
            return this.nextIndex != -2;
        }

        @Override
        public ObjectShortCursor<KType> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.cursor.index = this.nextIndex;
            this.cursor.key = ObjectShortOpenHashMap.this.keys[this.nextIndex];
            this.cursor.value = ObjectShortOpenHashMap.this.values[this.nextIndex];
            this.nextIndex = -1;
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

