/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortDeque;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.hash.ShortHashFunction;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ShortArrayDeque
extends AbstractShortCollection
implements ShortDeque {
    public static final int DEFAULT_CAPACITY = 5;
    public short[] buffer;
    public int head;
    public int tail;
    protected final ArraySizingStrategy resizer;
    public final ShortHashFunction hashFunction;

    public ShortArrayDeque() {
        this(5);
    }

    public ShortArrayDeque(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public ShortArrayDeque(int initialCapacity, ArraySizingStrategy resizer) {
        this(initialCapacity, resizer, new ShortHashFunction());
    }

    public ShortArrayDeque(int initialCapacity, ArraySizingStrategy resizer, ShortHashFunction hashFunction) {
        assert (initialCapacity >= 0) : "initialCapacity must be >= 0: " + initialCapacity;
        assert (resizer != null);
        assert (hashFunction != null);
        this.hashFunction = hashFunction;
        this.resizer = resizer;
        initialCapacity = resizer.round(initialCapacity);
        this.buffer = new short[initialCapacity];
    }

    public ShortArrayDeque(ShortContainer container) {
        this(container.size());
        this.addLast(container);
    }

    @Override
    public void addFirst(short e1) {
        int h = ShortArrayDeque.oneLeft(this.head, this.buffer.length);
        if (h == this.tail) {
            this.ensureBufferSpace(1);
            h = ShortArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        this.head = h;
        this.buffer[this.head] = e1;
    }

    public void addFirst(short ... elements) {
        this.ensureBufferSpace(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            this.addFirst(elements[i]);
        }
    }

    public final int addFirst(ShortContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (ShortCursor cursor : container) {
            this.addFirst(cursor.value);
        }
        return size;
    }

    @Override
    public void addLast(short e1) {
        int t = ShortArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == t) {
            this.ensureBufferSpace(1);
            t = ShortArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = e1;
        this.tail = t;
    }

    public void addLast(short ... elements) {
        this.ensureBufferSpace(1);
        for (int i = 0; i < elements.length; ++i) {
            this.addLast(elements[i]);
        }
    }

    public final int addLast(ShortContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (ShortCursor cursor : container) {
            this.addLast(cursor.value);
        }
        return size;
    }

    @Override
    public short removeFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        short result = this.buffer[this.head];
        this.buffer[this.head] = 0;
        this.head = ShortArrayDeque.oneRight(this.head, this.buffer.length);
        return result;
    }

    @Override
    public short removeLast() {
        assert (this.size() > 0) : "The deque is empty.";
        this.tail = ShortArrayDeque.oneLeft(this.tail, this.buffer.length);
        short result = this.buffer[this.tail];
        this.buffer[this.tail] = 0;
        return result;
    }

    @Override
    public short getFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[this.head];
    }

    @Override
    public short getLast() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[ShortArrayDeque.oneLeft(this.tail, this.buffer.length)];
    }

    @Override
    public int removeFirstOccurrence(short e1) {
        int index = this.bufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int bufferIndexOf(short e1) {
        int last = this.tail;
        int bufLen = this.buffer.length;
        int i = this.head;
        while (i != last) {
            if (e1 == this.buffer[i]) {
                return i;
            }
            i = ShortArrayDeque.oneRight(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeLastOccurrence(short e1) {
        int index = this.lastBufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int lastBufferIndexOf(short e1) {
        int bufLen = this.buffer.length;
        int last = ShortArrayDeque.oneLeft(this.head, bufLen);
        int i = ShortArrayDeque.oneLeft(this.tail, bufLen);
        while (i != last) {
            if (e1 == this.buffer[i]) {
                return i;
            }
            i = ShortArrayDeque.oneLeft(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeAllOccurrences(short e1) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        int from = to = this.head;
        while (from != last) {
            if (e1 == this.buffer[from]) {
                this.buffer[from] = 0;
                ++removed;
            } else {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0;
                }
                to = ShortArrayDeque.oneRight(to, bufLen);
            }
            from = ShortArrayDeque.oneRight(from, bufLen);
        }
        this.tail = to;
        return removed;
    }

    public void removeAtBufferIndex(int index) {
        int rightChunk;
        assert (this.head > this.tail ? index >= this.head || index < this.tail : index >= this.head && index < this.tail) : "Index out of range (head=" + this.head + ", tail=" + this.tail + ", index=" + index + ").";
        short[] b = this.buffer;
        int bufLen = b.length;
        int lastIndex = bufLen - 1;
        int head = this.head;
        int tail = this.tail;
        int leftChunk = Math.abs(index - head) % bufLen;
        if (leftChunk < (rightChunk = Math.abs(tail - index) % bufLen)) {
            if (index >= head) {
                System.arraycopy(b, head, b, head + 1, leftChunk);
            } else {
                System.arraycopy(b, 0, b, 1, index);
                b[0] = b[lastIndex];
                System.arraycopy(b, head, b, head + 1, lastIndex - head);
            }
            b[head] = 0;
            this.head = ShortArrayDeque.oneRight(head, bufLen);
        } else {
            if (index < tail) {
                System.arraycopy(b, index + 1, b, index, rightChunk);
            } else {
                System.arraycopy(b, index + 1, b, index, lastIndex - index);
                b[lastIndex] = b[0];
                System.arraycopy(b, 1, b, 0, tail);
            }
            b[tail] = 0;
            this.tail = ShortArrayDeque.oneLeft(tail, bufLen);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.tail - this.head + this.buffer.length;
    }

    @Override
    public void clear() {
        if (this.head < this.tail) {
            Arrays.fill(this.buffer, this.head, this.tail, (short)0);
        } else {
            Arrays.fill(this.buffer, 0, this.tail, (short)0);
            Arrays.fill(this.buffer, this.head, this.buffer.length, (short)0);
        }
        this.tail = 0;
        this.head = 0;
    }

    public void release() {
        this.tail = 0;
        this.head = 0;
        int size = this.resizer.round(5);
        this.buffer = new short[size];
    }

    protected final void ensureBufferSpace(int expectedAdditions) {
        int bufferLen = this.buffer == null ? 0 : this.buffer.length;
        int elementsCount = this.size();
        int requestedMinimum = 1 + elementsCount + expectedAdditions;
        if (requestedMinimum >= bufferLen) {
            int newSize = this.resizer.grow(bufferLen, elementsCount, expectedAdditions + 1);
            assert (newSize >= requestedMinimum) : "Resizer failed to return sensible new size: " + newSize + " <= " + (elementsCount + expectedAdditions);
            short[] newBuffer = new short[newSize];
            if (bufferLen > 0) {
                this.toArray(newBuffer);
                this.tail = elementsCount;
                this.head = 0;
            }
            this.buffer = newBuffer;
        }
    }

    @Override
    public short[] toArray() {
        int size = this.size();
        return this.toArray(new short[size]);
    }

    public short[] toArray(short[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        if (this.head < this.tail) {
            System.arraycopy(this.buffer, this.head, target, 0, this.size());
        } else if (this.head > this.tail) {
            int rightCount = this.buffer.length - this.head;
            System.arraycopy(this.buffer, this.head, target, 0, rightCount);
            System.arraycopy(this.buffer, 0, target, rightCount, this.tail);
        }
        return target;
    }

    static final int oneLeft(int index, int modulus) {
        if (index >= 1) {
            return index - 1;
        }
        return modulus - 1;
    }

    static final int oneRight(int index, int modulus) {
        if (index + 1 == modulus) {
            return 0;
        }
        return index + 1;
    }

    @Override
    public Iterator<ShortCursor> iterator() {
        return new ValueIterator();
    }

    @Override
    public Iterator<ShortCursor> descendingIterator() {
        return new DescendingIterator();
    }

    @Override
    public <T extends ShortProcedure> T forEach(T procedure) {
        this.forEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void forEach(ShortProcedure procedure, int fromIndex, int toIndex) {
        short[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            procedure.apply(buffer[i]);
            i = ShortArrayDeque.oneRight(i, buffer.length);
        }
    }

    @Override
    public <T extends ShortPredicate> T forEach(T predicate) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        short[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex && predicate.apply(buffer[i])) {
            i = ShortArrayDeque.oneRight(i, buffer.length);
        }
        return predicate;
    }

    @Override
    public <T extends ShortProcedure> T descendingForEach(T procedure) {
        this.descendingForEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void descendingForEach(ShortProcedure procedure, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        short[] buffer = this.buffer;
        int i = toIndex;
        do {
            i = ShortArrayDeque.oneLeft(i, buffer.length);
            procedure.apply(buffer[i]);
        } while (i != fromIndex);
    }

    @Override
    public <T extends ShortPredicate> T descendingForEach(T predicate) {
        this.descendingForEach(predicate, this.head, this.tail);
        return predicate;
    }

    private void descendingForEach(ShortPredicate predicate, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        short[] buffer = this.buffer;
        int i = toIndex;
        while (predicate.apply(buffer[i = ShortArrayDeque.oneLeft(i, buffer.length)]) && i != fromIndex) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(ShortPredicate predicate) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        int from = to = this.head;
        try {
            from = to = this.head;
            while (from != last) {
                if (predicate.apply(this.buffer[from])) {
                    this.buffer[from] = 0;
                    ++removed;
                } else {
                    if (to != from) {
                        this.buffer[to] = this.buffer[from];
                        this.buffer[from] = 0;
                    }
                    to = ShortArrayDeque.oneRight(to, bufLen);
                }
                from = ShortArrayDeque.oneRight(from, bufLen);
            }
        }
        finally {
            while (from != last) {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0;
                }
                to = ShortArrayDeque.oneRight(to, bufLen);
                from = ShortArrayDeque.oneRight(from, bufLen);
            }
            this.tail = to;
        }
        return removed;
    }

    @Override
    public boolean contains(short e) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        short[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            if (e == buffer[i]) {
                return true;
            }
            i = ShortArrayDeque.oneRight(i, buffer.length);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 1;
        int fromIndex = this.head;
        int toIndex = this.tail;
        short[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            h = 31 * h + this.hashFunction.hash(this.buffer[i]);
            i = ShortArrayDeque.oneRight(i, buffer.length);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        ShortDeque other;
        if (obj != null && obj instanceof ShortDeque && (other = (ShortDeque)obj).size() == this.size()) {
            int fromIndex = this.head;
            short[] buffer = this.buffer;
            int i = fromIndex;
            for (ShortCursor c : other) {
                if (c.value != buffer[i]) {
                    return false;
                }
                i = ShortArrayDeque.oneRight(i, buffer.length);
            }
            return true;
        }
        return false;
    }

    public static ShortArrayDeque from(short ... elements) {
        ShortArrayDeque coll = new ShortArrayDeque(elements.length);
        coll.addLast(elements);
        return coll;
    }

    public static ShortArrayDeque from(ShortContainer container) {
        return new ShortArrayDeque(container);
    }

    private final class DescendingIterator
    implements Iterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private int remaining;

        public DescendingIterator() {
            this.cursor.index = ShortArrayDeque.this.tail;
            this.remaining = ShortArrayDeque.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        @Override
        public ShortCursor next() {
            if (this.remaining == 0) {
                throw new NoSuchElementException();
            }
            --this.remaining;
            this.cursor.index = ShortArrayDeque.oneLeft(this.cursor.index, ShortArrayDeque.this.buffer.length);
            this.cursor.value = ShortArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class ValueIterator
    implements Iterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private int remaining;

        public ValueIterator() {
            this.cursor.index = ShortArrayDeque.oneLeft(ShortArrayDeque.this.head, ShortArrayDeque.this.buffer.length);
            this.remaining = ShortArrayDeque.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        @Override
        public ShortCursor next() {
            if (this.remaining == 0) {
                throw new NoSuchElementException();
            }
            --this.remaining;
            this.cursor.index = ShortArrayDeque.oneRight(this.cursor.index, ShortArrayDeque.this.buffer.length);
            this.cursor.value = ShortArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

