/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.xxindex;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psidev.psi.tools.xxindex.FastXmlElementExtractor;
import psidev.psi.tools.xxindex.GzXmlElementExtractor;
import psidev.psi.tools.xxindex.XmlElementExtractor;
import psidev.psi.tools.xxindex.XpathAccess;
import psidev.psi.tools.xxindex.index.ByteBuffer;
import psidev.psi.tools.xxindex.index.IndexElement;
import psidev.psi.tools.xxindex.index.XmlElement;
import psidev.psi.tools.xxindex.index.XmlXpathIndexer;
import psidev.psi.tools.xxindex.index.XpathIndex;

public class StandardXpathAccess
implements XpathAccess {
    Logger logger = LoggerFactory.getLogger(StandardXpathAccess.class);
    private File file;
    private XpathIndex index;
    private XmlElementExtractor extractor;
    private boolean ignoreNSPrefix = true;
    private boolean isGzFile;
    private FileInputStream fis = null;
    private AsynchronousFileChannel asynchFileChannel;

    public StandardXpathAccess(File file) throws IOException {
        this(file, null);
    }

    public StandardXpathAccess(File file, Set<String> aXpathInclusionSet) throws IOException {
        this(file, aXpathInclusionSet, true);
    }

    public StandardXpathAccess(File file, Set<String> aXpathInclusionSet, boolean recordLineNumbers) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("The input file must not be null!");
        }
        if (!file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("Can not read from file! " + file.getAbsolutePath());
        }
        this.file = file;
        this.fis = new FileInputStream(file);
        if (file.getName().endsWith(".gz")) {
            this.isGzFile = true;
            this.index = XmlXpathIndexer.buildIndex(new GZIPInputStream(this.fis), aXpathInclusionSet, recordLineNumbers);
            this.extractor = new GzXmlElementExtractor();
        } else {
            this.isGzFile = false;
            this.index = XmlXpathIndexer.buildIndex(this.fis, aXpathInclusionSet, recordLineNumbers);
            this.extractor = new FastXmlElementExtractor(file);
        }
        String enc = this.extractor.detectFileEncoding(file.toURI().toURL());
        if (enc != null) {
            this.extractor.setEncoding(enc);
        }
        this.fis.close();
    }

    @Override
    public XpathIndex getIndex() {
        return this.index;
    }

    public boolean isIgnoreNSPrefix() {
        return this.ignoreNSPrefix;
    }

    public void setIgnoreNSPrefix(boolean ignoreNSPrefix) {
        this.ignoreNSPrefix = ignoreNSPrefix;
    }

    @Override
    public List<String> getXmlSnippets(String xpath) throws IOException {
        return this.getXmlSnippets(xpath, null, null);
    }

    public List<String> getXmlSnippets(String xpath, Long start, Long stop) throws IOException {
        ArrayList<String> results = new ArrayList<String>();
        if (this.index.containsXpath(xpath)) {
            List<IndexElement> ranges = this.index.getElements(xpath);
            for (IndexElement range : ranges) {
                if (start != null && range.getStart() < start || stop != null && range.getStop() > stop) continue;
                results.add(this.extractor.readString(range.getStart(), range.getStop(), this.file));
            }
        } else {
            this.logger.info("The index does not contain any entry for the requested xpath: " + xpath);
        }
        return results;
    }

    @Override
    public Iterator<String> getXmlSnippetIterator(String xpath) {
        return this.getXmlSnippetIterator(xpath, null, null);
    }

    @Override
    public Iterator<String> getXmlSnippetIterator(String xpath, Long start, Long stop) {
        XmlSnippetIterator iter;
        if (this.index.containsXpath(xpath)) {
            List<IndexElement> ranges = this.index.getElements(xpath);
            iter = new XmlSnippetIterator(ranges, this.extractor, this.file, start, stop);
        } else {
            this.logger.info("The index does not contain any entry for the requested xpath: " + xpath);
            List s = Collections.emptyList();
            iter = s.iterator();
        }
        return iter;
    }

    public int getXmlElementCount(String xpath) {
        return this.index.getElementCount(xpath);
    }

    public String getStartTag(IndexElement element) throws IOException {
        String startTag = null;
        long startPos = element.getStart();
        if (this.asynchFileChannel == null || !this.asynchFileChannel.isOpen()) {
            this.asynchFileChannel = AsynchronousFileChannel.open(this.file.toPath(), StandardOpenOption.READ);
        }
        if (this.isGzFile) {
            GZIPInputStream stream = new GZIPInputStream((InputStream)new FileInputStream(this.file), 0x100000);
            long skipped = ((InputStream)stream).skip(startPos);
            if (skipped != startPos) {
                throw new IllegalStateException("Could not position at requested location, reading compromised! Location: " + startPos);
            }
            boolean stopFound = false;
            ByteBuffer bb = new ByteBuffer();
            byte[] buffer = new byte[1];
            while (!stopFound) {
                ((InputStream)stream).read(buffer);
                byte read = buffer[0];
                bb.append(read);
                if (read != 62) continue;
                stopFound = true;
            }
            startTag = bb.toString("ASCII");
        } else {
            java.nio.ByteBuffer byteBuffer = java.nio.ByteBuffer.allocate(2048);
            Future<Integer> results = this.asynchFileChannel.read(byteBuffer, startPos);
            while (!results.isDone()) {
            }
            byteBuffer.flip();
            ByteBuffer psiByteBuffer = new ByteBuffer();
            while (byteBuffer.hasRemaining()) {
                byte aByte = byteBuffer.get();
                psiByteBuffer.append(aByte);
                if ((char)aByte != '>') continue;
                startTag = psiByteBuffer.toString("ASCII");
                break;
            }
        }
        if (startTag == null) {
            this.logger.warn("No start tag found in line number: " + element.getLineNumber());
        }
        return startTag;
    }

    public List<XmlElement> getXmlElements(String xpath) throws IOException {
        return this.getXmlElements(xpath, null, null);
    }

    public List<XmlElement> getXmlElements(String xpath, Long start, Long stop) throws IOException {
        ArrayList<XmlElement> results = new ArrayList<XmlElement>();
        if (this.index.containsXpath(xpath)) {
            List<IndexElement> elements = this.index.getElements(xpath);
            for (IndexElement element : elements) {
                if (start != null && element.getStart() < start || stop != null && element.getStop() > stop) continue;
                String tmp = this.extractor.readString(element.getStart(), element.getStop(), this.file);
                long posTmp = element.getLineNumber();
                results.add(new XmlElement(tmp, posTmp));
            }
        } else {
            this.logger.info("The index does not contain any entry for the requested xpath: " + xpath);
        }
        return results;
    }

    public Iterator<XmlElement> getXmlElementIterator(String xpath) {
        return this.getXmlElementIterator(xpath, null, null);
    }

    public Iterator<XmlElement> getXmlElementIterator(String xpath, Long start, Long stop) {
        XmlElementIterator iter;
        if (this.index.containsXpath(xpath)) {
            List<IndexElement> elements = this.index.getElements(xpath);
            iter = new XmlElementIterator(elements, this.extractor, this.file, start, stop);
        } else {
            this.logger.info("The index does not contain any entry for the requested xpath: " + xpath);
            List s = Collections.emptyList();
            iter = s.iterator();
        }
        return iter;
    }

    private class XmlElementIterator
    implements Iterator<XmlElement> {
        private Iterator<IndexElement> iterator;
        private XmlElementExtractor extractor;
        private File file;

        public XmlElementIterator(List<IndexElement> elements, XmlElementExtractor extractor, File file) {
            this.iterator = elements.iterator();
            this.extractor = extractor;
            this.file = file;
        }

        public XmlElementIterator(List<IndexElement> elements, XmlElementExtractor extractor, File file, Long start, Long stop) {
            List<IndexElement> validElements;
            if (start == null && stop == null) {
                validElements = elements;
            } else {
                validElements = new ArrayList<IndexElement>();
                for (IndexElement element : elements) {
                    if (start != null && element.getStart() < start || stop != null && element.getStop() > stop) continue;
                    validElements.add(element);
                }
            }
            this.iterator = validElements.iterator();
            this.extractor = extractor;
            this.file = file;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public XmlElement next() {
            XmlElement result;
            IndexElement element = this.iterator.next();
            try {
                String xmlSnippet = this.extractor.readString(element.getStart(), element.getStop(), this.file);
                long position = element.getLineNumber();
                result = new XmlElement(xmlSnippet, position);
            }
            catch (IOException e) {
                throw new IllegalStateException("Caught IOException while reading from file: " + this.file.getName());
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class XmlSnippetIterator
    implements Iterator<String> {
        private Iterator<IndexElement> iterator;
        private XmlElementExtractor extractor;
        private File file;

        public XmlSnippetIterator(List<IndexElement> ranges, XmlElementExtractor extractor, File file) {
            this.iterator = ranges.iterator();
            this.extractor = extractor;
            this.file = file;
        }

        public XmlSnippetIterator(List<IndexElement> elements, XmlElementExtractor extractor, File file, Long start, Long stop) {
            List<IndexElement> validElements;
            if (start == null && stop == null) {
                validElements = elements;
            } else {
                validElements = new ArrayList<IndexElement>();
                for (IndexElement element : elements) {
                    if (start != null && element.getStart() < start || stop != null && element.getStop() > stop) continue;
                    validElements.add(element);
                }
            }
            this.iterator = validElements.iterator();
            this.extractor = extractor;
            this.file = file;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            String result;
            IndexElement range = this.iterator.next();
            try {
                result = this.extractor.readString(range.getStart(), range.getStop(), this.file);
            }
            catch (IOException e) {
                throw new IllegalStateException("Caught IOException while reading from file: " + this.file.getName(), e);
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

