/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.xxindex.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import psidev.psi.tools.xxindex.index.ByteRange;
import psidev.psi.tools.xxindex.index.IndexElement;
import psidev.psi.tools.xxindex.index.LineNumberedByteRange;
import psidev.psi.tools.xxindex.index.XpathIndex;

public class StandardXpathIndex
implements XpathIndex {
    private Map<String, List<IndexElement>> index = new HashMap<String, List<IndexElement>>();
    private Set<String> xpathInclusionSet = null;
    private boolean recordLineNumber;
    private String checksum;

    public StandardXpathIndex() {
        this(null);
    }

    public StandardXpathIndex(Set<String> aXpathInclusionSet) {
        if (aXpathInclusionSet != null) {
            this.xpathInclusionSet = new HashSet<String>(aXpathInclusionSet.size());
            for (String s : aXpathInclusionSet) {
                if (s == null) continue;
                if (s.endsWith("/")) {
                    s = s.substring(0, s.length() - 1);
                }
                this.xpathInclusionSet.add(s);
            }
        }
        this.recordLineNumber = true;
    }

    @Override
    public boolean isRecordLineNumber() {
        return this.recordLineNumber;
    }

    public void setRecordLineNumber(boolean recordLineNumber) {
        this.recordLineNumber = recordLineNumber;
    }

    @Override
    public Set<String> getKeys() {
        return this.index.keySet();
    }

    @Override
    public List<IndexElement> getElements(String xpath) {
        if (xpath.endsWith("/")) {
            xpath = xpath.substring(0, xpath.length() - 1);
        }
        return this.index.computeIfAbsent(xpath, k -> new ArrayList());
    }

    public void put(String path, long start, long stop) {
        this.put(path, start, stop, -1L);
    }

    @Override
    public void put(String xpath, long start, long stop, long lineNumber) {
        if (this.xpathInclusionSet != null && !this.xpathInclusionSet.contains(xpath)) {
            return;
        }
        ByteRange element = this.recordLineNumber ? new LineNumberedByteRange(start, stop, lineNumber) : new ByteRange(start, stop, lineNumber);
        this.getElements(xpath).add(element);
    }

    @Override
    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    @Override
    public int getElementCount(String xpath) {
        if (xpath.endsWith("/")) {
            xpath = xpath.substring(0, xpath.length() - 1);
        }
        int cnt = -1;
        List<IndexElement> ranges = this.index.get(xpath);
        if (ranges != null) {
            cnt = ranges.size();
        }
        return cnt;
    }

    @Override
    public boolean containsXpath(String xpath) {
        if (xpath != null && xpath.endsWith("/")) {
            xpath = xpath.substring(0, xpath.length() - 1);
        }
        boolean result = false;
        if (this.index.containsKey(xpath) && this.index.get(xpath).size() > 0) {
            result = true;
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String key : this.index.keySet()) {
            List<IndexElement> entries = this.getElements(key);
            sb.append("xPath: ");
            sb.append(key);
            sb.append(" entries: ").append(entries.size());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String print() {
        StringBuilder sb = new StringBuilder();
        for (String key : this.index.keySet()) {
            List<IndexElement> entries = this.getElements(key);
            sb.append("xPath: ");
            sb.append(key);
            sb.append("\n");
            for (IndexElement element : entries) {
                sb.append("\tLocation : ");
                sb.append(element.getStart());
                sb.append("-");
                sb.append(element.getStop());
                sb.append(" in line: ");
                sb.append(element.getLineNumber());
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

