/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jaxb.xml;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psidev.psi.tools.xxindex.index.IndexElement;
import uk.ac.ebi.pride.jaxb.model.Admin;
import uk.ac.ebi.pride.jaxb.model.CvLookup;
import uk.ac.ebi.pride.jaxb.model.DataProcessing;
import uk.ac.ebi.pride.jaxb.model.Description;
import uk.ac.ebi.pride.jaxb.model.GelFreeIdentification;
import uk.ac.ebi.pride.jaxb.model.Identification;
import uk.ac.ebi.pride.jaxb.model.Instrument;
import uk.ac.ebi.pride.jaxb.model.Param;
import uk.ac.ebi.pride.jaxb.model.PeptideItem;
import uk.ac.ebi.pride.jaxb.model.PrideXmlObject;
import uk.ac.ebi.pride.jaxb.model.Protocol;
import uk.ac.ebi.pride.jaxb.model.Reference;
import uk.ac.ebi.pride.jaxb.model.Spectrum;
import uk.ac.ebi.pride.jaxb.model.TwoDimensionalIdentification;
import uk.ac.ebi.pride.jaxb.utils.FileUtils;
import uk.ac.ebi.pride.jaxb.xml.PrideXmlXpath;
import uk.ac.ebi.pride.jaxb.xml.adapter.SpectrumAdapter;
import uk.ac.ebi.pride.jaxb.xml.extractor.PrideXmlExtractor;
import uk.ac.ebi.pride.jaxb.xml.unmarshaller.PrideXmlUnmarshaller;
import uk.ac.ebi.pride.jaxb.xml.unmarshaller.PrideXmlUnmarshallerFactory;

public class PrideXmlReader {
    private static final Logger logger = LoggerFactory.getLogger((String)PrideXmlReader.class.getName());
    private static final Pattern ELEMENT_CONTENT_PATTERN = Pattern.compile("\\s*\\<[^\\>]+\\>([^\\<]+)\\<\\/[^\\>]+\\>\\s*");
    private PrideXmlUnmarshaller unmarshaller = null;
    private PrideXmlExtractor extractor = null;

    public PrideXmlReader(URL url) {
        this(FileUtils.getFileFromURL(url));
    }

    public PrideXmlReader(File xml) {
        if (xml == null) {
            throw new IllegalArgumentException("Xml file to be indexed must not be null");
        }
        if (!xml.exists()) {
            throw new IllegalArgumentException("Xml file to be indexed does not exist: " + xml.getAbsolutePath());
        }
        this.extractor = new PrideXmlExtractor(xml);
        this.unmarshaller = PrideXmlUnmarshallerFactory.getInstance().initializeUnmarshaller();
        this.unmarshaller.setSpectrumAdapter(new SpectrumAdapter(this.extractor));
    }

    public File getSourceFile() {
        return this.extractor.getSourceFile();
    }

    public String getVersion() {
        return this.extractor.getExpCollectionVersionString();
    }

    public String getExpAccession() {
        String expAccXml = this.extractor.getExpAccXmlString();
        return this.findByPattern(expAccXml, ELEMENT_CONTENT_PATTERN, 1);
    }

    public String getExpTitle() {
        String titleXml = this.extractor.getExpTitleXmlString();
        return this.findByPattern(titleXml, ELEMENT_CONTENT_PATTERN, 1);
    }

    public List<Reference> getReferences() {
        ArrayList<Reference> refs = new ArrayList<Reference>();
        List<String> referenceXmlStrings = this.extractor.getReferenceXmlStrings();
        for (String refXml : referenceXmlStrings) {
            refs.add((Reference)this.unmarshalXmlToPrideObject(refXml, PrideXmlXpath.EXP_REF.getClassType()));
        }
        return refs;
    }

    public String getExpShortLabel() {
        String shorLabelXml = this.extractor.getExpShortLabelXmlString();
        return this.findByPattern(shorLabelXml, ELEMENT_CONTENT_PATTERN, 1);
    }

    public Protocol getProtocol() {
        return (Protocol)this.unmarshalXmlToPrideObject(this.extractor.getProtocolXmlString(), PrideXmlXpath.EXP_PROTOCOL.getClassType());
    }

    public Param getAdditionalParams() {
        return (Param)this.unmarshalXmlToPrideObject(this.extractor.getAdditionalParamXmlString(), PrideXmlXpath.EXP_ADDITIONAL.getClassType());
    }

    public List<CvLookup> getCvLookups() {
        ArrayList<CvLookup> cvLookups = new ArrayList<CvLookup>();
        List<String> cvLookupStrings = this.extractor.getCvLookupXmlStrings();
        for (String cvLookupString : cvLookupStrings) {
            cvLookups.add((CvLookup)this.unmarshalXmlToPrideObject(cvLookupString, PrideXmlXpath.MZDATA_CVLOOKUP.getClassType()));
        }
        return cvLookups;
    }

    public Description getDescription() {
        return (Description)this.unmarshalXmlToPrideObject(this.extractor.getDescriptionXmlString(), PrideXmlXpath.MZDATA_DESC.getClassType());
    }

    public Admin getAdmin() {
        return (Admin)this.unmarshalXmlToPrideObject(this.extractor.getAdminXmlString(), PrideXmlXpath.MZDATA_DESC_AMDIN.getClassType());
    }

    public Instrument getInstrument() {
        return (Instrument)this.unmarshalXmlToPrideObject(this.extractor.getInstrumentXmlString(), PrideXmlXpath.MZDATA_DESC_INSTRUMENT.getClassType());
    }

    public DataProcessing getDataProcessing() {
        return (DataProcessing)this.unmarshalXmlToPrideObject(this.extractor.getDataProcessingXmlString(), PrideXmlXpath.MZDATA_DESC_DATAPROCESSING.getClassType());
    }

    public List<String> getSpectrumIds() {
        return this.extractor.getSpectrumIds();
    }

    public Spectrum getSpectrumById(String id) {
        return (Spectrum)this.unmarshalXmlToPrideObject(this.extractor.getSpectrumXmlString(id), PrideXmlXpath.MZDATA_SPECTRUM.getClassType());
    }

    public int getSpectrumMsLevel(String id) {
        return this.extractor.getSpectrumMsLevel(id);
    }

    public Map<String, IndexElement> getSpectrumIndices() {
        return this.extractor.getSpectrumIndices();
    }

    public boolean isIdentifiedSpectrum(String id) {
        return this.extractor.isIdentifiedSpectrum(id);
    }

    public List<String> getIdentIds() {
        return this.extractor.getIdentIds();
    }

    public Identification getIdentById(String id) {
        Identification ident = null;
        if (this.extractor.hasGelFreeIdentId(id)) {
            ident = this.getGelFreeIdentById(id);
        } else if (this.extractor.hasTwoDimIdentId(id)) {
            ident = this.getTwoDimIdentById(id);
        }
        return ident;
    }

    public List<String> getGelFreeIdentIds() {
        return this.extractor.getGelFreeIdentIds();
    }

    public GelFreeIdentification getGelFreeIdentById(String id) {
        GelFreeIdentification ident = (GelFreeIdentification)this.unmarshalXmlToPrideObject(this.extractor.getGelFreeIdentXmlString(id), PrideXmlXpath.GELFREE.getClassType());
        if (ident != null) {
            ident.setId(id);
        }
        return ident;
    }

    public List<String> getTwoDimIdentIds() {
        return this.extractor.getTwoDimIdentIds();
    }

    public TwoDimensionalIdentification getTwoDimIdentById(String id) {
        TwoDimensionalIdentification ident = (TwoDimensionalIdentification)this.unmarshalXmlToPrideObject(this.extractor.getTwoDimIdentXmlString(id), PrideXmlXpath.TWOD.getClassType());
        if (ident != null) {
            ident.setId(id);
        }
        return ident;
    }

    public int getNumberOfPeptides() {
        return this.extractor.getNumberOfPeptides();
    }

    public int getNumberOfPeptides(String identId) {
        return this.extractor.getNumberOfPeptides(identId);
    }

    public PeptideItem getPeptide(String identId, int index) {
        PeptideItem peptide = null;
        String xml = this.extractor.getPeptideXmlString(identId, index);
        if (xml != null) {
            peptide = this.unmarshalXmlToPrideObject(xml, PeptideItem.class);
        }
        return peptide;
    }

    public List<PeptideItem> getPeptides(String identId) {
        ArrayList<PeptideItem> peptides = new ArrayList<PeptideItem>();
        List<String> xmls = this.extractor.getPeptideXmlStrings(identId);
        if (xmls != null) {
            for (String xml : xmls) {
                peptides.add(this.unmarshalXmlToPrideObject(xml, PeptideItem.class));
            }
        }
        return peptides;
    }

    private <T extends PrideXmlObject> T unmarshalXmlToPrideObject(String xml, Class<T> classType) {
        try {
            return this.unmarshaller.unmarshal(xml, classType);
        }
        catch (JAXBException e) {
            logger.error("PrideXmlAccessor unmarshal xml to Pride Object" + classType, (Throwable)e);
            throw new IllegalStateException("Could not convert unmarshal xml to " + classType);
        }
    }

    private String findByPattern(String str, Pattern pattern, int matchIndex) {
        Matcher m;
        String result = null;
        if (str != null && (m = pattern.matcher(str)).find()) {
            result = m.group(matchIndex);
        }
        if (result != null) {
            result = result.trim();
        }
        return result;
    }
}

