/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jaxb.xml.unmarshaller;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import uk.ac.ebi.pride.jaxb.model.PrideXmlObject;
import uk.ac.ebi.pride.jaxb.xml.adapter.SpectrumAdapter;
import uk.ac.ebi.pride.jaxb.xml.unmarshaller.PrideXmlUnmarshaller;
import uk.ac.ebi.pride.jaxb.xml.util.EscapingXMLUtilities;

public class PrideXmlUnmarshallerFactory {
    private static final Logger logger = LoggerFactory.getLogger(PrideXmlUnmarshallerFactory.class);
    private static final PrideXmlUnmarshallerFactory instance = new PrideXmlUnmarshallerFactory();
    private static JAXBContext jc = null;

    private PrideXmlUnmarshallerFactory() {
    }

    public static PrideXmlUnmarshallerFactory getInstance() {
        return instance;
    }

    public PrideXmlUnmarshaller initializeUnmarshaller() {
        try {
            if (jc == null) {
                jc = JAXBContext.newInstance((String)"uk.ac.ebi.pride.jaxb.model");
            }
            PrideUnmarshallerImpl pum = new PrideUnmarshallerImpl();
            logger.debug("Unmarshaller Initialized");
            return pum;
        }
        catch (JAXBException e) {
            logger.error("UnmarshallerFactory.initializeUnmarshaller", (Throwable)e);
            throw new IllegalStateException("Could not initialize unmarshaller", e);
        }
    }

    static /* synthetic */ JAXBContext access$100() {
        return jc;
    }

    private class PrideUnmarshallerImpl
    implements PrideXmlUnmarshaller {
        private Unmarshaller unmarshaller = PrideXmlUnmarshallerFactory.access$100().createUnmarshaller();

        private PrideUnmarshallerImpl() throws JAXBException {
        }

        @Override
        public synchronized <T extends PrideXmlObject> T unmarshal(String xmlSnippet, Class<T> cls) throws JAXBException {
            if (xmlSnippet == null || cls == null) {
                return null;
            }
            String cleanXML = EscapingXMLUtilities.escapeCharacters(xmlSnippet);
            JAXBElement holder = this.unmarshaller.unmarshal((Source)new SAXSource(new InputSource(new StringReader(cleanXML))), cls);
            return (T)((PrideXmlObject)holder.getValue());
        }

        @Override
        public synchronized void setSpectrumAdapter(SpectrumAdapter adapter) {
            this.unmarshaller.setAdapter((XmlAdapter)adapter);
        }
    }
}

