/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.settings.PathKey;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.preferences.PeptideShakerPathParameters;
import eu.isas.peptideshaker.utils.Properties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class PeptideShakerWrapper
extends CompomicsWrapper {
    public PeptideShakerWrapper() {
        this(null);
    }

    public PeptideShakerWrapper(String[] args) {
        String jarFileName = "PeptideShaker-" + new Properties().getVersion() + ".jar";
        String path = PeptideShaker.getJarFilePath();
        File jarFile = new File(path, jarFileName);
        String splash = "peptide-shaker-splash.png";
        String mainClass = "eu.isas.peptideshaker.gui.PeptideShakerGUI";
        try {
            this.setPathConfiguration();
        }
        catch (Exception e) {
            System.out.println("Unable to load the path configurations. Default paths will be used.");
            e.printStackTrace();
        }
        try {
            ArrayList<PathKey> errorKeys = PeptideShakerPathParameters.getErrorKeys();
            if (!errorKeys.isEmpty()) {
                System.out.println("Unable to write in the following configuration folders. Please edit the configuration paths.");
                for (PathKey pathKey : errorKeys) {
                    System.out.println(pathKey.getId() + ": " + pathKey.getDescription());
                }
            }
        }
        catch (Exception e) {
            System.out.println("Unable to load the path configurations. Default pahts will be used.");
        }
        this.launchTool("PeptideShaker", jarFile, splash, mainClass, args);
    }

    private void setPathConfiguration() throws IOException {
        File pathConfigurationFile = new File(PeptideShaker.getJarFilePath(), "resources/conf/paths.txt");
        if (pathConfigurationFile.exists()) {
            PeptideShakerPathParameters.loadPathParametersFromFile(pathConfigurationFile);
        }
    }

    public static void main(String[] args) {
        new PeptideShakerWrapper(args);
    }
}

