/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.cmd;

import com.compomics.util.experiment.io.identification.MzIdentMLVersion;
import eu.isas.peptideshaker.cmd.PathSettingsCLIParams;
import org.apache.commons.cli.Options;

public enum MzidCLIParams {
    PSDB_FILE("in", "PeptideShaker project (.psdb or .zip file)", true, true),
    CONTACT_FIRST_NAME("contact_first_name", "Contact first name.", true, true),
    CONTACT_LAST_NAME("contact_last_name", "Contact last name.", true, true),
    CONTACT_EMAIL("contact_email", "Contact e-mail.", true, true),
    CONTACT_ADDRESS("contact_address", "Contact address.", true, true),
    CONTACT_URL("contact_url", "Contact URL.", true, false),
    ORGANIZATION_NAME("organization_name", "Organization name.", true, true),
    ORGANIZATION_EMAIL("organization_email", "Organization e-mail.", true, true),
    ORGANIZATION_ADDRESS("organization_address", "Organization address.", true, true),
    ORGANIZATION_URL("organization_url", "Organization URL.", true, false),
    INCLUDE_PROTEIN_SEQUENCES("include_sequences", "Include the protein sequences. 1: true, 0: false, default is '0'.", true, false),
    VERSION("mzid_version", "The mzIdentML version to use. " + MzIdentMLVersion.getCommandLineOptions() + ", default is '0'.", true, false),
    OUTPUT_FILE("output_file", "Output file.", true, true),
    GZIP("gzip", "Indicates whether the mzIdentML file should be compressed (0: no, 1: yes, default is 0).", true, false);

    public final String id;
    public final String description;
    public final boolean mandatory;
    public final boolean hasArgument;

    private MzidCLIParams(String id, String description, boolean hasArgument, boolean mandatory) {
        this.id = id;
        this.description = description;
        this.mandatory = mandatory;
        this.hasArgument = hasArgument;
    }

    public static void createOptionsCLI(Options aOptions) {
        for (MzidCLIParams mzidCLIParams : MzidCLIParams.values()) {
            aOptions.addOption(mzidCLIParams.id, mzidCLIParams.hasArgument, mzidCLIParams.description);
        }
    }

    public static String getOptionsAsString() {
        String output = "";
        String formatter = "%-35s";
        output = output + "Mandatory Parameters:\n\n";
        for (MzidCLIParams mzidCLIParams : MzidCLIParams.values()) {
            if (!mzidCLIParams.mandatory) continue;
            output = output + "-" + String.format(formatter, mzidCLIParams.id) + " " + mzidCLIParams.description + "\n";
        }
        output = output + "\n\nOptional Annotation Parameters:\n";
        for (MzidCLIParams mzidCLIParams : MzidCLIParams.values()) {
            if (mzidCLIParams.mandatory) continue;
            output = output + "-" + String.format(formatter, mzidCLIParams.id) + " " + mzidCLIParams.description + "\n";
        }
        output = output + "\nCompression:\n\n";
        output = output + "-" + String.format(formatter, MzidCLIParams.GZIP.id) + MzidCLIParams.GZIP.description + "\n";
        output = output + "\n\nOptional Temporary Folder:\n";
        output = output + "-" + String.format(formatter, PathSettingsCLIParams.ALL.id) + " " + PathSettingsCLIParams.ALL.description + "\n";
        return output;
    }
}

