/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.cmd;

import com.compomics.software.cli.CommandLineUtils;
import eu.isas.peptideshaker.cmd.PathSettingsCLIInputBean;
import eu.isas.peptideshaker.cmd.ReportCLIParams;
import eu.isas.peptideshaker.export.PSExportFactory;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;

public class ReportCLIInputBean {
    private File psdbFile = null;
    private File zipFile = null;
    private File reportOutputFolder = null;
    private String reportNamePrefix = null;
    private boolean gzip = false;
    private final ArrayList<String> reportTypes = new ArrayList();
    private final ArrayList<String> documentationTypes = new ArrayList();
    private final PathSettingsCLIInputBean pathSettingsCLIInputBean;

    public ReportCLIInputBean(CommandLine aLine) {
        PSExportFactory exportFactory;
        ArrayList<Integer> options;
        if (aLine.hasOption(ReportCLIParams.PSDB_FILE.id)) {
            String file = aLine.getOptionValue(ReportCLIParams.PSDB_FILE.id);
            if (file.toLowerCase().endsWith(".psdb")) {
                this.psdbFile = new File(file);
            } else if (file.toLowerCase().endsWith(".zip")) {
                this.zipFile = new File(file);
            } else {
                throw new IllegalArgumentException("Unknown file format '" + file + "' for PeptideShaker project input.");
            }
        }
        if (aLine.hasOption(ReportCLIParams.EXPORT_FOLDER.id)) {
            this.reportOutputFolder = new File(aLine.getOptionValue(ReportCLIParams.EXPORT_FOLDER.id));
        }
        if (aLine.hasOption(ReportCLIParams.EXPORT_PREFIX.id)) {
            this.reportNamePrefix = aLine.getOptionValue(ReportCLIParams.EXPORT_PREFIX.id);
        }
        if (aLine.hasOption(ReportCLIParams.REPORT_TYPE.id)) {
            options = CommandLineUtils.getIntegerListFromString(aLine.getOptionValue(ReportCLIParams.REPORT_TYPE.id), ",");
            exportFactory = PSExportFactory.getInstance();
            for (int option : options) {
                this.reportTypes.add(exportFactory.getExportTypeFromCommandLineOption(option));
            }
        }
        if (aLine.hasOption(ReportCLIParams.DOCUMENTATION_TYPE.id)) {
            options = CommandLineUtils.getIntegerListFromString(aLine.getOptionValue(ReportCLIParams.DOCUMENTATION_TYPE.id), ",");
            exportFactory = PSExportFactory.getInstance();
            for (int option : options) {
                this.documentationTypes.add(exportFactory.getExportTypeFromCommandLineOption(option));
            }
        }
        if (aLine.hasOption(ReportCLIParams.GZIP.id)) {
            String input = aLine.getOptionValue(ReportCLIParams.GZIP.id);
            int index = Integer.parseInt(input.trim());
            this.gzip = index == 1;
        }
        this.pathSettingsCLIInputBean = new PathSettingsCLIInputBean(aLine);
    }

    public File getPsdbFile() {
        return this.psdbFile;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    public File getReportOutputFolder() {
        return this.reportOutputFolder;
    }

    public void setReportOutputFolder(File outputFolder) {
        this.reportOutputFolder = outputFolder;
    }

    public String getReportNamePrefix() {
        return this.reportNamePrefix;
    }

    public void setReportNamePrefix(String reportNamePrefix) {
        this.reportNamePrefix = reportNamePrefix;
    }

    public ArrayList<String> getReportTypes() {
        return this.reportTypes;
    }

    public ArrayList<String> getDocumentationTypes() {
        return this.documentationTypes;
    }

    public boolean exportNeeded() {
        return this.reportExportNeeded() || this.documentationExportNeeded();
    }

    public boolean reportExportNeeded() {
        return !this.reportTypes.isEmpty();
    }

    public boolean documentationExportNeeded() {
        return !this.documentationTypes.isEmpty();
    }

    public PathSettingsCLIInputBean getPathSettingsCLIInputBean() {
        return this.pathSettingsCLIInputBean;
    }

    public boolean isGzip() {
        return this.gzip;
    }
}

