/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.cmd;

import eu.isas.peptideshaker.cmd.StirredOptions;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;

public class StirredOptionsBean {
    public final File inputFile;
    public File spectrumFile = null;
    public File fastaFile = null;
    public File identificationParametersFile = null;
    public final File tempFolder;
    public final File logFile;
    public int nThreads = Runtime.getRuntime().availableProcessors();
    public int timeOutDays = 365;
    public final File outputFolder;
    public String contactFirstName = "Unknown";
    public String contactLastName = "Unknown";
    public String contactAddress = "Unknown";
    public String contactEmail = "Unknown";
    public String contactOrganizationName = "Unknown";
    public String contactOrganizationAddress = "Unknown";
    public String contactOrganizationEmail = "Unknown";

    public StirredOptionsBean(CommandLine aLine) throws IOException {
        for (StirredOptions option : StirredOptions.values()) {
            if (!option.mandatory || StirredOptionsBean.hasOption(aLine, option)) continue;
            throw new IllegalArgumentException("No value found for mandatory option " + option.opt + " (" + option.longOpt + ").");
        }
        String arg = StirredOptionsBean.getOptionValue(aLine, StirredOptions.input);
        this.inputFile = new File(arg);
        if (StirredOptionsBean.hasOption(aLine, StirredOptions.spectrum)) {
            arg = StirredOptionsBean.getOptionValue(aLine, StirredOptions.spectrum);
            this.spectrumFile = new File(arg);
        }
        if (StirredOptionsBean.hasOption(aLine, StirredOptions.fasta)) {
            arg = StirredOptionsBean.getOptionValue(aLine, StirredOptions.fasta);
            this.fastaFile = new File(arg);
        }
        if (StirredOptionsBean.hasOption(aLine, StirredOptions.identificationParametersFile)) {
            arg = StirredOptionsBean.getOptionValue(aLine, StirredOptions.identificationParametersFile);
            this.identificationParametersFile = new File(arg);
        }
        arg = StirredOptionsBean.getOptionValue(aLine, StirredOptions.output);
        this.outputFolder = new File(arg);
        if (!this.outputFolder.exists()) {
            throw new IllegalArgumentException("Output folder '" + this.outputFolder + "' not found.");
        }
        if (!this.outputFolder.isDirectory()) {
            throw new IllegalArgumentException("Output folder '" + this.outputFolder + "' must be a directory.");
        }
        if (StirredOptionsBean.hasOption(aLine, StirredOptions.log)) {
            arg = StirredOptionsBean.getOptionValue(aLine, StirredOptions.log);
            this.logFile = new File(arg);
        } else {
            this.logFile = new File(this.outputFolder, this.inputFile.getName() + ".stirred.log");
        }
        if (StirredOptionsBean.hasOption(aLine, StirredOptions.tempFolder)) {
            arg = StirredOptionsBean.getOptionValue(aLine, StirredOptions.tempFolder);
            this.tempFolder = new File(arg);
            if (!this.tempFolder.exists()) {
                this.tempFolder.mkdir();
            }
        } else {
            this.tempFolder = this.outputFolder;
        }
        if (StirredOptionsBean.hasOption(aLine, StirredOptions.nThreads)) {
            String argString = StirredOptionsBean.getOptionValue(aLine, StirredOptions.nThreads);
            try {
                this.nThreads = Integer.parseInt(argString);
                if (this.nThreads <= 0) {
                    throw new IllegalArgumentException("Input for number of threads must be a strictly positive number.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Input for number of threads could not be parsed as a number: " + argString + ".");
            }
        }
        if (StirredOptionsBean.hasOption(aLine, StirredOptions.timeOutDays)) {
            String argString = StirredOptionsBean.getOptionValue(aLine, StirredOptions.timeOutDays);
            try {
                this.timeOutDays = Integer.parseInt(argString);
                if (this.timeOutDays <= 0) {
                    throw new IllegalArgumentException("Input for timeout must be a strictly positive number.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Input for timeout could not be parsed as a number: " + argString + ".");
            }
        }
        if (StirredOptionsBean.hasOption(aLine, StirredOptions.contactFirstName)) {
            this.contactFirstName = StirredOptionsBean.getOptionValue(aLine, StirredOptions.contactFirstName);
        }
        if (StirredOptionsBean.hasOption(aLine, StirredOptions.contactLastName)) {
            this.contactLastName = StirredOptionsBean.getOptionValue(aLine, StirredOptions.contactLastName);
        }
        if (StirredOptionsBean.hasOption(aLine, StirredOptions.contactAddress)) {
            this.contactAddress = StirredOptionsBean.getOptionValue(aLine, StirredOptions.contactAddress);
        }
        if (StirredOptionsBean.hasOption(aLine, StirredOptions.contactEmail)) {
            this.contactEmail = StirredOptionsBean.getOptionValue(aLine, StirredOptions.contactEmail);
        }
        if (StirredOptionsBean.hasOption(aLine, StirredOptions.contactOrganizationName)) {
            this.contactOrganizationName = StirredOptionsBean.getOptionValue(aLine, StirredOptions.contactOrganizationName);
        }
        if (StirredOptionsBean.hasOption(aLine, StirredOptions.contactOrganizationAddress)) {
            this.contactOrganizationAddress = StirredOptionsBean.getOptionValue(aLine, StirredOptions.contactOrganizationAddress);
        }
        if (StirredOptionsBean.hasOption(aLine, StirredOptions.contactOrganizationEmail)) {
            this.contactOrganizationEmail = StirredOptionsBean.getOptionValue(aLine, StirredOptions.contactOrganizationEmail);
        }
    }

    private static boolean hasOption(CommandLine commandLine, StirredOptions option) {
        return commandLine.hasOption(option.opt) || commandLine.hasOption(option.longOpt);
    }

    private static String getOptionValue(CommandLine commandLine, StirredOptions option) {
        if (commandLine.hasOption(option.opt)) {
            return commandLine.getOptionValue(option.opt);
        }
        if (commandLine.hasOption(option.longOpt)) {
            return commandLine.getOptionValue(option.longOpt);
        }
        return null;
    }
}

