/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.export;

import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.compression.ZipUtils;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipOutputStream;

public class ProjectExport {
    public static final String DEFAULT_DATA_FOLDER = "data";
    public static final String DEFAULT_REPORTS_FOLDER = "reports";

    public static void exportProjectAsZip(File zipFile, File fastaFile, SpectrumProvider spectrumProvider, File psdbFile, boolean moveFilesIntoZip, WaitingHandler waitingHandler) throws IOException {
        ProjectExport.exportProjectAsZip(zipFile, fastaFile, spectrumProvider, null, null, null, psdbFile, moveFilesIntoZip, waitingHandler);
    }

    public static void exportProjectAsZip(File zipFile, File fastaFile, SpectrumProvider spectrumProvider, ArrayList<File> followupAnalysisFiles, ArrayList<File> reportFiles, File mzidFile, File psdbFile, boolean moveFilesIntoZip, WaitingHandler waitingHandler) throws IOException {
        if (waitingHandler != null) {
            waitingHandler.setWaitingText("Getting FASTA File. Please Wait...");
        }
        ArrayList<String> dataFiles = new ArrayList<String>(2 * spectrumProvider.getOrderedFileNamesWithoutExtensions().length + 2);
        dataFiles.add(fastaFile.getAbsolutePath());
        String fastaExtension = IoUtil.getExtension(fastaFile);
        File FMFile = new File(fastaFile.getAbsolutePath().replace(fastaExtension, ".fmi"));
        dataFiles.add(FMFile.getAbsolutePath());
        if (waitingHandler != null) {
            waitingHandler.setWaitingText("Getting Spectrum Files. Please Wait...");
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setSecondaryProgressCounter(0);
            waitingHandler.setMaxSecondaryProgressCounter(spectrumProvider.getOrderedFileNamesWithoutExtensions().length);
        }
        for (String fileName : spectrumProvider.getOrderedFileNamesWithoutExtensions()) {
            String cmsFilePath = spectrumProvider.getCmsFilePaths().get(fileName);
            File cmsFile = new File(cmsFilePath);
            if (!cmsFile.exists()) continue;
            dataFiles.add(cmsFilePath);
        }
        for (String fileName : spectrumProvider.getOrderedFileNamesWithoutExtensions()) {
            String msFilePath = spectrumProvider.getFilePaths().get(fileName);
            File msFile = new File(msFilePath);
            if (IoUtil.getExtension(msFile).equals(".cms") || !msFile.exists()) continue;
            dataFiles.add(msFilePath);
        }
        if (waitingHandler != null) {
            waitingHandler.setWaitingText("Zipping Project. Please Wait...");
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
            if (waitingHandler.isRunCanceled()) {
                return;
            }
        }
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            long totalUncompressedSize = 0L;
            if (psdbFile != null) {
                totalUncompressedSize += psdbFile.length();
            }
            for (String dataFilePath : dataFiles) {
                totalUncompressedSize += new File(dataFilePath).length();
            }
            if (followupAnalysisFiles != null) {
                for (File followupReportFile : followupAnalysisFiles) {
                    totalUncompressedSize += followupReportFile.length();
                }
            }
            if (reportFiles != null) {
                for (File reportFile : reportFiles) {
                    totalUncompressedSize += reportFile.length();
                }
            }
            if (mzidFile != null) {
                totalUncompressedSize += mzidFile.length();
            }
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                waitingHandler.setSecondaryProgressCounter(0);
                waitingHandler.setMaxSecondaryProgressCounter(100);
            }
            if (reportFiles != null && reportFiles.size() > 0) {
                ZipUtils.addFolderToZip(DEFAULT_REPORTS_FOLDER, out);
                for (File reportFile : reportFiles) {
                    if (waitingHandler != null) {
                        if (waitingHandler.isRunCanceled()) {
                            return;
                        }
                        waitingHandler.increaseSecondaryProgressCounter();
                    }
                    ZipUtils.addFileToZip(DEFAULT_REPORTS_FOLDER, reportFile, out, waitingHandler, totalUncompressedSize);
                    if (!moveFilesIntoZip) continue;
                    reportFile.delete();
                }
            }
            if (followupAnalysisFiles != null && followupAnalysisFiles.size() > 0) {
                if (reportFiles == null || reportFiles.isEmpty()) {
                    ZipUtils.addFolderToZip(DEFAULT_REPORTS_FOLDER, out);
                }
                for (File followupAnalysisFile : followupAnalysisFiles) {
                    if (waitingHandler != null) {
                        if (waitingHandler.isRunCanceled()) {
                            return;
                        }
                        waitingHandler.increaseSecondaryProgressCounter();
                    }
                    ZipUtils.addFileToZip(DEFAULT_REPORTS_FOLDER, followupAnalysisFile, out, waitingHandler, totalUncompressedSize);
                    if (!moveFilesIntoZip) continue;
                    followupAnalysisFile.delete();
                }
            }
            ZipUtils.addFolderToZip(DEFAULT_DATA_FOLDER, out);
            for (String dataFilePath : dataFiles) {
                if (waitingHandler != null) {
                    if (waitingHandler.isRunCanceled()) {
                        return;
                    }
                    waitingHandler.increaseSecondaryProgressCounter();
                }
                File dataFile = new File(dataFilePath);
                ZipUtils.addFileToZip(DEFAULT_DATA_FOLDER, dataFile, out, waitingHandler, totalUncompressedSize);
            }
            if (mzidFile != null) {
                if (waitingHandler != null) {
                    if (waitingHandler.isRunCanceled()) {
                        return;
                    }
                    waitingHandler.increaseSecondaryProgressCounter();
                }
                ZipUtils.addFileToZip(mzidFile, out, waitingHandler, totalUncompressedSize);
                if (moveFilesIntoZip) {
                    mzidFile.delete();
                }
            }
            if (psdbFile != null) {
                ZipUtils.addFileToZip(psdbFile, out, waitingHandler, totalUncompressedSize);
                if (moveFilesIntoZip) {
                    psdbFile.delete();
                }
            }
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressCounterIndeterminate(true);
            }
        }
    }
}

