/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.export.sections;

import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.TagSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.features.peptideshaker.PsFragmentFeature;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;

public class PsFragmentSection {
    private final EnumSet<PsFragmentFeature> fragmentFeatures;
    private final boolean indexes;
    private final boolean header;
    private final ExportWriter writer;

    public PsFragmentSection(ArrayList<ExportFeature> exportFeatures, boolean indexes, boolean header, ExportWriter writer) {
        this.indexes = indexes;
        this.header = header;
        this.writer = writer;
        this.fragmentFeatures = EnumSet.noneOf(PsFragmentFeature.class);
        for (ExportFeature exportFeature : exportFeatures) {
            if (exportFeature instanceof PsFragmentFeature) {
                PsFragmentFeature fragmentFeature = (PsFragmentFeature)exportFeature;
                this.fragmentFeatures.add(fragmentFeature);
                continue;
            }
            throw new IllegalArgumentException("Impossible to export " + exportFeature.getClass().getName() + " as fragment feature.");
        }
    }

    public void writeSection(String spectrumFile, String spectrumTitle, SpectrumIdentificationAssumption spectrumIdentificationAssumption, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, IdentificationParameters identificationParameters, String linePrefix, WaitingHandler waitingHandler) throws IOException {
        IonMatch[] annotations;
        SpecificAnnotationParameters specificAnnotationParameters;
        SpectrumAnnotator spectrumAnnotator;
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        if (this.header) {
            this.writeHeader();
        }
        Spectrum spectrum = spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
        AnnotationParameters annotationParameters = identificationParameters.getAnnotationParameters();
        ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
        SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
        if (spectrumIdentificationAssumption instanceof PeptideAssumption) {
            PeptideAssumption peptideAssumption = (PeptideAssumption)spectrumIdentificationAssumption;
            spectrumAnnotator = new PeptideSpectrumAnnotator();
            specificAnnotationParameters = annotationParameters.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, spectrumIdentificationAssumption, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, spectrumAnnotator);
            annotations = ((PeptideSpectrumAnnotator)spectrumAnnotator).getSpectrumAnnotation(annotationParameters, specificAnnotationParameters, spectrumFile, spectrumTitle, spectrum, peptideAssumption.getPeptide(), modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
        } else if (spectrumIdentificationAssumption instanceof TagAssumption) {
            TagAssumption tagAssumption = (TagAssumption)spectrumIdentificationAssumption;
            spectrumAnnotator = new TagSpectrumAnnotator();
            specificAnnotationParameters = annotationParameters.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, spectrumIdentificationAssumption, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, spectrumAnnotator);
            annotations = ((TagSpectrumAnnotator)spectrumAnnotator).getSpectrumAnnotation(annotationParameters, modificationParameters, modificationSequenceMatchingParameters, specificAnnotationParameters, spectrumFile, spectrumTitle, spectrum, tagAssumption.getTag());
        } else {
            throw new UnsupportedOperationException("Export not implemented for spectrum identification of type " + spectrumIdentificationAssumption.getClass() + ".");
        }
        TreeMap sortedAnnotation = new TreeMap();
        for (SpectrumAnnotator spectrumAnnotator2 : annotations) {
            double mz = ((IonMatch)((Object)spectrumAnnotator2)).peakMz;
            if (!sortedAnnotation.containsKey(mz)) {
                sortedAnnotation.put(mz, new ArrayList(1));
            }
            ((ArrayList)sortedAnnotation.get(mz)).add(spectrumAnnotator2);
        }
        int line = 1;
        if (waitingHandler != null) {
            waitingHandler.setWaitingText("Exporting. Please Wait...");
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(annotations.length);
        }
        for (Map.Entry entry : sortedAnnotation.entrySet()) {
            for (IonMatch ionMatch : (ArrayList)entry.getValue()) {
                if (waitingHandler != null) {
                    if (waitingHandler.isRunCanceled()) {
                        return;
                    }
                    waitingHandler.increaseSecondaryProgressCounter();
                }
                if (this.indexes) {
                    if (linePrefix != null) {
                        this.writer.write(linePrefix);
                    }
                    this.writer.write(Integer.toString(line));
                    this.writer.addSeparator();
                }
                for (PsFragmentFeature fragmentFeature : this.fragmentFeatures) {
                    switch (fragmentFeature) {
                        case annotation: {
                            this.writer.write(ionMatch.getPeakAnnotation());
                            break;
                        }
                        case fragment_type: {
                            this.writer.write(Ion.getTypeAsString(ionMatch.ion.getType()));
                            break;
                        }
                        case fragment_subType: {
                            this.writer.write(ionMatch.ion.getSubTypeAsString());
                            break;
                        }
                        case fragment_number: {
                            Ion ion = ionMatch.ion;
                            if (ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) break;
                            this.writer.write(Integer.toString(((PeptideFragmentIon)ion).getNumber()));
                            break;
                        }
                        case fragment_losses: {
                            this.writer.write(ionMatch.ion.getNeutralLossesAsString());
                            break;
                        }
                        case fragment_name: {
                            Ion ion = ionMatch.ion;
                            String name = ion.getType() == Ion.IonType.PEPTIDE_FRAGMENT_ION ? ((PeptideFragmentIon)ion).getNameWithNumber() : ion.getName();
                            this.writer.write(name);
                            break;
                        }
                        case fragment_charge: {
                            this.writer.write(Integer.toString(ionMatch.charge));
                            break;
                        }
                        case theoretic_mz: {
                            this.writer.write(Double.toString(ionMatch.ion.getTheoreticMz(ionMatch.charge)));
                            break;
                        }
                        case mz: {
                            this.writer.write(Double.toString(ionMatch.peakMz));
                            break;
                        }
                        case intensity: {
                            this.writer.write(Double.toString(ionMatch.peakIntensity));
                            break;
                        }
                        case error_Da: {
                            this.writer.write(Double.toString(ionMatch.getAbsoluteError()));
                            break;
                        }
                        case error_ppm: {
                            this.writer.write(Double.toString(ionMatch.getRelativeError()));
                            break;
                        }
                        default: {
                            this.writer.write("Not implemented");
                        }
                    }
                    this.writer.addSeparator();
                }
                this.writer.newLine();
                ++line;
            }
        }
    }

    public void writeHeader() throws IOException {
        if (this.indexes) {
            this.writer.writeHeaderText("");
            this.writer.addSeparator();
        }
        boolean firstColumn = true;
        for (PsFragmentFeature fragmentFeature : this.fragmentFeatures) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                this.writer.addSeparator();
            }
            this.writer.writeHeaderText(fragmentFeature.getTitle());
        }
        this.writer.newLine();
    }
}

