/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.export.sections;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.features.peptideshaker.PsFragmentFeature;
import com.compomics.util.io.export.features.peptideshaker.PsIdentificationAlgorithmMatchesFeature;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.export.sections.PsFragmentSection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PsIdentificationAlgorithmMatchesSection {
    private final EnumSet<PsIdentificationAlgorithmMatchesFeature> matchExportFeatures = EnumSet.noneOf(PsIdentificationAlgorithmMatchesFeature.class);
    private PsFragmentSection fragmentSection = null;
    private final boolean indexes;
    private final boolean header;
    private final ExportWriter writer;
    private static final PeptideSpectrumAnnotator peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();

    public PsIdentificationAlgorithmMatchesSection(ArrayList<ExportFeature> exportFeatures, boolean indexes, boolean header, ExportWriter writer) {
        ArrayList<ExportFeature> fragmentFeatures = new ArrayList<ExportFeature>(0);
        for (ExportFeature exportFeature : exportFeatures) {
            if (exportFeature instanceof PsIdentificationAlgorithmMatchesFeature) {
                PsIdentificationAlgorithmMatchesFeature identificationAlgorithmMatchesFeature = (PsIdentificationAlgorithmMatchesFeature)exportFeature;
                this.matchExportFeatures.add(identificationAlgorithmMatchesFeature);
                continue;
            }
            if (exportFeature instanceof PsFragmentFeature) {
                fragmentFeatures.add(exportFeature);
                continue;
            }
            throw new IllegalArgumentException("Export feature of type " + exportFeature.getClass() + " not recognized.");
        }
        if (!fragmentFeatures.isEmpty()) {
            this.fragmentSection = new PsFragmentSection(fragmentFeatures, indexes, header, writer);
        }
        this.indexes = indexes;
        this.header = header;
        this.writer = writer;
    }

    /*
     * Could not resolve type clashes
     */
    public void writeSection(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider, IdentificationParameters identificationParameters, long[] keys, String linePrefix, int nSurroundingAA, WaitingHandler waitingHandler) throws IOException {
        SpectrumMatch spectrumMatch;
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        if (this.header) {
            this.writeHeader();
        }
        PSParameter psParameter = new PSParameter();
        int line = 1;
        int totalSize = identification.getNumber(SpectrumMatch.class);
        if (waitingHandler != null) {
            waitingHandler.setWaitingText("Exporting. Please Wait...");
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(totalSize);
        }
        SpectrumMatchesIterator psmIterator = identification.getSpectrumMatchesIterator(waitingHandler);
        while ((spectrumMatch = psmIterator.next()) != null) {
            if (waitingHandler != null) {
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                waitingHandler.increaseSecondaryProgressCounter();
            }
            HashMap<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> peptideAssumptions = spectrumMatch.getPeptideAssumptionsMap();
            for (int advocateId : peptideAssumptions.keySet()) {
                TreeMap<Double, ArrayList<PeptideAssumption>> advocateAssumptions = peptideAssumptions.get(advocateId);
                ArrayList<Double> scores = new ArrayList<Double>(advocateAssumptions.keySet());
                Collections.sort(scores);
                for (double score : scores) {
                    for (SpectrumIdentificationAssumption assumption : advocateAssumptions.get(score)) {
                        boolean firstFeature = true;
                        if (this.indexes) {
                            if (linePrefix != null) {
                                this.writer.write(linePrefix);
                            }
                            this.writer.write(Integer.toString(line));
                            firstFeature = false;
                        }
                        for (Object identificationAlgorithmMatchesFeature : this.matchExportFeatures) {
                            if (!firstFeature) {
                                this.writer.addSeparator();
                            } else {
                                firstFeature = false;
                            }
                            psParameter = (PSParameter)assumption.getUrParam(psParameter);
                            PeptideAssumption peptideAssumption = (PeptideAssumption)assumption;
                            String feature = PsIdentificationAlgorithmMatchesSection.getPeptideAssumptionFeature(identification, identificationFeaturesGenerator, sequenceProvider, proteinDetailsProvider, spectrumProvider, identificationParameters, linePrefix, nSurroundingAA, peptideAssumption, spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle(), psParameter, (PsIdentificationAlgorithmMatchesFeature)identificationAlgorithmMatchesFeature, waitingHandler);
                            this.writer.write(feature);
                        }
                        this.writer.addSeparator();
                        if (this.fragmentSection != null) {
                            String fractionPrefix = "";
                            if (linePrefix != null) {
                                fractionPrefix = fractionPrefix + linePrefix;
                            }
                            fractionPrefix = fractionPrefix + line + ".";
                            this.fragmentSection.writeSection(spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle(), assumption, sequenceProvider, spectrumProvider, identificationParameters, fractionPrefix, null);
                        }
                        ++line;
                        this.writer.newLine();
                    }
                }
            }
            HashMap<Integer, TreeMap<Double, ArrayList<TagAssumption>>> tagAssumptions = spectrumMatch.getTagAssumptionsMap();
            for (int advocateId : tagAssumptions.keySet()) {
                TreeMap<Double, ArrayList<TagAssumption>> advocateAssumptions = tagAssumptions.get(advocateId);
                ArrayList<Double> scores = new ArrayList<Double>(advocateAssumptions.keySet());
                Collections.sort(scores);
                for (double score : scores) {
                    for (SpectrumIdentificationAssumption assumption : advocateAssumptions.get(score)) {
                        Object identificationAlgorithmMatchesFeature;
                        boolean firstFeature = true;
                        if (this.indexes) {
                            if (linePrefix != null) {
                                this.writer.write(linePrefix);
                            }
                            this.writer.write(Integer.toString(line));
                            firstFeature = false;
                        }
                        identificationAlgorithmMatchesFeature = this.matchExportFeatures.iterator();
                        while (identificationAlgorithmMatchesFeature.hasNext()) {
                            PsIdentificationAlgorithmMatchesFeature identificationAlgorithmMatchesFeature2 = (PsIdentificationAlgorithmMatchesFeature)identificationAlgorithmMatchesFeature.next();
                            if (!firstFeature) {
                                this.writer.addSeparator();
                            } else {
                                firstFeature = false;
                            }
                            psParameter = (PSParameter)assumption.getUrParam(psParameter);
                            TagAssumption tagAssumption = (TagAssumption)assumption;
                            String feature = PsIdentificationAlgorithmMatchesSection.getTagAssumptionFeature(identification, identificationFeaturesGenerator, spectrumProvider, identificationParameters, linePrefix, tagAssumption, spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle(), psParameter, identificationAlgorithmMatchesFeature2, waitingHandler);
                            this.writer.write(feature);
                        }
                        this.writer.addSeparator();
                        if (this.fragmentSection != null) {
                            String fractionPrefix = "";
                            if (linePrefix != null) {
                                fractionPrefix = fractionPrefix + linePrefix;
                            }
                            fractionPrefix = fractionPrefix + line + ".";
                            this.fragmentSection.writeSection(spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle(), assumption, sequenceProvider, spectrumProvider, identificationParameters, fractionPrefix, null);
                        }
                        ++line;
                        this.writer.newLine();
                    }
                }
            }
        }
    }

    private static TreeMap<String, TreeSet<Integer>> getModMap(Peptide peptide, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationSequenceMatchingParameters, boolean variablePtms) {
        if (variablePtms) {
            ModificationMatch[] modificationMatches = peptide.getVariableModifications();
            return modificationMatches == null ? new TreeMap() : Arrays.stream(modificationMatches).collect(Collectors.groupingBy(ModificationMatch::getModification, TreeMap::new, Collectors.mapping(ModificationMatch::getSite, Collectors.toCollection(TreeSet::new))));
        }
        final String[] fixedModifications = peptide.getFixedModifications(modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
        return IntStream.range(0, fixedModifications.length).mapToObj(i -> new Object(){
            Integer position;
            String modification;
            {
                this.position = i;
                this.modification = fixedModifications[i];
            }
        }).filter(obj -> obj.modification != null).collect(Collectors.groupingBy(obj -> obj.modification, TreeMap::new, Collectors.mapping(obj -> obj.position, Collectors.toCollection(TreeSet::new))));
    }

    public void writeHeader() throws IOException {
        if (this.indexes) {
            this.writer.writeHeaderText("");
            this.writer.addSeparator();
        }
        boolean firstColumn = true;
        for (PsIdentificationAlgorithmMatchesFeature identificationAlgorithmMatchesFeature : this.matchExportFeatures) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                this.writer.addSeparator();
            }
            this.writer.writeHeaderText(identificationAlgorithmMatchesFeature.getTitle());
        }
        this.writer.newLine();
    }

    public static String getPeptideAssumptionFeature(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider, IdentificationParameters identificationParameters, String linePrefix, int nSurroundingAA, PeptideAssumption peptideAssumption, String spectrumFile, String spectrumTitle, PSParameter psParameter, PsIdentificationAlgorithmMatchesFeature exportFeature, WaitingHandler waitingHandler) {
        switch (exportFeature) {
            case rank: {
                return Integer.toString(peptideAssumption.getRank());
            }
            case variable_ptms: {
                ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                TreeMap<String, TreeSet<Integer>> modMap = PsIdentificationAlgorithmMatchesSection.getModMap(peptideAssumption.getPeptide(), modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, true);
                return modMap.entrySet().stream().map(entry -> PsIdentificationAlgorithmMatchesSection.getModificationAsString((String)entry.getKey(), (TreeSet)entry.getValue())).collect(Collectors.joining(";"));
            }
            case fixed_ptms: {
                ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                TreeMap<String, TreeSet<Integer>> modMap = PsIdentificationAlgorithmMatchesSection.getModMap(peptideAssumption.getPeptide(), modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, false);
                return modMap.entrySet().stream().map(entry -> PsIdentificationAlgorithmMatchesSection.getModificationAsString((String)entry.getKey(), (TreeSet)entry.getValue())).collect(Collectors.joining(";"));
            }
            case accessions: {
                TreeMap<String, int[]> proteinMapping = peptideAssumption.getPeptide().getProteinMapping();
                return proteinMapping.navigableKeySet().stream().collect(Collectors.joining(","));
            }
            case protein_description: {
                TreeMap<String, int[]> proteinMapping = peptideAssumption.getPeptide().getProteinMapping();
                return proteinMapping.navigableKeySet().stream().map(accession -> proteinDetailsProvider.getDescription((String)accession)).collect(Collectors.joining(","));
            }
            case algorithm_confidence: {
                return Double.toString(psParameter.getConfidence());
            }
            case algorithm_delta_confidence: {
                Double delta = psParameter.getAlgorithmDeltaPEP();
                return delta == null ? "Not available" : Double.toString(100.0 * delta);
            }
            case delta_confidence: {
                Double delta = psParameter.getDeltaPEP();
                return Double.toString(100.0 * delta);
            }
            case decoy: {
                return PeptideUtils.isDecoy(peptideAssumption.getPeptide(), sequenceProvider) ? "1" : "0";
            }
            case hidden: {
                return psParameter.getHidden() ? "1" : "0";
            }
            case identification_charge: {
                return Integer.toString(peptideAssumption.getIdentificationCharge());
            }
            case isotope: {
                double precursorMz = spectrumProvider.getPrecursorMz(spectrumFile, spectrumTitle);
                return Integer.toString(peptideAssumption.getIsotopeNumber(precursorMz, identificationParameters.getSearchParameters().getMinIsotopicCorrection(), identificationParameters.getSearchParameters().getMaxIsotopicCorrection()));
            }
            case mz: {
                double precursorMz = spectrumProvider.getPrecursorMz(spectrumFile, spectrumTitle);
                return Double.toString(precursorMz);
            }
            case total_spectrum_intensity: {
                Spectrum spectrum = spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
                return Double.toString(spectrum.getTotalIntensity());
            }
            case max_intensity: {
                Spectrum spectrum = spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
                return Double.toString(spectrum.getMaxIntensity());
            }
            case intensity_coverage: {
                Spectrum spectrum = spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
                Peptide peptide = peptideAssumption.getPeptide();
                AnnotationParameters annotationParameters = identificationParameters.getAnnotationParameters();
                ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                SpecificAnnotationParameters specificAnnotationParameters = annotationParameters.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, peptideAssumption, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, peptideSpectrumAnnotator);
                IonMatch[] matches = peptideSpectrumAnnotator.getSpectrumAnnotation(annotationParameters, specificAnnotationParameters, spectrumFile, spectrumTitle, spectrum, peptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
                double coveredIntensity = Arrays.stream(matches).mapToDouble(ionMatch -> ionMatch.peakIntensity).sum();
                double coverage = 100.0 * coveredIntensity / spectrum.getTotalIntensity();
                return Double.toString(coverage);
            }
            case mz_error_ppm: {
                double precursorMz = spectrumProvider.getPrecursorMz(spectrumFile, spectrumTitle);
                return Double.toString(peptideAssumption.getDeltaMz(precursorMz, true, identificationParameters.getSearchParameters().getMinIsotopicCorrection(), identificationParameters.getSearchParameters().getMaxIsotopicCorrection()));
            }
            case mz_error_da: {
                double precursorMz = spectrumProvider.getPrecursorMz(spectrumFile, spectrumTitle);
                return Double.toString(peptideAssumption.getDeltaMz(precursorMz, false, identificationParameters.getSearchParameters().getMinIsotopicCorrection(), identificationParameters.getSearchParameters().getMaxIsotopicCorrection()));
            }
            case rt: {
                double precursorRt = spectrumProvider.getPrecursorRt(spectrumFile, spectrumTitle);
                return Double.toString(precursorRt);
            }
            case algorithm_raw_score: {
                int id = peptideAssumption.getAdvocate();
                double score = peptideAssumption.getRawScore();
                return String.join((CharSequence)"", Advocate.getAdvocate(id).getName(), " (", Double.toString(score), ")");
            }
            case algorithm_score: {
                int id = peptideAssumption.getAdvocate();
                double score = peptideAssumption.getScore();
                return String.join((CharSequence)"", Advocate.getAdvocate(id).getName(), " (", Double.toString(score), ")");
            }
            case sequence: {
                return peptideAssumption.getPeptide().getSequence();
            }
            case aaBefore: {
                TreeMap<String, String[]> aaMap = PeptideUtils.getAaBefore(peptideAssumption.getPeptide(), nSurroundingAA, sequenceProvider);
                return aaMap.values().stream().map(aas -> Arrays.stream(aas).collect(Collectors.joining(","))).collect(Collectors.joining(";"));
            }
            case aaAfter: {
                TreeMap<String, String[]> aaMap = PeptideUtils.getAaAfter(peptideAssumption.getPeptide(), nSurroundingAA, sequenceProvider);
                return aaMap.values().stream().map(aas -> Arrays.stream(aas).collect(Collectors.joining(","))).collect(Collectors.joining(";"));
            }
            case position: {
                TreeMap<String, int[]> proteinMapping = peptideAssumption.getPeptide().getProteinMapping();
                return proteinMapping.values().stream().map(positions -> Arrays.stream(positions).mapToObj(pos -> Integer.toString(pos)).collect(Collectors.joining(","))).collect(Collectors.joining(";"));
            }
            case missed_cleavages: {
                Peptide peptide = peptideAssumption.getPeptide();
                int nMissedCleavages = peptide.getNMissedCleavages(identificationParameters.getSearchParameters().getDigestionParameters());
                return Integer.toString(nMissedCleavages);
            }
            case modified_sequence: {
                ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                return peptideAssumption.getPeptide().getTaggedModifiedSequence(modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, false, false, true, null);
            }
            case spectrum_charge: {
                Precursor precursor = spectrumProvider.getPrecursor(spectrumFile, spectrumTitle);
                return precursor.getPossibleChargesAsString();
            }
            case precursor_intensity: {
                Precursor precursor = spectrumProvider.getPrecursor(spectrumFile, spectrumTitle);
                return Double.toString(precursor.intensity);
            }
            case spectrum_file: {
                return spectrumFile;
            }
            case spectrum_array_list: {
                Spectrum spectrum = spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
                return spectrum.getPeakListAsString();
            }
            case spectrum_title: {
                return spectrumTitle;
            }
            case spectrum_scan_number: {
                return "";
            }
            case starred: {
                return psParameter.getStarred() ? "1" : "0";
            }
            case theoretical_mass: {
                ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                double mass = peptideAssumption.getPeptide().getMass(modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
                return Double.toString(mass);
            }
            case validated: {
                if (psParameter.getMatchValidationLevel() != null) {
                    return psParameter.getMatchValidationLevel().toString();
                }
                return "";
            }
            case sequence_coverage: {
                Peptide peptide = peptideAssumption.getPeptide();
                Spectrum spectrum = spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
                AnnotationParameters annotationParameters = identificationParameters.getAnnotationParameters();
                ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                SpecificAnnotationParameters specificAnnotationParameters = annotationParameters.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, peptideAssumption, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, peptideSpectrumAnnotator);
                IonMatch[] matches = peptideSpectrumAnnotator.getSpectrumAnnotation(annotationParameters, specificAnnotationParameters, spectrumFile, spectrumTitle, spectrum, peptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
                int sequenceLength = peptide.getSequence().length();
                int[] aaCoverage = new int[sequenceLength];
                Arrays.stream(matches).filter(ionMatch -> ionMatch.ion instanceof PeptideFragmentIon).forEach(ionMatch -> {
                    aaCoverage[((PeptideFragmentIon)ionMatch.ion).getNumber() - 1] = 1;
                });
                double nIons = Arrays.stream(aaCoverage).sum();
                double coverage = 100.0 * nIons / (double)sequenceLength;
                return Double.toString(coverage);
            }
            case longest_amino_acid_sequence_annotated: {
                boolean current;
                int aaIndex;
                Peptide peptide = peptideAssumption.getPeptide();
                Spectrum spectrum = spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
                AnnotationParameters annotationParameters = identificationParameters.getAnnotationParameters();
                ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                SpecificAnnotationParameters specificAnnotationParameters = annotationParameters.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, peptideAssumption, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, peptideSpectrumAnnotator);
                IonMatch[] matches = peptideSpectrumAnnotator.getSpectrumAnnotation(annotationParameters, specificAnnotationParameters, spectrumFile, spectrumTitle, spectrum, peptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
                String sequence = peptide.getSequence();
                int sequenceLength = sequence.length();
                boolean[] coverageForward = new boolean[sequenceLength];
                boolean[] coverageRewind = new boolean[sequenceLength];
                Arrays.stream(matches).filter(ionMatch -> ionMatch.ion instanceof PeptideFragmentIon).map(ionMatch -> (PeptideFragmentIon)ionMatch.ion).forEach(peptideFragmentIon -> {
                    if (PeptideFragmentIon.isForward(peptideFragmentIon.getSubType())) {
                        coverageForward[peptideFragmentIon.getNumber() - 1] = true;
                    } else {
                        coverageRewind[peptideFragmentIon.getNumber() - 1] = true;
                    }
                });
                boolean[] aaCoverageB = new boolean[sequenceLength];
                boolean previous = true;
                for (aaIndex = 0; aaIndex < sequenceLength; ++aaIndex) {
                    current = coverageForward[aaIndex];
                    if (current && previous) {
                        aaCoverageB[aaIndex] = true;
                    }
                    previous = current;
                }
                previous = true;
                for (aaIndex = 0; aaIndex < sequenceLength; ++aaIndex) {
                    current = coverageRewind[aaIndex];
                    if (current && previous) {
                        aaCoverageB[sequenceLength - aaIndex - 1] = true;
                    }
                    previous = current;
                }
                StringBuilder currentTag = new StringBuilder();
                String longestTag = new String();
                for (int aaIndex2 = 0; aaIndex2 < sequenceLength; ++aaIndex2) {
                    if (aaCoverageB[aaIndex2]) {
                        currentTag.append(sequence.charAt(aaIndex2));
                        continue;
                    }
                    if (currentTag.length() > longestTag.length()) {
                        longestTag = currentTag.toString();
                    }
                    currentTag = new StringBuilder();
                }
                if (currentTag.length() > longestTag.length()) {
                    longestTag = currentTag.toString();
                }
                return longestTag;
            }
            case longest_amino_acid_sequence_annotated_single_serie: {
                Peptide peptide = peptideAssumption.getPeptide();
                Spectrum spectrum = spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
                AnnotationParameters annotationParameters = identificationParameters.getAnnotationParameters();
                ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                SpecificAnnotationParameters specificAnnotationParameters = annotationParameters.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, peptideAssumption, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, peptideSpectrumAnnotator);
                IonMatch[] matches = peptideSpectrumAnnotator.getSpectrumAnnotation(annotationParameters, specificAnnotationParameters, spectrumFile, spectrumTitle, spectrum, peptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
                String sequence = peptide.getSequence();
                int sequenceLength = sequence.length();
                HashMap<Integer, boolean[]> ionCoverage = new HashMap<Integer, boolean[]>(6);
                ionCoverage.put(0, new boolean[sequenceLength]);
                ionCoverage.put(1, new boolean[sequenceLength]);
                ionCoverage.put(2, new boolean[sequenceLength]);
                ionCoverage.put(3, new boolean[sequenceLength]);
                ionCoverage.put(4, new boolean[sequenceLength]);
                ionCoverage.put(5, new boolean[sequenceLength]);
                Arrays.stream(matches).filter(ionMatch -> ionMatch.charge == 1 && ionMatch.ion instanceof PeptideFragmentIon && !ionMatch.ion.hasNeutralLosses()).map(ionMatch -> (PeptideFragmentIon)ionMatch.ion).forEach(peptideFragmentIon -> {
                    ((boolean[])ionCoverage.get((Object)Integer.valueOf((int)peptideFragmentIon.getSubType())))[peptideFragmentIon.getNumber() - 1] = true;
                });
                String longestTag = new String();
                StringBuilder currentTag = new StringBuilder();
                boolean previous = true;
                for (int ionType : PeptideFragmentIon.getPossibleSubtypes()) {
                    for (int i = 0; i < sequenceLength; ++i) {
                        int aaIndex = PeptideFragmentIon.isForward(ionType) ? i : sequence.length() - i - 1;
                        boolean current = ((boolean[])ionCoverage.get(ionType))[i];
                        if (current && previous) {
                            currentTag.append(sequence.charAt(aaIndex));
                        } else {
                            if (currentTag.length() > longestTag.length()) {
                                if (PeptideFragmentIon.isForward(ionType)) {
                                    currentTag.reverse();
                                }
                                longestTag = currentTag.toString();
                            }
                            currentTag = new StringBuilder();
                        }
                        previous = current;
                    }
                    if (currentTag.length() <= longestTag.length()) continue;
                    if (PeptideFragmentIon.isForward(ionType)) {
                        currentTag.reverse();
                    }
                    longestTag = currentTag.toString();
                }
                return longestTag;
            }
            case amino_acids_annotated: {
                boolean current;
                int aaIndex;
                Peptide peptide = peptideAssumption.getPeptide();
                Spectrum spectrum = spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
                AnnotationParameters annotationParameters = identificationParameters.getAnnotationParameters();
                ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                SpecificAnnotationParameters specificAnnotationParameters = annotationParameters.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, peptideAssumption, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, peptideSpectrumAnnotator);
                IonMatch[] matches = peptideSpectrumAnnotator.getSpectrumAnnotation(annotationParameters, specificAnnotationParameters, spectrumFile, spectrumTitle, spectrum, peptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
                String sequence = peptide.getSequence();
                int sequenceLength = sequence.length();
                boolean[] coverageForward = new boolean[sequenceLength];
                boolean[] coverageRewind = new boolean[sequenceLength];
                Arrays.stream(matches).filter(ionMatch -> ionMatch.ion instanceof PeptideFragmentIon).map(ionMatch -> (PeptideFragmentIon)ionMatch.ion).forEach(peptideFragmentIon -> {
                    if (PeptideFragmentIon.isForward(peptideFragmentIon.getSubType())) {
                        coverageForward[peptideFragmentIon.getNumber() - 1] = true;
                    } else {
                        coverageRewind[peptideFragmentIon.getNumber() - 1] = true;
                    }
                });
                boolean[] aaCoverageB = new boolean[sequenceLength];
                boolean previous = true;
                for (aaIndex = 0; aaIndex < sequenceLength; ++aaIndex) {
                    current = coverageForward[aaIndex];
                    if (current && previous) {
                        aaCoverageB[aaIndex] = true;
                    }
                    previous = current;
                }
                previous = true;
                for (aaIndex = 0; aaIndex < sequenceLength; ++aaIndex) {
                    current = coverageRewind[aaIndex];
                    if (current && previous) {
                        aaCoverageB[sequenceLength - aaIndex - 1] = true;
                    }
                    previous = current;
                }
                StringBuilder tag = new StringBuilder();
                double gap = 0.0;
                for (int aaIndex3 = 0; aaIndex3 < sequenceLength; ++aaIndex3) {
                    if (aaCoverageB[aaIndex3]) {
                        if (gap > 0.0) {
                            tag.append("<").append(gap).append(">");
                        }
                        tag.append(sequence.charAt(aaIndex3));
                        gap = 0.0;
                        continue;
                    }
                    gap += AminoAcid.getAminoAcid(sequence.charAt(aaIndex3)).getMonoisotopicMass();
                }
                if (gap > 0.0) {
                    tag.append("<").append(gap).append(">");
                }
                return tag.toString();
            }
        }
        return "Not implemented";
    }

    private static String getModificationAsString(String modification, TreeSet<Integer> location) {
        StringBuilder sb = new StringBuilder(modification.length() + 2 * location.size() + 2);
        sb.append(modification).append(" (").append(location.stream().map(site -> site.toString()).collect(Collectors.joining(","))).append(")");
        return sb.toString();
    }

    public static String getTagAssumptionFeature(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SpectrumProvider spectrumProvider, IdentificationParameters identificationParameters, String linePrefix, TagAssumption tagAssumption, String spectrumFile, String spectrumTitle, PSParameter psParameter, PsIdentificationAlgorithmMatchesFeature exportFeature, WaitingHandler waitingHandler) {
        switch (exportFeature) {
            case rank: {
                return Integer.toString(tagAssumption.getRank());
            }
            case variable_ptms: {
                return Tag.getTagModificationsAsString(tagAssumption.getTag());
            }
            case fixed_ptms: {
                return "";
            }
            case accessions: {
                return "";
            }
            case protein_description: {
                return "";
            }
            case algorithm_confidence: {
                return Double.toString(psParameter.getConfidence());
            }
            case decoy: {
                return "";
            }
            case hidden: {
                return psParameter.getHidden() ? "1" : "0";
            }
            case identification_charge: {
                return Integer.toString(tagAssumption.getIdentificationCharge());
            }
            case isotope: {
                double precursorMz = spectrumProvider.getPrecursorMz(spectrumFile, spectrumTitle);
                return Double.toString(tagAssumption.getIsotopeNumber(precursorMz, identificationParameters.getSearchParameters().getMinIsotopicCorrection(), identificationParameters.getSearchParameters().getMaxIsotopicCorrection()));
            }
            case mz: {
                double precursorMz = spectrumProvider.getPrecursorMz(spectrumFile, spectrumTitle);
                return Double.toString(precursorMz);
            }
            case total_spectrum_intensity: {
                Spectrum spectrum = spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
                return Double.toString(spectrum.getTotalIntensity());
            }
            case max_intensity: {
                Spectrum spectrum = spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
                return Double.toString(spectrum.getMaxIntensity());
            }
            case mz_error_ppm: {
                double precursorMz = spectrumProvider.getPrecursorMz(spectrumFile, spectrumTitle);
                return Double.toString(tagAssumption.getDeltaMz(precursorMz, true, identificationParameters.getSearchParameters().getMinIsotopicCorrection(), identificationParameters.getSearchParameters().getMaxIsotopicCorrection()));
            }
            case rt: {
                double precursorRt = spectrumProvider.getPrecursorRt(spectrumFile, spectrumTitle);
                return Double.toString(precursorRt);
            }
            case algorithm_raw_score: {
                int id = tagAssumption.getAdvocate();
                double score = tagAssumption.getRawScore();
                return String.join((CharSequence)"", Advocate.getAdvocate(id).getName(), " (", Double.toString(score), ")");
            }
            case algorithm_score: {
                int id = tagAssumption.getAdvocate();
                double score = tagAssumption.getScore();
                return String.join((CharSequence)"", Advocate.getAdvocate(id).getName(), " (", Double.toString(score), ")");
            }
            case sequence: {
                return tagAssumption.getTag().asSequence();
            }
            case missed_cleavages: {
                return "";
            }
            case modified_sequence: {
                ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                HashSet<String> modToExport = new HashSet<String>(modificationParameters.getVariableModifications());
                return tagAssumption.getTag().getTaggedModifiedSequence(modificationParameters, false, false, true, false, modificationSequenceMatchingParameters, modToExport);
            }
            case spectrum_charge: {
                Precursor precursor = spectrumProvider.getPrecursor(spectrumFile, spectrumTitle);
                return precursor.getPossibleChargesAsString();
            }
            case precursor_intensity: {
                Precursor precursor = spectrumProvider.getPrecursor(spectrumFile, spectrumTitle);
                return Double.toString(precursor.intensity);
            }
            case spectrum_file: {
                return spectrumFile;
            }
            case spectrum_array_list: {
                Spectrum spectrum = spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
                return spectrum.getPeakListAsString();
            }
            case spectrum_title: {
                return spectrumTitle;
            }
            case spectrum_scan_number: {
                return "";
            }
            case starred: {
                return psParameter.getStarred() ? "1" : "0";
            }
            case theoretical_mass: {
                return Double.toString(tagAssumption.getTag().getMass());
            }
            case validated: {
                if (psParameter.getMatchValidationLevel() != null) {
                    return psParameter.getMatchValidationLevel().toString();
                }
                return "";
            }
            case position: 
            case sequence_coverage: 
            case longest_amino_acid_sequence_annotated: 
            case amino_acids_annotated: 
            case fragment_mz_accuracy_score: 
            case intensity_score: {
                return "";
            }
        }
        return "Not implemented";
    }
}

