/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.export.sections;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.ModificationScoring;
import com.compomics.util.experiment.identification.peptide_shaker.PSModificationScores;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.features.peptideshaker.PsFragmentFeature;
import com.compomics.util.io.export.features.peptideshaker.PsIdentificationAlgorithmMatchesFeature;
import com.compomics.util.io.export.features.peptideshaker.PsPsmFeature;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.export.ExportUtils;
import eu.isas.peptideshaker.export.sections.PsFragmentSection;
import eu.isas.peptideshaker.export.sections.PsIdentificationAlgorithmMatchesSection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PsPsmSection {
    private final EnumSet<PsPsmFeature> psmFeatures = EnumSet.noneOf(PsPsmFeature.class);
    private final EnumSet<PsIdentificationAlgorithmMatchesFeature> identificationAlgorithmMatchesFeatures = EnumSet.noneOf(PsIdentificationAlgorithmMatchesFeature.class);
    private PsFragmentSection fragmentSection = null;
    private final boolean indexes;
    private final boolean header;
    private final ExportWriter writer;

    public PsPsmSection(ArrayList<ExportFeature> exportFeatures, boolean indexes, boolean header, ExportWriter writer) {
        ArrayList<ExportFeature> fragmentFeatures = new ArrayList<ExportFeature>(0);
        for (ExportFeature exportFeature : exportFeatures) {
            if (exportFeature instanceof PsPsmFeature) {
                this.psmFeatures.add((PsPsmFeature)exportFeature);
                continue;
            }
            if (exportFeature instanceof PsIdentificationAlgorithmMatchesFeature) {
                this.identificationAlgorithmMatchesFeatures.add((PsIdentificationAlgorithmMatchesFeature)exportFeature);
                continue;
            }
            if (exportFeature instanceof PsFragmentFeature) {
                fragmentFeatures.add(exportFeature);
                continue;
            }
            throw new IllegalArgumentException("Export feature of type " + exportFeature.getClass() + " not recognized.");
        }
        if (!fragmentFeatures.isEmpty()) {
            this.fragmentSection = new PsFragmentSection(fragmentFeatures, indexes, header, writer);
        }
        this.indexes = indexes;
        this.header = header;
        this.writer = writer;
    }

    public void writeSection(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider, IdentificationParameters identificationParameters, long[] keys, String linePrefix, int nSurroundingAA, boolean validatedOnly, boolean decoys, WaitingHandler waitingHandler) throws IOException {
        SpectrumMatch spectrumMatch;
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        if (this.header) {
            this.writeHeader();
        }
        int line = 1;
        int totalSize = identification.getNumber(SpectrumMatch.class);
        if (waitingHandler != null) {
            waitingHandler.setWaitingText("Exporting. Please Wait...");
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(totalSize);
        }
        SpectrumMatchesIterator psmIterator = identification.getSpectrumMatchesIterator(keys, waitingHandler);
        while ((spectrumMatch = psmIterator.next()) != null) {
            if (waitingHandler != null) {
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                waitingHandler.increaseSecondaryProgressCounter();
            }
            String spectrumFile = spectrumMatch.getSpectrumFile();
            String spectrumTitle = spectrumMatch.getSpectrumTitle();
            PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
            if (validatedOnly && !psParameter.getMatchValidationLevel().isValidated()) continue;
            PeptideAssumption peptideAssumption = spectrumMatch.getBestPeptideAssumption();
            TagAssumption tagAssumption = spectrumMatch.getBestTagAssumption();
            if (peptideAssumption == null && tagAssumption == null || !decoys && (peptideAssumption == null || PeptideUtils.isDecoy(peptideAssumption.getPeptide(), sequenceProvider)) && tagAssumption == null) continue;
            boolean first = true;
            if (this.indexes) {
                if (linePrefix != null) {
                    this.writer.write(linePrefix);
                }
                this.writer.write(Integer.toString(line));
                first = false;
            }
            for (PsIdentificationAlgorithmMatchesFeature identificationAlgorithmMatchesFeature : this.identificationAlgorithmMatchesFeatures) {
                String feature;
                if (!first) {
                    this.writer.addSeparator();
                } else {
                    first = false;
                }
                if (peptideAssumption != null) {
                    feature = PsIdentificationAlgorithmMatchesSection.getPeptideAssumptionFeature(identification, identificationFeaturesGenerator, sequenceProvider, proteinDetailsProvider, spectrumProvider, identificationParameters, linePrefix, nSurroundingAA, peptideAssumption, spectrumFile, spectrumTitle, psParameter, identificationAlgorithmMatchesFeature, waitingHandler);
                } else if (tagAssumption != null) {
                    feature = PsIdentificationAlgorithmMatchesSection.getTagAssumptionFeature(identification, identificationFeaturesGenerator, spectrumProvider, identificationParameters, linePrefix, tagAssumption, spectrumFile, spectrumTitle, psParameter, identificationAlgorithmMatchesFeature, waitingHandler);
                } else {
                    throw new IllegalArgumentException("No best match found for spectrum " + spectrumTitle + " in " + spectrumFile + ".");
                }
                this.writer.write(feature);
            }
            for (PsPsmFeature psmFeature : this.psmFeatures) {
                if (!first) {
                    this.writer.addSeparator();
                } else {
                    first = false;
                }
                this.writer.write(PsPsmSection.getFeature(identification, identificationFeaturesGenerator, identificationParameters, linePrefix, spectrumMatch, psParameter, psmFeature, validatedOnly, decoys, waitingHandler));
            }
            this.writer.newLine();
            if (this.fragmentSection != null) {
                StringBuilder fractionPrefix = new StringBuilder();
                if (linePrefix != null) {
                    fractionPrefix.append(linePrefix);
                }
                fractionPrefix.append(line).append(".");
                this.writer.increaseDepth();
                if (peptideAssumption != null) {
                    this.fragmentSection.writeSection(spectrumFile, spectrumTitle, peptideAssumption, sequenceProvider, spectrumProvider, identificationParameters, fractionPrefix.toString(), null);
                } else if (tagAssumption != null) {
                    this.fragmentSection.writeSection(spectrumFile, spectrumTitle, tagAssumption, sequenceProvider, spectrumProvider, identificationParameters, fractionPrefix.toString(), null);
                }
                this.writer.decreaseDepth();
            }
            ++line;
        }
    }

    public static String getFeature(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, IdentificationParameters identificationParameters, String linePrefix, SpectrumMatch spectrumMatch, PSParameter psParameter, PsPsmFeature psmFeature, boolean validatedOnly, boolean decoys, WaitingHandler waitingHandler) {
        switch (psmFeature) {
            case protein_groups: {
                if (spectrumMatch.getBestPeptideAssumption() != null) {
                    TreeSet<Long> proteinGroups = identification.getProteinMatches(spectrumMatch.getBestPeptideAssumption().getPeptide().getKey());
                    return proteinGroups.stream().map(key -> PsPsmSection.getProteinGroupText(key, identification)).collect(Collectors.joining(";"));
                }
                return "";
            }
            case best_protein_group_validation: {
                if (spectrumMatch.getBestPeptideAssumption() != null) {
                    TreeSet<Long> proteinGroups = identification.getProteinMatches(spectrumMatch.getBestPeptideAssumption().getPeptide().getKey());
                    int bestIndex = proteinGroups.stream().map(key -> ((PSParameter)identification.getProteinMatch((long)key).getUrParam(PSParameter.dummy)).getMatchValidationLevel()).mapToInt(MatchValidationLevel::getIndex).max().orElse(MatchValidationLevel.none.getIndex());
                    return MatchValidationLevel.getMatchValidationLevel(bestIndex).getName();
                }
                return "";
            }
            case probabilistic_score: {
                PSModificationScores ptmScores;
                if (spectrumMatch.getBestPeptideAssumption() != null && (ptmScores = (PSModificationScores)spectrumMatch.getUrParam(PSModificationScores.dummy)) != null) {
                    StringBuilder result = new StringBuilder();
                    TreeSet<String> modList = new TreeSet<String>(ptmScores.getScoredModifications());
                    for (String mod : modList) {
                        ModificationScoring ptmScoring = ptmScores.getModificationScoring(mod);
                        TreeSet<Integer> sites = new TreeSet<Integer>(ptmScoring.getProbabilisticSites());
                        if (sites.isEmpty()) continue;
                        if (result.length() > 0) {
                            result.append(", ");
                        }
                        result.append(mod).append(" (");
                        boolean firstSite = true;
                        for (int site : sites) {
                            if (firstSite) {
                                firstSite = false;
                            } else {
                                result.append(", ");
                            }
                            result.append(site).append(": ").append(ptmScoring.getProbabilisticScore(site));
                        }
                        result.append(")");
                    }
                    return result.toString();
                }
                return "";
            }
            case d_score: {
                if (spectrumMatch.getBestPeptideAssumption() != null) {
                    StringBuilder result = new StringBuilder();
                    PSModificationScores ptmScores = (PSModificationScores)spectrumMatch.getUrParam(PSModificationScores.dummy);
                    if (ptmScores != null) {
                        TreeSet<String> modList = new TreeSet<String>(ptmScores.getScoredModifications());
                        for (String mod : modList) {
                            ModificationScoring ptmScoring = ptmScores.getModificationScoring(mod);
                            TreeSet<Integer> sites = new TreeSet<Integer>(ptmScoring.getDSites());
                            if (sites.isEmpty()) continue;
                            if (result.length() > 0) {
                                result.append(", ");
                            }
                            result.append(mod).append(" (");
                            boolean firstSite = true;
                            for (int site : sites) {
                                if (firstSite) {
                                    firstSite = false;
                                } else {
                                    result.append(", ");
                                }
                                result.append(site).append(": ").append(ptmScoring.getDeltaScore(site));
                            }
                            result.append(")");
                        }
                    }
                    return result.toString();
                }
                return "";
            }
            case localization_confidence: {
                return PsPsmSection.getPeptideModificationLocationConfidence(spectrumMatch, identificationParameters.getSearchParameters().getModificationParameters());
            }
            case algorithm_score: {
                PeptideAssumption bestPeptideAssumption = spectrumMatch.getBestPeptideAssumption();
                TagAssumption bestTagAssumption = spectrumMatch.getBestTagAssumption();
                if (bestPeptideAssumption != null) {
                    return spectrumMatch.getAllPeptideAssumptions().filter(peptideAssumption -> peptideAssumption.getPeptide().isSameSequenceAndModificationStatus(bestPeptideAssumption.getPeptide(), identificationParameters.getSequenceMatchingParameters())).collect(Collectors.toMap(SpectrumIdentificationAssumption::getAdvocate, Function.identity(), (a, b) -> b.getScore() < a.getScore() ? b : a, TreeMap::new)).entrySet().stream().map(entry -> Util.keyValueToString(Advocate.getAdvocate((Integer)entry.getKey()).getName(), Double.toString(((PeptideAssumption)entry.getValue()).getRawScore()))).collect(Collectors.joining(","));
                }
                if (bestTagAssumption != null) {
                    return spectrumMatch.getAllTagAssumptions().filter(tagAssumption -> tagAssumption.getTag().isSameSequenceAndModificationStatusAs(bestTagAssumption.getTag(), identificationParameters.getSequenceMatchingParameters())).collect(Collectors.toMap(SpectrumIdentificationAssumption::getAdvocate, Function.identity(), (a, b) -> b.getScore() < a.getScore() ? b : a, TreeMap::new)).entrySet().stream().map(entry -> Util.keyValueToString(Advocate.getAdvocate((Integer)entry.getKey()).getName(), Double.toString(((TagAssumption)entry.getValue()).getRawScore()))).collect(Collectors.joining(","));
                }
                return "";
            }
            case confidence: {
                return Double.toString(psParameter.getConfidence());
            }
            case score: {
                return Double.toString(psParameter.getTransformedScore());
            }
            case raw_score: {
                return Double.toString(psParameter.getScore());
            }
            case validated: {
                return psParameter.getMatchValidationLevel().toString();
            }
            case starred: {
                return psParameter.getStarred() ? "1" : "0";
            }
            case hidden: {
                return psParameter.getHidden() ? "1" : "0";
            }
            case confident_modification_sites: {
                if (spectrumMatch.getBestPeptideAssumption() != null) {
                    Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
                    return identificationFeaturesGenerator.getModificationSites(peptide.getSequence(), peptide.getVariableModifications(), true);
                }
                return "";
            }
            case confident_modification_sites_number: {
                if (spectrumMatch.getBestPeptideAssumption() != null) {
                    Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
                    return identificationFeaturesGenerator.getModificationSitesNumber(peptide.getVariableModifications(), true);
                }
                return "";
            }
            case ambiguous_modification_sites: {
                if (spectrumMatch.getBestPeptideAssumption() != null) {
                    Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
                    return identificationFeaturesGenerator.getModificationSites(peptide.getSequence(), peptide.getVariableModifications(), false);
                }
                return "";
            }
            case ambiguous_modification_sites_number: {
                if (spectrumMatch.getBestPeptideAssumption() != null) {
                    Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
                    return identificationFeaturesGenerator.getModificationSitesNumber(peptide.getVariableModifications(), false);
                }
                return "";
            }
            case confident_phosphosites: {
                if (spectrumMatch.getBestPeptideAssumption() != null) {
                    Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
                    HashSet<String> modifications = ExportUtils.getPhosphorylations(identificationParameters.getSearchParameters().getModificationParameters());
                    return identificationFeaturesGenerator.getModificationSites(peptide.getSequence(), peptide.getVariableModifications(), true, modifications);
                }
                return "";
            }
            case confident_phosphosites_number: {
                if (spectrumMatch.getBestPeptideAssumption() != null) {
                    Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
                    HashSet<String> modifications = ExportUtils.getPhosphorylations(identificationParameters.getSearchParameters().getModificationParameters());
                    return Integer.toString(identificationFeaturesGenerator.getModificationSitesNumber(peptide.getVariableModifications(), true, modifications));
                }
                return "";
            }
            case ambiguous_phosphosites: {
                if (spectrumMatch.getBestPeptideAssumption() != null) {
                    Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
                    HashSet<String> modifications = ExportUtils.getPhosphorylations(identificationParameters.getSearchParameters().getModificationParameters());
                    return identificationFeaturesGenerator.getModificationSites(peptide.getSequence(), peptide.getVariableModifications(), false, modifications);
                }
                return "";
            }
            case ambiguous_phosphosites_number: {
                if (spectrumMatch.getBestPeptideAssumption() != null) {
                    Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
                    HashSet<String> modifications = ExportUtils.getPhosphorylations(identificationParameters.getSearchParameters().getModificationParameters());
                    return Integer.toString(identificationFeaturesGenerator.getModificationSitesNumber(peptide.getVariableModifications(), false, modifications));
                }
                return "";
            }
        }
        return "Not implemented";
    }

    public static String getProteinGroupText(long proteinGroupKey, Identification identification) {
        ProteinMatch proteinMatch = (ProteinMatch)identification.retrieveObject(proteinGroupKey);
        String[] accessions = proteinMatch.getAccessions();
        String accessionsString = Arrays.stream(accessions).collect(Collectors.joining(","));
        PSParameter psParameter = new PSParameter();
        psParameter = (PSParameter)proteinMatch.getUrParam(psParameter);
        String validationString = psParameter.getMatchValidationLevel().getName();
        StringBuilder sb = new StringBuilder(accessionsString.length() + validationString.length() + 2);
        sb.append(accessionsString).append("(").append(validationString).append(")");
        return sb.toString();
    }

    public static String getPeptideModificationLocationConfidence(SpectrumMatch spectrumMatch, ModificationParameters modificationParameters) {
        PSModificationScores psPtmScores = (PSModificationScores)spectrumMatch.getUrParam(PSModificationScores.dummy);
        if (psPtmScores != null) {
            TreeSet<String> modList = new TreeSet<String>(psPtmScores.getScoredModifications());
            StringBuilder result = new StringBuilder();
            for (String mod : modList) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(mod).append(" (");
                ModificationScoring ptmScoring = psPtmScores.getModificationScoring(mod);
                boolean firstSite = true;
                block8: for (int site : ptmScoring.getOrderedPtmLocations()) {
                    if (firstSite) {
                        firstSite = false;
                    } else {
                        result.append(", ");
                    }
                    int ptmConfidence = ptmScoring.getLocalizationConfidence(site);
                    switch (ptmConfidence) {
                        case -1: {
                            result.append(site).append(": Not Scored");
                            continue block8;
                        }
                        case 0: {
                            result.append(site).append(": Random");
                            continue block8;
                        }
                        case 1: {
                            result.append(site).append(": Doubtfull");
                            continue block8;
                        }
                        case 2: {
                            result.append(site).append(": Confident");
                            continue block8;
                        }
                        case 3: {
                            result.append(site).append(": Very Confident");
                            continue block8;
                        }
                    }
                    throw new IllegalArgumentException("Localizatoin confidence level not recognized: " + ptmConfidence + ".");
                }
                result.append(")");
            }
            return result.toString();
        }
        return "";
    }

    public void writeHeader() throws IOException {
        if (this.indexes) {
            this.writer.writeHeaderText("");
            this.writer.addSeparator();
        }
        boolean firstColumn = true;
        for (ExportFeature exportFeature : this.identificationAlgorithmMatchesFeatures) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                this.writer.addSeparator();
            }
            this.writer.writeHeaderText(exportFeature.getTitle());
        }
        for (ExportFeature exportFeature : this.psmFeatures) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                this.writer.addSeparator();
            }
            this.writer.writeHeaderText(exportFeature.getTitle());
        }
        this.writer.newLine();
    }
}

