/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.export.sections;

import com.compomics.util.io.IoUtil;
import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.features.peptideshaker.PsSearchFeature;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.preferences.ProjectDetails;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.stream.Collectors;

public class PsSearchParametersSection {
    private final EnumSet<PsSearchFeature> searchFeatures;
    private final boolean indexes;
    private final boolean header;
    private final ExportWriter writer;

    public PsSearchParametersSection(ArrayList<ExportFeature> exportFeatures, boolean indexes, boolean header, ExportWriter writer) {
        this.indexes = indexes;
        this.header = header;
        this.writer = writer;
        this.searchFeatures = EnumSet.noneOf(PsSearchFeature.class);
        for (ExportFeature exportFeature : exportFeatures) {
            if (exportFeature instanceof PsSearchFeature) {
                this.searchFeatures.add((PsSearchFeature)exportFeature);
                continue;
            }
            throw new IllegalArgumentException("Impossible to export " + exportFeature.getClass().getName() + " as search parameter feature.");
        }
    }

    public void writeSection(SearchParameters searchParameters, ProjectDetails projectDetails, WaitingHandler waitingHandler) throws IOException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        if (this.header) {
            if (this.indexes) {
                this.writer.writeHeaderText("");
                this.writer.addSeparator();
            }
            this.writer.writeHeaderText("Parameter");
            this.writer.addSeparator();
            this.writer.writeHeaderText("Value");
            this.writer.newLine();
        }
        int line = 1;
        for (PsSearchFeature exportFeature : this.searchFeatures) {
            if (this.indexes) {
                this.writer.write(Integer.toString(line));
                this.writer.addSeparator();
            }
            this.writer.write(exportFeature.getTitle());
            this.writer.addSeparator();
            switch (exportFeature) {
                case database: {
                    String fastaFileName = IoUtil.getFileName(projectDetails.getFastaFile());
                    this.writer.write(fastaFileName);
                    break;
                }
                case cleavage: {
                    DigestionParameters digestionPreferences = searchParameters.getDigestionParameters();
                    this.writer.write(digestionPreferences.getCleavageParameter().toString());
                    break;
                }
                case enzyme: {
                    DigestionParameters digestionPreferences = searchParameters.getDigestionParameters();
                    if (digestionPreferences.getCleavageParameter() != DigestionParameters.CleavageParameter.enzyme) break;
                    String enzymeString = digestionPreferences.getEnzymes().stream().map(enzyme -> enzyme.getName()).collect(Collectors.joining(", "));
                    this.writer.write(enzymeString);
                    break;
                }
                case mc: {
                    DigestionParameters digestionPreferences = searchParameters.getDigestionParameters();
                    if (digestionPreferences.getCleavageParameter() != DigestionParameters.CleavageParameter.enzyme) break;
                    String nMissedCleavagesString = digestionPreferences.getEnzymes().stream().map(enzyme -> digestionPreferences.getnMissedCleavages(enzyme.getName()).toString()).collect(Collectors.joining(", "));
                    this.writer.write(nMissedCleavagesString);
                    break;
                }
                case specificity: {
                    DigestionParameters digestionPreferences = searchParameters.getDigestionParameters();
                    if (digestionPreferences.getCleavageParameter() != DigestionParameters.CleavageParameter.enzyme) break;
                    String specificityString = digestionPreferences.getEnzymes().stream().map(enzyme -> digestionPreferences.getSpecificity((String)enzyme.getName()).name).collect(Collectors.joining(", "));
                    this.writer.write(specificityString);
                    break;
                }
                case fixed_modifications: {
                    this.writer.write(searchParameters.getModificationParameters().getFixedModifications().stream().collect(Collectors.joining(", ")));
                    break;
                }
                case variable_modifications: {
                    this.writer.write(searchParameters.getModificationParameters().getVariableModifications().stream().collect(Collectors.joining(", ")));
                    break;
                }
                case refinement_variable_modifications: {
                    this.writer.write(searchParameters.getModificationParameters().getRefinementVariableModifications().stream().collect(Collectors.joining(", ")));
                    break;
                }
                case refinement_fixed_modifications: {
                    this.writer.write(searchParameters.getModificationParameters().getRefinementFixedModifications().stream().collect(Collectors.joining(", ")));
                    break;
                }
                case forward_ion: {
                    this.writer.write(searchParameters.getForwardIons().stream().map(ion -> ion.toString()).collect(Collectors.joining(", ")));
                    break;
                }
                case rewind_ion: {
                    this.writer.write(searchParameters.getRewindIons().stream().map(ion -> ion.toString()).collect(Collectors.joining(", ")));
                    break;
                }
                case fragment_tolerance: {
                    this.writer.write(Double.toString(searchParameters.getFragmentIonAccuracy()));
                    break;
                }
                case precursor_tolerance_unit: {
                    this.writer.write(searchParameters.getPrecursorAccuracyType().toString());
                    break;
                }
                case fragment_tolerance_unit: {
                    this.writer.write(searchParameters.getFragmentAccuracyType().toString());
                    break;
                }
                case precursor_tolerance: {
                    this.writer.write(Double.toString(searchParameters.getPrecursorAccuracy()));
                    break;
                }
                default: {
                    this.writer.write("Not implemented");
                }
            }
            this.writer.newLine();
            ++line;
        }
    }
}

