/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.fileimport;

import com.compomics.util.Util;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.exceptions.exception_handlers.FrameExceptionHandler;
import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.biology.genes.ProteinGeneDetailsProvider;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.filtering.PeptideAssumptionFilter;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.peptide_shaker.Metrics;
import com.compomics.util.experiment.identification.protein_inference.FastaMapper;
import com.compomics.util.experiment.identification.protein_inference.fm_index.FMIndex;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.io.identification.IdfileReaderFactory;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.gui.JOptionEditorPane;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingDialog;
import com.compomics.util.io.IoUtil;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.GeneParameters;
import com.compomics.util.parameters.identification.advanced.PeptideVariantsParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.tools.ProcessingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.fileimport.PsmImporter;
import eu.isas.peptideshaker.preferences.ProjectDetails;
import eu.isas.peptideshaker.protein_inference.TagMapper;
import eu.isas.peptideshaker.scoring.maps.InputMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;

public class FileImporter {
    private final WaitingHandler waitingHandler;
    private final ExceptionHandler exceptionHandler;
    private SequenceProvider sequenceProvider;
    private ProteinDetailsProvider proteinDetailsProvider;
    private final SpectrumProvider spectrumProvider;
    private final HashMap<String, HashSet<String>> loadedSpectraMap;
    private FastaSummary fastaSummary;
    private final Metrics metrics;
    private final IdentificationParameters identificationParameters;
    private final IdfileReaderFactory readerFactory = IdfileReaderFactory.getInstance();
    private final ProcessingParameters processingParameters;
    private final ProjectDetails projectDetails;
    private long nRetained = 0L;
    private final InputMap inputMap = new InputMap();
    private boolean hasGUI = false;
    private final Identification identification;
    private FastaMapper fastaMapper;
    private final TagMapper tagMapper;
    private final HashMap<String, Integer> proteinCount = new HashMap(10000);
    private long nPSMs = 0L;
    private long nTotal = 0L;
    private GeneMaps geneMaps;

    public FileImporter(Identification identification, IdentificationParameters identificationParameters, ProcessingParameters processingParameters, Metrics metrics, ProjectDetails projectDetails, SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) {
        this.identificationParameters = identificationParameters;
        this.metrics = metrics;
        this.processingParameters = processingParameters;
        this.projectDetails = projectDetails;
        this.spectrumProvider = spectrumProvider;
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.identification = identification;
        this.tagMapper = new TagMapper(identificationParameters, exceptionHandler);
        this.loadedSpectraMap = new HashMap(spectrumProvider.getOrderedFileNamesWithoutExtensions().length);
        for (String fileNameWithoutExtension : spectrumProvider.getOrderedFileNamesWithoutExtensions()) {
            this.loadedSpectraMap.put(fileNameWithoutExtension, Arrays.stream(spectrumProvider.getSpectrumTitles(fileNameWithoutExtension)).collect(Collectors.toCollection(HashSet::new)));
        }
    }

    public int importFiles(ArrayList<File> idFiles) {
        ArrayList sortedIdFiles = idFiles.stream().collect(Collectors.groupingBy(File::getName, TreeMap::new, Collectors.toList())).values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toCollection(ArrayList::new));
        try {
            this.importSequences(this.identificationParameters.getSequenceMatchingParameters(), this.identificationParameters.getSearchParameters(), this.identificationParameters.getFastaParameters(), this.identificationParameters.getPeptideVariantsParameters(), this.waitingHandler, this.exceptionHandler);
            if (this.waitingHandler.isRunCanceled()) {
                return 1;
            }
            GeneParameters geneParameters = this.identificationParameters.getGeneParameters();
            if (geneParameters.getUseGeneMapping().booleanValue()) {
                this.waitingHandler.setSecondaryProgressCounterIndeterminate(true);
                this.waitingHandler.appendReport("Importing gene mappings.", true, true);
                this.importGenes();
            } else {
                this.geneMaps = new GeneMaps();
            }
            if (this.waitingHandler.isRunCanceled()) {
                return 1;
            }
            this.waitingHandler.setSecondaryProgressCounterIndeterminate(true);
            this.waitingHandler.appendReport("Establishing local database connection.", true, true);
            this.waitingHandler.increasePrimaryProgressCounter();
            if (!this.waitingHandler.isRunCanceled()) {
                this.waitingHandler.appendReport("Reading identification files.", true, true);
                for (File idFile : sortedIdFiles) {
                    this.importPsms(idFile);
                    if (!this.waitingHandler.isRunCanceled()) continue;
                    return 1;
                }
                if (this.nRetained == 0L) {
                    this.waitingHandler.appendReport("No identification results.", true, true);
                    this.waitingHandler.setRunCanceled();
                    return 1;
                }
                int nSpectra = 0;
                for (String spectrumFileName : this.identification.getFractions()) {
                    nSpectra += this.spectrumProvider.getSpectrumTitles(spectrumFileName).length;
                }
                this.waitingHandler.appendReport("File import completed. " + this.nPSMs + " first hits imported (" + this.nTotal + " total) from " + nSpectra + " spectra.", true, true);
                this.waitingHandler.appendReport("[" + this.nRetained + " first hits passed the initial filtering]", true, true);
            }
        }
        catch (OutOfMemoryError error) {
            System.out.println("<CompomicsError>PeptideShaker ran out of memory! See the PeptideShaker log for details.</CompomicsError>");
            System.err.println("Ran out of memory!");
            System.err.println("Memory given to the Java virtual machine: " + Runtime.getRuntime().maxMemory() + ".");
            System.err.println("Memory used by the Java virtual machine: " + Runtime.getRuntime().totalMemory() + ".");
            System.err.println("Free memory in the Java virtual machine: " + Runtime.getRuntime().freeMemory() + ".");
            Runtime.getRuntime().gc();
            this.waitingHandler.appendReportEndLine();
            this.waitingHandler.appendReport("Ran out of memory!", true, true);
            this.waitingHandler.setRunCanceled();
            if (this.waitingHandler instanceof WaitingDialog) {
                JOptionPane.showMessageDialog((WaitingDialog)this.waitingHandler, JOptionEditorPane.getJOptionEditorPane("PeptideShaker used up all the available memory and had to be stopped.<br>Memory boundaries are changed in the the Welcome Dialog (Settings<br>& Help > Settings > Java Memory Settings) or in the Edit menu (Edit<br>Java Options). See also <a href=\"https://compomics.github.io/projects/compomics-utilities/wiki/JavaTroubleShooting.html\">JavaTroubleShooting</a>."), "Out Of Memory", 0);
            }
            error.printStackTrace();
            return 1;
        }
        catch (Exception e) {
            this.waitingHandler.setRunCanceled();
            System.out.println("<CompomicsError>PeptideShaker processing failed. See the PeptideShaker log for details.</CompomicsError>");
            if (e instanceof NullPointerException) {
                this.waitingHandler.appendReport("An error occurred while loading the identification files.", true, true);
                this.waitingHandler.appendReport("Please see the error log (Help Menu > Bug Report) for details.", true, true);
            } else if (FrameExceptionHandler.getExceptionType(e).equalsIgnoreCase("Protein not found")) {
                this.waitingHandler.appendReport("An error occurred while loading the identification files:", true, true);
                this.waitingHandler.appendReport(e.getLocalizedMessage(), true, true);
                this.waitingHandler.appendReport("Please see https://compomics.github.io/projects/searchgui/wiki/DatabaseHelp.html.", true, true);
            } else {
                this.waitingHandler.appendReport("An error occurred while loading the identification files:", true, true);
                this.waitingHandler.appendReport(e.getLocalizedMessage(), true, true);
            }
            e.printStackTrace();
            System.err.println("Free memory: " + Runtime.getRuntime().freeMemory());
            return 1;
        }
        return 0;
    }

    public void importPsms(File idFile) throws IOException, InterruptedException, TimeoutException {
        this.waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        this.waitingHandler.appendReport("Parsing " + idFile.getName() + ".", true, true);
        IdfileReader fileReader = null;
        try {
            fileReader = this.readerFactory.getFileReader(idFile);
        }
        catch (OutOfMemoryError error) {
            this.waitingHandler.appendReport("Ran out of memory when parsing '" + IoUtil.getFileName(idFile) + "'.", true, true);
            throw new OutOfMemoryError("Ran out of memory when parsing '" + IoUtil.getFileName(idFile) + "'.");
        }
        if (fileReader == null) {
            this.waitingHandler.appendReport("Identification result file '" + IoUtil.getFileName(idFile) + "' not recognized.", true, true);
            this.waitingHandler.setRunCanceled();
            return;
        }
        this.waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        ArrayList<SpectrumMatch> idFileSpectrumMatches = null;
        try {
            idFileSpectrumMatches = fileReader.getAllSpectrumMatches(this.spectrumProvider, this.waitingHandler, this.identificationParameters.getSearchParameters(), this.identificationParameters.getSequenceMatchingParameters(), true);
        }
        catch (Exception e) {
            this.waitingHandler.appendReport("An error occurred while loading spectrum matches from '" + IoUtil.getFileName(idFile) + "'. This file will be ignored. Error: " + e.toString() + " See resources/PeptideShaker.log for details.", true, true);
            e.printStackTrace();
        }
        HashMap<String, ArrayList<String>> software = fileReader.getSoftwareVersions();
        this.projectDetails.setIdentificationAlgorithmsForFile(IoUtil.getFileName(idFile), software);
        if (!software.isEmpty()) {
            for (String advocateName : software.keySet()) {
                Advocate advocate = Advocate.getAdvocate(advocateName);
                if (advocate != null && advocate.getType() != Advocate.AdvocateType.unknown) continue;
                this.waitingHandler.appendReport("Warning: The software used to generate " + idFile.getName() + " was not recognized by PeptideShaker. Please create an issue on the tool website and we will add support for the software used. github.com/compomics/peptide-shaker/issues", true, true);
                return;
            }
        }
        fileReader.close();
        if (idFileSpectrumMatches != null && !this.waitingHandler.isRunCanceled()) {
            int nMatches = idFileSpectrumMatches.size();
            if (nMatches == 0) {
                this.waitingHandler.appendReport("No PSM found in " + idFile.getName() + ".", true, true);
            } else {
                String report;
                this.waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                this.waitingHandler.resetSecondaryProgressCounter();
                this.waitingHandler.setMaxSecondaryProgressCounter(nMatches);
                this.waitingHandler.appendReport("Checking spectra for " + idFile.getName() + ".", true, true);
                HashSet<String> importedFileNames = new HashSet<String>(1);
                for (SpectrumMatch spectrumMatch : idFileSpectrumMatches) {
                    HashSet<String> hashSet = this.loadedSpectraMap.get(spectrumMatch.getSpectrumFile());
                    if (hashSet == null) {
                        this.waitingHandler.appendReport("Spectrum file named '" + spectrumMatch.getSpectrumFile() + "' required to parse '" + IoUtil.getFileName(idFile) + "' not found.", true, true);
                        this.waitingHandler.setRunCanceled();
                        return;
                    }
                    importedFileNames.add(spectrumMatch.getSpectrumFile());
                    String spectrumTitle = spectrumMatch.getSpectrumTitle();
                    if (!hashSet.contains(spectrumTitle)) {
                        this.waitingHandler.appendReport("Spectrum with title '" + spectrumTitle + "' in file named '" + spectrumMatch.getSpectrumFile() + "' required to parse '" + IoUtil.getFileName(idFile) + "' not found.", true, true);
                        this.waitingHandler.setRunCanceled();
                        return;
                    }
                    this.waitingHandler.increaseSecondaryProgressCounter();
                }
                for (String string : importedFileNames) {
                    this.projectDetails.addSpectrumFilePath(this.spectrumProvider.getFilePaths().get(string));
                    this.identification.addFraction(string);
                }
                if (fileReader.hasDeNovoTags()) {
                    this.waitingHandler.resetSecondaryProgressCounter();
                    this.waitingHandler.setMaxSecondaryProgressCounter(nMatches);
                    this.waitingHandler.appendReport("Mapping tags to peptides.", true, true);
                    this.tagMapper.mapTags(idFileSpectrumMatches, this.fastaMapper, this.waitingHandler);
                }
                this.waitingHandler.setMaxSecondaryProgressCounter(2 * nMatches);
                this.waitingHandler.appendReport("Importing PSMs from " + idFile.getName(), true, true);
                PsmImporter psmImporter = new PsmImporter();
                psmImporter.importPsms(idFileSpectrumMatches, this.identification, this.identificationParameters, this.inputMap, fileReader, this.sequenceProvider, this.spectrumProvider, this.fastaMapper, this.processingParameters, this.waitingHandler, this.exceptionHandler);
                if (this.waitingHandler.isRunCanceled()) {
                    return;
                }
                for (Map.Entry<String, Integer> entry : psmImporter.getProteinCount().entrySet()) {
                    String accession = entry.getKey();
                    int fileCount = entry.getValue();
                    Integer count = this.proteinCount.get(accession);
                    if (count != null) {
                        this.proteinCount.put(accession, count + fileCount);
                        continue;
                    }
                    this.proteinCount.put(accession, fileCount);
                }
                this.nPSMs += psmImporter.getnPSMs();
                this.nTotal += psmImporter.getnPeptideAssumptionsTotal();
                this.nRetained += (long)psmImporter.getnRetained();
                this.metrics.addFoundCharges(psmImporter.getCharges());
                if (psmImporter.getMaxPeptideErrorDa() > this.metrics.getMaxPeptidePrecursorErrorDa()) {
                    this.metrics.setMaxPeptidePrecursorErrorDa(psmImporter.getMaxPeptideErrorDa());
                }
                if (psmImporter.getMaxPeptideErrorPpm() > this.metrics.getMaxPeptidePrecursorErrorPpm()) {
                    this.metrics.setMaxPeptidePrecursorErrorPpm(psmImporter.getMaxPeptideErrorPpm());
                }
                if (psmImporter.getMaxTagErrorDa() > this.metrics.getMaxTagPrecursorErrorDa()) {
                    this.metrics.setMaxTagPrecursorErrorDa(psmImporter.getMaxTagErrorDa());
                }
                if (psmImporter.getMaxTagErrorPpm() > this.metrics.getMaxTagPrecursorErrorPpm()) {
                    this.metrics.setMaxTagPrecursorErrorPpm(psmImporter.getMaxTagErrorPpm());
                }
                this.projectDetails.addIdentificationFiles(idFile);
                int n = psmImporter.getPsmsRejected();
                int n2 = psmImporter.getMissingProteins();
                int proteinIssue = psmImporter.getProteinIssue();
                int peptideIssue = psmImporter.getPeptideIssue();
                int precursorIssue = psmImporter.getPrecursorIssue();
                int ptmIssue = psmImporter.getModificationIssue();
                int totalAssumptionsRejected = n2 + proteinIssue + peptideIssue + precursorIssue + ptmIssue;
                double sharePsmsRejected = 100.0 * (double)n / (double)nMatches;
                if (n > 0) {
                    this.waitingHandler.appendReport(n + " identified spectra (" + Util.roundDouble(sharePsmsRejected, 1) + "%) did not present a valid peptide.", true, true);
                    this.waitingHandler.appendReport(totalAssumptionsRejected + " of the best scoring peptides were excluded by the import filters:", true, true);
                    String padding = "    ";
                    PeptideAssumptionFilter idFilter = this.identificationParameters.getPeptideAssumptionFilter();
                    double share = 100.0 * (double)n2 / (double)totalAssumptionsRejected;
                    if (share >= 1.0) {
                        this.waitingHandler.appendReport(padding + "- " + Util.roundDouble(share, 1) + "% peptide not matching to the database.", true, true);
                    }
                    if ((share = 100.0 * (double)proteinIssue / (double)totalAssumptionsRejected) >= 1.0) {
                        this.waitingHandler.appendReport(padding + "- " + Util.roundDouble(share, 1) + "% peptide mapping to both target and decoy.", true, true);
                    }
                    if ((share = 100.0 * (double)peptideIssue / (double)totalAssumptionsRejected) >= 1.0) {
                        if (this.identificationParameters.getPeptideAssumptionFilter().getMinMissedCleavages() != null || this.identificationParameters.getPeptideAssumptionFilter().getMaxMissedCleavages() != null) {
                            Integer minMissedCleavages = idFilter.getMinMissedCleavages();
                            Integer maxMissedCleavages = idFilter.getMaxMissedCleavages();
                            if (minMissedCleavages == null) {
                                minMissedCleavages = 0;
                            }
                            if (maxMissedCleavages != null) {
                                this.waitingHandler.appendReport(padding + "- " + Util.roundDouble(share, 1) + "% peptide length less than " + idFilter.getMinPepLength() + " or greater than " + idFilter.getMaxPepLength() + ",", true, true);
                                this.waitingHandler.appendReport(padding + "    or number of missed cleavage sites outside of the range [" + minMissedCleavages + "-" + maxMissedCleavages + "].", true, true);
                            } else {
                                this.waitingHandler.appendReport(padding + "- " + Util.roundDouble(share, 1) + "% peptide length less than " + idFilter.getMinPepLength() + " or greater than " + idFilter.getMaxPepLength() + ",", true, true);
                                this.waitingHandler.appendReport(padding + "    or number of missed cleavage sites lower than " + minMissedCleavages + ".", true, true);
                            }
                        } else {
                            this.waitingHandler.appendReport(padding + "- " + Util.roundDouble(share, 1) + "% peptide length less than " + idFilter.getMinPepLength() + " or greater than " + idFilter.getMaxPepLength() + ".", true, true);
                        }
                    }
                    if ((share = 100.0 * (double)precursorIssue / (double)totalAssumptionsRejected) >= 1.0) {
                        this.waitingHandler.appendReport(padding + "- " + Util.roundDouble(share, 1) + "% peptide presenting high mass or isotopic deviation.", true, true);
                    }
                    if ((share = 100.0 * (double)ptmIssue / (double)totalAssumptionsRejected) >= 1.0) {
                        this.waitingHandler.appendReport(padding + "- " + Util.roundDouble(share, 1) + "% unrecognized modifications.", true, true);
                    }
                }
                boolean allSearchEngines = true;
                for (String advocateName : software.keySet()) {
                    Advocate advocate = Advocate.getAdvocate(advocateName);
                    if (advocate.getType() == Advocate.AdvocateType.search_engine) continue;
                    allSearchEngines = false;
                    break;
                }
                if (allSearchEngines && n2 > 0) {
                    report = "Some peptides could not be mapped to the database. Please verify the following:" + System.getProperty("line.separator");
                    if (software.keySet().contains(Advocate.mascot.getName())) {
                        report = report + "- Make sure that Mascot was not used using the 'decoy' option.";
                    }
                    report = report + "- The protein sequence database must be the same or contain the database used for the search." + System.getProperty("line.separator") + "- When using the 'REVERSED' tag, decoy sequences must be reversed versions of the target sequences, use the 'DECOY' tag otherwise." + System.getProperty("line.separator") + "- When using in house databases make sure that the format is recognized by search engines and PeptideShaker (more details at https://compomics.github.io/projects/searchgui/wiki/DatabaseHelp.html)." + System.getProperty("line.separator") + "The problematic spectra can be inspected in the Spectrum ID tab. In case of doubt please contact the developers.";
                    this.waitingHandler.appendReport(report, true, true);
                }
                if (sharePsmsRejected > 75.0) {
                    report = "Warning: More than 75% of the PSMs did not pass the import filters." + System.getProperty("line.separator");
                    double meanRejected = sharePsmsRejected / 4.0;
                    if (!allSearchEngines && (double)n2 > meanRejected) {
                        report = report + " PeptideShaker did not manage to map most peptides to the database. Please verify your database." + System.getProperty("line.separator");
                    }
                    if ((double)proteinIssue > meanRejected) {
                        report = report + " Apparently your database contains a high degree of shared peptides between the target and decoy sequences. Please verify your database";
                        if (software.keySet().contains(Advocate.mascot.getName())) {
                            report = report + " and make sure that you use Mascot with the 'decoy' option disabled.";
                        }
                        report = report + "." + System.getProperty("line.separator");
                    }
                    if ((double)peptideIssue > meanRejected) {
                        report = report + " Please verify that your peptide selection criteria are not too restrictive." + System.getProperty("line.separator");
                    }
                    if ((double)precursorIssue > meanRejected) {
                        report = report + " Please verify that your precursor selection criteria are not too restrictive." + System.getProperty("line.separator");
                    }
                    if ((double)ptmIssue > meanRejected) {
                        report = report + " Apparently your data contains modifications which are not recognized by PeptideShaker. Please verify the search parameters provided when creating the project." + System.getProperty("line.separator");
                        if (software.keySet().contains(Advocate.mascot.getName())) {
                            report = report + " When using Mascot alone, you need to specify the search parameters manually when creating the project. We recommend the complementary use of SearchGUI when possible." + System.getProperty("line.separator");
                        }
                    }
                    this.waitingHandler.appendReport(report, true, true);
                }
            }
        }
        this.waitingHandler.increasePrimaryProgressCounter();
    }

    public void importSequences(SequenceMatchingParameters sequenceMatchingParameters, SearchParameters searchParameters, FastaParameters fastaParameters, PeptideVariantsParameters peptideVariantsParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) throws IOException {
        String fastaFilePath = this.projectDetails.getFastaFile();
        File fastaFile = new File(fastaFilePath);
        waitingHandler.appendReport("Importing sequences from " + fastaFile.getName() + ".", true, true);
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        this.fastaSummary = FastaSummary.getSummary(fastaFilePath, fastaParameters, waitingHandler);
        FMIndex fmIndex = new FMIndex(fastaFile, fastaParameters, waitingHandler, true, peptideVariantsParameters, searchParameters);
        this.sequenceProvider = fmIndex;
        this.fastaMapper = fmIndex;
        this.proteinDetailsProvider = fmIndex;
    }

    public void importGenes() {
        ProteinGeneDetailsProvider geneFactory = new ProteinGeneDetailsProvider();
        try {
            geneFactory.initialize(PeptideShaker.getConfigFolder());
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "An error occurred while loading the gene mappings.", "Gene Mapping File Error", 0);
        }
        GeneParameters geneParameters = this.identificationParameters.getGeneParameters();
        this.geneMaps = geneFactory.getGeneMaps(geneParameters, this.fastaSummary, this.sequenceProvider, this.proteinDetailsProvider, this.waitingHandler);
    }

    public GeneMaps getGeneMaps() {
        return this.geneMaps;
    }

    public SequenceProvider getSequenceProvider() {
        return this.sequenceProvider;
    }

    public ProteinDetailsProvider getProteinDetailsProvider() {
        return this.proteinDetailsProvider;
    }

    public FastaMapper getFastaMapper() {
        return this.fastaMapper;
    }

    public InputMap getInputMap() {
        return this.inputMap;
    }

    public HashMap<String, Integer> getProteinCount() {
        return this.proteinCount;
    }
}

