/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.followup;

import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.io.flat.SimpleFileWriter;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.pride.CvTerm;
import com.compomics.util.threading.SimpleSemaphore;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.utils.Ms2PipUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.stream.Stream;

public class Ms2PipExport {
    public static ArrayList<File> ms2pipExport(File peprecFile, String[] models, Identification identification, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingParameters, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, WaitingHandler waitingHandler) {
        File destinationFolder = peprecFile.getParentFile();
        waitingHandler.resetSecondaryProgressCounter();
        waitingHandler.setMaxSecondaryProgressCounter(identification.getSpectrumIdentificationSize());
        Ms2PipExport.ms2pipExport(peprecFile, identification, searchParameters.getModificationParameters(), sequenceMatchingParameters, sequenceProvider, spectrumProvider, waitingHandler);
        ArrayList<File> configFiles = new ArrayList<File>(models.length);
        for (String model : models) {
            File configFile = models.length == 1 ? new File(destinationFolder, "config.txt") : new File(destinationFolder, model + "_config.txt");
            Ms2PipExport.writeConfigFile(configFile, model, searchParameters);
        }
        configFiles.add(peprecFile);
        return configFiles;
    }

    public static void writeConfigFile(File configFile, String model, SearchParameters searchParameters) {
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        try (SimpleFileWriter writer = new SimpleFileWriter(configFile, false);){
            writer.writeLine("model=" + model);
            writer.writeLine("out=csv");
            writer.writeLine("frag_error=" + searchParameters.getFragmentIonAccuracyInDaltons());
            block10: for (String modName : searchParameters.getModificationParameters().getAllModifications()) {
                Modification modification = modificationFactory.getModification(modName);
                CvTerm cvTerm = modification.getUnimodCvTerm();
                if (cvTerm == null) {
                    throw new IllegalArgumentException("No Unimod id found for modification " + modName + ".");
                }
                String unimodName = cvTerm.getName();
                double mass = modification.getMass();
                ModificationType modificationType = modification.getModificationType();
                switch (modificationType) {
                    case modaa: 
                    case modcaa_peptide: 
                    case modcaa_protein: 
                    case modnaa_peptide: 
                    case modnaa_protein: {
                        for (Character targetAa : modification.getPattern().getAminoAcidsAtTarget()) {
                            writer.writeLine(String.join((CharSequence)"", "ptm=", unimodName, "," + Double.toString(mass), ",opt,", targetAa.toString()));
                        }
                        continue block10;
                    }
                    case modn_peptide: 
                    case modn_protein: {
                        writer.writeLine(String.join((CharSequence)"", "ptm=", unimodName, "," + Double.toString(mass), ",opt,N-term"));
                        break;
                    }
                    case modc_peptide: 
                    case modc_protein: {
                        writer.writeLine(String.join((CharSequence)"", "ptm=", unimodName, "," + Double.toString(mass), ",opt,C-term"));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Modification type " + (Object)((Object)modificationType) + " not supported.");
                    }
                }
            }
        }
    }

    public static void ms2pipExport(File peprecFile, Identification identification, ModificationParameters modificationParameters, SequenceMatchingParameters sequenceMatchingParameters, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, WaitingHandler waitingHandler) {
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        try (SimpleFileWriter writer = new SimpleFileWriter(peprecFile, true);){
            SpectrumMatch spectrumMatch;
            writer.writeLine("spec_id modifications peptide charge");
            SpectrumMatchesIterator spectrumMatchesIterator = identification.getSpectrumMatchesIterator(waitingHandler);
            HashSet processedPeptideKeys = new HashSet();
            SimpleSemaphore writingSemaphore = new SimpleSemaphore(1);
            while ((spectrumMatch = spectrumMatchesIterator.next()) != null) {
                if (waitingHandler != null) {
                    waitingHandler.increaseSecondaryProgressCounter();
                    if (waitingHandler.isRunCanceled()) {
                        return;
                    }
                }
                ((Stream)spectrumMatch.getAllPeptideAssumptions().parallel()).forEach(peptideAssumption -> Ms2PipExport.writePeptideCandidate(peptideAssumption, modificationParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory, processedPeptideKeys, writingSemaphore, writer));
            }
        }
    }

    private static void writePeptideCandidate(PeptideAssumption peptideAssumption, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters, ModificationFactory modificationFactory, HashSet<Long> processedPeptides, SimpleSemaphore writingSemaphore, SimpleFileWriter writer) {
        String peptideData = Ms2PipUtils.getPeptideData(peptideAssumption, modificationParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory);
        long peptideKey = Ms2PipUtils.getPeptideKey(peptideData);
        writingSemaphore.acquire();
        if (!processedPeptides.contains(peptideKey)) {
            String line = String.join((CharSequence)" ", Long.toString(peptideKey), peptideData);
            writer.writeLine(line);
            processedPeptides.add(peptideKey);
        }
        writingSemaphore.release();
    }
}

