/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.followup;

import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches_iterators.ProteinMatchesIterator;
import com.compomics.util.io.flat.SimpleFileWriter;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class ProteoformExport {
    public static void writeProteoforms(File destinationFile, Identification identification, WaitingHandler waitingHandler) {
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        if (waitingHandler != null) {
            waitingHandler.setWaitingText("Exporting Proteoforms. Please Wait...");
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(identification.getProteinIdentification().size());
        }
        ProteinMatchesIterator proteinMatchesIterator = identification.getProteinMatchesIterator(waitingHandler);
        try (SimpleFileWriter simpleFileWriter = new SimpleFileWriter(destinationFile, false);){
            ProteinMatch proteinMatch;
            while ((proteinMatch = proteinMatchesIterator.next()) != null) {
                if (!proteinMatch.isDecoy()) {
                    for (String accession : proteinMatch.getAccessions()) {
                        boolean unmodified = false;
                        TreeSet<String> modifications = new TreeSet<String>();
                        for (long peptideKey : proteinMatch.getPeptideMatchesKeys()) {
                            PeptideMatch peptideMatch = identification.getPeptideMatch(peptideKey);
                            Peptide peptide = peptideMatch.getPeptide();
                            ModificationMatch[] modificationMatches = peptide.getVariableModifications();
                            if (modificationMatches.length > 0) {
                                int[] peptideStarts;
                                for (int peptideStart : peptideStarts = peptide.getProteinMapping().get(accession)) {
                                    TreeMap<Integer, String> modMap = new TreeMap<Integer, String>();
                                    for (ModificationMatch modificationMatch : modificationMatches) {
                                        String modAccession;
                                        String modName = modificationMatch.getModification();
                                        Modification modification = modificationFactory.getModification(modName);
                                        if (modification.getPsiModCvTerm() != null) {
                                            modAccession = modification.getPsiModCvTerm().getAccession();
                                            modAccession = modAccession.substring(modAccession.indexOf(58) + 1);
                                        } else {
                                            modAccession = modification.getUnimodCvTerm() != null ? modification.getUnimodCvTerm().getAccession() : modName;
                                        }
                                        int site = modificationMatch.getSite();
                                        if (site == 0) {
                                            site = 1;
                                        } else if (site == peptide.getSequence().length() + 1) {
                                            site = peptide.getSequence().length();
                                        }
                                        int siteOnProtein = peptideStart + site;
                                        modMap.put(siteOnProtein, modAccession);
                                    }
                                    String proteoformMods = modMap.entrySet().stream().map(entry -> String.join((CharSequence)":", (CharSequence)entry.getValue(), Integer.toString((Integer)entry.getKey()))).collect(Collectors.joining(","));
                                    modifications.add(proteoformMods);
                                }
                                continue;
                            }
                            unmodified = true;
                        }
                        if (unmodified) {
                            simpleFileWriter.writeLine(accession);
                        }
                        Object object = modifications.iterator();
                        while (object.hasNext()) {
                            String modification = (String)object.next();
                            simpleFileWriter.writeLine(String.join((CharSequence)";", accession, modification));
                        }
                    }
                }
                if (waitingHandler == null) continue;
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                waitingHandler.increaseSecondaryProgressCounter();
            }
        }
    }
}

