/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui;

import com.compomics.util.io.IoUtil;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import no.uib.jsparklines.data.XYDataPoint;

public class FractionDetailsDialog
extends JDialog {
    private final PeptideShakerGUI peptideShakerGUI;
    private ArrayList<String> tableToolTips;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JLabel disclaimerLabel;
    private JPanel disclamierPanel;
    private JScrollPane fractionJScrollPane;
    private JTable fractionTable;
    private JPanel fractionsPanel;
    private JLabel helpLabel;
    private JButton importFractionRangesButton;
    private JButton moveBottomButton;
    private JButton moveDownButton;
    private JButton moveTopButton;
    private JButton moveUpButton;
    private JButton okButton;
    private JPanel orderSettingsPanel;

    public FractionDetailsDialog(PeptideShakerGUI peptideShakerGUI, boolean modal) {
        super((Frame)peptideShakerGUI, modal);
        this.initComponents();
        this.peptideShakerGUI = peptideShakerGUI;
        this.setUpTable();
        this.addData();
        this.setLocationRelativeTo(peptideShakerGUI);
        this.setVisible(true);
    }

    private void addData() {
        ArrayList<String> fractions = this.peptideShakerGUI.getIdentification().getFractions();
        HashMap<String, XYDataPoint> expectedMolecularWeightRanges = this.peptideShakerGUI.getIdentificationParameters().getFractionParameters().getFractionMolecularWeightRanges();
        int lineNumber = 1;
        for (String fraction : fractions) {
            XYDataPoint dataPoint;
            Double lower = 0.0;
            Double upper = 0.0;
            if (expectedMolecularWeightRanges != null && (dataPoint = expectedMolecularWeightRanges.get(fraction)) != null) {
                lower = dataPoint.getX();
                upper = dataPoint.getY();
            }
            ((DefaultTableModel)this.fractionTable.getModel()).addRow(new Object[]{lineNumber++, IoUtil.getFileName(fraction), lower, upper});
        }
    }

    private void setUpTable() {
        this.fractionTable.getTableHeader().setReorderingAllowed(false);
        JPanel proteinCorner = new JPanel();
        proteinCorner.setBackground(this.fractionTable.getTableHeader().getBackground());
        this.fractionJScrollPane.setCorner("UPPER_RIGHT_CORNER", proteinCorner);
        this.fractionJScrollPane.getViewport().setOpaque(false);
        this.tableToolTips = new ArrayList();
        this.tableToolTips.add(null);
        this.tableToolTips.add("Fraction File");
        this.tableToolTips.add("Expected Lower Molecular Weight For Fraction (kDa)");
        this.tableToolTips.add("Expected Upper Molecular Weight For Fraction (kDa)");
        this.fractionTable.getColumn(" ").setMaxWidth(50);
        this.fractionTable.getColumn(" ").setMinWidth(50);
        this.fractionTable.getColumn("Lower Range (kDa)").setMaxWidth(120);
        this.fractionTable.getColumn("Lower Range (kDa)").setMinWidth(120);
        this.fractionTable.getColumn("Upper Range (kDa)").setMaxWidth(120);
        this.fractionTable.getColumn("Upper Range (kDa)").setMinWidth(120);
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.fractionsPanel = new JPanel();
        this.fractionJScrollPane = new JScrollPane();
        this.fractionTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)FractionDetailsDialog.this.tableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.orderSettingsPanel = new JPanel();
        this.moveUpButton = new JButton();
        this.moveTopButton = new JButton();
        this.moveDownButton = new JButton();
        this.moveBottomButton = new JButton();
        this.importFractionRangesButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.helpLabel = new JLabel();
        this.disclamierPanel = new JPanel();
        this.disclaimerLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Fraction Details");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.fractionsPanel.setBorder(BorderFactory.createTitledBorder("Fractions"));
        this.fractionsPanel.setOpaque(false);
        this.fractionTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Fraction", "Lower Range (kDa)", "Upper Range (kDa)"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, Double.class, Double.class};
                this.canEdit = new boolean[]{false, false, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.fractionTable.setSelectionMode(1);
        this.fractionTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                FractionDetailsDialog.this.fractionTableMouseReleased(evt);
            }
        });
        this.fractionTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FractionDetailsDialog.this.fractionTableKeyReleased(evt);
            }
        });
        this.fractionJScrollPane.setViewportView(this.fractionTable);
        this.orderSettingsPanel.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.orderSettingsPanel.setOpaque(false);
        this.moveUpButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/arrowUp_grey.png")));
        this.moveUpButton.setToolTipText("Move Up");
        this.moveUpButton.setBorderPainted(false);
        this.moveUpButton.setContentAreaFilled(false);
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/arrowUp.png")));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FractionDetailsDialog.this.moveUpButtonActionPerformed(evt);
            }
        });
        this.moveTopButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/arrowUpTop_grey.png")));
        this.moveTopButton.setToolTipText("Move to Top");
        this.moveTopButton.setBorderPainted(false);
        this.moveTopButton.setContentAreaFilled(false);
        this.moveTopButton.setEnabled(false);
        this.moveTopButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/arrowUpTop.png")));
        this.moveTopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FractionDetailsDialog.this.moveTopButtonActionPerformed(evt);
            }
        });
        this.moveDownButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/arrowDown_grey.png")));
        this.moveDownButton.setToolTipText("Move Down");
        this.moveDownButton.setBorderPainted(false);
        this.moveDownButton.setContentAreaFilled(false);
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/arrowDown.png")));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FractionDetailsDialog.this.moveDownButtonActionPerformed(evt);
            }
        });
        this.moveBottomButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/arrowDownBottom_grey.png")));
        this.moveBottomButton.setToolTipText("Move to Bottom");
        this.moveBottomButton.setBorderPainted(false);
        this.moveBottomButton.setContentAreaFilled(false);
        this.moveBottomButton.setEnabled(false);
        this.moveBottomButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/arrowDownBottom.png")));
        this.moveBottomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FractionDetailsDialog.this.moveBottomButtonActionPerformed(evt);
            }
        });
        GroupLayout orderSettingsPanelLayout = new GroupLayout(this.orderSettingsPanel);
        this.orderSettingsPanel.setLayout(orderSettingsPanelLayout);
        orderSettingsPanelLayout.setHorizontalGroup(orderSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, orderSettingsPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(orderSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.moveUpButton, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addComponent(this.moveDownButton, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addComponent(this.moveBottomButton, GroupLayout.Alignment.TRAILING, -2, 36, -2).addComponent(this.moveTopButton, -2, 36, -2))));
        orderSettingsPanelLayout.setVerticalGroup(orderSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, orderSettingsPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.moveTopButton, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveUpButton, -2, 20, -2).addGap(27, 27, 27).addComponent(this.moveDownButton, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveBottomButton).addContainerGap()));
        this.importFractionRangesButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/list2.gif")));
        this.importFractionRangesButton.setToolTipText("Import fraction ranges from file");
        this.importFractionRangesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FractionDetailsDialog.this.importFractionRangesButtonActionPerformed(evt);
            }
        });
        GroupLayout fractionsPanelLayout = new GroupLayout(this.fractionsPanel);
        this.fractionsPanel.setLayout(fractionsPanelLayout);
        fractionsPanelLayout.setHorizontalGroup(fractionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fractionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fractionJScrollPane, -1, 656, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(fractionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.orderSettingsPanel, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.importFractionRangesButton, GroupLayout.Alignment.TRAILING, -2, 36, -2)).addContainerGap()));
        fractionsPanelLayout.setVerticalGroup(fractionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fractionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(fractionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fractionsPanelLayout.createSequentialGroup().addComponent(this.orderSettingsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.importFractionRangesButton)).addComponent(this.fractionJScrollPane, -1, 389, Short.MAX_VALUE)).addContainerGap()));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FractionDetailsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FractionDetailsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.helpLabel.setFont(this.helpLabel.getFont().deriveFont(this.helpLabel.getFont().getStyle() | 2));
        this.helpLabel.setText("Choose the order in which you want to display the fractions.");
        this.disclamierPanel.setBorder(BorderFactory.createTitledBorder("Disclaimer"));
        this.disclamierPanel.setOpaque(false);
        this.disclaimerLabel.setText("<html>\nThe fraction data is based on estimations of the confidence of a peptide/protein if found in a fraction alone in the context of the whole<br>\nanalysis. <i>These are <u><b>not</b></u> equal to the confidence in the peptide/protein identifications when processing the fractions independently!</i><br><br>\nIndependant fractions (like different donors, measurements) or replicates <u><b>should be processed separately</b></u>.<br>\n</html>");
        GroupLayout disclamierPanelLayout = new GroupLayout(this.disclamierPanel);
        this.disclamierPanel.setLayout(disclamierPanelLayout);
        disclamierPanelLayout.setHorizontalGroup(disclamierPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(disclamierPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.disclaimerLabel).addContainerGap()));
        disclamierPanelLayout.setVerticalGroup(disclamierPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(disclamierPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.disclaimerLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fractionsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.disclamierPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fractionsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disclamierPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.helpLabel)).addGap(4, 4, 4)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void moveTopButtonActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.fractionTable.getSelectedRows();
        if (selectedRows.length > 0 && selectedRows[0] > 0) {
            DefaultTableModel model = (DefaultTableModel)this.fractionTable.getModel();
            model.moveRow(selectedRows[0], selectedRows[selectedRows.length - 1], 0);
            this.fractionTable.setRowSelectionInterval(0, selectedRows.length - 1);
            this.resetTableIndexes();
            this.fractionTableMouseReleased(null);
        }
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.fractionTable.getSelectedRows();
        if (selectedRows.length > 0 && selectedRows[0] > 0) {
            DefaultTableModel model = (DefaultTableModel)this.fractionTable.getModel();
            model.moveRow(selectedRows[0], selectedRows[selectedRows.length - 1], selectedRows[0] - 1);
            this.fractionTable.setRowSelectionInterval(selectedRows[0] - 1, selectedRows[0] - 1 + selectedRows.length - 1);
            this.resetTableIndexes();
            this.fractionTableMouseReleased(null);
        }
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.fractionTable.getSelectedRows();
        if (selectedRows.length > 0 && selectedRows[selectedRows.length - 1] < this.fractionTable.getRowCount() - 1) {
            DefaultTableModel model = (DefaultTableModel)this.fractionTable.getModel();
            model.moveRow(selectedRows[0], selectedRows[selectedRows.length - 1], selectedRows[0] + 1);
            this.fractionTable.setRowSelectionInterval(selectedRows[0] + 1, selectedRows[0] + selectedRows.length);
            this.resetTableIndexes();
            this.fractionTableMouseReleased(null);
        }
    }

    private void moveBottomButtonActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.fractionTable.getSelectedRows();
        if (selectedRows.length > 0 && selectedRows[selectedRows.length - 1] < this.fractionTable.getRowCount() - 1) {
            DefaultTableModel model = (DefaultTableModel)this.fractionTable.getModel();
            model.moveRow(selectedRows[0], selectedRows[selectedRows.length - 1], this.fractionTable.getRowCount() - selectedRows.length);
            this.fractionTable.setRowSelectionInterval(this.fractionTable.getRowCount() - selectedRows.length, this.fractionTable.getRowCount() - 1);
            this.resetTableIndexes();
            this.fractionTableMouseReleased(null);
        }
    }

    private void fractionTableKeyReleased(KeyEvent evt) {
        this.fractionTableMouseReleased(null);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        ArrayList<String> spectrumFiles = new ArrayList<String>();
        HashMap<String, XYDataPoint> fractionRanges = new HashMap<String, XYDataPoint>();
        for (int i = 0; i < this.fractionTable.getRowCount(); ++i) {
            String fileName = (String)this.fractionTable.getValueAt(i, this.fractionTable.getColumn("Fraction").getModelIndex());
            spectrumFiles.add(IoUtil.removeExtension(fileName));
            Double lower = (Double)this.fractionTable.getValueAt(i, this.fractionTable.getColumn("Lower Range (kDa)").getModelIndex());
            Double upper = (Double)this.fractionTable.getValueAt(i, this.fractionTable.getColumn("Upper Range (kDa)").getModelIndex());
            fractionRanges.put(fileName, new XYDataPoint(lower.doubleValue(), upper.doubleValue()));
        }
        this.peptideShakerGUI.setUpdated(2, false);
        if (this.peptideShakerGUI.getSelectedTab() == 2) {
            this.peptideShakerGUI.getProteinFractionsPanel().displayResults();
        }
        this.peptideShakerGUI.getIdentification().setFractions(spectrumFiles);
        this.peptideShakerGUI.getIdentificationParameters().getFractionParameters().setFractionMolecularWeightRanges(fractionRanges);
        this.setVisible(false);
        this.dispose();
    }

    private void fractionTableMouseReleased(MouseEvent evt) {
        int[] selectedRows = this.fractionTable.getSelectedRows();
        if (selectedRows.length > 0) {
            this.moveUpButton.setEnabled(selectedRows[0] > 0);
            this.moveTopButton.setEnabled(selectedRows[0] > 0);
            this.moveDownButton.setEnabled(selectedRows[selectedRows.length - 1] < this.fractionTable.getRowCount() - 1);
            this.moveBottomButton.setEnabled(selectedRows[selectedRows.length - 1] < this.fractionTable.getRowCount() - 1);
        } else {
            this.moveUpButton.setEnabled(false);
            this.moveTopButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
            this.moveBottomButton.setEnabled(false);
        }
    }

    private void importFractionRangesButtonActionPerformed(ActionEvent evt) {
        File selectedFile = this.peptideShakerGUI.getUserSelectedFile(null, ".txt", "Tab separated text file (.txt)", "Import...", true);
        if (selectedFile != null) {
            ArrayList<XYDataPoint> lowerAndUpper = new ArrayList<XYDataPoint>();
            try {
                FileReader r = new FileReader(selectedFile);
                BufferedReader br = new BufferedReader(r);
                String line = br.readLine();
                while (line != null) {
                    String[] values = line.split("\\t");
                    lowerAndUpper.add(new XYDataPoint(Double.valueOf(values[0]).doubleValue(), Double.valueOf(values[1]).doubleValue()));
                    line = br.readLine();
                }
                br.close();
                r.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Could not find the file '" + selectedFile.getAbsolutePath() + "'.", "File Not Found", 2);
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "An error occurred when parsing the file '" + selectedFile.getAbsolutePath() + "'.", "File Error", 0);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "One of the values in the file is not a number.\nPlease include tab separated values only.", "File Error", 2);
            }
            if (lowerAndUpper.size() > this.fractionTable.getRowCount()) {
                JOptionPane.showMessageDialog(this, "There are more values in the file than there are rows in the table!\nSome rows will be ignored.", "File Error", 2);
            }
            for (int i = 0; i < lowerAndUpper.size(); ++i) {
                ((DefaultTableModel)this.fractionTable.getModel()).setValueAt(((XYDataPoint)lowerAndUpper.get(i)).getX(), i, 2);
                ((DefaultTableModel)this.fractionTable.getModel()).setValueAt(((XYDataPoint)lowerAndUpper.get(i)).getY(), i, 3);
            }
        }
    }

    private void resetTableIndexes() {
        for (int i = 0; i < this.fractionTable.getRowCount(); ++i) {
            this.fractionTable.setValueAt(i + 1, i, 0);
        }
    }

    public static void moveRows(DefaultTableModel model, int start, int end, int destination) {
        int count = end - start;
        if (count <= 0) {
            return;
        }
        if (destination > start) {
            destination = Math.max(start, destination - count);
        }
        model.moveRow(start, --end, destination);
    }
}

