/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui;

import com.compomics.util.Util;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.ValidationQcParameters;
import eu.isas.peptideshaker.scoring.targetdecoy.TargetDecoyMap;
import eu.isas.peptideshaker.scoring.targetdecoy.TargetDecoyResults;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.TrueFalseIconRenderer;

public class MatchValidationDialog
extends JDialog {
    private PSParameter psParameter;
    private boolean validationChanged = false;
    private MatchType type;
    private static final Color GREEN = new Color(0, 125, 0);
    private static final Color ORANGE = new Color(220, 110, 0);
    private final IdentificationParameters identificationParameters;
    private ArrayList<String> validationTableToolTips;
    private String fastaFile;
    private JPanel backgroundPanel;
    private JLabel bitLabel1;
    private JLabel bitRecommendationLabel1;
    private JLabel bitRecommendationLabel3;
    private JLabel bitRecommendationLabel4;
    private JButton cancelButton;
    private JLabel confidenceLbl;
    private JLabel confidenceResolutionLbl;
    private JLabel confidenceThresholdLbl;
    private JPanel databaseSearchPanel;
    private JLabel editLbl;
    private JLabel matchesBeforeFirstDecoyLbl;
    private JLabel nTargetLbl;
    private JButton okButton;
    private JPanel qualityFiltersPanel;
    private JTable qualityFiltersTable;
    private JScrollPane qualityFiltersTableScrollPane;
    private JLabel recommendedNumberOfTargetHitsLbl;
    private JLabel recommendedResolutionLbl;
    private JPanel targetDecoyGroupPanel;
    private JLabel targetDecoyLbl;
    private JPanel targetDecoyPanel;
    private JComboBox validationLevelJComboBox;
    private JPanel validationLevelPanel;
    private JLabel validationStatusLbl;
    private JLabel validationThresholdLbl;
    private JLabel validationTypeLabel;

    public MatchValidationDialog(Frame parent, Identification identification, TargetDecoyMap targetDecoyMap, long matchKey, IdentificationParameters identificationParameters, String fastaFile, MatchType matchType) {
        super(parent, true);
        this.initComponents();
        this.setUpGui();
        this.identificationParameters = identificationParameters;
        this.fastaFile = fastaFile;
        this.type = matchType;
        switch (this.type.ordinal()) {
            case 0: {
                ProteinMatch proteinMatch = identification.getProteinMatch(matchKey);
                this.psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
                this.setTitle("Protein Group Validation Quality");
                break;
            }
            case 1: {
                PeptideMatch peptideMatch = identification.getPeptideMatch(matchKey);
                this.psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                this.setTitle("Peptide Validation Quality");
                break;
            }
            case 2: {
                SpectrumMatch spectrumMatch = identification.getSpectrumMatch(matchKey);
                this.psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
                this.setTitle("PSM Validation Quality");
            }
        }
        this.populateGUI(targetDecoyMap);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.qualityFiltersTableScrollPane.getViewport().setOpaque(false);
        this.qualityFiltersTable.getTableHeader().setReorderingAllowed(false);
        this.validationLevelJComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.validationLevelJComboBox.setEditable(false);
        this.validationTableToolTips = new ArrayList(3);
        this.validationTableToolTips.add(null);
        this.validationTableToolTips.add("Quality Test");
        this.validationTableToolTips.add("Passed");
    }

    private void populateGUI(TargetDecoyMap targetDecoyMap) {
        ValidationQcParameters validationQCPreferences = this.identificationParameters.getIdValidationParameters().getValidationQCParameters();
        this.validationLevelJComboBox.setSelectedItem(this.psParameter.getMatchValidationLevel().getName());
        FastaParameters fastaParameters = this.identificationParameters.getFastaParameters();
        boolean targetDecoy = fastaParameters.isTargetDecoy();
        if (!targetDecoy) {
            this.targetDecoyLbl.setText("Target only");
            this.targetDecoyLbl.setForeground(Color.red);
        } else {
            this.targetDecoyLbl.setForeground(GREEN);
        }
        try {
            FastaSummary fastaSummary = FastaSummary.getSummary(this.fastaFile, fastaParameters, null);
            int nTarget = fastaSummary.nTarget;
            this.nTargetLbl.setText(nTarget + " target sequences");
            if (nTarget < 10000) {
                this.nTargetLbl.setForeground(Color.red);
            } else if (nTarget > 1000000) {
                this.nTargetLbl.setForeground(ORANGE);
            } else {
                this.nTargetLbl.setForeground(GREEN);
            }
        }
        catch (IOException iOException) {
            this.nTargetLbl.setText("Database size not available");
            this.nTargetLbl.setForeground(Color.red);
        }
        ((TitledBorder)this.targetDecoyGroupPanel.getBorder()).setTitle("Target/Decoy Distributions");
        this.targetDecoyGroupPanel.repaint();
        if (targetDecoy) {
            int nTargetOnly = targetDecoyMap.getnTargetOnly();
            this.matchesBeforeFirstDecoyLbl.setText(nTargetOnly + " matches before the first decoy hit");
            TargetDecoyResults targetDecoyResults = targetDecoyMap.getTargetDecoyResults();
            double desiredThreshold = targetDecoyResults.getUserInput();
            double nTargetLimit = 100.0 / desiredThreshold;
            if ((double)nTargetOnly < nTargetLimit) {
                this.matchesBeforeFirstDecoyLbl.setForeground(Color.red);
            } else {
                this.matchesBeforeFirstDecoyLbl.setForeground(GREEN);
            }
            this.recommendedNumberOfTargetHitsLbl.setText("Recommended: " + Util.roundDouble(nTargetLimit, 0) + " matches before the first decoy hit");
            double resolution = targetDecoyMap.getResolution();
            this.confidenceResolutionLbl.setText("PEP/Confidence resolution of " + Util.roundDouble(resolution, 2) + "%");
            double minResolution = desiredThreshold;
            if (resolution > 10.0 * minResolution) {
                this.confidenceResolutionLbl.setForeground(Color.red);
            } else if (resolution > minResolution) {
                this.confidenceResolutionLbl.setForeground(ORANGE);
            } else {
                this.confidenceResolutionLbl.setForeground(GREEN);
            }
            this.recommendedResolutionLbl.setText("Recommended: resolution < " + Util.roundDouble(minResolution, 2) + "%");
        } else {
            this.matchesBeforeFirstDecoyLbl.setText("No decoy");
            this.matchesBeforeFirstDecoyLbl.setForeground(Color.gray);
            this.confidenceResolutionLbl.setText("Impossible to estimate confidence resolution");
            this.confidenceResolutionLbl.setForeground(Color.gray);
        }
        if (targetDecoy) {
            double confidence = this.psParameter.getConfidence();
            MatchValidationLevel matchValidationLevel = this.psParameter.getMatchValidationLevel();
            this.validationStatusLbl.setText("Validation Status: " + matchValidationLevel.getName());
            switch (matchValidationLevel) {
                case confident: {
                    this.validationStatusLbl.setForeground(GREEN);
                    break;
                }
                case doubtful: {
                    this.validationStatusLbl.setForeground(ORANGE);
                    break;
                }
                case not_validated: {
                    this.validationStatusLbl.setForeground(Color.red);
                    break;
                }
                case none: {
                    this.validationStatusLbl.setForeground(Color.gray);
                }
            }
            TargetDecoyResults targetDecoyResults = targetDecoyMap.getTargetDecoyResults();
            String validationThresholdTxt = "";
            double threshold = targetDecoyResults.getUserInput();
            int thresholdType = targetDecoyResults.getInputType();
            if (thresholdType == 0) {
                validationThresholdTxt = validationThresholdTxt + "Validation Threshold: " + Util.roundDouble(threshold, 2) + "%";
            } else if (targetDecoyResults.getInputType() == 1) {
                validationThresholdTxt = validationThresholdTxt + "FDR Threshold: " + Util.roundDouble(threshold, 2) + "%";
            } else if (targetDecoyResults.getInputType() == 2) {
                validationThresholdTxt = validationThresholdTxt + "FNR Threshold: " + Util.roundDouble(threshold, 2) + "%";
            }
            this.validationThresholdLbl.setText(validationThresholdTxt);
            this.confidenceLbl.setText("Confidence: " + Util.roundDouble(confidence, 2) + "%");
            double validationThreshold = targetDecoyResults.getConfidenceLimit();
            this.confidenceThresholdLbl.setText("Expected Confidence: " + Util.roundDouble(validationThreshold, 2) + "%");
            double margin = validationQCPreferences.getConfidenceMargin() * targetDecoyMap.getResolution();
            double confidenceThreshold = validationThreshold + margin;
            if (confidenceThreshold > 100.0) {
                confidenceThreshold = 100.0;
            }
            this.confidenceThresholdLbl.setText("Confident confidence: " + Util.roundDouble(confidenceThreshold, 2) + "%");
            if (confidence < validationThreshold) {
                this.confidenceLbl.setForeground(Color.red);
            } else if (confidence < confidenceThreshold) {
                this.confidenceLbl.setForeground(ORANGE);
            } else {
                this.confidenceLbl.setForeground(GREEN);
            }
        } else {
            this.validationStatusLbl.setText("Validation Status: " + this.psParameter.getMatchValidationLevel().getName());
            this.validationThresholdLbl.setText("Impossible to estimate validation threshold");
            this.confidenceLbl.setText("Impossible to estimate confidence");
            this.confidenceThresholdLbl.setText("Impossible to estimate confidence threshold");
            this.validationStatusLbl.setForeground(Color.gray);
            this.confidenceLbl.setForeground(Color.gray);
        }
        FiltersTableModel tableModel = new FiltersTableModel();
        this.qualityFiltersTable.setModel(tableModel);
        this.qualityFiltersTable.getColumn("").setMaxWidth(50);
        this.qualityFiltersTable.getColumn(" ").setMaxWidth(50);
        this.qualityFiltersTable.getColumn(" ").setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/accept-new.png")), new ImageIcon(this.getClass().getResource("/icons/error-new.png")), "Yes", "No"));
        int valid = 0;
        for (String qcCheck : this.psParameter.getQcCriteria()) {
            if (!this.psParameter.isQcPassed(qcCheck).booleanValue()) continue;
            ++valid;
        }
        ((TitledBorder)this.qualityFiltersPanel.getBorder()).setTitle("Quality Filters (" + valid + "/" + this.psParameter.getQcCriteria().size() + ")");
    }

    public boolean isValidationChanged() {
        return this.validationChanged;
    }

    private void initComponents() {
        this.bitRecommendationLabel1 = new JLabel();
        this.bitLabel1 = new JLabel();
        this.backgroundPanel = new JPanel();
        this.validationLevelPanel = new JPanel();
        this.validationLevelJComboBox = new JComboBox();
        this.validationTypeLabel = new JLabel();
        this.databaseSearchPanel = new JPanel();
        this.bitRecommendationLabel3 = new JLabel();
        this.targetDecoyLbl = new JLabel();
        this.bitRecommendationLabel4 = new JLabel();
        this.nTargetLbl = new JLabel();
        this.targetDecoyGroupPanel = new JPanel();
        this.recommendedNumberOfTargetHitsLbl = new JLabel();
        this.matchesBeforeFirstDecoyLbl = new JLabel();
        this.recommendedResolutionLbl = new JLabel();
        this.confidenceResolutionLbl = new JLabel();
        this.targetDecoyPanel = new JPanel();
        this.validationThresholdLbl = new JLabel();
        this.confidenceLbl = new JLabel();
        this.confidenceThresholdLbl = new JLabel();
        this.validationStatusLbl = new JLabel();
        this.qualityFiltersPanel = new JPanel();
        this.qualityFiltersTableScrollPane = new JScrollPane();
        this.qualityFiltersTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)MatchValidationDialog.this.validationTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.editLbl = new JLabel();
        this.bitRecommendationLabel1.setFont(this.bitRecommendationLabel1.getFont().deriveFont(this.bitRecommendationLabel1.getFont().getStyle() | 2));
        this.bitRecommendationLabel1.setText("Recommended: Concatenated Target/Decoy");
        this.bitLabel1.setText("Concatenated Target/Decoy");
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(700, 600));
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.validationLevelPanel.setBorder(BorderFactory.createTitledBorder("Validation Level"));
        this.validationLevelPanel.setOpaque(false);
        this.validationLevelJComboBox.setModel(new DefaultComboBoxModel<String>(MatchValidationLevel.getValidationLevelsNames()));
        this.validationLevelJComboBox.setToolTipText("Validation Level");
        this.validationLevelJComboBox.setEnabled(false);
        this.validationTypeLabel.setText("Type");
        GroupLayout validationLevelPanelLayout = new GroupLayout(this.validationLevelPanel);
        this.validationLevelPanel.setLayout(validationLevelPanelLayout);
        validationLevelPanelLayout.setHorizontalGroup(validationLevelPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(validationLevelPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.validationTypeLabel).addGap(20, 20, 20).addComponent(this.validationLevelJComboBox, 0, -1, Short.MAX_VALUE).addContainerGap()));
        validationLevelPanelLayout.setVerticalGroup(validationLevelPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(validationLevelPanelLayout.createSequentialGroup().addContainerGap().addGroup(validationLevelPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.validationTypeLabel).addComponent(this.validationLevelJComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.databaseSearchPanel.setBorder(BorderFactory.createTitledBorder("Database Search"));
        this.databaseSearchPanel.setOpaque(false);
        this.bitRecommendationLabel3.setFont(this.bitRecommendationLabel3.getFont().deriveFont(this.bitRecommendationLabel3.getFont().getStyle() | 2));
        this.bitRecommendationLabel3.setText("Recommended: Concatenated Target/Decoy");
        this.targetDecoyLbl.setText("Concatenated Target/Decoy");
        this.bitRecommendationLabel4.setFont(this.bitRecommendationLabel4.getFont().deriveFont(this.bitRecommendationLabel4.getFont().getStyle() | 2));
        this.bitRecommendationLabel4.setText("Recommended: between 10 000 and 100 000");
        this.nTargetLbl.setText("xx,xxx target sequences");
        GroupLayout databaseSearchPanelLayout = new GroupLayout(this.databaseSearchPanel);
        this.databaseSearchPanel.setLayout(databaseSearchPanelLayout);
        databaseSearchPanelLayout.setHorizontalGroup(databaseSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(databaseSearchPanelLayout.createSequentialGroup().addContainerGap().addGroup(databaseSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(databaseSearchPanelLayout.createSequentialGroup().addComponent(this.targetDecoyLbl, -1, -1, Short.MAX_VALUE).addGap(266, 266, 266).addComponent(this.bitRecommendationLabel3)).addGroup(databaseSearchPanelLayout.createSequentialGroup().addComponent(this.nTargetLbl, -1, -1, Short.MAX_VALUE).addGap(266, 266, 266).addComponent(this.bitRecommendationLabel4))).addContainerGap()));
        databaseSearchPanelLayout.setVerticalGroup(databaseSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(databaseSearchPanelLayout.createSequentialGroup().addContainerGap().addGroup(databaseSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.targetDecoyLbl).addComponent(this.bitRecommendationLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(databaseSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nTargetLbl).addComponent(this.bitRecommendationLabel4)).addContainerGap(-1, Short.MAX_VALUE)));
        this.targetDecoyGroupPanel.setBorder(BorderFactory.createTitledBorder("Target/Decoy Group"));
        this.targetDecoyGroupPanel.setOpaque(false);
        this.recommendedNumberOfTargetHitsLbl.setFont(this.recommendedNumberOfTargetHitsLbl.getFont().deriveFont(this.recommendedNumberOfTargetHitsLbl.getFont().getStyle() | 2));
        this.recommendedNumberOfTargetHitsLbl.setText("Recommended: 100 matches before the first decoy hit");
        this.matchesBeforeFirstDecoyLbl.setText("xxx matches before the first decoy hit");
        this.recommendedResolutionLbl.setFont(this.recommendedResolutionLbl.getFont().deriveFont(this.recommendedResolutionLbl.getFont().getStyle() | 2));
        this.recommendedResolutionLbl.setText("Recommended: resolution < 1%");
        this.confidenceResolutionLbl.setText("PEP/Confidence resolution of x%");
        GroupLayout targetDecoyGroupPanelLayout = new GroupLayout(this.targetDecoyGroupPanel);
        this.targetDecoyGroupPanel.setLayout(targetDecoyGroupPanelLayout);
        targetDecoyGroupPanelLayout.setHorizontalGroup(targetDecoyGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(targetDecoyGroupPanelLayout.createSequentialGroup().addContainerGap().addGroup(targetDecoyGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(targetDecoyGroupPanelLayout.createSequentialGroup().addComponent(this.matchesBeforeFirstDecoyLbl, -1, 265, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 266, Short.MAX_VALUE).addComponent(this.recommendedNumberOfTargetHitsLbl)).addGroup(targetDecoyGroupPanelLayout.createSequentialGroup().addComponent(this.confidenceResolutionLbl, -1, -1, Short.MAX_VALUE).addGap(266, 266, 266).addComponent(this.recommendedResolutionLbl))).addContainerGap()));
        targetDecoyGroupPanelLayout.setVerticalGroup(targetDecoyGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(targetDecoyGroupPanelLayout.createSequentialGroup().addContainerGap().addGroup(targetDecoyGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.matchesBeforeFirstDecoyLbl).addComponent(this.recommendedNumberOfTargetHitsLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(targetDecoyGroupPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.confidenceResolutionLbl).addComponent(this.recommendedResolutionLbl)).addContainerGap(-1, Short.MAX_VALUE)));
        this.targetDecoyPanel.setBorder(BorderFactory.createTitledBorder("Target/Decoy Results"));
        this.targetDecoyPanel.setOpaque(false);
        this.validationThresholdLbl.setFont(this.validationThresholdLbl.getFont().deriveFont(this.validationThresholdLbl.getFont().getStyle() | 2));
        this.validationThresholdLbl.setText("Validation threshold: x%");
        this.confidenceLbl.setText("Confidence: x%");
        this.confidenceThresholdLbl.setFont(this.confidenceThresholdLbl.getFont().deriveFont(this.confidenceThresholdLbl.getFont().getStyle() | 2));
        this.confidenceThresholdLbl.setText("Confidence threshold: x%");
        this.validationStatusLbl.setText("Validation Status: Validated");
        GroupLayout targetDecoyPanelLayout = new GroupLayout(this.targetDecoyPanel);
        this.targetDecoyPanel.setLayout(targetDecoyPanelLayout);
        targetDecoyPanelLayout.setHorizontalGroup(targetDecoyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(targetDecoyPanelLayout.createSequentialGroup().addContainerGap().addGroup(targetDecoyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, targetDecoyPanelLayout.createSequentialGroup().addComponent(this.confidenceLbl, -1, 365, Short.MAX_VALUE).addGap(301, 301, 301).addComponent(this.confidenceThresholdLbl)).addGroup(GroupLayout.Alignment.TRAILING, targetDecoyPanelLayout.createSequentialGroup().addComponent(this.validationStatusLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.validationThresholdLbl))).addContainerGap()));
        targetDecoyPanelLayout.setVerticalGroup(targetDecoyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(targetDecoyPanelLayout.createSequentialGroup().addContainerGap().addGroup(targetDecoyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.validationThresholdLbl).addComponent(this.validationStatusLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 11, Short.MAX_VALUE).addGroup(targetDecoyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.confidenceThresholdLbl).addComponent(this.confidenceLbl)).addContainerGap()));
        this.qualityFiltersPanel.setBorder(BorderFactory.createTitledBorder("Quality Filters"));
        this.qualityFiltersPanel.setOpaque(false);
        this.qualityFiltersTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.qualityFiltersTableScrollPane.setViewportView(this.qualityFiltersTable);
        GroupLayout qualityFiltersPanelLayout = new GroupLayout(this.qualityFiltersPanel);
        this.qualityFiltersPanel.setLayout(qualityFiltersPanelLayout);
        qualityFiltersPanelLayout.setHorizontalGroup(qualityFiltersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, qualityFiltersPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.qualityFiltersTableScrollPane).addContainerGap()));
        qualityFiltersPanelLayout.setVerticalGroup(qualityFiltersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(qualityFiltersPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.qualityFiltersTableScrollPane, -1, 138, Short.MAX_VALUE).addContainerGap()));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MatchValidationDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MatchValidationDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.editLbl.setFont(new Font("Tahoma", 2, 11));
        this.editLbl.setText("Validation filters can be edited via Edit > Validation Filters.");
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.validationLevelPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.editLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.qualityFiltersPanel, -1, -1, Short.MAX_VALUE).addComponent(this.databaseSearchPanel, -1, -1, Short.MAX_VALUE).addComponent(this.targetDecoyGroupPanel, -1, -1, Short.MAX_VALUE).addComponent(this.targetDecoyPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.validationLevelPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.databaseSearchPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetDecoyGroupPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetDecoyPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.qualityFiltersPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.editLbl)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static enum MatchType {
        PROTEIN,
        PEPTIDE,
        PSM;

    }

    private class FiltersTableModel
    extends DefaultTableModel {
        private final ArrayList<String> qcCriteria;

        public FiltersTableModel() {
            this.qcCriteria = new ArrayList<String>(MatchValidationDialog.this.psParameter.getQcCriteria());
            Collections.sort(this.qcCriteria);
        }

        @Override
        public int getRowCount() {
            if (this.qcCriteria == null) {
                return 0;
            }
            return this.qcCriteria.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return " ";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return this.qcCriteria.get(row);
                }
                case 2: {
                    String criterion = this.qcCriteria.get(row);
                    return MatchValidationDialog.this.psParameter.isQcPassed(criterion);
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

