/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui;

import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class ModificationDialog
extends JDialog {
    private ArrayList<String> modifications;
    private boolean cancel = false;
    private JPanel backgroundPanel;
    private JButton cancelJButton;
    private JScrollPane jScrollPane2;
    private JList modificationList;
    private JScrollPane modificationsJScrollPane;
    private JButton okJButton;
    private JTextArea textArea;

    public ModificationDialog(Frame parent, boolean modal, Modification unknownPTM) {
        super(parent, modal);
        this.loadModifications();
        this.initComponents();
        this.modificationsJScrollPane.getViewport().setOpaque(false);
        this.textArea.setText("The modification " + unknownPTM.getName() + " (" + unknownPTM.getRoundedMass() + " Da) could not be identified, please select one from the following list to ensure search engine compatibility:");
        this.modificationList.setListData(this.modifications.toArray());
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.modificationsJScrollPane = new JScrollPane();
        this.modificationList = new JList();
        this.cancelJButton = new JButton();
        this.okJButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.textArea = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setTitle("Modification Mapping");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.backgroundPanel.setToolTipText("");
        this.modificationList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.modificationList.setSelectionMode(0);
        this.modificationsJScrollPane.setViewportView(this.modificationList);
        this.cancelJButton.setText("Cancel");
        this.cancelJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationDialog.this.cancelJButtonActionPerformed(evt);
            }
        });
        this.okJButton.setText("OK");
        this.okJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationDialog.this.okJButtonActionPerformed(evt);
            }
        });
        this.textArea.setBackground(new Color(254, 254, 254));
        this.textArea.setColumns(20);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setRows(2);
        this.textArea.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.textArea);
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.okJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelJButton)).addComponent(this.modificationsJScrollPane, GroupLayout.Alignment.LEADING, -1, 496, Short.MAX_VALUE).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 496, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelJButton, this.okJButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modificationsJScrollPane, -1, 316, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelJButton).addComponent(this.okJButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okJButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cancelJButtonActionPerformed(ActionEvent evt) {
        this.cancel = true;
        this.dispose();
    }

    private void loadModifications() {
        this.modifications = ModificationFactory.getInstance().getModifications().stream().sorted().collect(Collectors.toCollection(ArrayList::new));
    }

    public String getSelectedModification() {
        return (String)this.modificationList.getSelectedValue();
    }

    public boolean isCanceled() {
        return this.cancel;
    }
}

